import { ViewingDirection } from "@iiif/vocabulary/dist-commonjs";
import { Canvas } from ".";
declare type CanvasDimensions = {
    canvas: Canvas;
    height: number;
    width: number;
    x: number;
    y: number;
};
export declare class CanvasWorld {
    canvases: Canvas[];
    viewingDirection: ViewingDirection;
    layers: any[];
    private _canvasDimensions;
    /**
     * @param {Array} canvases - Array of Manifesto:Canvas objects to create a
     * world from.
     */
    constructor(canvases: Canvas[], layers: any, viewingDirection?: ViewingDirection);
    readonly canvasIds: string[];
    readonly canvasDimensions: CanvasDimensions[];
    /**
     * contentResourceToWorldCoordinates - calculates the contentResource coordinates
     * respective to the world.
     */
    contentResourceToWorldCoordinates(contentResource: any): any[];
    /** */
    canvasToWorldCoordinates(canvasId: any): number[];
    /** */
    readonly canvasDirection: number[];
    /** Get the IIIF content resource for an image */
    contentResource(infoResponseId: any): any;
    /** @private */
    getLayerMetadata(contentResource: any): any;
    /** */
    layerOpacityOfImageResource(contentResource: any): any;
    /** */
    layerIndexOfImageResource(contentResource: any): number | undefined;
    /**
     * offsetByCanvas - calculates the offset for a given canvas target. Currently
     * assumes a horizontal only layout.
     */
    offsetByCanvas(canvasTarget: any): {
        x: number;
        y: number;
    };
    /**
     * worldBounds - calculates the "World" bounds. World in this case is canvases
     * lined up horizontally starting from left to right.
     */
    worldBounds(): number[];
    /** */
    canvasAtPoint(point: any): Canvas | undefined;
}
export {};
