# Mapbox GL JS

Mapbox GL JS is a JavaScript library that renders interactive maps from vector tiles and Mapbox styles using WebGL. Mapbox GL JS is part of the [cross-platform Mapbox GL ecosystem](https://www.mapbox.com/maps/), which also includes compatible native SDKs for applications on [Android](https://www.mapbox.com/android-sdk/), [iOS](https://www.mapbox.com/ios-sdk/), [macOS](http://mapbox.github.io/mapbox-gl-native/macos), and [Qt](https://github.com/mapbox/mapbox-gl-native/tree/master/platform/qt).

In addition to GL JS, this repository contains code, issues, and test fixtures that are common to both GL JS and the native SDKs. For code and issues specific to the native SDKs, see the [mapbox/mapbox-gl-native](https://github.com/mapbox/mapbox-gl-native/) repository.

- [Getting started](https://github.com/mapbox/mapbox-gl-js/blob/master/INSTALL.md)
- [API documentation](https://www.mapbox.com/mapbox-gl-js/api)
- [Examples](https://www.mapbox.com/mapbox-gl-js/examples/)
- [Style documentation](https://www.mapbox.com/mapbox-gl-style-spec)
- [Open source styles](https://github.com/mapbox/mapbox-gl-styles)
- [Roadmap](https://www.mapbox.com/mapbox-gl-js/roadmap/)
- [Contributor documentation](https://github.com/mapbox/mapbox-gl-js/blob/master/CONTRIBUTING.md)

[<img width="981" alt="Mapbox GL gallery" src="https://cloud.githubusercontent.com/assets/281306/14547142/a3c98294-025f-11e6-92f4-d6b0f50c8e89.png">](https://www.mapbox.com/gallery/)

## Mapbox-suported plugins

* [mapbox-gl-draw](https://github.com/mapbox/mapbox-gl-draw) – Adds support for drawing and editing features on Mapbox GL JS maps
* [mapbox-gl-filter-simplify](https://github.com/mapbox/mapbox-gl-filter-simplify) – Simplifies and complexifies filters in Mapbox GL Styles

## Community-suported plugins

These projects are maintained by the GL JS community. Feel free to open a PR add your own projects to this list. We :heart: third party projects!

 - [Typescript Definitions on DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/mapbox-gl)
 - [wtMapbox: Webtoolkit Integration](https://github.com/yvanvds/wtMapbox)
 - [deck.gl: Advanced WebGL visualization layers](https://github.com/uber/deck.gl)
 - [echartslayer: echarts extension for mapboxgl](https://github.com/lzxue/echartLayer)
