/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){var e="3.5.2";let r;const n={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==r){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{r=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){r=t;}}return r},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!n.API_URL)return null;try{const t=new URL(n.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",RASTERARRAYS_URL_PREFIX:"rasterarrays/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",MESHOPT_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_base_v0.20.wasm",MESHOPT_SIMD_URL:"https://api.mapbox.com/mapbox-gl-js/meshopt_simd_v0.20.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf",TILES3D_URL_PREFIX:"3dtiles/v1"};function i(t){return n.API_URL_REGEX.test(t)}function s(t){return 0===t.indexOf("mapbox:")}function a(t){return n.API_CDN_URL_REGEX.test(t)}function o(t){return n.API_SPRITE_REGEX.test(t)}function l(t){return n.API_STYLE_REGEX.test(t)&&!o(t)}const u={create:"create",load:"load",fullLoad:"fullLoad"},c={mark(t){performance.mark(t);},measure(t,e,r){performance.measure(t,e,r);}};function h(t){const e=t.name.split("?")[0];return a(e)&&e.includes("mapbox-gl.js")?"javascript":a(e)&&e.includes("mapbox-gl.css")?"css":function(t){return n.API_FONTS_REGEX.test(t)}(e)?"fontRange":o(e)?"sprite":l(e)?"style":function(t){return n.API_TILEJSON_REGEX.test(t)}(e)?"tilejson":"other"}function p(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var f={},d={};Object.defineProperty(d,"__esModule",{value:!0}),d.setMatrixArrayType=function(t){d.ARRAY_TYPE=y=t;},d.toRadian=function(t){return t*x},d.equals=function(t,e){return Math.abs(t-e)<=m*Math.max(1,Math.abs(t),Math.abs(e))},d.RANDOM=d.ARRAY_TYPE=d.EPSILON=void 0;var m=1e-6;d.EPSILON=m;var y="undefined"!=typeof Float32Array?Float32Array:Array;d.ARRAY_TYPE=y;var g=Math.random;d.RANDOM=g;var x=Math.PI/180;Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var b={};function v(t){return v="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},v(t)}Object.defineProperty(b,"__esModule",{value:!0}),b.create=function(){var t=new _.ARRAY_TYPE(4);return _.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},b.clone=function(t){var e=new _.ARRAY_TYPE(4);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},b.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},b.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},b.fromValues=function(t,e,r,n){var i=new _.ARRAY_TYPE(4);return i[0]=t,i[1]=e,i[2]=r,i[3]=n,i},b.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},b.transpose=function(t,e){if(t===e){var r=e[1];t[1]=e[2],t[2]=r;}else t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3];return t},b.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*s-i*n;return a?(t[0]=s*(a=1/a),t[1]=-n*a,t[2]=-i*a,t[3]=r*a,t):null},b.adjoint=function(t,e){var r=e[0];return t[0]=e[3],t[1]=-e[1],t[2]=-e[2],t[3]=r,t},b.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},b.multiply=M,b.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+s*o,t[1]=i*l+a*o,t[2]=n*-o+s*l,t[3]=i*-o+a*l,t},b.scale=function(t,e,r){var n=e[1],i=e[2],s=e[3],a=r[0],o=r[1];return t[0]=e[0]*a,t[1]=n*a,t[2]=i*o,t[3]=s*o,t},b.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t},b.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t},b.str=function(t){return "mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},b.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},b.LDU=function(t,e,r,n){return t[2]=n[2]/n[0],r[0]=n[0],r[1]=n[1],r[3]=n[3]-t[2]*r[1],[t,e,r]},b.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},b.subtract=A,b.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},b.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=e[0],o=e[1],l=e[2],u=e[3];return Math.abs(r-a)<=_.EPSILON*Math.max(1,Math.abs(r),Math.abs(a))&&Math.abs(n-o)<=_.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=_.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(s-u)<=_.EPSILON*Math.max(1,Math.abs(s),Math.abs(u))},b.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},b.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},b.sub=b.mul=void 0;var _=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==v(t)&&"function"!=typeof t)return {default:t};var r=w(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function w(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (w=function(t){return t?r:e})(t)}function M(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*o+s*l,t[1]=i*o+a*l,t[2]=n*u+s*c,t[3]=i*u+a*c,t}function A(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}b.mul=M,b.sub=A;var S={};function I(t){return I="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},I(t)}Object.defineProperty(S,"__esModule",{value:!0}),S.create=function(){var t=new T.ARRAY_TYPE(6);return T.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},S.clone=function(t){var e=new T.ARRAY_TYPE(6);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e},S.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t},S.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},S.fromValues=function(t,e,r,n,i,s){var a=new T.ARRAY_TYPE(6);return a[0]=t,a[1]=e,a[2]=r,a[3]=n,a[4]=i,a[5]=s,a},S.set=function(t,e,r,n,i,s,a){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t},S.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=r*s-n*i;return l?(t[0]=s*(l=1/l),t[1]=-n*l,t[2]=-i*l,t[3]=r*l,t[4]=(i*o-s*a)*l,t[5]=(n*a-r*o)*l,t):null},S.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},S.multiply=P,S.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+s*u,t[1]=i*c+a*u,t[2]=n*-u+s*c,t[3]=i*-u+a*c,t[4]=o,t[5]=l,t},S.scale=function(t,e,r){var n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=r[0],u=r[1];return t[0]=e[0]*l,t[1]=n*l,t[2]=i*u,t[3]=s*u,t[4]=a,t[5]=o,t},S.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=r[0],c=r[1];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=n*u+s*c+o,t[5]=i*u+a*c+l,t},S.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=-r,t[3]=n,t[4]=0,t[5]=0,t},S.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=e[1],t[4]=0,t[5]=0,t},S.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=e[0],t[5]=e[1],t},S.str=function(t){return "mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},S.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},S.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t},S.subtract=z,S.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t},S.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t},S.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]},S.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=e[0],u=e[1],c=e[2],h=e[3],p=e[4],f=e[5];return Math.abs(r-l)<=T.EPSILON*Math.max(1,Math.abs(r),Math.abs(l))&&Math.abs(n-u)<=T.EPSILON*Math.max(1,Math.abs(n),Math.abs(u))&&Math.abs(i-c)<=T.EPSILON*Math.max(1,Math.abs(i),Math.abs(c))&&Math.abs(s-h)<=T.EPSILON*Math.max(1,Math.abs(s),Math.abs(h))&&Math.abs(a-p)<=T.EPSILON*Math.max(1,Math.abs(a),Math.abs(p))&&Math.abs(o-f)<=T.EPSILON*Math.max(1,Math.abs(o),Math.abs(f))},S.sub=S.mul=void 0;var T=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==I(t)&&"function"!=typeof t)return {default:t};var r=k(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function k(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (k=function(t){return t?r:e})(t)}function P(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=r[0],c=r[1],h=r[2],p=r[3],f=r[4],d=r[5];return t[0]=n*u+s*c,t[1]=i*u+a*c,t[2]=n*h+s*p,t[3]=i*h+a*p,t[4]=n*f+s*d+o,t[5]=i*f+a*d+l,t}function z(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t}S.mul=P,S.sub=z;var E={};function B(t){return B="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},B(t)}Object.defineProperty(E,"__esModule",{value:!0}),E.create=function(){var t=new D.ARRAY_TYPE(9);return D.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},E.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},E.clone=function(t){var e=new D.ARRAY_TYPE(9);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e},E.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},E.fromValues=function(t,e,r,n,i,s,a,o,l){var u=new D.ARRAY_TYPE(9);return u[0]=t,u[1]=e,u[2]=r,u[3]=n,u[4]=i,u[5]=s,u[6]=a,u[7]=o,u[8]=l,u},E.set=function(t,e,r,n,i,s,a,o,l,u){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t[8]=u,t},E.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},E.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},E.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=c*a-o*u,p=-c*s+o*l,f=u*s-a*l,d=r*h+n*p+i*f;return d?(t[0]=h*(d=1/d),t[1]=(-c*n+i*u)*d,t[2]=(o*n-i*a)*d,t[3]=p*d,t[4]=(c*r-i*l)*d,t[5]=(-o*r+i*s)*d,t[6]=f*d,t[7]=(-u*r+n*l)*d,t[8]=(a*r-n*s)*d,t):null},E.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=a*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*a,t[3]=o*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*o,t[6]=s*u-a*l,t[7]=n*l-r*u,t[8]=r*a-n*s,t},E.determinant=function(t){var e=t[3],r=t[4],n=t[5],i=t[6],s=t[7],a=t[8];return t[0]*(a*r-n*s)+t[1]*(-a*e+n*i)+t[2]*(s*e-r*i)},E.multiply=R,E.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=p*n+f*a+u,t[7]=p*i+f*o+c,t[8]=p*s+f*l+h,t},E.rotate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=Math.sin(r),f=Math.cos(r);return t[0]=f*n+p*a,t[1]=f*i+p*o,t[2]=f*s+p*l,t[3]=f*a-p*n,t[4]=f*o-p*i,t[5]=f*l-p*s,t[6]=u,t[7]=c,t[8]=h,t},E.scale=function(t,e,r){var n=r[0],i=r[1];return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=i*e[3],t[4]=i*e[4],t[5]=i*e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},E.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=e[0],t[7]=e[1],t[8]=1,t},E.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},E.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=e[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},E.fromMat2d=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=0,t[3]=e[2],t[4]=e[3],t[5]=0,t[6]=e[4],t[7]=e[5],t[8]=1,t},E.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,m=s*a,y=s*o,g=s*l;return t[0]=1-h-d,t[3]=c-g,t[6]=p+y,t[1]=c+g,t[4]=1-u-d,t[7]=f-m,t[2]=p-y,t[5]=f+m,t[8]=1-u-h,t},E.normalFromMat4=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*a,b=r*l-i*a,v=r*u-s*a,_=n*l-i*o,w=n*u-s*o,M=i*u-s*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,T=h*y-p*m,k=h*g-f*m,P=p*g-f*y,z=x*P-b*k+v*T+_*I-w*S+M*A;return z?(t[0]=(o*P-l*k+u*T)*(z=1/z),t[1]=(l*I-a*P-u*S)*z,t[2]=(a*k-o*I+u*A)*z,t[3]=(i*k-n*P-s*T)*z,t[4]=(r*P-i*I+s*S)*z,t[5]=(n*I-r*k-s*A)*z,t[6]=(m*M-y*w+g*_)*z,t[7]=(y*v-d*M-g*b)*z,t[8]=(d*w-m*v+g*x)*z,t):null},E.projection=function(t,e,r){return t[0]=2/e,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/r,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},E.str=function(t){return "mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},E.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},E.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t},E.subtract=V,E.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t},E.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t},E.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]},E.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=e[0],p=e[1],f=e[2],d=e[3],m=e[4],y=e[5],g=e[6],x=e[7],b=e[8];return Math.abs(r-h)<=D.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(n-p)<=D.EPSILON*Math.max(1,Math.abs(n),Math.abs(p))&&Math.abs(i-f)<=D.EPSILON*Math.max(1,Math.abs(i),Math.abs(f))&&Math.abs(s-d)<=D.EPSILON*Math.max(1,Math.abs(s),Math.abs(d))&&Math.abs(a-m)<=D.EPSILON*Math.max(1,Math.abs(a),Math.abs(m))&&Math.abs(o-y)<=D.EPSILON*Math.max(1,Math.abs(o),Math.abs(y))&&Math.abs(l-g)<=D.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(u-x)<=D.EPSILON*Math.max(1,Math.abs(u),Math.abs(x))&&Math.abs(c-b)<=D.EPSILON*Math.max(1,Math.abs(c),Math.abs(b))},E.sub=E.mul=void 0;var D=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==B(t)&&"function"!=typeof t)return {default:t};var r=C(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function C(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (C=function(t){return t?r:e})(t)}function R(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],m=r[3],y=r[4],g=r[5],x=r[6],b=r[7],v=r[8];return t[0]=p*n+f*a+d*u,t[1]=p*i+f*o+d*c,t[2]=p*s+f*l+d*h,t[3]=m*n+y*a+g*u,t[4]=m*i+y*o+g*c,t[5]=m*s+y*l+g*h,t[6]=x*n+b*a+v*u,t[7]=x*i+b*o+v*c,t[8]=x*s+b*l+v*h,t}function V(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t}E.mul=R,E.sub=V;var L={};function O(t){return O="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},O(t)}Object.defineProperty(L,"__esModule",{value:!0}),L.create=function(){var t=new F.ARRAY_TYPE(16);return F.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},L.clone=function(t){var e=new F.ARRAY_TYPE(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},L.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},L.fromValues=function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m){var y=new F.ARRAY_TYPE(16);return y[0]=t,y[1]=e,y[2]=r,y[3]=n,y[4]=i,y[5]=s,y[6]=a,y[7]=o,y[8]=l,y[9]=u,y[10]=c,y[11]=h,y[12]=p,y[13]=f,y[14]=d,y[15]=m,y},L.set=function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t[8]=u,t[9]=c,t[10]=h,t[11]=p,t[12]=f,t[13]=d,t[14]=m,t[15]=y,t},L.identity=N,L.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[3],s=e[6],a=e[7],o=e[11];t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=s,t[11]=e[14],t[12]=i,t[13]=a,t[14]=o;}else t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15];return t},L.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15],x=r*o-n*a,b=r*l-i*a,v=r*u-s*a,_=n*l-i*o,w=n*u-s*o,M=i*u-s*l,A=c*m-h*d,S=c*y-p*d,I=c*g-f*d,T=h*y-p*m,k=h*g-f*m,P=p*g-f*y,z=x*P-b*k+v*T+_*I-w*S+M*A;return z?(t[0]=(o*P-l*k+u*T)*(z=1/z),t[1]=(i*k-n*P-s*T)*z,t[2]=(m*M-y*w+g*_)*z,t[3]=(p*w-h*M-f*_)*z,t[4]=(l*I-a*P-u*S)*z,t[5]=(r*P-i*I+s*S)*z,t[6]=(y*v-d*M-g*b)*z,t[7]=(c*M-p*v+f*b)*z,t[8]=(a*k-o*I+u*A)*z,t[9]=(n*I-r*k-s*A)*z,t[10]=(d*w-m*v+g*x)*z,t[11]=(h*v-c*w-f*x)*z,t[12]=(o*S-a*T-l*A)*z,t[13]=(r*T-n*S+i*A)*z,t[14]=(m*b-d*_-y*x)*z,t[15]=(c*_-h*b+p*x)*z,t):null},L.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],m=e[13],y=e[14],g=e[15];return t[0]=o*(p*g-f*y)-h*(l*g-u*y)+m*(l*f-u*p),t[1]=-(n*(p*g-f*y)-h*(i*g-s*y)+m*(i*f-s*p)),t[2]=n*(l*g-u*y)-o*(i*g-s*y)+m*(i*u-s*l),t[3]=-(n*(l*f-u*p)-o*(i*f-s*p)+h*(i*u-s*l)),t[4]=-(a*(p*g-f*y)-c*(l*g-u*y)+d*(l*f-u*p)),t[5]=r*(p*g-f*y)-c*(i*g-s*y)+d*(i*f-s*p),t[6]=-(r*(l*g-u*y)-a*(i*g-s*y)+d*(i*u-s*l)),t[7]=r*(l*f-u*p)-a*(i*f-s*p)+c*(i*u-s*l),t[8]=a*(h*g-f*m)-c*(o*g-u*m)+d*(o*f-u*h),t[9]=-(r*(h*g-f*m)-c*(n*g-s*m)+d*(n*f-s*h)),t[10]=r*(o*g-u*m)-a*(n*g-s*m)+d*(n*u-s*o),t[11]=-(r*(o*f-u*h)-a*(n*f-s*h)+c*(n*u-s*o)),t[12]=-(a*(h*y-p*m)-c*(o*y-l*m)+d*(o*p-l*h)),t[13]=r*(h*y-p*m)-c*(n*y-i*m)+d*(n*p-i*h),t[14]=-(r*(o*y-l*m)-a*(n*y-i*m)+d*(n*l-i*o)),t[15]=r*(o*p-l*h)-a*(n*p-i*h)+c*(n*l-i*o),t},L.determinant=function(t){var e=t[0],r=t[1],n=t[2],i=t[3],s=t[4],a=t[5],o=t[6],l=t[7],u=t[8],c=t[9],h=t[10],p=t[11],f=t[12],d=t[13],m=t[14],y=t[15];return (e*a-r*s)*(h*y-p*m)-(e*o-n*s)*(c*y-p*d)+(e*l-i*s)*(c*m-h*d)+(r*o-n*a)*(u*y-p*f)-(r*l-i*a)*(u*m-h*f)+(n*l-i*o)*(u*d-c*f)},L.multiply=j,L.translate=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,m=r[0],y=r[1],g=r[2];return e===t?(t[12]=e[0]*m+e[4]*y+e[8]*g+e[12],t[13]=e[1]*m+e[5]*y+e[9]*g+e[13],t[14]=e[2]*m+e[6]*y+e[10]*g+e[14],t[15]=e[3]*m+e[7]*y+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*m+o*y+h*g+e[12],t[13]=i*m+l*y+p*g+e[13],t[14]=s*m+u*y+f*g+e[14],t[15]=a*m+c*y+d*g+e[15]),t},L.scale=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},L.rotate=function(t,e,r,n){var i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_,w,M,A,S,I,T,k=n[0],P=n[1],z=n[2],E=Math.hypot(k,P,z);return E<F.EPSILON?null:(k*=E=1/E,P*=E,z*=E,i=Math.sin(r),s=Math.cos(r),l=e[1],u=e[2],c=e[3],p=e[5],f=e[6],d=e[7],y=e[9],g=e[10],x=e[11],b=k*k*(a=1-s)+s,w=k*P*a-z*i,M=P*P*a+s,A=z*P*a+k*i,S=k*z*a+P*i,I=P*z*a-k*i,T=z*z*a+s,t[0]=(o=e[0])*b+(h=e[4])*(v=P*k*a+z*i)+(m=e[8])*(_=z*k*a-P*i),t[1]=l*b+p*v+y*_,t[2]=u*b+f*v+g*_,t[3]=c*b+d*v+x*_,t[4]=o*w+h*M+m*A,t[5]=l*w+p*M+y*A,t[6]=u*w+f*M+g*A,t[7]=c*w+d*M+x*A,t[8]=o*S+h*I+m*T,t[9]=l*S+p*I+y*T,t[10]=u*S+f*I+g*T,t[11]=c*S+d*I+x*T,e!==t&&(t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t)},L.rotateX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},L.rotateY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},L.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},L.fromTranslation=function(t,e){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=e[0],t[13]=e[1],t[14]=e[2],t[15]=1,t},L.fromScaling=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},L.fromRotation=function(t,e,r){var n,i,s,a=r[0],o=r[1],l=r[2],u=Math.hypot(a,o,l);return u<F.EPSILON?null:(a*=u=1/u,o*=u,l*=u,n=Math.sin(e),i=Math.cos(e),t[0]=a*a*(s=1-i)+i,t[1]=o*a*s+l*n,t[2]=l*a*s-o*n,t[3]=0,t[4]=a*o*s-l*n,t[5]=o*o*s+i,t[6]=l*o*s+a*n,t[7]=0,t[8]=a*l*s+o*n,t[9]=o*l*s-a*n,t[10]=l*l*s+i,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},L.fromXRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=n,t[6]=r,t[7]=0,t[8]=0,t[9]=-r,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},L.fromYRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=r,t[9]=0,t[10]=n,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},L.fromZRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=0,t[4]=-r,t[5]=n,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},L.fromRotationTranslation=q,L.fromQuat2=function(t,e){var r=new F.ARRAY_TYPE(3),n=-e[0],i=-e[1],s=-e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=n*n+i*i+s*s+a*a;return h>0?(r[0]=2*(o*a+c*n+l*s-u*i)/h,r[1]=2*(l*a+c*i+u*n-o*s)/h,r[2]=2*(u*a+c*s+o*i-l*n)/h):(r[0]=2*(o*a+c*n+l*s-u*i),r[1]=2*(l*a+c*i+u*n-o*s),r[2]=2*(u*a+c*s+o*i-l*n)),q(t,e,r),t},L.getTranslation=function(t,e){return t[0]=e[12],t[1]=e[13],t[2]=e[14],t},L.getScaling=$,L.getRotation=function(t,e){var r=new F.ARRAY_TYPE(3);$(r,e);var n=1/r[0],i=1/r[1],s=1/r[2],a=e[0]*n,o=e[1]*i,l=e[2]*s,u=e[4]*n,c=e[5]*i,h=e[6]*s,p=e[8]*n,f=e[9]*i,d=e[10]*s,m=a+c+d,y=0;return m>0?(y=2*Math.sqrt(m+1),t[3]=.25*y,t[0]=(h-f)/y,t[1]=(p-l)/y,t[2]=(o-u)/y):a>c&&a>d?(y=2*Math.sqrt(1+a-c-d),t[3]=(h-f)/y,t[0]=.25*y,t[1]=(o+u)/y,t[2]=(p+l)/y):c>d?(y=2*Math.sqrt(1+c-a-d),t[3]=(p-l)/y,t[0]=(o+u)/y,t[1]=.25*y,t[2]=(h+f)/y):(y=2*Math.sqrt(1+d-a-c),t[3]=(o-u)/y,t[0]=(p+l)/y,t[1]=(h+f)/y,t[2]=.25*y),t},L.fromRotationTranslationScale=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=e[3],l=i+i,u=s+s,c=a+a,h=i*l,p=i*u,f=i*c,d=s*u,m=s*c,y=a*c,g=o*l,x=o*u,b=o*c,v=n[0],_=n[1],w=n[2];return t[0]=(1-(d+y))*v,t[1]=(p+b)*v,t[2]=(f-x)*v,t[3]=0,t[4]=(p-b)*_,t[5]=(1-(h+y))*_,t[6]=(m+g)*_,t[7]=0,t[8]=(f+x)*w,t[9]=(m-g)*w,t[10]=(1-(h+d))*w,t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t},L.fromRotationTranslationScaleOrigin=function(t,e,r,n,i){var s=e[0],a=e[1],o=e[2],l=e[3],u=s+s,c=a+a,h=o+o,p=s*u,f=s*c,d=s*h,m=a*c,y=a*h,g=o*h,x=l*u,b=l*c,v=l*h,_=n[0],w=n[1],M=n[2],A=i[0],S=i[1],I=i[2],T=(1-(m+g))*_,k=(f+v)*_,P=(d-b)*_,z=(f-v)*w,E=(1-(p+g))*w,B=(y+x)*w,D=(d+b)*M,C=(y-x)*M,R=(1-(p+m))*M;return t[0]=T,t[1]=k,t[2]=P,t[3]=0,t[4]=z,t[5]=E,t[6]=B,t[7]=0,t[8]=D,t[9]=C,t[10]=R,t[11]=0,t[12]=r[0]+A-(T*A+z*S+D*I),t[13]=r[1]+S-(k*A+E*S+C*I),t[14]=r[2]+I-(P*A+B*S+R*I),t[15]=1,t},L.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,m=s*a,y=s*o,g=s*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-y,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+m,t[7]=0,t[8]=p+y,t[9]=f-m,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},L.frustum=function(t,e,r,n,i,s,a){var o=1/(r-e),l=1/(i-n),u=1/(s-a);return t[0]=2*s*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*s*l,t[6]=0,t[7]=0,t[8]=(r+e)*o,t[9]=(i+n)*l,t[10]=(a+s)*u,t[11]=-1,t[12]=0,t[13]=0,t[14]=a*s*2*u,t[15]=0,t},L.perspectiveNO=G,L.perspectiveZO=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=i*(s=1/(n-i)),t[14]=i*n*s):(t[10]=-1,t[14]=-n),t},L.perspectiveFromFieldOfView=function(t,e,r,n){var i=Math.tan(e.upDegrees*Math.PI/180),s=Math.tan(e.downDegrees*Math.PI/180),a=Math.tan(e.leftDegrees*Math.PI/180),o=Math.tan(e.rightDegrees*Math.PI/180),l=2/(a+o),u=2/(i+s);return t[0]=l,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=-(a-o)*l*.5,t[9]=(i-s)*u*.5,t[10]=n/(r-n),t[11]=-1,t[12]=0,t[13]=0,t[14]=n*r/(r-n),t[15]=0,t},L.orthoNO=Y,L.orthoZO=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=s*u,t[15]=1,t},L.lookAt=function(t,e,r,n){var i,s,a,o,l,u,c,h,p,f,d=e[0],m=e[1],y=e[2],g=n[0],x=n[1],b=n[2],v=r[0],_=r[1],w=r[2];return Math.abs(d-v)<F.EPSILON&&Math.abs(m-_)<F.EPSILON&&Math.abs(y-w)<F.EPSILON?N(t):(c=d-v,h=m-_,p=y-w,i=x*(p*=f=1/Math.hypot(c,h,p))-b*(h*=f),s=b*(c*=f)-g*p,a=g*h-x*c,(f=Math.hypot(i,s,a))?(i*=f=1/f,s*=f,a*=f):(i=0,s=0,a=0),o=h*a-p*s,l=p*i-c*a,u=c*s-h*i,(f=Math.hypot(o,l,u))?(o*=f=1/f,l*=f,u*=f):(o=0,l=0,u=0),t[0]=i,t[1]=o,t[2]=c,t[3]=0,t[4]=s,t[5]=l,t[6]=h,t[7]=0,t[8]=a,t[9]=u,t[10]=p,t[11]=0,t[12]=-(i*d+s*m+a*y),t[13]=-(o*d+l*m+u*y),t[14]=-(c*d+h*m+p*y),t[15]=1,t)},L.targetTo=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=n[0],l=n[1],u=n[2],c=i-r[0],h=s-r[1],p=a-r[2],f=c*c+h*h+p*p;f>0&&(c*=f=1/Math.sqrt(f),h*=f,p*=f);var d=l*p-u*h,m=u*c-o*p,y=o*h-l*c;return (f=d*d+m*m+y*y)>0&&(d*=f=1/Math.sqrt(f),m*=f,y*=f),t[0]=d,t[1]=m,t[2]=y,t[3]=0,t[4]=h*y-p*m,t[5]=p*d-c*y,t[6]=c*m-h*d,t[7]=0,t[8]=c,t[9]=h,t[10]=p,t[11]=0,t[12]=i,t[13]=s,t[14]=a,t[15]=1,t},L.str=function(t){return "mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},L.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},L.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},L.subtract=X,L.multiplyScalar=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},L.multiplyScalarAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t[4]=e[4]+r[4]*n,t[5]=e[5]+r[5]*n,t[6]=e[6]+r[6]*n,t[7]=e[7]+r[7]*n,t[8]=e[8]+r[8]*n,t[9]=e[9]+r[9]*n,t[10]=e[10]+r[10]*n,t[11]=e[11]+r[11]*n,t[12]=e[12]+r[12]*n,t[13]=e[13]+r[13]*n,t[14]=e[14]+r[14]*n,t[15]=e[15]+r[15]*n,t},L.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},L.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],m=t[13],y=t[14],g=t[15],x=e[0],b=e[1],v=e[2],_=e[3],w=e[4],M=e[5],A=e[6],S=e[7],I=e[8],T=e[9],k=e[10],P=e[11],z=e[12],E=e[13],B=e[14],D=e[15];return Math.abs(r-x)<=F.EPSILON*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-b)<=F.EPSILON*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-v)<=F.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-_)<=F.EPSILON*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-w)<=F.EPSILON*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(o-M)<=F.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))&&Math.abs(l-A)<=F.EPSILON*Math.max(1,Math.abs(l),Math.abs(A))&&Math.abs(u-S)<=F.EPSILON*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(c-I)<=F.EPSILON*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-T)<=F.EPSILON*Math.max(1,Math.abs(h),Math.abs(T))&&Math.abs(p-k)<=F.EPSILON*Math.max(1,Math.abs(p),Math.abs(k))&&Math.abs(f-P)<=F.EPSILON*Math.max(1,Math.abs(f),Math.abs(P))&&Math.abs(d-z)<=F.EPSILON*Math.max(1,Math.abs(d),Math.abs(z))&&Math.abs(m-E)<=F.EPSILON*Math.max(1,Math.abs(m),Math.abs(E))&&Math.abs(y-B)<=F.EPSILON*Math.max(1,Math.abs(y),Math.abs(B))&&Math.abs(g-D)<=F.EPSILON*Math.max(1,Math.abs(g),Math.abs(D))},L.sub=L.mul=L.ortho=L.perspective=void 0;var F=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==O(t)&&"function"!=typeof t)return {default:t};var r=U(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function U(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (U=function(t){return t?r:e})(t)}function N(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function j(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],m=e[12],y=e[13],g=e[14],x=e[15],b=r[0],v=r[1],_=r[2],w=r[3];return t[0]=b*n+v*o+_*h+w*m,t[1]=b*i+v*l+_*p+w*y,t[2]=b*s+v*u+_*f+w*g,t[3]=b*a+v*c+_*d+w*x,t[4]=(b=r[4])*n+(v=r[5])*o+(_=r[6])*h+(w=r[7])*m,t[5]=b*i+v*l+_*p+w*y,t[6]=b*s+v*u+_*f+w*g,t[7]=b*a+v*c+_*d+w*x,t[8]=(b=r[8])*n+(v=r[9])*o+(_=r[10])*h+(w=r[11])*m,t[9]=b*i+v*l+_*p+w*y,t[10]=b*s+v*u+_*f+w*g,t[11]=b*a+v*c+_*d+w*x,t[12]=(b=r[12])*n+(v=r[13])*o+(_=r[14])*h+(w=r[15])*m,t[13]=b*i+v*l+_*p+w*y,t[14]=b*s+v*u+_*f+w*g,t[15]=b*a+v*c+_*d+w*x,t}function q(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=n+n,l=i+i,u=s+s,c=n*o,h=n*l,p=n*u,f=i*l,d=i*u,m=s*u,y=a*o,g=a*l,x=a*u;return t[0]=1-(f+m),t[1]=h+x,t[2]=p-g,t[3]=0,t[4]=h-x,t[5]=1-(c+m),t[6]=d+y,t[7]=0,t[8]=p+g,t[9]=d-y,t[10]=1-(c+f),t[11]=0,t[12]=r[0],t[13]=r[1],t[14]=r[2],t[15]=1,t}function $(t,e){var r=e[4],n=e[5],i=e[6],s=e[8],a=e[9],o=e[10];return t[0]=Math.hypot(e[0],e[1],e[2]),t[1]=Math.hypot(r,n,i),t[2]=Math.hypot(s,a,o),t}function G(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t}function Y(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t}function X(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t}L.perspective=G,L.ortho=Y,L.mul=j,L.sub=X;var Z={},H={};function K(t){return K="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},K(t)}Object.defineProperty(H,"__esModule",{value:!0}),H.create=Q,H.clone=function(t){var e=new W.ARRAY_TYPE(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},H.length=tt,H.fromValues=function(t,e,r){var n=new W.ARRAY_TYPE(3);return n[0]=t,n[1]=e,n[2]=r,n},H.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},H.set=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},H.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},H.subtract=et,H.multiply=rt,H.divide=nt,H.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t},H.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t},H.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t},H.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t},H.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t},H.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},H.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},H.distance=it,H.squaredDistance=st,H.squaredLength=at,H.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t},H.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t},H.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t},H.dot=ot,H.cross=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t},H.lerp=function(t,e,r,n){var i=e[0],s=e[1],a=e[2];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=a+n*(r[2]-a),t},H.hermite=function(t,e,r,n,i,s){var a=s*s,o=a*(2*s-3)+1,l=a*(s-2)+s,u=a*(s-1),c=a*(3-2*s);return t[0]=e[0]*o+r[0]*l+n[0]*u+i[0]*c,t[1]=e[1]*o+r[1]*l+n[1]*u+i[1]*c,t[2]=e[2]*o+r[2]*l+n[2]*u+i[2]*c,t},H.bezier=function(t,e,r,n,i,s){var a=1-s,o=a*a,l=s*s,u=o*a,c=3*s*o,h=3*l*a,p=l*s;return t[0]=e[0]*u+r[0]*c+n[0]*h+i[0]*p,t[1]=e[1]*u+r[1]*c+n[1]*h+i[1]*p,t[2]=e[2]*u+r[2]*c+n[2]*h+i[2]*p,t},H.random=function(t,e){e=e||1;var r=2*W.RANDOM()*Math.PI,n=2*W.RANDOM()-1,i=Math.sqrt(1-n*n)*e;return t[0]=Math.cos(r)*i,t[1]=Math.sin(r)*i,t[2]=n*e,t},H.transformMat4=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t},H.transformMat3=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},H.transformQuat=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=i*l-s*o,c=s*a-n*l,h=n*o-i*a,p=i*h-s*c,f=s*u-n*h,d=n*c-i*u,m=2*r[3];return c*=m,h*=m,f*=2,d*=2,t[0]=a+(u*=m)+(p*=2),t[1]=o+c+f,t[2]=l+h+d,t},H.rotateX=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},H.rotateY=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},H.rotateZ=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},H.angle=function(t,e){var r=t[0],n=t[1],i=t[2],s=e[0],a=e[1],o=e[2],l=Math.sqrt(r*r+n*n+i*i)*Math.sqrt(s*s+a*a+o*o),u=l&&ot(t,e)/l;return Math.acos(Math.min(Math.max(u,-1),1))},H.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},H.str=function(t){return "vec3("+t[0]+", "+t[1]+", "+t[2]+")"},H.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},H.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=e[0],a=e[1],o=e[2];return Math.abs(r-s)<=W.EPSILON*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-a)<=W.EPSILON*Math.max(1,Math.abs(n),Math.abs(a))&&Math.abs(i-o)<=W.EPSILON*Math.max(1,Math.abs(i),Math.abs(o))},H.forEach=H.sqrLen=H.len=H.sqrDist=H.dist=H.div=H.mul=H.sub=void 0;var W=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==K(t)&&"function"!=typeof t)return {default:t};var r=J(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function J(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (J=function(t){return t?r:e})(t)}function Q(){var t=new W.ARRAY_TYPE(3);return W.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function tt(t){return Math.hypot(t[0],t[1],t[2])}function et(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function rt(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function nt(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t}function it(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])}function st(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2];return r*r+n*n+i*i}function at(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n}function ot(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}H.sub=et,H.mul=rt,H.div=nt,H.dist=it,H.sqrDist=st,H.len=tt,H.sqrLen=at;var lt,ut=(lt=Q(),function(t,e,r,n,i,s){var a,o;for(e||(e=3),r||(r=0),o=n?Math.min(n*e+r,t.length):t.length,a=r;a<o;a+=e)lt[0]=t[a],lt[1]=t[a+1],lt[2]=t[a+2],i(lt,lt,s),t[a]=lt[0],t[a+1]=lt[1],t[a+2]=lt[2];return t});H.forEach=ut;var ct={};function ht(t){return ht="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ht(t)}Object.defineProperty(ct,"__esModule",{value:!0}),ct.create=dt,ct.clone=function(t){var e=new pt.ARRAY_TYPE(4);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},ct.fromValues=function(t,e,r,n){var i=new pt.ARRAY_TYPE(4);return i[0]=t,i[1]=e,i[2]=r,i[3]=n,i},ct.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},ct.set=function(t,e,r,n,i){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t},ct.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t},ct.subtract=mt,ct.multiply=yt,ct.divide=gt,ct.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t[2]=Math.ceil(e[2]),t[3]=Math.ceil(e[3]),t},ct.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t[2]=Math.floor(e[2]),t[3]=Math.floor(e[3]),t},ct.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t[3]=Math.min(e[3],r[3]),t},ct.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t[3]=Math.max(e[3],r[3]),t},ct.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t[2]=Math.round(e[2]),t[3]=Math.round(e[3]),t},ct.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},ct.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t[3]=e[3]+r[3]*n,t},ct.distance=xt,ct.squaredDistance=bt,ct.length=vt,ct.squaredLength=_t,ct.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},ct.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t[2]=1/e[2],t[3]=1/e[3],t},ct.normalize=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=n*a,t[2]=i*a,t[3]=s*a,t},ct.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},ct.cross=function(t,e,r,n){var i=r[0]*n[1]-r[1]*n[0],s=r[0]*n[2]-r[2]*n[0],a=r[0]*n[3]-r[3]*n[0],o=r[1]*n[2]-r[2]*n[1],l=r[1]*n[3]-r[3]*n[1],u=r[2]*n[3]-r[3]*n[2],c=e[0],h=e[1],p=e[2],f=e[3];return t[0]=h*u-p*l+f*o,t[1]=-c*u+p*a-f*s,t[2]=c*l-h*a+f*i,t[3]=-c*o+h*s-p*i,t},ct.lerp=function(t,e,r,n){var i=e[0],s=e[1],a=e[2],o=e[3];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t[2]=a+n*(r[2]-a),t[3]=o+n*(r[3]-o),t},ct.random=function(t,e){var r,n,i,s,a,o;e=e||1;do{a=(r=2*pt.RANDOM()-1)*r+(n=2*pt.RANDOM()-1)*n;}while(a>=1);do{o=(i=2*pt.RANDOM()-1)*i+(s=2*pt.RANDOM()-1)*s;}while(o>=1);var l=Math.sqrt((1-a)/o);return t[0]=e*r,t[1]=e*n,t[2]=e*i*l,t[3]=e*s*l,t},ct.transformMat4=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t},ct.transformQuat=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2],u=r[3],c=u*n+o*s-l*i,h=u*i+l*n-a*s,p=u*s+a*i-o*n,f=-a*n-o*i-l*s;return t[0]=c*u+f*-a+h*-l-p*-o,t[1]=h*u+f*-o+p*-a-c*-l,t[2]=p*u+f*-l+c*-o-h*-a,t[3]=e[3],t},ct.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},ct.str=function(t){return "vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},ct.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},ct.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=e[0],o=e[1],l=e[2],u=e[3];return Math.abs(r-a)<=pt.EPSILON*Math.max(1,Math.abs(r),Math.abs(a))&&Math.abs(n-o)<=pt.EPSILON*Math.max(1,Math.abs(n),Math.abs(o))&&Math.abs(i-l)<=pt.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(s-u)<=pt.EPSILON*Math.max(1,Math.abs(s),Math.abs(u))},ct.forEach=ct.sqrLen=ct.len=ct.sqrDist=ct.dist=ct.div=ct.mul=ct.sub=void 0;var pt=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==ht(t)&&"function"!=typeof t)return {default:t};var r=ft(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function ft(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (ft=function(t){return t?r:e})(t)}function dt(){var t=new pt.ARRAY_TYPE(4);return pt.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function mt(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t}function yt(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}function gt(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t[3]=e[3]/r[3],t}function xt(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2],e[3]-t[3])}function bt(t,e){var r=e[0]-t[0],n=e[1]-t[1],i=e[2]-t[2],s=e[3]-t[3];return r*r+n*n+i*i+s*s}function vt(t){return Math.hypot(t[0],t[1],t[2],t[3])}function _t(t){var e=t[0],r=t[1],n=t[2],i=t[3];return e*e+r*r+n*n+i*i}ct.sub=mt,ct.mul=yt,ct.div=gt,ct.dist=xt,ct.sqrDist=bt,ct.len=vt,ct.sqrLen=_t;var wt=function(){var t=dt();return function(e,r,n,i,s,a){var o,l;for(r||(r=4),n||(n=0),l=i?Math.min(i*r+n,e.length):e.length,o=n;o<l;o+=r)t[0]=e[o],t[1]=e[o+1],t[2]=e[o+2],t[3]=e[o+3],s(t,t,a),e[o]=t[0],e[o+1]=t[1],e[o+2]=t[2],e[o+3]=t[3];return e}}();function Mt(t){return Mt="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Mt(t)}ct.forEach=wt,Object.defineProperty(Z,"__esModule",{value:!0}),Z.create=zt,Z.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},Z.setAxisAngle=Et,Z.getAxisAngle=function(t,e){var r=2*Math.acos(e[3]),n=Math.sin(r/2);return n>At.EPSILON?(t[0]=e[0]/n,t[1]=e[1]/n,t[2]=e[2]/n):(t[0]=1,t[1]=0,t[2]=0),r},Z.getAngle=function(t,e){var r=Ot(t,e);return Math.acos(2*r*r-1)},Z.multiply=Bt,Z.rotateX=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=s*l-i*o,t[3]=a*l-n*o,t},Z.rotateY=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l-s*o,t[1]=i*l+a*o,t[2]=s*l+n*o,t[3]=a*l-i*o,t},Z.rotateZ=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},Z.calculateW=function(t,e){var r=e[0],n=e[1],i=e[2];return t[0]=r,t[1]=n,t[2]=i,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-i*i)),t},Z.exp=Dt,Z.ln=Ct,Z.pow=function(t,e,r){return Ct(t,e),Lt(t,t,r),Dt(t,t),t},Z.slerp=Rt,Z.random=function(t){var e=At.RANDOM(),r=At.RANDOM(),n=At.RANDOM(),i=Math.sqrt(1-e),s=Math.sqrt(e);return t[0]=i*Math.sin(2*Math.PI*r),t[1]=i*Math.cos(2*Math.PI*r),t[2]=s*Math.sin(2*Math.PI*n),t[3]=s*Math.cos(2*Math.PI*n),t},Z.invert=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s,o=a?1/a:0;return t[0]=-r*o,t[1]=-n*o,t[2]=-i*o,t[3]=s*o,t},Z.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},Z.fromMat3=Vt,Z.fromEuler=function(t,e,r,n){var i=.5*Math.PI/180;e*=i,r*=i,n*=i;var s=Math.sin(e),a=Math.cos(e),o=Math.sin(r),l=Math.cos(r),u=Math.sin(n),c=Math.cos(n);return t[0]=s*l*c-a*o*u,t[1]=a*o*c+s*l*u,t[2]=a*l*u-s*o*c,t[3]=a*l*c+s*o*u,t},Z.str=function(t){return "quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},Z.setAxes=Z.sqlerp=Z.rotationTo=Z.equals=Z.exactEquals=Z.normalize=Z.sqrLen=Z.squaredLength=Z.len=Z.length=Z.lerp=Z.dot=Z.scale=Z.mul=Z.add=Z.set=Z.copy=Z.fromValues=Z.clone=void 0;var At=Pt(d),St=Pt(E),It=Pt(H),Tt=Pt(ct);function kt(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (kt=function(t){return t?r:e})(t)}function Pt(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==Mt(t)&&"function"!=typeof t)return {default:t};var r=kt(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}function zt(){var t=new At.ARRAY_TYPE(4);return At.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function Et(t,e,r){r*=.5;var n=Math.sin(r);return t[0]=n*e[0],t[1]=n*e[1],t[2]=n*e[2],t[3]=Math.cos(r),t}function Bt(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+a*o+i*u-s*l,t[1]=i*c+a*l+s*o-n*u,t[2]=s*c+a*u+n*l-i*o,t[3]=a*c-n*o-i*l-s*u,t}function Dt(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=Math.sqrt(r*r+n*n+i*i),o=Math.exp(s),l=a>0?o*Math.sin(a)/a:0;return t[0]=r*l,t[1]=n*l,t[2]=i*l,t[3]=o*Math.cos(a),t}function Ct(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=Math.sqrt(r*r+n*n+i*i),o=a>0?Math.atan2(a,s)/a:0;return t[0]=r*o,t[1]=n*o,t[2]=i*o,t[3]=.5*Math.log(r*r+n*n+i*i+s*s),t}function Rt(t,e,r,n){var i,s,a,o,l,u=e[0],c=e[1],h=e[2],p=e[3],f=r[0],d=r[1],m=r[2],y=r[3];return (s=u*f+c*d+h*m+p*y)<0&&(s=-s,f=-f,d=-d,m=-m,y=-y),1-s>At.EPSILON?(i=Math.acos(s),a=Math.sin(i),o=Math.sin((1-n)*i)/a,l=Math.sin(n*i)/a):(o=1-n,l=n),t[0]=o*u+l*f,t[1]=o*c+l*d,t[2]=o*h+l*m,t[3]=o*p+l*y,t}function Vt(t,e){var r,n=e[0]+e[4]+e[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,t[0]=(e[5]-e[7])*(r=.5/r),t[1]=(e[6]-e[2])*r,t[2]=(e[1]-e[3])*r;else {var i=0;e[4]>e[0]&&(i=1),e[8]>e[3*i+i]&&(i=2);var s=(i+1)%3,a=(i+2)%3;r=Math.sqrt(e[3*i+i]-e[3*s+s]-e[3*a+a]+1),t[i]=.5*r,t[3]=(e[3*s+a]-e[3*a+s])*(r=.5/r),t[s]=(e[3*s+i]+e[3*i+s])*r,t[a]=(e[3*a+i]+e[3*i+a])*r;}return t}Z.clone=Tt.clone,Z.fromValues=Tt.fromValues,Z.copy=Tt.copy,Z.set=Tt.set,Z.add=Tt.add,Z.mul=Bt;var Lt=Tt.scale;Z.scale=Lt;var Ot=Tt.dot;Z.dot=Ot,Z.lerp=Tt.lerp;var Ft=Tt.length;Z.length=Ft,Z.len=Ft;var Ut=Tt.squaredLength;Z.squaredLength=Ut,Z.sqrLen=Ut;var Nt=Tt.normalize;Z.normalize=Nt,Z.exactEquals=Tt.exactEquals,Z.equals=Tt.equals;var jt,qt,$t,Gt=(jt=It.create(),qt=It.fromValues(1,0,0),$t=It.fromValues(0,1,0),function(t,e,r){var n=It.dot(e,r);return n<-.999999?(It.cross(jt,qt,e),It.len(jt)<1e-6&&It.cross(jt,$t,e),It.normalize(jt,jt),Et(t,jt,Math.PI),t):n>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(It.cross(jt,e,r),t[0]=jt[0],t[1]=jt[1],t[2]=jt[2],t[3]=1+n,Nt(t,t))});Z.rotationTo=Gt;var Yt,Xt,Zt=(Yt=zt(),Xt=zt(),function(t,e,r,n,i,s){return Rt(Yt,e,i,s),Rt(Xt,r,n,s),Rt(t,Yt,Xt,2*s*(1-s)),t});Z.sqlerp=Zt;var Ht,Kt=(Ht=St.create(),function(t,e,r,n){return Ht[0]=r[0],Ht[3]=r[1],Ht[6]=r[2],Ht[1]=n[0],Ht[4]=n[1],Ht[7]=n[2],Ht[2]=-e[0],Ht[5]=-e[1],Ht[8]=-e[2],Nt(t,Vt(t,Ht))});Z.setAxes=Kt;var Wt={};function Jt(t){return Jt="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Jt(t)}Object.defineProperty(Wt,"__esModule",{value:!0}),Wt.create=function(){var t=new Qt.ARRAY_TYPE(8);return Qt.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},Wt.clone=function(t){var e=new Qt.ARRAY_TYPE(8);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e},Wt.fromValues=function(t,e,r,n,i,s,a,o){var l=new Qt.ARRAY_TYPE(8);return l[0]=t,l[1]=e,l[2]=r,l[3]=n,l[4]=i,l[5]=s,l[6]=a,l[7]=o,l},Wt.fromRotationTranslationValues=function(t,e,r,n,i,s,a){var o=new Qt.ARRAY_TYPE(8);o[0]=t,o[1]=e,o[2]=r,o[3]=n;var l=.5*i,u=.5*s,c=.5*a;return o[4]=l*n+u*r-c*e,o[5]=u*n+c*t-l*r,o[6]=c*n+l*e-u*t,o[7]=-l*t-u*e-c*r,o},Wt.fromRotationTranslation=ie,Wt.fromTranslation=function(t,e){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*e[0],t[5]=.5*e[1],t[6]=.5*e[2],t[7]=0,t},Wt.fromRotation=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},Wt.fromMat4=function(t,e){var r=te.create();ee.getRotation(r,e);var n=new Qt.ARRAY_TYPE(3);return ee.getTranslation(n,e),ie(t,r,n),t},Wt.copy=se,Wt.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},Wt.set=function(t,e,r,n,i,s,a,o,l){return t[0]=e,t[1]=r,t[2]=n,t[3]=i,t[4]=s,t[5]=a,t[6]=o,t[7]=l,t},Wt.getDual=function(t,e){return t[0]=e[4],t[1]=e[5],t[2]=e[6],t[3]=e[7],t},Wt.setDual=function(t,e){return t[4]=e[0],t[5]=e[1],t[6]=e[2],t[7]=e[3],t},Wt.getTranslation=function(t,e){var r=e[4],n=e[5],i=e[6],s=e[7],a=-e[0],o=-e[1],l=-e[2],u=e[3];return t[0]=2*(r*u+s*a+n*l-i*o),t[1]=2*(n*u+s*o+i*a-r*l),t[2]=2*(i*u+s*l+r*o-n*a),t},Wt.translate=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=.5*r[0],l=.5*r[1],u=.5*r[2],c=e[4],h=e[5],p=e[6],f=e[7];return t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=a*o+i*u-s*l+c,t[5]=a*l+s*o-n*u+h,t[6]=a*u+n*l-i*o+p,t[7]=-n*o-i*l-s*u+f,t},Wt.rotateX=function(t,e,r){var n=-e[0],i=-e[1],s=-e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*a+c*n+l*s-u*i,p=l*a+c*i+u*n-o*s,f=u*a+c*s+o*i-l*n,d=c*a-o*n-l*i-u*s;return te.rotateX(t,e,r),t[4]=h*(a=t[3])+d*(n=t[0])+p*(s=t[2])-f*(i=t[1]),t[5]=p*a+d*i+f*n-h*s,t[6]=f*a+d*s+h*i-p*n,t[7]=d*a-h*n-p*i-f*s,t},Wt.rotateY=function(t,e,r){var n=-e[0],i=-e[1],s=-e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*a+c*n+l*s-u*i,p=l*a+c*i+u*n-o*s,f=u*a+c*s+o*i-l*n,d=c*a-o*n-l*i-u*s;return te.rotateY(t,e,r),t[4]=h*(a=t[3])+d*(n=t[0])+p*(s=t[2])-f*(i=t[1]),t[5]=p*a+d*i+f*n-h*s,t[6]=f*a+d*s+h*i-p*n,t[7]=d*a-h*n-p*i-f*s,t},Wt.rotateZ=function(t,e,r){var n=-e[0],i=-e[1],s=-e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=o*a+c*n+l*s-u*i,p=l*a+c*i+u*n-o*s,f=u*a+c*s+o*i-l*n,d=c*a-o*n-l*i-u*s;return te.rotateZ(t,e,r),t[4]=h*(a=t[3])+d*(n=t[0])+p*(s=t[2])-f*(i=t[1]),t[5]=p*a+d*i+f*n-h*s,t[6]=f*a+d*s+h*i-p*n,t[7]=d*a-h*n-p*i-f*s,t},Wt.rotateByQuatAppend=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=r[3],o=e[0],l=e[1],u=e[2],c=e[3];return t[0]=o*a+c*n+l*s-u*i,t[1]=l*a+c*i+u*n-o*s,t[2]=u*a+c*s+o*i-l*n,t[3]=c*a-o*n-l*i-u*s,t[4]=(o=e[4])*a+(c=e[7])*n+(l=e[5])*s-(u=e[6])*i,t[5]=l*a+c*i+u*n-o*s,t[6]=u*a+c*s+o*i-l*n,t[7]=c*a-o*n-l*i-u*s,t},Wt.rotateByQuatPrepend=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[0],l=r[1],u=r[2],c=r[3];return t[0]=n*c+a*o+i*u-s*l,t[1]=i*c+a*l+s*o-n*u,t[2]=s*c+a*u+n*l-i*o,t[3]=a*c-n*o-i*l-s*u,t[4]=n*(c=r[7])+a*(o=r[4])+i*(u=r[6])-s*(l=r[5]),t[5]=i*c+a*l+s*o-n*u,t[6]=s*c+a*u+n*l-i*o,t[7]=a*c-n*o-i*l-s*u,t},Wt.rotateAroundAxis=function(t,e,r,n){if(Math.abs(n)<Qt.EPSILON)return se(t,e);var i=Math.hypot(r[0],r[1],r[2]);n*=.5;var s=Math.sin(n),a=s*r[0]/i,o=s*r[1]/i,l=s*r[2]/i,u=Math.cos(n),c=e[0],h=e[1],p=e[2],f=e[3];t[0]=c*u+f*a+h*l-p*o,t[1]=h*u+f*o+p*a-c*l,t[2]=p*u+f*l+c*o-h*a,t[3]=f*u-c*a-h*o-p*l;var d=e[4],m=e[5],y=e[6],g=e[7];return t[4]=d*u+g*a+m*l-y*o,t[5]=m*u+g*o+y*a-d*l,t[6]=y*u+g*l+d*o-m*a,t[7]=g*u-d*a-m*o-y*l,t},Wt.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t},Wt.multiply=ae,Wt.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t},Wt.lerp=function(t,e,r,n){var i=1-n;return oe(e,r)<0&&(n=-n),t[0]=e[0]*i+r[0]*n,t[1]=e[1]*i+r[1]*n,t[2]=e[2]*i+r[2]*n,t[3]=e[3]*i+r[3]*n,t[4]=e[4]*i+r[4]*n,t[5]=e[5]*i+r[5]*n,t[6]=e[6]*i+r[6]*n,t[7]=e[7]*i+r[7]*n,t},Wt.invert=function(t,e){var r=ue(e);return t[0]=-e[0]/r,t[1]=-e[1]/r,t[2]=-e[2]/r,t[3]=e[3]/r,t[4]=-e[4]/r,t[5]=-e[5]/r,t[6]=-e[6]/r,t[7]=e[7]/r,t},Wt.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=e[7],t},Wt.normalize=function(t,e){var r=ue(e);if(r>0){r=Math.sqrt(r);var n=e[0]/r,i=e[1]/r,s=e[2]/r,a=e[3]/r,o=e[4],l=e[5],u=e[6],c=e[7],h=n*o+i*l+s*u+a*c;t[0]=n,t[1]=i,t[2]=s,t[3]=a,t[4]=(o-n*h)/r,t[5]=(l-i*h)/r,t[6]=(u-s*h)/r,t[7]=(c-a*h)/r;}return t},Wt.str=function(t){return "quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},Wt.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]},Wt.equals=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=e[0],h=e[1],p=e[2],f=e[3],d=e[4],m=e[5],y=e[6],g=e[7];return Math.abs(r-c)<=Qt.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(n-h)<=Qt.EPSILON*Math.max(1,Math.abs(n),Math.abs(h))&&Math.abs(i-p)<=Qt.EPSILON*Math.max(1,Math.abs(i),Math.abs(p))&&Math.abs(s-f)<=Qt.EPSILON*Math.max(1,Math.abs(s),Math.abs(f))&&Math.abs(a-d)<=Qt.EPSILON*Math.max(1,Math.abs(a),Math.abs(d))&&Math.abs(o-m)<=Qt.EPSILON*Math.max(1,Math.abs(o),Math.abs(m))&&Math.abs(l-y)<=Qt.EPSILON*Math.max(1,Math.abs(l),Math.abs(y))&&Math.abs(u-g)<=Qt.EPSILON*Math.max(1,Math.abs(u),Math.abs(g))},Wt.sqrLen=Wt.squaredLength=Wt.len=Wt.length=Wt.dot=Wt.mul=Wt.setReal=Wt.getReal=void 0;var Qt=ne(d),te=ne(Z),ee=ne(L);function re(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (re=function(t){return t?r:e})(t)}function ne(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==Jt(t)&&"function"!=typeof t)return {default:t};var r=re(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}function ie(t,e,r){var n=.5*r[0],i=.5*r[1],s=.5*r[2],a=e[0],o=e[1],l=e[2],u=e[3];return t[0]=a,t[1]=o,t[2]=l,t[3]=u,t[4]=n*u+i*l-s*o,t[5]=i*u+s*a-n*l,t[6]=s*u+n*o-i*a,t[7]=-n*a-i*o-s*l,t}function se(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t}function ae(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=r[4],l=r[5],u=r[6],c=r[7],h=e[4],p=e[5],f=e[6],d=e[7],m=r[0],y=r[1],g=r[2],x=r[3];return t[0]=n*x+a*m+i*g-s*y,t[1]=i*x+a*y+s*m-n*g,t[2]=s*x+a*g+n*y-i*m,t[3]=a*x-n*m-i*y-s*g,t[4]=n*c+a*o+i*u-s*l+h*x+d*m+p*g-f*y,t[5]=i*c+a*l+s*o-n*u+p*x+d*y+f*m-h*g,t[6]=s*c+a*u+n*l-i*o+f*x+d*g+h*y-p*m,t[7]=a*c-n*o-i*l-s*u+d*x-h*m-p*y-f*g,t}Wt.getReal=te.copy,Wt.setReal=te.copy,Wt.mul=ae;var oe=te.dot;Wt.dot=oe;var le=te.length;Wt.length=le,Wt.len=le;var ue=te.squaredLength;Wt.squaredLength=ue,Wt.sqrLen=ue;var ce={};function he(t){return he="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},he(t)}Object.defineProperty(ce,"__esModule",{value:!0}),ce.create=de,ce.clone=function(t){var e=new pe.ARRAY_TYPE(2);return e[0]=t[0],e[1]=t[1],e},ce.fromValues=function(t,e){var r=new pe.ARRAY_TYPE(2);return r[0]=t,r[1]=e,r},ce.copy=function(t,e){return t[0]=e[0],t[1]=e[1],t},ce.set=function(t,e,r){return t[0]=e,t[1]=r,t},ce.add=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t},ce.subtract=me,ce.multiply=ye,ce.divide=ge,ce.ceil=function(t,e){return t[0]=Math.ceil(e[0]),t[1]=Math.ceil(e[1]),t},ce.floor=function(t,e){return t[0]=Math.floor(e[0]),t[1]=Math.floor(e[1]),t},ce.min=function(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t},ce.max=function(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t},ce.round=function(t,e){return t[0]=Math.round(e[0]),t[1]=Math.round(e[1]),t},ce.scale=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},ce.scaleAndAdd=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t},ce.distance=xe,ce.squaredDistance=be,ce.length=ve,ce.squaredLength=_e,ce.negate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t},ce.inverse=function(t,e){return t[0]=1/e[0],t[1]=1/e[1],t},ce.normalize=function(t,e){var r=e[0],n=e[1],i=r*r+n*n;return i>0&&(i=1/Math.sqrt(i)),t[0]=e[0]*i,t[1]=e[1]*i,t},ce.dot=function(t,e){return t[0]*e[0]+t[1]*e[1]},ce.cross=function(t,e,r){var n=e[0]*r[1]-e[1]*r[0];return t[0]=t[1]=0,t[2]=n,t},ce.lerp=function(t,e,r,n){var i=e[0],s=e[1];return t[0]=i+n*(r[0]-i),t[1]=s+n*(r[1]-s),t},ce.random=function(t,e){e=e||1;var r=2*pe.RANDOM()*Math.PI;return t[0]=Math.cos(r)*e,t[1]=Math.sin(r)*e,t},ce.transformMat2=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i,t[1]=r[1]*n+r[3]*i,t},ce.transformMat2d=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[2]*i+r[4],t[1]=r[1]*n+r[3]*i+r[5],t},ce.transformMat3=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[3]*i+r[6],t[1]=r[1]*n+r[4]*i+r[7],t},ce.transformMat4=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},ce.rotate=function(t,e,r,n){var i=e[0]-r[0],s=e[1]-r[1],a=Math.sin(n),o=Math.cos(n);return t[0]=i*o-s*a+r[0],t[1]=i*a+s*o+r[1],t},ce.angle=function(t,e){var r=t[0],n=t[1],i=e[0],s=e[1],a=Math.sqrt(r*r+n*n)*Math.sqrt(i*i+s*s);return Math.acos(Math.min(Math.max(a&&(r*i+n*s)/a,-1),1))},ce.zero=function(t){return t[0]=0,t[1]=0,t},ce.str=function(t){return "vec2("+t[0]+", "+t[1]+")"},ce.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]},ce.equals=function(t,e){var r=t[0],n=t[1],i=e[0],s=e[1];return Math.abs(r-i)<=pe.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(n-s)<=pe.EPSILON*Math.max(1,Math.abs(n),Math.abs(s))},ce.forEach=ce.sqrLen=ce.sqrDist=ce.dist=ce.div=ce.mul=ce.sub=ce.len=void 0;var pe=function(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==he(t)&&"function"!=typeof t)return {default:t};var r=fe(void 0);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}(d);function fe(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (fe=function(t){return t?r:e})(t)}function de(){var t=new pe.ARRAY_TYPE(2);return pe.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0),t}function me(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t}function ye(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t}function ge(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t}function xe(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1])}function be(t,e){var r=e[0]-t[0],n=e[1]-t[1];return r*r+n*n}function ve(t){return Math.hypot(t[0],t[1])}function _e(t){var e=t[0],r=t[1];return e*e+r*r}ce.len=ve,ce.sub=me,ce.mul=ye,ce.div=ge,ce.dist=xe,ce.sqrDist=be,ce.sqrLen=_e;var we=function(){var t=de();return function(e,r,n,i,s,a){var o,l;for(r||(r=2),n||(n=0),l=i?Math.min(i*r+n,e.length):e.length,o=n;o<l;o+=r)t[0]=e[o],t[1]=e[o+1],s(t,t,a),e[o]=t[0],e[o+1]=t[1];return e}}();function Me(t){return Me="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Me(t)}ce.forEach=we,Object.defineProperty(f,"__esModule",{value:!0}),t.aA=f.vec4=t._=f.vec3=f.vec2=f.quat2=t.av=f.quat=t.ad=f.mat4=t.bC=f.mat3=f.mat2d=t.aC=f.mat2=f.glMatrix=void 0;var Ae=Re(d);f.glMatrix=Ae;var Se=Re(b);t.aC=f.mat2=Se;var Ie=Re(S);f.mat2d=Ie;var Te=Re(E);t.bC=f.mat3=Te;var ke=Re(L);t.ad=f.mat4=ke;var Pe=Re(Z);t.av=f.quat=Pe;var ze=Re(Wt);f.quat2=ze;var Ee=Re(ce);f.vec2=Ee;var Be=Re(H);t._=f.vec3=Be;var De=Re(ct);function Ce(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,r=new WeakMap;return (Ce=function(t){return t?r:e})(t)}function Re(t,e){if(t&&t.__esModule)return t;if(null===t||"object"!==Me(t)&&"function"!=typeof t)return {default:t};var r=Ce(e);if(r&&r.has(t))return r.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var s in t)if("default"!==s&&Object.prototype.hasOwnProperty.call(t,s)){var a=i?Object.getOwnPropertyDescriptor(t,s):null;a&&(a.get||a.set)?Object.defineProperty(n,s,a):n[s]=t[s];}return n.default=t,r&&r.set(t,n),n}t.aA=f.vec4=De;var Ve=Le;function Le(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}Le.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var Oe=p(Ve),Fe=Ue;function Ue(t,e){this.x=t,this.y=e;}Ue.prototype={clone:function(){return new Ue(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},Ue.convert=function(t){return t instanceof Ue?t:Array.isArray(t)?new Ue(t[0],t[1]):t};var Ne=p(Fe);const je=Math.PI/180,qe=180/Math.PI;function $e(t){return t*je}function Ge(t){return t*qe}const Ye=[[0,0],[1,0],[1,1],[0,1]];function Xe(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function Ze(t,e,r,n){const i=new Oe(t,e,r,n);return function(t){return i.solve(t)}}const He=Ze(.25,.1,.25,1);function Ke(t,e,r){return Math.min(r,Math.max(e,t))}function We(t,e,r){return (r=Ke((r-t)/(e-t),0,1))*r*(3-2*r)}function Je(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function Qe(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,a)=>{e(t,((t,e)=>{t&&(s=t),i[a]=e,0==--n&&r(s,i);}));}));}function tr(t){const e=[];for(const r in t)e.push(t[r]);return e}function er(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let rr=1;function nr(){return rr++}function ir(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function sr(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function ar(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function or(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function lr(t,e){return -1!==t.indexOf(e,t.length-e.length)}function ur(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function cr(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function hr(t){return Array.isArray(t)?t.map(hr):"object"==typeof t&&t?ur(t,hr):t}const pr={};function fr(t){pr[t]||("undefined"!=typeof console&&console.warn(t),pr[t]=!0);}function dr(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function mr(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function yr([t,e,r]){const n=$e(e+90),i=$e(r);return {x:t*Math.cos(n)*Math.sin(i),y:t*Math.sin(n)*Math.sin(i),z:t*Math.cos(i),azimuthal:e,polar:r}}function gr(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function xr(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let br,vr,_r,wr,Mr,Ar,Sr=null;function Ir(t){try{const e=self[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}function Tr(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}function kr(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<n?e=i+1:r=i;}return e}function Pr(t,e,r,n){for(;e<r;){const i=e+r>>1;t[i]<=n?e=i+1:r=i;}return e}function zr(t){return t>0?1/(1.001-t):1+t}function Er(t){return t>0?1-1/(1.001-t):-t}function Br(){return null==br&&(br=self.OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof self.createImageBitmap),br}const Dr={now:()=>void 0!==wr?wr:performance.now(),setNow(t){wr=t;},restoreNow(){wr=void 0;},frame(t){const e=requestAnimationFrame(t);return {cancel:()=>cancelAnimationFrame(e)}},getImageData(t,e=0){const{width:r,height:n}=t;Mr||(Mr=document.createElement("canvas"));const i=Mr.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return (r>Mr.width||n>Mr.height)&&(Mr.width=r,Mr.height=n),i.clearRect(-e,-e,r+2*e,n+2*e),i.drawImage(t,0,0,r,n),i.getImageData(-e,-e,r+2*e,n+2*e)},resolveURL:t=>(vr||(vr=document.createElement("a")),vr.href=t,vr.href),get devicePixelRatio(){return window.devicePixelRatio},get prefersReducedMotion(){return !!window.matchMedia&&(null==_r&&(_r=window.matchMedia("(prefers-reduced-motion: reduce)")),_r.matches)},hasCanvasFingerprintNoise(){if(void 0!==Ar)return Ar;if(!Br())return Ar=!1,!1;const t=new OffscreenCanvas(85,1),e=t.getContext("2d",{willReadFrequently:!0});let r=0;for(let n=0;n<t.width;++n)e.fillStyle=`rgba(${r++},${r++},${r++}, 255)`,e.fillRect(n,0,1,1);const n=e.getImageData(0,0,t.width,t.height);r=0;for(let t=0;t<n.data.length;++t)if(t%4!=3&&r++!==n.data[t])return Ar=!0,!0;return Ar=!1,!1}};function Cr(t,e){const r=t.indexOf("?");if(r<0)return `${t}?${new URLSearchParams(e).toString()}`;const n=new URLSearchParams(t.slice(r));for(const t in e)n.set(t,e[t]);return `${t.slice(0,r)}?${n.toString()}`}function Rr(t,e={persistentParams:[]}){const r=t.indexOf("?");if(r<0)return t;const n=new URLSearchParams,i=new URLSearchParams(t.slice(r));for(const t of e.persistentParams){const e=i.get(t);e&&n.set(t,e);}const s=n.toString();return `${t.slice(0,r)}${s.length>0?`?${s}`:""}`}const Vr="mapbox-tiles";let Lr=500,Or=50;let Fr,Ur;function Nr(){try{return caches}catch(t){}}function jr(){const t=Nr();t&&!Fr&&(Fr=t.open(Vr));}let qr=1/0;const $r={supported:!1,testSupport:function(t){!Xr&&Yr&&(Zr?Kr(t):Gr=t);}};let Gr,Yr,Xr=!1,Zr=!1;const Hr="undefined"!=typeof self?self:{};function Kr(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,Yr),t.isContextLost())return;$r.supported=!0;}catch(t){}t.deleteTexture(e),Xr=!0;}Hr.document&&(Yr=Hr.document.createElement("img"),Yr.onload=function(){Gr&&Kr(Gr),Gr=null,Zr=!0;},Yr.onerror=function(){Xr=!0,Gr=null;},Yr.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Wr={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(Wr);class Jr extends Error{constructor(t,e,r){401===e&&i(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const Qr=gr()?()=>self.worker&&self.worker.referrer:()=>("blob:"===location.protocol?parent:self).location.href;const tn=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(Qr())&&!/^\w+:/.test(r))){if(self.fetch&&self.Request&&self.AbortController&&Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new AbortController,n=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:Qr(),referrerPolicy:t.referrerPolicy,signal:r.signal});let s=!1,a=!1;const o=(l=n.url).indexOf("sku=")>0&&i(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const u=(r,i,s)=>{if(a)return;if(r&&"SecurityError"!==r.message&&fr(r.toString()),i&&s)return c(i);const l=Date.now();fetch(n).then((r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,l)}return e(new Jr(r.statusText,r.status,t.url))})).catch((r=>{"AbortError"!==r.name&&e(new Error(`${r.message} ${t.url}`));}));},c=(r,i,o)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{a||(i&&o&&function(t,e,r){if(jr(),!Fr)return;const n=xr(e.headers.get("Cache-Control")||"");if(n["no-store"])return;const i={status:e.status,statusText:e.statusText,headers:new Headers};e.headers.forEach(((t,e)=>i.headers.set(e,t))),n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString());const s=i.headers.get("Expires");if(!s)return;if(new Date(s).getTime()-r<42e4)return;let a=Rr(t.url,{persistentParams:["language","worldview"]});if(206===e.status){const e=t.headers.get("Range");if(!e)return;i.status=200,a=Cr(a,{range:e});}!function(t,e){if(void 0===Ur)try{new Response(new ReadableStream),Ur=!0;}catch(t){Ur=!1;}Ur?e(t.body):t.blob().then(e);}(e,(t=>{const r=new Response(200!==(n=e.status)&&404!==n&&[101,103,204,205,304].includes(n)?null:t,i);var n;jr(),Fr&&Fr.then((t=>t.put(a,r))).catch((t=>fr(t.message)));}));}(n,i,o),s=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));})).catch((t=>{a||e(new Error(t.message));}));};return o?function(t,e){if(jr(),!Fr)return e(null);Fr.then((r=>{let n=Rr(t.url,{persistentParams:["language","worldview"]});const i=t.headers.get("Range");i&&(n=Cr(n,{range:i})),r.match(n).then((t=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=xr(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(t);r.delete(n),i&&r.put(n,t.clone()),e(null,t,i);})).catch(e);})).catch(e);}(n,u):u(null,null),{cancel:()=>{a=!0,s||r.abort();}}}(t,e);if(gr()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let n=r.response;if("json"===t.type)try{n=JSON.parse(r.response);}catch(t){return e(t)}e(null,n,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new Jr(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},en=function(t,e){return tn(er(t,{type:"arrayBuffer"}),e)};function rn(t){const e=document.createElement("a");return e.href=t,e.protocol===location.protocol&&e.host===location.host}const nn="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let sn,an;sn=[],an=0;const on=function(t,e){if($r.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),an>=n.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return sn.push(r),r}an++;let r=!1;const i=()=>{if(!r)for(r=!0,an--;sn.length&&an<n.MAX_PARALLEL_IMAGE_REQUESTS;){const t=sn.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=on(e,r).cancel);}},s=en(t,((t,r,n,s)=>{i(),t?e(t):r&&(self.createImageBitmap?function(t,e){const r=new Blob([new Uint8Array(t)],{type:"image/png"});createImageBitmap(r).then((t=>{e(null,t);})).catch((t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(r,((t,r)=>e(t,r,n,s))):function(t,e){const r=new Image;r.onload=()=>{e(null,r),URL.revokeObjectURL(r.src),r.onload=null,requestAnimationFrame((()=>{r.src=nn;}));},r.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):nn;}(r,((t,r)=>e(t,r,n,s))));}));return {cancel:()=>{s.cancel(),i();}}},ln="01",un="NO_ACCESS_TOKEN",cn=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function hn(t){const e=t.match(cn);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function pn(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}const fn="mapbox.eventData";function dn(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(atob(e[1]).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(t){return null}}class mn{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=dn(n.ACCESS_TOKEN);let r="";return r=e&&e.u?btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e))))):n.ACCESS_TOKEN||"",t?`${fn}.${t}:${r}`:`${fn}:${r}`}fetchEventData(){const t=Ir("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const n=localStorage.getItem(r);n&&(this.anonId=n);}catch(t){fr("Unable to read from LocalStorage");}}saveEventData(){const t=Ir("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid"),n=this.anonId;if(t&&n)try{localStorage.setItem(r,n),Object.keys(this.eventData).length>=1&&localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){fr("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,e,r,i){if(!n.EVENTS_URL)return;const s=hn(n.EVENTS_URL);s.params.push(`access_token=${i||n.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(t).toISOString()},o=e?er(a,e):a,l={url:pn(s),headers:{"Content-Type":"text/plain"},body:JSON.stringify([o])};this.pendingRequest=function(t,e){return tn(er(t,{method:"POST"}),e)}(l,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);}));}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const yn=new class extends mn{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){n.EVENTS_URL&&n.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>s(t)||i(t)))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const r=dn(n.ACCESS_TOKEN),i=r?r.u:n.ACCESS_TOKEN;let s=i!==this.eventData.tokenU;ar(this.anonId)||(this.anonId=ir(),s=!0);const a=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(a),r=(a-this.eventData.lastSuccess)/864e5;s=s||r>=1||r<-1||t.getDate()!==e.getDate();}else s=!0;s?this.postEvent(a,{sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:ln,"enabled.telemetry":!1,userId:this.anonId},(t=>{t||(this.eventData.lastSuccess=a,this.eventData.tokenU=i);}),t):this.processRequests();}},gn=yn.postTurnstileEvent.bind(yn),xn=new class extends mn{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,i){this.skuToken=e,this.errorCb=i,n.EVENTS_URL&&(r||n.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(un)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:r,timestamp:n}=this.queue.shift();r&&this.success[r]||(this.anonId||this.fetchEventData(),ar(this.anonId)||(this.anonId=ir()),this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:e,skuId:ln,skuToken:this.skuToken,userId:this.anonId},(t=>{t?this.errorCb(t):r&&(this.success[r]=!0);}),t));}remove(){this.errorCb=null;}},bn=xn.postMapLoadEvent.bind(xn),vn=new class extends mn{constructor(){super("style.load"),this.eventIdPerMapInstanceMap=new Map,this.mapInstanceIdMap=new WeakMap;}getMapInstanceId(t){let e=this.mapInstanceIdMap.get(t);return e||(e=ir(),this.mapInstanceIdMap.set(t,e)),e}getEventId(t){const e=this.eventIdPerMapInstanceMap.get(t)||0;return this.eventIdPerMapInstanceMap.set(t,e+1),e}postStyleLoadEvent(t,e){const{map:r,style:i,importedStyles:s}=e;if(!n.EVENTS_URL||!t&&!n.ACCESS_TOKEN)return;const a=this.getMapInstanceId(r),o={mapInstanceId:a,eventId:this.getEventId(a),style:i};s.length&&(o.importedStyles=s),this.queueRequest({timestamp:Date.now(),payload:o},t);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:e,payload:r}=this.queue.shift();this.postEvent(e,r,(()=>{}),t);}},_n=vn.postStyleLoadEvent.bind(vn),wn=new class extends mn{constructor(){super("gljs.performance");}postPerformanceEvent(t,e){n.EVENTS_URL&&(t||n.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:e},t);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),i=function(t){const r=performance.getEntriesByType("resource"),n=performance.getEntriesByType("mark"),i=function(t){const e={};if(t)for(const r in t)if("other"!==r)for(const n of t[r]){const t=`${r}ResolveRangeMin`,i=`${r}ResolveRangeMax`,s=`${r}RequestCount`,a=`${r}RequestCachedCount`;e[t]=Math.min(e[t]||1/0,n.startTime),e[i]=Math.max(e[i]||-1/0,n.responseEnd);const o=t=>{void 0===e[t]&&(e[t]=0),++e[t];};void 0!==n.transferSize&&0===n.transferSize&&o(a),o(s);}return e}(function(t,e){const r={};if(t)for(const n of t){const t=e(n);void 0===r[t]&&(r[t]=[]),r[t].push(n);}return r}(r,h)),s=window.devicePixelRatio,a=navigator.connection||navigator.mozConnection||navigator.webkitConnection,o=a?a.effectiveType:void 0,c={counters:[],metadata:[],attributes:[]},p=(t,e,r)=>{null!=r&&t.push({name:e,value:r.toString()});};for(const t in i)p(c.counters,t,i[t]);if(t.interactionRange[0]!==1/0&&t.interactionRange[1]!==-1/0&&(p(c.counters,"interactionRangeMin",t.interactionRange[0]),p(c.counters,"interactionRangeMax",t.interactionRange[1])),n)for(const t of Object.keys(u)){const e=u[t],r=n.find((t=>t.name===e));r&&p(c.counters,e,r.startTime);}return p(c.counters,"visibilityHidden",t.visibilityHidden),p(c.attributes,"style",function(t){if(t)for(const e of t){const t=e.name.split("?")[0];if(l(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(r)),p(c.attributes,"terrainEnabled",t.terrainEnabled?"true":"false"),p(c.attributes,"fogEnabled",t.fogEnabled?"true":"false"),p(c.attributes,"projection",t.projection),p(c.attributes,"zoom",t.zoom),p(c.metadata,"devicePixelRatio",s),p(c.metadata,"connectionEffectiveType",o),p(c.metadata,"navigatorUserAgent",navigator.userAgent),p(c.metadata,"screenWidth",window.screen.width),p(c.metadata,"screenHeight",window.screen.height),p(c.metadata,"windowWidth",window.innerWidth),p(c.metadata,"windowHeight",window.innerHeight),p(c.metadata,"mapWidth",t.width/s),p(c.metadata,"mapHeight",t.height/s),p(c.metadata,"webglRenderer",t.renderer),p(c.metadata,"webglVendor",t.vendor),p(c.metadata,"sdkVersion",e),p(c.metadata,"sdkIdentifier","mapbox-gl-js"),c}(n);for(const t of i.metadata);for(const t of i.counters);for(const t of i.attributes);this.postEvent(r,i,(()=>{}),t);}},Mn=wn.postPerformanceEvent.bind(wn),An=new class extends mn{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,i){if(!n.API_URL||!n.SESSION_PATH)return;const s=hn(n.API_URL+n.SESSION_PATH);s.params.push(`sku=${e||""}`),s.params.push(`access_token=${i||n.ACCESS_TOKEN||""}`);const a={url:pn(s),headers:{"Content-Type":"text/plain"}};this.pendingRequest=function(t,e){return tn(er(t,{method:"GET"}),e)}(a,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);}));}getSessionAPI(t,e,r,i){this.skuToken=e,this.errorCb=i,n.SESSION_PATH&&n.API_URL&&(r||n.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(un)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t);}remove(){this.errorCb=null;}},Sn=An.getSessionAPI.bind(An),In=new Set;var Tn={exports:{}},kn={exports:function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}},Pn={exports:({},function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0})},zn=kn.exports,En=Pn.exports;Tn.exports=zn,Tn.exports.murmur3=zn,Tn.exports.murmur2=En;var Bn=p(Tn.exports);class Dn{constructor(t,...e){er(this,e[0]||{}),this.type=t;}}class Cn extends Dn{constructor(t,e={}){super("error",er({error:t},e));}}function Rn(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Vn(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class Ln{on(t,e){return this._listeners=this._listeners||{},Rn(t,e,this._listeners),this}off(t,e){return Vn(t,e,this._listeners),Vn(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Rn(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){const r="string"==typeof t?new Dn(t,e):t,n=r.type;if(this.listens(n)){r.target=this;const t=this._listeners&&this._listeners[n]?this._listeners[n].slice():[];for(const e of t)e.call(this,r);const e=this._oneTimeListeners&&this._oneTimeListeners[n]?this._oneTimeListeners[n].slice():[];for(const t of e)Vn(n,t,this._oneTimeListeners),t.call(this,r);const i=this._eventedParent;i&&(er(r,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(r));}else r instanceof Cn&&console.error(r.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}t.F=void 0;var On={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function Fn(t){return (t=Math.round(t))<0?0:t>255?255:t}function Un(t){return Fn("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function Nn(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function jn(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{t.F={}.parseCSSColor=function(t){var e,r=t.replace(/ /g,"").toLowerCase();if(r in On)return On[r].slice();if("#"===r[0])return 4===r.length?(e=parseInt(r.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===r.length&&(e=parseInt(r.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var n=r.indexOf("("),i=r.indexOf(")");if(-1!==n&&i+1===r.length){var s=r.substr(0,n),a=r.substr(n+1,i-(n+1)).split(","),o=1;switch(s){case"rgba":if(4!==a.length)return null;o=Nn(a.pop());case"rgb":return 3!==a.length?null:[Un(a[0]),Un(a[1]),Un(a[2]),o];case"hsla":if(4!==a.length)return null;o=Nn(a.pop());case"hsl":if(3!==a.length)return null;var l=(parseFloat(a[0])%360+360)%360/360,u=Nn(a[1]),c=Nn(a[2]),h=c<=.5?c*(u+1):c+u-c*u,p=2*c-h;return [Fn(255*jn(p,h,l+1/3)),Fn(255*jn(p,h,l)),Fn(255*jn(p,h,l-1/3)),o];default:return null}}return null};}catch(t){}class qn{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(e){if(!e)return;if(e instanceof qn)return e;if("string"!=typeof e)return;const r=t.F(e);return r?new qn(r[0]/255*r[3],r[1]/255*r[3],r[2]/255*r[3],r[3]):void 0}toString(){const[t,e,r,n]=0===this.a?[0,0,0,0]:[255*this.r/this.a,255*this.g/this.a,255*this.b/this.a,this.a];return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toRenderColor(t){const{r:e,g:r,b:n,a:i}=this;return new $n(t,e,r,n,i)}}class $n{constructor(t,e,r,n,i){if(t){const s=t.image.height,a=s*s;e=0===i?0:e/i*(s-1),r=0===i?0:r/i*(s-1),n=0===i?0:n/i*(s-1);const o=Math.floor(e),l=Math.floor(r),u=Math.floor(n),c=Math.ceil(e),h=Math.ceil(r),p=Math.ceil(n),f=e-o,d=r-l,m=n-u,y=t.image.data,g=4*(o+l*a+u*s),x=4*(o+l*a+p*s),b=4*(o+h*a+u*s),v=4*(o+h*a+p*s),_=4*(c+l*a+u*s),w=4*(c+l*a+p*s),M=4*(c+h*a+u*s),A=4*(c+h*a+p*s);if(g<0||A>=y.length)throw new Error("out of range");this.r=Gn(Gn(Gn(y[g],y[x],m),Gn(y[b],y[v],m),d),Gn(Gn(y[_],y[w],m),Gn(y[M],y[A],m),d),f)/255*i,this.g=Gn(Gn(Gn(y[g+1],y[x+1],m),Gn(y[b+1],y[v+1],m),d),Gn(Gn(y[_+1],y[w+1],m),Gn(y[M+1],y[A+1],m),d),f)/255*i,this.b=Gn(Gn(Gn(y[g+2],y[x+2],m),Gn(y[b+2],y[v+2],m),d),Gn(Gn(y[_+2],y[w+2],m),Gn(y[M+2],y[A+2],m),d),f)/255*i,this.a=i;}else this.r=e,this.g=r,this.b=n,this.a=i;}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[t/n,e/n,r/n,n]}toArray01Scaled(t){const{r:e,g:r,b:n,a:i}=this;return 0===i?[0,0,0]:[e/i*t,r/i*t,n/i*t]}toArray01PremultipliedAlpha(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}toArray01Linear(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[Math.pow(t/n,2.2),Math.pow(e/n,2.2),Math.pow(r/n,2.2),n]}}function Gn(t,e,r){return t*(1-r)+e*r}function Yn(t,e,r){return t.map(((t,n)=>Gn(t,e[n],r)))}qn.black=new qn(0,0,0,1),qn.white=new qn(1,1,1,1),qn.transparent=new qn(0,0,0,0),qn.red=new qn(1,0,0,1),qn.blue=new qn(0,0,1,1);var Xn=Object.freeze({__proto__:null,array:Yn,color:function(t,e,r){return new qn(Gn(t.r,e.r,r),Gn(t.g,e.g,r),Gn(t.b,e.b,r),Gn(t.a,e.a,r))},number:Gn});function Zn(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class Hn extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Kn{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Kn(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Wn={kind:"null"},Jn={kind:"number"},Qn={kind:"string"},ti={kind:"boolean"},ei={kind:"color"},ri={kind:"object"},ni={kind:"value"},ii={kind:"collator"},si={kind:"formatted"},ai={kind:"resolvedImage"};function oi(t,e){return {kind:"array",itemType:t,N:e}}function li(t){if("array"===t.kind){const e=li(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const ui=[Wn,Jn,Qn,ti,ei,si,ri,oi(ni),ai];function ci(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!ci(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of ui)if(!ci(t,e))return null}return `Expected ${li(t)} but found ${li(e)} instead.`}function hi(t,e){return e.some((e=>e.kind===t.kind))}function pi(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}class fi{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class di{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class mi{constructor(t){this.sections=t;}static fromString(t){return new mi([new di(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.namePrimary.length))}static factory(t){return t instanceof mi?t:mi.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.namePrimary]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toRenderColor(null).toArray())),t.push(r);}return t}}class yi{constructor(t){this.namePrimary=t.namePrimary,t.nameSecondary&&(this.nameSecondary=t.nameSecondary),this.available=t.available;}toString(){return this.nameSecondary?`[${this.namePrimary},${this.nameSecondary}]`:this.namePrimary}static fromString(t,e){return t?new yi({namePrimary:t,nameSecondary:e,available:!1}):null}serialize(){return this.nameSecondary?["image",this.namePrimary,this.nameSecondary]:["image",this.namePrimary]}}function gi(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function xi(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof qn)return !0;if(t instanceof fi)return !0;if(t instanceof mi)return !0;if(t instanceof yi)return !0;if(Array.isArray(t)){for(const e of t)if(!xi(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!xi(t[e]))return !1;return !0}return !1}function bi(t){if(null===t)return Wn;if("string"==typeof t)return Qn;if("boolean"==typeof t)return ti;if("number"==typeof t)return Jn;if(t instanceof qn)return ei;if(t instanceof fi)return ii;if(t instanceof mi)return si;if(t instanceof yi)return ai;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=bi(e);if(r){if(r===t)continue;r=ni;break}r=t;}return oi(r||ni,e)}return ri}function vi(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof qn||t instanceof mi||t instanceof yi?t.toString():JSON.stringify(t)}class _i{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!xi(t[1]))return e.error("invalid value");const r=t[1];let n=bi(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new _i(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof qn?["rgba"].concat(this.value.toRenderColor(null).toArray()):this.value instanceof mi?this.value.serialize():this.value}}class wi{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const Mi={string:Qn,number:Jn,boolean:ti,object:ri};class Ai{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Mi)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Mi[r],n++;}else i=ni;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=oi(i,s);}else r=Mi[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,ni);if(!r)return null;s.push(r);}return new Ai(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!ci(this.type,bi(r)))return r;if(e===this.args.length-1)throw new wi(`Expected value to be of type ${li(this.type)}, but found ${li(bi(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}class Si{constructor(t){this.type=si,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Jn),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,oi(Qn)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,ei),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,ni);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new Si(n)}evaluate(t){return new mi(this.sections.map((e=>{const r=e.content.evaluate(t);return bi(r)===ai?new di("",r,null,null,null):new di(vi(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class Ii{constructor(t,e){this.type=ai,this.inputPrimary=t,this.inputSecondary=e;}static parse(t,e){if(t.length<2)return e.error("Expected two or more arguments.");const r=e.parse(t[1],1,Qn);if(!r)return e.error("No image name provided.");if(2===t.length)return new Ii(r);const n=e.parse(t[2],1,Qn);return n?new Ii(r,n):e.error("Secondary image variant is not a string.")}evaluate(t){const e=yi.fromString(this.inputPrimary.evaluate(t),this.inputSecondary?this.inputSecondary.evaluate(t):void 0);return e&&t.availableImages&&(e.available=t.availableImages.indexOf(e.namePrimary)>-1,e.nameSecondary&&e.available&&t.availableImages&&(e.available=t.availableImages.indexOf(e.nameSecondary)>-1)),e}eachChild(t){t(this.inputPrimary),this.inputSecondary&&t(this.inputSecondary);}outputDefined(){return !1}serialize(){return this.inputSecondary?["image",this.inputPrimary.serialize(),this.inputSecondary.serialize()]:["image",this.inputPrimary.serialize()]}}function Ti(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}const ki={"to-boolean":ti,"to-color":ei,"to-number":Jn,"to-string":Qn};class Pi{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0],n=[];let i=Wn;if("to-array"===r){if(!Array.isArray(t[1]))return null;const r=t[1].length;if(e.expectedType){if("array"!==e.expectedType.kind)return e.error(`Expected ${e.expectedType.kind} but found array.`);i=oi(e.expectedType.itemType,r);}else {if(!(r>0&&xi(t[1][0])))return null;i=oi(bi(t[1][0]),r);}for(let s=0;s<r;s++){const r=t[1][s];let a;if("array"===Ti(r))a=e.parse(r,void 0,i.itemType);else {const t=Ti(r);if(t!==i.itemType.kind)return e.error(`Expected ${i.itemType.kind} but found ${t}.`);a=e.registry.literal.parse(["literal",void 0===r?null:r],e);}if(!a)return null;n.push(a);}}else {if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");i=ki[r];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,ni);if(!i)return null;n.push(i);}}return new Pi(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof qn)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:gi(e[0],e[1],e[2],e[3]),!r))return new qn(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new wi(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new wi(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?mi.fromString(vi(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?yi.fromString(vi(this.args[0].evaluate(t))):"array"===this.type.kind?this.args.map((e=>e.evaluate(t))):vi(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new Si([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new Ii(this.args[0]).serialize();const t="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}const zi=["Unknown","Point","LineString","Polygon"];class Ei{constructor(t,e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.scope=t,this.options=e;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?zi[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(t){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=qn.parse(t)),e}getConfig(t){return this.options?this.options.get(t):null}}class Bi{constructor(t,e,r,n,i){this.name=t,this.type=e,this._evaluate=r,this.args=n,this._overloadIndex=i;}evaluate(t){if(!this._evaluate){const t=Bi.definitions[this.name];this._evaluate=Array.isArray(t)?t[2]:t.overloads[this._overloadIndex][1];}return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=Bi.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=[];let o=null,l=-1;for(const[n,u]of s){if(Array.isArray(n)&&n.length!==t.length-1)continue;a.push(n),l++,o=new Js(e.registry,e.path,null,e.scope,void 0,e._scope,e.options);const s=[];let c=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,a=o.parse(r,1+s.length,i);if(!a){c=!0;break}s.push(a);}if(!c)if(Array.isArray(n)&&n.length!==s.length)o.error(`Expected ${n.length} arguments, but found ${s.length} instead.`);else {for(let t=0;t<s.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=s[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Bi(r,i,u,s,l)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s.map((([t])=>t))).map(Di).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(li(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Bi.definitions=e;for(const r in e)t[r]=Bi;}}function Di(t){return Array.isArray(t)?`(${t.map(li).join(", ")})`:`(${li(t.type)}...)`}class Ci{constructor(t,e,r){this.type=ii,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,ti);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,ti);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Qn),!s)?null:new Ci(n,i,s)}evaluate(t){return new fi(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function Ri(t,e,r=0,n=t.length-1,i=Li){for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Ri(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(Vi(t,r,e),i(t[n],s)>0&&Vi(t,r,n);a<o;){for(Vi(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?Vi(t,r,o):(o++,Vi(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function Vi(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Li(t,e){return t<e?-1:t>e?1:0}function Oi(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function Fi(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Ui(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Ni(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function ji(t,e,r=!1){let n=!1;for(let o=0,l=e.length;o<l;o++){const l=e[o];for(let e=0,o=l.length,u=o-1;e<o;u=e++){const o=l[u],c=l[e];if(Ni(t,o,c))return r;(s=o)[1]>(i=t)[1]!=(a=c)[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}}var i,s,a;return n}function qi(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function $i(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!qi(t,e,r,n)||!qi(r,n,t,e));var i,s;}const Gi=8192;function Yi(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Gi),Math.round(n*i*Gi)]}function Xi(t,e){for(let r=0;r<e.length;r++)if(ji(t,e[r]))return !0;return !1}function Zi(t,e,r){for(const n of r)for(let r=0,i=n.length,s=i-1;r<i;s=r++)if($i(t,e,n[s],n[r]))return !0;return !1}function Hi(t,e){for(let r=0;r<t.length;++r)if(!ji(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Zi(t[r],t[r+1],e))return !1;return !0}function Ki(t,e){for(let r=0;r<e.length;r++)if(Hi(t,e[r]))return !0;return !1}function Wi(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=Yi(t[i][n],r);Fi(e,a),s.push(a);}n.push(s);}return n}function Ji(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Wi(t[i],e,r);n.push(s);}return n}function Qi(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Fi(e,t);}function ts(t,e,r,n){const i=Math.pow(2,n.z)*Gi,s=[n.x*Gi,n.y*Gi],a=[];if(!t)return a;for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Qi(n,e,r,i),a.push(n);}return a}function es(t,e,r,n){const i=Math.pow(2,n.z)*Gi,s=[n.x*Gi,n.y*Gi],a=[];if(!t)return a;for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Fi(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Qi(n,e,r,i);}var o;return a}class rs{constructor(t,e){this.type=ti,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(xi(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new rs(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new rs(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new rs(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Wi(e.coordinates,n,i),a=ts(t.geometry(),r,n,i);if(!Ui(r,n))return !1;for(const t of a)if(!ji(t,s))return !1}if("MultiPolygon"===e.type){const s=Ji(e.coordinates,n,i),a=ts(t.geometry(),r,n,i);if(!Ui(r,n))return !1;for(const t of a)if(!Xi(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=Wi(e.coordinates,n,i),a=es(t.geometry(),r,n,i);if(!Ui(r,n))return !1;for(const t of a)if(!Hi(t,s))return !1}if("MultiPolygon"===e.type){const s=Ji(e.coordinates,n,i),a=es(t.geometry(),r,n,i);if(!Ui(r,n))return !1;for(const t of a)if(!Ki(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}const ns={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},is=1/298.257223563,ss=is*(2-is),as=Math.PI/180;class os{static fromTile(t,e,r){const n=Math.PI*(1-2*(t+.5)/Math.pow(2,e)),i=Math.atan(.5*(Math.exp(n)-Math.exp(-n)))/as;return new os(i,r)}static get units(){return ns}constructor(t,e){if(void 0===t)throw new Error("No latitude given.");if(e&&!ns[e])throw new Error(`Unknown unit ${e}. Use one of: ${Object.keys(ns).join(", ")}`);const r=6378.137*as*(e?ns[e]:1),n=Math.cos(t*as),i=1/(1-ss*(1-n*n)),s=Math.sqrt(i);this.kx=r*s*n,this.ky=r*s*i*(1-ss);}distance(t,e){const r=cs(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}bearing(t,e){const r=cs(e[0]-t[0])*this.kx;return Math.atan2(r,(e[1]-t[1])*this.ky)/as}destination(t,e,r){const n=r*as;return this.offset(t,Math.sin(n)*e,Math.cos(n)*e)}offset(t,e,r){return [t[0]+e/this.kx,t[1]+r/this.ky]}lineDistance(t){let e=0;for(let r=0;r<t.length-1;r++)e+=this.distance(t[r],t[r+1]);return e}area(t){let e=0;for(let r=0;r<t.length;r++){const n=t[r];for(let t=0,i=n.length,s=i-1;t<i;s=t++)e+=cs(n[t][0]-n[s][0])*(n[t][1]+n[s][1])*(r?-1:1);}return Math.abs(e)/2*this.kx*this.ky}along(t,e){let r=0;if(e<=0)return t[0];for(let n=0;n<t.length-1;n++){const i=t[n],s=t[n+1],a=this.distance(i,s);if(r+=a,r>e)return us(i,s,(e-(r-a))/a)}return t[t.length-1]}pointToSegmentDistance(t,e,r){let[n,i]=e,s=cs(r[0]-n)*this.kx,a=(r[1]-i)*this.ky;if(0!==s||0!==a){const e=(cs(t[0]-n)*this.kx*s+(t[1]-i)*this.ky*a)/(s*s+a*a);e>1?(n=r[0],i=r[1]):e>0&&(n+=s/this.kx*e,i+=a/this.ky*e);}return s=cs(t[0]-n)*this.kx,a=(t[1]-i)*this.ky,Math.sqrt(s*s+a*a)}pointOnLine(t,e){let r=1/0,n=t[0][0],i=t[0][1],s=0,a=0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=cs(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(cs(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=cs(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<r&&(r=f,n=l,i=u,s=o,a=p);}return {point:[n,i],index:s,t:Math.max(0,Math.min(1,a))}}lineSlice(t,e,r){let n=this.pointOnLine(r,t),i=this.pointOnLine(r,e);if(n.index>i.index||n.index===i.index&&n.t>i.t){const t=n;n=i,i=t;}const s=[n.point],a=n.index+1,o=i.index;!ls(r[a],s[0])&&a<=o&&s.push(r[a]);for(let t=a+1;t<=o;t++)s.push(r[t]);return ls(r[o],i.point)||s.push(i.point),s}lineSliceAlong(t,e,r){let n=0;const i=[];for(let s=0;s<r.length-1;s++){const a=r[s],o=r[s+1],l=this.distance(a,o);if(n+=l,n>t&&0===i.length&&i.push(us(a,o,(t-(n-l))/l)),n>=e)return i.push(us(a,o,(e-(n-l))/l)),i;n>t&&i.push(o);}return i}bufferPoint(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[0]+n,t[1]+r]}bufferBBox(t,e){const r=e/this.ky,n=e/this.kx;return [t[0]-n,t[1]-r,t[2]+n,t[3]+r]}insideBBox(t,e){return cs(t[0]-e[0])>=0&&cs(t[0]-e[2])<=0&&t[1]>=e[1]&&t[1]<=e[3]}}function ls(t,e){return t[0]===e[0]&&t[1]===e[1]}function us(t,e,r){const n=cs(e[0]-t[0]);return [t[0]+n*r,t[1]+(e[1]-t[1])*r]}function cs(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}class hs{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}var ps=8192;function fs(t,e){return e.dist-t.dist}const ds=100,ms=50;function ys(t){const e=[1/0,1/0,-1/0,-1/0];if(e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(e[r]!==t[r])return !1;return !0}function gs(t){return t[1]-t[0]+1}function xs(t,e){const r=t[1]>=t[0]&&t[1]<e;return r||console.warn("Distance Expression: Index is out of range"),r}function bs(t,e){if(t[0]>t[1])return [null,null];const r=gs(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}{if(1===r)return [t,null];const e=Math.floor(r/2)-1;return [[t[0],t[0]+e],[t[0]+e+1,t[1]]]}}function vs(t,e){const r=[1/0,1/0,-1/0,-1/0];if(!xs(e,t.length))return r;for(let n=e[0];n<=e[1];++n)Fi(r,t[n]);return r}function _s(t){const e=[1/0,1/0,-1/0,-1/0];for(let r=0;r<t.length;++r)for(let n=0;n<t[r].length;++n)Fi(e,t[r][n]);return e}function ws(t,e,r){if(ys(t)||ys(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function Ms(t){return 360*t-180}function As(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Ss(t,e){const r=Math.pow(2,e.z),n=(t.y/ps+e.y)/r;return [Ms((t.x/ps+e.x)/r),As(n)]}function Is(t,e){const r=[];for(let n=0;n<t.length;++n)r.push(Ss(t[n],e));return r}function Ts(t,e,r){const n=r.pointOnLine(e,t).point;return r.distance(t,n)}function ks(t,e,r,n,i){const s=r.slice(n[0],n[1]+1);let a=1/0;for(let r=e[0];r<=e[1];++r)if(0===(a=Math.min(a,Ts(t[r],s,i))))return 0;return a}function Ps(t,e,r,n,i){const s=Math.min(i.pointToSegmentDistance(t,r,n),i.pointToSegmentDistance(e,r,n)),a=Math.min(i.pointToSegmentDistance(r,t,e),i.pointToSegmentDistance(n,t,e));return Math.min(s,a)}function zs(t,e,r,n,i){if(!xs(e,t.length)||!xs(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<e[1];++a)for(let e=n[0];e<n[1];++e){if($i(t[a],t[a+1],r[e],r[e+1]))return 0;s=Math.min(s,Ps(t[a],t[a+1],r[e],r[e+1],i));}return s}function Es(t,e,r,n,i){if(!xs(e,t.length)||!xs(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(0===(s=Math.min(s,i.distance(t[a],r[e]))))return s;return s}function Bs(t,e,r){if(ji(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i.length;if(e<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(i[0]!==i[e-1]&&0===(n=Math.min(n,r.pointToSegmentDistance(t,i[e-1],i[0]))))return n;if(0===(n=Math.min(n,Ts(t,i,r))))return n}return n}function Ds(t,e,r,n){if(!xs(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(ji(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s)for(const e of r)for(let r=0,a=e.length,o=a-1;r<a;o=r++){if($i(t[s],t[s+1],e[o],e[r]))return 0;i=Math.min(i,Ps(t[s],t[s+1],e[o],e[r],n));}return i}function Cs(t,e){for(const r of t)for(let t=0;t<=r.length-1;++t)if(ji(r[t],e,!0))return !0;return !1}function Rs(t,e,r,n=1/0){const i=_s(t),s=_s(e);if(n!==1/0&&ws(i,s,r)>=n)return n;if(Ui(i,s)){if(Cs(t,e))return 0}else if(Cs(e,t))return 0;let a=n;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++)for(const i of e)for(let e=0,o=i.length,l=o-1;e<o;l=e++){if($i(n[s],n[t],i[l],i[e]))return 0;a=Math.min(a,Ps(n[s],n[t],i[l],i[e],r));}return a}function Vs(t,e,r,n,i,s,a){if(null===s||null===a)return;const o=ws(vs(n,s),vs(i,a),r);o<e&&t.push({dist:o,range1:s,range2:a});}function Ls(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new hs([{dist:0,range1:[0,t.length-1],range2:[0,0]}],fs),o=e?ms:ds,l=_s(r);for(;a.length;){const i=a.pop();if(i.dist>=s)continue;const u=i.range1;if(gs(u)<=o){if(!xs(u,t.length))return NaN;if(e){const e=Ds(t,u,r,n);if(0===(s=Math.min(s,e)))return s}else for(let e=u[0];e<=u[1];++e){const i=Bs(t[e],r,n);if(0===(s=Math.min(s,i)))return s}}else {const r=bs(u,e);if(null!==r[0]){const e=ws(vs(t,r[0]),l,n);e<s&&a.push({dist:e,range1:r[0],range2:[0,0]});}if(null!==r[1]){const e=ws(vs(t,r[1]),l,n);e<s&&a.push({dist:e,range1:r[1],range2:[0,0]});}}}return s}function Os(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new hs([{dist:0,range1:[0,t.length-1],range2:[0,r.length-1]}],fs),l=e?ms:ds,u=n?ms:ds;for(;o.length;){const s=o.pop();if(s.dist>=a)continue;const c=s.range1,h=s.range2;if(gs(c)<=l&&gs(h)<=u){if(!xs(c,t.length)||!xs(h,r.length))return NaN;if(e&&n?a=Math.min(a,zs(t,c,r,h,i)):e||n?e&&!n?a=Math.min(a,ks(r,h,t,c,i)):!e&&n&&(a=Math.min(a,ks(t,c,r,h,i))):a=Math.min(a,Es(t,c,r,h,i)),0===a)return a}else {const s=bs(c,e),l=bs(h,n);Vs(o,a,i,t,r,s[0],l[0]),Vs(o,a,i,t,r,s[0],l[1]),Vs(o,a,i,t,r,s[1],l[0]),Vs(o,a,i,t,r,s[1],l[1]);}}return a}function Fs(t,e,r,n,i=1/0){let s=i;const a=vs(t,[0,t.length-1]);for(const i of r)if(!(s!==1/0&&ws(a,vs(i,[0,i.length-1]),n)>=s)&&(s=Math.min(s,Os(t,e,i,!0,n,s)),0===s))return s;return s}function Us(t,e,r,n,i=1/0){let s=i;const a=vs(t,[0,t.length-1]);for(const i of r){if(s!==1/0&&ws(a,_s(i),n)>=s)continue;const r=Ls(t,e,i,n,s);if(isNaN(r))return r;if(0===(s=Math.min(s,r)))return s}return s}function Ns(t){return "Point"===t||"MultiPoint"===t||"LineString"===t||"MultiLineString"===t||"Polygon"===t||"MultiPolygon"===t}class js{constructor(t,e){this.type=Jn,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires either one argument, but found ' ${t.length-1} instead.`);if(xi(t[1])){const e=t[1];if("FeatureCollection"===e.type){for(let t=0;t<e.features.length;++t)if(Ns(e.features[t].geometry.type))return new js(e,e.features[t].geometry)}else if("Feature"===e.type){if(Ns(e.geometry.type))return new js(e,e.geometry)}else if(Ns(e.type))return new js(e,e)}return e.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(t){const e=t.geometry(),r=t.canonicalID();if(null!=e&&null!=r){if("Point"===t.geometryType())return function(t,e,r){const n=[];for(const r of t)for(const t of r)n.push(Ss(t,e));const i=new os(n[0][1],"meters");return "Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type?Os(n,!1,"Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,i):"MultiLineString"===r.type?Fs(n,!1,r.coordinates,i):"Polygon"===r.type||"MultiPolygon"===r.type?Us(n,!1,"Polygon"===r.type?[r.coordinates]:r.coordinates,i):null}(e,r,this.geometries);if("LineString"===t.geometryType())return function(t,e,r){const n=[];for(const r of t){const t=[];for(const n of r)t.push(Ss(n,e));n.push(t);}const i=new os(n[0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return Fs("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=Fs(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}if("Polygon"===r.type||"MultiPolygon"===r.type){let t=1/0;for(let e=0;e<n.length;e++){const s=Us(n[e],!0,"Polygon"===r.type?[r.coordinates]:r.coordinates,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return null}(e,r,this.geometries);if("Polygon"===t.geometryType())return function(t,e,r){const n=[];for(const r of function(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=Oi(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}return i&&n.push(i),n}(t)){const t=[];for(let n=0;n<r.length;++n)t.push(Is(r[n],e));n.push(t);}const i=new os(n[0][0][0][1],"meters");if("Point"===r.type||"MultiPoint"===r.type||"LineString"===r.type)return Us("Point"===r.type?[r.coordinates]:r.coordinates,"LineString"===r.type,n,i);if("MultiLineString"===r.type){let t=1/0;for(let e=0;e<r.coordinates.length;e++){const s=Us(r.coordinates[e],!0,n,i,t);if(isNaN(s))return s;if(0===(t=Math.min(t,s)))return t}return t}return "Polygon"===r.type||"MultiPolygon"===r.type?function(t,e,r){let n=1/0;for(const i of t)for(const t of e){const e=Rs(i,t,r,n);if(isNaN(e))return e;if(0===(n=Math.min(n,e)))return n}return n}("Polygon"===r.type?[r.coordinates]:r.coordinates,n,i):null}(e,r,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.");}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return !0}serialize(){return ["distance",this.geojson]}}function qs(t,e){switch(t){case"string":return vi(e);case"number":return +e;case"boolean":return !!e;case"color":return qn.parse(e);case"formatted":return mi.fromString(vi(e));case"resolvedImage":return yi.fromString(vi(e))}return e}function $s(t,e,r,n){return void 0!==n&&(t=n*Math.round(t/n)),void 0!==e&&t<e&&(t=e),void 0!==r&&t>r&&(t=r),t}class Gs{constructor(t,e,r){this.type=t,this.key=e,this.scope=r;}static parse(t,e){let r=e.expectedType;if(null==r&&(r=ni),t.length<2||t.length>3)return e.error("Invalid number of arguments for 'config' expression.");const n=e.parse(t[1],1);if(!(n instanceof _i))return e.error("Key name of 'config' expression must be a string literal.");if(t.length>=3){const i=e.parse(t[2],2);return i instanceof _i?new Gs(r,vi(n.value),vi(i.value)):e.error("Scope of 'config' expression must be a string literal.")}return new Gs(r,vi(n.value))}evaluate(t){const e=[this.key,this.scope,t.scope].filter(Boolean).join(""),r=t.getConfig(e);if(!r)return null;const{type:n,value:i,values:s,minValue:a,maxValue:o,stepValue:l}=r,u=r.default.evaluate(t);let c=u;if(i){const e=t.scope;t.scope=(e||"").split("").slice(1).join(""),c=i.evaluate(t),t.scope=e;}return n&&(c=qs(n,c)),void 0===c||void 0===a&&void 0===o&&void 0===l||("number"==typeof c?c=$s(c,a,o,l):Array.isArray(c)&&(c=c.map((t=>"number"==typeof t?$s(t,a,o,l):t)))),void 0!==i&&void 0!==c&&s&&!s.includes(c)&&(c=u,n&&(c=qs(n,c))),(n&&n!==this.type||void 0!==c&&bi(c)!==this.type)&&(c=qs(this.type.kind,c)),c}eachChild(){}outputDefined(){return !1}serialize(){const t=["config",this.key];return this.scope&&t.concat(this.key),t}}function Ys(t){if(t instanceof Bi){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof rs)return !1;if(t instanceof js)return !1;let e=!0;return t.eachChild((t=>{e&&!Ys(t)&&(e=!1);})),e}function Xs(t){if(t instanceof Bi&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!Xs(t)&&(e=!1);})),e}function Zs(t){if(t instanceof Gs)return !1;let e=!0;return t.eachChild((t=>{e&&!Zs(t)&&(e=!1);})),e}function Hs(t,e){if(t instanceof Bi&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Hs(t,e)&&(r=!1);})),r}class Ks{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Ks(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class Ws{constructor(t,e=[],r,n=new Kn,i=[],s,a){this.registry=t,this.path=e,this.key=e.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r,this._scope=s,this.options=a;}parse(t,e,r,n,i={}){return e||r?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Ai(e,[t]):"coerce"===r?new Pi(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n="string"==typeof t[0]?this.registry[t[0]]:void 0;if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof _i)&&"resolvedImage"!==i.type.kind&&Qs(i)){const t=new Ei(this._scope,this.options);try{i=new _i(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return Pi.parse(["to-array",t],this)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Ws(this.registry,n,e||null,i,this.errors,this._scope,this.options)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Hn(r,t));}checkSubtype(t,e){const r=ci(t,e);return r&&this.error(r),r}}var Js=Ws;function Qs(t){if(t instanceof Ks)return Qs(t.boundExpression);if(t instanceof Bi&&"error"===t.name)return !1;if(t instanceof Ci)return !1;if(t instanceof rs)return !1;if(t instanceof js)return !1;if(t instanceof Gs)return !1;const e=t instanceof Pi||t instanceof Ai;let r=!0;return t.eachChild((t=>{r=e?r&&Qs(t):r&&t instanceof _i;})),!!r&&Ys(t)&&Hs(t,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light","raster-particle-speed"])}function ta(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new wi("Input is not a number.");a=o-1;}return 0}class ea{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Jn);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new ea(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[ta(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}const ra=.95047,na=1.08883,ia=4/29,sa=6/29,aa=3*sa*sa,oa=sa*sa*sa,la=Math.PI/180,ua=180/Math.PI;function ca(t){return t>oa?Math.pow(t,1/3):t/aa+ia}function ha(t){return t>sa?t*t*t:aa*(t-ia)}function pa(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function fa(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function da(t){const e=fa(t.r),r=fa(t.g),n=fa(t.b),i=ca((.4124564*e+.3575761*r+.1804375*n)/ra),s=ca((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-ca((.0193339*e+.119192*r+.9503041*n)/na)),alpha:t.a}}function ma(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*ha(e),r=ra*ha(r),n=na*ha(n),new qn(pa(3.2404542*r-1.5371385*e-.4985314*n),pa(-.969266*r+1.8760108*e+.041556*n),pa(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function ya(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const ga={forward:da,reverse:ma,interpolate:function(t,e,r){return {l:Gn(t.l,e.l,r),a:Gn(t.a,e.a,r),b:Gn(t.b,e.b,r),alpha:Gn(t.alpha,e.alpha,r)}}},xa={forward:function(t){const{l:e,a:r,b:n}=da(t),i=Math.atan2(n,r)*ua;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*la,r=t.c;return ma({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:ya(t.h,e.h,r),c:Gn(t.c,e.c,r),l:Gn(t.l,e.l,r),alpha:Gn(t.alpha,e.alpha,r)}}};var ba=Object.freeze({__proto__:null,hcl:xa,lab:ga});class va{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=_a(e,t.base,r,n);else if("linear"===t.name)i=_a(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new Oe(s[0],s[1],s[2],s[3]).solve(_a(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Jn),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=ei:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new va(o,r,n,i,a):e.error(`Type ${li(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=ta(e,n),a=va.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?Xn[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?xa.reverse(xa.interpolate(xa.forward(o),xa.forward(l),a)):ga.reverse(ga.interpolate(ga.forward(o),ga.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function _a(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class wa{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>ci(n,t.type)));return new wa(s?ni:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof yi&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Ma{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Ma(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class Aa{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Jn),n=e.parse(t[2],2,oi(e.expectedType||ni));return r&&n?new Aa(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new wi(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new wi(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new wi(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class Sa{constructor(t,e){this.type=ti,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ni),n=e.parse(t[2],2,ni);return r&&n?hi(r.type,[ti,Qn,Jn,Wn,ni])?new Sa(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${li(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!pi(e,["boolean","string","number","null"]))throw new wi(`Expected first argument to be of type boolean, string, number or null, but found ${li(bi(e))} instead.`);if(!pi(r,["string","array"]))throw new wi(`Expected second argument to be of type array or string, but found ${li(bi(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class Ia{constructor(t,e,r){this.type=Jn,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ni),n=e.parse(t[2],2,ni);if(!r||!n)return null;if(!hi(r.type,[ti,Qn,Jn,Wn,ni]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${li(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Jn);return i?new Ia(r,n,i):null}return new Ia(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!pi(e,["boolean","string","number","null"]))throw new wi(`Expected first argument to be of type boolean, string, number or null, but found ${li(bi(e))} instead.`);if(!pi(r,["string","array"]))throw new wi(`Expected second argument to be of type array or string, but found ${li(bi(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class Ta{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,bi(t)))return null}else r=bi(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,ni);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new Ta(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (bi(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class ka{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,ti);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new ka(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}class Pa{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ni),n=e.parse(t[2],2,Jn);if(!r||!n)return null;if(!hi(r.type,[oi(ni),Qn,ni]))return e.error(`Expected first argument to be of type array or string, but found ${li(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Jn);return i?new Pa(r.type,r,n,i):null}return new Pa(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!pi(e,["string","array"]))throw new wi(`Expected first argument to be of type array or string, but found ${li(bi(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function za(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Ea(t,e,r,n){return 0===n.compare(e,r)}function Ba(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=ti,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,ni);if(!s)return null;if(!za(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${li(s.type)}'.`);let a=e.parse(t[2],2,ni);if(!a)return null;if(!za(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${li(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${li(s.type)}' and '${li(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Ai(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Ai(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,ii),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=bi(s),r=bi(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new wi(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=bi(s),r=bi(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const Da=Ba("==",(function(t,e,r){return e===r}),Ea),Ca=Ba("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !Ea(0,e,r,n)})),Ra=Ba("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),Va=Ba(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),La=Ba("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),Oa=Ba(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class Fa{constructor(t,e,r,n,i,s){this.type=Qn,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=s;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Jn);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Qn),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Qn),!s))return null;let a=null;if(n.unit&&(a=e.parse(n.unit,1,Qn),!a))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parse(n["min-fraction-digits"],1,Jn),!o))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parse(n["max-fraction-digits"],1,Jn),!l)?null:new Fa(r,i,s,a,o,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Ua{constructor(t){this.type=Jn,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${li(r.type)} instead.`):new Ua(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new wi(`Expected value to be of type string or array, but found ${li(bi(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}function Na(t){return function(){t=1831565813+(t|=0)|0;let e=Math.imul(t^t>>>15,1|t);return e=e+Math.imul(e^e>>>7,61|e)^e,((e^e>>>14)>>>0)/4294967296}}const ja={"==":Da,"!=":Ca,">":Va,"<":Ra,">=":Oa,"<=":La,array:Ai,at:Aa,boolean:Ai,case:ka,coalesce:wa,collator:Ci,format:Si,image:Ii,in:Sa,"index-of":Ia,interpolate:va,"interpolate-hcl":va,"interpolate-lab":va,length:Ua,let:Ma,literal:_i,match:Ta,number:Ai,"number-format":Fa,object:Ai,slice:Pa,step:ea,string:Ai,"to-boolean":Pi,"to-color":Pi,"to-number":Pi,"to-string":Pi,var:Ks,within:rs,distance:js,config:Gs};function qa(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=gi(e,r,n,s);if(a)throw new wi(a);return new qn(e/255*s,r/255*s,n/255*s,s)}function $a(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=function(t,e,r,n){return "number"==typeof t&&t>=0&&t<=360?"number"==typeof e&&e>=0&&e<=100&&"number"==typeof r&&r>=0&&r<=100?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid hsla value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'h' must be between 0 and 360.`}(e,r,n,s);if(a)throw new wi(a);const o=`hsla(${e}, ${r}%, ${n}%, ${s})`,l=qn.parse(o);if(!l)throw new wi(`Failed to parse HSLA color: ${o}`);return l}function Ga(t,e){return t in e}function Ya(t,e){const r=e[t];return void 0===r?null:r}function Xa(t){return {type:t}}function Za(t){return {result:"success",value:t}}function Ha(t){return {result:"error",value:t}}function Ka(t,e){return !!t&&!!t.parameters&&t.parameters.indexOf(e)>-1}function Wa(t){return "data-driven"===t["property-type"]}function Ja(t){return Ka(t.expression,"measure-light")}function Qa(t){return Ka(t.expression,"zoom")}function to(t){return !!t.expression&&t.expression.interpolated}function eo(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function ro(t){return t}function no(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(to(e)?"exponential":"interval");if(r&&((t=Zn({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],qn.parse(t[1])]))),t.default=qn.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!ba[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let a,o,l;if("exponential"===s)a=oo;else if("interval"===s)a=ao;else if("categorical"===s){a=so,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=lo;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,no(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:va.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>oo({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:va.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?io(t.default,e.default):a(t,e,i,o,l)}}}function io(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function so(t,e,r,n,i){return io(typeof r===i?n[r]:void 0,t.default,e.default)}function ao(t,e,r){if("number"!==Ti(r))return io(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=ta(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function oo(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Ti(r))return io(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=ta(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=Xn[e.type]||ro;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=ba[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function lo(t,e,r){return "color"===e.type?r=qn.parse(r):"formatted"===e.type?r=mi.fromString(r.toString()):"resolvedImage"===e.type?r=yi.fromString(r.toString()):Ti(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),io(r,t.default,e.default)}Bi.register(ja,{error:[{kind:"error"},[Qn],(t,[e])=>{throw new wi(e.evaluate(t))}],typeof:[Qn,[ni],(t,[e])=>li(bi(e.evaluate(t)))],"to-rgba":[oi(Jn,4),[ei],(t,[e])=>e.evaluate(t).toRenderColor(null).toArray()],rgb:[ei,[Jn,Jn,Jn],qa],rgba:[ei,[Jn,Jn,Jn,Jn],qa],hsl:[ei,[Jn,Jn,Jn],$a],hsla:[ei,[Jn,Jn,Jn,Jn],$a],has:{type:ti,overloads:[[[Qn],(t,[e])=>Ga(e.evaluate(t),t.properties())],[[Qn,ri],(t,[e,r])=>Ga(e.evaluate(t),r.evaluate(t))]]},get:{type:ni,overloads:[[[Qn],(t,[e])=>Ya(e.evaluate(t),t.properties())],[[Qn,ri],(t,[e,r])=>Ya(e.evaluate(t),r.evaluate(t))]]},"feature-state":[ni,[Qn],(t,[e])=>Ya(e.evaluate(t),t.featureState||{})],properties:[ri,[],t=>t.properties()],"geometry-type":[Qn,[],t=>t.geometryType()],id:[ni,[],t=>t.id()],zoom:[Jn,[],t=>t.globals.zoom],pitch:[Jn,[],t=>t.globals.pitch||0],"distance-from-center":[Jn,[],t=>t.distanceFromCenter()],"measure-light":[Jn,[Qn],(t,[e])=>t.measureLight(e.evaluate(t))],"heatmap-density":[Jn,[],t=>t.globals.heatmapDensity||0],"line-progress":[Jn,[],t=>t.globals.lineProgress||0],"raster-value":[Jn,[],t=>t.globals.rasterValue||0],"raster-particle-speed":[Jn,[],t=>t.globals.rasterParticleSpeed||0],"sky-radial-progress":[Jn,[],t=>t.globals.skyRadialProgress||0],accumulated:[ni,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Jn,Xa(Jn),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Jn,Xa(Jn),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Jn,overloads:[[[Jn,Jn],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Jn],(t,[e])=>-e.evaluate(t)]]},"/":[Jn,[Jn,Jn],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Jn,[Jn,Jn],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Jn,[],()=>Math.LN2],pi:[Jn,[],()=>Math.PI],e:[Jn,[],()=>Math.E],"^":[Jn,[Jn,Jn],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Jn,[Jn],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Jn,[Jn],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Jn,[Jn],(t,[e])=>Math.log(e.evaluate(t))],log2:[Jn,[Jn],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Jn,[Jn],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Jn,[Jn],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Jn,[Jn],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Jn,[Jn],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Jn,[Jn],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Jn,[Jn],(t,[e])=>Math.atan(e.evaluate(t))],min:[Jn,Xa(Jn),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Jn,Xa(Jn),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Jn,[Jn],(t,[e])=>Math.abs(e.evaluate(t))],round:[Jn,[Jn],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Jn,[Jn],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Jn,[Jn],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[ti,[Qn,ni],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[ti,[ni],(t,[e])=>t.id()===e.value],"filter-type-==":[ti,[Qn],(t,[e])=>t.geometryType()===e.value],"filter-<":[ti,[Qn,ni],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[ti,[ni],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[ti,[Qn,ni],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[ti,[ni],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[ti,[Qn,ni],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[ti,[ni],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[ti,[Qn,ni],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[ti,[ni],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[ti,[ni],(t,[e])=>e.value in t.properties()],"filter-has-id":[ti,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[ti,[oi(Qn)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[ti,[oi(ni)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[ti,[Qn,oi(ni)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[ti,[Qn,oi(ni)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:ti,overloads:[[[ti,ti],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Xa(ti),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:ti,overloads:[[[ti,ti],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Xa(ti),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[ti,[ti],(t,[e])=>!e.evaluate(t)],"is-supported-script":[ti,[Qn],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Qn,[Qn],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Qn,[Qn],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Qn,Xa(ni),(t,e)=>e.map((e=>vi(e.evaluate(t)))).join("")],"resolved-locale":[Qn,[ii],(t,[e])=>e.evaluate(t).resolvedLocale()],random:[Jn,[Jn,Jn,ni],(t,e)=>{const[r,n,i]=e.map((e=>e.evaluate(t)));if(r>n)return r;if(r===n)return r;let s;if("string"==typeof i)s=function(t){let e=0;if(0===t.length)return e;for(let r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r),e|=0;return e}(i);else {if("number"!=typeof i)throw new wi(`Invalid seed input: ${i}`);s=i;}return r+Na(s)()*(n-r)}]});class uo{constructor(t,e,r,n){this.expression=t,this._warningHistory={},this._evaluator=new Ei(r,n),this._defaultValue=e?function(t){return "color"===t.type&&(eo(t.default)||Array.isArray(t.default))?new qn(0,0,0,0):"color"===t.type?qn.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s,a,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,a,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new wi(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function co(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in ja}function ho(t,e,r,n){const i=new Js(ja,[],e?function(t){const e={color:ei,string:Qn,number:Jn,enum:Qn,boolean:ti,formatted:si,resolvedImage:ai};return "array"===t.type?oi(e[t.value]||ni,t.length):e[t.type]}(e):void 0,void 0,void 0,r,n),s=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return s?Za(new uo(s,e,r,n)):Ha(i.errors)}class po{constructor(t,e,r){this.kind=t,this._styleExpression=e,this.isLightConstant=r,this.isStateDependent="constant"!==t&&!Xs(e.expression),this.isConfigDependent=!Zs(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class fo{constructor(t,e,r,n,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Xs(e.expression),this.isLightConstant=i,this.isConfigDependent=!Zs(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?va.interpolationFactor(this.interpolationType,t,e,r):0}}function mo(t,e,r,n){if("error"===(t=ho(t,e,r,n)).result)return t;const i=t.value.expression,s=Ys(i);if(!s&&!Wa(e))return Ha([new Hn("","data expressions not supported")]);const a=Hs(i,["zoom","pitch","distance-from-center"]);if(!a&&!Qa(e))return Ha([new Hn("","zoom expressions not supported")]);const o=Hs(i,["measure-light"]);if(!o&&!Ja(e))return Ha([new Hn("","measure-light expression not supported")]);const l=e.expression&&e.expression.relaxZoomRestriction,u=go(i);return u||a||l?u instanceof Hn?Ha([u]):u instanceof va&&!to(e)?Ha([new Hn("",'"interpolate" expressions cannot be used with this property')]):Za(u?new fo(s?"camera":"composite",t.value,u.labels,u instanceof va?u.interpolation:void 0,o):new po(s?"constant":"source",t.value,o)):Ha([new Hn("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class yo{constructor(t,e){this._parameters=t,this._specification=e,Zn(this,no(this._parameters,this._specification));}static deserialize(t){return new yo(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function go(t){let e=null;if(t instanceof Ma)e=go(t.result);else if(t instanceof wa){for(const r of t.args)if(e=go(r),e)break}else (t instanceof ea||t instanceof va)&&t.input instanceof Bi&&"zoom"===t.input.name&&(e=t);return e instanceof Hn||t.eachChild((t=>{const r=go(t);r instanceof Hn?e=r:e&&r&&e!==r&&(e=new Hn("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}var xo=vo,bo=3;function vo(t,e,r){var n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(var s=0;s<this.d*this.d;s++){var a=i[bo+s],o=i[bo+s+1];n.push(a===o?null:i.subarray(a,o));}var l=i[bo+n.length+1];this.keys=i.subarray(i[bo+n.length],l),this.bboxes=i.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}vo.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},vo.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},vo.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},vo.prototype.query=function(t,e,r,n,i){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},vo.prototype._queryCell=function(t,e,r,n,i,s,a,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var f=4*p;(o?o(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},vo.prototype._forEachCell=function(t,e,r,n,i,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,s,a,o))return}},vo.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},vo.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},vo.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=bo+this.cells.length+1+1,r=0,n=0;n<this.cells.length;n++)r+=this.cells[n].length;var i=new Int32Array(e+r+this.keys.length+this.bboxes.length);i[0]=this.extent,i[1]=this.n,i[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];i[bo+a]=s,i.set(o,s),s+=o.length;}return i[bo+t.length]=s,i.set(this.keys,s),i[bo+t.length+1]=s+=this.keys.length,i.set(this.bboxes,s),s+=this.bboxes.length,i.buffer};var _o=p(xo);const wo={};function Mo(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writable:!1}),wo[e]={klass:t,omit:r.omit||[]};}Mo(Object,"Object"),_o.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.add(r),{buffer:r}},_o.deserialize=function(t){return new _o(t.buffer)},Object.defineProperty(_o,"name",{value:"Grid"}),Mo(_o,"Grid"),Mo(qn,"Color"),Mo(Error,"Error"),Mo(mi,"Formatted"),Mo(di,"FormattedSection"),Mo(Jr,"AJAXError"),Mo(yi,"ResolvedImage"),Mo(yo,"StylePropertyFunction"),Mo(uo,"StyleExpression",{omit:["_evaluator"]}),Mo(fo,"ZoomDependentExpression"),Mo(po,"ZoomConstantExpression"),Mo(Bi,"CompoundExpression",{omit:["_evaluate"]});for(const t in ja)wo[ja[t]._classRegistryKey]||Mo(ja[t],`Expression${t}`);function Ao(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function So(t){return self.ImageBitmap&&t instanceof ImageBitmap}function Io(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Ao(t)||So(t))return e&&e.add(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.add(r.buffer),r}if(t instanceof ImageData)return e&&e.add(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Io(n,e));return r}if(t instanceof Map){const e={$name:"Map"};for(const[r,n]of t.entries())e[r]=Io(n);return e}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`can't serialize object of unregistered class ${n}`);const i=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t)t.hasOwnProperty(r)&&(wo[n].omit.indexOf(r)>=0||(i[r]=Io(t[r],e)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function To(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Ao(t)||So(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(To);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=new Map;for(const r of Object.keys(t))"$name"!==r&&e.set(r,To(t[r]));return e}const{klass:r}=wo[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=To(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const ko={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519,"CJK Unified Ideographs Extension B":t=>t>=131072&&t<=173791};function Po(t){for(const e of t)if(Bo(e.charCodeAt(0)))return !0;return !1}function zo(t){for(const e of t)if(!Eo(e.charCodeAt(0)))return !1;return !0}function Eo(t){return !(ko.Arabic(t)||ko["Arabic Supplement"](t)||ko["Arabic Extended-A"](t)||ko["Arabic Presentation Forms-A"](t)||ko["Arabic Presentation Forms-B"](t))}function Bo(t){return !(746!==t&&747!==t&&(t<4352||!(ko["Bopomofo Extended"](t)||ko.Bopomofo(t)||ko["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||ko["CJK Compatibility Ideographs"](t)||ko["CJK Compatibility"](t)||ko["CJK Radicals Supplement"](t)||ko["CJK Strokes"](t)||!(!ko["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||ko["CJK Unified Ideographs Extension A"](t)||ko["CJK Unified Ideographs"](t)||ko["Enclosed CJK Letters and Months"](t)||ko["Hangul Compatibility Jamo"](t)||ko["Hangul Jamo Extended-A"](t)||ko["Hangul Jamo Extended-B"](t)||ko["Hangul Jamo"](t)||ko["Hangul Syllables"](t)||ko.Hiragana(t)||ko["Ideographic Description Characters"](t)||ko.Kanbun(t)||ko["Kangxi Radicals"](t)||ko["Katakana Phonetic Extensions"](t)||ko.Katakana(t)&&12540!==t||!(!ko["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!ko["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||ko["Unified Canadian Aboriginal Syllabics"](t)||ko["Unified Canadian Aboriginal Syllabics Extended"](t)||ko["Vertical Forms"](t)||ko["Yijing Hexagram Symbols"](t)||ko["Yi Syllables"](t)||ko["Yi Radicals"](t))))}function Do(t){return !(Bo(t)||function(t){return !!(ko["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||ko["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||ko["Letterlike Symbols"](t)||ko["Number Forms"](t)||ko["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||ko["Control Pictures"](t)&&9251!==t||ko["Optical Character Recognition"](t)||ko["Enclosed Alphanumerics"](t)||ko["Geometric Shapes"](t)||ko["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||ko["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||ko["CJK Symbols and Punctuation"](t)||ko.Katakana(t)||ko["Private Use Area"](t)||ko["CJK Compatibility Forms"](t)||ko["Small Form Variants"](t)||ko["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function Co(t){return t>=1424&&t<=2303||ko["Arabic Presentation Forms-A"](t)||ko["Arabic Presentation Forms-B"](t)}function Ro(t,e){return !(!e&&Co(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||ko.Khmer(t))}function Vo(t){for(const e of t)if(Co(e.charCodeAt(0)))return !0;return !1}const Lo="deferred",Oo="loading",Fo="loaded";let Uo=null,No="unavailable",jo=null;const qo=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(No="error"),Uo&&Uo(t);};function $o(){Go.fire(new Dn("pluginStateChange",{pluginStatus:No,pluginURL:jo}));}const Go=new Ln,Yo=function(){return No},Xo=function(){if(No!==Lo||!jo)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");No=Oo,$o(),jo&&en({url:jo},(t=>{t?qo(t):(No=Fo,$o());}));},Zo={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>No===Fo||null!=Zo.applyArabicShaping,isLoading:()=>No===Oo,setState(t){No=t.pluginStatus,jo=t.pluginURL;},isParsed:()=>null!=Zo.applyArabicShaping&&null!=Zo.processBidirectionalText&&null!=Zo.processStyledBidirectionalText,getPluginURL:()=>jo};class Ho{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch,this.brightness=e.brightness):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!Ro(r.charCodeAt(0),e))return !1;return !0}(t,Zo.isLoaded())}}class Ko{constructor(t,e,r,n){this.property=t,this.value=e,this.expression=function(t,e,r,n){if(eo(t))return new yo(t,e);if(co(t)||Array.isArray(t)&&t.length>0){const i=mo(t,e,r,n);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=qn.parse(t)),{kind:"constant",isConfigDependent:!1,evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r,n);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Wo{constructor(t,e,r){this.property=t,this.value=new Ko(t,void 0,e,r);}transitioned(t,e){return new Qo(this.property,this.value,e,er({},t.transition,this.transition),t.now)}untransitioned(){return new Qo(this.property,this.value,null,{},0)}}class Jo{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._scope=e,this._options=r,this.isConfigDependent=!1;}getValue(t){return hr(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Wo(this._values[t].property,this._scope,this._options)),this._values[t].value=new Ko(this._values[t].property,null===e?void 0:hr(e),this._scope,this._options),this.isConfigDependent=this.isConfigDependent||this._values[t].value.expression.isConfigDependent;}setTransitionOrValue(t,e){e&&(this._options=e);const r=this._properties.properties;if(t)for(const e in t){const n=t[e];if(lr(e,"-transition")){const t=e.slice(0,-11);r[t]&&this.setTransition(t,n);}else r.hasOwnProperty(e)&&this.setValue(e,n);}}getTransition(t){return hr(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Wo(this._values[t].property)),this._values[t].transition=hr(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new tl(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new tl(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Qo{constructor(t,e,r,n,i){const s=n.delay||0,a=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+a,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,Xe(a))}}return i}}class tl{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new nl(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class el{constructor(t,e,r){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._scope=e,this._options=r,this.isConfigDependent=!1;}getValue(t){return hr(this._values[t].value)}setValue(t,e){this._values[t]=new Ko(this._values[t].property,null===e?void 0:hr(e),this._scope,this._options),this.isConfigDependent=this.isConfigDependent||this._values[t].expression.isConfigDependent;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new nl(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class rl{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class nl{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class il{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=Xn[this.specification.type];return n?n(t,e,r):t}}class sl{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new rl(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new rl(this,{kind:"constant",value:void 0},t.parameters);const n=Xn[this.specification.type];return n?new rl(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class al{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class ol{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new Ho(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Ko(n,void 0),s=this.defaultTransitionablePropertyValues[r]=new Wo(n);this.defaultTransitioningPropertyValues[r]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}Mo(sl,"DataDrivenProperty"),Mo(il,"DataConstantProperty"),Mo(al,"ColorRampProperty");var ll=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain","optional":true},"fog":{"type":"fog"},"camera":{"type":"camera"},"color-theme":{"type":"colorTheme"},"imports":{"type":"array","value":"import"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","property-type":"data-constant","expression":{},"required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"expression":{},"property-type":"data-constant"},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_raster_array","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_array":{"experimental":true,"type":{"required":true,"type":"enum","values":{"raster-array":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"rasterLayers":{"type":"*"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"},"dynamic":{"type":"boolean","default":false}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"raster-particle":{"experimental":true},"hillshade":{},"model":{"experimental":true},"background":{},"sky":{},"slot":{},"clip":{"experimental":true}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_clip","layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_raster-particle","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_clip":{"clip-layer-types":{"type":"array","value":"enum","values":{"model":1,"symbol":1},"default":[],"expression":{},"property-type":"data-constant","experimental":true}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","experimental":true,"private":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1,"none":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-z-offset":{"type":"number","experimental":true,"expression":{"parameters":["zoom","feature","line-progress"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster-particle":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"colorTheme":{"data":{"type":"string","property-type":"data-constant","expression":{}}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_raster-particle","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","experimental":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","experimental":true,"default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","experimental":true,"default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","experimental":true,"default":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","experimental":true,"default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","experimental":true,"default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"experimental":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"fill-extrusion-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-trim-fade-range":{"type":"array","value":"number","experimental":true,"length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-trim-color":{"type":"color","experimental":true,"default":"transparent","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-occlusion-opacity":{"type":"number","default":0,"minimum":0,"maximum":1,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"property-type":"data-constant"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-occlusion-opacity":{"type":"number","minimum":0,"maximum":1,"default":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-color-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"icon-color-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"raster-array-band":{"type":"string","required":false,"experimental":true,"property-type":"data-constant"},"raster-elevation":{"type":"number","default":0,"minimum":0,"transition":true,"experimental":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster-particle":{"raster-particle-array-band":{"type":"string","required":false,"property-type":"data-constant"},"raster-particle-count":{"type":"number","default":512,"minimum":1,"property-type":"data-constant"},"raster-particle-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-particle-speed"]},"property-type":"color-ramp"},"raster-particle-max-speed":{"type":"number","default":1,"minimum":1,"property-type":"data-constant"},"raster-particle-speed-factor":{"type":"number","default":0.2,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-fade-opacity-factor":{"type":"number","default":0.98,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-particle-reset-rate-factor":{"type":"number","default":0.8,"minimum":0,"maximum":1,"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"},"model-front-cutoff":{"type":"array","private":true,"value":"number","property-type":"data-constant","expression":{"interpolated":true,"parameters":["zoom"]},"length":3,"default":[0,0,1],"minimum":[0,0,0],"maximum":[1,1,1]}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');function ul(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function cl(t){if(Array.isArray(t))return t.map(cl);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=cl(t[r]);return e}return ul(t)}function hl(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!hl(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function pl(t,e="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};hl(t)||(t=bl(t));const r=t;let n=!0;try{n=function(t){if(!ml(t))return t;let e=cl(t);return dl(e),e=fl(e),e}(r);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(r,null,2)}\n        `);}const i=ll[`filter_${e}`],s=ho(n,i);let a=null;if("error"===s.result)throw new Error(s.value.map((t=>`${t.key}: ${t.message}`)).join(", "));a=(t,e,r)=>s.value.evaluate(t,e,{},r);let o=null,l=null;if(n!==r){const t=ho(r,i);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),l=!Ys(t.value.expression);}return {filter:a,dynamicFilter:o||void 0,needGeometry:xl(n),needFeature:!!l}}function fl(t){if(!Array.isArray(t))return t;const e=function(t){if(yl.has(t[0]))for(let e=1;e<t.length;e++)if(ml(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>fl(t)))}function dl(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||ml(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||ml(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||ml(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)dl(t[e]);}function ml(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(ml(t[e]))return !0;return !1}const yl=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function gl(t,e){return t<e?-1:t>e?1:0}function xl(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(xl(t[e]))return !0;return !1}function bl(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?vl(t[1],t[2],"=="):"!="===e?Ml(vl(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?vl(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(bl))):"all"===e?["all"].concat(t.slice(1).map(bl)):"none"===e?["all"].concat(t.slice(1).map(bl).map(Ml)):"in"===e?_l(t[1],t.slice(2)):"!in"===e?Ml(_l(t[1],t.slice(2))):"has"===e?wl(t[1]):"!has"!==e||Ml(wl(t[1]));var r;}function vl(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function _l(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(gl)]]:["filter-in-small",t,["literal",e]]}}function wl(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function Ml(t){return ["!",t]}const Al="";function Sl(t,e){return e?`${t}${Al}${e}`:t}const Il="-transition",Tl=new Set(["fill","line","background","hillshade","raster"]);class kl extends Ln{constructor(t,e,r,n,i){if(super(),this.id=t.id,this.fqid=Sl(this.id,r),this.type=t.type,this.scope=r,this.lut=n,this.options=i,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.isConfigDependent=!1,"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&"slot"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),t.slot&&(this.slot=t.slot),e.layout&&(this._unevaluatedLayout=new el(e.layout,this.scope,i),this.isConfigDependent=this.isConfigDependent||this._unevaluatedLayout.isConfigDependent),e.paint)){this._transitionablePaint=new Jo(e.paint,this.scope,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e]);for(const e in t.layout)this.setLayoutProperty(e,t.layout[e]);this.isConfigDependent=this.isConfigDependent||this._transitionablePaint.isConfigDependent,this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new nl(e.paint);}}onAdd(t){}onRemove(t){}isDraped(t){return Tl.has(this.type)}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e){if("custom"===this.type&&"visibility"===t)return void(this.visibility=e);const r=this._unevaluatedLayout;r._properties.properties[t]&&(r.setValue(t,e),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,"visibility"===t&&this.possiblyEvaluateVisibility());}possiblyEvaluateVisibility(){this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0});}getPaintProperty(t){return lr(t,Il)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e){const r=this._transitionablePaint,n=r._properties.properties;if(lr(t,Il)){const i=t.slice(0,-11);return n[i]&&r.setTransition(i,e||void 0),!1}if(!n[t])return !1;const i=r._values[t],s=i.value.isDataDriven(),a=i.value;r.setValue(t,e),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,this._handleSpecialPaintPropertyUpdate(t);const o=r._values[t].value,l=o.isDataDriven(),u=lr(t,"pattern")||"line-dasharray"===t;return l||s||u||this._handleOverridablePaintPropertyUpdate(t,a,o)}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getDefaultProgramParams(t,e,r){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){return cr({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}hasShadowPass(){return !1}canCastShadows(){return !1}hasLightBeamPass(){return !1}cutoffRange(){return 0}tileCoverLift(){return 0}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof rl&&Wa(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(){this._filterCompiled||(this._featureFilter=pl(this.filter),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}getLayerRenderingStats(){return this._stats}resetLayerRenderingStats(t){this._stats&&("shadow"===t.renderPass?this._stats.numRenderedVerticesInShadowPass=0:this._stats.numRenderedVerticesInTransparentPass=0);}queryRadius(t){}queryIntersectsFeature(t,e,r,n,i,s,a,o,l){}queryIntersectsMatchingFeature(t,e,r,n){}}const Pl={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class zl{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class El{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.add(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("StructArray#_refreshViews() must be implemented by each concrete StructArray layout")}emplace(...t){throw new Error("StructArray#emplace() must be implemented by each concrete StructArray layout")}emplaceBack(...t){throw new Error("StructArray#emplaceBack() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function Bl(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=Pl[t.type].BYTES_PER_ELEMENT,s=r=Dl(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:Dl(r,Math.max(n,e)),alignment:e}}function Dl(t,e){return Math.ceil(t/e)*e}class Cl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}Cl.prototype.bytesPerElement=4,Mo(Cl,"StructArrayLayout2i4");class Rl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Rl.prototype.bytesPerElement=6,Mo(Rl,"StructArrayLayout3i6");class Vl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Vl.prototype.bytesPerElement=8,Mo(Vl,"StructArrayLayout4i8");class Ll extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=5*t;return this.int16[a+0]=e,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,t}}Ll.prototype.bytesPerElement=10,Mo(Ll,"StructArrayLayout5i10");class Ol extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}Ol.prototype.bytesPerElement=12,Mo(Ol,"StructArrayLayout2i4ub1f12");class Fl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Fl.prototype.bytesPerElement=16,Mo(Fl,"StructArrayLayout4f16");class Ul extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ul.prototype.bytesPerElement=12,Mo(Ul,"StructArrayLayout3f12");class Nl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=6*t,o=3*t;return this.uint16[a+0]=e,this.uint16[a+1]=r,this.uint16[a+2]=n,this.uint16[a+3]=i,this.float32[o+2]=s,t}}Nl.prototype.bytesPerElement=12,Mo(Nl,"StructArrayLayout4ui1f12");class jl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,t}}jl.prototype.bytesPerElement=8,Mo(jl,"StructArrayLayout4ui8");class ql extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}ql.prototype.bytesPerElement=12,Mo(ql,"StructArrayLayout6i12");class $l extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}$l.prototype.bytesPerElement=24,Mo($l,"StructArrayLayout4i4ui4i24");class Gl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=10*t,l=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=a,t}}Gl.prototype.bytesPerElement=20,Mo(Gl,"StructArrayLayout3i3f20");class Yl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Yl.prototype.bytesPerElement=4,Mo(Yl,"StructArrayLayout1ul4");class Xl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Xl.prototype.bytesPerElement=4,Mo(Xl,"StructArrayLayout1f4");class Zl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Zl.prototype.bytesPerElement=4,Mo(Zl,"StructArrayLayout2ui4");class Hl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,s,a,o,l,u,c,h,p)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f){const d=20*t,m=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=s,this.float32[m+3]=a,this.float32[m+4]=o,this.float32[m+5]=l,this.float32[m+6]=u,this.int16[d+14]=c,this.uint32[m+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}Hl.prototype.bytesPerElement=40,Mo(Hl,"StructArrayLayout5i4f1i1ul2ui40");class Kl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=a,this.int16[l+7]=o,t}}Kl.prototype.bytesPerElement=16,Mo(Kl,"StructArrayLayout3i2i2i16");class Wl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}Wl.prototype.bytesPerElement=16,Mo(Wl,"StructArrayLayout2f1f2i16");class Jl extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=n,this.float32[a+2]=i,t}}Jl.prototype.bytesPerElement=12,Mo(Jl,"StructArrayLayout2ub2f12");class Ql extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Ql.prototype.bytesPerElement=6,Mo(Ql,"StructArrayLayout3ui6");class tu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v){const _=this.length;return this.resize(_+1),this.emplace(_,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_){const w=30*t,M=15*t,A=60*t;return this.int16[w+0]=e,this.int16[w+1]=r,this.int16[w+2]=n,this.float32[M+2]=i,this.float32[M+3]=s,this.uint16[w+8]=a,this.uint16[w+9]=o,this.uint32[M+5]=l,this.uint32[M+6]=u,this.uint32[M+7]=c,this.uint16[w+16]=h,this.uint16[w+17]=p,this.uint16[w+18]=f,this.float32[M+10]=d,this.float32[M+11]=m,this.uint8[A+48]=y,this.uint8[A+49]=g,this.uint8[A+50]=x,this.uint32[M+13]=b,this.int16[w+28]=v,this.uint8[A+58]=_,t}}tu.prototype.bytesPerElement=60,Mo(tu,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class eu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_,w,M,A,S,I,T,k,P,z,E,B,D){const C=this.length;return this.resize(C+1),this.emplace(C,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_,w,M,A,S,I,T,k,P,z,E,B,D)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_,w,M,A,S,I,T,k,P,z,E,B,D,C){const R=22*t,V=44*t,L=88*t;return this.float32[R+0]=e,this.float32[R+1]=r,this.int16[V+4]=n,this.int16[V+5]=i,this.int16[V+6]=s,this.int16[V+7]=a,this.int16[V+8]=o,this.int16[V+9]=l,this.int16[V+10]=u,this.int16[V+11]=c,this.int16[V+12]=h,this.uint16[V+13]=p,this.uint16[V+14]=f,this.uint16[V+15]=d,this.uint16[V+16]=m,this.uint16[V+17]=y,this.uint16[V+18]=g,this.uint16[V+19]=x,this.uint16[V+20]=b,this.uint16[V+21]=v,this.uint16[V+22]=_,this.uint16[V+23]=w,this.uint16[V+24]=M,this.uint16[V+25]=A,this.uint16[V+26]=S,this.uint16[V+27]=I,this.uint32[R+14]=T,this.float32[R+15]=k,this.float32[R+16]=P,this.float32[R+17]=z,this.float32[R+18]=E,this.float32[R+19]=B,this.float32[R+20]=D,this.uint8[L+84]=C,t}}eu.prototype.bytesPerElement=88,Mo(eu,"StructArrayLayout2f9i15ui1ul6f1ub88");class ru extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=5*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,this.float32[a+4]=s,t}}ru.prototype.bytesPerElement=20,Mo(ru,"StructArrayLayout5f20");class nu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=7*t;return this.float32[l+0]=e,this.float32[l+1]=r,this.float32[l+2]=n,this.float32[l+3]=i,this.float32[l+4]=s,this.float32[l+5]=a,this.float32[l+6]=o,t}}nu.prototype.bytesPerElement=28,Mo(nu,"StructArrayLayout7f28");class iu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}iu.prototype.bytesPerElement=8,Mo(iu,"StructArrayLayout2f8");class su extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}su.prototype.bytesPerElement=12,Mo(su,"StructArrayLayout1ul3ui12");class au extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}au.prototype.bytesPerElement=2,Mo(au,"StructArrayLayout1ui2");class ou extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m){const y=this.length;return this.resize(y+1),this.emplace(y,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y){const g=16*t;return this.float32[g+0]=e,this.float32[g+1]=r,this.float32[g+2]=n,this.float32[g+3]=i,this.float32[g+4]=s,this.float32[g+5]=a,this.float32[g+6]=o,this.float32[g+7]=l,this.float32[g+8]=u,this.float32[g+9]=c,this.float32[g+10]=h,this.float32[g+11]=p,this.float32[g+12]=f,this.float32[g+13]=d,this.float32[g+14]=m,this.float32[g+15]=y,t}}ou.prototype.bytesPerElement=64,Mo(ou,"StructArrayLayout16f64");class lu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=10*t,u=5*t;return this.uint16[l+0]=e,this.uint16[l+1]=r,this.uint16[l+2]=n,this.uint16[l+3]=i,this.float32[u+2]=s,this.float32[u+3]=a,this.float32[u+4]=o,t}}lu.prototype.bytesPerElement=20,Mo(lu,"StructArrayLayout4ui3f20");class uu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.int16[1*t+0]=e,t}}uu.prototype.bytesPerElement=2,Mo(uu,"StructArrayLayout1i2");class cu extends El{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint8[1*t+0]=e,t}}cu.prototype.bytesPerElement=1,Mo(cu,"StructArrayLayout1ub1");class hu extends zl{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}hu.prototype.size=40;class pu extends Hl{get(t){return new hu(this,t)}}Mo(pu,"CollisionBoxArray");class fu extends zl{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}fu.prototype.size=60;class du extends tu{get(t){return new fu(this,t)}}Mo(du,"PlacedSymbolArray");class mu extends zl{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(t){this._structArray.uint32[this._pos4+14]=t;}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(t){this._structArray.float32[this._pos4+18]=t;}get occlusionState(){return this._structArray.float32[this._pos4+19]}set occlusionState(t){this._structArray.float32[this._pos4+19]=t;}get occlusionOpacity(){return this._structArray.float32[this._pos4+20]}set occlusionOpacity(t){this._structArray.float32[this._pos4+20]=t;}get hasIconTextFit(){return this._structArray.uint8[this._pos1+84]}}mu.prototype.size=88;class yu extends eu{get(t){return new mu(this,t)}}Mo(yu,"SymbolInstanceArray");class gu extends Xl{getoffsetX(t){return this.float32[1*t+0]}}Mo(gu,"GlyphOffsetArray");class xu extends Cl{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}Mo(xu,"SymbolLineVertexArray");class bu extends zl{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}bu.prototype.size=12;class vu extends su{get(t){return new bu(this,t)}}Mo(vu,"FeatureIndexArray");class _u extends Zl{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}Mo(_u,"FillExtrusionCentroidArray");const wu=Bl([{name:"a_pos",components:2,type:"Int16"}],4),Mu=Bl([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class Au{constructor(t=[]){this.segments=t;}_prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>Au.MAX_VERTEX_ARRAY_LENGTH&&fr(`Max vertices per segment is ${Au.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>Au.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e,primitiveOffset:r,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}prepareSegment(t,e,r,n){return this._prepareSegment(t,e.length,r.length,n)}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new Au([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function Su(t,e){return 256*(t=Ke(Math.floor(t),0,255))+Ke(Math.floor(e),0,255)}Au.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Mo(Au,"SegmentVector");const Iu=Bl([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),Tu=Bl([{name:"a_dash",components:4,type:"Uint16"}]);class ku{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(Pu(t)),this.positions.push(e,r,n);}eachPosition(t,e){const r=Pu(t);let n=0,i=this.ids.length-1;for(;n<i;){const t=n+i>>1;this.ids[t]>=r?i=t:n=t+1;}for(;this.ids[n]===r;)e(this.positions[3*n],this.positions[3*n+1],this.positions[3*n+2]),n++;}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return zu(r,n,0,r.length-1),e&&(e.add(r.buffer),e.add(n.buffer)),{ids:r,positions:n}}static deserialize(t){const e=new ku;let r;e.ids=t.ids,e.positions=t.positions;for(const t of e.ids)t!==r&&e.uniqueIds.push(t),r=t;return e.indexed=!0,e}}function Pu(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:Bn(String(t))}function zu(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;Eu(t,s,a),Eu(e,3*s,3*a),Eu(e,3*s+1,3*a+1),Eu(e,3*s+2,3*a+2);}a-r<n-a?(zu(t,e,r,a),r=a+1):(zu(t,e,a+1,n),n=a);}}function Eu(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}Mo(ku,"FeaturePositionMap");class Bu{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}set(t,e,r){throw new Error("Uniform#set() must be implemented by each concrete Uniform")}}class Du extends Bu{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}}class Cu extends Bu{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class Ru extends Bu{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}}class Vu extends Bu{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}}class Lu extends Bu{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class Ou extends Bu{constructor(t){super(t),this.current=qn.transparent.toRenderColor(null);}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const Fu=new Float32Array(16);class Uu extends Bu{constructor(t){super(t),this.current=Fu;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}}const Nu=new Float32Array(9),ju=new Float32Array(4);class qu extends Bu{constructor(t){super(t),this.current=ju;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}}function $u(t){return [Su(255*t.r,255*t.g),Su(255*t.b,255*t.a)]}class Gu{constructor(t,e,r,n){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r,this.context=n;}setUniform(t,e,r,n,i){const s=n.constantOr(this.value);e.set(t,i,s instanceof qn?s.toRenderColor(this.context.lut):s);}getBinding(t,e){return "color"===this.type?new Ou(t):new Cu(t)}}class Yu{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.pixelRatio=1;}setConstantPatternPositions(t){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br);}setUniform(t,e,r,n,i){const s="u_pattern"===i||"u_dash"===i?this.pattern:"u_pixel_ratio"===i?this.pixelRatio:null;s&&e.set(t,i,s);}getBinding(t,e){return "u_pattern"===e||"u_dash"===e?new Lu(t):new Cu(t)}}class Xu{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s,a){const o=this.paintVertexArray.length,l=this.expression.evaluate(new Ho(0,{brightness:s}),e,{},i,n,a);this.paintVertexArray.resize(t),this._setPaintValue(o,t,l,this.context);}updatePaintArray(t,e,r,n,i,s,a){const o=this.expression.evaluate({zoom:0,brightness:a},r,n,void 0,i);this._setPaintValue(t,e,o,this.context);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=$u(r.toRenderColor(n.lut));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Zu{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.context=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s,a){const o=this.expression.evaluate(new Ho(this.context.zoom,{brightness:s}),e,{},i,n,a),l=this.expression.evaluate(new Ho(this.context.zoom+1,{brightness:s}),e,{},i,n,a),u=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(u,t,o,l,this.context);}updatePaintArray(t,e,r,n,i,s,a){const o=this.expression.evaluate({zoom:this.context.zoom,brightness:a},r,n,void 0,i),l=this.expression.evaluate({zoom:this.context.zoom+1,brightness:a},r,n,void 0,i);this._setPaintValue(t,e,o,l,this.context);}_setPaintValue(t,e,r,n,i){if("color"===this.type){const n=$u(r.toRenderColor(i.lut)),s=$u(r.toRenderColor(i.lut));for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const s=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,a=Ke(this.expression.interpolationFactor(s,this.context.zoom,this.context.zoom+1),0,1);e.set(t,i,a);}getBinding(t,e){return new Cu(t)}}class Hu{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?Tu:Iu).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n;}populatePaintArray(t,e,r,n){const i=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s,a){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r];if(!i)return;const{tl:s,br:a,pixelRatio:o}=i;for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,s[0],s[1],a[0],a[1],o);}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Ku{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[],this.context=e;const n=[];for(const i in t.paint._values){const s=t.paint.get(i);if(!r(i))continue;if(!(s instanceof rl&&Wa(s.property.specification)))continue;const a=Qu(i,t.type),o=s.value,l=s.property.specification.type,u=!!s.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind;if("constant"!==o.kind||h)if("source"===o.kind||h||c){const e=rc(i,l,"source");this.binders[i]=c?new Hu(o,a,l,e,t.id):new Xu(o,a,l,e),n.push(`/a_${i}`);}else {const t=rc(i,l,"composite");this.binders[i]=new Zu(o,a,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new Yu(o.value,a):new Gu(o.value,a,l,e),n.push(`/u_${i}`);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Xu||e instanceof Zu?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s,a){for(const o in this.binders){const l=this.binders[o];l.context=this.context,(l instanceof Xu||l instanceof Zu||l instanceof Hu)&&l.populatePaintArray(t,e,r,n,i,s,a);}}setConstantPatternPositions(t){for(const e in this.binders){const r=this.binders[e];r instanceof Yu&&r.setConstantPatternPositions(t);}}updatePaintArrays(t,e,r,n,i,s,a,o){let l=!1;const u=Object.keys(t),c=0!==u.length,h=c?u:e.uniqueIds;this.context.lut=i.lut;for(const u in this.binders){const p=this.binders[u];if(p.context=this.context,(p instanceof Xu||p instanceof Zu||p instanceof Hu)&&(!0===p.expression.isStateDependent||!1===p.expression.isLightConstant)){const f=i.paint.get(u);p.expression=f.value;for(const r of h){const i=t[r.toString()];e.eachPosition(r,((t,e,r)=>{const l=n.feature(t);p.updatePaintArray(e,r,l,i,s,a,o);}));}if(!c)for(const e of r.uniqueIds){const i=t[e.toString()];r.eachPosition(e,((t,e,r)=>{const l=n.feature(t);p.updatePaintArray(e,r,l,i,s,a,o);}));}l=!0;}}return l}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Gu||r instanceof Yu)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Xu||r instanceof Zu||r instanceof Hu)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Gu||r instanceof Yu||r instanceof Zu)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof Gu||n instanceof Yu||n instanceof Zu)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:s,binding:a}of r)this.binders[s].setUniform(t,a,i,n.get(s),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof Xu||e instanceof Zu||e instanceof Hu)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Xu||r instanceof Zu||r instanceof Hu)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Xu||e instanceof Zu||e instanceof Hu)&&e.destroy();}}}class Wu{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Ku(n,e,r);this.needsUpload=!1,this._featureMap=new ku,this._featureMapWithoutIds=new ku,this._bufferOffset=0,this._idlessCounter=0;}populatePaintArrays(t,e,r,n,i,s,a,o){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,a,o);void 0!==e.id?this._featureMap.add(e.id,r,this._bufferOffset,t):(this._featureMapWithoutIds.add(this._idlessCounter,r,this._bufferOffset,t),this._idlessCounter+=1),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i,s){for(const a of r)this.needsUpload=this.programConfigurations[a.id].updatePaintArrays(t,this._featureMap,this._featureMapWithoutIds,e,a,n,i,s||0)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const Ju={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-occlusion-opacity":["occlusion_opacity"],"icon-occlusion-opacity":["occlusion_opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function Qu(t,e){return Ju[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const tc={"line-pattern":{source:Nl,composite:Nl},"fill-pattern":{source:Nl,composite:Nl},"fill-extrusion-pattern":{source:Nl,composite:Nl},"line-dasharray":{source:jl,composite:jl}},ec={color:{source:iu,composite:Fl},number:{source:Xl,composite:iu}};function rc(t,e,r){const n=tc[t];return n&&n[r]||ec[e][r]}Mo(Gu,"ConstantBinder"),Mo(Yu,"PatternConstantBinder"),Mo(Xu,"SourceExpressionBinder"),Mo(Hu,"PatternCompositeBinder"),Mo(Zu,"CompositeExpressionBinder"),Mo(Ku,"ProgramConfiguration",{omit:["_buffers"]}),Mo(Wu,"ProgramConfigurationSet");const nc=ps/Math.PI/2,ic=5,sc=6,ac=16383,oc=64,lc=[oc,32,16],uc=-nc,cc=nc;function hc(t,e,r,n=nc){return r=$e(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function pc(t,e,r){return hc(Math.cos($e(t)),Math.sin($e(t)),e,r)}const fc=6371008.8,dc=2*Math.PI*fc;class mc{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new mc(Je(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return fc*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new yc({lng:this.lng-r,lat:this.lat-e},{lng:this.lng+r,lat:this.lat+e})}toEcef(t){return pc(this.lat,this.lng,nc+t*nc/fc)}static convert(t){if(t instanceof mc)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new mc(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new mc(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class yc{constructor(t,e){if(t)if(e)this.setSouthWest(t).setNorthEast(e);else if(4===t.length){const e=t;this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]);}else {const e=t;this.setSouthWest(e[0]).setNorthEast(e[1]);}}setNorthEast(t){return this._ne=t instanceof mc?new mc(t.lng,t.lat):mc.convert(t),this}setSouthWest(t){return this._sw=t instanceof mc?new mc(t.lng,t.lat):mc.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof mc)n=t,i=t;else {if(!(t instanceof yc))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(yc.convert(t)):this.extend(mc.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(mc.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new mc(n.lng,n.lat),this._ne=new mc(i.lng,i.lat)),this}getCenter(){return new mc((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new mc(this.getWest(),this.getNorth())}getSouthEast(){return new mc(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=mc.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return !t||t instanceof yc?t:new yc(t)}}var gc={};!function(t,e){!function(t){function e(t,e,n){var i=r(256*t,256*(e=Math.pow(2,n)-e-1),n),s=r(256*(t+1),256*(e+1),n);return i[0]+","+i[1]+","+s[0]+","+s[1]}function r(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}t.getURL=function(t,r,n,i,s,a){return a=a||{},t+"?"+["bbox="+e(n,i,s),"format="+(a.format||"image/png"),"service="+(a.service||"WMS"),"version="+(a.version||"1.1.1"),"request="+(a.request||"GetMap"),"srs="+(a.srs||"EPSG:3857"),"width="+(a.width||256),"height="+(a.height||256),"layers="+r].join("&")},t.getTileBBox=e,t.getMercCoords=r,Object.defineProperty(t,"__esModule",{value:!0});}(e);}(0,gc);var xc=gc;class bc{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=wc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=xc.getTileBBox(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class vc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=wc(t,e.z,e.z,e.x,e.y);}}class _c{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new bc(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:wc(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new _c(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new _c(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return wc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return wc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.z<this.canonical.z&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new _c(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new _c(e,this.wrap,e,r,n),new _c(e,this.wrap,e,r+1,n),new _c(e,this.wrap,e,r,n+1),new _c(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new _c(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new _c(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new vc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function wc(t,e,r,n,i){const s=1<<Math.min(r,22);let a=s*(i%s)+n%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}const Mc=[t=>{let e=t.canonical.x-1,r=t.wrap;return e<0&&(e=(1<<t.canonical.z)-1,r--),new _c(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>{let e=t.canonical.x+1,r=t.wrap;return e===1<<t.canonical.z&&(e=0,r++),new _c(t.overscaledZ,r,t.canonical.z,e,t.canonical.y)},t=>new _c(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new _c(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)];Mo(bc,"CanonicalTileID"),Mo(_c,"OverscaledTileID",{omit:["projMatrix","expandedProjMatrix"]});const Ac=0,Sc=25.5;function Ic(t){return dc*Math.cos(t*Math.PI/180)}function Tc(t){return (180+t)/360}function kc(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Pc(t,e){return t/Ic(e)}function zc(t){return 360*t-180}function Ec(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Bc(t,e){return t*Ic(Ec(e))}const Dc=85.051129;function Cc(t){return Math.cos($e(Ke(t,-Dc,Dc)))}function Rc(t,e){const r=Ke(e,Ac,Sc),n=Math.pow(2,r);return Cc(t)*dc/(512*n)}function Vc(t){return 1/Math.cos(t*Math.PI/180)}function Lc(t,e=0){const r=Math.exp(Math.PI*(1-(t.y+e/ps)/(1<<t.z)*2));return 80150034*r/(r*r+1)/ps/(1<<t.z)}class Oc{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=mc.convert(t);return new Oc(Tc(r.lng),kc(r.lat),Pc(e,r.lat))}toLngLat(){return new mc(zc(this.x),Ec(this.y))}toAltitude(){return Bc(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/dc*Vc(Ec(this.y))}}function Fc(t,e,r,n,i,s,a,o,l){const u=(e+n)/2,c=(r+i)/2,h=new Ne(u,c);o(h),function(t,e,r,n,i,s){const a=r-i,o=n-s;return Math.abs((n-e)*a-(r-t)*o)/Math.hypot(a,o)}(h.x,h.y,s.x,s.y,a.x,a.y)>=l?(Fc(t,e,r,u,c,s,h,o,l),Fc(t,u,c,n,i,h,a,o,l)):t.push(a);}function Uc(t,e,r){let n=t[0],i=n.x,s=n.y;e(n);const a=[n];for(let o=1;o<t.length;o++){const l=t[o],{x:u,y:c}=l;e(l),Fc(a,i,s,u,c,n,l,e,r),i=u,s=c,n=l;}return a}function Nc(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);Nc(t,e,i,n),Nc(t,i,r,n);}else t.push(r);}function jc(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const s=t[i];Nc(n,r,s,e),r=s;}return n}const qc=Math.pow(2,14)-1,$c=-qc-1;function Gc(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=Ke(r,$c,qc),t.y=Ke(n,$c,qc),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&fr("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function Yc(t,e,r){const n=t.loadGeometry(),i=t.extent,s=ps/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:a,x:o,y:l,projection:u}=r,c=t=>{const r=zc((e.x+t.x/i)/s),n=Ec((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*a-o)*i,t.y=(c.y*a-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=Uc(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)Gc(e,s);return n}function Xc(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Yc(t):[]}}function Zc(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}function Hc(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Kc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new Cl,this.indexArray=new Ql,this.segments=new Au,this.programConfigurations=new Wu(t.layers,{zoom:t.zoom,lut:t.lut}),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}updateFootprints(t,e){}populate(t,e,r,n){const i=this.layers[0],s=[];let a=null;"circle"===i.type&&(a=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Xc(e,t);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),u,r))continue;const c=a?a.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Yc(e,r,n),patterns:{},sortKey:c};s.push(h);}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));let o=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new ql,o=n.projection);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n,l=t[s].feature;this.addFeature(n,i,s,e.availableImages,r,o,e.brightness),e.featureIndex.insert(l,i,s,a,this.index);}}update(t,e,r,n,i){const s=0!==Object.keys(t).length;s&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,s?this.stateDependentLayers:this.layers,r,n,i);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,wu.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Mu.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}addFeature(t,e,r,n,i,s,a){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=ps||n<0||n>=ps)continue;if(s){const t=s.projectTilePoint(r,n,i),e=s.upVector(i,r,n),a=this.globeExtVertexArray;Hc(a,t,e),Hc(a,t,e),Hc(a,t,e),Hc(a,t,e);}const a=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),o=a.vertexLength;Zc(this.layoutVertexArray,r,n,-1,-1),Zc(this.layoutVertexArray,r,n,1,-1),Zc(this.layoutVertexArray,r,n,1,1),Zc(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(o,o+1,o+2),this.indexArray.emplaceBack(o,o+2,o+3),a.vertexLength+=4,a.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i,a);}}function Wc(t,e){for(let r=0;r<t.length;r++)if(ah(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(ah(t,e[r]))return !0;return !!eh(t,e)}function Jc(t,e,r){return !!ah(t,e)||!!nh(e,t,r)}function Qc(t,e){if(1===t.length)return sh(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(ah(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(sh(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(eh(t,e[r]))return !0;return !1}function th(t,e,r){if(t.length>1){if(eh(t,e))return !0;for(let n=0;n<e.length;n++)if(nh(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(nh(t[n],e,r))return !0;return !1}function eh(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(rh(n,i,e[t],e[t+1]))return !0}return !1}function rh(t,e,r,n){return dr(t,r,n)!==dr(e,r,n)&&dr(t,e,r)!==dr(t,e,n)}function nh(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(ih(t,e[r-1],e[r])<n)return !0;return !1}function ih(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function sh(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function ah(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function oh(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new Ne(e,r),new Ne(e,i),new Ne(n,i),new Ne(n,r)];if(t.length>2)for(const e of s)if(ah(t,e))return !0;for(let e=0;e<t.length-1;e++)if(lh(t[e],t[e+1],s))return !0;return !1}function lh(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=dr(t,e,r[0]);return s!==dr(t,e,r[1])||s!==dr(t,e,r[2])||s!==dr(t,e,r[3])}function uh(t,e,r,n,i,s){let a=e.y-t.y,o=t.x-e.x;if(s=s||0){const t=a*a+o*o;if(0===t)return !0;const e=Math.sqrt(t);a/=e,o/=e;}return !((r.x-t.x)*a+(r.y-t.y)*o-s<0||(n.x-t.x)*a+(n.y-t.y)*o-s<0||(i.x-t.x)*a+(i.y-t.y)*o-s<0)}function ch(t,e,r,n,i,s,a){return !(uh(t,e,n,i,s,a)||uh(e,r,n,i,s,a)||uh(r,t,n,i,s,a)||uh(n,i,t,e,r,a)||uh(i,s,t,e,r,a)||uh(s,n,t,e,r,a))}function hh(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function ph(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function fh(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=Ne.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(s));return a}function dh(t,e,r,n){const i=Ne.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}Mo(Kc,"CircleBucket",{omit:["layers"]});const mh=new ol({"circle-sort-key":new sl(ll.layout_circle["circle-sort-key"]),visibility:new il(ll.layout_circle.visibility)});var yh={paint:new ol({"circle-radius":new sl(ll.paint_circle["circle-radius"]),"circle-color":new sl(ll.paint_circle["circle-color"]),"circle-blur":new sl(ll.paint_circle["circle-blur"]),"circle-opacity":new sl(ll.paint_circle["circle-opacity"]),"circle-translate":new il(ll.paint_circle["circle-translate"]),"circle-translate-anchor":new il(ll.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new il(ll.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new il(ll.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new sl(ll.paint_circle["circle-stroke-width"]),"circle-stroke-color":new sl(ll.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new sl(ll.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new il(ll.paint_circle["circle-emissive-strength"])}),layout:mh};class gh{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(e,r,n){const i=t._.dot(r,this.dir);if(Math.abs(i)<1e-6)return !1;const s=((e[0]-this.pos[0])*r[0]+(e[1]-this.pos[1])*r[1]+(e[2]-this.pos[2])*r[2])/i;return n[0]=this.pos[0]+this.dir[0]*s,n[1]=this.pos[1]+this.dir[1]*s,n[2]=this.pos[2]+this.dir[2]*s,!0}closestPointOnSphere(e,r,n){if(t._.equals(this.pos,e)||0===r)return n[0]=n[1]=n[2]=0,!1;const[i,s,a]=this.dir,o=this.pos[0]-e[0],l=this.pos[1]-e[1],u=this.pos[2]-e[2],c=i*i+s*s+a*a,h=2*(o*i+l*s+u*a),p=h*h-4*c*(o*o+l*l+u*u-r*r);if(p<0){const t=Math.max(-h/2,0),e=o+i*t,c=l+s*t,p=u+a*t,f=Math.hypot(e,c,p);return n[0]=e*r/f,n[1]=c*r/f,n[2]=p*r/f,!1}{const t=(-h-Math.sqrt(p))/(2*c);if(t<0){const t=Math.hypot(o,l,u);return n[0]=o*r/t,n[1]=l*r/t,n[2]=u*r/t,!1}return n[0]=o+i*t,n[1]=l+s*t,n[2]=u+a*t,!0}}}class xh{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(e,r,n){const i=[-1,1,1],s=[1,1,1],a=[1,-1,1],o=[-1,-1,1],l=t._.transformMat4(i,i,e),u=t._.transformMat4(s,s,e),c=t._.transformMat4(a,a,e),h=t._.transformMat4(o,o,e);return new xh(l,u,c,h,r/n)}}function bh(e,r,n){let i=1/0,s=-1/0;const a=[];for(const o of e){t._.sub(a,o,r);const e=t._.dot(a,n);i=Math.min(i,e),s=Math.max(s,e);}return [i,s]}function vh(e,r){let n=!0;for(let i=0;i<e.planes.length;i++){const s=e.planes[i];let a=0;for(let e=0;e<r.length;e++)a+=t._.dot(s,r[e])+s[3]>=0;if(0===a)return 0;a!==r.length&&(n=!1);}return n?2:1}function _h(t,e){for(const r of t.projections){const n=bh(e,t.points[0],r.axis);if(r.projection[1]<n[0]||r.projection[0]>n[1])return 0}return 1}function wh(e,r){let n=0;const i=[0,0,0,0];for(let s=0;s<e.length;s++)i[0]=e[s][0],i[1]=e[s][1],i[2]=e[s][2],i[3]=1,t.aA.dot(i,r)>=0&&n++;return n}class Mh{constructor(e,r){this.points=e||new Array(8).fill([0,0,0]),this.planes=r||new Array(6).fill([0,0,0,0]),this.bounds=Ah.fromPoints(this.points),this.projections=[],this.frustumEdges=[t._.sub([],this.points[2],this.points[3]),t._.sub([],this.points[0],this.points[3]),t._.sub([],this.points[4],this.points[0]),t._.sub([],this.points[5],this.points[1]),t._.sub([],this.points[6],this.points[2]),t._.sub([],this.points[7],this.points[3])];for(const t of this.frustumEdges){const e=[0,-t[2],t[1]],r=[t[2],0,-t[0]];this.projections.push({axis:e,projection:bh(this.points,this.points[0],e)}),this.projections.push({axis:r,projection:bh(this.points,this.points[0],r)});}}static fromInvProjectionMatrix(e,r,n,i){const s=Math.pow(2,n),a=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((n=>{const a=t.aA.transformMat4([],n,e),o=1/a[3]/r*s;return t.aA.mul(a,a,[o,o,i?1/a[3]:o,o])})),o=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const r=t._.sub([],a[e[0]],a[e[1]]),n=t._.sub([],a[e[2]],a[e[1]]),i=t._.normalize([],t._.cross([],r,n)),s=-t._.dot(i,a[e[1]]);return i.concat(s)})),l=[];for(let t=0;t<a.length;t++)l.push([a[t][0],a[t][1],a[t][2]]);return new Mh(l,o)}intersectsPrecise(e,r,n){for(let t=0;t<r.length;t++)if(!wh(e,r[t]))return 0;for(let t=0;t<this.planes.length;t++)if(!wh(e,this.planes[t]))return 0;for(const r of n)for(const n of this.frustumEdges){const i=t._.cross([],r,n),s=t._.length(i);if(0===s)continue;t._.scale(i,i,1/s);const a=bh(this.points,this.points[0],i),o=bh(e,this.points[0],i);if(a[0]>o[1]||o[0]>a[1])return 0}return 1}}class Ah{static fromPoints(e){const r=[1/0,1/0,1/0],n=[-1/0,-1/0,-1/0];for(const i of e)t._.min(r,r,i),t._.max(n,n,i);return new Ah(r,n)}static fromTileIdAndHeight(t,e,r){const n=1<<t.canonical.z,i=t.canonical.x,s=t.canonical.y;return new Ah([i/n,s/n,e],[(i+1)/n,(s+1)/n,r])}static applyTransform(e,r){const n=e.getCorners();for(let e=0;e<n.length;++e)t._.transformMat4(n[e],n[e],r);return Ah.fromPoints(n)}static applyTransformFast(t,e){const r=[e[12],e[13],e[14]],n=[...r];for(let i=0;i<3;i++)for(let s=0;s<3;s++){const a=e[4*s+i],o=a*t.min[s],l=a*t.max[s];r[i]+=Math.min(o,l),n[i]+=Math.max(o,l);}return new Ah(r,n)}static projectAabbCorners(e,r){const n=e.getCorners();for(let e=0;e<n.length;++e)t._.transformMat4(n[e],n[e],r);return n}constructor(e,r){this.min=e,this.max=r,this.center=t._.scale([],t._.add([],this.min,this.max),.5);}quadrant(e){const r=[e%2==0,e<2],n=t._.clone(this.min),i=t._.clone(this.max);for(let t=0;t<r.length;t++)n[t]=r[t]?this.min[t]:this.center[t],i[t]=r[t]?this.center[t]:this.max[t];return i[2]=this.max[2],new Ah(n,i)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){return this.intersectsAabb(t.bounds)?vh(t,this.getCorners()):0}intersectsFlat(t){return this.intersectsAabb(t.bounds)?vh(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(t,e){return e||this.intersects(t)?_h(t,this.getCorners()):0}intersectsPreciseFlat(t,e){return e||this.intersectsFlat(t)?_h(t,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(t){for(let e=0;e<3;++e)if(this.min[e]>t.max[e]||t.min[e]>this.max[e])return !1;return !0}intersectsAabbXY(t){return !(this.min[0]>t.max[0]||t.min[0]>this.max[0]||this.min[1]>t.max[1]||t.min[1]>this.max[1])}encapsulate(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t.min[e]),this.max[e]=Math.max(this.max[e],t.max[e]);}encapsulatePoint(t){for(let e=0;e<3;e++)this.min[e]=Math.min(this.min[e],t[e]),this.max[e]=Math.max(this.max[e],t[e]);}closestPoint(t){return [Math.max(Math.min(this.max[0],t[0]),this.min[0]),Math.max(Math.min(this.max[1],t[1]),this.min[1]),Math.max(Math.min(this.max[2],t[2]),this.min[2])]}}Mo(Ah,"Aabb");const Sh=Bl([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:Ih}=Sh,Th=Bl([{name:"a_pos_3",components:3,type:"Int16"}]);var kh=Bl([{name:"a_pos",type:"Int16",components:2}]);function Ph(t){return t*nc/fc}const zh=[new Ah([uc,uc,uc],[cc,cc,cc]),new Ah([uc,uc,uc],[0,0,cc]),new Ah([0,uc,uc],[cc,0,cc]),new Ah([uc,0,uc],[0,cc,cc]),new Ah([0,0,uc],[cc,cc,cc])];function Eh(e,r,n,i=!0){const s=t._.scale([],e._camera.position,e.worldSize),a=[r,n,1,1];t.aA.transformMat4(a,a,e.pixelMatrixInverse),t.aA.scale(a,a,1/a[3]);const o=t._.sub([],a,s),l=t._.normalize([],o),u=e.globeMatrix,c=[u[12],u[13],u[14]],h=t._.sub([],c,s),p=t._.length(h),f=t._.normalize([],h),d=e.worldSize/(2*Math.PI),m=t._.dot(f,l),y=Math.asin(d/p);if(y<Math.acos(m)){if(!i)return null;const e=[],r=[];t._.scale(e,l,p/m),t._.normalize(r,t._.sub(r,e,h)),t._.normalize(l,t._.add(l,h,t._.scale(l,r,Math.tan(y)*p)));}const g=[];new gh(s,l).closestPointOnSphere(c,d,g);const x=t._.normalize([],Tr(u,0)),b=t._.normalize([],Tr(u,1)),v=t._.normalize([],Tr(u,2)),_=t._.dot(x,g),w=t._.dot(b,g),M=t._.dot(v,g),A=Ge(Math.asin(-w/d));let S=Ge(Math.atan2(_,M));S=e.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(e.center.lng,S);const I=Tc(S),T=Ke(kc(A),0,1);return new Oc(I,T)}class Bh{constructor(e,r,n){this.a=t._.sub([],e,n),this.b=t._.sub([],r,n),this.center=n;const i=t._.normalize([],this.a),s=t._.normalize([],this.b);this.angle=Math.acos(t._.dot(i,s));}}function Dh(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,Ke(r,0,1))+t.center[e]}function Ch(t){if(t.z<=1)return zh[t.z+2*t.y+t.x];const e=Uh(Fh(t));return Ah.fromPoints(e)}function Rh(e,r,n){return t._.scale(e,e,1-n),t._.scaleAndAdd(e,e,r,n)}function Vh(e,r){const n=Hh(r.zoom);if(0===n)return Ch(e);const i=Fh(e),s=Uh(i),a=Tc(i.getWest())*r.worldSize,o=Tc(i.getEast())*r.worldSize,l=kc(i.getNorth())*r.worldSize,u=kc(i.getSouth())*r.worldSize,c=[a,l,0],h=[o,l,0],p=[a,u,0],f=[o,u,0],d=t.ad.invert([],r.globeMatrix);return t._.transformMat4(c,c,d),t._.transformMat4(h,h,d),t._.transformMat4(p,p,d),t._.transformMat4(f,f,d),s[0]=Rh(s[0],p,n),s[1]=Rh(s[1],f,n),s[2]=Rh(s[2],h,n),s[3]=Rh(s[3],c,n),Ah.fromPoints(s)}function Lh(e,r,n){for(const i of e)t._.transformMat4(i,i,r),t._.scale(i,i,n);}function Oh(e,r,n,i){const s=r/e.worldSize,a=e.globeMatrix;if(n.z<=1){const t=Ch(n).getCorners();return Lh(t,a,s),Ah.fromPoints(t)}const o=Fh(n,i),l=Uh(o,nc+Ph(e._tileCoverLift));Lh(l,a,s);const u=Number.MAX_VALUE,c=[-u,-u,-u],h=[u,u,u];if(o.contains(e.center)){for(const e of l)t._.min(h,h,e),t._.max(c,c,e);c[2]=0;const r=e.point,n=[r.x*s,r.y*s,0];return t._.min(h,h,n),t._.max(c,c,n),new Ah(h,c)}if(e._tileCoverLift>0){for(const e of l)t._.min(h,h,e),t._.max(c,c,e);return new Ah(h,c)}const p=[a[12]*s,a[13]*s,a[14]*s],f=o.getCenter(),d=Ke(e.center.lat,-Dc,Dc),m=Ke(f.lat,-Dc,Dc),y=Tc(e.center.lng),g=kc(d);let x=y-Tc(f.lng);const b=g-kc(m);x>.5?x-=1:x<-.5&&(x+=1);let v=0;if(Math.abs(x)>Math.abs(b))v=x>=0?1:3;else {v=b>=0?0:2;const e=[a[4]*s,a[5]*s,a[6]*s],r=-Math.sin($e(b>=0?o.getSouth():o.getNorth()))*nc;t._.scaleAndAdd(p,p,e,r);}const _=l[v],w=l[(v+1)%4],M=new Bh(_,w,p),A=[Dh(M,0)||_[0],Dh(M,1)||_[1],Dh(M,2)||_[2]],S=Hh(e.zoom);if(S>0){const i=function({x:t,y:e,z:r},n,i,s,a){const o=1/(1<<r);let l=t*o,u=l+o,c=e*o,h=c+o,p=0;const f=(l+u)/2-s;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(s*=n))*i+s,u=((u+p)*n-s)*i+s,c=(c*n-(a*=n))*i+a,h=(h*n-a)*i+a,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(n,r,e._pixelsPerMercatorPixel,y,g);for(let t=0;t<l.length;t++)Rh(l[t],i[t],S);const s=t._.add([],i[v],i[(v+1)%4]);t._.scale(s,s,.5),Rh(A,s,S);}for(const e of l)t._.min(h,h,e),t._.max(c,c,e);return h[2]=Math.min(_[2],w[2]),t._.min(h,h,A),t._.max(c,c,A),new Ah(h,c)}function Fh({x:t,y:e,z:r},n=!1){const i=1/(1<<r),s=new mc(zc(t*i),e===(1<<r)-1&&n?-90:Ec((e+1)*i)),a=new mc(zc((t+1)*i),0===e&&n?90:Ec(e*i));return new yc(s,a)}function Uh(t,e=nc){const r=$e(t.getNorth()),n=$e(t.getSouth()),i=Math.cos(r),s=Math.cos(n),a=Math.sin(r),o=Math.sin(n),l=t.getWest(),u=t.getEast();return [hc(s,o,l,e),hc(s,o,u,e),hc(i,a,u,e),hc(i,a,l,e)]}function Nh(t,e,r,n){const i=1<<r.z,s=(t/ps+r.x)/i;return pc(Ec((e/ps+r.y)/i),zc(s),n)}function jh({min:t,max:e}){return ac/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const qh=new Float64Array(16);function $h(e){const r=jh(e),n=t.ad.fromScaling(qh,[r,r,r]);return t.ad.translate(n,n,t._.negate([],e.min))}function Gh(e){const r=t.ad.fromTranslation(qh,e.min),n=1/jh(e);return t.ad.scale(r,r,[n,n,n])}function Yh(t){const e=ps/(2*Math.PI);return t/(2*Math.PI)/e}function Xh(t,e){return ps/(512*Math.pow(2,t))*jh(Ch(e))}function Zh(e,r,n,i,s){const a=Yh(n),o=[e,r,-n/(2*Math.PI)],l=t.ad.identity(new Float64Array(16));return t.ad.translate(l,l,o),t.ad.scale(l,l,[a,a,a]),t.ad.rotateX(l,l,$e(-s)),t.ad.rotateY(l,l,$e(-i)),l}function Hh(t){return We(ic,sc,t)}function Kh(e,r){const n=pc(r.lat,r.lng),i=function(e){const r=pc(e._center.lat,e._center.lng),n=t._.fromValues(0,1,0);let i=t._.cross([],n,r);const s=t.ad.fromRotation([],-e.angle,r);i=t._.transformMat4(i,i,s),t.ad.fromRotation(s,-e._pitch,i);const a=t._.normalize([],r);return t._.scale(a,a,Ph(e.cameraToCenterDistance/e.pixelsPerMeter)),t._.transformMat4(a,a,s),t._.add([],r,a)}(e),s=t._.subtract([],i,n);return t._.angle(s,n)}function Wh(t,e){return Kh(t,e)>Math.PI/2*1.01}const Jh=$e(85),Qh=Math.cos(Jh),tp=Math.sin(Jh),ep=t.ad.create(),rp=t=>{const e=[];return "map"===t.paint.get("circle-pitch-alignment")&&e.push("PITCH_WITH_MAP"),"map"===t.paint.get("circle-pitch-scale")&&e.push("SCALE_WITH_MAP"),e};function np(e,r,n,i,s,a,o,l,u){if(a&&e.queryGeometry.isAboveHorizon)return !1;a&&(u*=e.pixelToTileUnitsFactor);const c=e.tileID.canonical,h=n.projection.upVectorScale(c,n.center.lat,n.worldSize).metersToTile;for(const p of r)for(const r of p){const p=r.add(l),f=s&&n.elevation?n.elevation.exaggeration()*s.getElevationAt(p.x,p.y,!0):0,d=n.projection.projectTilePoint(p.x,p.y,c);if(f>0){const t=n.projection.upVector(c,p.x,p.y);d.x+=t[0]*h*f,d.y+=t[1]*h*f,d.z+=t[2]*h*f;}const m=a?p:ip(d.x,d.y,d.z,i),y=a?e.tilespaceRays.map((t=>op(t,f))):e.queryGeometry.screenGeometry,g=t.aA.transformMat4([],[d.x,d.y,d.z,1],i);if(!o&&a?u*=g[3]/n.cameraToCenterDistance:o&&!a&&(u*=n.cameraToCenterDistance/g[3]),a){const t=Ec((r.y/ps+c.y)/(1<<c.z));u/=n.projection.pixelsPerMeter(t,1)/Pc(1,t);}if(Jc(y,m,u))return !0}return !1}function ip(e,r,n,i){const s=t.aA.transformMat4([],[e,r,n,1],i);return new Ne(s[0]/s[3],s[1]/s[3])}const sp=t._.fromValues(0,0,0),ap=t._.fromValues(0,0,1);function op(e,r){const n=t._.create();return sp[2]=r,e.intersectsPlane(sp,ap,n),new Ne(n[0],n[1])}class lp extends Kc{}function up(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function cp(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(hp(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r,null),t.width=n,t.height=i,t.data=e.data);}function hp(t,e,r,n,i,s,a,o){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const l=t.data,u=e.data,c=4===s&&o;for(let o=0;o<i.height;o++){const h=((r.y+o)*t.width+r.x)*s,p=((n.y+o)*e.width+n.x)*s;if(c)for(let t=0;t<i.width;t++){const e=h+t*s+3,r=p+t*s;u[r+0]=255,u[r+1]=255,u[r+2]=255,u[r+3]=l[e];}else if(a)for(let t=0;t<i.width;t++){const e=h+t*s,r=p+t*s,n=l[e+3],i=new qn(l[e+0]/255*n,l[e+1]/255*n,l[e+2]/255*n,n).toRenderColor(a).toArray();u[r+0]=i[0],u[r+1]=i[1],u[r+2]=i[2],u[r+3]=i[3];}else for(let t=0;t<i.width*s;t++)u[p+t]=l[h+t];}return e}Mo(lp,"HeatmapBucket",{omit:["layers"]});class pp{constructor(t,e){up(this,t,1,e);}resize(t){cp(this,new pp(t),1);}clone(){return new pp({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){hp(t,e,r,n,i,1,null);}}class fp{constructor(t,e){up(this,t,4,e);}resize(t){cp(this,new fp(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new fp({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i,s,a){hp(t,e,r,n,i,4,s,a);}}class dp{constructor(t,e){this.width=t.width,this.height=t.height,this.data=e instanceof Uint8Array?new Float32Array(e.buffer):e;}}Mo(pp,"AlphaImage"),Mo(fp,"RGBAImage");const mp=new ol({visibility:new il(ll.layout_heatmap.visibility)});var yp={paint:new ol({"heatmap-radius":new sl(ll.paint_heatmap["heatmap-radius"]),"heatmap-weight":new sl(ll.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new il(ll.paint_heatmap["heatmap-intensity"]),"heatmap-color":new al(ll.paint_heatmap["heatmap-color"]),"heatmap-opacity":new il(ll.paint_heatmap["heatmap-opacity"])}),layout:mp};function gp(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new fp({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);a&&(i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a));};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}const xp=new ol({visibility:new il(ll.layout_hillshade.visibility)});var bp={paint:new ol({"hillshade-illumination-direction":new il(ll.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new il(ll.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new il(ll.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new il(ll.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new il(ll.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new il(ll.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new il(ll.paint_hillshade["hillshade-emissive-strength"])}),layout:xp};const vp=Bl([{name:"a_pos",components:2,type:"Int16"}],4),{members:_p}=vp;function wp(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Mp(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=Mp(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(Cp(a));}i.sort(zp);for(let t=0;t<i.length;t++)r=Ep(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return Sp(s,a,r,o,l,u,0),a}function Mp(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=$p(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=$p(i/n|0,t[i],t[i+1],s);return s&&Op(s,s.next)&&(Gp(s),s=s.next),s}function Ap(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!Op(n,n.next)&&0!==Lp(n.prev,n,n.next))n=n.next;else {if(Gp(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Sp(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Dp(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?Tp(t,n,i,s):Ip(t))e.push(l.i,t.i,u.i),Gp(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?Sp(t=kp(Ap(t),e),e,r,n,i,s,2):2===a&&Pp(t,e,r,n,i,s):Sp(Ap(t),e,r,n,i,s,1);break}}}function Ip(t){const e=t.prev,r=t,n=t.next;if(Lp(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=i<s?i<a?i:a:s<a?s:a,h=o<l?o<u?o:u:l<u?l:u,p=i>s?i>a?i:a:s>a?s:a,f=o>l?o>u?o:u:l>u?l:u;let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Rp(i,o,s,l,a,u,d.x,d.y)&&Lp(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Tp(t,e,r,n){const i=t.prev,s=t,a=t.next;if(Lp(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,m=o>l?o>u?o:u:l>u?l:u,y=c>h?c>p?c:p:h>p?h:p,g=Dp(f,d,e,r,n),x=Dp(m,y,e,r,n);let b=t.prevZ,v=t.nextZ;for(;b&&b.z>=g&&v&&v.z<=x;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==a&&Rp(o,c,l,h,u,p,b.x,b.y)&&Lp(b.prev,b,b.next)>=0)return !1;if(b=b.prevZ,v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==a&&Rp(o,c,l,h,u,p,v.x,v.y)&&Lp(v.prev,v,v.next)>=0)return !1;v=v.nextZ;}for(;b&&b.z>=g;){if(b.x>=f&&b.x<=m&&b.y>=d&&b.y<=y&&b!==i&&b!==a&&Rp(o,c,l,h,u,p,b.x,b.y)&&Lp(b.prev,b,b.next)>=0)return !1;b=b.prevZ;}for(;v&&v.z<=x;){if(v.x>=f&&v.x<=m&&v.y>=d&&v.y<=y&&v!==i&&v!==a&&Rp(o,c,l,h,u,p,v.x,v.y)&&Lp(v.prev,v,v.next)>=0)return !1;v=v.nextZ;}return !0}function kp(t,e){let r=t;do{const n=r.prev,i=r.next.next;!Op(n,i)&&Fp(n,r,r.next,i)&&jp(n,i)&&jp(i,n)&&(e.push(n.i,r.i,i.i),Gp(r),Gp(r.next),r=t=i),r=r.next;}while(r!==t);return Ap(r)}function Pp(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Vp(a,t)){let o=qp(a,t);return a=Ap(a,a.next),o=Ap(o,o.next),Sp(a,e,r,n,i,s,0),void Sp(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function zp(t,e){return t.x-e.x}function Ep(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;do{if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Rp(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);jp(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Bp(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=qp(r,t);return Ap(n,n.next),Ap(r,r.next)}function Bp(t,e){return Lp(t.prev,t,e.prev)<0&&Lp(e.next,t,t.next)<0}function Dp(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Cp(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Rp(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function Vp(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Fp(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(jp(t,e)&&jp(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(Lp(t.prev,t,e.prev)||Lp(t,e.prev,e))||Op(t,e)&&Lp(t.prev,t,t.next)>0&&Lp(e.prev,e,e.next)>0)}function Lp(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Op(t,e){return t.x===e.x&&t.y===e.y}function Fp(t,e,r,n){const i=Np(Lp(t,e,r)),s=Np(Lp(t,e,n)),a=Np(Lp(r,n,t)),o=Np(Lp(r,n,e));return i!==s&&a!==o||!(0!==i||!Up(t,r,e))||!(0!==s||!Up(t,n,e))||!(0!==a||!Up(r,t,n))||!(0!==o||!Up(r,e,n))}function Up(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Np(t){return t>0?1:t<0?-1:0}function jp(t,e){return Lp(t.prev,t,t.next)<0?Lp(t,e,t.next)>=0&&Lp(t,t.prev,e)>=0:Lp(t,e,t.prev)<0||Lp(t,t.next,e)<0}function qp(t,e){const r=Yp(t.i,t.x,t.y),n=Yp(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function $p(t,e,r,n){const i=Yp(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function Gp(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function Yp(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function Xp(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=mr(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(Ri(n[t],e,1,n[t].length-1,Zp),n[t]=n[t].slice(0,e));return n}function Zp(t,e){return e.area-t.area}function Hp(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s]=!0);}return i}function Kp(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},i.availableImages);t=t&&t.name?t.name:t,s[t]=!0,r.patterns[a.id]=t;}}return r}class Wp{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new Cl,this.indexArray=new Ql,this.indexArray2=new Zl,this.programConfigurations=new Wu(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new Au,this.segments2=new Au,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Hp("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Xc(a,t);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Yc(a,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Kp("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages,e.brightness);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n,i){const s=0!==Object.keys(t).length;s&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,s?this.stateDependentLayers:this.layers,r,n,i);}addFeatures(t,e,r,n,i,s){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,_p),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s=[],a){for(const t of Xp(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=wp(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,a);}}Mo(Wp,"FillBucket",{omit:["layers","patternFeatures"]});const Jp=new ol({"fill-sort-key":new sl(ll.layout_fill["fill-sort-key"]),visibility:new il(ll.layout_fill.visibility)});var Qp={paint:new ol({"fill-antialias":new il(ll.paint_fill["fill-antialias"]),"fill-opacity":new sl(ll.paint_fill["fill-opacity"]),"fill-color":new sl(ll.paint_fill["fill-color"]),"fill-outline-color":new sl(ll.paint_fill["fill-outline-color"]),"fill-translate":new il(ll.paint_fill["fill-translate"]),"fill-translate-anchor":new il(ll.paint_fill["fill-translate-anchor"]),"fill-pattern":new sl(ll.paint_fill["fill-pattern"]),"fill-emissive-strength":new il(ll.paint_fill["fill-emissive-strength"])}),layout:Jp};class tf{constructor(t,e,r,n){if(this.triangleCount=e.length/3,this.min=new Ne(0,0),this.max=new Ne(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===t.length)return;const[i,s]=[t[0].clone(),t[0].clone()];for(let e=1;e<t.length;++e){const r=t[e];i.x=Math.min(i.x,r.x),i.y=Math.min(i.y,r.y),s.x=Math.max(s.x,r.x),s.y=Math.max(s.y,r.y);}if(n){const t=Math.ceil(Math.max(s.x-i.x,s.y-i.y)/n);r=Math.max(r,t);}if(0===r)return;this.min=i,this.max=s;const a=this.max.sub(this.min);a.x=Math.max(a.x,1),a.y=Math.max(a.y,1);const o=Math.max(a.x,a.y)/r;this.cellsX=Math.max(1,Math.ceil(a.x/o)),this.cellsY=Math.max(1,Math.ceil(a.y/o)),this.xScale=1/o,this.yScale=1/o;const l=[];for(let r=0;r<this.triangleCount;r++){const n=t[e[3*r+0]].sub(this.min),i=t[e[3*r+1]].sub(this.min),s=t[e[3*r+2]].sub(this.min),a=ef(Math.floor(Math.min(n.x,i.x,s.x)),this.xScale,this.cellsX),u=ef(Math.floor(Math.max(n.x,i.x,s.x)),this.xScale,this.cellsX),c=ef(Math.floor(Math.min(n.y,i.y,s.y)),this.yScale,this.cellsY),h=ef(Math.floor(Math.max(n.y,i.y,s.y)),this.yScale,this.cellsY),p=new Ne(0,0),f=new Ne(0,0),d=new Ne(0,0),m=new Ne(0,0);for(let t=c;t<=h;++t){p.y=f.y=t*o,d.y=m.y=(t+1)*o;for(let e=a;e<=u;++e)p.x=d.x=e*o,f.x=m.x=(e+1)*o,(ch(n,i,s,p,f,m)||ch(n,i,s,p,m,d))&&l.push({cellIdx:t*this.cellsX+e,triIdx:r});}}if(0===l.length)return;l.sort(((t,e)=>t.cellIdx-e.cellIdx||t.triIdx-e.triIdx));let u=0;for(;u<l.length;){const t=l[u].cellIdx,e={start:this.payload.length,len:0};for(;u<l.length&&l[u].cellIdx===t;)++e.len,this.payload.push(l[u++].triIdx);this.cells[t]=e;}}_lazyInitLookup(){this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8))),this.lookup.fill(0);}queryPoint(t,e){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>t.x||t.y>this.max.y||this.min.y>t.y)return;const r=ef(t.x-this.min.x,this.xScale,this.cellsX),n=ef(t.y-this.min.y,this.yScale,this.cellsY),i=this.cells[n*this.cellsX+r];if(i){this._lazyInitLookup();for(let t=0;t<i.len;t++){const r=this.payload[i.start+t],n=Math.floor(r/8),s=1<<r%8;if(!(this.lookup[n]&s)&&(this.lookup[n]|=s,e.push(r),e.length===this.triangleCount))return}}}query(t,e,r){if(0===this.triangleCount||0===this.cells.length)return;if(t.x>this.max.x||this.min.x>e.x)return;if(t.y>this.max.y||this.min.y>e.y)return;this._lazyInitLookup();const n=ef(t.x-this.min.x,this.xScale,this.cellsX),i=ef(e.x-this.min.x,this.xScale,this.cellsX),s=ef(t.y-this.min.y,this.yScale,this.cellsY),a=ef(e.y-this.min.y,this.yScale,this.cellsY);for(let t=s;t<=a;t++)for(let e=n;e<=i;e++){const n=this.cells[t*this.cellsX+e];if(n)for(let t=0;t<n.len;t++){const e=this.payload[n.start+t],i=Math.floor(e/8),s=1<<e%8;if(!(this.lookup[i]&s)&&(this.lookup[i]|=s,r.push(e),r.length===this.triangleCount))return}}}}function ef(t,e,r){return Math.max(0,Math.min(r-1,Math.floor(t*e)))}Mo(tf,"TriangleGridIndex");class rf{constructor(t){this.zoom=t.zoom,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.footprints=[];}updateFootprints(t,e){for(const r of this.footprints)e.push({footprint:r,id:t});}populate(t,e,r,n){const i=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Xc(e,t);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),l,r))continue;const u={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Yc(e,r,n),patterns:{}};i.push(u);}for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n;this.addFeature(n,i,s,r,{},e.availableImages,e.brightness),e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}isEmpty(){return 0===this.footprints.length}uploadPending(){return !1}upload(t){}update(t,e,r,n,i){}destroy(){}addFeature(t,e,r,n,i,s=[],a){for(const t of Xp(e,2)){const e=[],r=[],n=[],i=new Ne(1/0,1/0),s=new Ne(-1/0,-1/0);for(const a of t)if(0!==a.length){a!==t[0]&&n.push(r.length/2);for(let t=0;t<a.length;t++)r.push(a[t].x),r.push(a[t].y),e.push(a[t]),i.x=Math.min(i.x,a[t].x),i.y=Math.min(i.y,a[t].y),s.x=Math.max(s.x,a[t].x),s.y=Math.max(s.y,a[t].y);}const a=wp(r,n),o=new tf(e,a,8,256);this.footprints.push({vertices:e,indices:a,grid:o,min:i,max:s});}}}Mo(rf,"ClipBucket",{omit:["layers"]});const nf=new ol({"clip-layer-types":new il(ll.layout_clip["clip-layer-types"])});var sf={paint:new ol({}),layout:nf};const af=Bl([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),of=Bl([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),lf=Bl([{name:"a_centroid_pos",components:2,type:"Uint16"}]),uf=Bl([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),cf=Bl([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:hf}=af;var pf={},ff=Fe,df=mf;function mf(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(yf,this,e);}function yf(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function gf(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}mf.types=["Unknown","Point","LineString","Polygon"],mf.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,s=0,a=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)s+=t.readSVarint(),a+=t.readSVarint(),1===n&&(e&&o.push(e),e=[]),e.push(new ff(s,a));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e),o},mf.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},mf.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=mf.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=gf(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var xf=df,bf=vf;function vf(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(_f,this,e),this.length=this._features.length;}function _f(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}vf.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new xf(this._pbf,e,this.extent,this._keys,this._values)};var wf=bf;function Mf(t,e,r){if(3===t){var n=new wf(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}var Af=pf.VectorTile=function(t,e){this.layers=t.readFields(Mf,{},e);},Sf=pf.VectorTileFeature=df;pf.VectorTileLayer=bf;class If extends Ne{constructor(t,e,r){super(t,e),this.z=r;}}class Tf extends If{constructor(t,e,r,n){super(t,e,r),this.w=n;}}function kf(t,e,r,n){const i=[],s=0===n?(t,e,r,n,i,s)=>{t.push(new Ne(s,r+(s-e)/(n-e)*(i-r)));}:(t,e,r,n,i,s)=>{t.push(new Ne(e+(s-r)/(i-r)*(n-e),s));};for(const a of t){const t=[];for(const i of a){if(i.length<=2)continue;const a=[];for(let t=0;t<i.length-1;t++){const o=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?o:l,p=0===n?u:c;h<e?p>e&&s(a,o,l,u,c,e):h>r?p<r&&s(a,o,l,u,c,r):a.push(i[t]),p<e&&h>=e&&s(a,o,l,u,c,e),p>r&&h<=r&&s(a,o,l,u,c,r);}let o=i[i.length-1];const l=0===n?o.x:o.y;l>=e&&l<=r&&a.push(o),a.length&&(o=a[a.length-1],a[0].x===o.x&&a[0].y===o.y||a.push(a[0]),t.push(a));}t.length&&i.push(t);}return i}function Pf(t,e,r,n){const i="x"===r?"y":"x",s=(n-t[r])/(e[r]-t[r]);t[i]=t[i]+(e[i]-t[i])*s,t[r]=n,t.hasOwnProperty("z")&&(t.z=Gn(t.z,e.z,s)),t.hasOwnProperty("w")&&(t.w=Gn(t.w,e.w,s));}function zf(t,e,r,n){const i=r,s=n;for(const r of ["x","y"]){let n=t,a=e;n[r]>=a[r]&&(n=e,a=t),n[r]<i&&a[r]>i&&Pf(n,a,r,i),n[r]<s&&a[r]>s&&Pf(a,n,r,s);}}function Ef(t,e){return t.x-e.x||t.y-e.y}function Bf(t,e){return 0===Ef(t.min,e.min)&&0===Ef(t.max,e.max)}function Df(t,e){return !(t.min.x>e.max.x||t.max.x<e.min.x||t.min.y>e.max.y||t.max.y<e.min.y)}function Cf(t,e){if(t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(t[r].sourceId!==e[r].sourceId||!Bf(t[r],e[r])||t[r].order!==e[r].order||t[r].clipMask!==e[r].clipMask)return !1;return !0}function Rf(t,e,r){const n=1/ps,i=1/(1<<r.canonical.z),s=(e.x*n+r.canonical.x)*i+r.wrap,a=(e.y*n+r.canonical.y)*i;return {min:new Ne((t.x*n+r.canonical.x)*i+r.wrap,(t.y*n+r.canonical.y)*i),max:new Ne(s,a)}}function Vf(t,e,r){const n=1<<r.canonical.z,i=((e.x-r.wrap)*n-r.canonical.x)*ps,s=(e.y*n-r.canonical.y)*ps;return {min:new Ne(((t.x-r.wrap)*n-r.canonical.x)*ps,(t.y*n-r.canonical.y)*ps),max:new Ne(i,s)}}function Lf(t,e,r,n,i,s,a){const o=t.indices,l=t.vertices,u=[];for(let c=n;c<n+i;c+=3){const n=e[r[c+0]+s],i=e[r[c+1]+s],h=e[r[c+2]+s],p=Math.min(n.x,i.x,h.x),f=Math.max(n.x,i.x,h.x),d=Math.min(n.y,i.y,h.y),m=Math.max(n.y,i.y,h.y);u.length=0,t.grid.query(new Ne(p,d),new Ne(f,m),u);for(let t=0;t<u.length;t++){const e=u[t];if(ch(l[o[3*e+0]],l[o[3*e+1]],l[o[3*e+2]],n,i,h,a))return !0}}return !1}function Of(t,e,r,n){if(!t||!r)return !1;let i=t.vertices;if(!e.canonical.equals(n.canonical)||e.wrap!==n.wrap){if(r.vertices.length<t.vertices.length)return Of(r,n,t,e);const s=e.canonical,a=n.canonical,o=Math.pow(2,a.z-s.z);i=t.vertices.map((t=>new Ne((t.x+s.x*ps)*o-a.x*ps,(t.y+s.y*ps)*o-a.y*ps)));}return Lf(r,i,t.indices,0,t.indices.length,0,0)}function Ff(t,e,r,n){const i=Math.pow(2,n.z-r.z);return new Ne((t+r.x*ps)*i-n.x*ps,(e+r.y*ps)*i-n.y*ps)}function Uf(t,e){const r=[];e.footprint.grid.queryPoint(t,r);const n=e.footprint.indices,i=e.footprint.vertices;for(let e=0;e<r.length;e++){const s=r[e];if(ah([i[n[3*s+0]],i[n[3*s+1]],i[n[3*s+2]]],t))return !0}return !1}class Nf{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function jf(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(n[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/n[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function qf(t,e,r,n,i,s,a,o,l,u,c){const h=n-t,p=i-e,f=s-r,d=a-t,m=o-e,y=l-r,g=c[1]*y-c[2]*m,x=c[2]*d-c[0]*y,b=c[0]*m-c[1]*d,v=h*g+p*x+f*b;if(Math.abs(v)<1e-15)return null;const _=1/v,w=u[0]-t,M=u[1]-e,A=u[2]-r,S=(w*g+M*x+A*b)*_;if(S<0||S>1)return null;const I=M*f-A*p,T=A*h-w*f,k=w*p-M*h,P=(c[0]*I+c[1]*T+c[2]*k)*_;return P<0||S+P>1?null:(d*I+m*T+y*k)*_}function $f(t,e,r){return (t-e)/(r-e)}function Gf(t,e,r,n,i,s,a,o,l){const u=1<<r,c=s-n,h=a-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=f,l[0]=p,l[1]=d;}class Yf{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=o,i[2]=a,i[3]=l;};let a=new Nf(n);const o=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,o);const r=Zf(o[0],o[1],t),l=Zf(o[2],o[1],t),u=Zf(o[2],o[3],t),c=Zf(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),n/=2;n>=1;n/=2){const t=r[r.length-1];a=new Nf(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),f=t.isLeaf(o[0],o[3]),d=Math.min(r.min,i.min,l.min,u.min),m=Math.max(r.max,i.max,l.max,u.max),y=c&&h&&p&&f;a.maximums.push(m),a.minimums.push(d),a.leaves.push(m-d<=5&&y?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,a=1){return jf([t,e,-100],[r,n,this.maximums[0]*a],i,s)}raycast(e,r,n,i,s,a,o=1){if(!this.nodeCount)return null;const l=this.raycastRoot(e,r,n,i,s,a,o);if(null==l)return null;const u=[],c=[],h=[],p=[],f=[{idx:0,t:l,nodex:0,nodey:0,depth:0}];for(;f.length>0;){const{idx:l,t:d,nodex:m,nodey:y,depth:g}=f.pop();if(this.leaves[l]){Gf(m,y,g,e,r,n,i,h,p);const l=1<<g,u=(m+0)/l,c=(m+1)/l,f=(y+0)/l,x=(y+1)/l,b=Zf(u,f,this.dem)*o,v=Zf(c,f,this.dem)*o,_=Zf(c,x,this.dem)*o,w=Zf(u,x,this.dem)*o,M=qf(h[0],h[1],b,p[0],h[1],v,p[0],p[1],_,s,a),A=qf(p[0],p[1],_,h[0],p[1],w,h[0],h[1],b,s,a),S=Math.min(null!==M?M:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(S!==Number.MAX_VALUE)return S;{const e=t._.scaleAndAdd([],s,a,d);if(Xf(b,v,w,_,$f(e[0],h[0],p[0]),$f(e[1],h[1],p[1]))>=e[2])return d}continue}let x=0;for(let t=0;t<this._siblingOffset.length;t++){Gf((m<<1)+this._siblingOffset[t][0],(y<<1)+this._siblingOffset[t][1],g+1,e,r,n,i,h,p),h[2]=-100,p[2]=this.maximums[this.childOffsets[l]+t]*o;const f=jf(h,p,s,a);if(null!=f){const e=f;u[t]=e;let r=!1;for(let n=0;n<x&&!r;n++)e>=u[c[n]]&&(c.splice(n,0,t),r=!0);r||(c[x]=t),x++;}}for(let t=0;t<x;t++){const e=c[t];f.push({idx:this.childOffsets[l]+e,t:u[e],nodex:(m<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:g+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,a=t[s];let o=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=a.getElevation(n,i),u=a.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(o|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)o&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,l+n);}}function Xf(t,e,r,n,i,s){return Gn(Gn(t,r,s),Gn(e,n,s),i)}function Zf(t,e,r){const n=r.dim,i=Ke(t*n-.5,0,n-1),s=Ke(e*n-.5,0,n-1),a=Math.floor(i),o=Math.floor(s),l=Math.min(a+1,n-1),u=Math.min(o+1,n-1);return Xf(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),i-a,s-o)}const Hf={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Kf(t,e,r){return (256*t*256+256*e+r)/10-1e4}function Wf(t,e,r){return 256*t+e+r/256-32768}class Jf{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return fr(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const i=this.dim=e.height-2,s=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.floatView=new Float32Array(e.data.buffer),this.borderReady=n,this._modifiedForSources={},!n){for(let t=0;t<i;t++)s[this._idx(-1,t)]=s[this._idx(0,t)],s[this._idx(i,t)]=s[this._idx(i-1,t)],s[this._idx(t,-1)]=s[this._idx(t,0)],s[this._idx(t,i)]=s[this._idx(t,i-1)];s[this._idx(-1,-1)]=s[this._idx(0,0)],s[this._idx(i,-1)]=s[this._idx(i-1,0)],s[this._idx(-1,i)]=s[this._idx(0,i-1)],s[this._idx(i,i)]=s[this._idx(i-1,i-1)];}const a="terrarium"===r?Wf:Kf;for(let t=0;t<s.length;++t){const e=4*t;this.floatView[t]=a(this.pixels[e],this.pixels[e+1],this.pixels[e+2]);}this._timestamp=Dr.now();}_buildQuadTree(){this._tree=new Yf(this);}get(t,e,r=!1){r&&(t=Ke(t,-1,this.dim),e=Ke(e,-1,this.dim));const n=this._idx(t,e);return this.floatView[n]}set(t,e,r){const n=this._idx(t,e),i=this.floatView[n];return this.floatView[n]=r,r-i}static getUnpackVector(t){return Hf[t]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=Jf.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new dp({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+o,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}Mo(Jf,"DEMData"),Mo(Yf,"DemMinMaxQuadTree",{omit:["dem"]});class Qf{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,a=1<<e.canonical.z-s.canonical.z;return new Qf(n,i.dim/ps/a,[(e.canonical.x/a-s.canonical.x)*i.dim,(e.canonical.y/a-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new Ne(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(i),o=Math.floor(s),l=this._dem;return n=!!n,r?Gn(Gn(l.get(a,o,n),l.get(a,o+1,n),s-o),Gn(l.get(a+1,o,n),l.get(a+1,o+1,n),s-o),i-a):l.get(a,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*Pc(1,t)*this._dem.stride}}const td={None:0,Model:1,Symbol:2,FillExtrusion:4,All:7},ed=Sf.types,rd=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius"],nd=["fill-extrusion-flood-light-ground-radius"],id=Math.pow(2,13),sd=Math.pow(2,15)-1,ad=new Ne(0,1),od=2147483648;function ld(t,e,r,n,i,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(n*id)<<1)+i,Math.round(o));}function ud(t,e,r,n,i,s){t.emplaceBack(e.x,e.y,(r.x<<1)+n,(r.y<<1)+i,s);}function cd(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class hd{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0;}}class pd{constructor(){this.centroidXY=new Ne(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.polygonSegIdx=-1,this.polygonSegLen=0,this.min=new Ne(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new Ne(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0;}span(){return new Ne(this.max.x-this.min.x,this.max.y-this.min.y)}}class fd{constructor(){this.acc=new Ne(0,0),this.accCount=0,this.centroidDataIndex=0;}startRing(t,e){t.min.x===Number.MAX_VALUE&&(t.min.x=t.max.x=e.x,t.min.y=t.max.y=e.y);}appendEdge(t,e,r){this.accCount++,this.acc._add(e);let n=!!this.borders;e.x<t.min.x?(t.min.x=e.x,n=!0):e.x>t.max.x&&(t.max.x=e.x,n=!0),e.y<t.min.y?(t.min.y=e.y,n=!0):e.y>t.max.y&&(t.max.y=e.y,n=!0),((0===e.x||e.x===ps)&&e.x===r.x)!=((0===e.y||e.y===ps)&&e.y===r.y)&&this.processBorderOverlap(e,r),n&&this.checkBorderIntersection(e,r);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,Gn(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>ps!=t.x>ps&&this.addBorderIntersection(1,Gn(e.y,t.y,(ps-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Gn(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>ps!=t.y>ps&&this.addBorderIntersection(3,Gn(e.x,t.x,(ps-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){return 0===this.accCount?new Ne(0,0):new Ne(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0):0}}function dd(t,e){const r=t.add(e)._unit(),n=Ke(t.x*r.x+t.y*r.y,-1,1);var i,s,a;return i=Math.acos(n),Math.min(4,Math.max(-4,Math.tan(i)))/4*sd*((s=t).x*(a=e).y-s.y*a.x<0?-1:1)}const md=[t=>t.x<0,t=>t.x>ps,t=>t.y<0,t=>t.y>ps];function yd(t,e,r,n){const i=[4];if(0===n)return i;r._mult(n);const s=t.sub(r),a=e.sub(r),o=[t,e,s,a];for(let t=0;t<4;t++)for(const e of o)if(md[t](e)){i.push(t);break}return i}class gd{constructor(t){this.vertexArray=new Ll,this.indexArray=new Ql,this.programConfigurations=new Wu(t.layers,{zoom:t.zoom,lut:t.lut},(t=>nd.includes(t))),this._segments=new Au,this.hiddenByLandmarkVertexArray=new cu,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new Au;}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(t,e,r,n=!1){const i=t.length;if(i>2){let s=Math.max(0,this._segments.get().length-1);const a=this._segments._prepareSegment(4*i,this.vertexArray.length,2*this._segmentToGroundQuads[s].length);let o;s!==this._segments.get().length-1&&(s++,this._segmentToGroundQuads[s]=[],this._segmentToRegionTriCounts[s]=[0,0,0,0,0]);{const e=t[0],r=t[1];o=dd(e.sub(t[i-1])._perp()._unit(),r.sub(e)._perp()._unit());}for(let l=0;l<i;l++){const u=l===i-1?0:l+1,c=t[l],h=t[u],p=t[u===i-1?0:u+1],f=h.sub(c)._perp()._unit(),d=dd(f,p.sub(h)._perp()._unit()),m=o,y=d;if(wd(c,h,e)||n&&Md(c,e)&&Md(h,e)){o=d;continue}const g=a.vertexLength;ud(this.vertexArray,c,h,1,1,m),ud(this.vertexArray,c,h,1,0,m),ud(this.vertexArray,c,h,0,1,y),ud(this.vertexArray,c,h,0,0,y),a.vertexLength+=4;const x=yd(c,h,f,r);for(const t of x)this._segmentToGroundQuads[s].push({id:g,region:t}),this._segmentToRegionTriCounts[s][t]+=2,a.primitiveLength+=2;o=d;}}}prepareBorderSegments(){if(!this.hasData())return;const t=this._segments.get(),e=t.length;for(let t=0;t<e;t++)this._segmentToGroundQuads[t].sort(((t,e)=>t.region-e.region));for(let r=0;r<e;r++){const e=this._segmentToGroundQuads[r],n=t[r],i=this._segmentToRegionTriCounts[r];i.reduce(((t,e)=>t+e),0);let s=0;for(let t=0;t<=4;t++){const e=i[t];if(0!==e){let r=this.regionSegments[t];r||(r=this.regionSegments[t]=new Au);const i={vertexOffset:n.vertexOffset,primitiveOffset:n.primitiveOffset+s,vertexLength:n.vertexLength,primitiveLength:e};r.get().push(i);}s+=e;}for(let t=0;t<e.length;t++){const r=e[t].id;this.indexArray.emplaceBack(r,r+1,r+3),this.indexArray.emplaceBack(r,r+3,r+2);}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null;}addPaintPropertiesData(t,e,r,n,i,s){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,t,e,r,n,i,s);}upload(t){this.hasData()&&(this.vertexBuffer=t.createVertexBuffer(this.vertexArray,of.members),this.indexBuffer=t.createIndexBuffer(this.indexArray));}uploadPaintProperties(t){this.hasData()&&this.programConfigurations.upload(t);}update(t,e,r,n,i,s){this.hasData()&&this.programConfigurations.updatePaintArrays(t,e,r,n,i,s);}updateHiddenByLandmark(t){if(!this.hasData())return;const e=t.groundVertexCount+t.groundVertexArrayOffset;if(0===t.groundVertexCount)return;const r=t.flags&od?1:0;for(let n=t.groundVertexArrayOffset;n<e;++n)this.hiddenByLandmarkVertexArray.emplace(n,r);this._needsHiddenByLandmarkUpdate=!0;}uploadHiddenByLandmark(t){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=t.createVertexBuffer(this.hiddenByLandmarkVertexArray,uf.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1);}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let t=0;t<=4;t++){const e=this.regionSegments[t];e&&e.destroy();}}}}class xd{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new Ql,this.footprintVertices=new Cl,this.footprintSegments=[],this.layoutVertexArray=new Vl,this.centroidVertexArray=new _u,this.indexArray=new Ql,this.programConfigurations=new Wu(t.layers,{zoom:t.zoom,lut:t.lut},(t=>rd.includes(t))),this.segments=new Au,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.groundEffect=new gd(t),this.maxHeight=0,this.partLookup={},this.triangleSubSegments=[],this.polygonSegments=[];}updateFootprints(t,e){}populate(t,e,r,n){this.features=[],this.hasPattern=Hp("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.tileToMeter=Lc(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter;for(const{feature:i,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=Xc(i,t);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),l,r))continue;const u={id:s,sourceLayerIndex:o,index:a,geometry:t?l.geometry:Yc(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length;this.hasPattern?this.features.push(Kp("fill-extrusion",this.layers,u,this.zoom,e)):this.addFeature(u,u.geometry,a,r,{},e.availableImages,n,e.brightness),e.featureIndex.insert(i,u.geometry,a,o,this.index,c);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles(),this.groundEffect.prepareBorderSegments(),this.polygonSegments.length=0;}addFeatures(t,e,r,n,i,s){for(const t of this.features){const{geometry:a}=t;this.addFeature(t,a,t.index,e,r,n,i,s);}this.sortBorders(),"mercator"===this.projection.name&&this.splitToSubtiles();}update(t,e,r,n,i){const s=0!==Object.keys(t).length;if(s&&!this.stateDependentLayers.length)return;const a=s?this.stateDependentLayers:this.layers;this.programConfigurations.updatePaintArrays(t,e,a,r,n,i),this.groundEffect.update(t,e,a,r,n,i);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,hf),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,cf.members,!0)),this.groundEffect.upload(t)),this.groundEffect.uploadPaintProperties(t),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){this.groundEffect.uploadHiddenByLandmark(t),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,lf.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s,a,o){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(t,{})/this.tileToMeter,u=[new Ne(0,0),new Ne(ps,ps)],c=a.projection,h="globe"===c.name,p="Polygon"===ed[t.type],f=new fd;f.centroidDataIndex=this.centroidData.length;const d=new pd,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(t,{},n)<=0,y=this.layers[0].paint.get("fill-extrusion-height").evaluate(t,{},n);d.height=y,d.vertexArrayOffset=this.layoutVertexArray.length,d.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new ql);const g=Xp(e,500);for(let t=g.length-1;t>=0;t--){const e=g[t];(0===e.length||(x=e[0]).every((t=>t.x<=0))||x.every((t=>t.x>=ps))||x.every((t=>t.y<=0))||x.every((t=>t.y>=ps)))&&g.splice(t,1);}var x;let b;if(h)b=Td(g,u,n);else {b=[];for(const t of g)b.push({polygon:t,bounds:u});}const v=p?this.edgeRadius:0,_=v>0&&this.zoom<17,w=(t,e)=>{if(0===t.length)return !1;const r=t[t.length-1];return e.x===r.x&&e.y===r.y};for(const{polygon:t,bounds:e}of b){let r=0,i=0;for(const e of t)p&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=p?e.length-1:e.length;const s=this.segments.prepareSegment((p?5:4)*i,this.layoutVertexArray,this.indexArray);d.footprintSegIdx<0&&(d.footprintSegIdx=this.footprintSegments.length),d.polygonSegIdx<0&&(d.polygonSegIdx=this.polygonSegments.length);const a={triangleArrayOffset:this.indexArray.length,triangleCount:0,triangleSegIdx:this.segments.segments.length-1},o=new hd;if(o.vertexOffset=this.footprintVertices.length,o.indexOffset=3*this.footprintIndices.length,o.ringIndices=[],p){const i=[],a=[];r=s.vertexLength;for(let r=0;r<t.length;r++){const u=t[r];u.length&&0!==r&&a.push(i.length/2);const p=[];let f,d;f=u[1].sub(u[0])._perp()._unit(),o.ringIndices.push(u.length-1);for(let t=1;t<u.length;t++){const e=u[t],r=u[t===u.length-1?1:t+1],a=e.clone();if(v){d=r.sub(e)._perp()._unit();const t=f.add(d)._unit(),n=v*Math.min(4,1/(f.x*t.x+f.y*t.y));a.x+=n*t.x,a.y+=n*t.y,a.x=Math.round(a.x),a.y=Math.round(a.y),f=d;}!m||0!==v&&!_||w(p,a)||p.push(a),ld(this.layoutVertexArray,a.x,a.y,0,0,1,1,0),s.vertexLength++,this.footprintVertices.emplaceBack(e.x,e.y),i.push(e.x,e.y),h&&cd(this.layoutVertexExtArray,c.projectTilePoint(a.x,a.y,n),c.upVector(n,a.x,a.y));}m&&(0===v||_)&&(0!==p.length&&w(p,p[0])&&p.pop(),this.groundEffect.addData(p,e,l));}const u=wp(i,a);for(let t=0;t<u.length;t+=3)this.footprintIndices.emplaceBack(o.vertexOffset+u[t+0],o.vertexOffset+u[t+1],o.vertexOffset+u[t+2]),this.indexArray.emplaceBack(r+u[t],r+u[t+2],r+u[t+1]),s.primitiveLength++;o.indexCount+=u.length,o.vertexCount+=this.footprintVertices.length-o.vertexOffset;}for(let i=0;i<t.length;i++){const a=t[i];f.startRing(d,a[0]);let o=a.length>4&&Ad(a[a.length-2],a[0],a[1]),u=v?vd(a[a.length-2],a[0],a[1],v):0;const y=[];let g,x,b;x=a[1].sub(a[0])._perp()._unit();let _=!0;for(let t=1,i=0;t<a.length;t++){let l=a[t-1],p=a[t];const M=a[t===a.length-1?1:t+1];if(f.appendEdge(d,p,l),wd(p,l,e)){v&&(x=M.sub(p)._perp()._unit(),_=!_);continue}const A=p.sub(l)._perp(),S=A.x/(Math.abs(A.x)+Math.abs(A.y)),I=A.y>0?1:0,T=l.dist(p);if(i+T>32768&&(i=0),v){b=M.sub(p)._perp()._unit();let t=_d(l,p,M,bd(x,b),v);isNaN(t)&&(t=0);const e=p.sub(l)._unit();l=l.add(e.mult(u))._round(),p=p.add(e.mult(-t))._round(),u=t,x=b,m&&this.zoom>=17&&(w(y,l)||y.push(l),w(y,p)||y.push(p));}const k=s.vertexLength,P=a.length>4&&Ad(l,p,M);let z=Sd(i,o,_);if(ld(this.layoutVertexArray,l.x,l.y,S,I,0,0,z),ld(this.layoutVertexArray,l.x,l.y,S,I,0,1,z),i+=T,z=Sd(i,P,!_),o=P,ld(this.layoutVertexArray,p.x,p.y,S,I,0,0,z),ld(this.layoutVertexArray,p.x,p.y,S,I,0,1,z),s.vertexLength+=4,this.indexArray.emplaceBack(k+0,k+1,k+2),this.indexArray.emplaceBack(k+1,k+3,k+2),s.primitiveLength+=2,v){const n=r+(1===t?a.length-2:t-2),i=1===t?r:n+1;if(this.indexArray.emplaceBack(k+1,n,k+3),this.indexArray.emplaceBack(n,i,k+3),s.primitiveLength+=2,void 0===g&&(g=k),!wd(M,a[t],e)){const e=t===a.length-1?g:s.vertexLength;this.indexArray.emplaceBack(k+2,k+3,e),this.indexArray.emplaceBack(k+3,e+1,e),this.indexArray.emplaceBack(k+3,i,e+1),s.primitiveLength+=3;}_=!_;}if(h){const t=this.layoutVertexExtArray,e=c.projectTilePoint(l.x,l.y,n),r=c.projectTilePoint(p.x,p.y,n),i=c.upVector(n,l.x,l.y),s=c.upVector(n,p.x,p.y);cd(t,e,i),cd(t,e,i),cd(t,r,s),cd(t,r,s);}}p&&(r+=a.length-1),m&&v&&this.zoom>=17&&(0!==y.length&&w(y,y[0])&&y.pop(),this.groundEffect.addData(y,e,l,v>0));}this.footprintSegments.push(o),a.triangleCount=this.indexArray.length-a.triangleArrayOffset,this.polygonSegments.push(a),++d.footprintSegLen,++d.polygonSegLen;}if(d.vertexCount=this.layoutVertexArray.length-d.vertexArrayOffset,d.groundVertexCount=this.groundEffect.vertexArray.length-d.groundVertexArrayOffset,0!==d.vertexCount){if(d.centroidXY=f.borders?ad:this.encodeCentroid(f,d),this.centroidData.push(d),f.borders){this.featuresOnBorder.push(f);const t=this.featuresOnBorder.length-1;for(let e=0;e<f.borders.length;e++)f.borders[e][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[e].push(t);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,o),this.groundEffect.addPaintPropertiesData(t,r,i,s,n,o),this.maxHeight=Math.max(this.maxHeight,y);}}sortBorders(){for(let t=0;t<this.borderFeatureIndices.length;t++)this.borderFeatureIndices[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}splitToSubtiles(){const t=[];for(let e=0;e<this.centroidData.length;e++){const r=this.centroidData[e],n=+(r.min.y+r.max.y>ps),i=2*n+(+(r.min.x+r.max.x>ps)^n);for(let n=0;n<r.polygonSegLen;n++){const s=r.polygonSegIdx+n;t.push({centroidIdx:e,subtile:i,polygonSegmentIdx:s,triangleSegmentIdx:this.polygonSegments[s].triangleSegIdx});}}const e=new Ql;t.sort(((t,e)=>t.triangleSegmentIdx===e.triangleSegmentIdx?t.subtile-e.subtile:t.triangleSegmentIdx-e.triangleSegmentIdx));let r=0,n=0,i=0;for(const e of t){if(e.triangleSegmentIdx!==r)break;i++;}const s=t.length;for(;n!==t.length;){r=t[n].triangleSegmentIdx;let a=0,o=n,l=n;for(let e=o;e<i&&t[e].subtile===a;e++)l++;for(;o!==i;){const n=t[o];a=n.subtile;const s=this.centroidData[n.centroidIdx].min.clone(),u=this.centroidData[n.centroidIdx].max.clone(),c={vertexOffset:this.segments.segments[r].vertexOffset,primitiveOffset:e.length,vertexLength:this.segments.segments[r].vertexLength,primitiveLength:0,sortKey:void 0,vaos:{}};for(let r=o;r<l;r++){const n=t[r],i=this.polygonSegments[n.polygonSegmentIdx],a=this.centroidData[n.centroidIdx].min,o=this.centroidData[n.centroidIdx].max,l=this.indexArray.uint16;for(let t=i.triangleArrayOffset;t<i.triangleArrayOffset+i.triangleCount;t++)e.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);c.primitiveLength+=i.triangleCount,s.x=Math.min(s.x,a.x),s.y=Math.min(s.y,a.y),u.x=Math.max(u.x,o.x),u.y=Math.max(u.y,o.y);}c.primitiveLength>0&&this.triangleSubSegments.push({segment:c,min:s,max:u}),o=l;for(let e=o;e<i&&t[e].subtile===t[o].subtile;e++)l++;}n=i;for(let e=n;e<s&&t[e].triangleSegmentIdx===t[n].triangleSegmentIdx;e++)i++;}e._trim(),this.indexArray=e;}getVisibleSegments(t,e,r){let n=0,i=0;const s=1<<t.canonical.z;if(e){const r=e.getMinMaxForTile(t);r&&(n=r.min,i=r.max);}i+=this.maxHeight;const a=t.toUnwrapped();let o;const l=[a.canonical.x/s+a.wrap,a.canonical.y/s],u=[(a.canonical.x+1)/s+a.wrap,(a.canonical.y+1)/s],c=new Au,h=(t,e,r)=>[t[0]*(1-r[0])+e[0]*r[0],t[1]*(1-r[1])+e[1]*r[1]],p=[],f=[];for(const t of this.triangleSubSegments){p[0]=t.min.x/ps,p[1]=t.min.y/ps,f[0]=t.max.x/ps,f[1]=t.max.y/ps;const e=h(l,u,p),s=h(l,u,f);if(0===new Ah([e[0],e[1],n],[s[0],s[1],i]).intersectsPrecise(r)){o&&(c.segments.push(o),o=void 0);continue}const a=t.segment;o&&o.vertexOffset!==a.vertexOffset&&(c.segments.push(o),o=void 0),o?(o.vertexLength+=a.vertexLength,o.primitiveLength+=a.primitiveLength):o={vertexOffset:a.vertexOffset,primitiveLength:a.primitiveLength,vertexLength:a.vertexLength,primitiveOffset:a.primitiveOffset,sortKey:void 0,vaos:{}};}return o&&c.segments.push(o),c}encodeCentroid(t,e){const r=t.centroid(),n=e.span(),i=Math.min(7,Math.round(n.x*this.tileToMeter/10)),s=Math.min(7,Math.round(n.y*this.tileToMeter/10));return new Ne(Ke(r.x,1,ps-1)<<3|i,Ke(r.y,1,ps-1)<<3|s)}encodeBorderCentroid(t){if(!t.borders)return new Ne(0,0);const e=t.borders,r=Number.MAX_VALUE;if(e[0][0]!==r||e[1][0]!==r){const t=e[0][0]!==r?0:1;return new Ne(6|(e[0][0]!==r?0:65528),(e[t][0]+e[t][1])/2<<3|6)}{const t=e[2][0]!==r?2:3;return new Ne((e[t][0]+e[t][1])/2<<3|6,6|(e[2][0]!==r?0:65528))}}showCentroid(t){const e=this.centroidData[t.centroidDataIndex];e.flags&=od,e.centroidXY.x=0,e.centroidXY.y=0,this.writeCentroidToBuffer(e);}writeCentroidToBuffer(t){this.groundEffect.updateHiddenByLandmark(t);const e=t.vertexArrayOffset,r=t.vertexCount+t.vertexArrayOffset,n=t.flags&od?ad:t.centroidXY,i=this.centroidVertexArray.geta_centroid_pos0(e);if(this.centroidVertexArray.geta_centroid_pos1(e)!==n.y||i!==n.x){for(let t=e;t<r;++t)this.centroidVertexArray.emplace(t,n.x,n.y);this.needsCentroidUpdate=!0;}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const t of this.centroidData)this.writeCentroidToBuffer(t);}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped());if(Cf(this.activeReplacements,n))return;if(this.activeReplacements=n,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const t of this.centroidData)t.flags&=2147483647;const i=[];for(const e of this.activeReplacements){if(e.order<r)continue;const n=Math.pow(2,e.footprintTileId.canonical.z-t.canonical.z);for(const r of this.centroidData)if(!(r.flags&od||e.min.x>r.max.x||r.min.x>e.max.x||e.min.y>r.max.y||r.min.y>e.max.y))for(let s=0;s<r.footprintSegLen;s++){const a=this.footprintSegments[r.footprintSegIdx+s];if(i.length=0,kd(this.footprintVertices,a.vertexOffset,a.vertexCount,e.footprintTileId.canonical,t.canonical,i),Lf(e.footprint,i,this.footprintIndices.uint16,a.indexOffset,a.indexCount,-a.vertexOffset,-n)){r.flags|=od;break}}}for(const t of this.centroidData)this.writeCentroidToBuffer(t);this.borderDoneWithNeighborZ=[-1,-1,-1,-1];}footprintContainsPoint(t,e,r){let n=!1;for(let i=0;i<r.footprintSegLen;i++){const s=this.footprintSegments[r.footprintSegIdx+i];let a=0;for(const r of s.ringIndices){for(let i=a,o=r+a-1;i<r+a;o=i++){const r=this.footprintVertices.int16[2*(i+s.vertexOffset)+0],a=this.footprintVertices.int16[2*(i+s.vertexOffset)+1],l=this.footprintVertices.int16[2*(o+s.vertexOffset)+1];a>e!=l>e&&t<(this.footprintVertices.int16[2*(o+s.vertexOffset)+0]-r)*(e-a)/(l-a)+r&&(n=!n);}a=r;}}return n}getHeightAtTileCoord(t,e){let r=Number.NEGATIVE_INFINITY,n=!0;const i=4*(t+ps)*ps+(e+ps);if(this.partLookup.hasOwnProperty(i)){const t=this.partLookup[i];return t?{height:t.height,hidden:!!(t.flags&od)}:void 0}for(const s of this.centroidData)t>s.max.x||s.min.x>t||e>s.max.y||s.min.y>e||this.footprintContainsPoint(t,e,s)&&s&&s.height>r&&(r=s.height,this.partLookup[i]=s,n=!!(s.flags&od));if(r!==Number.NEGATIVE_INFINITY)return {height:r,hidden:n};this.partLookup[i]=void 0;}}function bd(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function vd(t,e,r,n){const i=e.sub(t)._perp()._unit(),s=r.sub(e)._perp()._unit();return _d(t,e,r,bd(i,s),n)}function _d(t,e,r,n,i){const s=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*s/n)}function wd(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function Md(t,e){return t.x<e[0].x||t.x>e[1].x||t.y<e[0].y||t.y>e[1].y}function Ad(t,e,r){if(t.x<0||t.x>=ps||e.x<0||e.x>=ps||r.x<0||r.x>=ps)return !1;const n=r.sub(e),i=n.perp(),s=t.sub(e);return (n.x*s.x+n.y*s.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(s.x*s.x+s.y*s.y))>-.866&&i.x*s.x+i.y*s.y<0}function Sd(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function Id(){const t=Math.PI/32,e=Math.tan(t),r=fc;return r*Math.sqrt(1+2*e*e)-r}function Td(t,e,r){const n=1<<r.z,i=zc(r.x/n),s=zc((r.x+1)/n),a=Ec(r.y/n),o=Ec((r.y+1)/n);return function(t,e,r,n,i=0,s){const a=[];if(!t.length||!r||!n)return a;const o=(t,e)=>{for(const r of t)a.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=kf(p,e[0].y-i,e[1].y+i,1),p=kf(p,e[0].x-i,e[1].x+i,0),!p.length)return a;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):o(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],a=t.bounds[1],l=0===r?n.x:n.y,u=0===r?a.x:a.y,c=s?s(r,l,u):.5*(l+u),p=kf(t.polygons,l-i,c+i,r),d=kf(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new Ne(0===r?c:a.x,1===r?c:a.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):o(p,t);}if(d.length){const t=[new Ne(0===r?c:n.x,1===r?c:n.y),a];h.length>e+1?f.push({polygons:d,bounds:t,depth:e+1}):o(d,t);}}return a}(t,e,Math.ceil((s-i)/11.25),Math.ceil((a-o)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=Ec((r.y+e/ps)/n);return (kc(.5*(Ec((r.y+i/ps)/n)+t))*n-r.y)*ps}}))}function kd(t,e,r,n,i,s){const a=Math.pow(2,n.z-i.z);for(let o=0;o<r;o++){let r=t.int16[2*(o+e)+0],l=t.int16[2*(o+e)+1];r=(r+i.x*ps)*a-n.x*ps,l=(l+i.y*ps)*a-n.y*ps,s.push(new Ne(r,l));}}Mo(xd,"FillExtrusionBucket",{omit:["layers","features"]}),Mo(pd,"PartData"),Mo(hd,"FootprintSegment"),Mo(fd,"BorderCentroidData"),Mo(gd,"GroundEffect");const Pd=new ol({visibility:new il(ll["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new il(ll["layout_fill-extrusion"]["fill-extrusion-edge-radius"])});var zd={paint:new ol({"fill-extrusion-opacity":new il(ll["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new sl(ll["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new il(ll["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new il(ll["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new sl(ll["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new sl(ll["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new sl(ll["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new il(ll["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new il(ll["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new il(ll["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new il(ll["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new il(ll["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new il(ll["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new il(ll["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new il(ll["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new sl(ll["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new sl(ll["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new il(ll["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new il(ll["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new il(ll["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new il(ll["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"]),"fill-extrusion-emissive-strength":new il(ll["paint_fill-extrusion"]["fill-extrusion-emissive-strength"])}),layout:Pd};function Ed(t,e){return t.x*e.x+t.y*e.y}function Bd(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Ed(o,o),h=Ed(o,l),p=Ed(l,l),f=Ed(u,o),d=Ed(u,l),m=c*p-h*h,y=(p*f-h*d)/m,g=(c*d-h*f)/m,x=n.z*(1-y-g)+i.z*y+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Dd(t,e,r,n,i,s,a,o){const l=a*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7-450):a*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),a=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),m=Math.abs(d[0]-d[1]),y=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(m+y)/p),b=Math.min(.25,.5*l*g/f);return o+Math.max(x*s,b*a)}(i,s,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+n,l+r+2):l+n}}const Cd=Bl([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Rd}=Cd,Vd=Bl([{name:"a_packed",components:4,type:"Float32"}]),{members:Ld}=Vd,Od=Bl([{name:"a_pattern_data",components:3,type:"Float32"}]),{members:Fd}=Od,Ud=Bl([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Nd=Bl([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),jd=Bl([{name:"a_projected_pos",components:4,type:"Float32"}],4);Bl([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const qd=Bl([{name:"a_occlusion_query_opacity",components:1,type:"Float32"}],4),$d=Bl([{name:"a_z_offset",components:1,type:"Float32"}],4),Gd=Bl([{name:"a_texb",components:2,type:"Uint16"}]),Yd=Bl([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),Xd=Bl([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"},{name:"a_z_offset",components:1,type:"Float32"}]);Bl([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Zd=Bl([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Hd=Bl([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);Bl([{name:"triangle",components:3,type:"Uint16"}]),Bl([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),Bl([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Float32",name:"occlusionState"},{type:"Float32",name:"occlusionOpacity"},{type:"Uint8",name:"hasIconTextFit"}]),Bl([{type:"Float32",name:"offsetX"}]),Bl([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);class Kd{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new pp({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=sr(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,a=!0;n.push({left:i,right:s,isDash:a,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){a=!a;const l=t[e];i=o*r,o+=l,s=o*r,n.push({left:i,right:s,isDash:a,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,a=t[s];for(let o=0;o<this.width;o++){o/a.right>1&&(a=t[++s]);const l=Math.abs(o-a.left),u=Math.abs(o-a.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(a.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,a=t[s];for(let r=0;r<this.width;r++){r/a.right>1&&(a=t[++s]);const n=Math.abs(r-a.left),o=Math.abs(r-a.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(a.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return fr("LineAtlas out of space"),null;0===t.length&&t.push(1);let a=0;for(let e=0;e<t.length;e++)t[e]<0&&(fr("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),a+=t[e];if(0!==a){const r=this.width/a,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=s;const l={tl:[o,i],br:[a,0]};return this.positions[r]=l,l}}Mo(Kd,"LineAtlas");const Wd=Sf.types,Jd=Math.cos(Math.PI/180*37.5),Qd=Math.cos(Math.PI/180*5);class tm{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.hasZOffset=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new Ol,this.layoutVertexArray2=new Fl,this.patternVertexArray=new Ul,this.indexArray=new Ql,this.programConfigurations=new Wu(t.layers,{zoom:t.zoom,lut:t.lut}),this.segments=new Au,this.maxLineLength=0,this.zOffsetVertexArray=new Xl,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.tessellationStep=t.tessellationStep?t.tessellationStep:ps/64;}updateFootprints(t,e){}populate(t,e,r,n){this.hasPattern=Hp("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),s=this.layers[0].layout.get("line-z-offset");this.hasZOffset=!s.isConstant()||!!s.constantOr(0);const a=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Xc(e,t);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r):void 0,h={id:s,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Yc(e,r,n),patterns:{},sortKey:c};a.push(h);}i&&a.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:o,featureIndex:l}=e,u=this.addConstantDashes(o);for(const n of a){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(u&&this.addFeatureDashes(n,o),this.hasPattern){const t=Kp("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,o.positions,e.availableImages,e.brightness);l.insert(t[s].feature,i,s,a,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let a,o;if("constant"===i.kind){if(a=i.value,!a)continue}else a=i.evaluate({zoom:r},t);o="constant"===s.kind?s.value:s.evaluate({zoom:r},t),e.addDash(a,o),t.patterns[n.id]=e.getKey(a,o);}}update(t,e,r,n,i){const s=0!==Object.keys(t).length;s&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(t,e,s?this.stateDependentLayers:this.layers,r,n,i);}addFeatures(t,e,r,n,i,s){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n,s);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Ld)),0!==this.patternVertexArray.length&&(this.patternVertexBuffer=t.createVertexBuffer(this.patternVertexArray,Fd)),!this.zOffsetVertexBuffer&&this.zOffsetVertexArray.length>0&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,$d.members,!0)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Rd),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy(),this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s,a){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap").evaluate(t,{}),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,n,l,u,c,h);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n,a);}addLine(t,e,r,n,i,s,a){this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.currentVertex=void 0;const o={zoom:this.zoom,lineProgress:void 0},l=this.layers[0].layout,u="none"===n;if(this.patternJoinNone=this.hasPattern&&u,this.segmentStart=0,this.segmentStartf32=0,this.segmentPoints=[],this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const c="Polygon"===Wd[e.type];let h=t.length;for(;h>=2&&t[h-1].equals(t[h-2]);)h--;let p=0;for(;p<h-1&&t[p].equals(t[p+1]);)p++;if(h<(c?3:2))return;"bevel"===n&&(s=1.05);const f=this.overscaling<=16?15*ps/(512*this.overscaling):0,d=this.segments.prepareSegment(10*h,this.layoutVertexArray,this.indexArray);let m,y,g,x,b,v;this.e1=this.e2=-1,c&&(m=t[h-2],b=t[p].sub(m)._unit()._perp());for(let r=p;r<h;r++){if(g=r===h-1?c?t[p+1]:void 0:t[r+1],g&&t[r].equals(g))continue;if(b&&(x=b),m&&(y=m),m=t[r],this.hasZOffset){const t=l.get("line-z-offset").value;if("constant"===t.kind)v=t.value;else {if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);o.lineProgress=(t*this.lineClips.start+this.distance+(y?y.dist(m):0))/t;}else fr(`line-z-offset evaluation for ${this.layerIds[0]} requires enabling 'lineMetrics' for the source.`),o.lineProgress=0;v=t.evaluate(o,e);}v=v||0;}b=g?g.sub(m)._unit()._perp():x,x=x||b;const _=y&&g;let w=_?n:c||u?"butt":i;const M=x.x*b.x+x.y*b.y;if(u){const t=function(t){if(t.patternJoinNone){const e=t.segmentPoints.length/2,r=t.lineSoFar-t.segmentStart;for(let n=0;n<e;++n){const e=t.segmentPoints[2*n+1],i=Math.round(t.segmentPoints[2*n])+.5+.25*e;t.patternVertexArray.emplaceBack(i,r,t.segmentStart),t.patternVertexArray.emplaceBack(i,r,t.segmentStart);}t.segmentPoints.length=0;}t.e1=t.e2=-1;};if(_&&M<Qd){this.updateDistance(y,m),this.addCurrentVertex(m,x,1,1,d,v),t(this),this.addCurrentVertex(m,b,-1,-1,d,v);continue}if(y){if(!g){this.updateDistance(y,m),this.addCurrentVertex(m,x,1,1,d,v),t(this);continue}w="miter";}}let A=x.add(b);0===A.x&&0===A.y||A._unit();const S=A.x*b.x+A.y*b.y,I=0!==S?1/S:1/0,T=2*Math.sqrt(2-2*S),k=S<Jd&&y&&g,P=x.x*b.y-x.y*b.x>0;if(k&&r>p){const t=m.dist(y);if(t>2*f){const e=m.sub(m.sub(y)._mult(f/t)._round());this.updateDistance(y,e),this.addCurrentVertex(e,x,0,0,d,v),y=e;}}if(_&&"round"===w&&(I<a?w="miter":I<=2&&(w="fakeround")),"miter"===w&&I>s&&(w="bevel"),"bevel"===w&&(I>2&&(w="flipbevel"),I<s&&(w="miter")),y&&this.updateDistance(y,m),"miter"===w)A._mult(I),this.addCurrentVertex(m,A,0,0,d,v);else if("flipbevel"===w){if(I>100)A=b.mult(-1);else {const t=I*x.add(b).mag()/x.sub(b).mag();A._perp()._mult(t*(P?-1:1));}this.addCurrentVertex(m,A,0,0,d,v),this.addCurrentVertex(m,A.mult(-1),0,0,d,v);}else if("bevel"===w||"fakeround"===w){const t=-Math.sqrt(I*I-1),e=P?t:0,r=P?0:t;if(y&&this.addCurrentVertex(m,x,e,r,d,v),"fakeround"===w){const t=Math.round(180*T/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+M*(M*(3.55645-1.43519*M)-3.2452))*t*t+(.848013+M*(.215638*M-1.06021)));}const n=b.sub(x)._mult(r)._add(x)._unit()._mult(P?-1:1);this.addHalfVertex(m,n.x,n.y,!1,P,0,d,v);}}g&&this.addCurrentVertex(m,b,-e,-r,d,v);}else "butt"===w?this.addCurrentVertex(m,A,0,0,d,v):"square"===w?(y||this.addCurrentVertex(m,A,-1,-1,d,v),this.addCurrentVertex(m,A,0,0,d,v),y&&this.addCurrentVertex(m,A,1,1,d,v)):"round"===w&&(y&&(this.addCurrentVertex(m,x,0,0,d,v),this.addCurrentVertex(m,x,1,1,d,v,!0)),g&&(this.addCurrentVertex(m,b,-1,-1,d,v,!0),this.addCurrentVertex(m,b,0,0,d,v)));if(k&&r<h-1){const t=m.dist(g);if(t>2*f){const e=m.add(g.sub(m)._mult(f/t)._round());this.updateDistance(m,e),this.addCurrentVertex(e,b,0,0,d,v),m=e;}}}}addVerticesTo(t,e,r,n,i,s,a,o,l,u){const c=(e.w-t.w)/this.tessellationStep|0;if(c>1){this.lineSoFar=t.w;const h=(e.x-t.x)/c,p=(e.y-t.y)/c,f=(e.z-t.z)/c,d=(e.w-t.w)/c;for(let e=1;e<c;++e)t.x+=h,t.y+=p,t.z+=f,this.lineSoFar+=d,this.addHalfVertex(t,r,n,u,!1,a,l,t.z),this.addHalfVertex(t,i,s,u,!0,-o,l,t.z);}this.lineSoFar=e.w,this.addHalfVertex(e,r,n,u,!1,a,l,e.z),this.addHalfVertex(e,i,s,u,!0,-o,l,e.z);}addCurrentVertex(t,e,r,n,i,s,a=!1){const o=e.x+e.y*r,l=e.y-e.x*r,u=e.y*n-e.x,c=-e.y-e.x*n;if(null!=s){const e=-10,h=ps+10,p=s,f=new Tf(t.x,t.y,p,this.lineSoFar),d=em(t,e,h),m=this.lineSoFar;if(this.currentVertex)if(d){const s=this.currentVertexIsOutside,f=this.currentVertex,d=new Tf(t.x,t.y,p,this.lineSoFar);zf(f,d,e,h),em(d,e,h)||(s&&(this.e1=this.e2=-1,this.lineSoFar=f.w,this.addHalfVertex(f,o,l,a,!1,r,i,f.z),this.addHalfVertex(f,u,c,a,!0,-n,i,f.z)),this.addVerticesTo(f,d,o,l,u,c,r,n,i,a));}else {const t=this.currentVertex;this.currentVertexIsOutside&&(zf(t,f,e,h),this.e1=this.e2=-1,this.lineSoFar=t.w,this.addHalfVertex(t,o,l,a,!1,r,i,t.z),this.addHalfVertex(t,u,c,a,!0,-n,i,t.z)),this.addVerticesTo(t,f,o,l,u,c,r,n,i,a);}else d||(this.addHalfVertex(t,o,l,a,!1,r,i,s),this.addHalfVertex(t,u,c,a,!0,-n,i,s));this.currentVertex=f,this.currentVertexIsOutside=d,this.lineSoFar=m;}else this.addHalfVertex(t,o,l,a,!1,r,i,s),this.addHalfVertex(t,u,c,a,!0,-n,i,s);}addHalfVertex({x:t,y:e},r,n,i,s,a,o,l){this.patternJoinNone&&(0===this.segmentPoints.length&&(this.segmentStart=this.lineSoFar,this.segmentStartf32=Math.fround(this.lineSoFar)),s||this.segmentPoints.push(this.lineSoFar-this.segmentStart,a)),this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar-this.segmentStartf32),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineClips.start,this.lineClips.end);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),o.primitiveLength++),s?this.e2=u:this.e1=u,null!=l&&this.zOffsetVertexArray.emplaceBack(l);}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}function em(t,e,r){return t.x<e||t.x>r||t.y<e||t.y>r}Mo(tm,"LineBucket",{omit:["layers","patternFeatures","currentVertex","currentVertexIsOutside"]});const rm=new ol({"line-cap":new sl(ll.layout_line["line-cap"]),"line-join":new sl(ll.layout_line["line-join"]),"line-miter-limit":new il(ll.layout_line["line-miter-limit"]),"line-round-limit":new il(ll.layout_line["line-round-limit"]),"line-sort-key":new sl(ll.layout_line["line-sort-key"]),"line-z-offset":new sl(ll.layout_line["line-z-offset"]),visibility:new il(ll.layout_line.visibility)});var nm={paint:new ol({"line-opacity":new sl(ll.paint_line["line-opacity"]),"line-color":new sl(ll.paint_line["line-color"]),"line-translate":new il(ll.paint_line["line-translate"]),"line-translate-anchor":new il(ll.paint_line["line-translate-anchor"]),"line-width":new sl(ll.paint_line["line-width"]),"line-gap-width":new sl(ll.paint_line["line-gap-width"]),"line-offset":new sl(ll.paint_line["line-offset"]),"line-blur":new sl(ll.paint_line["line-blur"]),"line-dasharray":new sl(ll.paint_line["line-dasharray"]),"line-pattern":new sl(ll.paint_line["line-pattern"]),"line-gradient":new al(ll.paint_line["line-gradient"]),"line-trim-offset":new il(ll.paint_line["line-trim-offset"]),"line-trim-fade-range":new il(ll.paint_line["line-trim-fade-range"]),"line-trim-color":new il(ll.paint_line["line-trim-color"]),"line-emissive-strength":new il(ll.paint_line["line-emissive-strength"]),"line-border-width":new sl(ll.paint_line["line-border-width"]),"line-border-color":new sl(ll.paint_line["line-border-color"]),"line-occlusion-opacity":new il(ll.paint_line["line-occlusion-opacity"])}),layout:rm};function im(t,e,r){return e*(ps/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}function sm(t,e){return 1/im(t,1,e.tileZoom)}function am(t,e,r,n){return t.translatePosMatrix(n||e.tileID.projMatrix,e,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const om=t=>{const e=[];lm(t)&&e.push("RENDER_LINE_DASH"),t.paint.get("line-gradient")&&e.push("RENDER_LINE_GRADIENT");const r=t.paint.get("line-trim-offset");0===r[0]&&0===r[1]||e.push("RENDER_LINE_TRIM_OFFSET"),0!==t.paint.get("line-border-width").constantOr(1)&&e.push("RENDER_LINE_BORDER");const n="none"===t.layout.get("line-join").constantOr("miter"),i=!!t.paint.get("line-pattern").constantOr(1);return n&&i&&e.push("LINE_JOIN_NONE"),e};function lm(t){const e=t.paint.get("line-dasharray").value;return e.value||"constant"!==e.kind}class um{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}var cm={
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
read:function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},write:function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*m;}},hm=fm,pm=cm;function fm(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}fm.Varint=0,fm.Fixed64=1,fm.Bytes=2,fm.Fixed32=5;var dm=4294967296,mm=1/dm,ym="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function gm(t){return t.type===fm.Bytes?t.readVarint()+t.pos:t.pos+1}function xm(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function bm(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function vm(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function _m(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function wm(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Mm(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Am(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Sm(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Im(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Tm(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function km(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Pm(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function zm(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Em(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}fm.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Pm(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Em(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Pm(this.buf,this.pos)+Pm(this.buf,this.pos+4)*dm;return this.pos+=8,t},readSFixed64:function(){var t=Pm(this.buf,this.pos)+Em(this.buf,this.pos+4)*dm;return this.pos+=8,t},readFloat:function(){var t=pm.read(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=pm.read(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return xm(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return xm(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return xm(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return xm(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return xm(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return xm(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&ym?function(t,e,r){return ym.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==fm.Bytes)return t.push(this.readVarint(e));var r=gm(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==fm.Bytes)return t.push(this.readSVarint());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==fm.Bytes)return t.push(this.readBoolean());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==fm.Bytes)return t.push(this.readFloat());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==fm.Bytes)return t.push(this.readDouble());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==fm.Bytes)return t.push(this.readFixed32());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==fm.Bytes)return t.push(this.readSFixed32());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==fm.Bytes)return t.push(this.readFixed64());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==fm.Bytes)return t.push(this.readSFixed64());var e=gm(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===fm.Varint)for(;this.buf[this.pos++]>127;);else if(e===fm.Bytes)this.pos=this.readVarint()+this.pos;else if(e===fm.Fixed32)this.pos+=4;else {if(e!==fm.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),zm(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),zm(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),zm(this.buf,-1&t,this.pos),zm(this.buf,Math.floor(t*mm),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),zm(this.buf,-1&t,this.pos),zm(this.buf,Math.floor(t*mm),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&bm(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),pm.write(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),pm.write(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&bm(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,fm.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,vm,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,_m,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Am,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,wm,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Mm,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Sm,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Im,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Tm,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,km,e);},writeBytesField:function(t,e){this.writeTag(t,fm.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,fm.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,fm.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,fm.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,fm.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,fm.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,fm.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,fm.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,fm.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,fm.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};var Bm=p(hm);const Dm=["id","tile","layer","source","sourceLayer","state"];class Cm{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};for(const e of Dm)void 0!==this[e]&&(t[e]=this[e]);return t}}class Rm{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const n=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][n]=this.stateChanges[t][n]||{},er(this.stateChanges[t][n],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==n&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][n]){this.deletedStates[t][n]={};for(const e in this.state[t][n])r[e]||(this.deletedStates[t][n][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][n]&&null===this.deletedStates[t][n][e]&&delete this.deletedStates[t][n][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const n=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][n]&&(this.deletedStates[t][n]=this.deletedStates[t][n]||{},this.deletedStates[t][n][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][n])for(r in this.deletedStates[t][n]={},this.stateChanges[t][n])this.deletedStates[t][n][r]=null;else this.deletedStates[t][n]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),n=er({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete n[t];}return n}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),er(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else if(this.state[t][r])for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},er(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const n in t)t[n].setFeatureState(r,e);}}class Vm{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new _o(ps,16,0),this.featureIndexArray=new vu,this.promoteId=e,this.is3DTile=!1;}insert(t,e,r,n,i,s=0,a=0){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const l=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}0!==a&&(n[0]-=a,n[1]-=a,n[2]+=a,n[3]+=a),n[0]<ps&&n[1]<ps&&n[2]>=0&&n[3]>=0&&l.insert(o,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Af(new Bm(this.rawTileData)).layers,this.sourceLayerCoder=new um(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},s=pl(i.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,r,n)=>oh(a.bufferedTilespaceGeometry,t,e,r,n)));u.sort(Om);let c=null;o.elevation&&u.length>0&&(c=Qf.create(o.elevation,this.tileID));const h={};let p;for(let l=0;l<u.length;l++){const f=u[l];if(f===p)continue;p=f;const d=this.featureIndexArray.get(f);let m=null;if(this.is3DTile){const t=this.bucketLayerIDs[0][0],r=e[t];if("model"!==r.type)continue;const{queryFeature:n,intersectionZ:i}=r.queryIntersectsMatchingFeature(a,d.featureIndex,s,o);n&&this.appendToResult(h,t,d.featureIndex,n,i);}else this.loadMatchingFeature(h,d,s,i.layers,i.availableImages,e,r,n,((e,r,n,i=0)=>(m||(m=Yc(e,this.tileID.canonical,t.tileTransform)),r.queryIntersectsFeature(a,e,n,m,this.z,t.transform,t.pixelPosMatrix,c,i))));}return h}loadMatchingFeature(t,e,r,n,i,s,a,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,f=this.bucketLayerIDs[c];if(n&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(n,f))return;const d=this.sourceLayerCoder.decode(h),m=this.vtLayers[d].feature(u);if(r.needGeometry){const t=Xc(m,!0);if(!r.filter(new Ho(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new Ho(this.tileID.overscaledZ),m))return;const y=this.getId(m,d);for(let e=0;e<f.length;e++){const r=f[e];if(n&&n.indexOf(r)<0)continue;const c=s[r];if(!c)continue;let h={};void 0!==y&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",y));const d=!l||l(m,c,h,p);if(!d)continue;const g=new Cm(m,this.z,this.x,this.y,y),x=er({},a[r]);x.paint=Lm(x.paint,c.paint,m,h,i),x.layout=Lm(x.layout,c.layout,m,h,i),g.layer=x,this.appendToResult(t,r,u,g,d);}}appendToResult(t,e,r,n,i){let s=t[e];void 0===s&&(s=t[e]=[]),s.push({featureIndex:r,feature:n,intersectionZ:i});}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=pl(i);for(const i of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:n,featureIndex:i,layoutVertexArrayOffset:0},u,s,a,o,e);return l}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n="string"==typeof this.promoteId?this.promoteId:this.promoteId[e];null!=n&&(r=t.properties[n]),"boolean"==typeof r&&(r=Number(r));}return r}}function Lm(t,e,r,n,i){return ur(t,((t,s)=>{const a=e instanceof nl?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function Om(t,e){return e-t}Mo(Vm,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});var Fm=24;const Um=128;function Nm(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Ho(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Ho(a)),maxSize:r.evaluate(new Ho(o)),interpolationType:n}}}function jm(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/Um:"composite"===t.kind?Gn(n/Um,i/Um,r):e}function qm(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?Ke(va.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=Gn(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}}var $m=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:Um,evaluateSizeForFeature:jm,evaluateSizeForZoom:qm,getSizeData:Nm});function Gm(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Zo.applyArabicShaping&&(t=Zo.applyArabicShaping(t)),t}(t.text,e,r);})),t}const Ym={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function Xm(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function Zm(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}const Hm=3;function Km(t,e,r){e.glyphs=[],1===t&&r.readMessage(Wm,e);}function Wm(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Jm,{});e.glyphs.push({id:t,bitmap:new pp({width:i+2*Hm,height:s+2*Hm},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Jm(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Qm=Hm,ty={horizontal:1,vertical:2,horizontalOnly:3};class ey{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new ey;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new ey;return e.imageName=t,e}}class ry{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new ry;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCodePoint(t){return this.text.codePointAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&Do(i)&&!Ym[t[n+1]]||s&&Do(s)&&!Ym[t[n-1]])||!Ym[t[n]]?t[n]:Ym[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&iy[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&iy[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new ry;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(ey.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.namePrimary:"";if(0===e.length)return void fr("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCodePoint(r),this.sections.push(ey.forImage(e)),this.sectionIndex.push(this.sections.length-1)):fr("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function ny(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d){const m=ry.fromFeature(t,i);h===ty.vertical&&m.verticalizePunctuation(p);let y=[];const g=function(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=ay(t.getCodePoint(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCodePoint(r);if(iy[p]||(u+=ay(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904||!(ko["Bopomofo Extended"](c)||ko.Bopomofo(c)||ko["CJK Compatibility Forms"](c)||ko["CJK Compatibility Ideographs"](c)||ko["CJK Compatibility"](c)||ko["CJK Radicals Supplement"](c)||ko["CJK Strokes"](c)||ko["CJK Symbols and Punctuation"](c)||ko["CJK Unified Ideographs Extension A"](c)||ko["CJK Unified Ideographs"](c)||ko["Enclosed CJK Letters and Months"](c)||ko["Halfwidth and Fullwidth Forms"](c)||ko.Hiragana(c)||ko["Ideographic Description Characters"](c)||ko["Kangxi Radicals"](c)||ko["Katakana Phonetic Extensions"](c)||ko.Katakana(c)||ko["Vertical Forms"](c)||ko["Yi Radicals"](c)||ko["Yi Syllables"](c)));(sy[p]||e||h.imageName)&&a.push(uy(r+1,u,o,a,ly(p,t.getCodePoint(r+1),e&&l),!1));}}var c;return cy(uy(t.length(),u,o,a,0,!0))}(m,u,s,e,n,f),{processBidirectionalText:x,processStyledBidirectionalText:b}=Zo;if(x&&1===m.sections.length){const t=x(m.toString(),g);for(const e of t){const t=new ry;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);y.push(t);}}else if(b){const t=b(m.text,m.sectionIndex,g);for(const e of t){const t=new ry;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,y.push(t);}}else y=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,g);const v=[],_={positionedLines:v,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0;const m="right"===o?1:"left"===o?0:.5;let y=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.imageName)continue;const r=e[t.fontStack];if(r&&(y=void 0!==r.ascender&&void 0!==r.descender,!y))break}if(!y)break}let g=0;for(const a of i){a.trim();const i=a.getMaxScale(),o=(i-1)*Fm,b={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=b;const v=b.positionedGlyphs;let _=0;if(!a.length()){f+=s,++g;continue}let w=0,M=0;for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),m=a.getCodePoint(s);let g=o.scale,b=null,A=null,S=null,I=Fm,T=0;const k=!(l===ty.horizontal||!c&&!Bo(m)||c&&(iy[m]||(x=m,ko.Arabic(x)||ko["Arabic Supplement"](x)||ko["Arabic Extended-A"](x)||ko["Arabic Presentation Forms-A"](x)||ko["Arabic Presentation Forms-B"](x))));if(o.imageName){const e=n[o.imageName];if(!e)continue;S=o.imageName,t.iconsInText=t.iconsInText||!0,A=e.paddedRect;const r=e.displaySize;g=g*Fm/h,b={width:r[0],height:r[1],left:0,top:-Qm,advance:k?r[1]:r[0],localGlyph:!1},T=y?-b.height*g:i*Fm-17-r[1]*g,I=b.advance;const s=(k?r[0]:r[1])*g-Fm*i;s>0&&s>_&&(_=s);}else {const t=r[o.fontStack];if(!t)continue;t[m]&&(A=t[m]);const n=e[o.fontStack];if(!n)continue;const s=n.glyphs[m];if(!s)continue;if(b=s.metrics,I=8203!==m?Fm:0,y){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;w<r&&(w=r,M=(t-e)/2*g),T=-t*g;}else T=(i-g)*Fm-17;}k?(t.verticalizable=!0,v.push({glyph:m,imageName:S,x:p,y:f+T,vertical:k,scale:g,localGlyph:b.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:b,rect:A}),p+=I*g+u):(v.push({glyph:m,imageName:S,x:p,y:f+T,vertical:k,scale:g,localGlyph:b.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:b,rect:A}),p+=b.advance*g+u);}0!==v.length&&(d=Math.max(p-u,d),y?py(v,m,_,M,s*i/2):py(v,m,_,0,s/2)),p=0;const A=s*i+_;b.lineOffset=Math.max(_,o),f+=A,++g;}var x;const b=f,{horizontalAlign:v,verticalAlign:_}=hy(a);((function(t,e,r,n,i,s){const a=(e-r)*i,o=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=a,t.y+=o;}))(t.positionedLines,m,v,_,d,b),t.top+=-_*b,t.bottom=t.top+b,t.left+=-v*d,t.right=t.left+d,t.hasBaseline=y;}(_,e,r,n,y,a,o,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(v)&&_}const iy={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},sy={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function ay(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*Fm/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function oy(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function ly(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function uy(t,e,r,n,i,s){let a=null,o=oy(e,r,i,s);for(const t of n){const n=oy(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function cy(t){return t?cy(t.priorBreak).concat(t.index):[]}function hy(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function py(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,a=t[s],o=(a.x+a.metrics.advance*a.scale)*e;for(let e=0;e<=s;e++)t[e].x-=o,t[e].y+=r+n+i;}function fy(t,e,r,n){const{horizontalAlign:i,verticalAlign:s}=hy(n),a=r[0]-t.displaySize[0]*i,o=r[1]-t.displaySize[1]*s;return {imagePrimary:t,imageSecondary:e,top:o,bottom:o+t.displaySize[1],left:a,right:a+t.displaySize[0]}}function dy(t,e,r,n,i,s){const a=t.imagePrimary;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,m=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+m+n[2]):(c=i[1]+(d+m-a.displaySize[1])/2,p=c+a.displaySize[1]),{imagePrimary:a,imageSecondary:void 0,top:c,right:h,bottom:p,left:f,collisionPadding:o}}class my extends Ne{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new my(this.x,this.y,this.z,this.angle,this.segment)}}function yy(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function gy(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function xy(t,e,r){return t?.6*e*r:0}function by(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function vy(t,e,r,n,i,s){const a=xy(r,i,s),o=by(r,n)*s;let l=0;const u=gy(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Gn(n.x,i.x,c),p=Gn(n.y,i.y,c),f=new my(h,p,0,i.angleTo(n),r);return !a||yy(t,f,o,a,e)?f:void 0}l+=s;}}function _y(t,e,r,n,i,s,a,o,l){const u=xy(n,s,a),c=by(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),wy(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function wy(t,e,r,n,i,s,a,o,l){const u=s/2,c=gy(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),m=o.angleTo(a);for(;p+r<h+d;){p+=r;const y=(p-h)/d,g=Gn(a.x,o.x,y),x=Gn(a.y,o.y,y);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new my(g,x,0,m,e);n&&!yy(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=wy(t,h/2,r,n,i,s,a,!0,l)),f}function My(t,e,r,n,i){const s=[];for(let a=0;a<t.length;a++){const o=t[a];let l;for(let t=0;t<o.length-1;t++){let a=o[t],u=o[t+1];a.x<e&&u.x<e||(a.x<e?a=new Ne(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x<e&&(u=new Ne(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y<r&&u.y<r||(a.y<r?a=new Ne(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round():u.y<r&&(u=new Ne(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round()),a.x>=n&&u.x>=n||(a.x>=n?a=new Ne(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x>=n&&(u=new Ne(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y>=i&&u.y>=i||(a.y>=i?a=new Ne(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round():u.y>=i&&(u=new Ne(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round()),l&&a.equals(l[l.length-1])||(l=[a],s.push(l)),l.push(u)))));}}return s}function Ay(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}Mo(my,"Anchor");const Sy=1;class Iy{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+Sy,this.paddedRect.y+Sy]}get br(){return [this.paddedRect.x+this.paddedRect.w-Sy,this.paddedRect.y+this.paddedRect.h-Sy]}get displaySize(){return [(this.paddedRect.w-2*Sy)/this.pixelRatio,(this.paddedRect.h-2*Sy)/this.pixelRatio]}}class Ty{constructor(t,e,r){const n={},i={};this.haveRenderCallbacks=[];const s=[];this.addImages(t,n,s),this.addImages(e,i,s);const{w:a,h:o}=Ay(s),l=new fp({width:a||1,height:o||1});for(const e in t){const i=t[e],s=n[e].paddedRect;fp.copy(i.data,l,{x:0,y:0},{x:s.x+Sy,y:s.y+Sy},i.data,r,i.sdf);}for(const t in e){const n=e[t],s=i[t].paddedRect,a=s.x+Sy,o=s.y+Sy,u=n.data.width,c=n.data.height;fp.copy(n.data,l,{x:0,y:0},{x:a,y:o},n.data,r),fp.copy(n.data,l,{x:0,y:c-1},{x:a,y:o-1},{width:u,height:1},r),fp.copy(n.data,l,{x:0,y:0},{x:a,y:o+c},{width:u,height:1},r),fp.copy(n.data,l,{x:u-1,y:0},{x:a-1,y:o},{width:1,height:c},r),fp.copy(n.data,l,{x:0,y:0},{x:a+u,y:o},{width:1,height:c},r);}this.image=l,this.iconPositions=n,this.patternPositions=i;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2*Sy,h:i.data.height+2*Sy};r.push(s),e[n]=new Iy(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e,r){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e,r))),t.dispatchRenderCallbacks(this.haveRenderCallbacks,r);for(const n in t.getUpdatedImages(r))this.patchUpdatedImage(this.iconPositions[n],t.getImage(n,r),e),this.patchUpdatedImage(this.patternPositions[n],t.getImage(n,r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl,s=!!Object.keys(this.patternPositions).length;r.update(e.data,{useMipmap:s},{x:n,y:i});}}Mo(Iy,"ImagePosition"),Mo(Ty,"ImageAtlas");const ky=1e20;function Py(t,e,r,n,i,s,a,o,l){for(let u=e;u<e+n;u++)zy(t,r*s+u,s,i,a,o,l);for(let u=r;u<r+i;u++)zy(t,u*s+e,1,n,a,o,l);}function zy(t,e,r,n,i,s,a){s[0]=0,a[0]=-ky,a[1]=ky,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=s[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=a[l]&&--l>-1);l++,s[l]=o,a[l]=u,a[l+1]=ky;}for(let o=0,l=0;o<n;o++){for(;a[l+1]<o;)l++;const n=s[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const Ey=2,By={none:0,ideographs:1,all:2};class Dy{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t,e){this.urls[e]=t;}getGlyphs(t,e,r){const i=[],s=this.urls[e]||n.GLYPHS_URL;for(const e in t)for(const r of t[e])i.push({stack:e,id:r});Qe(i,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let i=n.glyphs[e];if(void 0!==i)return void r(null,{stack:t,id:e,glyph:i});if(i=this._tinySDF(n,t,e),i)return n.glyphs[e]=i,void r(null,{stack:t,id:e,glyph:i});const a=Math.floor(e/256);if(256*a>65535)return void r(new Error("glyphs > 65535 not supported"));if(n.ranges[a])return void r(null,{stack:t,id:e,glyph:i});let o=n.requests[a];o||(o=n.requests[a]=[],Dy.loadGlyphRange(t,a,s,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[a]=!0;}for(const r of o)r(t,e);delete n.requests[a];}))),o.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,e)=>{if(t)r(t);else if(e){const t={};for(const{stack:r,id:n,glyph:i}of e)void 0===t[r]&&(t[r]={}),void 0===t[r].glyphs&&(t[r].glyphs={}),t[r].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[r].ascender=this.entries[r].ascender,t[r].descender=this.entries[r].descender;r(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==By.none&&(this.localGlyphMode===By.all?!!this.localFontFamily:!!this.localFontFamily&&(ko["CJK Unified Ideographs"](t)||ko["Hangul Syllables"](t)||ko.Hiragana(t)||ko.Katakana(t)||ko["CJK Symbols and Punctuation"](t)||ko["CJK Unified Ideographs Extension A"](t)||ko["CJK Unified Ideographs Extension B"](t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new Dy.TinySDF({fontFamily:n,fontWeight:r,fontSize:24*Ey,buffer:3*Ey,radius:8*Ey}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCodePoint(r),{data:a,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new pp({width:o,height:l},a),metrics:{width:u/Ey,height:c/Ey,left:h/Ey,top:p/Ey-27,advance:f/Ey,localGlyph:!0}}}}Dy.loadGlyphRange=function(t,e,r,n,i){const s=256*e,a=s+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),Wr.Glyphs);en(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new Bm(t).readFields(Km,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},Dy.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:a="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${a} ${s} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),a=Math.ceil(r),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-i))),l=Math.min(this.size-this.buffer,a+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return f;const{ctx:d,buffer:m,gridInner:y,gridOuter:g}=this;d.clearRect(m,m,o,l),d.fillText(t,m,m+a);const x=d.getImageData(m,m,o,l);g.fill(ky,0,h),y.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+m)*u+e+m;if(1===r)g[n]=0,y[n]=ky;else {const t=.5-r;g[n]=t>0?t*t:0,y[n]=t<0?t*t:0;}}Py(g,0,0,u,c,u,this.f,this.v,this.z),Py(y,m,m,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(y[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};const Cy=Sy;function Ry(t,e,r,n){const i=[],s=t.imagePrimary,a=s.pixelRatio,o=s.paddedRect.w-2*Cy,l=s.paddedRect.h-2*Cy,u=t.right-t.left,c=t.bottom-t.top,h=s.stretchX||[[0,o]],p=s.stretchY||[[0,l]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),m=p.reduce(f,0),y=o-d,g=l-m;let x=0,b=d,v=0,_=m,w=0,M=y,A=0,S=g;if(s.content&&n){const t=s.content;x=Vy(h,0,t[0]),v=Vy(p,0,t[1]),b=Vy(h,t[0],t[2]),_=Vy(p,t[1],t[3]),w=t[0]-x,A=t[1]-v,M=t[2]-t[0]-b,S=t[3]-t[1]-_;}const I=(n,i,o,l)=>{const h=Oy(n.stretch-x,b,u,t.left),p=Fy(n.fixed-w,M,n.stretch,d),f=Oy(i.stretch-v,_,c,t.top),y=Fy(i.fixed-A,S,i.stretch,m),g=Oy(o.stretch-x,b,u,t.left),I=Fy(o.fixed-w,M,o.stretch,d),T=Oy(l.stretch-v,_,c,t.top),k=Fy(l.fixed-A,S,l.stretch,m),P=new Ne(h,f),z=new Ne(g,f),E=new Ne(g,T),B=new Ne(h,T),D=new Ne(p/a,y/a),C=new Ne(I/a,k/a),R=e*Math.PI/180;if(R){const t=Math.sin(R),e=Math.cos(R),r=[e,-t,t,e];P._matMult(r),z._matMult(r),B._matMult(r),E._matMult(r);}const V=n.stretch+n.fixed,L=o.stretch+o.fixed,O=i.stretch+i.fixed,F=l.stretch+l.fixed,U=t.imageSecondary;return {tl:P,tr:z,bl:B,br:E,texPrimary:{x:s.paddedRect.x+Cy+V,y:s.paddedRect.y+Cy+O,w:L-V,h:F-O},texSecondary:U?{x:U.paddedRect.x+Cy+V,y:U.paddedRect.y+Cy+O,w:L-V,h:F-O}:void 0,writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:D,pixelOffsetBR:C,minFontScaleX:M/a/u,minFontScaleY:S/a/c,isSDF:r}};if(n&&(s.stretchX||s.stretchY)){const t=Ly(h,y,d),e=Ly(p,g,m);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(I(n,e[t],s,e[t+1]));}}else i.push(I({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:o+1},{fixed:0,stretch:l+1}));return i}function Vy(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Ly(t,e,r){const n=[{fixed:-Cy,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+Cy,stretch:r}),n}function Oy(t,e,r,n){return t/e*r+n}function Fy(t,e,r,n){return t-e*r/n}function Uy(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}function Ny(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,a=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>a)&&(a=e.y);}const l=Math.min(s-n,a-i);let u=l/2;const c=new hs([],jy);if(0===l)return new Ne(n,i);for(let e=n;e<s;e+=l)for(let r=i;r<a;r+=l)c.push(new qy(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new qy(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new qy(n.p.x-u,n.p.y-u,u,t)),c.push(new qy(n.p.x+u,n.p.y-u,u,t)),c.push(new qy(n.p.x-u,n.p.y+u,u,t)),c.push(new qy(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function jy(t,e){return e.max-t.max}class qy{constructor(t,e,r,n){this.p=new Ne(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,ih(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const $y=Number.POSITIVE_INFINITY,Gy=Math.sqrt(2);function Yy(t,[e,r]){let n=0,i=0;if(r===$y){e<0&&(e=0);const r=e/Gy;switch(t){case"top-right":case"top-left":i=r-7;break;case"bottom-right":case"bottom-left":i=7-r;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":n=-r;break;case"top-left":case"bottom-left":n=r;break;case"left":n=e;break;case"right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}}return [n,i]}function Xy(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Zy(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d){let m=s.textMaxSize.evaluate(e,{},h);void 0===m&&(m=a);const y=t.layers[0].layout,g=y.get("icon-offset").evaluate(e,{},h),x=Jy(r.horizontal)||r.vertical,b="globe"===p.name,v=Fm,_=a/v,w=t.tilePixelRatio*m/v,M=(E=t.overscaling,t.zoom>18&&E>2&&(E>>=1),Math.max(ps/(512*E),1)*y.get("symbol-spacing")),A=y.get("text-padding")*t.tilePixelRatio,S=y.get("icon-padding")*t.tilePixelRatio,I=$e(y.get("text-max-angle")),T="map"===y.get("text-rotation-alignment")&&"point"!==y.get("symbol-placement"),k="map"===y.get("icon-rotation-alignment")&&"point"!==y.get("symbol-placement"),P=y.get("symbol-placement"),z=M/2;var E;const B=y.get("icon-text-fit").evaluate(e,{},h),D=y.get("icon-text-fit-padding").evaluate(e,{},h),C="none"!==B;let R;!1===t.hasAnyIconTextFit&&C&&(t.hasAnyIconTextFit=!0),n&&C&&(t.allowVerticalPlacement&&r.vertical&&(R=dy(n,r.vertical,B,D,g,_)),x&&(n=dy(n,x,B,D,g,_)));const V=(a,o,m)=>{if(o.x<0||o.x>=ps||o.y<0||o.y>=ps)return;let y=null;if(b){const{x:t,y:e,z:r}=p.projectTilePoint(o.x,o.y,m);y={anchor:new my(t,e,r,0,void 0),up:p.upVector(m,o.x,o.y)};}!function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g,x,b,v,_,w,M,A,S,I){const T=t.addToLineVertexArray(e,n);let k,P,z,E,B,D,C,R=0,V=0,L=0,O=0,F=-1,U=-1;const N={};let j=Bn("");const q=r?r.anchor:e,$="none"!==l.layout.get("icon-text-fit").evaluate(v,{},A);let G=0,Y=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[G,Y]=l.layout.get("text-offset").evaluate(v,{},A).map((t=>t*Fm)):(G=l.layout.get("text-radial-offset").evaluate(v,{},A)*Fm,Y=$y),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)D=tg(t),o&&(C=tg(o));else {const r=l.layout.get("text-rotate").evaluate(v,{},A)+90;z=Qy(u,q,e,c,h,p,t,f,r,m),o&&(E=Qy(u,q,e,c,h,p,o,g,r));}}if(s){const n=l.layout.get("icon-rotate").evaluate(v,{},A),i=Ry(s,n,w,$),a=o?Ry(o,n,w,$):void 0;P=Qy(u,q,e,c,h,p,s,g,n),R=4*i.length;const f=t.iconSizeData;let d=null;"source"===f.kind?(d=[Um*l.layout.get("icon-size").evaluate(v,{},A)],d[0]>Ky&&fr(`${t.layerIds[0]}: Value for "icon-size" is >= ${Hy}. Reduce your "icon-size".`)):"composite"===f.kind&&(d=[Um*_.compositeIconSizes[0].evaluate(v,{},A),Um*_.compositeIconSizes[1].evaluate(v,{},A)],(d[0]>Ky||d[1]>Ky)&&fr(`${t.layerIds[0]}: Value for "icon-size" is >= ${Hy}. Reduce your "icon-size".`)),t.addSymbols(t.icon,i,d,b,x,v,!1,r,e,T.lineStartIndex,T.lineLength,-1,M,A,S,I),F=t.icon.placedSymbolArray.length-1,a&&(V=4*a.length,t.addSymbols(t.icon,a,d,b,x,v,ty.vertical,r,e,T.lineStartIndex,T.lineLength,-1,M,A,S,I),U=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=i.horizontal[n];k||(j=Bn(s.text),d?B=tg(s):k=Qy(u,q,e,c,h,p,s,f,l.layout.get("text-rotate").evaluate(v,{},A),m));const o=1===s.positionedLines.length;if(L+=Wy(t,r,e,s,a,l,d,v,m,T,i.vertical?ty.horizontal:ty.horizontalOnly,o?Object.keys(i.horizontal):[n],N,F,_,M,A,S),o)break}i.vertical&&(O+=Wy(t,r,e,i.vertical,a,l,d,v,m,T,ty.vertical,["vertical"],N,U,_,M,A,S));let X=-1;const Z=(t,e)=>t?Math.max(t,e):e;X=Z(B,X),X=Z(D,X),X=Z(C,X);const H=X>-1?1:0;t.glyphOffsetArray.length>=65535&&fr("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==v.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,v.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,q.x,q.y,q.z,N.right>=0?N.right:-1,N.center>=0?N.center:-1,N.left>=0?N.left:-1,N.vertical>=0?N.vertical:-1,F,U,j,void 0!==k?k:t.collisionBoxArray.length,void 0!==k?k+1:t.collisionBoxArray.length,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,void 0!==P?P:t.collisionBoxArray.length,void 0!==P?P+1:t.collisionBoxArray.length,E||t.collisionBoxArray.length,E?E+1:t.collisionBoxArray.length,c,L,O,R,V,H,0,G,Y,X,0,1,1,$?1:0);}(t,o,y,a,r,n,i,R,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,A,T,l,0,S,k,g,e,s,u,c,h,f,d);};if("line"===P)for(const i of My(e.geometry,0,0,ps,ps)){const e=_y(i,M,I,r.vertical||x,n,v,w,t.overscaling,ps);for(const r of e)x&&eg(t,x.text,z,r)||V(i,r,h);}else if("line-center"===P){for(const t of e.geometry)if(t.length>1){const e=vy(t,I,r.vertical||x,n,v,w);e&&V(t,e,h);}}else if("Polygon"===e.type)for(const t of Xp(e.geometry,0)){const e=Ny(t,16);V(t[0],new my(e.x,e.y,0,0,void 0),h);}else if("LineString"===e.type)for(const t of e.geometry)V(t,new my(t[0].x,t[0].y,0,0,void 0),h);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)V([e],new my(e.x,e.y,0,0,void 0),h);}const Hy=255,Ky=Hy*Um;function Wy(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m,y,g){const x=function(t,e,r,n,i,s,a,o){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let d=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];d=Uy(e,f,d,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let s=Qm+1,h=!0,p=1,f=0;if(t.imageName){const e=a[t.imageName];if(!e)continue;if(e.sdf){fr("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,s=Sy/p;}const m=(i||o)&&t.vertical,y=t.metrics.advance*t.scale/2,g=t.metrics,x=t.rect;if(null===x)continue;o&&e.verticalizable&&(f=t.imageName?y-t.metrics.width*t.scale/2:0);const b=i?[t.x+y,t.y]:[0,0];let v=[0,0],_=[0,0],w=!1;i||(m?(_=[t.x+y+c[0],t.y+c[1]-f],w=!0):v=[t.x+y+r[0],t.y+r[1]-f]);const M=x.w*t.scale/(p*(t.localGlyph?Ey:1)),A=x.h*t.scale/(p*(t.localGlyph?Ey:1));let S,I,T,k;if(m){const e=t.y-d,r=new Ne(-y,y-e),n=-Math.PI/2,i=new Ne(..._);S=new Ne(-y+v[0],v[1]),S._rotateAround(n,r)._add(i),S.x+=-e+y,S.y-=(g.left-s)*t.scale;const a=t.imageName?g.advance*t.scale:Fm*t.scale,o=String.fromCodePoint(t.glyph);Xm(o)?S.x+=(1-s)*t.scale:Zm(o)?S.x+=a-g.height*t.scale+(-s-1)*t.scale:S.x+=t.imageName||g.width+2*s===x.w&&g.height+2*s===x.h?(a-A)/2:(a-(g.height+2*s)*t.scale)/2,I=new Ne(S.x,S.y-M),T=new Ne(S.x+A,S.y),k=new Ne(S.x+A,S.y-M);}else {const e=(g.left-s)*t.scale-y+v[0],r=(-g.top-s)*t.scale+v[1],n=e+M,i=r+A;S=new Ne(e,r),I=new Ne(n,r),T=new Ne(e,i),k=new Ne(n,i);}if(u){let t;t=i?new Ne(0,0):w?new Ne(c[0],c[1]):new Ne(r[0],r[1]),S._rotateAround(u,t),I._rotateAround(u,t),T._rotateAround(u,t),k._rotateAround(u,t);}const P=new Ne(0,0),z=new Ne(0,0);l.push({tl:S,tr:I,bl:T,br:k,texPrimary:n,texSecondary:void 0,writingMode:e.writingMode,glyphOffset:b,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:P,pixelOffsetBR:z,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,s,a,o,i,t.allowVerticalPlacement),b=t.textSizeData;let v=null;"source"===b.kind?(v=[Um*s.layout.get("text-size").evaluate(o,{},y)],v[0]>Ky&&fr(`${t.layerIds[0]}: Value for "text-size" is >= ${Hy}. Reduce your "text-size".`)):"composite"===b.kind&&(v=[Um*d.compositeTextSizes[0].evaluate(o,{},y),Um*d.compositeTextSizes[1].evaluate(o,{},y)],(v[0]>Ky||v[1]>Ky)&&fr(`${t.layerIds[0]}: Value for "text-size" is >= ${Hy}. Reduce your "text-size".`)),t.addSymbols(t.text,x,v,l,a,o,c,e,r,u.lineStartIndex,u.lineLength,f,m,y,g,!1);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function Jy(t){for(const e in t)return t[e];return null}function Qy(t,e,r,n,i,s,a,o,l,u){let c=a.top,h=a.bottom,p=a.left,f=a.right;const d=a.collisionPadding;if(d&&(p-=d[0],c-=d[1],f+=d[2],h+=d[3]),l){const t=new Ne(p,c),e=new Ne(f,c),r=new Ne(p,h),n=new Ne(f,h),i=$e(l);let s=new Ne(0,0);u&&(s=new Ne(u[0],u[1])),t._rotateAround(i,s),e._rotateAround(i,s),r._rotateAround(i,s),n._rotateAround(i,s),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,o,n,i,s),t.length-1}function tg(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function eg(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function rg(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01)),a=Math.sin(t._pitch)*s+i;return Math.min(1.01*a,i*(1/t._horizonShift))}function ng(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,a=(t.y+1)*r,o=zc(n),l=zc(i),u=Ec(s),c=Ec(a),h=e.project(o,u),p=e.project(l,u),f=e.project(l,c),d=e.project(o,c);let m=Math.min(h.x,p.x,f.x,d.x),y=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const b=r/16;function v(t,r,n,i,s,a){const o=(n+s)/2,l=(i+a)/2,u=e.project(zc(o),Ec(l)),c=Math.max(0,m-u.x,y-u.y,u.x-g,u.y-x);m=Math.min(m,u.x),g=Math.max(g,u.x),y=Math.min(y,u.y),x=Math.max(x,u.y),c>b&&(v(t,u,n,i,o,l),v(u,r,o,l,s,a));}v(h,p,n,s,i,s),v(p,f,i,s,i,a),v(f,d,i,a,n,a),v(d,h,n,a,n,s),m-=b,y-=b,g+=b,x+=b;const _=1/Math.max(g-m,x-y);return {scale:_,x:m*_,y:y*_,x2:g*_,y2:x*_,projection:e}}function ig(t,{x:e,y:r},n=0){return new Ne(((e-n)*t.scale-t.x)*ps,(r*t.scale-t.y)*ps)}const sg=t.ad.identity(new Float32Array(16));class ag{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new mc(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r=!0){return t._coordinatePoint(t.locationCoordinate(e),r)}pixelsPerMeter(t,e){return Pc(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return rg(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),s=new Ne(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(s,n))}pointCoordinate3D(t,e,r){const n=new Ne(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation&&t.elevation.visibleDemTiles.length)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return sg}createTileMatrix(e,r,n){let i,s,a;const o=n.canonical,l=t.ad.identity(new Float64Array(16));if(this.isReprojectedInTileSpace){const u=ng(o,this);i=1,s=u.x+n.wrap*u.scale,a=u.y,t.ad.scale(l,l,[i/u.scale,i/u.scale,e.pixelsPerMeter/r]);}else i=r/e.zoomScale(o.z),s=(o.x+Math.pow(2,o.z)*n.wrap)*i,a=o.y*i;return t.ad.translate(l,l,[s,a,0]),t.ad.scale(l,l,[i/ps,i/ps,1]),l}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class og extends ag{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin($e(e));this.n=(n+Math.sin($e(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,s=$e(t-this.center[0]),a=$e(e),o=Math.sqrt(n-2*r*Math.sin(a))/r;return {x:o*Math.sin(s*r),y:o*Math.cos(s*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,s=i+e;let a=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(a-=Math.PI*Math.sign(t)*Math.sign(s));const o=$e(this.center[0])*r;a=Je(a,-Math.PI-o,Math.PI-o);const l=Ke(Ge(a/r)+this.center[0],-180,180),u=Math.asin(Ke((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=Ke(Ge(u),-Dc,Dc);return new mc(l,c)}}const lg=1.340264,ug=-.081106,cg=893e-6,hg=.003796,pg=Math.sqrt(3)/2;class fg extends ag{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(pg*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(pg*(lg+3*ug*n+i*(7*cg+9*hg*n)))/Math.PI+.5),y:1-.5*(r*(lg+ug*n+i*(cg+hg*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,a,o=0;o<12&&(s=r*(lg+ug*n+i*(cg+hg*n))-e,a=lg+3*ug*n+i*(7*cg+9*hg*n),t=s/a,r=Ke(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const s=pg*t*(lg+3*ug*n+i*(7*cg+9*hg*n))/Math.cos(r),a=Math.asin(Math.sin(r)/pg),o=Ke(180*s/Math.PI,-180,180),l=Ke(180*a/Math.PI,-Dc,Dc);return new mc(o,l)}}class dg extends ag{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=Ke(360*(.5-e),-Dc,Dc);return new mc(r,n)}}const mg=Math.PI/2;function yg(t){return Math.tan((mg+t)/2)}class gg extends ag{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=$e(e),i=$e(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const s=Math.cos(n),a=yg(n);this.n=n===i?Math.sin(n):Math.log(s/Math.cos(i))/Math.log(yg(i)/a),this.f=s*Math.pow(yg(n),this.n)/this.n;}project(t,e){e=$e(e),this.southernCenter&&(e=-e),t=$e(t-this.center[0]);const r=1e-6,{n,f:i}=this;i>0?e<-mg+r&&(e=-mg+r):e>mg-r&&(e=mg-r);const s=i/Math.pow(yg(e),n);let a=s*Math.sin(n*t),o=i-s*Math.cos(n*t);return a=.5*(a/Math.PI+.5),o=.5*(o/Math.PI+.5),{x:a,y:this.southernCenter?o:1-o,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,s=Math.sign(i),a=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*s;i*r<0&&(o-=Math.PI*Math.sign(t)*s);const l=Ke(Ge(o/r)+this.center[0],-180,180),u=Ke(Ge(2*Math.atan(Math.pow(n/a,1/r))-mg),-Dc,Dc);return new mc(l,this.southernCenter?-u:u)}}class xg extends ag{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:Tc(t),y:kc(e),z:0}}unproject(t,e){const r=zc(t),n=Ec(e);return new mc(r,n)}}const bg=$e(Dc);class vg extends ag{project(t,e){const r=(e=$e(e))*e,n=r*r;return {x:.5*((t=$e(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=Ke(r-i,-bg,bg);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const a=Ke(Ge(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),o=Ge(r);return new mc(a,o)}}const _g=$e(Dc);class wg extends ag{project(t,e){e=$e(e),t=$e(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,a=.5*(t*n+2*r*Math.sin(t/2)/s)||0,o=.5*(e+Math.sin(e)/s)||0;return {x:.5*(a/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let a=0,o=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,m=1-c*h*h,y=m?1/m:0,g=m?Math.acos(i*h)*Math.sqrt(1/m):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,b=.5*(g*s+n)-e,v=.5*y*(c*d+g*i*h*u)+1/Math.PI,_=y*(f*l/4-g*s*p),w=.125*y*(l*p-g*s*c*f),M=.5*y*(u*h+g*d*i)+.5,A=_*w-M*v;a=(b*_-x*M)/A,o=(x*w-b*v)/A,r=Ke(r-a,-Math.PI,Math.PI),n=Ke(n-o,-_g,_g);}while((Math.abs(a)>s||Math.abs(o)>s)&&--i>0);return new mc(Ge(r),Ge(n))}}class Mg extends ag{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos($e(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:$e(t)*n*r+.5,y:-Math.sin($e(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,s=Ke(Ge((t-.5)/r)/n,-180,180),a=Math.asin(Ke(i*n,-1,1)),o=Ke(Ge(a),-Dc,Dc);return new mc(s,o)}}class Ag extends xg{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(e,r,n){const i=Nh(e,r,n),s=$h(Ch(n));return t._.transformMat4(i,i,s),{x:i[0],y:i[1],z:i[2]}}locationPoint(e,r){const n=pc(r.lat,r.lng),i=t._.normalize([],n),s=e.elevation?e.elevation.getAtPointOrZero(e.locationCoordinate(r),e._centerAltitude):e._centerAltitude,a=Pc(1,0)*ps*s;t._.scaleAndAdd(n,n,i,a);const o=t.ad.identity(new Float64Array(16));return t.ad.multiply(o,e.pixelMatrix,e.globeMatrix),t._.transformMat4(n,n,o),new Ne(n[0],n[1])}pixelsPerMeter(t,e){return Pc(1,0)*e}pixelSpaceConversion(t,e,r){const n=Pc(1,t)*e,i=Gn(Pc(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(e,r,n){const i=Gh(Ch(n.canonical));return t.ad.multiply(new Float64Array(16),e.globeMatrix,i)}createInversionMatrix(e,r){const{center:n}=e,i=$h(Ch(r));return t.ad.rotateY(i,i,$e(n.lng)),t.ad.rotateX(i,i,$e(n.lat)),t.ad.scale(i,i,[e._pixelsPerMercatorPixel,e._pixelsPerMercatorPixel,1]),Float32Array.from(i)}pointCoordinate(t,e,r,n){return Eh(t,e,r,!0)||new Oc(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Eh(t,e.x,e.y,!1)}farthestPixelDistance(e){const r=function(e,r){const n=e.cameraToCenterDistance,i=e._centerAltitude*r,s=e._camera,a=e._camera.forward(),o=t._.add([],t._.scale([],a,-n),[0,0,i]),l=e.worldSize/(2*Math.PI),u=[0,0,-l],c=e.width/e.height,h=Math.tan(e.fovAboveCenter),p=t._.scale([],s.up(),h),f=t._.scale([],s.right(),h*c),d=t._.normalize([],t._.add([],t._.add([],a,p),f)),m=[];let y;if(new gh(o,d).closestPointOnSphere(u,l,m)){const r=t._.add([],m,u),n=t._.sub([],r,o);y=Math.cos(e.fovAboveCenter)*t._.length(n);}else {const e=t._.sub([],o,u),r=t._.sub([],u,o);t._.normalize(r,r);const n=t._.length(e)-l;y=Math.sqrt(n*(n+2*l));const i=Math.acos(y/(l+n))-Math.acos(t._.dot(a,r));y*=Math.cos(i);}return 1.01*y}(e,this.pixelsPerMeter(e.center.lat,e.worldSize)),n=Hh(e.zoom);if(n>0){const t=rg(e,Pc(1,e.center.lat)*e.worldSize),i=e.worldSize/(2*Math.PI),s=Math.max(e.width,e.height)/e.worldSize*Math.PI;return Gn(r,t+i*(1-Math.cos(s)),Math.pow(n,10))}return r}upVector(t,e,r){return Nh(e,r,t,1)}upVectorScale(t){return {metersToTile:Ph(jh(Ch(t)))}}}function Sg(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case"mercator":return new xg(t);case"equirectangular":return new dg(t);case"naturalEarth":return new vg(t);case"equalEarth":return new fg(t);case"winkelTripel":return new wg(t);case"albers":return r?new Mg(t):new og(t);case"lambertConformalConic":return r?new Mg(t):new gg(t);case"globe":return new Ag(t)}throw new Error(`Invalid projection name: ${t.name}`)}class Ig{constructor(t,e,r,n){this.id=Ig.uniqueIdxCounter,Ig.uniqueIdxCounter++,this.context=t;const i=t.gl;this.buffer=i.createBuffer(),this.dynamicDraw=Boolean(r),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),i.bufferData(i.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?i.DYNAMIC_DRAW:i.STATIC_DRAW),this.dynamicDraw||n||e.destroy();}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){this.id=Ig.uniqueIdxCounter,Ig.uniqueIdxCounter++;const e=this.context.gl;this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}Ig.uniqueIdxCounter=0;class Tg{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}Tg.ReadOnly=!1,Tg.ReadWrite=!0,Tg.disabled=new Tg(519,Tg.ReadOnly,[0,1]);const kg=7680;class Pg{constructor(t,e,r,n,i,s){this.test=t,this.ref=e,this.mask=r,this.fail=n,this.depthFail=i,this.pass=s;}}Pg.disabled=new Pg({func:519,mask:0},0,0,kg,kg,kg);const zg=771;class Eg{constructor(t,e,r,n){this.blendFunction=t,this.blendColor=e,this.mask=r,this.blendEquation=n;}}Eg.Replace=[1,0,1,0],Eg.disabled=new Eg(Eg.Replace,qn.transparent,[!1,!1,!1,!1]),Eg.unblended=new Eg(Eg.Replace,qn.transparent,[!0,!0,!0,!0]),Eg.alphaBlended=new Eg([1,zg,1,zg],qn.transparent,[!0,!0,!0,!0]),Eg.alphaBlendedNonPremultiplied=new Eg([770,zg,770,zg],qn.transparent,[!0,!0,!0,!0]),Eg.multiply=new Eg([774,0,774,0],qn.transparent,[!0,!0,!0,!0]);const Bg=1029,Dg=2305;class Cg{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}Cg.disabled=new Cg(!1,Bg,Dg),Cg.backCCW=new Cg(!0,Bg,Dg),Cg.backCW=new Cg(!0,Bg,2304),Cg.frontCW=new Cg(!0,1028,2304),Cg.frontCCW=new Cg(!0,1028,Dg);const Rg=Sf.types,Vg=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Lg(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(Ky,Math.round(o[0])):0,d=o?Math.min(Ky,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Og(t,e,r){t.emplaceBack(e,r);}function Fg(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,a);}function Ug(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function Ng(t){for(const e of t.sections)if(Vo(e.text))return !0;return !1}class jg{constructor(t){this.layoutVertexArray=new $l,this.indexArray=new Ql,this.programConfigurations=t,this.segments=new Au,this.dynamicLayoutVertexArray=new Fl,this.opacityVertexArray=new Yl,this.occlusionQueryOpacityVertexArray=new Xl,this.placedSymbolArray=new du,this.iconTransitioningVertexArray=new Zl,this.globeExtVertexArray=new Gl,this.zOffsetVertexArray=new Xl;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(t,e,r,n,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ud.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,jd.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Vg,!0),this.occlusionQueryOpacityVertexBuffer=t.createVertexBuffer(this.occlusionQueryOpacityVertexArray,qd.members,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=t.createVertexBuffer(this.iconTransitioningVertexArray,Gd.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Nd.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||i)&&(this.zOffsetVertexBuffer=t.createVertexBuffer(this.zOffsetVertexArray,$d.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.occlusionQueryOpacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy());}}Mo(jg,"SymbolBuffers");class qg{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Au,this.collisionVertexArray=new Jl,this.collisionVertexArrayExt=new Fl;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Yd.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,Xd.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}Mo(qg,"CollisionBuffers");class $g{constructor(e){this.queries=new Map,this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.lut=e.lut,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=t.ad.identity([]),this.placementViewportMatrix=t.ad.identity([]);const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Nm(this.zoom,r["text-size"]),this.iconSizeData=Nm(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap=n.get("text-allow-overlap")||n.get("icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&void 0!==i.constantOr(1),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=n.get("text-writing-mode").map((t=>ty[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID,this.projection=e.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=n.get("symbol-z-elevate"),this.activeReplacements=[],this.replacementUpdateTime=0;}createArrays(){this.text=new jg(new Wu(this.layers,{zoom:this.zoom,lut:this.lut},(t=>/^text/.test(t)))),this.icon=new jg(new Wu(this.layers,{zoom:this.zoom,lut:this.lut},(t=>/^icon/.test(t)))),this.glyphOffsetArray=new gu,this.lineVertexArray=new xu,this.symbolInstances=new yu;}calculateGlyphDependencies(t,e,r,n,i){for(let r=0;r<t.length;r++){const s=t.codePointAt(r);if(void 0===s)break;if(e[s]=!0,n&&i&&s<=65535){const n=Ym[t.charAt(r)];n&&(e[n.charCodeAt(0)]=!0);}}}updateFootprints(t,e){}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);return !Cf(this.activeReplacements,r)&&(this.activeReplacements=r,!0)}populate(e,r,n,i){const s=this.layers[0],a=s.layout,o="globe"===this.projection.name,l=a.get("text-font"),u=a.get("text-field"),c=a.get("icon-image"),h=("constant"!==u.value.kind||u.value.value instanceof mi&&!u.value.value.isEmpty()||u.value.value.toString().length>0)&&("constant"!==l.value.kind||l.value.value.length>0),p="constant"!==c.value.kind||!!c.value.value||Object.keys(c.parameters).length>0,f=a.get("symbol-sort-key");if(this.features=[],!h&&!p)return;const d=r.iconDependencies,m=r.glyphDependencies,y=r.availableImages,g=new Ho(this.zoom);for(const{feature:r,id:u,index:c,sourceLayerIndex:x}of e){const e=s._featureFilter.needGeometry,b=Xc(r,e);if(!s._featureFilter.filter(g,b,n))continue;if(e||(b.geometry=Yc(r,n,i)),o&&1!==r.type&&n.z<=5){const e=b.geometry,r=.98078528056,i=(e,i)=>{const s=Nh(e.x,e.y,n,1),a=Nh(i.x,i.y,n,1);return t._.dot(s,a)<r};for(let t=0;t<e.length;t++)e[t]=jc(e[t],i);}let v,_;if(h){const t=s.getValueAndResolveTokens("text-field",b,n,y),e=mi.factory(t);Ng(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Yo()||this.hasRTLText&&Zo.isParsed())&&(v=Gm(e,s,b));}if(p){const t=s.getValueAndResolveTokens("icon-image",b,n,y);_=t instanceof yi?t:yi.fromString(t);}if(!v&&!_)continue;const w=this.sortFeaturesByKey?f.evaluate(b,{},n):void 0;if(this.features.push({id:u,text:v,icon:_,index:c,sourceLayerIndex:x,geometry:b.geometry,properties:r.properties,type:Rg[r.type],sortKey:w}),_&&(d[_.namePrimary]=!0,_.nameSecondary&&(d[_.nameSecondary]=!0)),v){const t=l.evaluate(b,{},n).join(","),e="map"===a.get("text-rotation-alignment")&&"point"!==a.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(ty.vertical)>=0;for(const r of v.sections)if(r.image)d[r.image.namePrimary]=!0;else {const n=Po(v.toString()),i=r.fontStack||t,s=m[i]=m[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}"line"===a.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n,i){const s=0!==Object.keys(t).length;if(s&&!this.stateDependentLayers.length)return;const a=s?this.stateDependentLayers:this.layers;this.text.programConfigurations.updatePaintArrays(t,e,a,r,n,i),this.icon.programConfigurations.updatePaintArrays(t,e,a,r,n,i);}updateOcclusionOpacities(t,e,r){if(!e.useOcclusionQueries)return !1;const n=this;if("globe"===n.projection.name)return !1;let i=!1;n.hasTextData()&&(i=i||0!==n.text.occlusionQueryOpacityVertexArray.length),n.hasIconData()&&(i=i||0!==n.icon.occlusionQueryOpacityVertexArray.length);const s=n.layers[0].paint,a=s.get("icon-occlusion-opacity").constantOr(0),o=s.get("text-occlusion-opacity").constantOr(0);if(!n.layers[0].hasInitialOcclusionOpacityProperties||1===a&&1===o)return !1;let l=!i;for(let t=0;t<n.symbolInstances.length;t++){const i=n.symbolInstances.get(t),s=i.occlusionOpacity;i.occlusionOpacity+=(i.occlusionState>.5?1:-1)*e.fadeSpeed*r*.001,i.occlusionOpacity=Ke(i.occlusionOpacity,0,1),l=l||i.occlusionOpacity!==s;}if(!l)return !1;let u=0,c=0;const h=(t,e,r,n)=>{let i=0,s=0;r?(i=c,c+=n,s=c):(i=u,u+=n,s=u),s>e.occlusionQueryOpacityVertexArray.length&&e.occlusionQueryOpacityVertexArray.resize(s);const a=t.occlusionOpacity;for(let t=0;t<n;t++)e.occlusionQueryOpacityVertexArray.emplace(t+i,a);};for(let t=0;t<n.symbolInstances.length;t++){const e=n.symbolInstances.get(t),{numHorizontalGlyphVertices:r,numVerticalGlyphVertices:i,numIconVertices:s}=e,a=s>0;if((r>0||i>0)&&(h(e,n.text,!1,r),h(e,n.text,!1,i)),a){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=e;t>=0&&h(e,n.icon,!0,s),r>=0&&h(e,n.icon,!0,e.numVerticalIconVertices);}}return n.hasTextData()&&n.text.occlusionQueryOpacityVertexBuffer&&(n.text.occlusionQueryOpacityVertexBuffer.length<n.text.occlusionQueryOpacityVertexArray.length?n.text.occlusionQueryOpacityVertexBuffer=t.createVertexBuffer(n.text.occlusionQueryOpacityVertexArray,qd.members,!0):n.text.occlusionQueryOpacityVertexBuffer.updateData(n.text.occlusionQueryOpacityVertexArray)),n.hasIconData()&&n.icon.occlusionQueryOpacityVertexBuffer&&(n.icon.occlusionQueryOpacityVertexBuffer.length<n.icon.occlusionQueryOpacityVertexArray.length?n.icon.occlusionQueryOpacityVertexBuffer=t.createVertexBuffer(n.icon.occlusionQueryOpacityVertexArray,qd.members,!0):n.icon.occlusionQueryOpacityVertexBuffer.updateData(n.icon.occlusionQueryOpacityVertexArray)),!0}updateZOffset(){const t=(t,e,n)=>{r+=e,r>t.length&&t.resize(r);for(let i=-e;i<0;i++)t.emplace(i+r,n);},e=(t,e,r)=>{n+=e,n>t.length&&t.resize(n);for(let i=-e;i<0;i++)t.emplace(i+n,r);};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let r=0,n=0;for(let r=0;r<this.symbolInstances.length;r++){const n=this.symbolInstances.get(r),{numHorizontalGlyphVertices:i,numVerticalGlyphVertices:s,numIconVertices:a}=n,o=n.zOffset,l=a>0;if((i>0||s>0)&&(t(this.text.zOffsetVertexArray,i,o),t(this.text.zOffsetVertexArray,s,o)),l){const{placedIconSymbolIndex:t,verticalPlacedIconSymbolIndex:r}=n;t>=0&&e(this.icon.zOffsetVertexArray,a,o),r>=0&&e(this.icon.zOffsetVertexArray,n.numVerticalIconVertices,o);}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray);}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=Sg(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();for(const t of this.queries.values())t.destroy();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,m){const y=t.indexArray,g=t.layoutVertexArray,x=t.globeExtVertexArray,b=t.segments.prepareSegment(4*e.length,g,y,this.canOverlap?s.sortKey:void 0),v=this.glyphOffsetArray.length,_=b.vertexLength,w=this.allowVerticalPlacement&&a===ty.vertical?Math.PI/2:0,M=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:a,bl:u,br:c,texPrimary:h,texSecondary:v,pixelOffsetTL:_,pixelOffsetBR:A,minFontScaleX:S,minFontScaleY:I,glyphOffset:T,isSDF:k,sectionIndex:P}=e[n],z=b.vertexLength,E=T[1];if(Lg(g,l.x,l.y,i.x,E+i.y,h.x,h.y,r,k,_.x,_.y,S,I),Lg(g,l.x,l.y,a.x,E+a.y,h.x+h.w,h.y,r,k,A.x,_.y,S,I),Lg(g,l.x,l.y,u.x,E+u.y,h.x,h.y+h.h,r,k,_.x,A.y,S,I),Lg(g,l.x,l.y,c.x,E+c.y,h.x+h.w,h.y+h.h,r,k,A.x,A.y,S,I),o){const{x:e,y:r,z:n}=o.anchor,[i,s,a]=o.up;Fg(x,e,r,n,i,s,a),Fg(x,e,r,n,i,s,a),Fg(x,e,r,n,i,s,a),Fg(x,e,r,n,i,s,a),Ug(t.dynamicLayoutVertexArray,e,r,n,w);}else Ug(t.dynamicLayoutVertexArray,l.x,l.y,l.z,w);if(m){const e=v||h;Og(t.iconTransitioningVertexArray,e.x,e.y),Og(t.iconTransitioningVertexArray,e.x+e.w,e.y),Og(t.iconTransitioningVertexArray,e.x,e.y+e.h),Og(t.iconTransitioningVertexArray,e.x+e.w,e.y+e.h);}y.emplaceBack(z,z+1,z+2),y.emplaceBack(z+1,z+2,z+3),b.vertexLength+=4,b.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(T[0]),n!==e.length-1&&P===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(g.length,s,s.index,{},p,f,d,M&&M[P]);}const A=o?o.anchor:l;t.placedSymbolArray.emplaceBack(A.x,A.y,A.z,l.x,l.y,v,this.glyphOffsetArray.length-v,_,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,Math.round(a.x),Math.round(a.y));}_addCollisionDebugVertices(t,e,r,n,i,s,a){const o=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=o.vertexLength,u=a.tileAnchorX,c=a.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);this._commitDebugCollisionVertexUpdate(r.collisionVertexArrayExt,e,t.padding,a.zOffset),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new Ne(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new Ne(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new Ne(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new Ne(t.x1,t.y2)),o.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),o.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new qg(Kl,Zd.members,Zl),this.iconCollisionBox=new qg(Kl,Zd.members,Zl);const r=qm(this.iconSizeData,t),n=qm(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._addTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=jm(this.textSizeData,t,i)/Fm;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=jm(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r,n){t.emplaceBack(e,-r,-r,n),t.emplaceBack(e,r,-r,n),t.emplaceBack(e,r,r,n),t.emplaceBack(e,-r,r,n);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding,s.zOffset);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=qm(this.iconSizeData,t),n=qm(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._updateTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(s<a){const{x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(s);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(o<l){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(o);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.tileAnchorX+r*a.tileAnchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let t=0;t<this.symbolInstances.length;++t)this.symbolInstanceIndexesSortedZOffset.push(t);}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((t,e)=>this.symbolInstances.get(e).zOffset-this.symbolInstances.get(t).zOffset))}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:s,placedIconSymbolIndex:a,verticalPlacedIconSymbolIndex:o}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),s>=0&&this.addIndicesForPlacedSymbol(this.text,s),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}Mo($g,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),$g.addDynamicAttributes=Ug;class Gg{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,{context:s}=this,{gl:a}=s;if(a.bindTexture(a.TEXTURE_2D,this.texture),s.pixelStoreUnpackFlipY.set(!1),s.pixelStoreUnpack.set(1),s.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),this.useMipmap=Boolean(e&&e.useMipmap),r||this.size&&this.size[0]===n&&this.size[1]===i){const{x:e,y:s}=r||{x:0,y:0};if(t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap)a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t);else {let r=this.format,o=a.UNSIGNED_BYTE;this.format===a.R32F&&(r=a.RED,o=a.FLOAT),a.texSubImage2D(a.TEXTURE_2D,0,e,s,n,i,r,o,t.data);}}else if(this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||ImageBitmap&&t instanceof ImageBitmap){let e=this.format;this.format===a.R8&&(e=a.RED),a.texImage2D(a.TEXTURE_2D,0,this.format,e,a.UNSIGNED_BYTE,t);}else {let e=this.format,r=this.format,s=a.UNSIGNED_BYTE,o=!1;this.format===a.DEPTH_COMPONENT&&(e=a.DEPTH_COMPONENT16,s=a.UNSIGNED_SHORT),this.format===a.DEPTH_STENCIL&&(e=a.DEPTH24_STENCIL8,s=a.UNSIGNED_INT_24_8,o=!0),this.format===a.R8&&(r=a.RED),this.format===a.R32F&&(s=a.FLOAT,r=a.RED),!this.useMipmap&&o?a.texStorage2D(a.TEXTURE_2D,1,e,n,i):a.texImage2D(a.TEXTURE_2D,0,e,n,i,0,r,s,t.data);}this.useMipmap&&a.generateMipmap(a.TEXTURE_2D);}bind(t,e,r=!1){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),t!==this.minFilter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,this.useMipmap&&!r?t===i.NEAREST?i.NEAREST_MIPMAP_NEAREST:i.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),e!==this.wrapS&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrapS=e);}bindExtraParam(t,e,r,n){const{context:i}=this,{gl:s}=i;s.bindTexture(s.TEXTURE_2D,this.texture),e!==this.magFilter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,e),this.magFilter=e),t!==this.minFilter&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,this.useMipmap?t===s.NEAREST?s.NEAREST_MIPMAP_NEAREST:s.LINEAR_MIPMAP_LINEAR:t),this.minFilter=t),r!==this.wrapS&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,r),this.wrapS=r),n!==this.wrapT&&(s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,n),this.wrapT=n);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Yg{constructor(t,e){this.context=t,this.texture=e;}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}}const Xg=32,Zg=33,Hg=new Uint16Array(8184);for(let t=0;t<2046;t++){let e=t+2,r=0,n=0,i=0,s=0,a=0,o=0;for(1&e?i=s=a=Xg:r=n=o=Xg;(e>>=1)>1;){const t=r+i>>1,l=n+s>>1;1&e?(i=r,s=n,r=a,n=o):(r=i,n=s,i=a,s=o),a=t,o=l;}const l=4*t;Hg[l+0]=r,Hg[l+1]=n,Hg[l+2]=i,Hg[l+3]=s;}const Kg=new Uint16Array(2178),Wg=new Uint8Array(1089),Jg=new Uint16Array(1089);function Qg(t){return 0===t?-.03125:32===t?.03125:0}var tx=Bl([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]),ex=Bl([{name:"a_index",type:"Int16",components:1}]);const rx=(()=>({type:2,extent:ps,loadGeometry:()=>[[new Ne(0,0),new Ne(ps+1,0),new Ne(ps+1,ps+1),new Ne(0,ps+1),new Ne(0,0)]]}))();class nx{constructor(t,e,r,n,i){this.tileID=t,this.uid=nr(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=i,n&&n.style&&(this._lastUpdatedBrightness=n.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",n&&n.transform&&(this.projection=n.transform.projection);}registerFadeDuration(t){const e=t+this.timeAdded;e<Dr.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=ng(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,e,r){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const n of t){const t=n.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){n.layers=t,n.stateDependentLayerIds&&(n.stateDependentLayers=n.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)r[e.fqid]=n;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof $g){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof $g&&e.hasRTLText){this.hasRTLText=!0,Zo.isLoading()||Zo.isLoaded()||"deferred"!==Yo()||Xo();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t],n=e.style.getOwnLayer(t);if(!n)continue;const i=n.queryRadius(r);this.queryPadding=Math.max(this.queryPadding,i);}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas),this._lastUpdatedBrightness=t.brightness;}else this.collisionBoxArray=new pu;}unloadVectorData(){if(this.hasData()){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}getBucket(t){return this.buckets[t.fqid]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl,r=this.imageAtlas;if(r&&!r.uploaded){const n=!!Object.keys(r.patternPositions).length;this.imageAtlasTexture=new Gg(t,r.image,e.RGBA,{useMipmap:n}),this.imageAtlas.uploaded=!0;}this.glyphAtlasImage&&(this.glyphAtlasTexture=new Gg(t,this.glyphAtlasImage,e.R8),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new Gg(t,this.lineAtlas.image,e.R8),this.lineAtlas.uploaded=!0);}prepare(t,e,r){if(this.imageAtlas&&this.imageAtlasTexture&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture,r),!e||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const n=e.style.getBrightness();(this._lastUpdatedBrightness||n)&&(this._lastUpdatedBrightness&&n&&Math.abs(this._lastUpdatedBrightness-n)<.001||(this._lastUpdatedBrightness=n,this.updateBuckets(void 0,e)));}queryRenderedFeatures(t,e,r,n,i,s,a,o){return this.latestFeatureIndex&&(this.latestFeatureIndex.rawTileData||this.latestFeatureIndex.is3DTile)?this.latestFeatureIndex.query({tileResult:n,pixelPosMatrix:a,transform:s,params:i,tileTransform:this.tileTransform},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const n=r.loadVTLayers(),i=e?e.sourceLayer:"",s=n._geojsonTileLayer||n[i];if(!s)return;const a=pl(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const n=s.feature(e);if(a.needGeometry){const t=Xc(n,!0);if(!a.filter(new Ho(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new Ho(this.tileID.overscaledZ),n))continue;const h=r.getId(n,i),p=new Cm(n,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}bucketsLoaded(){for(const t in this.buckets)if(this.buckets[t].uploadPending())return !1;return !0}patternsLoaded(){return !!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=xr(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const n=this.expirationTime-e;n?this.expirationTime=t+Math.max(n,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData&&0!==Object.keys(t).length&&e&&this.updateBuckets(t,e);}updateBuckets(t,e){if(!this.latestFeatureIndex)return;const r=this.latestFeatureIndex.loadVTLayers(),n=e.style.listImages(),i=e.style.getBrightness();for(const s in this.buckets){if(!e.style.hasLayer(s))continue;const a=this.buckets[s],o=a.layers[0].sourceLayer||"_geojsonTileLayer",l=r[o];let u={};if(t&&(u=t[o],!l||!u||0===Object.keys(u).length))continue;if(a.update(u,l,n,this.imageAtlas&&this.imageAtlas.patternPositions||{},i),a instanceof tm||a instanceof Wp){const t=e.style.getOwnSourceCache(a.layers[0].source);e._terrain&&e._terrain.enabled&&t&&a.programConfigurations.needsUpload&&e._terrain._clearRenderCacheForTile(t.id,this.tileID);}const c=e&&e.style&&e.style.getOwnLayer(s);c&&(this.queryPadding=Math.max(this.queryPadding,c.queryRadius(a)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<Dr.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=Dr.now()+t;}setTexture(t,e){const r=e.context,n=r.gl;this.texture=this.texture||e.getTileTexture(t.width),this.texture&&this.texture instanceof Gg?this.texture.update(t,{useMipmap:!0}):(this.texture=new Gg(r,t,n.RGBA,{useMipmap:!0}),this.texture.bind(n.LINEAR,n.CLAMP_TO_EDGE));}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,e){if(!e||"mercator"===e.name||this._tileDebugBuffer)return;const r=Yc(rx,this.tileID.canonical,this.tileTransform)[0],n=new Cl,i=new au;for(let t=0;t<r.length;t++){const{x:e,y:s}=r[t];n.emplaceBack(e,s),i.emplaceBack(t);}i.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(i),this._tileDebugBuffer=t.createVertexBuffer(n,kh.members),this._tileDebugSegments=Au.simpleSegment(0,0,n.length,i.length);}_makeTileBoundsBuffers(t,e){if(this._tileBoundsBuffer||!e||"mercator"===e.name)return;const r=Yc(rx,this.tileID.canonical,this.tileTransform)[0];let n,i;if(this.isRaster){const t=function(t,e){const r=ng(t,e),n=Math.pow(2,t.z);for(let i=0;i<Zg;i++)for(let s=0;s<Zg;s++){const a=zc((t.x+(s+Qg(s))/Xg)/n),o=Ec((t.y+(i+Qg(i))/Xg)/n),l=e.project(a,o),u=i*Zg+s;Kg[2*u+0]=Math.round((l.x*r.scale-r.x)*ps),Kg[2*u+1]=Math.round((l.y*r.scale-r.y)*ps);}Wg.fill(0),Jg.fill(0);for(let t=2045;t>=0;t--){const e=4*t,r=Hg[e+0],n=Hg[e+1],i=Hg[e+2],s=Hg[e+3],a=r+i>>1,o=n+s>>1,l=a+o-n,u=o+r-a,c=n*Zg+r,h=s*Zg+i,p=o*Zg+a,f=Math.hypot((Kg[2*c+0]+Kg[2*h+0])/2-Kg[2*p+0],(Kg[2*c+1]+Kg[2*h+1])/2-Kg[2*p+1])>=16;Wg[p]=Wg[p]||(f?1:0),t<1022&&(Wg[p]=Wg[p]||Wg[(n+u>>1)*Zg+(r+l>>1)]||Wg[(s+u>>1)*Zg+(i+l>>1)]);}const i=new Vl,s=new Ql;let a=0;function o(t,e){const r=e*Zg+t;return 0===Jg[r]&&(i.emplaceBack(Kg[2*r+0],Kg[2*r+1],t*ps/Xg,e*ps/Xg),Jg[r]=++a),Jg[r]-1}function l(t,e,r,n,i,a){const u=t+r>>1,c=e+n>>1;if(Math.abs(t-i)+Math.abs(e-a)>1&&Wg[c*Zg+u])l(i,a,t,e,u,c),l(r,n,i,a,u,c);else {const l=o(t,e),u=o(r,n),c=o(i,a);s.emplaceBack(l,u,c);}}return l(0,0,Xg,Xg,Xg,0),l(Xg,Xg,0,0,0,Xg),{vertices:i,indices:s}}(this.tileID.canonical,e);n=t.vertices,i=t.indices;}else {n=new Vl,i=new Ql;for(const{x:t,y:e}of r)n.emplaceBack(t,e,0,0);const t=wp(n.int16,void 0,4);for(let e=0;e<t.length;e+=3)i.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(n,tx.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(i),this._tileBoundsSegments=Au.simpleSegment(0,0,n.length,i.length);}_makeGlobeTileDebugBuffers(e,r){const n=r.projection;if(!n||"globe"!==n.name||r.freezeTileCoverage)return;const i=this.tileID.canonical,s=$h(Vh(i,r)),a=Hh(r.zoom);let o;a>0&&(o=t.ad.invert(new Float64Array(16),r.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(e,i,r,s,o,a),this._makeGlobeTileDebugTextBuffer(e,i,r,s,o,a);}_globePoint(e,r,n,i,s,a,o){let l=Nh(e,r,n);if(a){const s=1<<n.z,u=Tc(i.center.lng),c=kc(i.center.lat),h=(n.x+.5)/s-u;let p=0;h>.5?p=-1:h<-.5&&(p=1);let f=(e/ps+n.x)/s+p,d=(r/ps+n.y)/s;f=(f-u)*i._pixelsPerMercatorPixel+u,d=(d-c)*i._pixelsPerMercatorPixel+c;const m=[f*i.worldSize,d*i.worldSize,0];t._.transformMat4(m,m,a),l=Rh(l,m,o);}return t._.transformMat4(l,l,s)}_makeGlobeTileDebugBorderBuffer(t,e,r,n,i,s){const a=new Cl,o=new au,l=new Rl,u=(t,u,c,h,p)=>{const f=(c-t)/(p-1),d=(h-u)/(p-1),m=a.length;for(let c=0;c<p;c++){const h=t+c*f,p=u+c*d;a.emplaceBack(h,p);const y=this._globePoint(h,p,e,r,n,i,s);l.emplaceBack(y[0],y[1],y[2]),o.emplaceBack(m+c);}},c=ps;u(0,0,c,0,16),u(c,0,c,c,16),u(c,c,0,c,16),u(0,c,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(o),this._tileDebugBuffer=t.createVertexBuffer(a,kh.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(l,Th.members),this._tileDebugSegments=Au.simpleSegment(0,0,a.length,o.length);}_makeGlobeTileDebugTextBuffer(t,e,r,n,i,s){const a=ps/4,o=new Cl,l=new Ql,u=new Rl,c=25;l.reserve(32),o.reserve(c),u.reserve(c);const h=(t,e)=>c*t+e;for(let t=0;t<c;t++){const l=t*a;for(let t=0;t<c;t++){const c=t*a;o.emplaceBack(c,l);const h=this._globePoint(c,l,e,r,n,i,s);u.emplaceBack(h[0],h[1],h[2]);}}for(let t=0;t<4;t++)for(let e=0;e<4;e++){const r=h(t,e),n=h(t,e+1),i=h(t+1,e),s=h(t+1,e+1);l.emplaceBack(r,n,i),l.emplaceBack(i,n,s);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(l),this._tileDebugTextBuffer=t.createVertexBuffer(o,kh.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(u,Th.members),this._tileDebugTextSegments=Au.simpleSegment(0,0,c,32);}destroy(t=!1){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&(this.imageAtlasTexture.destroy(),delete this.imageAtlasTexture),this.glyphAtlasTexture&&(this.glyphAtlasTexture.destroy(),delete this.glyphAtlasTexture),this.lineAtlasTexture&&(this.lineAtlasTexture.destroy(),delete this.lineAtlasTexture),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),!t&&this.texture&&this.texture instanceof Gg&&(this.texture.destroy(),delete this.texture),this.hillshadeFBO&&(this.hillshadeFBO.destroy(),delete this.hillshadeFBO),this.dem&&delete this.dem,this.neighboringTiles&&delete this.neighboringTiles,this.demTexture&&(this.demTexture.destroy(),delete this.demTexture),this.rasterParticleState&&(this.rasterParticleState.destroy(),delete this.rasterParticleState),this.latestFeatureIndex=null,this.state="unloaded";}}function ix(t,e,r){1===t?e.header_length=r.readFixed32():2===t?e.x=r.readVarint():3===t?e.y=r.readVarint():4===t?e.z=r.readVarint():5===t&&e.layers.push(function(t,e){return t.readFields(ux,{version:0,name:"",units:"",tilesize:0,buffer:0,pixel_format:0,data_index:[]},e)}(r,r.readVarint()+r.pos));}function sx(t,e,r){1===t?(e.delta_filter=function(t,e){return t.readFields(ax,{block_size:0},e)}(r,r.readVarint()+r.pos),e.filter="delta_filter"):2===t?(r.readVarint(),e.filter="zigzag_filter"):3===t?(r.readVarint(),e.filter="bitshuffle_filter"):4===t&&(r.readVarint(),e.filter="byteshuffle_filter");}function ax(t,e,r){1===t&&(e.block_size=r.readVarint());}function ox(t,e,r){1===t?(r.readVarint(),e.codec="gzip_data"):2===t?(r.readVarint(),e.codec="jpeg_image"):3===t?(r.readVarint(),e.codec="webp_image"):4===t&&(r.readVarint(),e.codec="png_image");}function lx(t,e,r){1===t?e.first_byte=r.readFixed64():2===t?e.last_byte=r.readFixed64():3===t?e.filters.push(function(t,e){return t.readFields(sx,{},e)}(r,r.readVarint()+r.pos)):4===t?e.codec=function(t,e){return t.readFields(ox,{},e)}(r,r.readVarint()+r.pos):5===t?e.offset=r.readFloat():6===t?e.scale=r.readFloat():7===t&&e.bands.push(r.readString());}function ux(t,e,r){1===t?e.version=r.readVarint():2===t?e.name=r.readString():3===t?e.units=r.readString():4===t?e.tilesize=r.readVarint():5===t?e.buffer=r.readVarint():6===t?e.pixel_format=r.readVarint():7===t&&e.data_index.push(function(t,e){return t.readFields(lx,{first_byte:0,last_byte:0,filters:[],codec:null,offset:0,scale:0,bands:[]},e)}(r,r.readVarint()+r.pos));}function cx(t,e,r){if(2===t)!function(t,e,r){t.readFields(hx,r,e);}(r,r.readVarint()+r.pos,e);else if(3===t)throw new Error("Not implemented")}function hx(t,e,r){if(1===t){let t=0;const n=r.readVarint()+r.pos;for(;r.pos<n;)e[t++]=r.readVarint();}}
/**
 * tiny-lru
 *
 * @copyright 2024 Jason Mulligan <jason.mulligan@avoidwork.com>
 * @license BSD-3-Clause
 * @version 11.2.11
 */class px{constructor(t=0,e=0,r=!1){this.first=null,this.items=Object.create(null),this.last=null,this.max=t,this.resetTtl=r,this.size=0,this.ttl=e;}clear(){return this.first=null,this.items=Object.create(null),this.last=null,this.size=0,this}delete(t){if(this.has(t)){const e=this.items[t];delete this.items[t],this.size--,null!==e.prev&&(e.prev.next=e.next),null!==e.next&&(e.next.prev=e.prev),this.first===e&&(this.first=e.next),this.last===e&&(this.last=e.prev);}return this}entries(t=this.keys()){return t.map((t=>[t,this.get(t)]))}evict(t=!1){if(t||this.size>0){const t=this.first;delete this.items[t.key],0==--this.size?(this.first=null,this.last=null):(this.first=t.next,this.first.prev=null);}return this}expiresAt(t){let e;return this.has(t)&&(e=this.items[t].expiry),e}get(t){let e;if(this.has(t)){const r=this.items[t];this.ttl>0&&r.expiry<=Date.now()?this.delete(t):(e=r.value,this.set(t,e,!0));}return e}has(t){return t in this.items}keys(){const t=[];let e=this.first;for(;null!==e;)t.push(e.key),e=e.next;return t}set(t,e,r=!1,n=this.resetTtl){let i;if(r||this.has(t)){if(i=this.items[t],i.value=e,!1===r&&n&&(i.expiry=this.ttl>0?Date.now()+this.ttl:this.ttl),this.last!==i){const t=this.last,e=i.next,r=i.prev;this.first===i&&(this.first=i.next),i.next=null,i.prev=this.last,t.next=i,null!==r&&(r.next=e),null!==e&&(e.prev=r);}}else this.max>0&&this.size===this.max&&this.evict(!0),i=this.items[t]={expiry:this.ttl>0?Date.now()+this.ttl:this.ttl,key:t,prev:this.last,next:null,value:e},1==++this.size?this.first=i:this.last.next=i;return this.last=i,this}values(t=this.keys()){return t.map((t=>this.get(t)))}}function fx(t,e){if(4!==e.length)throw new Error(`Expected data of dimension 4 but got ${e.length}.`);let r=e[3];for(let n=2;n>=1;n--){const i=1===n?1:0,s=2===n?1:0;for(let n=0;n<e[0];n++){const a=e[1]*n;for(let n=i;n<e[1];n++){const i=e[2]*(n+a);for(let n=s;n<e[2];n++){const s=e[3]*(n+i);for(let n=0;n<e[3];n++){const e=s+n;t[e]+=t[e-r];}}}}r*=e[n];}return t}function dx(t){for(let e=0,r=t.length;e<r;e++)t[e]=t[e]>>>1^-(1&t[e]);return t}function mx(t,e){switch(e){case"uint32":return t;case"uint16":for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];t[e]=(240&r)>>4|(61440&r)>>8|(240&n)<<4|61440&n,t[e+1]=15&r|(3840&r)>>4|(15&n)<<8|(3840&n)<<4;}return t;case"uint8":for(let e=0;e<t.length;e+=4){const r=t[e],n=t[e+1],i=t[e+2],s=t[e+3];t[e+0]=(192&r)>>6|(192&n)>>4|(192&i)>>2|192&s,t[e+1]=(48&r)>>4|(48&n)>>2|48&i|(48&s)<<2,t[e+2]=(12&r)>>2|12&n|(12&i)<<2|(12&s)<<4,t[e+3]=3&r|(3&n)<<2|(3&i)<<4|(3&s)<<6;}return t;default:throw new Error(`Invalid pixel format, "${e}"`)}}class yx extends Error{constructor(t){super(t),this.name="MRTError";}}var gx=Uint8Array,xx=Uint16Array,bx=Int32Array,vx=new gx([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),_x=new gx([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),wx=new gx([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),Mx=function(t,e){for(var r=new xx(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new bx(r[30]);for(n=1;n<30;++n)for(var s=r[n];s<r[n+1];++s)i[s]=s-r[n]<<5|n;return {b:r,r:i}},Ax=Mx(vx,2),Sx=Ax.b,Ix=Ax.r;Sx[28]=258,Ix[258]=28;for(var Tx=Mx(_x,0).b,kx=new xx(32768),Px=0;Px<32768;++Px){var zx=(43690&Px)>>1|(21845&Px)<<1;kx[Px]=((65280&(zx=(61680&(zx=(52428&zx)>>2|(13107&zx)<<2))>>4|(3855&zx)<<4))>>8|(255&zx)<<8)>>1;}var Ex=function(t,e,r){for(var n=t.length,i=0,s=new xx(e);i<n;++i)t[i]&&++s[t[i]-1];var a,o=new xx(e);for(i=1;i<e;++i)o[i]=o[i-1]+s[i-1]<<1;if(r){a=new xx(1<<e);var l=15-e;for(i=0;i<n;++i)if(t[i])for(var u=i<<4|t[i],c=e-t[i],h=o[t[i]-1]++<<c,p=h|(1<<c)-1;h<=p;++h)a[kx[h]>>l]=u;}else for(a=new xx(n),i=0;i<n;++i)t[i]&&(a[i]=kx[o[t[i]-1]++]>>15-t[i]);return a},Bx=new gx(288);for(Px=0;Px<144;++Px)Bx[Px]=8;for(Px=144;Px<256;++Px)Bx[Px]=9;for(Px=256;Px<280;++Px)Bx[Px]=7;for(Px=280;Px<288;++Px)Bx[Px]=8;var Dx=new gx(32);for(Px=0;Px<32;++Px)Dx[Px]=5;var Cx=Ex(Bx,9,1),Rx=Ex(Dx,5,1),Vx=function(t){for(var e=t[0],r=1;r<t.length;++r)t[r]>e&&(e=t[r]);return e},Lx=function(t,e,r){var n=e/8|0;return (t[n]|t[n+1]<<8)>>(7&e)&r},Ox=function(t,e){var r=e/8|0;return (t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&e)},Fx=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],Ux=function(t,e,r){var n=new Error(e||Fx[t]);if(n.code=t,Error.captureStackTrace&&Error.captureStackTrace(n,Ux),!r)throw n;return n},Nx=new gx(0),jx="undefined"!=typeof TextDecoder&&new TextDecoder;try{jx.decode(Nx,{stream:!0});}catch(t){}const qx={gzip_data:"gzip"};const $x={0:"uint32",1:"uint32",2:"uint16",3:"uint8"},Gx={uint32:1,uint16:2,uint8:4},Yx={uint32:Uint32Array,uint16:Uint16Array,uint8:Uint8Array};class Xx{constructor(t=1){this.x=NaN,this.y=NaN,this.z=NaN,this.layers={},this._cacheSize=t;}getLayer(t){return this.layers[t]}getHeaderLength(t){const e=new Uint8Array(t),r=new DataView(t);if(13!==e[0])throw new yx("File is not a valid MRT.");return r.getUint32(1,!0)}parseHeader(t){const e=new Uint8Array(t),r=this.getHeaderLength(t);if(e.length<r)throw new yx(`Expected header with length >= ${r} but got buffer of length ${e.length}`);const n=function(t,e){return t.readFields(ix,{header_length:0,x:0,y:0,z:0,layers:[]},void 0)}(new Bm(e.subarray(0,r)));if(!isNaN(this.x)&&(this.x!==n.x||this.y!==n.y||this.z!==n.z))throw new yx(`Invalid attempt to parse header ${n.z}/${n.x}/${n.y} for tile ${this.z}/${this.x}/${this.y}`);this.x=n.x,this.y=n.y,this.z=n.z;for(const t of n.layers)this.layers[t.name]=new Zx(t,{cacheSize:this._cacheSize});return this}createDecodingTask(t){const e=[],r=this.getLayer(t.layerName);for(let n=0;n<r.dataIndex.length;n++){const i=r.dataIndex[n],s=i.first_byte-t.firstByte,a=i.last_byte+1-t.firstByte;if(n<t.firstBlock||n>t.lastBlock)continue;if(r._blocksInProgress.has(n))continue;const o={layerName:r.name,firstByte:s,lastByte:a,pixelFormat:r.pixelFormat,blockIndex:n,blockShape:[i.bands.length].concat(r.bandShape),buffer:r.buffer,codec:i.codec.codec,filters:i.filters.map((t=>t.filter))};r._blocksInProgress.add(n),e.push(o);}return new Hx(e,(()=>{e.forEach((t=>r._blocksInProgress.delete(t.blockIndex)));}),((t,n)=>{if(e.forEach((t=>r._blocksInProgress.delete(t.blockIndex))),t)throw t;n.forEach((t=>{this.getLayer(t.layerName).processDecodedData(t);}));}))}}class Zx{constructor({version:t,name:e,units:r,tilesize:n,pixel_format:i,buffer:s,data_index:a},o){if(this.version=t,1!==this.version)throw new yx(`Cannot parse raster layer encoded with MRT version ${t}`);this.name=e,this.units=r,this.tileSize=n,this.buffer=s,this.pixelFormat=$x[i],this.dataIndex=a,this.bandShape=[n+2*s,n+2*s,Gx[this.pixelFormat]],this._decodedBlocks=function(t=1e3,e=0,r=!1){if(isNaN(t)||t<0)throw new TypeError("Invalid max value");if(isNaN(e)||e<0)throw new TypeError("Invalid ttl value");if("boolean"!=typeof r)throw new TypeError("Invalid resetTtl value");return new px(t,e,r)}(o?o.cacheSize:5),this._blocksInProgress=new Set;}processDecodedData(t){const e=t.blockIndex.toString();this._decodedBlocks.get(e)||this._decodedBlocks.set(e,t.data);}getBlockForBand(t){let e=0;switch(typeof t){case"string":for(const[r,n]of this.dataIndex.entries()){for(const[i,s]of n.bands.entries())if(s===t)return {bandIndex:e+i,blockIndex:r,blockBandIndex:i};e+=n.bands.length;}break;case"number":for(const[r,n]of this.dataIndex.entries()){if(t>=e&&t<e+n.bands.length)return {bandIndex:t,blockIndex:r,blockBandIndex:t-e};e+=n.bands.length;}break;default:throw new yx(`Invalid band \`${JSON.stringify(t)}\`. Expected string or integer.`)}throw new yx(`Band not found: ${JSON.stringify(t)}`)}getDataRange(t){let e=1/0,r=-1/0,n=1/0,i=-1/0;for(const s of t){const{blockIndex:t}=this.getBlockForBand(s);if(t<0)throw new yx(`Invalid band: ${JSON.stringify(s)}`);const a=this.dataIndex[t];n=Math.min(n,t),i=Math.max(i,t),e=Math.min(e,a.first_byte),r=Math.max(r,a.last_byte);}return {layerName:this.name,firstByte:e,lastByte:r,firstBlock:n,lastBlock:i}}hasBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0}hasDataForBand(t){const{blockIndex:e}=this.getBlockForBand(t);return e>=0&&!!this._decodedBlocks.get(e.toString())}getBandView(t){const{blockIndex:e,blockBandIndex:r}=this.getBlockForBand(t),n=this._decodedBlocks.get(e.toString());if(!n)throw new yx(`Data for band ${JSON.stringify(t)} of layer "${this.name}" not decoded.`);const i=this.dataIndex[e],s=this.bandShape.reduce(((t,e)=>t*e),1),a=r*s,o=n.subarray(a,a+s);return {data:o,bytes:new Uint8Array(o.buffer).subarray(o.byteOffset,o.byteOffset+o.byteLength),tileSize:this.tileSize,buffer:this.buffer,offset:i.offset,scale:i.scale}}}class Hx{constructor(t,e,r){this.tasks=t,this._onCancel=e,this._onComplete=r,this._finalized=!1;}cancel(){this._finalized||(this._onCancel(),this._finalized=!0);}complete(t,e){this._finalized||(this._onComplete(t,e),this._finalized=!0);}}Xx.performDecoding=function(t,e){return Promise.all(e.tasks.map((e=>{const{layerName:r,firstByte:n,lastByte:i,pixelFormat:s,blockShape:a,blockIndex:o,filters:l,codec:u}=e,c=new Uint8Array(t).subarray(n,i+1),h=new Uint32Array(a[0]*a[1]*a[2]);let p;if("gzip_data"!==u)throw new Error(`Unhandled codec: ${u}`);return p=function(t,e){if(!globalThis.DecompressionStream&&"gzip_data"===e)return Promise.resolve(((s=function(t){31==t[0]&&139==t[1]&&8==t[2]||Ux(6,"invalid gzip data");var e=t[3],r=10;4&e&&(r+=2+(t[10]|t[11]<<8));for(var n=(e>>3&1)+(e>>4&1);n>0;n-=!t[r++]);return r+(2&e)}(i=t))+8>i.length&&Ux(6,"invalid gzip data"),function(t,e,r,n){var i=t.length;if(!i||e.f&&!e.l)return r||new gx(0);var s=!r,a=s||2!=e.i,o=e.i;s&&(r=new gx(3*i));var l,u,c=function(t){var e=r.length;if(t>e){var n=new gx(Math.max(2*e,t));n.set(r),r=n;}},h=e.f||0,p=e.p||0,f=e.b||0,d=e.l,m=e.d,y=e.m,g=e.n,x=8*i;do{if(!d){h=Lx(t,p,1);var b=Lx(t,p+1,3);if(p+=3,!b){var v=t[(E=4+((p+7)/8|0))-4]|t[E-3]<<8,_=E+v;if(_>i){o&&Ux(0);break}a&&c(f+v),r.set(t.subarray(E,_),f),e.b=f+=v,e.p=p=8*_,e.f=h;continue}if(1==b)d=Cx,m=Rx,y=9,g=5;else if(2==b){var w=Lx(t,p,31)+257,M=Lx(t,p+10,15)+4,A=w+Lx(t,p+5,31)+1;p+=14;for(var S=new gx(A),I=new gx(19),T=0;T<M;++T)I[wx[T]]=Lx(t,p+3*T,7);p+=3*M;var k=Vx(I),P=(1<<k)-1,z=Ex(I,k,1);for(T=0;T<A;){var E,B=z[Lx(t,p,P)];if(p+=15&B,(E=B>>4)<16)S[T++]=E;else {var D=0,C=0;for(16==E?(C=3+Lx(t,p,3),p+=2,D=S[T-1]):17==E?(C=3+Lx(t,p,7),p+=3):18==E&&(C=11+Lx(t,p,127),p+=7);C--;)S[T++]=D;}}var R=S.subarray(0,w),V=S.subarray(w);y=Vx(R),g=Vx(V),d=Ex(R,y,1),m=Ex(V,g,1);}else Ux(1);if(p>x){o&&Ux(0);break}}a&&c(f+131072);for(var L=(1<<y)-1,O=(1<<g)-1,F=p;;F=p){var U=(D=d[Ox(t,p)&L])>>4;if((p+=15&D)>x){o&&Ux(0);break}if(D||Ux(2),U<256)r[f++]=U;else {if(256==U){F=p,d=null;break}var N=U-254;U>264&&(N=Lx(t,p,(1<<($=vx[T=U-257]))-1)+Sx[T],p+=$);var j=m[Ox(t,p)&O],q=j>>4;if(j||Ux(3),p+=15&j,V=Tx[q],q>3){var $=_x[q];V+=Ox(t,p)&(1<<$)-1,p+=$;}if(p>x){o&&Ux(0);break}a&&c(f+131072);var G=f+N;if(f<V){var Y=0-V,X=Math.min(V,G);for(Y+f<0&&Ux(3);f<X;++f)r[f]=(void 0)[Y+f];}for(;f<G;++f)r[f]=r[f-V];}}e.l=d,e.p=F,e.b=f,e.f=h,d&&(h=1,e.m=y,e.d=m,e.n=g);}while(!h);return f!=r.length&&s?(l=r,(null==(u=f)||u>l.length)&&(u=l.length),new gx(l.subarray(0,u))):r.subarray(0,f)}(i.subarray(s,-8),{i:2},new gx(((r=i)[(n=r.length)-4]|r[n-3]<<8|r[n-2]<<16|r[n-1]<<24)>>>0))));var r,n,i,s;const a=qx[e];if(!a)throw new Error(`Unhandled codec: ${e}`);const o=new globalThis.DecompressionStream(a);return new Response(new Blob([t]).stream().pipeThrough(o)).arrayBuffer().then((t=>new Uint8Array(t)))}(c,u).then((t=>(function(t,e){t.readFields(cx,e);}(new Bm(t),h),new(0,Yx[s])(h.buffer)))),p.then((t=>{for(let e=l.length-1;e>=0;e--)switch(l[e]){case"delta_filter":fx(t,a);break;case"zigzag_filter":dx(t);break;case"bitshuffle_filter":mx(t,s);break;default:throw new Error(`Unhandled filter "${l[e]}"`)}return {layerName:r,blockIndex:o,data:t}})).catch((t=>{throw t}))})))};class Kx extends nx{constructor(t,e,r,n,i){super(t,e,r,n,i),this._workQueue=[],this._fetchQueue=[],this._isHeaderLoaded=!1;}setTexture(t,e){const r=e.context,n=r.gl;this.texture=this.texture||e.getTileTexture(t.width),this.texture&&this.texture instanceof Gg?this.texture.update(t,{useMipmap:!1,premultiply:!1}):this.texture=new Gg(r,t,n.RGBA,{useMipmap:!1,premultiply:!1});}flushQueues(){for(;this._workQueue.length;)this._workQueue.pop()();for(;this._fetchQueue.length;)this._fetchQueue.pop()();}fetchHeader(t=16384,e){const r=this._mrt=new Xx(30),n=Object.assign({},this.requestParams,{headers:{Range:"bytes=0-"+(t-1)}});return this.entireBuffer=null,this.request=en(n,((n,i,s,a)=>{if(n)e(n);else try{const n=r.getHeaderLength(i);if(n>t)return void(this.request=this.fetchHeader(n,e));r.parseHeader(i),this._isHeaderLoaded=!0;let o=0;for(const t of Object.values(r.layers))o=Math.max(o,t.dataIndex[t.dataIndex.length-1].last_byte);i.byteLength>=o&&(this.entireBuffer=i),e(null,this.entireBuffer||i,s,a);}catch(t){e(t);}})),this.request}fetchBand(t,e,r){const n=this._mrt;if(!this._isHeaderLoaded||!n)return void r(new Error("Tile header is not ready"));const i=this.actor;if(!i)return void r(new Error("Can't fetch tile band without an actor"));let s;const a=(n,i)=>{s.complete(n,i),n?r(n):(this.updateTextureDescriptor(t,e),r(null,this.textureDescriptor&&this.textureDescriptor.img));},o=(t,e)=>{if(t)return r(t);const n=i.send("decodeRasterArray",{buffer:e,task:s},a,void 0,!0);this._workQueue.push((()=>{n&&n.cancel(),s.cancel();}));},l=n.getLayer(t);if(!l)return void r(new Error(`Unknown sourceLayer "${t}"`));if(l.hasDataForBand(e))return this.updateTextureDescriptor(t,e),void r(null,this.textureDescriptor?this.textureDescriptor.img:null);const u=l.getDataRange([e]);if(s=n.createDecodingTask(u),!s||s.tasks.length)if(this.flushQueues(),this.entireBuffer)o(null,this.entireBuffer.slice(u.firstByte,u.lastByte+1));else {const t=Object.assign({},this.requestParams,{headers:{Range:`bytes=${u.firstByte}-${u.lastByte}`}}),e=en(t,o);this._fetchQueue.push((()=>{e.cancel(),s.cancel();}));}else r(null);}updateNeeded(t,e){return (!this.textureDescriptor||this.textureDescriptor.band!==e||this.textureDescriptor.layer!==t)&&"errored"!==this.state}updateTextureDescriptor(t,e){if(!this._mrt)return;const r=this._mrt.getLayer(t);if(!r||!r.hasBand(e)||!r.hasDataForBand(e))return;const{bytes:n,tileSize:i,buffer:s,offset:a,scale:o}=r.getBandView(e),l=i+2*s,u={data:n,width:l,height:l},c=this.texture;c&&c instanceof Gg&&c.update(u,{useMipmap:!1,premultiply:!1}),this.textureDescriptor={layer:t,band:e,img:u,buffer:s,offset:a,tileSize:i,format:r.pixelFormat,mix:[o,256*o,65536*o,16777216*o]};}}class Wx{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const n=t.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:e,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(t,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,n=void 0===e?0:this.data[r].indexOf(e),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const n of this.data[r])t(n.value)||e.push(n);for(const t of e)this.remove(t.value.tileID,t);}}class Jx extends Ln{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",(t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),e.on("error",(()=>{this._sourceErrored=!0;})),this._source=e,this._tiles={},this._cache=new Wx(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=e.minTileCacheSize,this._maxTileCacheSize=e.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this.tileCoverLift=0,this._coveredTiles={},this._shadowCasterTiles={},this._state=new Rm,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"raster-array"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(t){this.map=t,this._minTileCacheSize=void 0===this._minTileCacheSize&&t?t._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&t?t._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("errored"!==e.state&&("loaded"!==e.state||!e.bucketsLoaded()))return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,t.isExtraShadowCaster=this._shadowCasterTiles[t.tileID.key],this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t)}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t)}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope);}}getIds(){return tr(this._tiles).map((t=>t.tileID)).sort(Qx).map((t=>t.key))}getRenderableIds(t,e){const r=[];for(const n in this._tiles)this._isIdRenderable(+n,t,e)&&r.push(this._tiles[n]);return t?r.sort(((t,e)=>{const r=t.tileID,n=e.tileID,i=new Ne(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),s=new Ne(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||s.y-i.y||s.x-i.x})).map((t=>t.tileID.key)):r.map((t=>t.tileID)).sort(Qx).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e,r){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())&&(r||!this._shadowCasterTiles[t])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,n){if(n)if(t.state="errored",404!==n.status)this._source.fire(new Cn(n,{tile:t}));else {if(!(t.tileID.key in this._loadedParentTiles))return void this._source.fire(new Dn("data",{dataType:"source",sourceDataType:"error",sourceId:this._source.id}));if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const t=this.map.painter.terrain;this.update(this.transform,t.getScaledDemTileSize(),!0),t.resetTileLookupCache(this.id);}else this.update(this.transform);}else t.timeAdded=Dr.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new Dn("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let n=0;n<e.length;n++){const i=e[n];if(t.neighboringTiles&&t.neighboringTiles[i]){const e=this.getTileByID(i);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const n=e.tileID.canonical.y-t.tileID.canonical.y,i=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===n||Math.abs(n)>1||(Math.abs(r)>1&&(1===Math.abs(r+i)?r+=i:1===Math.abs(r-i)&&(r-=i)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,n),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,n){for(const i in this._tiles){let s=this._tiles[i];if(n[i]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){n[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),n=this._getLoadedTile(e);if(n)return n}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,n=Math.ceil(t.height/e)+1,i=Math.floor(r*n*5),s="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,i):i,a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,s):s;this._cache.setMaxSize(a);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const n=this._tiles[r];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),t[n.tileID.key]=n;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r,n){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let i;if(this.updateCacheSize(t,e),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={},this.used||this.usedForTerrain){if(this._source.tileID)i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new _c(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)));else if(0!==this.tileCoverLift){const n=t.clone();n.tileCoverLift=this.tileCoverLift,i=n.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.minzoom<=1&&"globe"===t.projection.name&&(i.push(new _c(1,0,1,0,0)),i.push(new _c(1,0,1,1,0)),i.push(new _c(1,0,1,0,1)),i.push(new _c(1,0,1,1,1)));}else if(i=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile){const t=this._source.hasTile.bind(this._source);i=i.filter((e=>t(e)));}}else i=[];if(i.length>0&&this.castsShadows&&n&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!tb(this._source.type)){const s=t.coveringZoomLevel({tileSize:e||this._source.tileSize,roundZoom:this._source.roundZoom&&!r}),a=Math.min(s,this._source.maxzoom),o=t.extendTileCoverForShadows(i,n,a);for(const t of o)this._shadowCasterTiles[t.key]=!0,i.push(t);}const s=this._updateRetainedTiles(i);if(tb(this._source.type)&&0!==i.length){const t={},e={},r=Object.keys(s);for(const n of r){const r=s[n],i=this._tiles[n];if(!i||i.fadeEndTime&&i.fadeEndTime<=Dr.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-Jx.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[n]=r;}const n=i[i.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(s[t]||!r.hasData())continue;let i=r.tileID;for(;i.overscaledZ>n;){i=i.scaledTo(i.overscaledZ-1);const n=this._tiles[i.key];if(n&&n.hasData()&&e[i.key]){s[t]=r.tileID;break}}}for(const e in t)s[e]||(this._coveredTiles[e]=!0,s[e]=t[e]);}for(const t in s)this._tiles[t].clearFadeHold();const a=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r}(this._tiles,s);for(const t of a){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},n=t.reduce(((t,e)=>Math.min(t,e.overscaledZ)),1/0),i=t[0].overscaledZ,s=Math.max(i-Jx.maxOverzooming,this._source.minzoom),a=Math.max(i+Jx.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||n<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,n,a,e);for(const n of t){let t=this._tiles[n.key];if(t.hasData())continue;if(n.canonical.z>=this._source.maxzoom){const t=n.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=n.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let i=t.wasRequested();for(let a=n.overscaledZ-1;a>=s;--a){const s=n.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&i&&(t=this._addTile(s)),t&&(e[s.key]=s,i=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,n=this._tiles[t].tileID;for(;n.overscaledZ>0;){if(n.key in this._loadedParentTiles){r=this._loadedParentTiles[n.key];break}e.push(n.key);const t=n.scaledTo(n.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;n=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return !0!==e.isExtraShadowCaster||!!this._shadowCasterTiles[t.key]||this._reloadTile(t.key,"reloading"),e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);if(!r){const r=this.map?this.map.painter:null,n=this._source.tileSize*t.overscaleFactor();e="raster-array"===this._source.type?new Kx(t,n,this.transform.tileZoom,r,this._isRaster):new nx(t,n,this.transform.tileZoom,r,this._isRaster),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state));}return e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new Dn("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state||"empty"===e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,e,r){const n=[],i=this.transform;if(!i)return n;const s="globe"===i.projection.name,a=Tc(i.center.lng);for(const o in this._tiles){const l=this._tiles[o];if(r&&l.clearQueryDebugViz(),l.holdingForFade())continue;let u;if(s){const t=l.tileID.canonical;if(0===t.z){const e=[Math.abs(Ke(a,...eb(t,-1))-a),Math.abs(Ke(a,...eb(t,1))-a)];u=[0,2*e.indexOf(Math.min(...e))-1];}else {const e=[Math.abs(Ke(a,...eb(t,-1))-a),Math.abs(Ke(a,...eb(t,0))-a),Math.abs(Ke(a,...eb(t,1))-a)];u=[e.indexOf(Math.min(...e))-1];}}else u=[0];for(const r of u){const s=t.containsTile(l,i,e,r);s&&n.push(s);}}return n}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(t){return this._getRenderableCoordinates(t)}_getRenderableCoordinates(t,e){const r=this.getRenderableIds(t,e).map((t=>this._tiles[t].tileID)),n="globe"===this.transform.projection.name;for(const t of r)t.projMatrix=this.transform.calculateProjMatrix(t.toUnwrapped()),t.expandedProjMatrix=n?this.transform.calculateProjMatrix(t.toUnwrapped(),!1,!0):t.projMatrix;return r}sortCoordinatesByDistance(t){const e=t.slice(),r=this.transform._camera.position,n=this.transform._camera.forward(),i={};for(const t of e){const e=1/(1<<t.canonical.z);i[t.key]=((t.canonical.x+.5)*e+t.wrap-r[0])*n[0]+((t.canonical.y+.5)*e-r[1])*n[1]-r[2]*n[2];}return e.sort(((t,e)=>i[t.key]-i[e.key])),e}hasTransition(){if(this._source.hasTransition())return !0;if(tb(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=Dr.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const n=this._tiles[t];n&&n.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter((r=>!r.hasDependency(t,e)));}_preloadTiles(t,e){if(!this._sourceLoaded){const r=()=>{this._sourceLoaded&&(this._source.off("data",r),this._preloadTiles(t,e));};return void this._source.on("data",r)}const r=new Map,n=Array.isArray(t)?t:[t],i=this.map.painter.terrain,s=this.usedForTerrain&&i?i.getScaledDemTileSize():this._source.tileSize;for(const t of n){const e=t.coveringTiles({tileSize:s,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const t of e)r.set(t.key,t);this.usedForTerrain&&t.updateElevation(!1);}Qe(Array.from(r.values()),((t,e)=>{const r=new nx(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(r,(t=>{"raster-dem"===this._source.type&&r.dem&&this._backfillDEM(r),e(t,r);}));}),e);}}function Qx(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),n=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||n-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function tb(t){return "raster"===t||"image"===t||"video"===t||"custom"===t}function eb(t,e){const r=1<<t.z;return [t.x/r+e,(t.x+1)/r+e]}Jx.maxOverzooming=10,Jx.maxUnderzooming=3;const rb=new class extends sl{possiblyEvaluate(t,e){return e=new Ho(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=er({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}(nm.paint.properties["line-width"].specification);function nb(t,e){return e>0?e+2*t:t}rb.useIntegerZoom=!0;const ib=new ol({"symbol-placement":new il(ll.layout_symbol["symbol-placement"]),"symbol-spacing":new il(ll.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new il(ll.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new sl(ll.layout_symbol["symbol-sort-key"]),"symbol-z-order":new il(ll.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new il(ll.layout_symbol["symbol-z-elevate"]),"icon-allow-overlap":new il(ll.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new il(ll.layout_symbol["icon-ignore-placement"]),"icon-optional":new il(ll.layout_symbol["icon-optional"]),"icon-rotation-alignment":new il(ll.layout_symbol["icon-rotation-alignment"]),"icon-size":new sl(ll.layout_symbol["icon-size"]),"icon-text-fit":new sl(ll.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new sl(ll.layout_symbol["icon-text-fit-padding"]),"icon-image":new sl(ll.layout_symbol["icon-image"]),"icon-rotate":new sl(ll.layout_symbol["icon-rotate"]),"icon-padding":new il(ll.layout_symbol["icon-padding"]),"icon-keep-upright":new il(ll.layout_symbol["icon-keep-upright"]),"icon-offset":new sl(ll.layout_symbol["icon-offset"]),"icon-anchor":new sl(ll.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new il(ll.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new il(ll.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new il(ll.layout_symbol["text-rotation-alignment"]),"text-field":new sl(ll.layout_symbol["text-field"]),"text-font":new sl(ll.layout_symbol["text-font"]),"text-size":new sl(ll.layout_symbol["text-size"]),"text-max-width":new sl(ll.layout_symbol["text-max-width"]),"text-line-height":new sl(ll.layout_symbol["text-line-height"]),"text-letter-spacing":new sl(ll.layout_symbol["text-letter-spacing"]),"text-justify":new sl(ll.layout_symbol["text-justify"]),"text-radial-offset":new sl(ll.layout_symbol["text-radial-offset"]),"text-variable-anchor":new il(ll.layout_symbol["text-variable-anchor"]),"text-anchor":new sl(ll.layout_symbol["text-anchor"]),"text-max-angle":new il(ll.layout_symbol["text-max-angle"]),"text-writing-mode":new il(ll.layout_symbol["text-writing-mode"]),"text-rotate":new sl(ll.layout_symbol["text-rotate"]),"text-padding":new il(ll.layout_symbol["text-padding"]),"text-keep-upright":new il(ll.layout_symbol["text-keep-upright"]),"text-transform":new sl(ll.layout_symbol["text-transform"]),"text-offset":new sl(ll.layout_symbol["text-offset"]),"text-allow-overlap":new il(ll.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new il(ll.layout_symbol["text-ignore-placement"]),"text-optional":new il(ll.layout_symbol["text-optional"]),visibility:new il(ll.layout_symbol.visibility)});var sb={paint:new ol({"icon-opacity":new sl(ll.paint_symbol["icon-opacity"]),"icon-occlusion-opacity":new sl(ll.paint_symbol["icon-occlusion-opacity"]),"icon-emissive-strength":new sl(ll.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new sl(ll.paint_symbol["text-emissive-strength"]),"icon-color":new sl(ll.paint_symbol["icon-color"]),"icon-halo-color":new sl(ll.paint_symbol["icon-halo-color"]),"icon-halo-width":new sl(ll.paint_symbol["icon-halo-width"]),"icon-halo-blur":new sl(ll.paint_symbol["icon-halo-blur"]),"icon-translate":new il(ll.paint_symbol["icon-translate"]),"icon-translate-anchor":new il(ll.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new sl(ll.paint_symbol["icon-image-cross-fade"]),"text-opacity":new sl(ll.paint_symbol["text-opacity"]),"text-occlusion-opacity":new sl(ll.paint_symbol["text-occlusion-opacity"]),"text-color":new sl(ll.paint_symbol["text-color"],{runtimeType:ei,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new sl(ll.paint_symbol["text-halo-color"]),"text-halo-width":new sl(ll.paint_symbol["text-halo-width"]),"text-halo-blur":new sl(ll.paint_symbol["text-halo-blur"]),"text-translate":new il(ll.paint_symbol["text-translate"]),"text-translate-anchor":new il(ll.paint_symbol["text-translate-anchor"]),"icon-color-saturation":new il(ll.paint_symbol["icon-color-saturation"]),"icon-color-contrast":new il(ll.paint_symbol["icon-color-contrast"]),"icon-color-brightness-min":new il(ll.paint_symbol["icon-color-brightness-min"]),"icon-color-brightness-max":new il(ll.paint_symbol["icon-color-brightness-max"])}),layout:ib};class ab{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:Wn,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Mo(ab,"FormatSectionOverride",{omit:["defaultValue"]});class ob extends kl{constructor(e,r,n,i){super(e,sb,r,n,i),this._colorAdjustmentMatrix=t.ad.identity([]),this.hasInitialOcclusionOpacityProperties=void 0!==e.paint&&("icon-occlusion-opacity"in e.paint||"text-occlusion-opacity"in e.paint);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getColorAdjustmentMatrix(e,r,n,i){return this._saturation===e&&this._contrast===r&&this._brightnessMin===n&&this._brightnessMax===i||(this._colorAdjustmentMatrix=function(e,r,n,i){e=Er(e),r=zr(r);const s=t.ad.create(),a=e/3,o=1-2*a,l=[o,a,a,0,a,o,a,0,a,a,o,0,0,0,0,1],u=.5-.5*r,c=i-n;return t.ad.multiply(s,[c,0,0,0,0,c,0,0,0,0,c,0,n,n,n,1],[r,0,0,0,0,r,0,0,0,0,r,0,u,u,u,1]),t.ad.multiply(s,s,l),s}(e,r,n,i),this._saturation=e,this._contrast=r,this._brightnessMin=n,this._brightnessMax=i),this._colorAdjustmentMatrix}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||co(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new $g(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of sb.paint.overridableProperties){if(!ob.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new ab(e),n=new uo(r,e.property.specification,this.scope,this.options);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new po("source",n):new fo("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new rl(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&ob.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=sb.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof mi)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof _i&&bi(e.value)===si?s(e.value.sections):e instanceof Si?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramIds(){const t=0!==this.paint.get("icon-opacity").constantOr(1),e=0!==this.paint.get("text-opacity").constantOr(1),r=[];return t&&r.push("symbolIcon"),e&&r.push("symbolSDF"),r}getDefaultProgramParams(t,e,r){return {config:new Ku(this,{zoom:e,lut:r}),overrideFog:!1}}}const lb=new ol({visibility:new il(ll.layout_background.visibility)});var ub={paint:new ol({"background-color":new il(ll.paint_background["background-color"]),"background-pattern":new il(ll.paint_background["background-pattern"]),"background-opacity":new il(ll.paint_background["background-opacity"]),"background-emissive-strength":new il(ll.paint_background["background-emissive-strength"])}),layout:lb};const cb=new ol({visibility:new il(ll.layout_raster.visibility)});var hb={paint:new ol({"raster-opacity":new il(ll.paint_raster["raster-opacity"]),"raster-color":new al(ll.paint_raster["raster-color"]),"raster-color-mix":new il(ll.paint_raster["raster-color-mix"]),"raster-color-range":new il(ll.paint_raster["raster-color-range"]),"raster-hue-rotate":new il(ll.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new il(ll.paint_raster["raster-brightness-min"]),"raster-brightness-max":new il(ll.paint_raster["raster-brightness-max"]),"raster-saturation":new il(ll.paint_raster["raster-saturation"]),"raster-contrast":new il(ll.paint_raster["raster-contrast"]),"raster-resampling":new il(ll.paint_raster["raster-resampling"]),"raster-fade-duration":new il(ll.paint_raster["raster-fade-duration"]),"raster-emissive-strength":new il(ll.paint_raster["raster-emissive-strength"]),"raster-array-band":new il(ll.paint_raster["raster-array-band"]),"raster-elevation":new il(ll.paint_raster["raster-elevation"])}),layout:cb};function pb(e,r,n,i,s,a,o,l){const u=[e,r,1,n,i,1,s,a,1],c=[o,l,1],h=t.bC.adjoint([],u),[p,f,d]=t._.transformMat3(c,c,h);return t.bC.multiply(u,u,[p,0,0,0,f,0,0,0,d])}function fb(e,r,n,i,s,a,o,l){const u=function(e,r,n,i,s,a,o,l){const u=pb(0,0,1,0,1,1,0,1),c=pb(e,r,n,i,s,a,o,l),h=t.bC.adjoint([],u);return t.bC.multiply(c,c,h)}(e,r,n,i,s,a,o,l);return [u[2]/u[8]/ps,u[5]/u[8]/ps]}function db(t){return [t[0],Math.min(Math.max(t[1],-Dc),Dc)]}class mb extends Ln{constructor(t,e,r,n){super(),this.id=t,this.dispatcher=r,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(n),this.options=e,this._dirty=!1;}load(t,e){if(this._loaded=e||!1,this.fire(new Dn("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=on(this.map._requestManager.transformRequest(this.url,Wr.Image),((e,r)=>{this._imageRequest=null,this._loaded=!0,e?this.fire(new Cn(e)):r&&(this.image=r instanceof HTMLImageElement?Dr.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading());}));}loaded(){return this._loaded}updateImage(t){return t.url?(this._imageRequest&&t.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=t.url,this.load(t.coordinates,this._loaded),this):this}setTexture(t){if(!(t.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new Yg(this.map.painter.context,t.handle),this.width=t.dimensions[0],this.height=t.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Dn("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(t){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof Yg||this.texture.destroy(),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy());}setCoordinates(t){if(this.coordinates=t,this._boundsArray=void 0,this._unsupportedCoords=!1,!t.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let e=t[0][1],r=t[0][1];for(const n of t)n[1]>r&&(r=n[1]),n[1]<e&&(e=n[1]);const n=(r+e)/2;if(n>Dc?this.onNorthPole=!0:n<-Dc&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const e=t.map(Oc.fromLngLat);this.tileID=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);const s=Math.max(n-e,i-r),a=Math.max(0,Math.floor(-Math.log(s)/Math.LN2)),o=Math.pow(2,a);let l=Math.floor((e+n)/2*o);return l>1&&(l-=1),new bc(a,l,Math.floor((r+i)/2*o))}(e),this.minzoom=this.maxzoom=this.tileID.z;}return this.fire(new Dn("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0,this._unsupportedCoords=!1;}_prepareData(e){for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture);}if(this._boundsArray||this.onNorthPole||this.onSouthPole||this._unsupportedCoords)return;const r=ng(new bc(0,0,0),this.map.transform.projection),n=[r.projection.project(this.coordinates[0][0],this.coordinates[0][1]),r.projection.project(this.coordinates[1][0],this.coordinates[1][1]),r.projection.project(this.coordinates[2][0],this.coordinates[2][1]),r.projection.project(this.coordinates[3][0],this.coordinates[3][1])];if(!function(t){const e=t[1].x-t[0].x,r=t[1].y-t[0].y,n=t[2].x-t[1].x,i=t[2].y-t[1].y,s=t[3].x-t[2].x,a=t[3].y-t[2].y,o=t[0].x-t[3].x,l=t[0].y-t[3].y,u=e*i-n*r,c=n*a-s*i,h=s*l-o*a,p=o*r-e*l;return u>0&&c>0&&h>0&&p>0||u<0&&c<0&&h<0&&p<0}(n))return console.warn("Image source coordinates are defining non-convex area in the Mercator projection"),void(this._unsupportedCoords=!0);const i=ng(this.tileID,this.map.transform.projection),[s,a,o,l]=this.coordinates.map((t=>{const e=i.projection.project(t[0],t[1]);return ig(i,e)._round()}));this.perspectiveTransform=fb(s.x,s.y,a.x,a.y,o.x,o.y,l.x,l.y);const u=this._boundsArray=new Vl;u.emplaceBack(s.x,s.y,0,0),u.emplaceBack(a.x,a.y,ps,0),u.emplaceBack(l.x,l.y,0,ps),u.emplaceBack(o.x,o.y,ps,ps),this.boundsBuffer&&(this.boundsBuffer.destroy(),this.elevatedGlobeVertexBuffer&&this.elevatedGlobeVertexBuffer.destroy(),this.elevatedGlobeIndexBuffer&&this.elevatedGlobeIndexBuffer.destroy()),this.boundsBuffer=e.createVertexBuffer(u,tx.members),this.boundsSegments=Au.simpleSegment(0,0,4,2);const c=[],h=function(t){return [db(t[0]),db(t[1]),db(t[2]),db(t[3])]}(this.coordinates),[p,f,d,m]=function(t){let e=t[0][0],r=e,n=t[0][1],i=n;for(let s=1;s<t.length;s++)t[s][0]<e?e=t[s][0]:t[s][0]>r&&(r=t[s][0]),t[s][1]<n?n=t[s][1]:t[s][1]>i&&(i=t[s][1]);return [e,n,r-e,i-n]}(h);{const i=new Vl,[s,a,o,l]=function(t){let e=t[0].x,r=e,n=t[0].y,i=n;for(let s=1;s<t.length;s++)t[s].x<e?e=t[s].x:t[s].x>r&&(r=t[s].x),t[s].y<n?n=t[s].y:t[s].y>i&&(i=t[s].y);return [e,n,r-e,i-n]}(n),u=t=>[(t.x-s)/o,(t.y-a)/l],[h,y,g,x]=n.map(u),b=function(e,r,n,i,s,a,o,l){const u=pb(0,0,1,0,1,1,0,1),c=pb(e,r,n,i,s,a,o,l),h=t.bC.adjoint([],c);return t.bC.multiply(u,u,h)}(h[0],h[1],y[0],y[1],g[0],g[1],x[0],x[1]);this.elevatedGlobePerspectiveTransform=fb(h[0],h[1],y[0],y[1],g[0],g[1],x[0],x[1]);const v=(e,r)=>{c.push(e.lng);const n=Math.round((e.lng-p)/d*ps),s=Math.round((e.lat-f)/m*ps),a=u(r),o=t._.transformMat3([],[a[0],a[1],1],b),l=Math.round(o[0]/o[2]*ps),h=Math.round(o[1]/o[2]*ps);i.emplaceBack(n,s,l,h);},_=n[3].x-n[0].x,w=n[3].y-n[0].y,M=n[2].x-n[1].x,A=n[2].y-n[1].y;for(let t=0;t<65;t++){const e=t/64,i=[n[0].x+e*_,n[0].y+e*w],s=[n[1].x+e*M,n[1].y+e*A],a=s[0]-i[0],o=s[1]-i[1];for(let t=0;t<65;t++){const e=t/64,n={x:i[0]+a*e,y:i[1]+o*e,z:0};v(r.projection.unproject(n.x,n.y),n);}}this.elevatedGlobeVertexBuffer=e.createVertexBuffer(i,tx.members);}{this.maxLongitudeTriangleSize=0;let t=[],r=new Ql;const n=(e,n,i)=>{r.emplaceBack(e,n,i);const s=c[e],a=c[n],o=c[i],l=Math.min(Math.min(s,a),o),u=Math.max(Math.max(s,a),o)-l;u>this.maxLongitudeTriangleSize&&(this.maxLongitudeTriangleSize=u),t.push(l+u/2);};for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=65*t+e,i=r+1,s=r+65,a=s+1;n(r,s,i),n(i,s,a);}[t,r]=function(t,e){const r=Array.from({length:t.length},((t,e)=>e));r.sort(((e,r)=>t[e]-t[r]));const n=[],i=new Ql;for(let s=0;s<r.length;s++){const a=r[s];n.push(t[a]);const o=3*a,l=o+1;i.emplaceBack(e.uint16[o],e.uint16[l],e.uint16[l+1]);}return [n,i]}(t,r),this.elevatedGlobeTrianglesCenterLongitudes=t,this.elevatedGlobeIndexBuffer=e.createIndexBuffer(r);}this.elevatedGlobeSegments=Au.simpleSegment(0,0,4225,8192),this.elevatedGlobeGridMatrix=new Float32Array([0,d/ps,0,m/ps,0,0,f,p,0]);}prepare(){const t=0!==Object.keys(this.tiles).length;if(this.tileID&&!t)return;const e=this.map.painter.context,r=e.gl;!this._dirty||this.texture instanceof Yg||(this.texture?this.texture.update(this.image):(this.texture=new Gg(e,this.image,r.RGBA),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE)),this._dirty=!1),t&&this._prepareData(e);}loadTile(t,e){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={},e(null)):(t.state="errored",e(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}getSegmentsForLongitude(t){const e=this.elevatedGlobeSegments;if(!this.elevatedGlobeTrianglesCenterLongitudes||!e)return null;const r=this.elevatedGlobeTrianglesCenterLongitudes;let n=(i=t+180)+360*Math.round((r[0]-i)/360);var i;const s=new Au,a=(t,r)=>{s.segments.push({vertexOffset:0,primitiveOffset:t,vertexLength:e.segments[0].vertexLength,primitiveLength:r,sortKey:void 0,vaos:{}});},o=.51*this.maxLongitudeTriangleSize;if(Math.abs(r[0]-n)<=o){const t=Pr(r,0,r.length,n+o);return t===r.length||a(t,kr(r,t+1,r.length,n+360-o)-t),s}n<r[0]&&(n+=360);const l=kr(r,0,r.length,n-o);if(l===r.length)return a(0,r.length),s;a(0,l-0);const u=Pr(r,l+1,r.length,n+o);return u!==r.length&&a(u,r.length-u),s}}const yb=(Math.pow(256,2)-1)/16907520;class gb extends kl{constructor(t,e,r,n){super(t,hb,e,r,n),this.updateColorRamp(),this._curRampRange=[NaN,NaN];}getProgramIds(){return ["raster"]}hasColorMap(){return !!this._transitionablePaint._values["raster-color"].value.value}tileCoverLift(){return this.paint.get("raster-elevation")}isDraped(t){return !(t&&t._source instanceof mb&&(t._source.onNorthPole||t._source.onSouthPole))&&0===this.paint.get("raster-elevation")}_handleSpecialPaintPropertyUpdate(t){"raster-color"!==t&&"raster-color-range"!==t||(this._curRampRange=[NaN,NaN],this.updateColorRamp());}updateColorRamp(t){if(!this.hasColorMap())return;if(!this._curRampRange)return;const e=this._transitionablePaint._values["raster-color"].value.expression,[r,n]=t||this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0})||[NaN,NaN];isNaN(r)&&isNaN(n)||r===this._curRampRange[0]&&n===this._curRampRange[1]||(this.colorRamp=gp({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:r,end:n}],resolution:256}),this.colorRampTexture=null,this._curRampRange=[r,n]);}}const xb=new ol({visibility:new il(ll["layout_raster-particle"].visibility)});var bb={paint:new ol({"raster-particle-array-band":new il(ll["paint_raster-particle"]["raster-particle-array-band"]),"raster-particle-count":new il(ll["paint_raster-particle"]["raster-particle-count"]),"raster-particle-color":new al(ll["paint_raster-particle"]["raster-particle-color"]),"raster-particle-max-speed":new il(ll["paint_raster-particle"]["raster-particle-max-speed"]),"raster-particle-speed-factor":new il(ll["paint_raster-particle"]["raster-particle-speed-factor"]),"raster-particle-fade-opacity-factor":new il(ll["paint_raster-particle"]["raster-particle-fade-opacity-factor"]),"raster-particle-reset-rate-factor":new il(ll["paint_raster-particle"]["raster-particle-reset-rate-factor"])}),layout:xb};class vb extends kl{constructor(t,e,r,n){super(t,bb,e,r,n),this._updateColorRamp(),this.lastInvalidatedAt=Dr.now();}onRemove(t){this.colorRampTexture&&this.colorRampTexture.destroy(),this.tileFramebuffer&&this.tileFramebuffer.destroy(),this.particleFramebuffer&&this.particleFramebuffer.destroy();}hasColorMap(){return !!this._transitionablePaint._values["raster-particle-color"].value.value}getProgramIds(){return ["rasterParticle"]}hasOffscreenPass(){return "none"!==this.visibility}isDraped(t){return !1}_handleSpecialPaintPropertyUpdate(t){"raster-particle-color"!==t&&"raster-particle-max-speed"!==t||(this._updateColorRamp(),this._invalidateAnimationState()),"raster-particle-count"===t&&this._invalidateAnimationState();}_updateColorRamp(){if(!this.hasColorMap())return;const t=this._transitionablePaint._values["raster-particle-color"].value.expression,e=this._transitionablePaint._values["raster-particle-max-speed"].value.expression.evaluate({zoom:0});this.colorRamp=gp({expression:t,evaluationKey:"rasterParticleSpeed",image:this.colorRamp,clips:[{start:0,end:e}],resolution:256}),this.colorRampTexture=null;}_invalidateAnimationState(){this.lastInvalidatedAt=Dr.now();}}class _b extends kl{constructor(t,e){super(t,{},e,null),this.implementation=t,t.slot&&(this.slot=t.slot);}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isDraped(t){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}const wb=new ol({visibility:new il(ll.layout_sky.visibility)});var Mb={paint:new ol({"sky-type":new il(ll.paint_sky["sky-type"]),"sky-atmosphere-sun":new il(ll.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new il(ll.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new il(ll.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new il(ll.paint_sky["sky-gradient-radius"]),"sky-gradient":new al(ll.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new il(ll.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new il(ll.paint_sky["sky-atmosphere-color"]),"sky-opacity":new il(ll.paint_sky["sky-opacity"])}),layout:wb};function Ab(e,r,n){const i=[0,0,1],s=t.av.identity([]);return t.av.rotateY(s,s,n?-$e(e)+Math.PI:$e(e)),t.av.rotateX(s,s,-$e(r)),t._.transformQuat(i,i,s),t._.normalize(i,i)}var Sb={paint:new ol({})};function Ib(e,r){const n=kb(e.projection,e.zoom,e.width,e.height),i=function(e,r,n,i,s){const a=new mc(n.lng-180*Pb,n.lat),o=new mc(n.lng+180*Pb,n.lat),l=e.project(a.lng,a.lat),u=e.project(o.lng,o.lat),c=-Math.atan2(u.y-l.y,u.x-l.x),h=Oc.fromLngLat(n);h.y=Ke(h.y,-1+Pb,1-Pb);const p=h.toLngLat(),f=e.project(p.lng,p.lat),d=Oc.fromLngLat(p);d.x+=Pb;const m=d.toLngLat(),y=e.project(m.lng,m.lat),g=Eb(y.x-f.x,y.y-f.y,c),x=Oc.fromLngLat(p);x.y+=Pb;const b=x.toLngLat(),v=e.project(b.lng,b.lat),_=Eb(v.x-f.x,v.y-f.y,c),w=Math.abs(g.x)/Math.abs(_.y),M=t.ad.identity([]);t.ad.rotateZ(M,M,-c*(1-(s?0:i)));const A=t.ad.identity([]);return t.ad.scale(A,A,[1,1-(1-w)*i,1]),A[4]=-_.x/_.y*i,t.ad.rotateZ(A,A,c),t.ad.multiply(A,M,A),A}(e.projection,0,e.center,n,r),s=Tb(e);return t.ad.scale(i,i,[s,s,1]),i}function Tb(t){const e=t.projection,r=kb(t.projection,t.zoom,t.width,t.height),n=zb(e,t.center),i=zb(e,mc.convert(e.center));return Math.pow(2,n*r+(1-r)*i)}function kb(t,e,r,n,i=1/0){const s=t.range;if(!s)return 0;const a=Math.min(i,Math.max(r,n)),o=Math.log(a/1024)/Math.LN2;return We(s[0]+o,s[1]+o,e)}const Pb=1/4e4;function zb(t,e){const r=Ke(e.lat,-Dc,Dc),n=new mc(e.lng-180*Pb,r),i=new mc(e.lng+180*Pb,r),s=t.project(n.lng,r),a=t.project(i.lng,r),o=Oc.fromLngLat(n),l=Oc.fromLngLat(i),u=a.x-s.x,c=a.y-s.y,h=l.x-o.x,p=l.y-o.y,f=Math.sqrt((h*h+p*p)/(u*u+c*c));return Math.log(f)/Math.LN2}function Eb(t,e,r){const n=Math.cos(r),i=Math.sin(r);return {x:t*n-e*i,y:t*i+e*n}}function Bb(e,r,n){t.ad.identity(e),t.ad.rotateZ(e,e,$e(r[2])),t.ad.rotateX(e,e,$e(r[0])),t.ad.rotateY(e,e,$e(r[1])),t.ad.scale(e,e,n),t.ad.multiply(e,e,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1]);}function Db(e,r,n,i,s,a,o,l){const u=[n[0]-r[0],n[1]-r[1],0],c=[i[0]-r[0],i[1]-r[1],0];if(t._.length(u)<1e-12||t._.length(c)<1e-12)return t.av.identity(e);const h=t._.cross([],u,c);t._.normalize(h,h),t._.subtract(c,i,r),u[2]=(a-s)*l,c[2]=(o-s)*l;const p=u;return t._.cross(p,u,c),t._.normalize(p,p),t.av.rotationTo(e,h,p)}function Cb(e,r,n=!1){const i=Hh(r.zoom),s=function(e,r,n){const i=r.worldSize,s=[e[12],e[13],e[14]],a=Ec(s[1]/i),o=zc(s[0]/i),l=t.ad.identity([]),u=Pc(1,a)*i,c=Pc(1,0)*i*Rc(a,r.zoom),h=1/Yh(i);let p=c*h;if(n){const t=kb(r.projection,r.zoom,r.width,r.height,1024);p=h*r.projection.pixelSpaceConversion(r.center.lat,i,t);}const f=pc(a,o);t._.add(f,f,t._.scale([],t._.normalize([],f),u*p*s[2]));const d=function(e){const r=[e[0],e[1],e[2]];let n=[0,1,0];const i=t._.cross([],n,r);return t._.cross(n,r,i),0===t._.squaredLength(n)&&(n=[0,1,0],t._.cross(i,r,n)),t._.normalize(i,i),t._.normalize(n,n),t._.normalize(r,r),[i[0],i[1],i[2],0,n[0],n[1],n[2],0,r[0],r[1],r[2],0,e[0],e[1],e[2],1]}(f);t.ad.scale(l,l,[p,p,p*u]),t.ad.translate(l,l,[-s[0],-s[1],-s[2]]);const m=t.ad.multiply([],r.globeMatrix,d);return t.ad.multiply(m,m,l),t.ad.multiply(m,m,e),m}(e,r,n);if(i>0){const n=function(e,r){const n=r.worldSize,i=Pc(1,0)*n*Rc(r.center.lat,r.zoom)/Yh(n),s=Pc(1,r.center.lat)*n,a=t.ad.identity([]);return t.ad.rotateY(a,a,$e(r.center.lng)),t.ad.rotateX(a,a,$e(r.center.lat)),t.ad.translate(a,a,[0,0,nc]),t.ad.scale(a,a,[i,i,i*s]),t.ad.translate(a,a,[r.point.x-.5*n,r.point.y-.5*n,0]),t.ad.multiply(a,a,e),t.ad.multiply(a,r.globeMatrix,a)}(e,r);return function(e,r,n){const i=(e,r,n)=>{const i=t._.length(e),s=t._.length(r),a=Rh(e,r,n);return t._.scale(a,a,1/t._.length(a)*Gn(i,s,n))},s=i([e[0],e[1],e[2]],[r[0],r[1],r[2]],n),a=i([e[4],e[5],e[6]],[r[4],r[5],r[6]],n),o=i([e[8],e[9],e[10]],[r[8],r[9],r[10]],n),l=Rh([e[12],e[13],e[14]],[r[12],r[13],r[14]],n);return [s[0],s[1],s[2],0,a[0],a[1],a[2],0,o[0],o[1],o[2],0,l[0],l[1],l[2],1]}(s,n,i)}return s}function Rb(t,e,r,n){const i=Ah.projectAabbCorners(n,r);let s=Number.MAX_VALUE,a=-1;for(let t=0;t<i.length;++t){const r=i[t];r[0]=(.5*r[0]+.5)*e.width,r[1]=(.5-.5*r[1])*e.height,r[2]<s&&(a=t,s=r[2]);}const o=t=>new Ne(i[t][0],i[t][1]);let l;switch(a){case 0:case 6:l=[o(1),o(5),o(4),o(7),o(3),o(2),o(1)];break;case 1:case 7:l=[o(0),o(4),o(5),o(6),o(2),o(3),o(0)];break;case 3:case 5:l=[o(1),o(0),o(4),o(7),o(6),o(2),o(1)];break;default:l=[o(1),o(5),o(6),o(7),o(3),o(0),o(1)];}if(Wc(t,l))return s}const Vb=Bl([{name:"a_pos_3f",components:3,type:"Float32"}]),Lb=Bl([{name:"a_color_3f",components:3,type:"Float32"}]),Ob=Bl([{name:"a_color_4f",components:4,type:"Float32"}]),Fb=Bl([{name:"a_uv_2f",components:2,type:"Float32"}]),Ub=Bl([{name:"a_normal_3f",components:3,type:"Float32"}]),Nb=Bl([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),jb=Bl([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]);class qb{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function $b(t,e){const r=-1===t.indexOf("://");try{return new URL(t,r&&e?"http://example.com":void 0),!0}catch(t){return !1}}class Gb{constructor(t,e){this.feature=t,this.instancedDataOffset=e,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0];}}class Yb{constructor(){this.instancedDataArray=new ou,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={};}}class Xb{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.fqid)),this.projection=t.projection,this.index=t.index,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0},this.modelUris=[],this.modelsRequested=!1,this.activeReplacements=[],this.replacementUpdateTime=0;}updateFootprints(t,e){}populate(t,e,r,n){this.tileToMeter=Lc(r);const i=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:s,id:a,index:o,sourceLayerIndex:l}of t){const t=null!=a?a:s.properties&&s.properties.hasOwnProperty("id")?s.properties.id:void 0,u=Xc(s,i);if(!this.layers[0]._featureFilter.filter(new Ho(this.zoom),u,r))continue;const c={id:t,sourceLayerIndex:l,index:o,geometry:i?u.geometry:Yc(s,r,n),properties:s.properties,type:s.type,patterns:{}},h=this.addFeature(c,c.geometry,u);h&&e.featureIndex.insert(s,c.geometry,o,l,this.index,this.instancesPerModel[h].instancedDataArray.length,ps/32);}this.lookup=null;}update(t,e,r,n){for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];for(const e in t)r.idToFeaturesIndex.hasOwnProperty(e)&&(this.evaluate(r.features[r.idToFeaturesIndex[e]],t[e],r,!0),this.uploaded=!1);}this.maxHeight=0;}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return !1;let e=!1;for(const r in this.instancesPerModel){const n=this.instancesPerModel[r];for(const r of n.features){const i=this.layers[0],s=r.feature,a=this.canonical,o=i.paint.get("model-rotation").evaluate(s,{},a),l=i.paint.get("model-scale").evaluate(s,{},a),u=i.paint.get("model-translation").evaluate(s,{},a);t._.exactEquals(r.rotation,o)&&t._.exactEquals(r.scale,l)&&t._.exactEquals(r.translation,u)||(this.evaluate(r,r.featureStates,n,!0),e=!0);}}return e}updateReplacement(t,e,r){if(e.updateTime===this.replacementUpdateTime)return !1;this.replacementUpdateTime=e.updateTime;const n=e.getReplacementRegionsForTile(t.toUnwrapped(),!0);if(Cf(this.activeReplacements,n))return !1;this.activeReplacements=n;let i=!1;for(const e in this.instancesPerModel){const n=this.instancesPerModel[e],s=n.instancedDataArray;for(const e of n.features){const n=e.instancedDataOffset,a=e.instancedDataCount;for(let e=0;e<a;e++){const a=16*(e+n);let o=s.float32[a+0];o=o>ps?o-ps:o;const l=Math.floor(o),u=s.float32[a+1];let c=!1;for(const e of this.activeReplacements)if(!(e.order<r||e.order===1/0)&&e.clipMask&td.Model&&!(e.min.x>l||l>e.max.x||e.min.y>u||u>e.max.y)&&(c=Uf(Ff(l,u,t.canonical,e.footprintTileId.canonical),e),c))break;s.float32[a]=c?o+ps:o,i=i||c;}}}return i}isEmpty(){for(const t in this.instancesPerModel)if(0!==this.instancesPerModel[t].instancedDataArray.length)return !1;return !0}uploadPending(){return !this.uploaded}upload(t){if(!this.uploaded)for(const e in this.instancesPerModel){const r=this.instancesPerModel[e];r.instancedDataArray.length<0||0===r.instancedDataArray.length||(r.instancedDataBuffer?r.instancedDataBuffer.updateData(r.instancedDataArray):r.instancedDataBuffer=t.createVertexBuffer(r.instancedDataArray,Nb.members,!0,void 0,this.instanceCount));}this.uploaded=!0;}destroy(){for(const t in this.instancesPerModel){const e=this.instancesPerModel[t];0!==e.instancedDataArray.length&&e.instancedDataBuffer&&e.instancedDataBuffer.destroy();}const t=this.layers[0].modelManager;if(t&&this.modelUris)for(const e of this.modelUris)t.removeModel(e,"");}addFeature(t,e,r){const n=this.layers[0],i=n.layout.get("model-id").evaluate(r,{},this.canonical);if(!i)return fr(`modelId is not evaluated for layer ${n.id} and it is not going to get rendered.`),i;$b(i,!1)&&(this.modelUris.includes(i)||this.modelUris.push(i)),this.instancesPerModel[i]||(this.instancesPerModel[i]=new Yb);const s=this.instancesPerModel[i],a=s.instancedDataArray,o=new Gb(r,a.length);for(const t of e)for(const e of t){if(e.x<0||e.x>=ps||e.y<0||e.y>=ps)continue;const t=(this.lookupDim-1)/ps,r=this.lookupDim*(e.y*t|0)+e.x*t|0;if(this.lookup){if(0!==this.lookup[r])continue;this.lookup[r]=1;}this.instanceCount++;const n=a.length;a.resize(n+1),s.instancesEvaluatedElevation.push(0),a.float32[16*n]=e.x,a.float32[16*n+1]=e.y;}return o.instancedDataCount=s.instancedDataArray.length-o.instancedDataOffset,o.instancedDataCount>0&&(t.id&&(s.idToFeaturesIndex[t.id]=s.features.length),s.features.push(o),this.evaluate(o,{},s,!1)),i}getModelUris(){return this.modelUris}evaluate(t,e,r,n){const i=this.layers[0],s=t.feature,a=this.canonical,o=t.rotation=i.paint.get("model-rotation").evaluate(s,e,a),l=t.scale=i.paint.get("model-scale").evaluate(s,e,a),u=t.translation=i.paint.get("model-translation").evaluate(s,e,a),c=i.paint.get("model-color").evaluate(s,e,a);c.a=i.paint.get("model-color-mix-intensity").evaluate(s,e,a);const h=[];this.maxVerticalOffset<u[2]&&(this.maxVerticalOffset=u[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),Bb(h,o,l);const p=Math.round(100*c.a)+c.b/1.05;for(let e=0;e<t.instancedDataCount;++e){const i=t.instancedDataOffset+e,s=16*i,o=r.instancedDataArray.float32;let l=0;n&&(l=o[s+6]-r.instancesEvaluatedElevation[i]);const f=0|o[s+1];o[s]=(0|o[s])+c.r/1.05,o[s+1]=f+c.g/1.05,o[s+2]=p,o[s+3]=1/(a.z>10?this.tileToMeter:Lc(a,f)),o[s+4]=u[0],o[s+5]=u[1],o[s+6]=u[2]+l,o[s+7]=h[0],o[s+8]=h[1],o[s+9]=h[2],o[s+10]=h[4],o[s+11]=h[5],o[s+12]=h[6],o[s+13]=h[8],o[s+14]=h[9],o[s+15]=h[10],r.instancesEvaluatedElevation[i]=u[2];}}}Mo(Xb,"ModelBucket",{omit:["layers"]}),Mo(Yb,"PerModelAttributes"),Mo(Gb,"ModelFeature");const Zb=new ol({visibility:new il(ll.layout_model.visibility),"model-id":new sl(ll.layout_model["model-id"])});var Hb={paint:new ol({"model-opacity":new il(ll.paint_model["model-opacity"]),"model-rotation":new sl(ll.paint_model["model-rotation"]),"model-scale":new sl(ll.paint_model["model-scale"]),"model-translation":new sl(ll.paint_model["model-translation"]),"model-color":new sl(ll.paint_model["model-color"]),"model-color-mix-intensity":new sl(ll.paint_model["model-color-mix-intensity"]),"model-type":new il(ll.paint_model["model-type"]),"model-cast-shadows":new il(ll.paint_model["model-cast-shadows"]),"model-receive-shadows":new il(ll.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new il(ll.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new sl(ll.paint_model["model-emissive-strength"]),"model-roughness":new sl(ll.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new sl(ll.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new il(ll.paint_model["model-cutoff-fade-range"]),"model-front-cutoff":new il(ll.paint_model["model-front-cutoff"])}),layout:Zb};const Kb=64,Wb={CoordinateSpaceTile:1,CoordinateSpaceYUp:2,HasMapboxMeshFeatures:4,HasMeshoptCompression:8};function Jb(e,r,n,i,s,a,o,l,u,c=!1){const h=n.zoom,p=n.project(i),f=Rc(i.lat,h),d=1/f;t.ad.identity(e),t.ad.translate(e,e,[p.x+o[0]*d,p.y+o[1]*d,o[2]]);let m=1,y=1;const g=n.worldSize;if(c){if("mercator"===n.projection.name){let e=0;n.elevation&&(e=n.elevation.getAtPointOrZero(new Oc(p.x/g,p.y/g),0));const r=t.aA.transformMat4([],[p.x,p.y,e,1],n.projMatrix)[3]/n.cameraToCenterDistance;m=r,y=r*Rc(n.center.lat,h);}else if("globe"===n.projection.name){const r=Cb(e,n),s=t.ad.multiply([],n.projMatrix,r),a=[0,0,0,1];t.aA.transformMat4(a,a,s);const o=a[3]/n.cameraToCenterDistance,l=Hh(h),u=n.projection.pixelsPerMeter(i.lat,g)*Rc(i.lat,h),c=n.projection.pixelsPerMeter(n.center.lat,g)*Rc(n.center.lat,h);m=o/Gn(u,Cc(n.center.lat),l),y=o*f/u,m*=c,y*=c;}}else m=d;t.ad.scale(e,e,[m,m,y]);const x=[...e],b=r.orientation,v=[];if(Bb(v,[b[0]+s[0],b[1]+s[1],b[2]+s[2]],a),t.ad.multiply(e,x,v),l&&n.elevation){let s=0;const a=[];if(u&&n.elevation){s=function(e,r,n,i,s){const a=r.elevation;if(!a)return 0;const o=Ah.projectAabbCorners(n,i),l=Pc(1,s.lat)*r.worldSize,u=function(e,r){const n=[0,0,1],i=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const s of i){const i=e[s.corners[0]],a=e[s.corners[1]],o=e[s.corners[2]],l=[a[0]-i[0],a[1]-i[1],r*(a[2]-i[2])],u=t._.cross(l,l,[o[0]-i[0],o[1]-i[1],r*(o[2]-i[2])]);t._.normalize(u,u),s.dotProductWithUp=t._.dot(u,n);}return i.sort(((t,e)=>t.dotProductWithUp-e.dotProductWithUp)),i[0].corners}(o,l),c=o[u[0]],h=o[u[1]],p=o[u[2]],f=o[u[3]],d=a.getAtPointOrZero(new Oc(c[0]/r.worldSize,c[1]/r.worldSize),0),m=a.getAtPointOrZero(new Oc(h[0]/r.worldSize,h[1]/r.worldSize),0),y=a.getAtPointOrZero(new Oc(p[0]/r.worldSize,p[1]/r.worldSize),0),g=a.getAtPointOrZero(new Oc(f[0]/r.worldSize,f[1]/r.worldSize),0),x=(d+g)/2,b=(m+y)/2;return x>b?m<y?Db(e,h,f,c,m,g,d,l):Db(e,p,c,f,y,d,g,l):d<g?Db(e,c,h,p,d,m,y,l):Db(e,f,p,h,g,y,m,l),Math.max(x,b)}(a,n,r.aabb,e,i);const o=t.ad.fromQuat([],a),l=t.ad.multiply([],o,v);t.ad.multiply(e,x,l);}else s=n.elevation.getAtPointOrZero(new Oc(p.x/g,p.y/g),0);0!==s&&(e[14]+=s);}}function Qb(t,e,r=!1){t.uploaded||(t.gfxTexture=new Gg(e,t.image,r?e.gl.R8:e.gl.RGBA,{useMipmap:t.sampler.minFilter>=e.gl.NEAREST_MIPMAP_NEAREST}),t.uploaded=!0,t.image=null);}function tv(t,e,r){t.indexBuffer=e.createIndexBuffer(t.indexArray,!1,!0),t.vertexBuffer=e.createVertexBuffer(t.vertexArray,Vb.members,!1,!0),t.normalArray&&(t.normalBuffer=e.createVertexBuffer(t.normalArray,Ub.members,!1,!0)),t.texcoordArray&&(t.texcoordBuffer=e.createVertexBuffer(t.texcoordArray,Fb.members,!1,!0)),t.colorArray&&(t.colorBuffer=e.createVertexBuffer(t.colorArray,(12===t.colorArray.bytesPerElement?Lb:Ob).members,!1,!0)),t.featureArray&&(t.pbrBuffer=e.createVertexBuffer(t.featureArray,jb.members,!0)),t.segments=Au.simpleSegment(0,0,t.vertexArray.length,t.indexArray.length);const n=t.material;n.pbrMetallicRoughness.baseColorTexture&&Qb(n.pbrMetallicRoughness.baseColorTexture,e),n.pbrMetallicRoughness.metallicRoughnessTexture&&Qb(n.pbrMetallicRoughness.metallicRoughnessTexture,e),n.normalTexture&&Qb(n.normalTexture,e),n.occlusionTexture&&Qb(n.occlusionTexture,e,r),n.emissionTexture&&Qb(n.emissionTexture,e);}function ev(t,e,r){if(t.meshes)for(const n of t.meshes)tv(n,e,r);if(t.children)for(const n of t.children)ev(n,e,r);}function rv(t){if(t.meshes)for(const e of t.meshes)e.indexArray.destroy(),e.vertexArray.destroy(),e.colorArray&&e.colorArray.destroy(),e.normalArray&&e.normalArray.destroy(),e.texcoordArray&&e.texcoordArray.destroy(),e.featureArray&&e.featureArray.destroy();if(t.children)for(const e of t.children)rv(e);}function nv(t){if(t.meshes)for(const r of t.meshes)r.vertexBuffer&&(r.vertexBuffer.destroy(),r.indexBuffer.destroy(),r.normalBuffer&&r.normalBuffer.destroy(),r.texcoordBuffer&&r.texcoordBuffer.destroy(),r.colorBuffer&&r.colorBuffer.destroy(),r.pbrBuffer&&r.pbrBuffer.destroy(),r.segments.destroy(),r.material&&((e=r.material).pbrMetallicRoughness.baseColorTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture&&e.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),e.pbrMetallicRoughness.metallicRoughnessTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&e.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),e.normalTexture&&e.normalTexture.gfxTexture&&e.normalTexture.gfxTexture.destroy(),e.emissionTexture&&e.emissionTexture.gfxTexture&&e.emissionTexture.gfxTexture.destroy(),e.occlusionTexture&&e.occlusionTexture.gfxTexture&&e.occlusionTexture.gfxTexture.destroy()));var e;if(t.children)for(const e of t.children)nv(e);}class iv{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class sv{constructor(){this.tasks={},this.taskQueue=[],or(["process"],this),this.invoker=new iv(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){try{t();}finally{}return null}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class av{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},or(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new sv;}send(t,e,r,n,i=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=new Set;return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:Io(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||gr()){const t=this.callbacks[r],n=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});n&&(this.cancelCallbacks[r]=n);}else this.processTask(r,e);}processTask(t,e){if(delete this.cancelCallbacks[t],"<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(To(e.error)):r(null,To(e.data)));}else {const r=new Set,n=e.hasCallback?(e,n)=>{this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Io(e):null,data:Io(n,r)},r);}:t=>{},i=To(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source,i.scope)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}}class ov{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=nr();const r=this.workerPool.acquire(this.id);for(let t=0;t<r.length;t++){const n=new ov.Actor(r[t],e,this.id);n.name=`Worker ${t}`,this.actors.push(n);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,e,r){Qe(this.actors,((r,n)=>{r.send(t,e,n);}),r=r||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((t=>{t.remove();})),this.actors=[],this.workerPool.release(this.id);}}ov.Actor=av;var lv={workerUrl:"",workerClass:null,workerParams:void 0};function uv(){return null!=lv.workerClass?new lv.workerClass:new self.Worker(lv.workerUrl,lv.workerParams)}const cv="mapboxgl_preloaded_worker_pool";class hv{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<hv.workerCount;)this.workers.push(new uv);return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],this.workers&&0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[cv]}numActive(){return Object.keys(this.active).length}}let pv;function fv(){return pv||(pv=new hv),pv}hv.workerCount=2;let dv,mv,yv,gv,xv,bv=null;function vv(){return gr()&&self.worker&&self.worker.dracoUrl?self.worker.dracoUrl:mv||n.DRACO_URL}function _v(){if(gr()&&self.worker&&self.worker.meshoptUrl)return self.worker.meshoptUrl;if(gv)return gv;const t=new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,3,2,0,0,5,3,1,0,1,12,1,0,10,22,2,12,0,65,0,65,0,65,0,252,10,0,0,11,7,0,65,0,253,15,26,11]);if("object"!=typeof WebAssembly)throw new Error("WebAssembly not supported, cannot instantiate meshoptimizer");return gv=WebAssembly.validate(t)?n.MESHOPT_SIMD_URL:n.MESHOPT_URL,gv}const wv={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},Mv={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",5123:"DT_UINT16",5125:"DT_UINT32",5126:"DT_FLOAT32"},Av={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function Sv(t,e,r){const n=r.json.bufferViews.length,i=r.buffers.length;e.bufferView=n,r.json.bufferViews[n]={buffer:i,byteLength:t.byteLength},r.buffers[i]=t;}const Iv="KHR_draco_mesh_compression";function Tv(t,e){const r=t.extensions&&t.extensions[Iv];if(!r)return;const n=new yv.Decoder,i=Cv(e,r.bufferView),s=new yv.Mesh;if(!n.DecodeArrayToMesh(i,i.byteLength,s))throw new Error("Failed to decode Draco mesh");const a=e.json.accessors[t.indices],o=wv[a.componentType],l=a.count*o.BYTES_PER_ELEMENT,u=yv._malloc(l);o===Uint16Array?n.GetTrianglesUInt16Array(s,l,u):n.GetTrianglesUInt32Array(s,l,u),Sv(yv.memory.buffer.slice(u,u+l),a,e),yv._free(u);for(const i of Object.keys(r.attributes)){const a=n.GetAttributeByUniqueId(s,r.attributes[i]),o=e.json.accessors[t.attributes[i]],l=Mv[o.componentType],u=o.count*Av[o.type]*wv[o.componentType].BYTES_PER_ELEMENT,c=yv._malloc(u);n.GetAttributeDataArrayForAllPoints(s,a,yv[l],u,c),Sv(yv.memory.buffer.slice(c,c+u),o,e),yv._free(c);}n.destroy(),s.destroy(),delete t.extensions[Iv];}const kv="EXT_meshopt_compression";function Pv(t,e){if(!t.extensions||!t.extensions[kv])return;const r=t.extensions[kv],n=new Uint8Array(e.buffers[r.buffer],r.byteOffset||0,r.byteLength||0),i=new Uint8Array(r.count*r.byteStride);xv.decodeGltfBuffer(i,r.count,r.byteStride,n,r.mode,r.filter),t.buffer=e.buffers.length,t.byteOffset=0,e.buffers[t.buffer]=i.buffer,delete t.extensions[kv];}const zv=1179937895,Ev=new TextDecoder("utf8");function Bv(t,e){return new URL(t,e).href}function Dv(t,e,r,n){return fetch(Bv(t.uri,n)).then((t=>t.arrayBuffer())).then((t=>{e.buffers[r]=t;}))}function Cv(t,e){const r=t.json.bufferViews[e];return new Uint8Array(t.buffers[r.buffer],r.byteOffset||0,r.byteLength)}function Rv(t,e,r,n){if(t.uri){const i=Bv(t.uri,n);return fetch(i).then((t=>t.blob())).then((t=>createImageBitmap(t))).then((t=>{e.images[r]=t;}))}if(void 0!==t.bufferView){const n=Cv(e,t.bufferView),i=new Blob([n],{type:t.mimeType});return createImageBitmap(i).then((t=>{e.images[r]=t;}))}}function Vv(t,e=0,r){const n={json:null,images:[],buffers:[]};if(new Uint32Array(t,e,1)[0]===zv){const r=new Uint32Array(t,e);let i=2;const s=(r[i++]>>2)-3,a=r[i++]>>2;if(i++,n.json=JSON.parse(Ev.decode(r.subarray(i,i+a))),i+=a,i<s){const s=r[i++];i++;const a=e+(i<<2);n.buffers[0]=t.slice(a,a+s);}}else n.json=JSON.parse(Ev.decode(new Uint8Array(t,e)));const{buffers:i,images:s,meshes:a,extensionsUsed:o,bufferViews:l}=n.json;let u=Promise.resolve();if(i){const t=[];for(let e=0;e<i.length;e++){const s=i[e];s.uri?t.push(Dv(s,n,e,r)):n.buffers[e]||(n.buffers[e]=null);}u=Promise.all(t);}return u.then((()=>{const t=[],e=o&&o.includes(Iv),i=o&&o.includes(kv);if(e&&t.push(function(){if(!yv)return dv||(dv=function(t){let e,r=null;function n(){e=new Uint8Array(r.buffer);}function i(){throw new Error("Unexpected Draco error.")}const s={a:{a:i,d:function(t,r,n){return e.copyWithin(t,r,r+n)},c:function(t){const i=e.length,s=Math.max(t>>>0,Math.ceil(1.2*i)),a=Math.ceil((s-i)/65536);try{return r.grow(a),n(),!0}catch(t){return !1}},b:i}};return (WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(t,s):t.then((t=>t.arrayBuffer())).then((t=>WebAssembly.instantiate(t,s)))).then((t=>{const{Rb:i,Qb:s,P:a,T:o,X:l,Ja:u,La:c,Qa:h,Va:p,Wa:f,eb:d,jb:m,f:y,e:g,yb:x,zb:b,Ab:v,Bb:_,Db:w,Gb:M}=t.instance.exports;r=g;const A=(()=>{let t=0,r=0,n=0,a=0;return o=>{n&&(i(a),i(t),r+=n,n=t=0),t||(r+=128,t=s(r));const l=o.length+7&-8;let u=t;l>=r&&(n=l,u=a=s(l));for(let t=0;t<o.length;t++)e[u+t]=o[t];return u}})();return n(),y(),{memory:g,_free:i,_malloc:s,Mesh:class{constructor(){this.ptr=a();}destroy(){o(this.ptr);}},Decoder:class{constructor(){this.ptr=u();}destroy(){m(this.ptr);}DecodeArrayToMesh(t,e,r){const n=A(t),i=c(this.ptr,n,e,r.ptr);return !!l(i)}GetAttributeByUniqueId(t,e){return {ptr:h(this.ptr,t.ptr,e)}}GetTrianglesUInt16Array(t,e,r){p(this.ptr,t.ptr,e,r);}GetTrianglesUInt32Array(t,e,r){f(this.ptr,t.ptr,e,r);}GetAttributeDataArrayForAllPoints(t,e,r,n,i){d(this.ptr,t.ptr,e.ptr,r,n,i);}},DT_INT8:x(),DT_UINT8:b(),DT_INT16:v(),DT_UINT16:_(),DT_UINT32:w(),DT_FLOAT32:M()}}))}(fetch(vv())),dv.then((t=>{yv=t,dv=void 0;})))}()),i&&t.push(function(){if(xv)return;const t=function(t){let e;const r=WebAssembly.instantiateStreaming(t,{}).then((t=>{e=t.instance,e.exports.__wasm_call_ctors();})),n={NONE:"",OCTAHEDRAL:"meshopt_decodeFilterOct",QUATERNION:"meshopt_decodeFilterQuat",EXPONENTIAL:"meshopt_decodeFilterExp"},i={ATTRIBUTES:"meshopt_decodeVertexBuffer",TRIANGLES:"meshopt_decodeIndexBuffer",INDICES:"meshopt_decodeIndexSequence"};return {ready:r,supported:!0,decodeGltfBuffer(t,r,s,a,o,l){!function(t,e,r,n,i,s,a){const o=t.exports.sbrk,l=n+3&-4,u=o(l*i),c=o(s.length),h=new Uint8Array(t.exports.memory.buffer);h.set(s,c);const p=e(u,n,i,c,s.length);if(0===p&&a&&a(u,l,i),r.set(h.subarray(u,u+n*i)),o(u-o(0)),0!==p)throw new Error(`Malformed buffer data: ${p}`)}(e,e.exports[i[o]],t,r,s,a,e.exports[n[l]]);}}}(fetch(_v()));return t.ready.then((()=>{xv=t;}))}()),s)for(let e=0;e<s.length;e++)t.push(Rv(s[e],n,e,r));return (t.length?Promise.all(t):Promise.resolve()).then((()=>{if(e&&a)for(const{primitives:t}of a)for(const e of t)Tv(e,n);if(i&&a&&l)for(const t of l)Pv(t,n);return n}))}))}function Lv(t,e){const r=t.json.bufferViews[e.bufferView],n=wv[e.componentType];return new n(t.buffers[r.buffer],(e.byteOffset||0)+(r.byteOffset||0),e.count*(r.byteStride&&r.byteStride!==Av[e.type]*n.BYTES_PER_ELEMENT?r.byteStride/n.BYTES_PER_ELEMENT:Av[e.type]))}function Ov(t,e,r,n){const i=wv[e.componentType],s=function(t){switch(t){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:return 1}}(i),a=t.json.bufferViews[e.bufferView],o=a.byteStride?a.byteStride/i.BYTES_PER_ELEMENT:Av[e.type],l=r.float32,u=l.length/r.capacity;for(let t=0,r=0;t<e.count*o;t+=o,r+=u)for(let e=0;e<u;e++)l[r+e]=n[t+e]*s;r._trim();}function Fv(t,e,r){const n=t.indices,i=t.attributes,s={};s.indexArray=new Ql;const a=e.json.accessors[n],o=a.count/3;s.indexArray.reserve(o);const l=Lv(e,a);for(let t=0;t<o;t++)s.indexArray.emplaceBack(l[3*t],l[3*t+1],l[3*t+2]);s.indexArray._trim(),s.vertexArray=new Ul;const u=e.json.accessors[i.POSITION];s.vertexArray.reserve(u.count);const c=Lv(e,u);for(let t=0;t<u.count;t++)s.vertexArray.emplaceBack(c[3*t],c[3*t+1],c[3*t+2]);if(s.vertexArray._trim(),s.aabb=new Ah(u.min,u.max),s.centroid=function(t,e){const r=[0,0,0],n=t.length;if(n>0){for(let i=0;i<n;i++){const n=3*t[i];r[0]+=e[n],r[1]+=e[n+1],r[2]+=e[n+2];}r[0]/=n,r[1]/=n,r[2]/=n;}return r}(l,c),void 0!==i.COLOR_0){const t=e.json.accessors[i.COLOR_0],r=Av[t.type],n=Lv(e,t);s.colorArray=3===r?new Ul:new Fl,s.colorArray.resize(t.count),Ov(e,t,s.colorArray,n);}if(void 0!==i.NORMAL){s.normalArray=new Ul;const t=e.json.accessors[i.NORMAL];s.normalArray.resize(t.count);const r=Lv(e,t);Ov(e,t,s.normalArray,r);}if(void 0!==i.TEXCOORD_0&&r.length>0){s.texcoordArray=new iu;const t=e.json.accessors[i.TEXCOORD_0];s.texcoordArray.resize(t.count);const r=Lv(e,t);Ov(e,t,s.texcoordArray,r);}if(void 0!==i._FEATURE_ID_RGBA4444){const t=e.json.accessors[i._FEATURE_ID_RGBA4444];e.json.extensionsUsed&&e.json.extensionsUsed.includes("EXT_meshopt_compression")&&(s.featureData=Lv(e,t));}void 0!==i._FEATURE_RGBA4444&&(s.featureData=new Uint32Array(Lv(e,e.json.accessors[i._FEATURE_RGBA4444]).buffer));const h=t.material;return s.material=function(t,e){const{emissiveFactor:r=[0,0,0],alphaMode:n="OPAQUE",alphaCutoff:i=.5,normalTexture:s,occlusionTexture:a,emissiveTexture:o,doubleSided:l}=t,{baseColorFactor:u=[1,1,1,1],metallicFactor:c=1,roughnessFactor:h=1,baseColorTexture:p,metallicRoughnessTexture:f}=t.pbrMetallicRoughness||{},d=a?e[a.index]:void 0;if(a&&a.extensions&&a.extensions.KHR_texture_transform&&d){const t=a.extensions.KHR_texture_transform;d.offsetScale=[t.offset[0],t.offset[1],t.scale[0],t.scale[1]];}return {pbrMetallicRoughness:{baseColorFactor:new qn(...u),metallicFactor:c,roughnessFactor:h,baseColorTexture:p?e[p.index]:void 0,metallicRoughnessTexture:f?e[f.index]:void 0},doubleSided:l,emissiveFactor:r,alphaMode:n,alphaCutoff:i,normalTexture:s?e[s.index]:void 0,occlusionTexture:d,emissionTexture:o?e[o.index]:void 0,defined:void 0===t.defined}}(void 0!==h?e.json.materials[h]:{defined:!1},r),s}function Uv(e,r,n){const{matrix:i,rotation:s,translation:a,scale:o,mesh:l,extras:u,children:c}=e,h={};if(h.matrix=i||t.ad.fromRotationTranslationScale([],s||[0,0,0,1],a||[0,0,0],o||[1,1,1]),void 0!==l){h.meshes=n[l];const t=h.anchor=[0,0];for(const e of h.meshes){const{min:r,max:n}=e.aabb;t[0]+=r[0]+n[0],t[1]+=r[1]+n[1];}t[0]=Math.floor(t[0]/h.meshes.length/2),t[1]=Math.floor(t[1]/h.meshes.length/2);}if(u&&(u.id&&(h.id=u.id),u.lights&&(h.lights=function(t){if(!t.length)return [];const e=function(t){const e=atob(t),r=new Uint8Array(e.length);for(let t=0;t<e.length;t++)r[t]=e.codePointAt(t);return r}(t),r=[],n=e.length/24,i=new Uint16Array(e.buffer),s=new Float32Array(e.buffer);for(let t=0;t<n;t++){const e=i[2*t*6]/30,n=i[2*t*6+1]/30,a=i[2*t*6+10]/100,o=s[6*t+1],l=s[6*t+2],u=s[6*t+3],c=s[6*t+4],h=u-o,p=c-l,f=Math.hypot(h,p);r.push({pos:[o+.5*h,l+.5*p,n],normal:[p/f,-h/f,0],width:f,height:e,depth:a,points:[o,l,u,c]});}return r}(u.lights))),c){const t=[];for(const e of c)t.push(Uv(r.json.nodes[e],r,n));h.children=t;}return h}function Nv(t){if(0===t.vertices.length||0===t.indices.length)return null;const e=new tf(t.vertices,t.indices,8,256),[r,n]=[e.min.clone(),e.max.clone()];return {vertices:t.vertices,indices:t.indices,grid:e,min:r,max:n}}function jv(t){if(!t.extras||!t.extras.ground)return null;const e=t.extras.ground;if(!e||!Array.isArray(e)||0===e.length)return null;const r=e[0];if(!r||!Array.isArray(r)||0===r.length)return null;const n=[];for(const t of r){if(!Array.isArray(t)||2!==t.length)continue;const e=t[0],r=t[1];"number"==typeof e&&"number"==typeof r&&n.push(new Ne(e,r));}if(n.length<3)return null;n.length>1&&n[n.length-1].equals(n[0])&&n.pop();let i=0;for(let t=0;t<n.length;t++){const e=n[t],r=n[(t+1)%n.length],s=n[(t+2)%n.length];i+=(e.x-r.x)*(s.y-r.y)-(s.x-r.x)*(e.y-r.y);}i>0&&n.reverse();const s=wp(n.flatMap((t=>[t.x,t.y])),[]);return 0===s.length?null:{vertices:n,indices:s}}function qv(e,r){const n=[],i=[];let s=0;const a=[];for(const o of e){s=n.length;const e=o.vertexArray.float32,l=o.indexArray.uint16;for(let i=0;i<o.vertexArray.length;i++)a[0]=e[3*i+0],a[1]=e[3*i+1],a[2]=e[3*i+2],t._.transformMat4(a,a,r),n.push(new Ne(a[0],a[1]));for(let t=0;t<3*o.indexArray.length;t++)i.push(l[t]+s);}if(i.length%3!=0)return null;for(let t=0;t<i.length;t+=3){const e=n[i[t+0]],r=n[i[t+1]],s=n[i[t+2]];(e.x-r.x)*(s.y-r.y)-(s.x-r.x)*(e.y-r.y)>0&&([i[t+1],i[t+2]]=[i[t+2],i[t+1]]);}return {vertices:n,indices:i}}function $v(t){const e=function(t,e){const r=[],n=WebGL2RenderingContext;if(t.json.textures)for(const i of t.json.textures){const s={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==i.sampler&&Object.assign(s,t.json.samplers[i.sampler]),r.push({image:e[i.source],sampler:s,uploaded:!1});}return r}(t,t.images),r=function(t,e){const r=[];for(const n of t.json.meshes){const i=[];for(const r of n.primitives)i.push(Fv(r,t,e));r.push(i);}return r}(t,e),{scenes:n,scene:i,nodes:s}=t.json,a=n?n[i||0].nodes:s,o=[];for(const e of a)o.push(Uv(s[e],t,r));return function(t,e,r){const n={},i=new Set;for(let s=0;s<t.length;s++){const t=r[e[s]];if(!t.extras)continue;const a=t.extras["mapbox:footprint:version"],o=t.extras["mapbox:footprint:id"];(a||o)&&i.add(s),"1.0.0"===a&&o&&(n[o]=s);}for(let s=0;s<t.length;s++){if(i.has(s))continue;const a=t[s],o=r[e[s]];if(!o.extras)continue;let l=null;a.id in n&&(l=qv(t[n[a.id]].meshes,a.matrix)),l||(l=jv(o)),l&&(a.footprint=Nv(l));}if(i.size>0){const e=Array.from(i.values()).sort(((t,e)=>t-e));for(let r=e.length-1;r>=0;r--)t.splice(e[r],1);}}(o,a,t.json.nodes),o}function Gv(t){t.heightmap=new Float32Array(4096),t.heightmap.fill(-1);const e=t.vertexArray.float32,r=t.aabb.min[0]-1,n=t.aabb.min[1]-1,i=Kb/(t.aabb.max[0]-r+2),s=Kb/(t.aabb.max[1]-n+2);for(let a=0;a<e.length;a+=3){const o=e[a+2],l=(e[a+0]-r)*i|0,u=(e[a+1]-n)*s|0;o>t.heightmap[u*Kb+l]&&(t.heightmap[u*Kb+l]=o);}}function Yv(e,r){const n={};n.indexArray=new Ql,n.indexArray.reserve(4*e.length),n.vertexArray=new Ul,n.vertexArray.reserve(10*e.length),n.colorArray=new Fl,n.vertexArray.reserve(10*e.length);let i=0;for(const s of e){const e=Math.min(10,Math.max(4,1.3*s.height))*r,a=[-s.normal[1],s.normal[0],0],o=Math.min(.29,.1*s.width/s.depth),l=s.width-2*s.depth*r*(o+.01),u=t._.scaleAndAdd([],s.pos,a,l/2),c=t._.scaleAndAdd([],s.pos,a,-l/2),h=[u[0],u[1],u[2]+s.height],p=[c[0],c[1],c[2]+s.height],f=t._.scaleAndAdd([],s.normal,a,o);t._.scale(f,f,e);const d=t._.scaleAndAdd([],s.normal,a,-o);t._.scale(d,d,e),t._.add(f,u,f),t._.add(d,c,d),u[2]+=.1,c[2]+=.1,n.vertexArray.emplaceBack(f[0],f[1],f[2]),n.vertexArray.emplaceBack(d[0],d[1],d[2]),n.vertexArray.emplaceBack(u[0],u[1],u[2]),n.vertexArray.emplaceBack(c[0],c[1],c[2]),n.vertexArray.emplaceBack(h[0],h[1],h[2]),n.vertexArray.emplaceBack(p[0],p[1],p[2]),n.vertexArray.emplaceBack(u[0],u[1],u[2]),n.vertexArray.emplaceBack(c[0],c[1],c[2]),n.vertexArray.emplaceBack(f[0],f[1],f[2]),n.vertexArray.emplaceBack(d[0],d[1],d[2]);const m=l/e/2;n.colorArray.emplaceBack(-m-o,-1,m,.8),n.colorArray.emplaceBack(m+o,-1,m,.8),n.colorArray.emplaceBack(-m,0,m,1.3),n.colorArray.emplaceBack(m,0,m,1.3),n.colorArray.emplaceBack(m+o,-.8,m,.7),n.colorArray.emplaceBack(m+o,-.8,m,.7),n.colorArray.emplaceBack(0,0,m,1.3),n.colorArray.emplaceBack(0,0,m,1.3),n.colorArray.emplaceBack(m+o,-1.2,m,.8),n.colorArray.emplaceBack(m+o,-1.2,m,.8),n.indexArray.emplaceBack(6+i,4+i,8+i),n.indexArray.emplaceBack(7+i,9+i,5+i),n.indexArray.emplaceBack(0+i,1+i,2+i),n.indexArray.emplaceBack(1+i,3+i,2+i),i+=10;}const s={defined:!0,emissiveFactor:[0,0,0]},a={};return a.baseColorFactor=qn.white,s.pbrMetallicRoughness=a,n.material=s,n.aabb=new Ah([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),n}const Xv=new Float32Array(262144),Zv=new Uint8Array(262144);function Hv(t){let e=0;if(t.meshes)for(const r of t.meshes)e=Math.max(e,r.aabb.max[2]);if(t.children)for(const r of t.children)e=Math.max(e,Hv(r));return e}function Kv(t,e,r){if(t.meshes)for(const n of t.meshes)n.aabb.min[0]!==1/0&&r.insert(e,n.aabb.min[0],n.aabb.min[1],n.aabb.max[0],n.aabb.max[1]);if(t.children)for(const n of t.children)Kv(n,e,r);}const Wv=["","wall","door","roof","window","lamp","logo"];class Jv{constructor(t){this.node=t,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.feature={type:"Point",id:t.id,geometry:[],properties:{height:Hv(t)}},this.aabb=this._getLocalBounds();}_getLocalBounds(){if(!this.node.meshes)return new Ah([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);if(!this.aabb){let t=0;const e=new Ah([1/0,1/0,1/0],[-1/0,-1/0,-1/0]);for(const r of this.node.meshes)this.node.lightMeshIndex!==t&&(r.transformedAabb=Ah.applyTransformFast(r.aabb,this.node.matrix),e.encapsulate(r.transformedAabb)),t++;this.aabb=e;}return this.aabb}}class Qv{constructor(t,e,r,n,i,s){this.id=e,this.modelTraits|=Wb.CoordinateSpaceTile,this.uploaded=!1,this.hasPattern=!1,r&&(this.modelTraits|=Wb.HasMapboxMeshFeatures),n&&(this.modelTraits|=Wb.HasMeshoptCompression),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=i,this.dirty=!0,this.needsUpload=!1,this.nodesInfo=[];for(const e of t)this.nodesInfo.push(new Jv(e)),Kv(e,s.featureIndexArray.length,s.grid),s.featureIndexArray.emplaceBack(this.nodesInfo.length-1,0,s.bucketLayerIDs.length-1,0);}updateFootprints(t,e){for(const r of this.getNodesInfo()){const n=r.node;n.footprint&&e.push({footprint:n.footprint,id:t});}}update(){console.log("Update 3D model bucket");}populate(){console.log("populate 3D model bucket");}uploadPending(){return !this.uploaded||this.needsUpload}upload(t){if(!this.needsUpload)return;const e=this.getNodesInfo();for(const r of e){const e=r.node;this.uploaded?this.updatePbrBuffer(e):ev(e,t,!0);}for(const t of e)rv(t.node);this.uploaded=!0,this.needsUpload=!1;}updatePbrBuffer(t){let e=!1;if(!t.meshes)return e;for(const r of t.meshes)r.pbrBuffer&&(r.pbrBuffer.updateData(r.featureArray),e=!0);return e}needsReEvaluation(t,e,r){const n=t.transform.projectionOptions,i=t.style.getBrightness(),s=this.brightness!==i;return !!(!this.uploaded||this.dirty||n.name!==this.projection.name||t_(r.paint.get("model-color").value,s)||t_(r.paint.get("model-color-mix-intensity").value,s)||t_(r.paint.get("model-roughness").value,s)||t_(r.paint.get("model-emissive-strength").value,s)||t_(r.paint.get("model-height-based-emissive-strength-multiplier").value,s))&&(this.projection=n,this.brightness=i,!0)}evaluateScale(t,e){if(t.transform.zoom===this.zoom)return;this.zoom=t.transform.zoom;const r=this.getNodesInfo(),n=this.id.canonical;for(const t of r){const r=t.feature;t.evaluatedScale=e.paint.get("model-scale").evaluate(r,{},n);}}evaluate(t){const e=this.getNodesInfo();for(const r of e){if(!r.node.meshes)continue;const e=r.feature,n=r.node.meshes&&r.node.meshes[0].featureData,i=r.evaluatedColor[2],s=r.evaluatedRMEA[2],a=this.id.canonical;if(r.hasTranslucentParts=!1,n){for(let n=0;n<Wv.length;n++){const i=Wv[n];i.length&&(e.properties.part=i);const s=t.paint.get("model-color").evaluate(e,{},a).toRenderColor(null),o=t.paint.get("model-color-mix-intensity").evaluate(e,{},a);r.evaluatedColor[n]=[s.r,s.g,s.b,o],r.evaluatedRMEA[n][0]=t.paint.get("model-roughness").evaluate(e,{},a),r.evaluatedRMEA[n][2]=t.paint.get("model-emissive-strength").evaluate(e,{},a),r.evaluatedRMEA[n][3]=s.a,r.emissionHeightBasedParams[n]=t.paint.get("model-height-based-emissive-strength-multiplier").evaluate(e,{},a),!r.hasTranslucentParts&&s.a<1&&(r.hasTranslucentParts=!0);}delete e.properties.part,r_(r,i!==r.evaluatedColor[2]||s!==r.evaluatedRMEA[2],this.modelTraits);}else r.evaluatedRMEA[0][2]=t.paint.get("model-emissive-strength").evaluate(e,{},a);r.evaluatedScale=t.paint.get("model-scale").evaluate(e,{},a),this.updatePbrBuffer(r.node)||(this.needsUpload=!0);}this.dirty=!1;}elevationUpdate(t,e,r,n){const i=t.findDEMTileFor(r);if(i&&(i.tileID.canonical!==this.terrainTile||e!==this.terrainExaggeration)){if(i.dem&&i.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=i.tileID.overscaledZ;const e=Qf.create(t,r,i);if(!e)return;this.modelTraits&Wb.HasMapboxMeshFeatures&&this.updateDEM(t,e,r,n);for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.vertices||!r.footprint.vertices.length)continue;const n=r.footprint.vertices;let i=e.getElevationAt(n[0].x,n[0].y,!0,!0);for(let t=1;t<n.length;t++)i=Math.min(i,e.getElevationAt(n[t].x,n[t].y,!0,!0));r.elevation=i;}}this.terrainTile=i.tileID.canonical,this.terrainExaggeration=e;}}updateDEM(t,e,r,n){let i=e._dem._modifiedForSources[n];if(void 0===i&&(e._dem._modifiedForSources[n]=[],i=e._dem._modifiedForSources[n]),i.includes(r.canonical))return;const s=e._dem.dim;i.push(r.canonical);let a=!1;for(const t of this.getNodesInfo()){const r=t.node;if(!r.footprint||!r.footprint.grid)continue;const n=r.footprint.grid,i=e.tileCoordToPixel(n.min.x,n.min.y),o=e.tileCoordToPixel(n.max.x,n.max.y),l=Math.min(Math.min(s-o.y,i.x),Math.min(i.y,s-o.x));if(l<0)continue;const u=Ke(l,2,5);let c=Math.max(0,i.x-u),h=Math.max(0,i.y-u),p=Math.min(o.x+u,s-1),f=Math.min(o.y+u,s-1);for(let t=h;t<=f;++t)for(let e=c;e<=p;++e)Zv[t*s+e]=255;let d=0,m=0;for(let t=0;t<n.cellsY;++t)for(let r=0;r<n.cellsX;++r){if(!n.cells[t*n.cellsX+r])continue;const i=e.tileCoordToPixel(n.min.x+r/n.xScale,n.min.y+t/n.yScale),a=e.tileCoordToPixel(n.min.x+(r+1)/n.xScale,n.min.y+(t+1)/n.yScale);for(let t=i.y;t<=Math.min(a.y+1,s-1);++t)for(let r=i.x;r<=Math.min(a.x+1,s-1);++r)255===Zv[t*s+r]&&(Zv[t*s+r]=0,d+=e.getElevationAtPixel(r,t),m++);}const y=d/m;c=Math.max(1,i.x-u),h=Math.max(1,i.y-u),p=Math.min(o.x+u,s-2),f=Math.min(o.y+u,s-2),a=!0;for(let t=h;t<=f;++t)for(let r=c;r<=p;++r)0===Zv[t*s+r]&&(Xv[t*s+r]=e._dem.set(r,t,y));for(let t=1;t<u;++t){c=Math.max(1,i.x-t),h=Math.max(1,i.y-t),p=Math.min(o.x+t,s-2),f=Math.min(o.y+t,s-2);for(let r=h;r<=f;++r)for(let n=c;n<=p;++n){const i=r*s+n;if(255===Zv[i]){let a=0,o=0,l=-1,c=-1;for(let e=-1;e<=1;++e)for(let i=-1;i<=1;++i){const u=(r+e)*s+n+i;if(Zv[u]>=t)continue;const h=Xv[u],p=Math.abs(h);p>o&&(a=h,o=p,l=i,c=e);}if(o>.1){const s=1-(t+.5*Math.abs(l*c))/u;let o=e._dem.get(n,r)+a*s;const h=e._dem.get(n+l,r+c),p=e._dem.get(n-l,r-c,!0);(o-h)*(o-p)>0&&(o=(h+p)/2),Xv[i]=e._dem.set(n,r,o),Zv[i]=t;}}}}}a&&(e._demTile.needsDEMTextureUpload=!0,e._dem._timestamp=Dr.now());}getNodesInfo(){return this.nodesInfo}destroy(){const t=this.getNodesInfo();for(const e of t)rv(e.node),nv(e.node);}isEmpty(){return !this.nodesInfo.length}updateReplacement(t,e){if(e.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=e.updateTime;const r=e.getReplacementRegionsForTile(t.toUnwrapped()),n=this.getNodesInfo();for(let t=0;t<this.nodesInfo.length;t++){const e=n[t].node;n[t].hiddenByReplacement=!!e.footprint&&!r.find((t=>t.footprint===e.footprint));}}getHeightAtTileCoord(e,r){const n=this.getNodesInfo(),i=[],s=[0,0,0],a=t.ad.identity([]);for(let o=0;o<this.nodesInfo.length;o++){const l=n[o],u=l.node.meshes[0],c=u.transformedAabb;if(e<c.min[0]||r<c.min[1]||e>c.max[0]||r>c.max[1])continue;if(!0===l.node.hidden)return {height:0,maxHeight:l.feature.properties.height,hidden:!1,verticalScale:l.evaluatedScale[2]};t.ad.invert(a,l.node.matrix),s[0]=e,s[1]=r,t._.transformMat4(s,s,a);const h=(s[0]-u.aabb.min[0])/(u.aabb.max[0]-u.aabb.min[0])*Kb|0,p=Math.min(63,(s[1]-u.aabb.min[1])/(u.aabb.max[1]-u.aabb.min[1])*Kb|0)*Kb+Math.min(63,h),f=u.heightmap[p];if(!(f<0&&l.node.footprint)){if(l.hiddenByReplacement)return;return {height:f,maxHeight:l.feature.properties.height,hidden:!1,verticalScale:l.evaluatedScale[2]}}if(l.node.footprint.grid.query(new Ne(e,r),new Ne(e,r),i),i.length>0)return {height:void 0,maxHeight:l.feature.properties.height,hidden:l.hiddenByReplacement,verticalScale:l.evaluatedScale[2]}}}}function t_(t,e){return !t.isLightConstant&&e}function e_(t,e,r,n,i,s,a,o){let l=(61440&e|(61440&e)>>4)>>8,u=(3840&e|(3840&e)>>4)>>4,c=240&e|(240&e)>>4;r[3]>0&&(l=Gn(l,255*r[0],r[3]),u=Gn(u,255*r[1],r[3]),c=Gn(c,255*r[2],r[3]));const h=l<<8|u,p=c<<8|Math.floor(255*n[3]),f=function(t){const e=Ke(t,0,2);return Math.min(Math.round(.5*e*255),255)}(n[2])<<8|15*n[0]<<4|15*n[1],d=Ke(i[0],0,1),m=Ke(i[1],0,1),y=Ke(i[2],0,1),g=Ke(i[3],0,1);let x,b,v,_;if(d!==m&&a!==s&&m!==d){const t=a-s;b=1/(t*(m-d)),v=-(s+t*d)/(t*(m-d));const e=Ke(i[4],-1,1);_=Math.pow(10,e),x=255*y<<8|255*g;}else x=65535,b=0,v=1,_=1;if(t.emplaceBack(h,p,f,x,b,v,_),o){const t=o.length;o.clear();for(let e=0;e<t;e++)o.emplaceBack(h,p,f,x,b,v,_);}}function r_(t,e,r){const n=t.node;let i=0;const s=r&Wb.HasMeshoptCompression;for(const r of n.meshes){if(n.lights&&n.lightMeshIndex===i)continue;if(!r.featureData)continue;r.featureArray=new lu,r.featureArray.reserve(r.featureData.length);let a=e;for(const e of r.featureData){const i=s?65535&e:e>>16&65535,o=s?e>>16&65535:65535&e,l=(15&o)<8?15&o:0,u=t.evaluatedRMEA[l],c=t.evaluatedColor[l],h=t.emissionHeightBasedParams[l];let p;if(a&&2===l&&n.lights&&(p=new lu,p.resize(10*n.lights.length)),e_(r.featureArray,i,c,u,h,r.aabb.min[2],r.aabb.max[2],p),p&&a){a=!1;const t=n.meshes[n.lightMeshIndex];t.featureArray=p,t.featureArray._trim();}}r.featureArray._trim(),i++;}}function n_(t,e,r,n){const i=1<<t.z;e.lat=Ec((n/ps+t.y)/i),e.lng=zc((r/ps+t.x)/i);}Mo(Qv,"Tiled3dModelBucket",{omit:["layers"]}),Mo(Jv,"Tiled3dModelFeature");const i_={circle:class extends kl{constructor(t,e,r,n){super(t,yh,e,r,n);}createBucket(t){return new Kc(t)}queryRadius(t){const e=t;return hh("circle-radius",this,e)+hh("circle-stroke-width",this,e)+ph(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=dh(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return np(t,n,s,a,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getDefaultProgramParams(t,e,r){const n=rp(this);return {config:new Ku(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}},heatmap:class extends kl{createBucket(t){return new lp(t)}constructor(t,e,r,n){super(t,yp,e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=gp({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return hh("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=this.paint.get("heatmap-radius").evaluate(e,r);return np(t,n,s,a,o,!0,!0,new Ne(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getDefaultProgramParams(t,e,r){return "heatmap"===t?{config:new Ku(this,{zoom:e,lut:r}),overrideFog:!1}:{}}},hillshade:class extends kl{constructor(t,e,r,n){super(t,bp,e,r,n);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},fill:class extends kl{constructor(t,e,r,n){super(t,Qp,e,r,n);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getDefaultProgramParams(t,e,r){return {config:new Ku(this,{zoom:e,lut:r}),overrideFog:!1}}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new Wp(t)}queryRadius(){return ph(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&Qc(fh(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}},"fill-extrusion":class extends kl{constructor(t,e,r,n){super(t,zd,e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new xd(t)}queryRadius(){return ph(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}hasShadowPass(){return !0}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(e,r,n,i,s,a,o,l,u){const c=dh(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,e.pixelToTileUnitsFactor),h=this.paint.get("fill-extrusion-height").evaluate(r,n),p=this.paint.get("fill-extrusion-base").evaluate(r,n),f=[0,0],d=l&&a.elevation,m=a.elevation?a.elevation.exaggeration():1,y=e.tile.getBucket(this);if(d&&y instanceof xd){const t=y.centroidVertexArray,e=u+1;e<t.length&&(f[0]=t.geta_centroid_pos0(e),f[1]=t.geta_centroid_pos1(e));}if(0===f[0]&&1===f[1])return !1;"globe"===a.projection.name&&(i=Td([i],[new Ne(0,0),new Ne(ps,ps)],e.tileID.canonical).map((t=>t.polygon)).flat());const g=d?l:null,[x,b]=function(e,r,n,i,s,a,o,l,u,c,h){return "globe"===e.projection.name?function(e,r,n,i,s,a,o,l,u,c,h){const p=[],f=[],d=e.projection.upVectorScale(h,e.center.lat,e.worldSize).metersToTile,m=[0,0,0,1],y=[0,0,0,1],g=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},x=Id();n>0&&(n+=x),i+=x;for(const x of r){const r=[],b=[];for(const p of x){const f=p.x+s.x,x=p.y+s.y,v=e.projection.projectTilePoint(f,x,h),_=e.projection.upVector(h,p.x,p.y);let w=n,M=i;if(o){const t=Dd(f,x,n,i,o,l,u,c);w+=t.base,M+=t.top;}0!==n?g(m,v.x+_[0]*d*w,v.y+_[1]*d*w,v.z+_[2]*d*w):g(m,v.x,v.y,v.z),g(y,v.x+_[0]*d*M,v.y+_[1]*d*M,v.z+_[2]*d*M),t._.transformMat4(m,m,a),t._.transformMat4(y,y,a),r.push(new If(m[0],m[1],m[2])),b.push(new If(y[0],y[1],y[2]));}p.push(r),f.push(b);}return [p,f]}(e,r,n,i,s,a,o,l,u,c,h):o?function(e,r,n,i,s,a,o,l,u){const c=[],h=[],p=[0,0,0,1];for(const f of e){const e=[],d=[];for(const c of f){const h=c.x+i.x,f=c.y+i.y,m=Dd(h,f,r,n,a,o,l,u);p[0]=h,p[1]=f,p[2]=m.base,p[3]=1,t.aA.transformMat4(p,p,s),p[3]=Math.max(p[3],1e-5);const y=new If(p[0]/p[3],p[1]/p[3],p[2]/p[3]);p[0]=h,p[1]=f,p[2]=m.top,p[3]=1,t.aA.transformMat4(p,p,s),p[3]=Math.max(p[3],1e-5);const g=new If(p[0]/p[3],p[1]/p[3],p[2]/p[3]);e.push(y),d.push(g);}c.push(e),h.push(d);}return [c,h]}(r,n,i,s,a,o,l,u,c):function(t,e,r,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x+n.x,a=s.y+n.y,m=i[0]*e+i[4]*a+i[12],y=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],b=m+o,v=y+l,_=g+u,w=Math.max(x+c,1e-5),M=m+h,A=y+p,S=g+f,I=Math.max(x+d,1e-5);t.push(new If(b/w,v/w,_/w)),r.push(new If(M/I,A/I,S/I));}s.push(t),a.push(r);}return [s,a]}(r,n,i,s,a)}(a,i,p,h,c,o,g,f,m,a.center.lat,e.tileID.canonical),v=e.queryGeometry;return function(t,e,r){let n=1/0;Qc(r,e)&&(n=Bd(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Wc(r,i)&&(n=Math.min(n,Bd(r,i)));}}return n!==1/0&&n}(x,b,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},line:class extends kl{constructor(t,e,r,n){super(t,nm,e,r,n),nm.layout&&(this.layout=new nl(nm.layout)),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof ea,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=rb.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new tm(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(t,e,r){const n=om(this);return {config:new Ku(this,{zoom:e,lut:r}),defines:n,overrideFog:!1}}queryRadius(t){const e=t,r=nb(hh("line-width",this,e),hh("line-gap-width",this,e)),n=hh("line-offset",this,e);return r/2+Math.abs(n)+ph(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,s){if(t.queryGeometry.isAboveHorizon)return !1;const a=fh(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),o=t.pixelToTileUnitsFactor/2*nb(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new Ne(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t],i=s[t+1],o=0===t?n:r.sub(s[t-1])._unit()._perp(),l=t===s.length-1?n:i.sub(r)._unit()._perp(),u=o._add(l)._unit();u._mult(1/(u.x*l.x+u.y*l.y)),a.push(u._mult(e)._add(r));}r.push(a);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(ah(t,i[e]))return !0;if(th(t,i,r))return !0}return !1}(a,n,o)}isTileClipped(){return !0}isDraped(t){const e=this.layout.get("line-z-offset");return e.isConstant()&&!e.constantOr(0)}},symbol:ob,background:class extends kl{constructor(t,e,r,n){super(t,ub,e,r,n);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(t,e,r){return {overrideFog:!1}}},raster:gb,"raster-particle":vb,sky:class extends kl{constructor(t,e,r,n){super(t,Mb,e,r,n),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=gp({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&fr("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?Ab(s.azimuthal,90-s.polar,e):Ab(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return Ab(r[0],90-r[1],e)}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}},slot:class extends kl{constructor(t,e,r,n){super(t,Sb,e,null);}},model:class extends kl{constructor(t,e,r,n){super(t,Hb,e,r,n),this._stats={numRenderedVerticesInShadowPass:0,numRenderedVerticesInTransparentPass:0};}createBucket(t){return new Xb(t)}getProgramIds(){return ["model"]}is3D(){return !0}hasShadowPass(){return !0}canCastShadows(){return !0}hasLightBeamPass(){return !0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(t){return t instanceof Qv?ps-1:0}queryIntersectsFeature(e,r,n,i,s,a){if(!this.modelManager)return !1;const o=this.modelManager,l=e.tile.getBucket(this);if(!(l&&l instanceof Xb))return !1;const u=l;for(const n in u.instancesPerModel){const i=u.instancesPerModel[n],s=void 0!==r.id?r.id:r.properties&&r.properties.hasOwnProperty("id")?r.properties.id:void 0;if(i.idToFeaturesIndex.hasOwnProperty(s)){const r=i.features[i.idToFeaturesIndex[s]],l=o.getModel(n,this.scope);if(!l)return !1;let c=t.ad.create();const h=new mc(0,0),p=u.canonical;let f=Number.MAX_VALUE;for(let n=0;n<r.instancedDataCount;++n){const s=16*(r.instancedDataOffset+n),o=i.instancedDataArray.float32,u=[o[s+4],o[s+5],o[s+6]];n_(p,h,o[s],0|o[s+1]),Jb(c,l,a,h,r.rotation,r.scale,u,!1,!1,!1),"globe"===a.projection.name&&(c=Cb(c,a));const d=t.ad.multiply([],a.projMatrix,c),m=e.queryGeometry,y=Rb(m.isPointQuery()?m.screenBounds:m.screenGeometry,a,d,l.aabb);null!=y&&(f=Math.min(y,f));}return f!==Number.MAX_VALUE&&f}}return !1}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven()||"model-color"!==t&&"model-color-mix-intensity"!==t&&"model-rotation"!==t&&"model-scale"!==t&&"model-translation"!==t&&"model-emissive-strength"!==t)}_isPropertyZoomDependent(t){const e=this._transitionablePaint._values[t];return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof fo}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}queryIntersectsMatchingFeature(e,r,n,i){const s=e.tile,a=s.getBucket(this);let o=null,l=Number.MAX_VALUE;if(!(a&&a instanceof Qv))return {queryFeature:o,intersectionZ:l};const u=a.getNodesInfo()[r];if(u.hiddenByReplacement||!u.node.meshes||!n.filter(new Ho(s.tileID.overscaledZ),u.feature,s.tileID.canonical))return {queryFeature:o,intersectionZ:l};const c=u.node,h=i.calculatePosMatrix(s.tileID.toUnwrapped(),i.worldSize),p=u.evaluatedScale;let f=0;i.elevation&&c.elevation&&(f=c.elevation*i.elevation.exaggeration()),t.ad.translate(h,h,[(c.anchor?c.anchor[0]:0)*(p[0]-1),(c.anchor?c.anchor[1]:0)*(p[1]-1),f]),t.ad.scale(h,h,p),t.ad.multiply(h,h,c.matrix);const d=e.queryGeometry,m=d.isPointQuery()?d.screenBounds:d.screenGeometry,y=function(e){const r=t.ad.multiply([],h,e.matrix),n=t.ad.multiply(r,i.expandedFarZProjMatrix,r);for(let t=0;t<e.meshes.length;++t){const r=e.meshes[t];if(t===e.lightMeshIndex)continue;const s=Rb(m,i,n,r.aabb);null!=s&&(l=Math.min(s,l));}if(e.children)for(const t of e.children)y(t);};if(y(c),l===Number.MAX_VALUE)return {queryFeature:o,intersectionZ:l};const g=new mc(0,0);return n_(s.tileID.canonical,g,u.node.anchor[0],u.node.anchor[1]),o={type:"Feature",geometry:{type:"Point",coordinates:[g.lng,g.lat]},properties:u.feature.properties,id:u.feature.id,state:{},layer:this.serialize()},{queryFeature:o,intersectionZ:l}}},clip:class extends kl{constructor(t,e,r,n){super(t,sf,e,r,n);}recalculate(t,e){super.recalculate(t,e);}createBucket(t){return new rf(t)}isTileClipped(){return !0}is3D(){return !0}}};Mo(Hx,"MRTDecodingBatch",{omit:["_onCancel","_onComplete"]});const s_=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class a_{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=s_[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new a_(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=s_.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return o_(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)h_(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];h_(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function o_(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;l_(t,e,a,n,i,s),o_(t,e,r,n,a-1,1-s),o_(t,e,r,a+1,i,1-s);}function l_(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);l_(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(u_(t,e,n,r),e[2*i+s]>a&&u_(t,e,n,i);o<l;){for(u_(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?u_(t,e,n,l):(l++,u_(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function u_(t,e,r,n){c_(t,r,n),c_(e,2*r,2*n),c_(e,2*r+1,2*n+1);}function c_(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function h_(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}t.$=We,t.A=Hs,t.B=Ys,t.C=qn,t.D=Bi,t.E=Ln,t.G=hl,t.H=eo,t.I=Ig,t.J=Ja,t.K=function(t){const e=t.value;let r=[];if(!e)return r;const n=Ti(e);return "string"!==n?(r=r.concat([new qb(t.key,e,`string expected, "${n}" found`)]),r):($b(e,!0)||(r=r.concat([new qb(t.key,e,`invalid url "${e}"`)])),r)},t.L=ll,t.M=class{constructor(t,e,r,n){this.id=t,this.position=null!=e?new mc(e[0],e[1]):new mc(0,0),this.orientation=null!=r?r:[0,0,0],this.nodes=n,this.uploaded=!1,this.aabb=new Ah([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[];}_applyTransformations(e,r){if(t.ad.multiply(e.matrix,r,e.matrix),e.meshes)for(const t of e.meshes){const r=Ah.applyTransformFast(t.aabb,e.matrix);this.aabb.encapsulate(r);}if(e.children)for(const t of e.children)this._applyTransformations(t,e.matrix);}computeBoundsAndApplyParent(){const e=t.ad.identity([]);for(const t of this.nodes)this._applyTransformations(t,e);}computeModelMatrix(t,e,r,n,i,s,a=!1){Jb(this.matrix,this,t.transform,this.position,e,r,n,i,s,a);}upload(t){if(!this.uploaded){for(const e of this.nodes)ev(e,t);for(const t of this.nodes)rv(t);this.uploaded=!0;}}destroy(){for(const t of this.nodes)nv(t);}},t.N=ol,t.O=il,t.P=Ne,t.Q=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return yr(t.expression.evaluate(e))}interpolate(t,e,r){return {x:Gn(t.x,e.x,r),y:Gn(t.y,e.y,r),z:Gn(t.z,e.z,r),azimuthal:Gn(t.azimuthal,e.azimuthal,r),polar:Gn(t.polar,e.polar,r)}}},t.R=Wr,t.S=uu,t.T=Gg,t.U=Jo,t.V=qb,t.W=er,t.X=Ho,t.Y=Oc,t.Z=fo,t.a=Eg,t.a$=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return Zh(e,r,t.worldSize,n,i)},t.a0=nl,t.a1=Hh,t.a2=Gn,t.a3=ps,t.a4=Yn,t.a5=class{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return function([t,e]){const r=yr([1,t,e]);return {x:r.x,y:r.y,z:r.z}}(t.expression.evaluate(e))}interpolate(t,e,r){return {x:Gn(t.x,e.x,r),y:Gn(t.y,e.y,r),z:Gn(t.z,e.z,r)}}},t.a6=Uu,t.a7=Du,t.a8=Ru,t.a9=Ou,t.aB=function(e,r){const{x:n,y:i}=e.point,s=Zh(n,i,e.worldSize/e._pixelsPerMercatorPixel,0,0);return t.ad.multiply(s,s,Gh(Ch(r)))},t.aD=qm,t.aE=ty,t.aF=jm,t.aG=function(t,e,r,n,i){const s=5*e+2;t.float32[s+0]=r,t.float32[s+1]=n,t.float32[s+2]=i;},t.aH=Ug,t.aI=mc,t.aJ=Sg,t.aK=vc,t.aL=_c,t.aM=Mh,t.aN=Tb,t.aO=bc,t.aP=Oh,t.aQ=function(t,e,r,n,i,s,a,o,l){if("globe"===l.name)return Oh(t,e,new bc(r,n,i),!1);const u=ng({z:r,x:n,y:i},l);return new Ah([(s+u.x/u.scale)*e,e*(u.y/u.scale),a],[(s+u.x2/u.scale)*e,e*(u.y2/u.scale),o])},t.aR=function(t,e,r){let n=0;for(let r=0;r<2;++r){const i=0;t[r]>i&&(n+=(t[r]-i)*(t[r]-i)),e[r]<i&&(n+=(i-e[r])*(i-e[r]));}return n},t.aS=Dc,t.aT=gh,t.aU=sc,t.aV=function(e){const r=t.ad.identity(new Float64Array(16));t.ad.multiply(r,e.pixelMatrix,e.globeMatrix);const n=[0,uc,0],i=[0,cc,0];return t._.transformMat4(n,n,r),t._.transformMat4(i,i,r),[n[0]>0&&n[0]<=e.width&&n[1]>0&&n[1]<=e.height&&!Wh(e,new mc(e.center.lat,90)),i[0]>0&&i[0]<=e.width&&i[1]>0&&i[1]<=e.height&&!Wh(e,new mc(e.center.lat,-90))]},t.aW=function(e,r){const{scale:n}=e.tileTransform,i=n*ps/(e.tileSize*Math.pow(2,r.zoom-e.tileID.overscaledZ+e.tileID.canonical.z));return t.aC.scale(new Float32Array(4),r.inverseAdjustmentMatrix,[i,i])},t.aX=kb,t.aY=Ib,t.aZ=function(e){const r=Ib(e,!0);return t.aC.invert([],[r[0],r[1],r[4],r[5]])},t.a_=xh,t.aa=Cu,t.ab=$e,t.ac=function(t,e,r){const n=Math.sqrt(t*t+e*e+r*r),i=n>0?Math.acos(r/n)*qe:0;let s=0!==t||0!==e?Math.atan2(-e,-t)*qe+90:0;return s<0&&(s+=360),[n,s,i]},t.ae=Tg,t.af=Cg,t.ag=Pg,t.ah=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.ai=yc,t.aj=Tc,t.ak=kc,t.al=Sl,t.am=function(t){qr++,qr>Or&&(t.getActor().send("enforceCacheSizeLimit",Lr),qr=0);},t.an=gn,t.ao=class{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}},t.ap=function(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=en(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new Af(new Bm(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)},t.aq=Vu,t.ar=class extends Bu{constructor(t){super(t),this.current=Nu;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.as=Lu,t.at=Ke,t.au=Je,t.aw=Tr,t.ax=Pc,t.ay=Ec,t.az=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.b=Au,t.b$=od,t.b0=Ge,t.b1=ic,t.b2=function(t){const e=Math.round((t+45+360)%360/90)%4;return Ye[e]},t.b3=45,t.b4=Ic,t.b5=Lc,t.b6=Ah,t.b7=yr,t.b8=function(t){return [Math.pow(t[0],1/2.2),Math.pow(t[1],1/2.2),Math.pow(t[2],1/2.2)]},t.b9=Xe,t.bA=function(t,e){return [Math.pow(t[0],2.2)*e,Math.pow(t[1],2.2)*e,Math.pow(t[2],2.2)*e]},t.bB=im,t.bD=Xh,t.bE=Er,t.bF=zr,t.bG=256,t.bH=function(e,r){const n=[0,0,0],i=$h(Ch(r.canonical));return t._.transformMat4(n,n,i),t._.transformMat4(n,n,e),n},t.bI=t=>({u_camera_to_center_distance:new Cu(t),u_extrude_scale:new qu(t),u_device_pixel_ratio:new Cu(t),u_matrix:new Uu(t),u_inv_rot_matrix:new Uu(t),u_merc_center:new Ru(t),u_tile_id:new Vu(t),u_zoom_transition:new Cu(t),u_up_dir:new Vu(t),u_emissive_strength:new Cu(t)}),t.bJ=t=>({u_matrix:new Uu(t),u_pixels_to_tile_units:new qu(t),u_device_pixel_ratio:new Cu(t),u_units_to_pixels:new Ru(t),u_dash_image:new Du(t),u_gradient_image:new Du(t),u_image_height:new Cu(t),u_texsize:new Ru(t),u_tile_units_to_pixels:new Cu(t),u_alpha_discard_threshold:new Cu(t),u_trim_offset:new Ru(t),u_trim_fade_range:new Ru(t),u_trim_color:new Lu(t),u_emissive_strength:new Cu(t)}),t.bK=t=>({u_matrix:new Uu(t),u_texsize:new Ru(t),u_pixels_to_tile_units:new qu(t),u_device_pixel_ratio:new Cu(t),u_image:new Du(t),u_units_to_pixels:new Ru(t),u_tile_units_to_pixels:new Cu(t),u_alpha_discard_threshold:new Cu(t),u_trim_offset:new Ru(t)}),t.bL=Wl,t.bM=Hd,t.bN=Fm,t.bO=$m,t.bP=Yy,t.bQ=hy,t.bR=rp,t.bS=(t,e,r,n,i,s)=>{const a=t.transform,o="globe"===a.projection.name;let l;if("map"===s.paint.get("circle-pitch-alignment"))if(o){const t=Xh(a.zoom,e.canonical)*a._pixelsPerMercatorPixel;l=Float32Array.from([t,0,0,t]);}else l=a.calculatePixelsToTileUnitsMatrix(r);else l=new Float32Array([a.pixelsToGLUnits[0],0,0,a.pixelsToGLUnits[1]]);const u={u_camera_to_center_distance:t.transform.getCameraToCenterDistance(a.projection),u_matrix:t.translatePosMatrix(e.projMatrix,r,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_device_pixel_ratio:Dr.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:ep,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:s.paint.get("circle-emissive-strength")};if(o){u.u_inv_rot_matrix=n,u.u_merc_center=i,u.u_tile_id=[e.canonical.x,e.canonical.y,1<<e.canonical.z],u.u_zoom_transition=Hh(a.zoom);const t=i[0]*ps,r=i[1]*ps;u.u_up_dir=a.projection.upVector(new bc(0,0,0),t,r);}return u},t.bT=om,t.bU=(t,e,r,n,i,s)=>{const a=t.transform;return {u_matrix:am(t,e,r,n),u_texsize:e.imageAtlasTexture?e.imageAtlasTexture.size:[0,0],u_pixels_to_tile_units:a.calculatePixelsToTileUnitsMatrix(e),u_device_pixel_ratio:i,u_image:0,u_tile_units_to_pixels:sm(e,a),u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]],u_alpha_discard_threshold:0,u_trim_offset:s}},t.bV=(t,e,r,n,i,s,a)=>{const o=t.transform,l=o.calculatePixelsToTileUnitsMatrix(e);return {u_matrix:am(t,e,r,n),u_pixels_to_tile_units:l,u_device_pixel_ratio:s,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:i,u_texsize:lm(r)&&e.lineAtlasTexture?e.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:sm(e,t.transform),u_alpha_discard_threshold:0,u_trim_offset:a,u_trim_fade_range:r.paint.get("line-trim-fade-range"),u_trim_color:r.paint.get("line-trim-color").toRenderColor(r.lut).toArray01(),u_emissive_strength:r.paint.get("line-emissive-strength")}},t.bW=sr,t.bX=gp,t.bY=Id,t.bZ=Mc,t.b_=xd,t.ba=function(t,e,r){const n=Hh(r.zoom),i=t.style.map._antialias,s=e.options.extStandardDerivativesForceOff||t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!s},t.bb=function(e){const r=e.pixelsPerMeter,n=r/Pc(1,e.center.lat),i=t.ad.identity(new Float64Array(16));return t.ad.translate(i,i,[e.point.x,e.point.y,0]),t.ad.scale(i,i,[n,n,r]),Float32Array.from(i)},t.bc=Fh,t.bd=function(t){const e=Dc-5;t=Ke(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin($e(t))),3);return Math.round(r*(lc.length-1))},t.be=function(e,r,n,i){const s=r.getNorth(),a=r.getSouth(),o=r.getWest(),l=r.getEast(),u=1<<e.z,c=l-o,h=s-a,p=c/oc,f=-h/lc[n],d=[0,p,0,f,0,0,s,o,0];if(e.z>0){const e=180/i;t.bC.multiply(d,d,[e/c+1,0,0,0,e/h+1,0,-.5*e/p,.5*e/f,1]);}return d[2]=u,d[5]=e.x,d[8]=e.y,d},t.bf=$h,t.bg=Ch,t.bh=function(e,r,n){const i=t.ad.identity(new Float64Array(16)),s=(r/(1<<e)-.5)*Math.PI*2;return t.ad.rotateY(i,n.globeMatrix,s),Float32Array.from(i)},t.bi=Br,t.bj=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.bk=gb,t.bl=vb,t.bm=mb,t.bn=function(t,e){const r=document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const n=document.createElement("source");rn(t[e])||(r.crossOrigin="Anonymous"),n.src=t[e],r.appendChild(n);}return {cancel:()=>{}}},t.bo=Yg,t.bp=or,t.bq=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),s=Math.floor((t.x-i)*n),a=Math.floor(t.y*n),o=this.findDEMTileFor(new _c(r,i,r,s,a));return !(!o||!o.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,a=Math.floor(t.x),o=t.x-a,l=new _c(i,a,i,Math.floor(o*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),m=Math.floor(f);return (r?this.exaggeration():1)*Gn(Gn(c.get(d,m),c.get(d,m+1),f-m),Gn(c.get(d+1,m),c.get(d+1,m+1),f-m),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new Oc(t.wrap+(t.canonical.x+e/ps)/n,(t.canonical.y+r/ps)/n))}getAtTileOffsetFunc(e,r,n,i){return s=>{const a=this.getAtTileOffset(e,s.x,s.y),o=i.upVector(e.canonical,s.x,s.y),l=i.upVectorScale(e.canonical,r,n).metersToTile;return t._.scale(o,o,a*l),o}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=Qf.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,a=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}getMinMaxForVisibleTiles(){const t=this.visibleDemTiles;if(0===t.length)return null;let e=!1,r=Number.MAX_VALUE,n=Number.MIN_VALUE;for(const i of t){const t=this.getMinMaxForTile(i.tileID);t&&(r=Math.min(r,t.min),n=Math.max(n,t.max),e=!0);}return e?{min:r,max:n}:null}},t.br=kh,t.bs=Ph,t.bt=Cl,t.bu=Ql,t.bv=Jx,t.bw=ov,t.bx=fv,t.by=nx,t.bz=dp,t.c=$v,t.c$=tn,t.c0=450,t.c1=7,t.c2=yb,t.c3=Kx,t.c4=256,t.c5=Vh,t.c6=Gh,t.c7=Bl,t.c8=Ul,t.c9=ru,t.cA=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {min:new Ne(e,r),max:new Ne(n,i)}},t.cB=ah,t.cC=Uc,t.cD=nc,t.cE=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.cF=My,t.cG=Wc,t.cH=Ff,t.cI=Uf,t.cJ=Xy,t.cK=a_,t.cL=function(t){return t({pluginStatus:No,pluginURL:jo}),Go.on("pluginStateChange",t),t},t.cM=Dy,t.cN=By,t.cO=Qr,t.cP=qo,t.cQ=s,t.cR=Rr,t.cS=Bn,t.cT=hr,t.cU=function(t){const e=t.indexOf(Al);return e>=0?t.slice(0,e):t},t.cV=function(t){return t.indexOf(Al)>=0},t.cW=function(t){const e=t.indexOf(Al);return e>=0?t.slice(e+1):""},t.cX=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.cY=function(t,e,r,n){return "custom"===t.type?new _b(t,e):new i_[t.type](t,e,r,n)},t.cZ=cr,t.c_=Go,t.ca=1,t.cb=zg,t.cc=0,t.cd=nu,t.ce=function(t,e,r,n,i){return Ke((t-e)/(r-e)*(i-n)+n,n,i)},t.cf=Na,t.cg=Rc,t.ch=class{constructor(t,e,r,n){this.context=t,this.format=n,this.size=r,this.texture=t.gl.createTexture();const[i,s,a]=this.size,{gl:o}=t;o.bindTexture(o.TEXTURE_3D,this.texture),t.pixelStoreUnpackFlipY.set(!1),t.pixelStoreUnpack.set(1),t.pixelStoreUnpackPremultiplyAlpha.set(!1);let l=this.format,u=o.UNSIGNED_BYTE;this.format===o.DEPTH_COMPONENT&&(l=o.DEPTH_COMPONENT16,u=o.UNSIGNED_SHORT),this.format===o.R8&&(n=o.RED),this.format===o.R32F&&(u=o.FLOAT,n=o.RED),o.texImage3D(o.TEXTURE_3D,0,l,i,s,a,0,n,u,e.data);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_3D,this.texture),t!==this.minFilter&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_MIN_FILTER,t),this.minFilter=t),e!==this.wrapS&&(n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_3D,n.TEXTURE_WRAP_T,e),this.wrapS=e);}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}},t.ci=Cb,t.cj=[1,1,1],t.ck=Qf,t.cl=Wb,t.cm=Zl,t.cn=iu,t.co=class{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[],this._globalClipBounds={min:new Ne(1/0,1/0),max:new Ne(-1/0,-1/0)};}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[];}get updateTime(){return this._updateTime}getReplacementRegionsForTile(t,e=!1){const r=Rf(new Ne(0,0),new Ne(ps,ps),t),n=[];if(e&&!Df(r,this._globalClipBounds))return n;for(const e of this._activeRegions){if(e.hiddenByOverlap)continue;if(!Df(r,e))continue;const i=Vf(e.min,e.max,t);n.push({min:i.min,max:i.max,sourceId:this._sourceIds[e.priority],footprint:e.footprint,footprintTileId:e.tileId,order:e.order,clipMask:e.clipMask});}return n}setSources(t){this._setSources(t.map((t=>({getSourceId:()=>t.cache.id,getFootprints:()=>{const e=[];for(const r of t.cache.getVisibleCoordinates()){const n=t.cache.getTile(r).buckets[t.layer];n&&n.updateFootprints(r.toUnwrapped(),e);}return e},getOrder:()=>t.order,getClipMask:()=>t.clipMask}))));}_addSource(t){const e=t.getFootprints();if(0===e.length)return;const r=t.getOrder(),n=t.getClipMask();for(const t of e){if(!t.footprint)continue;const e=Rf(t.footprint.min,t.footprint.max,t.id);this._activeRegions.push({min:e.min,max:e.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:t.id,footprint:t.footprint,order:r,clipMask:n});}this._sourceIds.push(t.getSourceId());}_computeReplacement(){this._activeRegions.sort(((t,e)=>t.priority-e.priority||Ef(t.min,e.min)||Ef(t.max,e.max)));let t=this._activeRegions.length!==this._prevRegions.length;if(!t){let e=0;for(;!t&&e!==this._activeRegions.length;){const r=this._activeRegions[e],n=this._prevRegions[e];t=r.priority!==n.priority||!Bf(r,n)||r.order!==n.order||r.clipMask!==n.clipMask,++e;}}if(t){++this._updateTime;for(const t of this._activeRegions)t.order!==1/0&&(this._globalClipBounds.min.x=Math.min(this._globalClipBounds.min.x,t.min.x),this._globalClipBounds.min.y=Math.min(this._globalClipBounds.min.y,t.min.y),this._globalClipBounds.max.x=Math.max(this._globalClipBounds.max.x,t.max.x),this._globalClipBounds.max.y=Math.max(this._globalClipBounds.max.y,t.max.y));const t=t=>{const e=this._activeRegions;if(t>=e.length)return t;const r=e[t].priority;for(;t<e.length&&e[t].priority===r;)++t;return t};if(this._sourceIds.length>1){let e=0,r=t(e);for(;e!==r;){let n=e;const i=e;for(;n!==r;){const t=this._activeRegions[n];t.hiddenByOverlap=!1;for(let e=0;e<i;e++){const r=this._activeRegions[e];if(!r.hiddenByOverlap&&t.order===1/0&&Df(t,r)&&(t.hiddenByOverlap=Of(t.footprint,t.tileId,r.footprint,r.tileId),t.hiddenByOverlap))break}++n;}e=r,r=t(e);}}}}_setSources(t){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let e=t.length-1;e>=0;e--)this._addSource(t[e]);this._computeReplacement();}},t.cp=Vl,t.cq=tx,t.cr=au,t.cs=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();}_fillGridMeshWithLods(t,e){const r=new Cl,n=new Ql,i=[],s=t+1+2,a=e[0]+1,o=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===s-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<s;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<a;++t)for(let e=0;e<s;++e)r.emplaceBack(...l(e,t,(0===e||e===s-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<s;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const a=n.length,l=e[t]+1+2,u=new Ql;for(let r=0;r<l-1;r++){const i=r===l-2,a=i?s*(o-e.length+t-r):s;for(let t=0;t<s-1;t++){const e=r*s+t;0===r||i||0===t||t===s-2?(u.emplaceBack(e+1,e,e+a),u.emplaceBack(e+a,e+a+1,e+1)):(n.emplaceBack(e+1,e,e+a),n.emplaceBack(e+a,e+a+1,e+1));}}const c=Au.simpleSegment(0,a,r.length,n.length-a);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=Au.simpleSegment(0,a,r.length,n.length-a);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(oc,lc);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,kh.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new Ql;for(let t=0;t<=oc;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new ru,n=new ru,i=new ru,s=new ru;this._poleSegments=[];for(let t=0,e=0;t<ic;t++){const a=360/(1<<t);r.emplaceBack(0,-nc,0,.5,0),n.emplaceBack(0,-nc,0,.5,1),i.emplaceBack(0,-nc,0,.5,.5),s.emplaceBack(0,-nc,0,.5,.5);for(let t=0;t<=oc;t++){let e=t/oc,o=0;const l=Gn(0,a,e),[u,c,h]=hc(Qh,tp,l,nc);r.emplaceBack(u,c,h,e,o),n.emplaceBack(u,c,h,e,1-o);const p=$e(l);e=.5+.5*Math.sin(p),o=.5+.5*Math.cos(p),i.emplaceBack(u,c,h,e,o),s.emplaceBack(u,c,h,e,1-o);}this._poleSegments.push(Au.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,Ih,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,Ih,!1),this._texturedPoleNorthVertexBuffer=t.createVertexBuffer(i,Ih,!1),this._texturedPoleSouthVertexBuffer=t.createVertexBuffer(s,Ih,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t,e){return [e?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,e?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}},t.ct=function(t){return In.has(t)},t.cu=td,t.cv=function(t,e,r=0,n=!0){const i=new Ne(r,r),s=t.sub(i),a=e.add(i),o=[s,new Ne(a.x,s.y),a,new Ne(s.x,a.y)];return n&&o.push(s.clone()),o},t.cw=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=Je(n-1,-1,t.length-1),s=Je(n+1,-1,t.length-1),a=t[n],o=t[s],l=t[i].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cx=ig,t.cy=oh,t.cz=function(e,r,n=0){return t._.fromValues(((r.x-n)*e.scale-e.x)*ps,(r.y*e.scale-e.y)*ps,Bc(r.z,r.y))},t.d=Cn,t.d$=Fe,t.d0=Ze,t.d1=function(){return !!document.fullscreenElement||!!document.webkitFullscreenElement},t.d2=He,t.d3=Vc,t.d4=pc,t.d5=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),s=.5*Math.PI-Math.acos(-e/n);return new mc(Ge(i),Ge(s))},t.d6=zc,t.d7=fc,t.d8=n,t.d9=Wh,t.dA=function(t){const e=Nr();if(!e)return;const r=e.delete(Vr);t&&r.catch(t).then((()=>t()));},t.dB=lv,t.dC=vv,t.dD=function(t){mv=Dr.resolveURL(t),bv||(bv=new ov(fv(),new Ln)),bv.broadcast("setDracoUrl",mv);},t.dE=_v,t.dF=function(t){gv=Dr.resolveURL(t),bv||(bv=new ov(fv(),new Ln)),bv.broadcast("setMeshoptUrl",gv);},t.dG=tr,t.dH=Mo,t.dI=pp,t.dJ=Ey,t.dK=ng,t.dL=pu,t.dM=um,t.dN=Vm,t.dO=Kd,t.dP=ur,t.dQ=Ty,t.dR=$g,t.dS=function(t,e,r,n,i,s,a,o,l,u,c){t.createArrays(),t.tilePixelRatio=ps/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const h=t.layers[0].layout,p=t.layers[0]._unevaluatedLayout._values,f={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;f.compositeTextSizes=[p["text-size"].possiblyEvaluate(new Ho(e),o),p["text-size"].possiblyEvaluate(new Ho(r),o)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;f.compositeIconSizes=[p["icon-size"].possiblyEvaluate(new Ho(e),o),p["icon-size"].possiblyEvaluate(new Ho(r),o)];}f.layoutTextSize=p["text-size"].possiblyEvaluate(new Ho(l+1),o),f.layoutIconSize=p["icon-size"].possiblyEvaluate(new Ho(l+1),o),f.textMaxSize=p["text-size"].possiblyEvaluate(new Ho(18),o);const d="map"===h.get("text-rotation-alignment")&&"point"!==h.get("symbol-placement"),m=h.get("text-size");let y=!1;for(const e of t.features)if(e.icon&&e.icon.nameSecondary){y=!0;break}for(const s of t.features){const l=h.get("text-font").evaluate(s,{},o).join(","),p=m.evaluate(s,{},o),g=f.layoutTextSize.evaluate(s,{},o),x=(f.layoutIconSize.evaluate(s,{},o),{horizontal:{},vertical:void 0}),b=s.text;let v,_=[0,0];if(b){const n=b.toString(),a=h.get("text-letter-spacing").evaluate(s,{},o)*Fm,u=h.get("text-line-height").evaluate(s,{},o)*Fm,c=zo(n)?a:0,f=h.get("text-anchor").evaluate(s,{},o),m=h.get("text-variable-anchor");if(!m){const t=h.get("text-radial-offset").evaluate(s,{},o);_=t?Yy(f,[t*Fm,$y]):h.get("text-offset").evaluate(s,{},o).map((t=>t*Fm));}let y=d?"center":h.get("text-justify").evaluate(s,{},o);const v="point"===h.get("symbol-placement"),w=v?h.get("text-max-width").evaluate(s,{},o)*Fm:1/0,M=s=>{t.allowVerticalPlacement&&Po(n)&&(x.vertical=ny(b,e,r,i,l,w,u,f,s,c,_,ty.vertical,!0,g,p));};if(!d&&m){const t="auto"===y?m.map((t=>Xy(t))):[y];let n=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!x.horizontal[a])if(n)x.horizontal[a]=x.horizontal[0];else {const t=ny(b,e,r,i,l,w,u,"center",a,c,_,ty.horizontal,!1,g,p);t&&(x.horizontal[a]=t,n=1===t.positionedLines.length);}}M("left");}else {if("auto"===y&&(y=Xy(f)),v||h.get("text-writing-mode").indexOf("horizontal")>=0||!Po(n)){const t=ny(b,e,r,i,l,w,u,f,y,c,_,ty.horizontal,!1,g,p);t&&(x.horizontal[y]=t);}M(v?"left":y);}}let w=!1;if(s.icon&&s.icon.namePrimary){const e=n[s.icon.namePrimary];e&&(v=fy(i[s.icon.namePrimary],s.icon.nameSecondary?i[s.icon.nameSecondary]:void 0,h.get("icon-offset").evaluate(s,{},o),h.get("icon-anchor").evaluate(s,{},o)),w=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&fr("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==h.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const M=Jy(x.horizontal)||x.vertical;t.iconsInText||(t.iconsInText=!!M&&M.iconsInText),(M||v)&&Zy(t,s,x,v,n,f,g,0,_,w,a,o,u,c,y);}s&&t.generateCollisionDebugBuffers(l,t.collisionBoxArray);},t.dT=tm,t.dU=Wp,t.dV=Af,t.dW=Bm,t.dX=Jf,t.dY=Xx,t.dZ=Sf,t.d_=pf,t.da=Kh,t.db=function(e){const r=[0,0,0],n=t.ad.identity(new Float64Array(16));return t.ad.multiply(n,e.pixelMatrix,e.globeMatrix),t._.transformMat4(r,r,n),new Ne(r[0],r[1])},t.dc=c,t.dd=u,t.de=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!function(t){if(null==Sr){const e=t.navigator?t.navigator.userAgent:null;Sr=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Sr}(t)&&e&&(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))},t.df=nr,t.dg=class{constructor(t,e,r){this._transformRequestFn=t,this._customAccessToken=e,this._silenceAuthErrors=!!r,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",ln,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,r){if(!s(t))return t;const n=hn(t);return n.params.push(`sdk=js-${e}`),n.path=`/styles/v1${n.path}`,this._makeAPIURL(n,this._customAccessToken||r)}normalizeGlyphsURL(t,e){if(!s(t))return t;const r=hn(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeModelURL(t,e){if(!s(t))return t;const r=hn(t);return r.path=`/models/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e,r,n){if(!s(t))return t;const i=hn(t);return i.path=`/v4/${i.authority}.json`,i.params.push("secure"),r&&i.params.push(`language=${r}`),n&&i.params.push(`worldview=${n}`),this._makeAPIURL(i,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,n){const i=hn(t);return s(t)?(i.path=`/styles/v1${i.path}/sprite${e}${r}`,this._makeAPIURL(i,this._customAccessToken||n)):(i.path+=`${e}${r}`,pn(i))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!s(t))return t;const i=hn(t);i.path=i.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==i.authority&&512===r?"@2x":""}${$r.supported?".webp":"$1"}`),"raster"===i.authority?i.path=`/${n.RASTER_URL_PREFIX}${i.path}`:"rasterarrays"===i.authority?i.path=`/${n.RASTERARRAYS_URL_PREFIX}${i.path}`:"3dtiles"===i.authority?i.path=`/${n.TILES3D_URL_PREFIX}${i.path}`:(i.path=i.path.replace(/^.+\/v4\//,"/"),i.path=`/${n.TILE_URL_VERSION}${i.path}`);const a=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(i.params)||n.ACCESS_TOKEN;return n.REQUIRE_ACCESS_TOKEN&&a&&this._skuToken&&i.params.push(`sku=${this._skuToken}`),this._makeAPIURL(i,a)}canonicalizeTileURL(t,e){const r=hn(t);if(!r.path.match(/^(\/v4\/|\/(raster|rasterarrays)\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let i="mapbox://";r.path.match(/^\/raster\/v1\//)?i+=`raster/${r.path.replace(`/${n.RASTER_URL_PREFIX}/`,"")}`:r.path.match(/^\/rasterarrays\/v1\//)?i+=`rasterarrays/${r.path.replace(`/${n.RASTERARRAYS_URL_PREFIX}/`,"")}`:i+=`tiles/${r.path.replace(`/${n.TILE_URL_VERSION}/`,"")}`;let s=r.params;return e&&(s=s.filter((t=>!t.match(/^access_token=/)))),s.length&&(i+=`?${s.join("&")}`),i}canonicalizeTileset(t,e){const r=!!e&&s(e),n=[];for(const e of t.tiles||[])i(e)?n.push(this.canonicalizeTileURL(e,r)):n.push(e);return n}_makeAPIURL(t,e){const r="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",i=hn(n.API_URL);if(t.protocol=i.protocol,t.authority=i.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==i.path&&(t.path=`${i.path}${t.path}`),!n.REQUIRE_ACCESS_TOKEN)return pn(t);if(e=e||n.ACCESS_TOKEN,!this._silenceAuthErrors){if(!e)throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`)}return t.params=t.params.filter((t=>-1===t.indexOf("access_token"))),t.params.push(`access_token=${e||""}`),pn(t)}},t.dh=function(t,e){e?In.add(t):In.delete(t);},t.di=$r,t.dj=Mn,t.dk=Sn,t.dl=un,t.dm=bn,t.dn=_n,t.dp=function(t){In.delete(t);},t.dq=An,t.dr=xn,t.ds=Qe,t.dt=e,t.du=function(t,e){Lr=t,Or=e;},t.dv=function(t,e,r=!1){if(No===Lo||No===Oo||No===Fo)throw new Error("setRTLTextPlugin cannot be called multiple times.");jo=Dr.resolveURL(t),No=Lo,Uo=e,$o(),r||Xo();},t.dw=Yo,t.dx=function(){fv().acquire(cv);},t.dy=function(){const t=pv;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(cv),pv=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.dz=hv,t.e=Dr,t.e0=hm,t.e1=p,t.e2=en,t.e3=function(t){let e=0;if(new Uint32Array(t,0,1)[0]!==zv){const r=new Uint32Array(t,0,7),[,,n,i,s,a]=r;e=r.byteLength+i+s+a+s,(n!==t.byteLength||e>=t.byteLength)&&fr("Invalid b3dm header information.");}return Vv(t,e)},t.e4=function(t,e){const r=$v(t);for(const t of r){for(const e of t.meshes)Gv(e);t.lights&&(t.lightMeshIndex=t.meshes.length,t.meshes.push(Yv(t.lights,e)));}return r},t.e5=Qv,t.e6=av,t.e7=Zo,t.e8=function(t){jr(),Fr&&Fr.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.f=Dn,t.g=function(t,e){return tn(er(t,{type:"json"}),e)},t.h=on,t.i=fp,t.j=Ay,t.k=Iy,t.l=function(t){return fetch(t).then((t=>t.arrayBuffer())).then((e=>Vv(e,0,t)))},t.m=class extends qb{},t.n=Ti,t.o=Zn,t.p=ex,t.q=Wa,t.r=Qa,t.s=to,t.t=co,t.u=ul,t.v=cl,t.w=fr,t.x=mo,t.y=ho,t.z=Xs;}));

define(["./shared"],(function(e){function t(e){const t=e?e.url.toString():void 0;return t?performance.getEntriesByName(t):[]}function s(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const o of e)t+=`${s(o)},`;return `${t}]`}let t="{";for(const o of Object.keys(e).sort())t+=`${o}:${s(e[o])},`;return `${t}}`}function o(t){let o="";for(const i of e.cE)o+=`/${s(t[i])}`;return o}class i{constructor(e){this.keyCache={},this._layers={},this._layerConfigs={},e&&this.replace(e);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,s,i){this._options=i;for(const s of t)this._layerConfigs[s.id]=s,(this._layers[s.id]=e.cY(s,this.scope,null,this._options)).compileFilter(),this.keyCache[s.id]&&delete this.keyCache[s.id];for(const e of s)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const s={};for(let i=0;i<e.length;i++){const n=t&&t[e[i].id]||o(e[i]);t&&(t[e[i].id]=n);let r=s[n];r||(r=s[n]=[]),r.push(e[i]);}const i=[];for(const e in s)i.push(s[e]);return i}(e.dG(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),s=t[0];if("none"===s.visibility)continue;const o=s.source||"";let i=this.familiesBySource[o];i||(i=this.familiesBySource[o]={});const n=s.sourceLayer||"_geojsonTileLayer";let r=i[n];r||(r=i[n]=[]),r.push(t);}}}const n=1*e.dJ;class r{constructor(t){const s={},o=[];for(const e in t){const i=t[e],r=s[e]={};for(const e in i.glyphs){const t=i.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const s=t.metrics.localGlyph?n:1,a={x:0,y:0,w:t.bitmap.width+2*s,h:t.bitmap.height+2*s};o.push(a),r[e]=a;}}const{w:i,h:r}=e.j(o),a=new e.dI({width:i||1,height:r||1});for(const o in t){const i=t[o];for(const t in i.glyphs){const r=i.glyphs[+t];if(!r||0===r.bitmap.width||0===r.bitmap.height)continue;const l=s[o][t],c=r.metrics.localGlyph?n:1;e.dI.copy(r.bitmap,a,{x:0,y:0},{x:l.x+c,y:l.y+c},r.bitmap);}}this.image=a,this.positions=s;}}e.dH(r,"GlyphAtlas");class a{constructor(t){this.tileID=new e.aL(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.lut=t.lut,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.scope=t.scope,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.promoteId=t.promoteId,this.isSymbolTile=t.isSymbolTile,this.tileTransform=e.dK(t.tileID.canonical,t.projection),this.projection=t.projection,this.brightness=t.brightness,this.extraShadowCaster=!!t.extraShadowCaster,this.tessellationStep=t.tessellationStep;}parse(t,s,o,i,n){this.status="parsing",this.data=t,this.collisionBoxArray=new e.dL;const a=new e.dM(Object.keys(t.layers).sort()),c=new e.dN(this.tileID,this.promoteId);c.bucketLayerIDs=[];const h={},u=new e.dO(256,256),d={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},lineAtlas:u,availableImages:o,brightness:this.brightness},f=s.familiesBySource[this.source];for(const s in f){const i=t.layers[s];if(!i)continue;let n=!1,r=!1,u=!1;for(const e of f[s])"symbol"===e[0].type?n=!0:r=!0,e[0].is3D()&&"model"!==e[0].type&&(u=!0);if(this.extraShadowCaster&&!u)continue;if(!0===this.isSymbolTile&&!n)continue;if(!1===this.isSymbolTile&&!r)continue;1===i.version&&e.w(`Vector tile source "${this.source}" layer "${s}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const p=a.encode(s),g=[];for(let e=0;e<i.length;e++){const t=i.feature(e),o=c.getId(t,s);g.push({feature:t,id:o,index:e,sourceLayerIndex:p});}for(const e of f[s]){const t=e[0];(!this.extraShadowCaster||t.is3D()&&"model"!==t.type)&&(void 0!==this.isSymbolTile&&"symbol"===t.type!==this.isSymbolTile||t.minzoom&&this.zoom<Math.floor(t.minzoom)||t.maxzoom&&this.zoom>=t.maxzoom||"none"!==t.visibility&&(l(e,this.zoom,d.brightness,o),(h[t.id]=t.createBucket({index:c.bucketLayerIDs.length,layers:e,zoom:this.zoom,lut:this.lut,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:p,sourceID:this.source,projection:this.projection.spec,tessellationStep:this.tessellationStep})).populate(g,d,this.tileID.canonical,this.tileTransform),c.bucketLayerIDs.push(e.map((e=>e.id)))));}}let p,g,m,y;u.trim();const x={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},w=()=>{if(p)return this.status="done",n(p);if(this.extraShadowCaster)this.status="done",n(null,{buckets:e.dG(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:null,glyphAtlasImage:null,lineAtlas:null,imageAtlas:null,brightness:d.brightness,glyphMap:null,iconMap:null,glyphPositions:null});else if(g&&m&&y){const t=new r(g),s=new e.dQ(m,y,this.lut);for(const i in h){const n=h[i];n instanceof e.dR?(l(n.layers,this.zoom,d.brightness,o),e.dS(n,g,t.positions,m,s.iconPositions,this.showCollisionBoxes,o,this.tileID.canonical,this.tileZoom,this.projection,this.brightness)):n.hasPattern&&(n instanceof e.dT||n instanceof e.dU||n instanceof e.b_)&&(l(n.layers,this.zoom,d.brightness,o),n.addFeatures(d,this.tileID.canonical,s.patternPositions,o,this.tileTransform,this.brightness));}this.status="done",n(null,{buckets:e.dG(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,lineAtlas:u,imageAtlas:s,brightness:d.brightness});}};if(!this.extraShadowCaster){const t=e.dP(d.glyphDependencies,(e=>Object.keys(e).map(Number)));Object.keys(t).length?i.send("getGlyphs",{uid:this.uid,stacks:t,scope:this.scope},((e,t)=>{p||(p=e,g=t,w());}),void 0,!1,x):g={};const s=Object.keys(d.iconDependencies);s.length?i.send("getImages",{icons:s,source:this.source,scope:this.scope,tileID:this.tileID,type:"icons"},((e,t)=>{p||(p=e,m=t,w());}),void 0,!1,x):m={};const o=Object.keys(d.patternDependencies);o.length?i.send("getImages",{icons:o,source:this.source,scope:this.scope,tileID:this.tileID,type:"patterns"},((e,t)=>{p||(p=e,y=t,w());}),void 0,!1,x):y={};}w();}}function l(t,s,o,i){const n=new e.X(s,{brightness:o});for(const e of t)e.recalculate(n,i);}class c extends e.E{constructor(t,s,o,i,n,r){super(),this.actor=t,this.layerIndex=s,this.availableImages=o,this.loadVectorData=n||e.ap,this.loading={},this.loaded={},this.deduped=new e.ao(t.scheduler),this.isSpriteLoaded=i,this.scheduler=t.scheduler,this.brightness=r;}loadTile(s,o){const i=s.uid,n=s&&s.request,r=n&&n.collectResourceTiming,l=this.loading[i]=new a(s);l.abort=this.loadVectorData(s,((a,c)=>{const h=!this.loading[i];if(delete this.loading[i],h||a||!c)return l.status="done",h||(this.loaded[i]=l),o(a);const u=c.rawData,d={};c.expires&&(d.expires=c.expires),c.cacheControl&&(d.cacheControl=c.cacheControl),l.vectorTile=c.vectorTile||new e.dV(new e.dW(u));const f=()=>{l.parse(l.vectorTile,this.layerIndex,this.availableImages,this.actor,((s,i)=>{if(s||!i)return o(s);const a={};if(r){const e=t(n);e.length>0&&(a.resourceTiming=JSON.parse(JSON.stringify(e)));}o(null,e.W({rawTileData:u.slice(0)},i,d,a));}));};this.isSpriteLoaded?f():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(f,{type:"parseTile",isSymbolTile:s.isSymbolTile,zoom:s.tileZoom}):f();})),this.loaded=this.loaded||{},this.loaded[i]=l;}));}reloadTile(t,s){const o=this.loaded,i=t.uid;if(o&&o[i]){const n=o[i];n.showCollisionBoxes=t.showCollisionBoxes,n.projection=t.projection,n.brightness=t.brightness,n.tileTransform=e.dK(t.tileID.canonical,t.projection),n.extraShadowCaster=t.extraShadowCaster,n.lut=t.lut;const r=(e,t)=>{const o=n.reloadCallback;o&&(delete n.reloadCallback,n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,o)),s(e,t);};"parsing"===n.status?n.reloadCallback=r:"done"===n.status&&(n.vectorTile?n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,r):r());}else s(null,void 0);}abortTile(e,t){const s=e.uid,o=this.loading[s];o&&(o.abort&&o.abort(),delete this.loading[s]),t();}removeTile(e,t){const s=this.loaded,o=e.uid;s&&s[o]&&delete s[o],t();}}class h{loadTile(t,s){const{uid:o,encoding:i,rawImageData:n,padding:r}=t,a=ImageBitmap&&n instanceof ImageBitmap?this.getImageData(n,r):n;s(null,new e.dX(o,a,i,r<1));}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const s=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),s}}class u{decodeRasterArray({task:t,buffer:s},o){e.dY.performDecoding(s,t).then((e=>{o(null,e);}),(e=>{o(e);}));}}const d=e.dZ.prototype.toGeoJSON;let f=class{constructor(t){this._feature=t,this.extent=e.a3,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const s of this._feature.geometry)t.push([new e.P(s[0],s[1])]);return t}{const t=[];for(const s of this._feature.geometry){const o=[];for(const t of s)o.push(new e.P(t[0],t[1]));t.push(o);}return t}}toGeoJSON(e,t,s){return d.call(this,e,t,s)}},p=class{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.a3,this.length=t.length,this._features=t;}feature(e){return new f(this._features[e])}};const g=64/4096;class m{constructor(){this.features=new Map;}clear(){this.features.clear();}load(e=[],t){for(const s of e){const e=s.id;if(null==e)continue;let o=this.features.get(e);o&&this.updateCache(o,t),s.geometry?(o=x(s),this.updateCache(o,t),this.features.set(e,o)):this.features.delete(e),this.updateCache(o,t);}}updateCache(e,t){for(const{canonical:s,uid:o}of Object.values(t)){const{z:i,x:n,y:r}=s;y(e,Math.pow(2,i),n,r)&&delete t[o];}}getTile(e,t,s){const o=Math.pow(2,e),i=[];for(const e of this.features.values())y(e,o,t,s)&&i.push(v(e,o,t,s));return {features:i}}getFeatures(){return [...this.features.values()]}}function y({minX:e,minY:t,maxX:s,maxY:o},i,n,r){return e<(n+1+g)/i&&t<(r+1+g)/i&&s>(n-g)/i&&o>(r-g)/i}function x(e){const{id:t,geometry:s,properties:o}=e;if(!s)return;if("GeometryCollection"===s.type)throw new Error("GeometryCollection not supported in dynamic mode.");const{type:i,coordinates:n}=s,r={id:t,type:1,geometry:[],tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0},a=r.geometry;if("Point"===i)w(n,a,r);else if("MultiPoint"===i)for(const e of n)w(e,a,r);else if("LineString"===i)r.type=2,S(n,a,r);else if("MultiLineString"===i)r.type=2,b(n,a,r);else if("Polygon"===i)r.type=3,b(n,a,r,!0);else {if("MultiPolygon"!==i)throw new Error("Input data is not a valid GeoJSON object.");r.type=3;for(const e of n)b(e,a,r,!0);}return r}function w([t,s],o,i){const n=e.aj(t);let r=e.ak(s);r=r<0?0:r>1?1:r,o.push(n,r),i.minX=Math.min(i.minX,n),i.minY=Math.min(i.minY,r),i.maxX=Math.max(i.maxX,n),i.maxY=Math.max(i.maxY,r);}function S(e,t,s,o=!1,i=!1){const n=[];for(const t of e)w(t,n,s);t.push(n),o&&function(e,t){let s=0;for(let t=0,o=e.length,i=o-2;t<o;i=t,t+=2)s+=(e[t]-e[i])*(e[t+1]+e[i+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const o=e[t],i=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=o,e[s-1-t]=i;}}(n,i);}function b(e,t,s,o=!1){for(let i=0;i<e.length;i++)S(e[i],t,s,o,0===i);}function v(e,t,s,o){const{id:i,type:n,geometry:r,tags:a}=e,l=[];if(1===n)I(r,t,s,o,l);else for(const e of r)l.push(I(e,t,s,o));return {id:i,type:n,geometry:l,tags:a}}function I(e,t,s,o,i=[]){for(let n=0;n<e.length;n+=2)i.push(M(e[n],e[n+1],t,s,o));return i}function M(t,s,o,i,n){return [Math.round(e.a3*(t*o-i)),Math.round(e.a3*(s*o-n))]}var k={exports:{}},T=e.d$,P=e.d_.VectorTileFeature,C=_;function _(e,t){this.options=t||{},this.features=e,this.length=e.length;}function L(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}_.prototype.feature=function(e){return new L(this.features[e],this.options.extent)},L.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var s=e[t],o=[],i=0;i<s.length;i++)o.push(new T(s[i][0],s[i][1]));this.geometry.push(o);}return this.geometry},L.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,s=-1/0,o=1/0,i=-1/0,n=0;n<e.length;n++)for(var r=e[n],a=0;a<r.length;a++){var l=r[a];t=Math.min(t,l.x),s=Math.max(s,l.x),o=Math.min(o,l.y),i=Math.max(i,l.y);}return [t,o,s,i]},L.prototype.toGeoJSON=P.prototype.toGeoJSON;var D=e.e0,j=C;function O(e){var t=new D;return function(e,t){for(var s in e.layers)t.writeMessage(3,z,e.layers[s]);}(e,t),t.finish()}function z(e,t){var s;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var o={keys:[],values:[],keycache:{},valuecache:{}};for(s=0;s<e.length;s++)o.feature=e.feature(s),t.writeMessage(2,Z,o);var i=o.keys;for(s=0;s<i.length;s++)t.writeStringField(3,i[s]);var n=o.values;for(s=0;s<n.length;s++)t.writeMessage(4,Y,n[s]);}function Z(e,t){var s=e.feature;void 0!==s.id&&t.writeVarintField(1,s.id),t.writeMessage(2,E,e),t.writeVarintField(3,s.type),t.writeMessage(4,X,s);}function E(e,t){var s=e.feature,o=e.keys,i=e.values,n=e.keycache,r=e.valuecache;for(var a in s.properties){var l=s.properties[a],c=n[a];if(null!==l){void 0===c&&(o.push(a),n[a]=c=o.length-1),t.writeVarint(c);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var u=h+":"+l,d=r[u];void 0===d&&(i.push(l),r[u]=d=i.length-1),t.writeVarint(d);}}}function A(e,t){return (t<<3)+(7&e)}function N(e){return e<<1^e>>31}function X(e,t){for(var s=e.loadGeometry(),o=e.type,i=0,n=0,r=s.length,a=0;a<r;a++){var l=s[a],c=1;1===o&&(c=l.length),t.writeVarint(A(1,c));for(var h=3===o?l.length-1:l.length,u=0;u<h;u++){1===u&&1!==o&&t.writeVarint(A(2,h-1));var d=l[u].x-i,f=l[u].y-n;t.writeVarint(N(d)),t.writeVarint(N(f)),i+=d,n+=f;}3===o&&t.writeVarint(A(7,1));}}function Y(e,t){var s=typeof e;"string"===s?t.writeStringField(1,e):"boolean"===s?t.writeBooleanField(7,e):"number"===s&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}k.exports=O,k.exports.fromVectorTileJs=O,k.exports.fromGeojsonVt=function(e,t){t=t||{};var s={};for(var o in e)s[o]=new j(e[o].features,t),s[o].name=o,s[o].version=t.version,s[o].extent=t.extent;return O({layers:s})},k.exports.GeoJSONWrapper=j;var F=e.e1(k.exports);const G={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},J=Math.fround||(W=new Float32Array(1),e=>(W[0]=+e,W[0]));var W;const B=3,R=5,V=6;class ${constructor(e){this.options=Object.assign(Object.create(G),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:s,maxZoom:o}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;const n=[];for(let t=0;t<e.length;t++){const s=e[t];if(!s.geometry)continue;const[o,i]=s.geometry.coordinates,r=J(K(o)),a=J(H(i));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[o+1]=this._createTree(n);t&&console.timeEnd(i);for(let e=o;e>=s;e--){const s=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-s);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let s=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let i=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)s=-180,i=180;else if(s>i){const e=this.getClusters([s,o,180,n],t),r=this.getClusters([-180,o,i,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(K(s),H(n),K(i),H(o)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+R]>1?U(l,t,this.clusterProps):this.points[l[t+B]]);}return c}getChildren(e){const t=this._getOriginId(e),s=this._getOriginZoom(e),o="No cluster with the specified id.",i=this.trees[s];if(!i)throw new Error(o);const n=i.data;if(t*this.stride>=n.length)throw new Error(o);const r=this.options.radius/(this.options.extent*Math.pow(2,s-1)),a=i.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const s=t*this.stride;n[s+4]===e&&l.push(n[s+R]>1?U(n,s,this.clusterProps):this.points[n[s+B]]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,s){const o=[];return this._appendLeaves(o,e,t=t||10,s=s||0,0),o}getTile(e,t,s){const o=this.trees[this._limitZoom(e)],i=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(s-a)/i,c=(s+1+a)/i,h={features:[]};return this._addTileFeatures(o.range((t-a)/i,l,(t+1+a)/i,c),o.data,t,s,i,h),0===t&&this._addTileFeatures(o.range(1-a/i,l,1,c),o.data,i,s,i,h),t===i-1&&this._addTileFeatures(o.range(0,l,a/i,c),o.data,-1,s,i,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const s=this.getChildren(e);if(t++,1!==s.length)break;e=s[0].properties.cluster_id;}return t}_appendLeaves(e,t,s,o,i){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?i+n.point_count<=o?i+=n.point_count:i=this._appendLeaves(e,n.cluster_id,s,o,i):i<o?i++:e.push(t),e.length===s)break}return i}_createTree(t){const s=new e.cK(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)s.add(t[e],t[e+1]);return s.finish(),s.data=t,s}_addTileFeatures(e,t,s,o,i,n){for(const r of e){const e=r*this.stride,a=t[e+R]>1;let l,c,h;if(a)l=q(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const s=this.points[t[e+B]];l=s.properties;const[o,i]=s.geometry.coordinates;c=K(o),h=H(i);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*i-s)),Math.round(this.options.extent*(h*i-o))]],tags:l};let d;d=a||this.options.generateId?t[e+B]:this.points[t[e+B]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:s,extent:o,reduce:i,minPoints:n}=this.options,r=s/(o*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let s=0;s<a.length;s+=c){if(a[s+2]<=t)continue;a[s+2]=t;const o=a[s],h=a[s+1],u=e.within(a[s],a[s+1],r),d=a[s+R];let f=d;for(const e of u){const s=e*c;a[s+2]>t&&(f+=a[s+R]);}if(f>d&&f>=n){let e,n=o*d,r=h*d,p=-1;const g=(s/c<<5)+(t+1)+this.points.length;for(const o of u){const l=o*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+R];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=g,i&&(e||(e=this._map(a,s,!0),p=this.clusterProps.length,this.clusterProps.push(e)),i(e,this._map(a,l)));}a[s+4]=g,l.push(n/f,r/f,1/0,g,-1,f),i&&l.push(p);}else {for(let e=0;e<c;e++)l.push(a[s+e]);if(f>1)for(const e of u){const s=e*c;if(!(a[s+2]<=t)){a[s+2]=t;for(let e=0;e<c;e++)l.push(a[s+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,s){if(e[t+R]>1){const o=this.clusterProps[e[t+V]];return s?Object.assign({},o):o}const o=this.points[e[t+B]].properties,i=this.options.map(o);return s&&i===o?Object.assign({},i):i}}function U(e,t,s){return {type:"Feature",id:e[t+B],properties:q(e,t,s),geometry:{type:"Point",coordinates:[(o=e[t],360*(o-.5)),Q(e[t+1])]}};var o;}function q(e,t,s){const o=e[t+R],i=o>=1e4?`${Math.round(o/1e3)}k`:o>=1e3?Math.round(o/100)/10+"k":o,n=e[t+V],r=-1===n?{}:Object.assign({},s[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+B],point_count:o,point_count_abbreviated:i})}function K(e){return e/360+.5}function H(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function Q(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function ee(e,t,s,o){let i=o;const n=t+(s-t>>1);let r,a=s-t;const l=e[t],c=e[t+1],h=e[s],u=e[s+1];for(let o=t+3;o<s;o+=3){const t=te(e[o],e[o+1],l,c,h,u);if(t>i)r=o,i=t;else if(t===i){const e=Math.abs(o-n);e<a&&(r=o,a=e);}}i>o&&(r-t>3&&ee(e,t,r,o),e[r+2]=i,s-r>3&&ee(e,r,s,o));}function te(e,t,s,o,i,n){let r=i-s,a=n-o;if(0!==r||0!==a){const l=((e-s)*r+(t-o)*a)/(r*r+a*a);l>1?(s=i,o=n):l>0&&(s+=r*l,o+=a*l);}return r=e-s,a=t-o,r*r+a*a}function se(e,t,s,o){const i={id:e??null,type:t,geometry:s,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)oe(i,s);else if("Polygon"===t)oe(i,s[0]);else if("MultiLineString"===t)for(const e of s)oe(i,e);else if("MultiPolygon"===t)for(const e of s)oe(i,e[0]);return i}function oe(e,t){for(let s=0;s<t.length;s+=3)e.minX=Math.min(e.minX,t[s]),e.minY=Math.min(e.minY,t[s+1]),e.maxX=Math.max(e.maxX,t[s]),e.maxY=Math.max(e.maxY,t[s+1]);}function ie(e,t,s,o){if(!t.geometry)return;const i=t.geometry.coordinates;if(i&&0===i.length)return;const n=t.geometry.type,r=Math.pow(s.tolerance/((1<<s.maxZoom)*s.extent),2);let a=[],l=t.id;if(s.promoteId?l=t.properties[s.promoteId]:s.generateId&&(l=o||0),"Point"===n)ne(i,a);else if("MultiPoint"===n)for(const e of i)ne(e,a);else if("LineString"===n)re(i,a,r,!1);else if("MultiLineString"===n){if(s.lineMetrics){for(const s of i)a=[],re(s,a,r,!1),e.push(se(l,"LineString",a,t.properties));return}ae(i,a,r,!1);}else if("Polygon"===n)ae(i,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const i of t.geometry.geometries)ie(e,{id:l,geometry:i,properties:t.properties},s,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of i){const t=[];ae(e,t,r,!0),a.push(t);}}e.push(se(l,n,a,t.properties));}function ne(e,t){t.push(le(e[0]),ce(e[1]),0);}function re(e,t,s,o){let i,n,r=0;for(let s=0;s<e.length;s++){const a=le(e[s][0]),l=ce(e[s][1]);t.push(a,l,0),s>0&&(r+=o?(i*l-a*n)/2:Math.sqrt(Math.pow(a-i,2)+Math.pow(l-n,2))),i=a,n=l;}const a=t.length-3;t[2]=1,ee(t,0,a,s),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function ae(e,t,s,o){for(let i=0;i<e.length;i++){const n=[];re(e[i],n,s,o),t.push(n);}}function le(e){return e/360+.5}function ce(e){const t=Math.sin(e*Math.PI/180),s=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return s<0?0:s>1?1:s}function he(e,t,s,o,i,n,r,a){if(o/=t,n>=(s/=t)&&r<o)return e;if(r<s||n>=o)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===i?t.minX:t.minY,c=0===i?t.maxX:t.maxY;if(r>=s&&c<o){l.push(t);continue}if(c<s||r>=o)continue;let h=[];if("Point"===n||"MultiPoint"===n)ue(e,h,s,o,i);else if("LineString"===n)de(e,h,s,o,i,!1,a.lineMetrics);else if("MultiLineString"===n)pe(e,h,s,o,i,!1);else if("Polygon"===n)pe(e,h,s,o,i,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];pe(t,e,s,o,i,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(se(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(se(t.id,n,h,t.tags));}}return l.length?l:null}function ue(e,t,s,o,i){for(let n=0;n<e.length;n+=3){const r=e[n+i];r>=s&&r<=o&&ge(t,e[n],e[n+1],e[n+2]);}}function de(e,t,s,o,i,n,r){let a=fe(e);const l=0===i?me:ye;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],p=e[d+1],g=e[d+2],m=e[d+3],y=e[d+4],x=0===i?f:p,w=0===i?m:y;let S=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(p-y,2))),x<s?w>s&&(h=l(a,f,p,m,y,s),r&&(a.start=u+c*h)):x>o?w<o&&(h=l(a,f,p,m,y,o),r&&(a.start=u+c*h)):ge(a,f,p,g),w<s&&x>=s&&(h=l(a,f,p,m,y,s),S=!0),w>o&&x<=o&&(h=l(a,f,p,m,y,o),S=!0),!n&&S&&(r&&(a.end=u+c*h),t.push(a),a=fe(e)),r&&(u+=c);}let d=e.length-3;const f=e[d],p=e[d+1],g=0===i?f:p;g>=s&&g<=o&&ge(a,f,p,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&ge(a,a[0],a[1],a[2]),a.length&&t.push(a);}function fe(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function pe(e,t,s,o,i,n){for(const r of e)de(r,t,s,o,i,n,!1);}function ge(e,t,s,o){e.push(t,s,o);}function me(e,t,s,o,i,n){const r=(n-t)/(o-t);return ge(e,n,s+(i-s)*r,1),r}function ye(e,t,s,o,i,n){const r=(n-s)/(i-s);return ge(e,t+(o-t)*r,n,1),r}function xe(e,t){const s=[];for(let o=0;o<e.length;o++){const i=e[o],n=i.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=we(i.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of i.geometry)r.push(we(e,t));}else if("MultiPolygon"===n){r=[];for(const e of i.geometry){const s=[];for(const o of e)s.push(we(o,t));r.push(s);}}s.push(se(i.id,n,r,i.tags));}return s}function we(e,t){const s=[];s.size=e.size,void 0!==e.start&&(s.start=e.start,s.end=e.end);for(let o=0;o<e.length;o+=3)s.push(e[o]+t,e[o+1],e[o+2]);return s}function Se(e,t){if(e.transformed)return e;const s=1<<e.z,o=e.x,i=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(be(e[r],e[r+1],t,s,o,i));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(be(e[r][n],e[r][n+1],t,s,o,i));n.geometry.push(a);}}return e.transformed=!0,e}function be(e,t,s,o,i,n){return [Math.round(s*(e*o-i)),Math.round(s*(t*o-n))]}function ve(e,t,s,o,i){const n=t===i.maxZoom?0:i.tolerance/((1<<t)*i.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:s,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)Ie(r,t,n,i);return r}function Ie(e,t,s,o){const i=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<i.length;t+=3)r.push(i[t],i[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)Me(r,i,e,s,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<i.length;t++)Me(r,i[t],e,s,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<i.length;t++){const o=i[t];for(let t=0;t<o.length;t++)Me(r,o[t],e,s,!0,0===t);}if(r.length){let s=t.tags||null;if("LineString"===n&&o.lineMetrics){s={};for(const e in t.tags)s[e]=t.tags[e];s.mapbox_clip_start=i.start/i.size,s.mapbox_clip_end=i.end/i.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:s};null!==t.id&&(a.id=t.id),e.features.push(a);}}function Me(e,t,s,o,i,n){const r=o*o;if(o>0&&t.size<(i?r:o))return void(s.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===o||t[e+2]>r)&&(s.numSimplified++,a.push(t[e],t[e+1])),s.numPoints++;i&&function(e,t){let s=0;for(let t=0,o=e.length,i=o-2;t<o;i=t,t+=2)s+=(e[t]-e[i])*(e[t+1]+e[i+1]);if(s>0===t)for(let t=0,s=e.length;t<s/2;t+=2){const o=e[t],i=e[t+1];e[t]=e[s-2-t],e[t+1]=e[s-1-t],e[s-2-t]=o,e[s-1-t]=i;}}(a,n),e.push(a);}const ke={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class Te{constructor(e,t){const s=(t=this.options=function(e,t){for(const s in t)e[s]=t[s];return e}(Object.create(ke),t)).debug;if(s&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let o=function(e,t){const s=[];if("FeatureCollection"===e.type)for(let o=0;o<e.features.length;o++)ie(s,e.features[o],t,o);else ie(s,"Feature"===e.type?e:{geometry:e},t);return s}(e,t);this.tiles={},this.tileCoords=[],s&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=function(e,t){const s=t.buffer/t.extent;let o=e;const i=he(e,1,-1-s,s,0,-1,2,t),n=he(e,1,1-s,2+s,0,-1,2,t);return (i||n)&&(o=he(e,1,-s,1+s,0,-1,2,t)||[],i&&(o=xe(i,1).concat(o)),n&&(o=o.concat(xe(n,-1)))),o}(o,t),o.length&&this.splitTile(o,0,0,0),s&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,s,o,i,n,r){const a=[e,t,s,o],l=this.options,c=l.debug;for(;a.length;){o=a.pop(),s=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=Pe(t,s,o);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=ve(e,t,s,o,l),this.tileCoords.push({z:t,x:s,y:o}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,s,o,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==i){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===i)continue;if(null!=i){const e=i-t;if(s!==n>>e||o!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,p=.5-f,g=.5+f,m=1+f;let y=null,x=null,w=null,S=null,b=he(e,h,s-f,s+g,0,d.minX,d.maxX,l),v=he(e,h,s+p,s+m,0,d.minX,d.maxX,l);e=null,b&&(y=he(b,h,o-f,o+g,1,d.minY,d.maxY,l),x=he(b,h,o+p,o+m,1,d.minY,d.maxY,l),b=null),v&&(w=he(v,h,o-f,o+g,1,d.minY,d.maxY,l),S=he(v,h,o+p,o+m,1,d.minY,d.maxY,l),v=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*s,2*o),a.push(x||[],t+1,2*s,2*o+1),a.push(w||[],t+1,2*s+1,2*o),a.push(S||[],t+1,2*s+1,2*o+1);}}getTile(e,t,s){e=+e,t=+t,s=+s;const o=this.options,{extent:i,debug:n}=o;if(e<0||e>24)return null;const r=1<<e,a=Pe(e,t=t+r&r-1,s);if(this.tiles[a])return Se(this.tiles[a],i);n>1&&console.log("drilling down to z%d-%d-%d",e,t,s);let l,c=e,h=t,u=s;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[Pe(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,s),n>1&&console.timeEnd("drilling down"),this.tiles[a]?Se(this.tiles[a],i):null):null}}function Pe(e,t,s){return 32*((1<<e)*s+t)+e}function Ce(e,t){const s=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const o=this._geoJSONIndex.getTile(s.z,s.x,s.y);if(!o)return t(null,null);const i=new p(o.features);let n=F(i);0===n.byteOffset&&n.byteLength===n.buffer.byteLength||(n=new Uint8Array(n)),t(null,{vectorTile:i,rawData:n.buffer});}class _e extends c{constructor(e,t,s,o,i,n){super(e,t,s,o,Ce,n),i&&(this.loadGeoJSON=i),this._dynamicIndex=new m;}loadData(s,o){const i=s&&s.request,n=i&&i.collectResourceTiming;this.loadGeoJSON(s,((r,a)=>{if(r||!a)return o(r);if("object"!=typeof a)return o(new Error(`Input data given to '${s.source}' is not a valid GeoJSON object.`));{try{if(s.filter){const t=e.y(s.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a.features=a.features.filter((e=>t.value.evaluate({zoom:0},e)));}s.dynamic?("Feature"===a.type&&(a={type:"FeatureCollection",features:[a]}),s.append||(this._dynamicIndex.clear(),this.loaded={}),this._dynamicIndex.load(a.features,this.loaded),s.cluster&&(a.features=this._dynamicIndex.getFeatures())):this.loaded={},this._geoJSONIndex=s.cluster?new $(function({superclusterOptions:t,clusterProperties:s}){if(!s||!t)return t;const o={},i={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(s);for(const t of a){const[n,r]=s[t],a=e.y(r),l=e.y("string"==typeof n?[n,["accumulated"],["get",t]]:n);o[t]=a.value,i[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=i[t].evaluate(n,r);},t}(s)).load(a.features):s.dynamic?this._dynamicIndex:function(e,t){return new Te(e,t)}(a,s.geojsonVtOptions);}catch(e){return o(e)}const r={};if(n){const e=t(i);e&&(r.resourceTiming={},r.resourceTiming[s.source]=JSON.parse(JSON.stringify(e)));}o(null,r);}}));}reloadTile(e,t){const s=this.loaded;return s&&s[e.uid]?e.partial?t(null,void 0):super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,s){if(t.request)e.g(t.request,s);else {if("string"!=typeof t.data)return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return s(null,JSON.parse(t.data))}catch(e){return s(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class Le{constructor(t,s){this.tileID=new e.aL(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.projection=t.projection,this.brightness=s;}parse(t,s,o,i){this.status="parsing";const n=new e.aL(o.tileID.overscaledZ,o.tileID.wrap,o.tileID.canonical.z,o.tileID.canonical.x,o.tileID.canonical.y),r={},a=s.familiesBySource[o.source],l=new e.dN(n,o.promoteId);return l.bucketLayerIDs=[],l.is3DTile=!0,e.e3(t).then((t=>{if(!t)return i(new Error("Could not parse tile"));const s=e.e4(t,1/e.b5(o.tileID.canonical)),c=t.json.extensionsUsed&&t.json.extensionsUsed.includes("MAPBOX_mesh_features")||t.json.asset.extras&&t.json.asset.extras.MAPBOX_mesh_features,h=t.json.extensionsUsed&&t.json.extensionsUsed.includes("EXT_meshopt_compression"),u=new e.X(this.zoom,{brightness:this.brightness});for(const t in a)for(const o of a[t]){const t=o[0];l.bucketLayerIDs.push(o.map((e=>e.id))),t.recalculate(u,[]);const i=new e.e5(s,n,c,h,this.brightness,l);c||(i.needsUpload=!0),r[t.fqid]=i,i.evaluate(t);}this.status="done",i(null,{buckets:r,featureIndex:l});})).catch((e=>i(new Error(e.message))))}}class De{constructor(e,t,s,o,i,n){this.actor=e,this.layerIndex=t,this.brightness=n,this.loading={},this.loaded={};}loadTile(t,s){const o=t.uid,i=this.loading[o]=new Le(t,this.brightness);e.e2(t.request,((e,n)=>{const r=!this.loading[o];return delete this.loading[o],r||e?(i.status="done",r||(this.loaded[o]=i),s(e)):n&&0!==n.byteLength?void i.parse(n,this.layerIndex,t,((e,t)=>{i.status="done",this.loaded=this.loaded||{},this.loaded[o]=i,e||!t?s(e):s(null,t);})):(i.status="done",this.loaded[o]=i,s())}));}reloadTile(e,t){const s=this.loaded,o=e.uid;if(s&&s[o]){const i=s[o];i.projection=e.projection,i.brightness=e.brightness;const n=(s,o)=>{i.reloadCallback&&(delete i.reloadCallback,this.loadTile(e,t)),t(s,o);};"parsing"===i.status?i.reloadCallback=n:"done"===i.status&&this.loadTile(e,t);}}abortTile(e,t){const s=e.uid;this.loading[s]&&delete this.loading[s],t();}removeTile(e,t){const s=this.loaded,o=e.uid;s&&s[o]&&delete s[o],t();}}class je{constructor(t){this.self=t,this.actor=new e.e6(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.projections={},this.defaultProjection=e.aJ({name:"mercator"}),this.workerSourceTypes={vector:c,geojson:_e,"batched-model":De},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.e7.isParsed())throw new Error("RTL text plugin already registered.");e.e7.applyArabicShaping=t.applyArabicShaping,e.e7.processBidirectionalText=t.processBidirectionalText,e.e7.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,s){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],delete this.rasterArrayWorkerSource,s();}checkIfReady(e,t,s){s();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,{scope:s,isLoaded:o}){if(this.isSpriteLoaded[t]||(this.isSpriteLoaded[t]={}),this.isSpriteLoaded[t][s]=o,this.workerSources[t]&&this.workerSources[t][s])for(const i in this.workerSources[t][s]){const n=this.workerSources[t][s][i];for(const t in n){const s=n[t];s instanceof c&&(s.isSpriteLoaded=o,s.fire(new e.f("isSpriteLoaded")));}}}setImages(e,{scope:t,images:s},o){if(this.availableImages[e]||(this.availableImages[e]={}),this.availableImages[e][t]=s,this.workerSources[e]&&this.workerSources[e][t]){for(const o in this.workerSources[e][t]){const i=this.workerSources[e][t][o];for(const e in i)i[e].availableImages=s;}o();}else o();}setProjection(t,s){this.projections[t]=e.aJ(s);}setBrightness(e,t,s){this.brightness=t,s();}setLayers(e,t,s){this.getLayerIndex(e,t.scope).replace(t.layers,t.options),s();}updateLayers(e,t,s){this.getLayerIndex(e,t.scope).update(t.layers,t.removedIds,t.options),s();}loadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).loadTile(t,s);}loadDEMTile(e,t,s){this.getDEMWorkerSource(e,t.source,t.scope).loadTile(t,s);}decodeRasterArray(e,t,s){this.getRasterArrayWorkerSource().decodeRasterArray(t,s);}reloadTile(e,t,s){t.projection=this.projections[e]||this.defaultProjection,this.getWorkerSource(e,t.type,t.source,t.scope).reloadTile(t,s);}abortTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).abortTile(t,s);}removeTile(e,t,s){this.getWorkerSource(e,t.type,t.source,t.scope).removeTile(t,s);}removeSource(e,t,s){if(!(this.workerSources[e]&&this.workerSources[e][t.scope]&&this.workerSources[e][t.scope][t.type]&&this.workerSources[e][t.scope][t.type][t.source]))return;const o=this.workerSources[e][t.scope][t.type][t.source];delete this.workerSources[e][t.scope][t.type][t.source],void 0!==o.removeSource?o.removeSource(t,s):s();}loadWorkerSource(e,t,s){try{this.self.importScripts(t.url),s();}catch(e){s(e.toString());}}syncRTLPluginState(t,s,o){try{e.e7.setState(s);const t=e.e7.getPluginURL();if(e.e7.isLoaded()&&!e.e7.isParsed()&&null!=t){this.self.importScripts(t);const s=e.e7.isParsed();o(s?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),s);}}catch(e){o(e.toString());}}setDracoUrl(e,t){this.dracoUrl=t;}getAvailableImages(e,t){this.availableImages[e]||(this.availableImages[e]={});let s=this.availableImages[e][t];return s||(s=[]),s}getLayerIndex(e,t){this.layerIndexes[e]||(this.layerIndexes[e]={});let s=this.layerIndexes[e][t];return s||(s=this.layerIndexes[e][t]=new i,s.scope=t),s}getWorkerSource(e,t,s,o){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][o]||(this.workerSources[e][o]={}),this.workerSources[e][o][t]||(this.workerSources[e][o][t]={}),this.isSpriteLoaded[e]||(this.isSpriteLoaded[e]={}),this.workerSources[e][o][t][s]||(this.workerSources[e][o][t][s]=new this.workerSourceTypes[t]({send:(t,s,o,i,n,r)=>{this.actor.send(t,s,o,e,n,r);},scheduler:this.actor.scheduler},this.getLayerIndex(e,o),this.getAvailableImages(e,o),this.isSpriteLoaded[e][o],void 0,this.brightness)),this.workerSources[e][o][t][s]}getDEMWorkerSource(e,t,s){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][s]||(this.demWorkerSources[e][s]={}),this.demWorkerSources[e][s][t]||(this.demWorkerSources[e][s][t]=new h),this.demWorkerSources[e][s][t]}getRasterArrayWorkerSource(){return this.rasterArrayWorkerSource||(this.rasterArrayWorkerSource=new u),this.rasterArrayWorkerSource}enforceCacheSizeLimit(t,s){e.e8(s);}getWorkerPerformanceMetrics(e,t,s){s(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new je(self)),je}));

define(["./shared"],(function(e){function t(e,i){if(Array.isArray(e)){if(!Array.isArray(i)||e.length!==i.length)return !1;for(let o=0;o<e.length;o++)if(!t(e[o],i[o]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==i){if("object"!=typeof i)return !1;if(Object.keys(e).length!==Object.keys(i).length)return !1;for(const o in e)if(!t(e[o],i[o]))return !1;return !0}return e===i}var i=o;function o(e){return !function(e){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===r[t=e&&e.failIfMajorPerformanceCaveat]&&(r[t]=function(e){var t,i=function(e){var t=document.createElement("canvas"),i=Object.create(o.webGLContextAttributes);return i.failIfMajorPerformanceCaveat=e,t.getContext("webgl2",i)}(e);if(!i)return !1;try{t=i.createShader(i.VERTEX_SHADER);}catch(e){return !1}return !(!t||i.isContextLost())&&(i.shaderSource(t,"void main() {}"),i.compileShader(t),!0===i.getShaderParameter(t,i.COMPILE_STATUS))}(t)),r[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL2 support"):"insufficient Canvas/getImageData support":"insufficient worker support";var t;}(e)}var r={};function a(e,t,i){const o=document.createElement(e);return null!=t&&(o.className=t),i&&i.appendChild(o),o}function n(e,t,i){const o=document.createElementNS("http://www.w3.org/2000/svg",e);for(const e of Object.keys(t))o.setAttributeNS(null,e,String(t[e]));return i&&i.appendChild(o),o}o.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const s="undefined"!=typeof document?document.documentElement&&document.documentElement.style:null,l=s&&void 0!==s.userSelect?"userSelect":"WebkitUserSelect";let c;function h(){s&&l&&(c=s[l],s[l]="none");}function _(){s&&l&&(s[l]=c);}function u(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",u,!0);}function d(){window.addEventListener("click",u,!0),window.setTimeout((()=>{window.removeEventListener("click",u,!0);}),0);}function p(e,t){const i=e.getBoundingClientRect();return g(e,i,t)}function f(e,t){const i=e.getBoundingClientRect(),o=[];for(let r=0;r<t.length;r++)o.push(g(e,i,t[r]));return o}function m(e){return void 0!==window.InstallTrigger&&2===e.button&&e.ctrlKey&&window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:e.button}function g(t,i,o){const r=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.P((o.clientX-i.left)*r,(o.clientY-i.top)*r)}class v{constructor(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps=new Set,this._updatedImages=new Set;}isDirty(){return this._changed}setDirty(){this._changed=!0;}getUpdatedSourceCaches(){return this._updatedSourceCaches}updateSourceCache(e,t){this._updatedSourceCaches[e]=t,this.setDirty();}discardSourceCacheUpdate(e){delete this._updatedSourceCaches[e];}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id),this.setDirty();}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this._updatedPaintProps.delete(e.fqid),this.setDirty();}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id];}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}getUpdatedPaintProperties(){return this._updatedPaintProps}updatePaintProperties(e){this._updatedPaintProps.add(e.fqid),this.setDirty();}getUpdatedImages(){return Array.from(this._updatedImages.values())}updateImage(e){this._updatedImages.add(e),this.setDirty();}resetUpdatedImages(){this._updatedImages.clear();}reset(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSourceCaches={},this._updatedPaintProps.clear(),this._updatedImages.clear();}}const x={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class y{constructor(e,t,i,o,r,a){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=o,this.instanceCount=a,this.context=e;const n=e.gl;this.buffer=n.createBuffer(),e.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||r||t.destroy();}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const o=t.attributes[this.attributes[i].name];void 0!==o&&e.enableVertexAttribArray(o);}}setVertexAttribPointers(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],a=t.attributes[r.name];void 0!==a&&e.vertexAttribPointer(a,r.components,e[x[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}setVertexAttribDivisor(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=t.attributes[this.attributes[o].name];void 0!==r&&this.instanceCount&&this.instanceCount>0&&e.vertexAttribDivisor(r,i);}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class b{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class w extends b{getDefault(){return e.C.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class T extends b{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class E extends b{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class C extends b{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class S extends b{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class I extends b{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class L extends b{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class P extends b{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class A extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class R extends b{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class D extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class M extends b{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class z extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class O extends b{getDefault(){const e=this.gl;return [e.ONE,e.ZERO,e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.blendFuncSeparate(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class F extends b{getDefault(){return e.C.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class B extends b{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquationSeparate(e,e),this.current=e,this.dirty=!1);}}class k extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class N extends b{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class U extends b{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}let G=class extends b{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}};class j extends b{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class V extends b{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class W extends b{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class Z extends b{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class q extends b{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class H extends b{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class $ extends b{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class X extends b{getDefault(){return null}set(e){this.gl&&(e!==this.current||this.dirty)&&(this.gl.bindVertexArray(e),this.current=e,this.dirty=!1);}}class Y extends b{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class K extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class Q extends b{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class J extends b{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class ee extends J{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class te extends J{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class ie extends J{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,this.attachment(),t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class oe extends te{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class re{constructor(e,t,i,o,r){this.context=e,this.width=t,this.height=i;const a=this.framebuffer=e.gl.createFramebuffer();o&&(this.colorAttachment=new ee(e,a)),r&&(this.depthAttachmentType=r,this.depthAttachment="renderbuffer"===r?new te(e,a):new ie(e,a));}destroy(){const e=this.context.gl;if(this.colorAttachment){const t=this.colorAttachment.get();t&&e.deleteTexture(t);}if(this.depthAttachment&&this.depthAttachmentType)if("renderbuffer"===this.depthAttachmentType){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}else {const t=this.depthAttachment.get();t&&e.deleteTexture(t);}e.deleteFramebuffer(this.framebuffer);}}class ae{constructor(e,t){this.gl=e,this.clearColor=new w(this),this.clearDepth=new T(this),this.clearStencil=new E(this),this.colorMask=new C(this),this.depthMask=new S(this),this.stencilMask=new I(this),this.stencilFunc=new L(this),this.stencilOp=new P(this),this.stencilTest=new A(this),this.depthRange=new R(this),this.depthTest=new D(this),this.depthFunc=new M(this),this.blend=new z(this),this.blendFunc=new O(this),this.blendColor=new F(this),this.blendEquation=new B(this),this.cullFace=new k(this),this.cullFaceSide=new N(this),this.frontFace=new U(this),this.program=new G(this),this.activeTexture=new j(this),this.viewport=new V(this),this.bindFramebuffer=new W(this),this.bindRenderbuffer=new Z(this),this.bindTexture=new q(this),this.bindVertexBuffer=new H(this),this.bindElementBuffer=new $(this),this.bindVertexArrayOES=new X(this),this.pixelStoreUnpack=new Y(this),this.pixelStoreUnpackPremultiplyAlpha=new K(this),this.pixelStoreUnpackFlipY=new Q(this),this.options=t?{...t}:{},this.options.extTextureFilterAnisotropicForceOff||(this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT))),this.extDebugRendererInfo=e.getExtension("WEBGL_debug_renderer_info"),this.extDebugRendererInfo&&(this.renderer=e.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL),this.vendor=e.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)),this.options.extTextureFloatLinearForceOff||(this.extTextureFloatLinear=e.getExtension("OES_texture_float_linear")),this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float"),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query_webgl2"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),this.maxPointSize=e.getParameter(e.ALIASED_POINT_SIZE_RANGE)[1];}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArrayOES.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,i,o){return new e.I(this,t,i,o)}createVertexBuffer(e,t,i,o,r){return new y(this,e,t,i,o,r)}createRenderbuffer(e,t,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i,o){return new re(this,e,t,i,o)}clear({color:e,depth:t,stencil:i,colorMask:o}){const r=this.gl;let a=0;e&&(a|=r.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set(o||[!0,!0,!0,!0])),void 0!==t&&(a|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(a|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(a);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(i){t(i.blendFunction,e.a.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(i.blendFunction),this.blendColor.set(i.blendColor),i.blendEquation?this.blendEquation.set(i.blendEquation):this.blendEquation.setDefault()),this.colorMask.set(i.mask);}unbindVAO(){this.bindVertexArrayOES.set(null);}}class ne{constructor(e){this._gl=e.gl,this._query=this._gl.createQuery(),this._isFree=!0;}begin(){this._gl.beginQuery(this._gl.ANY_SAMPLES_PASSED,this._query),this._isFree=!1;}end(){this._gl.endQuery(this._gl.ANY_SAMPLES_PASSED);}isResultAvailable(){return this._gl.getQueryParameter(this._query,this._gl.QUERY_RESULT_AVAILABLE)}consumeResult(){const e=this._gl.getQueryParameter(this._query,this._gl.QUERY_RESULT);return this._isFree=!0,e}isFree(){return this._isFree}destroy(){this._gl.deleteQuery(this._query);}}class se{constructor(e){this.useOcclusionQueries=!0,this.visualizeOcclusions="none",this.occlusionQueryFrameWindow=5,this.occluderSize=32,this.fadeSpeed=7,this.depthOffset=-1e-4,e.registerParameter(this,["Symbols"],"useOcclusionQueries"),e.registerParameter(this,["Symbols"],"visualizeOcclusions",{options:{none:"none",zPass:"zPass",zTest:"zTest"}}),e.registerParameter(this,["Symbols"],"occlusionQueryFrameWindow",{min:1,max:30,step:1}),e.registerParameter(this,["Symbols"],"occluderSize",{min:1,max:100,step:1}),e.registerParameter(this,["Symbols"],"fadeSpeed",{min:.1,max:50,step:.1}),e.registerParameter(this,["Symbols"],"depthOffset",{min:-.001,max:0,step:1e-4});}}class le{constructor(t,i,o,r){const a={width:o[0],height:o[1],data:null},n=t.gl;this.targetColorTexture=new e.T(t,a,n.RGBA,{useMipmap:!1}),this.backgroundColorTexture=new e.T(t,a,n.RGBA,{useMipmap:!1}),this.context=t,this.updateParticleTexture(i,r),this.lastInvalidatedAt=0;}updateParticleTexture(t,i){if(this.particleTextureDimension===i.width)return;(this.particleTexture0||this.particleTexture1||this.particleIndexBuffer||this.particleSegment)&&(this.particleTexture0.destroy(),this.particleTexture1.destroy(),this.particleIndexBuffer.destroy(),this.particleSegment.destroy());const o=this.context.gl,r=i.width*i.height;this.particleTexture0=new e.T(this.context,i,o.RGBA,{premultiply:!1,useMipmap:!1}),this.particleTexture1=new e.T(this.context,i,o.RGBA,{premultiply:!1,useMipmap:!1});const a=new e.S;a.reserve(r);for(let e=0;e<r;e++)a.emplaceBack(e);this.particleIndexBuffer=this.context.createVertexBuffer(a,e.p.members,!0),this.particleSegment=e.b.simpleSegment(0,0,this.particleIndexBuffer.length,0),this.particleTextureDimension=i.width;}update(t){return !(this.lastInvalidatedAt<t&&(this.lastInvalidatedAt=e.e.now(),1))}destroy(){this.targetColorTexture.destroy(),this.backgroundColorTexture.destroy(),this.particleIndexBuffer.destroy(),this.particleTexture0.destroy(),this.particleTexture1.destroy(),this.particleSegment.destroy();}}class ce extends e.E{constructor(e){super(),this.requestManager=e,this.models={"":{}},this.numModelsLoading={};}loadModel(t,i){return e.l(this.requestManager.transformRequest(i,e.R.Model).url).then((i=>{if(!i)return;const o=e.c(i),r=new e.M(t,void 0,void 0,o);return r.computeBoundsAndApplyParent(),r})).catch((o=>{if(o&&404===o.status)return null;this.fire(new e.d(new Error(`Could not load model ${t} from ${i}: ${o.message}`)));}))}load(t,i){this.models[i]||(this.models[i]={});const o=Object.keys(t);this.numModelsLoading[i]=(this.numModelsLoading[i]||0)+o.length;const r=[];for(const e of o)r.push(this.loadModel(e,t[e]));Promise.allSettled(r).then((t=>{for(let e=0;e<t.length;e++){const{status:r,value:a}=t[e];"fulfilled"===r&&a&&(this.models[i][o[e]]={model:a,numReferences:1});}this.numModelsLoading[i]-=o.length,this.fire(new e.f("data",{dataType:"style"}));})).catch((t=>{this.fire(new e.d(new Error(`Could not load models: ${t.message}`)));}));}isLoaded(){for(const e in this.numModelsLoading)if(this.numModelsLoading[e]>0)return !1;return !0}hasModel(e,t){return !!this.getModel(e,t)}getModel(e,t){return this.models[t]||(this.models[t]={}),this.models[t][e]?this.models[t][e].model:void 0}addModel(e,t,i){this.models[i]||(this.models[i]={}),this.hasModel(e,i)&&this.models[i][e].numReferences++,this.load({[e]:this.requestManager.normalizeModelURL(t)},i);}addModels(e,t){this.models[t]||(this.models[t]={});const i={};for(const o in e)this.models[t][o]={},i[o]=this.requestManager.normalizeModelURL(e[o]);this.load(i,t);}addModelsFromBucket(e,t){this.models[t]||(this.models[t]={});const i={};for(const o of e)this.hasModel(o,t)?this.models[t][o].numReferences++:i[o]=this.requestManager.normalizeModelURL(o);this.load(i,t);}removeModel(e,t){if(this.models[t]&&this.models[t][e]&&(this.models[t][e].numReferences--,0===this.models[t][e].numReferences)){const i=this.models[t][e].model;delete this.models[t][e],i.destroy();}}listModels(e){return this.models[e]||(this.models[e]={}),Object.keys(this.models[e])}upload(e,t){this.models[t]||(this.models[t]={});for(const i in this.models[t])this.models[t][i].model&&this.models[t][i].model.upload(e.context);}}function he(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class _e extends e.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded={},this.requestors=[],this.patterns={},this.atlasImage={},this.atlasTexture={},this.dirty=!0;}createScope(t){this.images[t]={},this.loaded[t]=!1,this.updatedImages[t]={},this.patterns[t]={},this.callbackDispatchedThisFrame[t]={},this.atlasImage[t]=new e.i({width:1,height:1});}isLoaded(){for(const e in this.loaded)if(!this.loaded[e])return !1;return !0}setLoaded(e,t){if(this.loaded[t]!==e&&(this.loaded[t]=e,e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[];}}hasImage(e,t){return !!this.getImage(e,t)}getImage(e,t){return this.images[t][e]}addImage(e,t,i){this._validate(e,i)&&(this.images[t][e]=i);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.d(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.d(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.d(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){return !(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t,i){i.version=this.images[t][e].version+1,this.images[t][e]=i,this.updatedImages[t][e]=!0;}removeImage(e,t){const i=this.images[t][e];delete this.images[t][e],delete this.patterns[t][e],i.userImage&&i.userImage.onRemove&&i.userImage.onRemove();}listImages(e){return Object.keys(this.images[e])}getImages(e,t,i){let o=!0;const r=!!this.loaded[t];if(!r)for(const i of e)this.images[t][i]||(o=!1);r||o?this._notify(e,t,i):this.requestors.push({ids:e,scope:t,callback:i});}getUpdatedImages(e){return this.updatedImages[e]}_notify(t,i,o){const r={};for(const o of t){this.images[i][o]||this.fire(new e.f("styleimagemissing",{id:o}));const t=this.images[i][o];t?r[o]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.w(`Image "${o}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}o(null,r);}getPixelSize(e){const{width:t,height:i}=this.atlasImage[e];return {width:t,height:i}}getPattern(t,i,o){const r=this.patterns[i][t],a=this.getImage(t,i);if(!a)return null;if(r&&r.position.version===a.version)return r.position;if(r)r.position.version=a.version;else {const o={w:a.data.width+2,h:a.data.height+2,x:0,y:0},r=new e.k(o,a);this.patterns[i][t]={bin:o,position:r};}return this._updatePatternAtlas(i,o),this.patterns[i][t].position}bind(t,i){const o=t.gl;let r=this.atlasTexture[i];r?this.dirty&&(r.update(this.atlasImage[i]),this.dirty=!1):(r=new e.T(t,this.atlasImage[i],o.RGBA),this.atlasTexture[i]=r),r.bind(o.LINEAR,o.CLAMP_TO_EDGE);}_updatePatternAtlas(t,i){const o=[];for(const e in this.patterns[t])o.push(this.patterns[t][e].bin);const{w:r,h:a}=e.j(o),n=this.atlasImage[t];n.resize({width:r||1,height:a||1});for(const o in this.patterns[t]){const{bin:r}=this.patterns[t][o],a=r.x+1,s=r.y+1,l=this.images[t][o].data,c=l.width,h=l.height;e.i.copy(l,n,{x:0,y:0},{x:a,y:s},{width:c,height:h},i),e.i.copy(l,n,{x:0,y:h-1},{x:a,y:s-1},{width:c,height:1},i),e.i.copy(l,n,{x:0,y:0},{x:a,y:s+h},{width:c,height:1},i),e.i.copy(l,n,{x:c-1,y:0},{x:a-1,y:s},{width:1,height:h},i),e.i.copy(l,n,{x:0,y:0},{x:a+c,y:s},{width:1,height:h},i);}this.dirty=!0;}beginFrame(){for(const e in this.images)this.callbackDispatchedThisFrame[e]={};}dispatchRenderCallbacks(e,t){for(const i of e){if(this.callbackDispatchedThisFrame[t][i])continue;this.callbackDispatchedThisFrame[t][i]=!0;const e=this.images[t][i];he(e)&&this.updateImage(i,t,e);}}}function ue(t){const i=t.key,o=t.value,r=t.valueSpec||{},a=t.objectElementValidators||{},n=t.style,s=t.styleSpec;let l=[];const c=e.n(o);if("object"!==c)return [new e.V(i,o,`object expected, ${c} found`)];for(const t in o){const c=t.split(".")[0];let h;a[c]?h=a[c]:r[c]?h=ze:a["*"]?h=a["*"]:r["*"]&&(h=ze),h?l=l.concat(h({key:(i?`${i}.`:i)+t,value:o[t],valueSpec:r[c]||r["*"],style:n,styleSpec:s,object:o,objectKey:t},o)):l.push(new e.m(i,o[t],`unknown property "${t}"`));}for(const t in r)a[t]||r[t].required&&void 0===r[t].default&&void 0===o[t]&&l.push(new e.V(i,o,`missing required property "${t}"`));return l}function de(t){const i=t.value,o=t.valueSpec,r=t.style,a=t.styleSpec,n=t.key,s=t.arrayElementValidator||ze;if("array"!==e.n(i))return [new e.V(n,i,`array expected, ${e.n(i)} found`)];if(o.length&&i.length!==o.length)return [new e.V(n,i,`array length ${o.length} expected, length ${i.length} found`)];if(o["min-length"]&&i.length<o["min-length"])return [new e.V(n,i,`array length at least ${o["min-length"]} expected, length ${i.length} found`)];let l={type:o.value,values:o.values,minimum:o.minimum,maximum:o.maximum,function:void 0};a.$version<7&&(l.function=o.function),"object"===e.n(o.value)&&(l=o.value);let c=[];for(let e=0;e<i.length;e++)c=c.concat(s({array:i,arrayIndex:e,value:i[e],valueSpec:l,style:r,styleSpec:a,key:`${n}[${e}]`},!0));return c}function pe(t){const i=t.key,o=t.value,r=t.valueSpec;let a=e.n(o);if("number"===a&&o!=o&&(a="NaN"),"number"!==a)return [new e.V(i,o,`number expected, ${a} found`)];if("minimum"in r){let a=r.minimum;if("array"===e.n(r.minimum)&&(a=r.minimum[t.arrayIndex]),o<a)return [new e.V(i,o,`${o} is less than the minimum value ${a}`)]}if("maximum"in r){let a=r.maximum;if("array"===e.n(r.maximum)&&(a=r.maximum[t.arrayIndex]),o>a)return [new e.V(i,o,`${o} is greater than the maximum value ${a}`)]}return []}function fe(t){const i=t.valueSpec,o=e.u(t.value.type);let r,a,n,s={};const l="categorical"!==o&&void 0===t.value.property,c=!l,h="array"===e.n(t.value.stops)&&"array"===e.n(t.value.stops[0])&&"object"===e.n(t.value.stops[0][0]),_=ue({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===o)return [new e.V(t.key,t.value,'identity function may not have a "stops" property')];let i=[];const r=t.value;return i=i.concat(de({key:t.key,value:r,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===e.n(r)&&0===r.length&&i.push(new e.V(t.key,r,"array must have at least one stop")),i},default:function(e){return ze({key:e.key,value:e.value,valueSpec:i,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===o&&l&&_.push(new e.V(t.key,t.value,'missing required property "property"')),"identity"===o||t.value.stops||_.push(new e.V(t.key,t.value,'missing required property "stops"')),"exponential"===o&&t.valueSpec.expression&&!e.s(t.valueSpec)&&_.push(new e.V(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(c&&!e.q(t.valueSpec)?_.push(new e.V(t.key,t.value,"property functions not supported")):l&&!e.r(t.valueSpec)&&_.push(new e.V(t.key,t.value,"zoom functions not supported"))),"categorical"!==o&&!h||void 0!==t.value.property||_.push(new e.V(t.key,t.value,'"property" property is required')),_;function u(t){let o=[];const r=t.value,l=t.key;if("array"!==e.n(r))return [new e.V(l,r,`array expected, ${e.n(r)} found`)];if(2!==r.length)return [new e.V(l,r,`array length 2 expected, length ${r.length} found`)];if(h){if("object"!==e.n(r[0]))return [new e.V(l,r,`object expected, ${e.n(r[0])} found`)];if(void 0===r[0].zoom)return [new e.V(l,r,"object stop key must have zoom")];if(void 0===r[0].value)return [new e.V(l,r,"object stop key must have value")];const i=e.u(r[0].zoom);if("number"!=typeof i)return [new e.V(l,r[0].zoom,"stop zoom values must be numbers")];if(n&&n>i)return [new e.V(l,r[0].zoom,"stop zoom values must appear in ascending order")];i!==n&&(n=i,a=void 0,s={}),o=o.concat(ue({key:`${l}[0]`,value:r[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:pe,value:d}}));}else o=o.concat(d({key:`${l}[0]`,value:r[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},r));return e.t(e.v(r[1]))?o.concat([new e.V(`${l}[1]`,r[1],"expressions are not allowed in function stops.")]):o.concat(ze({key:`${l}[1]`,value:r[1],valueSpec:i,style:t.style,styleSpec:t.styleSpec}))}function d(t,n){const l=e.n(t.value),c=e.u(t.value),h=null!==t.value?t.value:n;if(r){if(l!==r)return [new e.V(t.key,h,`${l} stop domain type must match previous stop domain type ${r}`)]}else r=l;if("number"!==l&&"string"!==l&&"boolean"!==l&&"number"!=typeof c&&"string"!=typeof c&&"boolean"!=typeof c)return [new e.V(t.key,h,"stop domain value must be a number, string, or boolean")];if("number"!==l&&"categorical"!==o){let r=`number expected, ${l} found`;return e.q(i)&&void 0===o&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new e.V(t.key,h,r)]}return "categorical"!==o||"number"!==l||"number"==typeof c&&isFinite(c)&&Math.floor(c)===c?"categorical"!==o&&"number"===l&&"number"==typeof c&&"number"==typeof a&&void 0!==a&&c<a?[new e.V(t.key,h,"stop domain values must appear in ascending order")]:(a=c,"categorical"===o&&c in s?[new e.V(t.key,h,"stop domain values must be unique")]:(s[c]=!0,[])):[new e.V(t.key,h,`integer expected, found ${String(c)}`)]}}function me(t){const i=("property"===t.expressionContext?e.x:e.y)(e.v(t.value),t.valueSpec);if("error"===i.result)return i.value.map((i=>new e.V(`${t.key}${i.key}`,t.value,i.message)));const o=i.value.expression||i.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!o.outputDefined())return [new e.V(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!e.z(o))return [new e.V(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return ge(o,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!e.A(o,["zoom","feature-state"]))return [new e.V(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!e.B(o))return [new e.V(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function ge(t,i){const o=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(i.valueSpec&&i.valueSpec.expression)for(const e of i.valueSpec.expression.parameters)o.delete(e);if(0===o.size)return [];const r=[];return t instanceof e.D&&o.has(t.name)?[new e.V(i.key,i.value,`["${t.name}"] expression is not supported in a filter for a ${i.object.type} layer with id: ${i.object.id}`)]:(t.eachChild((e=>{r.push(...ge(e,i));})),r)}function ve(t){const i=t.key,o=t.value,r=t.valueSpec,a=[];return Array.isArray(r.values)?-1===r.values.indexOf(e.u(o))&&a.push(new e.V(i,o,`expected one of [${r.values.join(", ")}], ${JSON.stringify(o)} found`)):-1===Object.keys(r.values).indexOf(e.u(o))&&a.push(new e.V(i,o,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(o)} found`)),a}function xe(t){return e.G(e.v(t.value))?me(e.o({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):ye(t)}function ye(t){const i=t.value,o=t.key;if("array"!==e.n(i))return [new e.V(o,i,`array expected, ${e.n(i)} found`)];const r=t.styleSpec;let a,n=[];if(i.length<1)return [new e.V(o,i,"filter array must have at least 1 element")];switch(n=n.concat(ve({key:`${o}[0]`,value:i[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),e.u(i[0])){case"<":case"<=":case">":case">=":i.length>=2&&"$type"===e.u(i[1])&&n.push(new e.V(o,i,`"$type" cannot be use with operator "${i[0]}"`));case"==":case"!=":3!==i.length&&n.push(new e.V(o,i,`filter array for operator "${i[0]}" must have 3 elements`));case"in":case"!in":i.length>=2&&(a=e.n(i[1]),"string"!==a&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${a} found`)));for(let s=2;s<i.length;s++)a=e.n(i[s]),"$type"===e.u(i[1])?n=n.concat(ve({key:`${o}[${s}]`,value:i[s],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==a&&"number"!==a&&"boolean"!==a&&n.push(new e.V(`${o}[${s}]`,i[s],`string, number, or boolean expected, ${a} found`));break;case"any":case"all":case"none":for(let e=1;e<i.length;e++)n=n.concat(ye({key:`${o}[${e}]`,value:i[e],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":a=e.n(i[1]),2!==i.length?n.push(new e.V(o,i,`filter array for "${i[0]}" operator must have 2 elements`)):"string"!==a&&n.push(new e.V(`${o}[1]`,i[1],`string expected, ${a} found`));}return n}function be(t,i){const o=t.key,r=t.style,a=t.layer,n=t.styleSpec,s=t.value,l=t.objectKey,c=n[`${i}_${t.layerType}`];if(!c)return [];const h=l.match(/^(.*)-transition$/);if("paint"===i&&h&&c[h[1]]&&c[h[1]].transition)return ze({key:o,value:s,valueSpec:n.transition,style:r,styleSpec:n});const _=t.valueSpec||c[l];if(!_)return [new e.m(o,s,`unknown property "${l}"`)];let u;if("string"===e.n(s)&&e.q(_)&&!_.tokens&&(u=/^{([^}]+)}$/.exec(s))){const t=`\`{ "type": "identity", "property": ${u?JSON.stringify(u[1]):'"_"'} }\``;return [new e.V(o,s,`"${l}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const d=[];if("symbol"===t.layerType)"text-field"!==l||!r||r.glyphs||r.imports||d.push(new e.V(o,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===l&&e.H(e.v(s))&&"identity"===e.u(s.type)&&d.push(new e.V(o,s,'"text-font" does not support identity functions'));else if("model"===t.layerType&&"paint"===i&&a&&a.layout&&a.layout.hasOwnProperty("model-id")&&e.q(_)&&(e.J(_)||e.r(_))){const t=e.x(e.v(s),_),i=t.value.expression||t.value._styleExpression.expression;i&&!e.A(i,["measure-light"])&&("model-emissive-strength"===l&&e.B(i)&&e.z(i)||d.push(new e.V(o,s,`${l} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`)));}return d.concat(ze({key:t.key,value:s,valueSpec:_,style:r,styleSpec:n,expressionContext:"property",propertyType:i,propertyKey:l}))}function we(e){return be(e,"paint")}function Te(e){return be(e,"layout")}function Ee(t){let i=[];const o=t.value,r=t.key,a=t.style,n=t.styleSpec;o.type||o.ref||i.push(new e.V(r,o,'either "type" or "ref" is required'));let s=e.u(o.type);const l=e.u(o.ref);if(o.id){const n=e.u(o.id);for(let s=0;s<t.arrayIndex;s++){const t=a.layers[s];e.u(t.id)===n&&i.push(new e.V(r,o.id,`duplicate layer id "${o.id}", previously used at line ${t.id.__line__}`));}}if("ref"in o){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in o&&i.push(new e.V(r,o[t],`"${t}" is prohibited for ref layers`));})),a.layers.forEach((i=>{e.u(i.id)===l&&(t=i);})),t?t.ref?i.push(new e.V(r,o.ref,"ref cannot reference another ref layer")):s=e.u(t.type):"string"==typeof l&&i.push(new e.V(r,o.ref,`ref layer "${l}" not found`));}else if("background"!==s&&"sky"!==s&&"slot"!==s)if(o.source){const t=a.sources&&a.sources[o.source],n=t&&e.u(t.type);t?"vector"===n&&"raster"===s?i.push(new e.V(r,o.source,`layer "${o.id}" requires a raster source`)):"raster"===n&&"raster"!==s?i.push(new e.V(r,o.source,`layer "${o.id}" requires a vector source`)):"vector"!==n||o["source-layer"]?"raster-dem"===n&&"hillshade"!==s?i.push(new e.V(r,o.source,"raster-dem source can only be used with layer type 'hillshade'.")):"raster-array"!==n||["raster","raster-particle"].includes(s)?"line"!==s||!o.paint||!o.paint["line-gradient"]&&!o.paint["line-trim-offset"]||"geojson"===n&&t.lineMetrics?"raster-particle"===s&&"raster-array"!==n&&i.push(new e.V(r,o.source,`layer "${o.id}" requires a 'raster-array' source.`)):i.push(new e.V(r,o,`layer "${o.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):i.push(new e.V(r,o.source,"raster-array source can only be used with layer type 'raster'.")):i.push(new e.V(r,o,`layer "${o.id}" must specify a "source-layer"`)):i.push(new e.V(r,o.source,`source "${o.source}" not found`));}else i.push(new e.V(r,o,'missing required property "source"'));return i=i.concat(ue({key:r,value:o,valueSpec:n.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>ze({key:`${r}.type`,value:o.type,valueSpec:n.layer.type,style:t.style,styleSpec:t.styleSpec,object:o,objectKey:"type"}),filter:t=>xe(e.o({layerType:s},t)),layout:t=>ue({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>Te(e.o({layerType:s},t))}}),paint:t=>ue({layer:o,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>we(e.o({layerType:s,layer:o},t))}})}})),i}function Ce(t){const i=t.value,o=t.key,r=e.n(i);return "string"!==r?[new e.V(o,i,`string expected, ${r} found`)]:[]}const Se={promoteId:function({key:t,value:i}){if("string"===e.n(i))return Ce({key:t,value:i});{const e=[];for(const o in i)e.push(...Ce({key:`${t}.${o}`,value:i[o]}));return e}}};function Ie(t){const i=t.value,o=t.key,r=t.styleSpec,a=t.style;if(!i.type)return [new e.V(o,i,'"type" is required')];const n=e.u(i.type);let s=[];switch(["vector","raster","raster-dem","raster-array"].includes(n)&&(i.url||i.tiles||s.push(new e.m(o,i,'Either "url" or "tiles" is required.'))),n){case"vector":case"raster":case"raster-dem":case"raster-array":return s=s.concat(ue({key:o,value:i,valueSpec:r[`source_${n.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:Se})),s;case"geojson":if(s=ue({key:o,value:i,valueSpec:r.source_geojson,style:a,styleSpec:r,objectElementValidators:Se}),i.cluster)for(const e in i.clusterProperties){const[t,r]=i.clusterProperties[e],a="string"==typeof t?[t,["accumulated"],["get",e]]:t;s.push(...me({key:`${o}.${e}.map`,value:r,expressionContext:"cluster-map"})),s.push(...me({key:`${o}.${e}.reduce`,value:a,expressionContext:"cluster-reduce"}));}return s;case"video":return ue({key:o,value:i,valueSpec:r.source_video,style:a,styleSpec:r});case"image":return ue({key:o,value:i,valueSpec:r.source_image,style:a,styleSpec:r});case"canvas":return [new e.V(o,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ve({key:`${o}.type`,value:i.type,valueSpec:{values:Le(r)},style:a,styleSpec:r})}}function Le(e){return e.source.reduce(((t,i)=>{const o=e[i];return "enum"===o.type.type&&(t=t.concat(Object.keys(o.type.values))),t}),[])}function Pe(t){const i=t.value,o=t.styleSpec,r=o.light,a=t.style;let n=[];const s=e.n(i);if(void 0===i)return n;if("object"!==s)return n=n.concat([new e.V("light",i,`object expected, ${s} found`)]),n;for(const t in i){const s=t.match(/^(.*)-transition$/);n=n.concat(s&&r[s[1]]&&r[s[1]].transition?ze({key:t,value:i[t],valueSpec:o.transition,style:a,styleSpec:o}):r[t]?ze({key:t,value:i[t],valueSpec:r[t],style:a,styleSpec:o}):[new e.V(t,i[t],`unknown property "${t}"`)]);}return n}function Ae(t){const i=t.value;let o=[];if(!i)return o;const r=e.n(i);if("object"!==r)return o=o.concat([new e.V("light-3d",i,`object expected, ${r} found`)]),o;const a=t.styleSpec,n=a["light-3d"],s=t.key,l=t.style,c=t.style.lights;for(const t of ["type","id"])if(!(t in i))return o=o.concat([new e.V("light-3d",i,`missing property ${t} on light`)]),o;if(i.type&&c)for(let r=0;r<t.arrayIndex;r++){const t=e.u(i.type),a=c[r];e.u(a.type)===t&&o.push(new e.V(s,i.id,`duplicate light type "${i.type}", previously defined at line ${a.id.__line__}`));}const h=`properties_light_${i.type}`;if(!(h in a))return o=o.concat([new e.V("light-3d",i,`Invalid light type ${i.type}`)]),o;const _=a[h];for(const r in i)if("properties"===r){const n=i[r],s=e.n(n);if("object"!==s)return o=o.concat([new e.V("properties",n,`object expected, ${s} found`)]),o;for(const i in n)o=o.concat(_[i]?ze({key:i,value:n[i],valueSpec:_[i],style:l,styleSpec:a}):[new e.m(t.key,n[i],`unknown property "${i}"`)]);}else {const t=r.match(/^(.*)-transition$/);o=o.concat(t&&n[t[1]]&&n[t[1]].transition?ze({key:r,value:i[r],valueSpec:a.transition,style:l,styleSpec:a}):n[r]?ze({key:r,value:i[r],valueSpec:n[r],style:l,styleSpec:a}):[new e.m(r,i[r],`unknown property "${r}"`)]);}return o}function Re(t){const i=t.value,o=t.key,r=t.style,a=t.styleSpec,n=a.terrain;let s=[];const l=e.n(i);if(void 0===i)return s;if("null"===l)return s;if("object"!==l)return s=s.concat([new e.V("terrain",i,`object expected, ${l} found`)]),s;for(const t in i){const o=t.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?ze({key:t,value:i[t],valueSpec:a.transition,style:r,styleSpec:a}):n[t]?ze({key:t,value:i[t],valueSpec:n[t],style:r,styleSpec:a}):[new e.m(t,i[t],`unknown property "${t}"`)]);}if(i.source){const t=r.sources&&r.sources[i.source],a=t&&e.u(t.type);t?"raster-dem"!==a&&s.push(new e.V(o,i.source,`terrain cannot be used with a source of type ${String(a)}, it only be used with a "raster-dem" source type`)):s.push(new e.V(o,i.source,`source "${i.source}" not found`));}else s.push(new e.V(o,i,'terrain is missing required property "source"'));return s}function De(t){const i=t.value,o=t.style,r=t.styleSpec,a=r.fog;let n=[];const s=e.n(i);if(void 0===i)return n;if("object"!==s)return n=n.concat([new e.V("fog",i,`object expected, ${s} found`)]),n;for(const t in i){const s=t.match(/^(.*)-transition$/);n=n.concat(s&&a[s[1]]&&a[s[1]].transition?ze({key:t,value:i[t],valueSpec:r.transition,style:o,styleSpec:r}):a[t]?ze({key:t,value:i[t],valueSpec:a[t],style:o,styleSpec:r}):[new e.m(t,i[t],`unknown property "${t}"`)]);}return n}const Me={"*":()=>[],array:de,boolean:function(t){const i=t.value,o=t.key,r=e.n(i);return "boolean"!==r?[new e.V(o,i,`boolean expected, ${r} found`)]:[]},number:pe,color:function(t){const i=t.key,o=t.value,r=e.n(o);return "string"!==r?[new e.V(i,o,`color expected, ${r} found`)]:null===e.F(o)?[new e.V(i,o,`color expected, "${o}" found`)]:[]},enum:ve,filter:xe,function:fe,layer:Ee,object:ue,source:Ie,model:e.K,light:Pe,"light-3d":Ae,terrain:Re,fog:De,string:Ce,formatted:function(e){return 0===Ce(e).length?[]:me(e)},resolvedImage:function(e){return 0===Ce(e).length?[]:me(e)},projection:function(t){const i=t.value,o=t.styleSpec,r=o.projection,a=t.style;let n=[];const s=e.n(i);if("object"===s)for(const e in i)n=n.concat(ze({key:e,value:i[e],valueSpec:r[e],style:a,styleSpec:o}));else "string"!==s&&(n=n.concat([new e.V("projection",i,`object or string expected, ${s} found`)]));return n},import:function(t){const{value:i,styleSpec:o}=t,{data:r,...a}=i;Object.defineProperty(a,"__line__",{value:i.__line__,enumerable:!1});let n=ue(e.o({},t,{value:a,valueSpec:o.import}));return ""===e.u(a.id)&&n.push(new e.V(`${t.key}.id`,a,"import id can't be an empty string")),r&&(n=n.concat(Fe(r,o,{key:`${t.key}.data`}))),n}};function ze(t,i=!1){const o=t.value,r=t.valueSpec,a=t.styleSpec;if(r.expression&&e.H(e.u(o)))return fe(t);if(r.expression&&e.t(e.v(o)))return me(t);if(r.type&&Me[r.type]){const o=Me[r.type](t);return !0===i&&o.length>0&&"array"===e.n(t.value)?me(t):o}return ue(e.o({},t,{valueSpec:r.type?a[r.type]:r}))}function Oe(t){const i=t.value,o=t.key,r=Ce(t);return r.length||(-1===i.indexOf("{fontstack}")&&r.push(new e.V(o,i,'"glyphs" url must include a "{fontstack}" token')),-1===i.indexOf("{range}")&&r.push(new e.V(o,i,'"glyphs" url must include a "{range}" token'))),r}function Fe(t,i=e.L,o={}){return ze({key:o.key||"",value:t,valueSpec:i.$root,styleSpec:i,style:t,objectElementValidators:{glyphs:Oe,"*":()=>[]}})}function Be(t,i=e.L){return $e(Fe(t,i))}const ke=e=>$e(Ie(e)),Ne=e=>$e(Pe(e)),Ue=e=>$e(Ae(e)),Ge=e=>$e(Re(e)),je=e=>$e(De(e)),Ve=e=>$e(Ee(e)),We=e=>$e(xe(e)),Ze=e=>$e(we(e)),qe=e=>$e(Te(e)),He=t=>$e(e.K(t));function $e(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Xe(t,i){let o=!1;if(i&&i.length)for(const r of i)r instanceof e.m?e.w(r.message):(t.fire(new e.d(new Error(r.message))),o=!0);return o}const Ye=new e.N({anchor:new e.O(e.L.light.anchor),position:new e.Q(e.L.light.position),color:new e.O(e.L.light.color),intensity:new e.O(e.L.light.intensity)});class Ke extends e.E{constructor(t,i="flat"){super(),this._transitionable=new e.U(Ye),this.setLight(t,i),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(Ne,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Xe(this,t.call(Be,e.W({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.L})))}}const Qe=new e.N({source:new e.O(e.L.terrain.source),exaggeration:new e.O(e.L.terrain.exaggeration)});let Je=class extends e.E{constructor(t,i,o,r){super(),this.scope=o,this._transitionable=new e.U(Qe,o,r),this._transitionable.setTransitionOrValue(t,r),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(e,t){this._transitionable.setTransitionOrValue(e,t);}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}getExaggeration(t){return this._transitioning.possiblyEvaluate(new e.X(t)).get("exaggeration")}isZoomDependent(){const t=this._transitionable._values.exaggeration;return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof e.Z}};const et=45,tt=65,it=.05;function ot(t,i,o,r){const a=e.$(et,tt,o),[n,s]=rt(t,r);let l=1-Math.min(1,Math.exp((i-n)/(s-n)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*a*t.alpha}function rt(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}function at(t,i,o,r,a){const n=e._.transformMat4([],[i,o,r],a.mercatorFogMatrix);return ot(t,e._.length(n),a.pitch,a._fov)}function nt(t,i,o,r,a,n,s){const l=[[o,r,0],[a,r,0],[a,n,0],[o,n,0]];let c=Number.MAX_VALUE,h=-Number.MAX_VALUE;for(const t of l){const o=e._.transformMat4([],t,i),r=e._.length(o);c=Math.min(c,r),h=Math.max(h,r);}return [ot(t,c,s.pitch,s._fov),ot(t,h,s.pitch,s._fov)]}const st=new e.N({range:new e.O(e.L.fog.range),color:new e.O(e.L.fog.color),"high-color":new e.O(e.L.fog["high-color"]),"space-color":new e.O(e.L.fog["space-color"]),"horizon-blend":new e.O(e.L.fog["horizon-blend"]),"star-intensity":new e.O(e.L.fog["star-intensity"]),"vertical-range":new e.O(e.L.fog["vertical-range"])});class lt extends e.E{constructor(t,i,o,r){super(),this._transitionable=new e.U(st,o,new Map(r)),this.set(t,r),this._transitioning=this._transitionable.untransitioned(),this._transform=i,this.properties=new e.a0(st),this.scope=o;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.a1(t.zoom),r=this.properties.get("range"),a=[.5,3];return {range:i?[e.a2(a[0],r[0],o),e.a2(a[1],r[1],o)]:r,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i,o={}){if(this._validate(je,t,o))return;const r=e.W({},t);for(const t of Object.keys(e.L.fog))void 0===r[t]&&(r[t]=e.L.fog[t].default);this._options=r,this._transitionable.setTransitionOrValue(this._options,i);}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.$(et,tt,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const r=e.Y.fromLngLat(i),a=o.elevation?o.elevation.getAtPointOrZero(r):0;return at(t,r.x,r.y,a,o)}(this.state,t,i):0}getOpacityForTile(t){if(!this._transform.projection.supportsFog)return [1,1];const i=this._transform.calculateFogTileMatrix(t.toUnwrapped());return nt(this.state,i,0,0,e.a3,e.a3,this._transform)}getOpacityForBounds(e,t,i,o,r){return this._transform.projection.supportsFog?nt(this.state,e,t,i,o,r,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?rt(this.state,e):[0,1]}isVisibleOnFrustum(t){if(!this._transform.projection.supportsFog)return !1;const i=[4,5,6,7];for(const o of i){const i=t.points[o];let r;if(i[2]>=0)r=i;else {const a=t.points[o-4];r=e.a4(a,i,a[2]/(a[2]-i[2]));}if(at(this.state,r[0],r[1],0,this._transform)>=it)return !0}return !1}updateConfig(e){this._transitionable.setTransitionOrValue(this._options,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&Xe(this,t.call(Be,e.W({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.L})))}}class ct extends e.E{constructor(t,i,o,r){super(),this.scope=o,this._options=t,this.properties=new e.a0(i),this._transitionable=new e.U(i,o,new Map(r)),this._transitionable.setTransitionOrValue(t.properties),this._transitioning=this._transitionable.untransitioned();}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e));}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t);}shadowsEnabled(){return !!this.properties&&!0===this.properties.get("cast-shadows")}}const ht=new e.N({color:new e.O(e.L.properties_light_ambient.color),intensity:new e.O(e.L.properties_light_ambient.intensity)}),_t=new e.N({direction:new e.a5(e.L.properties_light_directional.direction),color:new e.O(e.L.properties_light_directional.color),intensity:new e.O(e.L.properties_light_directional.intensity),"cast-shadows":new e.O(e.L.properties_light_directional["cast-shadows"]),"shadow-intensity":new e.O(e.L.properties_light_directional["shadow-intensity"])});var ut="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#ifdef RENDER_CUTOFF\nfloat cutoff_opacity(vec4 cutoff_params,float depth) {float near=cutoff_params.x;float far=cutoff_params.y;float cutoffStart=cutoff_params.z;float cutoffEnd=cutoff_params.w;float linearDepth=(depth-near)/(far-near);return clamp((linearDepth-cutoffStart)/(cutoffEnd-cutoffStart),0.0,1.0);}\n#endif",dt="\nout vec4 glFragColor;highp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}highp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(255.0*255.0*255.0,255.0*255.0,255.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/255.0,1.0/255.0,1.0/255.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}\n#ifdef INDICATOR_CUTOUT\nuniform vec2 u_indicator_cutout_centers;uniform vec4 u_indicator_cutout_params;\n#endif\nvec4 applyCutout(vec4 color) {\n#ifdef INDICATOR_CUTOUT\nfloat holeMinOpacity=u_indicator_cutout_params.x;float holeRadius=max(u_indicator_cutout_params.y,0.0);float holeAspectRatio=u_indicator_cutout_params.z;float fadeStart=u_indicator_cutout_params.w;float distA=distance(vec2(gl_FragCoord.x,gl_FragCoord.y*holeAspectRatio),vec2(u_indicator_cutout_centers[0],u_indicator_cutout_centers[1]*holeAspectRatio));return color*min(smoothstep(fadeStart,holeRadius,distA)+holeMinOpacity,1.0);\n#else\nreturn color;\n#endif\n}\n#ifdef DEBUG_WIREFRAME\n#define HANDLE_WIREFRAME_DEBUG \\\nglFragColor=vec4(0.7,0.0,0.0,0.7); \\\ngl_FragDepth=gl_FragCoord.z-0.0001;\n#else\n#define HANDLE_WIREFRAME_DEBUG\n#endif\n#ifdef RENDER_CUTOFF\nuniform highp vec4 u_cutoff_params;in float v_cutoff_opacity;\n#endif\nvec4 textureLodCustom(sampler2D image,vec2 pos,vec2 lod_coord) {vec2 size=vec2(textureSize(image,0));vec2 dx=dFdx(lod_coord.xy*size);vec2 dy=dFdy(lod_coord.xy*size);float delta_max_sqr=max(dot(dx,dx),dot(dy,dy));float lod=0.5*log2(delta_max_sqr);return textureLod(image,pos,lod);}vec4 applyLUT(highp sampler3D lut,vec4 col) {vec3 size=vec3(textureSize(lut,0));vec3 uvw=(col.rbg*float(size-1.0)+0.5)/size;return vec4(texture(lut,uvw).rgb,col.a);}vec3 applyLUT(highp sampler3D lut,vec3 col) {return applyLUT(lut,vec4(col,1.0)).rgb;}",pt="\n#define EXTENT 8192.0\n#define RAD_TO_DEG 180.0/PI\n#define DEG_TO_RAD PI/180.0\n#define GLOBE_RADIUS EXTENT/PI/2.0\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#ifndef PROJECTED_POS_ON_VIEWPORT\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {return mix(globe,mercator,t);}mat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}float mercatorXfromLng(float lng) {return (180.0+lng)/360.0;}float mercatorYfromLat(float lat) {return (180.0-(RAD_TO_DEG*log(tan(PI/4.0+lat/2.0*DEG_TO_RAD))))/360.0;}vec3 latLngToECEF(vec2 latLng) {latLng=DEG_TO_RAD*latLng;float cosLat=cos(latLng[0]);float sinLat=sin(latLng[0]);float cosLng=cos(latLng[1]);float sinLng=sin(latLng[1]);float sx=cosLat*sinLng*GLOBE_RADIUS;float sy=-sinLat*GLOBE_RADIUS;float sz=cosLat*cosLng*GLOBE_RADIUS;return vec3(sx,sy,sz);}\n#ifdef RENDER_CUTOFF\nuniform vec4 u_cutoff_params;out float v_cutoff_opacity;\n#endif\nconst vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);const float skirtOffset=24575.0;vec3 decomposeToPosAndSkirt(vec2 posWithComposedSkirt)\n{float skirt=float(posWithComposedSkirt.x >=skirtOffset);vec2 pos=posWithComposedSkirt-vec2(skirt*skirtOffset,0.0);return vec3(pos,skirt);}",ft="in highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;out highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}",mt="\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\n#ifdef TERRAIN\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform highp sampler2D u_depth;uniform vec2 u_depth_size_inv;uniform vec2 u_depth_range_unpack;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=texture(u_dem,pos).r;float tr=texture(u_dem,pos+vec2(dd,0)).r;float bl=texture(u_dem,pos+vec2(0,dd)).r;float br=texture(u_dem,pos+vec2(dd,dd)).r;return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem_prev,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=texture(u_dem_prev,pos).r;float tr=texture(u_dem_prev,pos+vec2(dd,0)).r;float bl=texture(u_dem_prev,pos+vec2(0,dd)).r;float br=texture(u_dem_prev,pos+vec2(dd,dd)).r;return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nfloat nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nreturn currentElevation(apos);}\n#endif\n#ifdef TERRAIN_DEPTH_D24\nfloat unpack_depth(float depth) {return depth*u_depth_range_unpack.x+u_depth_range_unpack.y;}vec4 unpack_depth4(vec4 depth) {return depth*u_depth_range_unpack.x+vec4(u_depth_range_unpack.y);}\n#else\nhighp float unpack_depth_rgba(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}\n#endif\nbool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;\n#ifdef TERRAIN_DEPTH_D24\nfloat depth=unpack_depth(texture(u_depth,(coord.xy+1.0)*0.5).r);\n#else\nfloat depth=unpack_depth_rgba(texture(u_depth,(coord.xy+1.0)*0.5));\n#endif\nreturn coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;\n#ifdef TERRAIN_DEPTH_D24\nvec4 depth=vec4(\ntexture(u_depth,uv-df.xz).r,texture(u_depth,uv+df.xz).r,texture(u_depth,uv-df.zy).r,texture(u_depth,uv+df.zy).r\n);depth=unpack_depth4(depth);\n#else\nvec4 depth=vec4(\nunpack_depth_rgba(texture(u_depth,uv-df.xz)),unpack_depth_rgba(texture(u_depth,uv+df.xz)),unpack_depth_rgba(texture(u_depth,uv-df.zy)),unpack_depth_rgba(texture(u_depth,uv+df.zy))\n);\n#endif\nreturn dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {float tl=texture(u_dem,pos).r;float tr=texture(u_dem,pos+vec2(off.x,0.0)).r;float bl=texture(u_dem,pos+vec2(0.0,off.y)).r;float br=texture(u_dem,pos+off).r;return vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",gt="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump mat4 u_fog_matrix;out vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",vt="highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}\n#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump vec2 u_fog_vertical_limit;uniform mediump float u_fog_temporal_offset;in vec3 v_fog_pos;uniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform highp vec2 u_viewport;uniform float u_globe_transition;uniform int u_is_globe;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}float globe_glow_progress() {highp vec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);highp vec3 dir=normalize(ray_dir);highp vec3 closest_point=dot(u_globe_pos,dir)*dir;highp float sdf=length(closest_point-u_globe_pos)/u_globe_radius;return sdf+PI*0.5;}float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos,float opacity_limit) {float depth=length(pos);float opacity;if (u_is_globe==1) {float glow_progress=globe_glow_progress();float t=mix(glow_progress,depth,u_globe_transition);opacity=fog_opacity(fog_range(t));} else {opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);}return mix(color,u_fog_color.rgb,min(opacity,opacity_limit));}vec3 fog_apply(vec3 color,vec3 pos) {return fog_apply(color,pos,1.0);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec4 fog_apply_premultiplied(vec4 color,vec3 pos,float heightMeters) {float verticalProgress=(u_fog_vertical_limit.x > 0.0 || u_fog_vertical_limit.y > 0.0) ? smoothstep(u_fog_vertical_limit.x,u_fog_vertical_limit.y,heightMeters) : 0.0;float opacityLimit=1.0-smoothstep(0.9,1.0,fog_opacity(pos));return mix(fog_apply_premultiplied(color,pos),color,min(verticalProgress,opacityLimit));}vec3 fog_dither(vec3 color) {\n#ifdef FOG_DITHERING\nvec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);\n#else\nreturn color;\n#endif\n}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif",xt="#ifdef RASTER_ARRAY\nuniform sampler2D u_image0;uniform sampler2D u_image1;const vec4 NODATA=vec4(1);ivec4 _raTexLinearCoord(highp vec2 texCoord,highp vec2 texResolution,out highp vec2 fxy) {texCoord=texCoord*texResolution-0.5;fxy=fract(texCoord);texCoord-=fxy;return ivec4(texCoord.xxyy+vec2(1.5,0.5).xyxy);}vec2 _raTexLinearMix(highp vec2 fxy,highp vec4 colorMix,highp float colorOffset,highp vec4 t00,highp vec4 t10,highp vec4 t01,highp vec4 t11) {vec2 c00=t00==NODATA ? vec2(0) : vec2(colorOffset+dot(t00,colorMix),1);vec2 c10=t10==NODATA ? vec2(0) : vec2(colorOffset+dot(t10,colorMix),1);vec2 c01=t01==NODATA ? vec2(0) : vec2(colorOffset+dot(t01,colorMix),1);vec2 c11=t11==NODATA ? vec2(0) : vec2(colorOffset+dot(t11,colorMix),1);return mix(mix(c01,c11,fxy.x),mix(c00,c10,fxy.x),fxy.y);}vec2 raTexture2D_image0_linear(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec2 fxy;ivec4 c=_raTexLinearCoord(texCoord,texResolution,fxy);return _raTexLinearMix(fxy,colorMix,colorOffset,texelFetch(u_image0,c.yz,0),texelFetch(u_image0,c.xz,0),texelFetch(u_image0,c.yw,0),texelFetch(u_image0,c.xw,0)\n);}vec2 raTexture2D_image1_linear(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec2 fxy;ivec4 c=_raTexLinearCoord(texCoord,texResolution,fxy);return _raTexLinearMix(fxy,colorMix,colorOffset,texelFetch(u_image1,c.yz,0),texelFetch(u_image1,c.xz,0),texelFetch(u_image1,c.yw,0),texelFetch(u_image1,c.xw,0)\n);}vec2 raTexture2D_image0_nearest(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec4 t=texelFetch(u_image0,ivec2(texCoord*texResolution),0);return t==NODATA ? vec2(0) : vec2(colorOffset+dot(t,colorMix),1);}vec2 raTexture2D_image1_nearest(highp vec2 texCoord,highp vec2 texResolution,highp vec4 colorMix,highp float colorOffset) {vec4 t=texelFetch(u_image1,ivec2(texCoord*texResolution),0);return t==NODATA ? vec2(0) : vec2(colorOffset+dot(t,colorMix),1);}\n#endif",yt="#ifdef RASTER_ARRAY\nuniform sampler2D u_velocity;uniform mediump vec2 u_velocity_res;uniform mediump float u_max_speed;const vec4 NO_DATA=vec4(1);const vec2 INVALID_VELOCITY=vec2(-1);uniform highp vec2 u_uv_offset;uniform highp float u_data_offset;uniform highp vec2 u_data_scale;ivec4 rasterArrayLinearCoord(highp vec2 texCoord,highp vec2 texResolution,out highp vec2 fxy) {texCoord=texCoord*texResolution-0.5;fxy=fract(texCoord);texCoord-=fxy;return ivec4(texCoord.xxyy+vec2(1.5,0.5).xyxy);}highp vec2 lookup_velocity(highp vec2 uv) {uv=u_uv_offset.x+u_uv_offset.y*uv;highp vec2 fxy;ivec4 c=rasterArrayLinearCoord(uv,u_velocity_res,fxy);highp vec4 tl=texelFetch(u_velocity,c.yz,0);highp vec4 tr=texelFetch(u_velocity,c.xz,0);highp vec4 bl=texelFetch(u_velocity,c.yw,0);highp vec4 br=texelFetch(u_velocity,c.xw,0);if (tl==NO_DATA) {return INVALID_VELOCITY;}if (tr==NO_DATA) {return INVALID_VELOCITY;}if (bl==NO_DATA) {return INVALID_VELOCITY;}if (br==NO_DATA) {return INVALID_VELOCITY;}highp vec4 t=mix(mix(bl,br,fxy.x),mix(tl,tr,fxy.x),fxy.y);highp vec2 velocity=u_data_offset+vec2(dot(t.rg,u_data_scale),dot(t.ba,u_data_scale));velocity.y=-velocity.y;velocity/=max(u_max_speed,length(velocity));return velocity;}\n#endif\nuniform highp float u_particle_pos_scale;uniform highp vec2 u_particle_pos_offset;highp vec4 pack_pos_to_rgba(highp vec2 p) {highp vec2 v=(p+u_particle_pos_offset)/u_particle_pos_scale;highp vec4 r=vec4(v.x,fract(v.x*255.0),v.y,fract(v.y*255.0));return vec4(r.x-r.y/255.0,r.y,r.z-r.w/255.0,r.w);}highp vec2 unpack_pos_from_rgba(highp vec4 v) {v=floor(v*255.0+0.5)/255.0;highp vec2 p=vec2(v.x+(v.y/255.0),v.z+(v.w/255.0));return u_particle_pos_scale*p-u_particle_pos_offset;}",bt="#ifdef RENDER_SHADOWS\nuniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_normal_offset;vec3 shadow_normal_offset(vec3 normal) {float tileInMeters=u_shadow_normal_offset[0];vec3 n=vec3(-normal.xy,tileInMeters*normal.z);float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return n*dotScale;}vec3 shadow_normal_offset_model(vec3 normal) {float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return normal*dotScale;}float shadow_normal_offset_multiplier0() {return u_shadow_normal_offset[1];}float shadow_normal_offset_multiplier1() {return u_shadow_normal_offset[2];}\n#endif//RENDER_SHADOWS",wt="#ifdef RENDER_SHADOWS\n#ifdef DEPTH_TEXTURE\nuniform highp sampler2D u_shadowmap_0;uniform highp sampler2D u_shadowmap_1;\n#else\nuniform sampler2D u_shadowmap_0;uniform sampler2D u_shadowmap_1;\n#endif\nuniform float u_shadow_intensity;uniform float u_shadow_map_resolution;uniform float u_shadow_texel_size;uniform highp vec3 u_shadow_normal_offset;uniform vec2 u_fade_range;uniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_bias;highp float shadow_sample_1(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture(u_shadowmap_1,uv).r;\n#else\nshadow_depth=unpack_depth(texture(u_shadowmap_1,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}highp float shadow_sample_0(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture(u_shadowmap_0,uv).r;\n#else\nshadow_depth=unpack_depth(texture(u_shadowmap_0,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}float shadow_occlusion_1(highp vec4 pos,highp float bias) {highp vec2 uv=pos.xy;return shadow_sample_1(uv,pos.z-bias);}float shadow_occlusion_0(highp vec4 pos,highp float bias) {highp float compare0=pos.z-bias;\n#ifdef NATIVE\nhighp vec2 uv=pos.xy;highp vec4 samples=textureGather(u_shadowmap_0,uv,0);lowp vec4 stepSamples=step(samples,vec4(compare0));\n#else\nhighp vec2 uv00=pos.xy-vec2(0.5*u_shadow_texel_size);highp vec2 uv10=uv00+vec2(u_shadow_texel_size,0.0);highp vec2 uv01=uv00+vec2(0.0,u_shadow_texel_size);highp vec2 uv11=uv01+vec2(u_shadow_texel_size,0.0);lowp vec4 stepSamples=vec4(\nshadow_sample_0(uv01,compare0),shadow_sample_0(uv11,compare0),shadow_sample_0(uv10,compare0),shadow_sample_0(uv00,compare0)\n);\n#endif\nvec2 f=fract(pos.xy*u_shadow_map_resolution-vec2(0.5));lowp vec2 lerpx=mix(stepSamples.wx,stepSamples.zy,f.xx);return mix(lerpx.x,lerpx.y,f.y);}float shadow_occlusion(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth,highp float bias) {\n#ifdef SHADOWS_SINGLE_CASCADE\nlight_view_pos0.xyz=light_view_pos0.xyz/light_view_pos0.w*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);\n#else\nlight_view_pos0.xyz/=light_view_pos0.w;light_view_pos1.xyz/=light_view_pos1.w;vec4 uv=vec4(light_view_pos0.xy,light_view_pos1.xy);vec4 abs_bounds=abs(uv);if (abs_bounds.x < 1.0 && abs_bounds.y < 1.0) {light_view_pos0.xyz=light_view_pos0.xyz*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);}if (abs_bounds.z >=1.0 || abs_bounds.w >=1.0) {return 0.0;}light_view_pos1.xyz=light_view_pos1.xyz*0.5+0.5;float occlusion1=shadow_occlusion_1(light_view_pos1,bias);return mix(occlusion1,0.0,smoothstep(u_fade_range.x,u_fade_range.y,view_depth));\n#endif\n}highp float calculate_shadow_bias(float NDotL) {\n#ifdef NORMAL_OFFSET\nreturn 0.5*u_shadow_bias.x;\n#else\nreturn 0.5*(u_shadow_bias.x+clamp(u_shadow_bias.y*tan(acos(NDotL)),0.0,u_shadow_bias.z));\n#endif\n}float shadowed_light_factor_normal(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=calculate_shadow_bias(NDotL);float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor_normal_opacity(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth,float shadow_opacity) {float NDotL=dot(N,u_shadow_direction);float bias=calculate_shadow_bias(NDotL);float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias)*shadow_opacity;return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor_normal_unbiased(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return 1.0-(u_shadow_intensity*occlusion);}float shadow_occlusion(float ndotl,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=calculate_shadow_bias(ndotl);return shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);}\n#endif";const Tt=[];Pt(ut,Tt),Pt(pt,Tt),Pt(dt,Tt);const Et={"_prelude_fog.vertex.glsl":gt,"_prelude_terrain.vertex.glsl":mt,"_prelude_shadow.vertex.glsl":bt,"_prelude_fog.fragment.glsl":vt,"_prelude_shadow.fragment.glsl":wt,"_prelude_lighting.glsl":"\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec3 u_lighting_ambient_color;uniform mediump vec3 u_lighting_directional_dir;uniform mediump vec3 u_lighting_directional_color;uniform mediump vec3 u_ground_radiance;float calculate_ambient_directional_factor(vec3 normal) {float NdotL=dot(normal,u_lighting_directional_dir);const float factor_reduction_max=0.3;float dir_luminance=dot(u_lighting_directional_color,vec3(0.2126,0.7152,0.0722));float directional_factor_min=1.0-factor_reduction_max*min(dir_luminance,1.0);float ambient_directional_factor=mix(directional_factor_min,1.0,min((NdotL+1.0),1.0));const float vertical_factor_min=0.92;float vertical_factor=mix(vertical_factor_min,1.0,normal.z*0.5+0.5);return vertical_factor*ambient_directional_factor;}vec3 linearProduct(vec3 srgbIn,vec3 k) {return srgbIn*pow(k,vec3(1./2.2));}vec3 apply_lighting(vec3 color,vec3 normal,float dir_factor) {float ambient_directional_factor=calculate_ambient_directional_factor(normal);vec3 ambient_contrib=ambient_directional_factor*u_lighting_ambient_color;vec3 directional_contrib=u_lighting_directional_color*dir_factor;return linearProduct(color,ambient_contrib+directional_contrib);}vec4 apply_lighting(vec4 color,vec3 normal,float dir_factor) {return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting(vec3 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return apply_lighting(color.rgb,normal,dir_factor);}vec4 apply_lighting(vec4 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting_ground(vec3 color) {return color*u_ground_radiance;}vec4 apply_lighting_ground(vec4 color) {return vec4(apply_lighting_ground(color.rgb),color.a);}float calculate_NdotL(vec3 normal) {const float ext=0.70710678118;return (clamp(dot(normal,u_lighting_directional_dir),-ext,1.0)+ext)/(1.0+ext);}vec4 apply_lighting_with_emission_ground(vec4 color,float emissive_strength) {return mix(apply_lighting_ground(color),color,emissive_strength);}vec3 compute_flood_lighting(vec3 flood_light_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=flood_light_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);float occlusion_ramp=smoothstep(0.0,0.2,1.0-occlusion);return mix(fully_occluded_color,flood_light_color,occlusion_ramp);}vec3 compute_emissive_draped(vec3 unlit_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=unlit_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);return mix(fully_occluded_color,unlit_color,1.0-occlusion);}\n#endif//LIGHTING_3D_MODE","_prelude_raster_array.glsl":xt,"_prelude_raster_particle.glsl":yt},Ct={};At("",mt),At(vt,gt),At(wt,bt),At(xt,""),At(yt,"");const St=At(dt,pt),It=ut;var Lt={background:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec4 u_color;uniform float u_opacity;\n#ifdef LIGHTING_3D_MODE\nin vec4 v_color;\n#endif\nvoid main() {vec4 out_color;\n#ifdef LIGHTING_3D_MODE\nout_color=v_color;\n#else\nout_color=u_color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_lighting.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec4 u_color;out vec4 v_color;uniform float u_emissive_strength;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting_with_emission_ground(u_color,u_emissive_strength);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),backgroundPattern:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_pattern_tl;uniform vec2 u_pattern_br;uniform vec2 u_texsize;uniform float u_opacity;uniform float u_emissive_strength;uniform sampler2D u_image;in vec2 v_pos;void main() {vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(u_pattern_tl/u_texsize,u_pattern_br/u_texsize,imagecoord);vec4 out_color=textureLodCustom(u_image,pos,v_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pattern_size;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_pattern_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),circle:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\nglFragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\n}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;in vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nout vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);vec4 world_center;mat3 surface_vectors;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);world_center=vec4(pos,1);\n#else \nsurface_vectors=mat3(1.0);float height=circle_elevation(circle_center);world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();vec4 occlusion_world_center;vec4 occlusion_projected_center;\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);occlusion_world_center=vec4(circle_center,cantilevered_height,1);occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nocclusion_world_center=world_center;occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}'),clippingMask:At("void main() {glFragColor=vec4(1.0);}","in vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:At('#include "_prelude_fog.fragment.glsl"\nuniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);glFragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\nif (u_is_globe==0) {glFragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;in vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nout vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);vec3 pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\npos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),heatmapTexture:At("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));glFragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(0.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}","in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:At("in float v_placed;in float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);glFragColor =mix(red,blue,step(0.5,v_placed))*0.5;glFragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}",'#include "_prelude_terrain.vertex.glsl"\nin vec3 a_pos;in vec2 a_anchor_pos;in vec2 a_extrude;in vec2 a_placed;in vec2 a_shift;in float a_size_scale;in vec2 a_padding;in float a_z_offset;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;out float v_placed;out float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*(a_z_offset+elevation(a_anchor_pos)),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}'),collisionCircle:At("in float v_radius;in vec2 v_extrude;in float v_perspective_ratio;in float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);glFragColor=color*alpha*opacity_t;}","in vec2 a_pos_2f;in float a_radius;in vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;out float v_radius;out vec2 v_extrude;out float v_perspective_ratio;out float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:At("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);glFragColor=mix(u_color,overlay_color,overlay_color.a);}",'#include "_prelude_terrain.vertex.glsl"\nin vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;\n#endif\nout vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}'),fill:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutline:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin highp vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nin vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;out highp vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutlinePattern:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_emissive_strength;in highp vec2 v_pos;in highp vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);float dist=length(v_pos_world-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out highp vec2 v_pos;out highp vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);v_pos_world=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillPattern:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;in vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nglFragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillExtrusion:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nin vec4 v_color;in vec4 v_flat;\n#ifdef RENDER_SHADOWS\nin highp vec4 v_pos_light_view_0;in highp vec4 v_pos_light_view_1;\n#endif\nuniform lowp float u_opacity;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;in vec2 v_ao;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nin vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nin highp vec3 v_normal;\n#endif\nuniform vec3 u_flood_light_color;uniform highp float u_vertical_scale;uniform float u_flood_light_intensity;uniform vec3 u_ground_shadow_factor;\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nin float v_flood_radius;in float v_has_floodlight;\n#endif\nuniform float u_emissive_strength;in float v_height;void main() {\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nvec3 normal=normalize(v_normal);\n#endif\nfloat z;vec4 color=v_color;\n#ifdef ZERO_ROOF_RADIUS\nz=float(normal.z > 0.00001);\n#ifdef LIGHTING_3D_MODE\nnormal=mix(normal,vec3(0.0,0.0,1.0),z);\n#else\ncolor=mix(v_color,v_roof_color,z);\n#endif\n#endif\nfloat h=max(0.0,v_height);float ao_shade=1.0;\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h_floors=h/(u_ao[1]*u_vertical_scale);float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);ao_shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;\n#ifdef ZERO_ROOF_RADIUS\nconcave*=(1.0-z);\n#endif\nfloat x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);ao_shade*=mix(1.0,x_shade*x_shade*x_shade,concave);\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\ncolor.rgb*=mix(ao_shade,1.0,v_has_floodlight);\n#else\ncolor.rgb*=ao_shade;\n#endif\n#else\ncolor.rgb*=ao_shade;\n#endif\n#endif\n#ifdef LIGHTING_3D_MODE\nfloat flood_radiance=0.0;\n#ifdef FLOOD_LIGHT\nflood_radiance=(1.0-min(h/v_flood_radius,1.0))*u_flood_light_intensity*v_has_floodlight;\n#endif\n#ifdef RENDER_SHADOWS\n#ifdef FLOOD_LIGHT\nfloat ndotl_unclamped=dot(normal,u_shadow_direction);float ndotl=max(0.0,ndotl_unclamped);float occlusion=ndotl_unclamped < 0.0 ? 1.0 : shadow_occlusion(ndotl,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);vec3 litColor=apply_lighting(color.rgb,normal,(1.0-u_shadow_intensity*occlusion)*ndotl);vec3 floodLitColor=compute_flood_lighting(u_flood_light_color*u_opacity,1.0-u_shadow_intensity,occlusion,u_ground_shadow_factor);color.rgb=mix(litColor,floodLitColor,flood_radiance);\n#else\nfloat shadowed_lighting_factor;\n#ifdef RENDER_CUTOFF\nshadowed_lighting_factor=shadowed_light_factor_normal_opacity(normal,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w,v_cutoff_opacity);if (v_cutoff_opacity==0.0) {discard;}\n#else\nshadowed_lighting_factor=shadowed_light_factor_normal(normal,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);\n#endif\ncolor.rgb=apply_lighting(color.rgb,normal,shadowed_lighting_factor);\n#endif\n#else\ncolor.rgb=apply_lighting(color.rgb,normal);\n#ifdef FLOOD_LIGHT\ncolor.rgb=mix(color.rgb,u_flood_light_color*u_opacity,flood_radiance);\n#endif\n#endif\ncolor.rgb=mix(color.rgb,v_flat.rgb,u_emissive_strength);color*=u_opacity;\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos,h));\n#endif\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\nglFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_shadow.vertex.glsl"\n#include "_prelude_lighting.glsl"\nuniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform float u_edge_radius;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nuniform highp float u_vertical_scale;out vec4 v_color;out vec4 v_flat;\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;out highp vec4 v_pos_light_view_0;out highp vec4 v_pos_light_view_1;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nout vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nout highp vec3 v_normal;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;out vec2 v_ao;\n#endif\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nout float v_flood_radius;out float v_has_floodlight;\n#endif\nout float v_height;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define highp float flood_light_wall_radius\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize highp float flood_light_wall_radius\nbase*=u_vertical_scale;height*=u_vertical_scale;vec4 pos_nx=floor(a_pos_normal_ed*0.5);vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nv_normal=normal;\n#endif\nbase=max(0.0,base);float attr_height=height;height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=0.0;float c_ele=0.0;vec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);pos=vec3(pos_nx.xy,h);\n#else\nh=t > 0.0 ? height : base;pos=vec3(pos_nx.xy,h);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*h);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat cutoff=1.0;vec3 scaled_pos=pos;\n#ifdef RENDER_CUTOFF\nvec3 centroid_random=vec3(centroid_pos.xy,centroid_pos.x+centroid_pos.y+1.0);vec3 ground_pos=centroid_pos.x==0.0 ? pos.xyz : (centroid_random/8.0);vec4 ground=u_matrix*vec4(ground_pos.xy,ele,1.0);cutoff=cutoff_opacity(u_cutoff_params,ground.z);if (centroid_pos.y !=0.0 && centroid_pos.x !=0.0) {vec3 g=floor(ground_pos);vec3 mod_=centroid_random-g*8.0;float seed=min(1.0,0.1*(min(3.5,max(mod_.x+mod_.y,0.2*attr_height))*0.35+mod_.z));if (cutoff < 0.8-seed) {cutoff=0.0;}}float cutoff_scale=cutoff;v_cutoff_opacity=cutoff;scaled_pos.z=mix(c_ele,h,cutoff_scale);\n#endif\nfloat hidden=float((centroid_pos.x==0.0 && centroid_pos.y==1.0) || (cutoff==0.0 && centroid_pos.x !=0.0));gl_Position=mix(u_matrix*vec4(scaled_pos,1),AWAY,hidden);h=h-ele;v_height=h;\n#ifdef RENDER_SHADOWS\nvec3 shd_pos0=pos;vec3 shd_pos1=pos;\n#ifdef NORMAL_OFFSET\nvec3 offset=shadow_normal_offset(normal);shd_pos0+=offset*shadow_normal_offset_multiplier0();shd_pos1+=offset*shadow_normal_offset_multiplier1();\n#endif\nv_pos_light_view_0=u_light_matrix_0*vec4(shd_pos0,1);v_pos_light_view_1=u_light_matrix_1*vec4(shd_pos1,1);\n#endif\nfloat NdotL=0.0;float colorvalue=0.0;\n#ifndef LIGHTING_3D_MODE\ncolorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;NdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),NdotL);if (normal.y !=0.0) {float r=0.84;r=mix(0.7,0.98,1.0-u_lightintensity);NdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#endif\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec2(mix(concave,-concave,start),y_ground);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\nfloat is_wall=1.0-float(t > 0.0 && top_up_ny.y > 0.0);v_has_floodlight=float(flood_light_wall_radius > 0.0 && is_wall > 0.0);v_flood_radius=flood_light_wall_radius*u_vertical_scale;\n#endif\nv_color=vec4(color.rgb,1.0);v_flat=vec4(linearProduct(color.rgb,vec3(calculate_NdotL(normal))),1.0);\n#else\nv_color=vec4(0.0,0.0,0.0,1.0);v_color.rgb+=clamp(color.rgb*NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_color*=u_opacity;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nfloat roofNdotL=clamp(u_lightpos.z,0.0,1.0);roofNdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),roofNdotL);v_roof_color=vec4(0.0,0.0,0.0,1.0);v_roof_color.rgb+=clamp(color.rgb*roofNdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_roof_color*=u_opacity;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),fillExtrusionDepth:At("in highp float v_depth;void main() {\n#ifndef DEPTH_TEXTURE\nglFragColor=pack_depth(v_depth);\n#endif\n}",'#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_edge_radius;uniform float u_vertical_scale;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\nout highp float v_depth;void main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\nbase*=u_vertical_scale;height*=u_vertical_scale;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;base=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nvec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;float ele=elevation(pos_nx.xy);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base);pos=vec3(pos_nx.xy,h);\n#else\npos=vec3(pos_nx.xy,t > 0.0 ? height : base);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);v_depth=gl_Position.z/gl_Position.w;}'),fillExtrusionPattern:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;in vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nin vec3 v_normal;\n#endif\nin vec2 v_pos;in vec4 v_lighting;uniform lowp float u_opacity;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec2 lod_pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,v_pos);vec4 out_color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color,normalize(v_normal))*u_opacity;\n#else\nout_color=out_color*v_lighting;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;float x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);out_color.rgb=out_color.rgb*shade;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_lighting.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform float u_tile_units_to_pixels;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;in vec4 a_pos_normal_ed;in vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_pos_3;in vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nout vec2 v_pos;out vec4 v_lighting;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;out vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nout vec3 v_normal;\n#endif\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec4 pos_nx=floor(a_pos_normal_ed*0.5);mediump vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;mediump vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=z;vec3 p;float c_ele;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);p=vec3(pos_nx.xy,h);\n#else\np=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float NdotL=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\nNdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_normal=normal;\n#else\nv_lighting.rgb+=clamp(NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#endif \n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}'),groundShadow:At('#include "_prelude_shadow.fragment.glsl"\nprecision highp float;uniform vec3 u_ground_shadow_factor;in vec4 v_pos_light_view_0;in vec4 v_pos_light_view_1;\n#ifdef FOG\nin float v_fog_opacity;\n#endif\nvoid main() {float light=shadowed_light_factor(v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);vec3 shadow=mix(u_ground_shadow_factor,vec3(1.0),light);\n#ifdef RENDER_CUTOFF\nshadow=mix(vec3(1.0),shadow,cutoff_opacity(u_cutoff_params,1.0/gl_FragCoord.w));\n#endif\n#ifdef FOG\nshadow=mix(shadow,vec3(1.0),v_fog_opacity);\n#endif\n#ifdef INDICATOR_CUTOUT\nshadow=mix(shadow,vec3(1.0),1.0-applyCutout(vec4(1.0)).r);\n#endif\nglFragColor=vec4(shadow,1.0);}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;in vec2 a_pos;out vec4 v_pos_light_view_0;out vec4 v_pos_light_view_1;\n#ifdef FOG\nout float v_fog_opacity;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0.0,1.0);v_pos_light_view_0=u_light_matrix_0*vec4(a_pos,0.0,1.0);v_pos_light_view_1=u_light_matrix_1*vec4(a_pos,0.0,1.0);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);v_fog_opacity=fog(v_fog_pos);\n#endif\n}'),fillExtrusionGroundEffect:At("uniform highp float u_ao_pass;uniform highp float u_opacity;uniform highp float u_flood_light_intensity;uniform highp vec3 u_flood_light_color;uniform highp float u_attenuation;uniform sampler2D u_fb;uniform float u_fb_size;\n#ifdef SDF_SUBPASS\nin highp vec2 v_pos;in highp vec4 v_line_segment;in highp float v_flood_light_radius_tile;in highp vec2 v_ao;float line_df(highp vec2 a,highp vec2 b,highp vec2 p) {highp vec2 ba=b-a;highp vec2 pa=p-a;highp float r=clamp(dot(pa,ba)/dot(ba,ba),0.0,1.0);return length(pa-r*ba);}\n#ifdef FOG\nin highp float v_fog;\n#endif\n#endif\nvoid main() {\n#ifdef CLEAR_SUBPASS\nvec4 color=vec4(1.0);\n#ifdef CLEAR_FROM_TEXTURE\ncolor=texture(u_fb,gl_FragCoord.xy/vec2(u_fb_size));\n#endif\nglFragColor=color;\n#else\n#ifdef SDF_SUBPASS\nhighp float d=line_df(v_line_segment.xy,v_line_segment.zw,v_pos);highp float effect_radius=mix(v_flood_light_radius_tile,v_ao.y,u_ao_pass);d/=effect_radius;d=min(d,1.0);d=1.0-pow(1.0-d,u_attenuation);highp float effect_intensity=mix(u_flood_light_intensity,v_ao.x,u_ao_pass);highp float fog=1.0;\n#ifdef FOG\nfog=v_fog;\n#endif\n#ifdef RENDER_CUTOFF\nfog*=v_cutoff_opacity;\n#endif\nglFragColor=vec4(vec3(0.0),mix(1.0,d,effect_intensity*u_opacity*fog));\n#else\nvec4 color=mix(vec4(u_flood_light_color,1.0),vec4(vec3(0.0),1.0),u_ao_pass);\n#ifdef OVERDRAW_INSPECTOR\ncolor=vec4(1.0);\n#endif\nglFragColor=color;\n#endif\nHANDLE_WIREFRAME_DEBUG;\n#endif\n}",'#include "_prelude_fog.vertex.glsl"\nin highp vec4 a_pos_end;in highp float a_angular_offset_factor;in highp float a_hidden_by_landmark;\n#ifdef SDF_SUBPASS\nout highp vec2 v_pos;out highp vec4 v_line_segment;out highp float v_flood_light_radius_tile;out highp vec2 v_ao;\n#ifdef FOG\nout highp float v_fog;\n#endif\n#endif\nuniform highp float u_flood_light_intensity;uniform highp mat4 u_matrix;uniform highp float u_ao_pass;uniform highp float u_meter_to_tile;uniform highp float u_edge_radius;uniform highp vec2 u_ao;\n#pragma mapbox: define highp float flood_light_ground_radius\nconst float TANGENT_CUTOFF=4.0;const float NORM=32767.0;void main() {\n#pragma mapbox: initialize highp float flood_light_ground_radius\nvec2 p=a_pos_end.xy;vec2 q=floor(a_pos_end.zw*0.5);vec2 start_bottom=a_pos_end.zw-q*2.0;float fl_ground_radius=flood_light_ground_radius;fl_ground_radius=abs(flood_light_ground_radius);float direction=flood_light_ground_radius < 0.0 ?-1.0 : 1.0;float flood_radius_tile=fl_ground_radius*u_meter_to_tile;vec2 v=normalize(q-p);float ao_radius=u_ao.y/3.5;float effect_radius=mix(flood_radius_tile,ao_radius,u_ao_pass)+u_edge_radius;float angular_offset_factor=a_angular_offset_factor/NORM*TANGENT_CUTOFF;float angular_offset=direction*angular_offset_factor*effect_radius;float top=1.0-start_bottom.y;float side=(0.5-start_bottom.x)*2.0;vec2 extrusion_parallel=v*side*mix(1.0,angular_offset,top);vec2 perp=vec2(v.y,-v.x);vec2 extrusion_perp=direction*perp*effect_radius*top;vec3 pos=vec3(mix(q,p,start_bottom.x),0.0);pos.xy+=extrusion_parallel+extrusion_perp;\n#ifdef SDF_SUBPASS\nv_pos=pos.xy;v_line_segment=vec4(p,q)+perp.xyxy*u_edge_radius;v_flood_light_radius_tile=flood_radius_tile;v_ao=vec2(u_ao.x,ao_radius);\n#ifdef FOG\nv_fog_pos=fog_position(pos);v_fog=1.0-fog(v_fog_pos);\n#endif\n#endif\nfloat hidden_by_landmark=0.0;\n#ifdef HAS_CENTROID\nhidden_by_landmark=a_hidden_by_landmark;\n#endif\nfloat isFloodlit=float(fl_ground_radius > 0.0 && u_flood_light_intensity > 0.0);float hidden=mix(1.0-isFloodlit,isFloodlit,u_ao_pass);hidden+=hidden_by_landmark;gl_Position=mix(u_matrix*vec4(pos,1.0),AWAY,float(hidden > 0.0));\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n}'),hillshadePrepare:At("precision highp float;uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;float getElevation(vec2 coord) {return texture(u_image,coord).r/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos+vec2(epsilon.x,0));float f=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float g=getElevation(v_pos+vec2(0,epsilon.y));float h=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+e+e+h)-(a+d+d+f),(f+g+g+h)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));glFragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;uniform float u_emissive_strength;void main() {vec4 pixel=texture(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);glFragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef LIGHTING_3D_MODE\nglFragColor=apply_lighting_with_emission_ground(glFragColor,u_emissive_strength);\n#endif\n#ifdef FOG\nglFragColor=fog_dither(fog_apply_premultiplied(glFragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),line:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;uniform highp vec2 u_trim_offset;uniform lowp vec2 u_trim_fade_range;uniform lowp vec4 u_trim_color;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;in vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;\n#endif\nfloat luminance(vec3 c) {return (c.r+c.r+c.b+c.g+c.g+c.g)*0.1667;}uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nfloat linearstep(float edge0,float edge1,float x) {return  clamp((x-edge0)/(edge1-edge0),0.0,1.0);}void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist=texture(u_dash_image,v_tex).r;float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/dash.z;alpha*=linearstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\nhighp vec4 out_color;\n#ifdef RENDER_LINE_GRADIENT\nout_color=texture(u_gradient_image,v_uv.xy);\n#else\nout_color=color;\n#endif\nfloat trim_alpha=1.0;\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {float start_transition=max(0.0,min(1.0,(line_progress-trim_start)/clamp(u_trim_fade_range[0],1e-4,1.0)));float end_transition=max(0.0,min(1.0,(trim_end-line_progress)/clamp(u_trim_fade_range[1],1e-4,1.0)));float transition_factor=min(start_transition,end_transition);out_color=mix(out_color,u_trim_color,transition_factor);trim_alpha=out_color.a;}\n#endif\nif (u_alpha_discard_threshold !=0.0) {if (alpha < u_alpha_discard_threshold) {discard;}}\n#ifdef RENDER_LINE_BORDER\nfloat edgeBlur=(border_width+1.0/u_device_pixel_ratio);float alpha2=clamp(min(dist-(v_width2.t-edgeBlur),v_width2.s-dist)/edgeBlur,0.0,1.0);if (alpha2 < 1.) {float smoothAlpha=smoothstep(0.6,1.0,alpha2);if (border_color.a==0.0) {float Y=(out_color.a > 0.01) ? luminance(out_color.rgb/out_color.a) : 1.;float adjustment=(Y > 0.) ? 0.5/Y : 0.45;if (out_color.a > 0.25 && Y < 0.25) {vec3 borderColor=(Y > 0.) ? out_color.rgb : vec3(1,1,1)*out_color.a;out_color.rgb=out_color.rgb+borderColor*(adjustment*(1.0-smoothAlpha));} else {out_color.rgb*=(0.6 +0.4*smoothAlpha);}} else {out_color.rgb=mix(border_color.rgb*border_color.a*trim_alpha,out_color.rgb,smoothAlpha);}}\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nout_color*=(alpha*opacity);\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#define EXTRUDE_SCALE 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;\n#if defined(ELEVATED)\nin float a_z_offset;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nin highp vec4 a_packed;\n#endif\n#ifdef RENDER_LINE_DASH\nin float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform float u_tile_units_to_pixels;out vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);\n#if defined(ELEVATED)\nvec2 offsetTile=offset2*u_pixels_to_tile_units;vec2 halfCellProgress=normal.yx*32.0;float ele0=elevation(pos);float ele_line=max(ele0,max(elevation(pos+halfCellProgress),elevation(pos-halfCellProgress)));float ele1=elevation(pos+offsetTile);float ele2=elevation(pos-offsetTile);float ele_max=max(ele_line,0.5*(ele1+ele2));float ele=ele_max-ele0+ele1+a_z_offset ;gl_Position=u_matrix*vec4(pos+offsetTile,ele,1.0)+projected_extrude;float z=clamp(gl_Position.z/gl_Position.w,0.5,1.0);float zbias=max(0.00005,(pow(z,0.8)-z)*0.1*u_exaggeration);gl_Position.z-=(gl_Position.w*zbias);\n#else\ngl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#endif\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];\n#ifdef RENDER_LINE_GRADIENT\nhighp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec4(a_uv_x,a_split_index*texel_height-half_texel_height,a_clip_start,a_clip_end);\n#else\nv_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\n#endif\n#ifdef RENDER_LINE_DASH\nfloat scale=dash.z==0.0 ? 0.0 : u_tile_units_to_pixels/dash.z;float height=dash.y;v_tex=vec2(a_linesofar*scale/floorwidth,(-normal.y*height+dash.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),linePattern:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform highp float u_device_pixel_ratio;uniform highp float u_alpha_discard_threshold;uniform highp vec2 u_texsize;uniform highp float u_tile_units_to_pixels;uniform highp vec2 u_trim_offset;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in highp float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef RENDER_LINE_TRIM_OFFSET\nin highp vec4 v_uv;\n#endif\n#ifdef LINE_JOIN_NONE\nin vec2 v_pattern_data;\n#endif\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define mediump float pixel_ratio\n#pragma mapbox: define mediump float blur\n#pragma mapbox: define mediump float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize mediump float pixel_ratio\n#pragma mapbox: initialize mediump float blur\n#pragma mapbox: initialize mediump float opacity\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;float pattern_size=display_size.x/u_tile_units_to_pixels;float aspect=display_size.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);highp float pattern_x=v_linesofar/pattern_size*aspect;float x=mod(pattern_x,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(x,y));vec2 lod_pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(pattern_x,y));vec4 color=textureLodCustom(u_image,pos,lod_pos);\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {color=vec4(0,0,0,0);}}\n#endif\n#ifdef LINE_JOIN_NONE\nfloat pattern_len=pattern_size/aspect;float segment_phase=pattern_len-mod(v_linesofar-v_pattern_data.x+pattern_len,pattern_len);float visible_start=segment_phase-step(pattern_len*0.5,segment_phase)*pattern_len;float visible_end=floor((v_pattern_data.y-segment_phase)/pattern_len)*pattern_len+segment_phase;visible_end+=step(pattern_len*0.5,v_pattern_data.y-visible_end)*pattern_len;if (v_pattern_data.x < visible_start || v_pattern_data.x >=visible_end) {color=vec4(0.0);}\n#endif\n#ifdef LIGHTING_3D_MODE\ncolor=apply_lighting_ground(color);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ncolor*=(alpha*opacity);if (u_alpha_discard_threshold !=0.0) {if (color.a < u_alpha_discard_threshold) {discard;}}\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\nglFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;\n#if defined(ELEVATED)\nin float a_z_offset;\n#endif\n#ifdef RENDER_LINE_TRIM_OFFSET\nin highp vec4 a_packed;\n#endif\nin highp float a_linesofar;\n#ifdef LINE_JOIN_NONE\nin highp vec3 a_pattern_data;out vec2 v_pattern_data;\n#endif\nuniform mat4 u_matrix;uniform float u_tile_units_to_pixels;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out highp float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef RENDER_LINE_TRIM_OFFSET\nout highp vec4 v_uv;\n#endif\n#pragma mapbox: define mediump float blur\n#pragma mapbox: define mediump float opacity\n#pragma mapbox: define mediump float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define mediump float floorwidth\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define mediump float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize mediump float blur\n#pragma mapbox: initialize mediump float opacity\n#pragma mapbox: initialize mediump float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize mediump float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize mediump float pixel_ratio\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);vec2 dist=outset*a_extrude*scale;float u=0.5*a_direction;float t=1.0-abs(u);vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);\n#if defined(ELEVATED)\nvec2 offsetTile=offset2*u_pixels_to_tile_units;vec2 halfCellProgress=normal.yx*32.0;float ele0=elevation(pos);float ele_line=max(ele0,max(elevation(pos+halfCellProgress),elevation(pos-halfCellProgress)));float ele1=elevation(pos+offsetTile);float ele2=elevation(pos-offsetTile);float ele_max=max(ele_line,0.5*(ele1+ele2));float ele=ele_max-ele0+ele1+a_z_offset ;gl_Position=u_matrix*vec4(pos+offsetTile,ele,1.0)+projected_extrude;float z=clamp(gl_Position.z/gl_Position.w,0.5,1.0);float zbias=max(0.00005,(pow(z,0.8)-z)*0.1*u_exaggeration);gl_Position.z-=(gl_Position.w*zbias);\n#else\ngl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#endif\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#ifdef RENDER_LINE_TRIM_OFFSET\nfloat a_uv_x=a_packed[0];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];v_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef LINE_JOIN_NONE\nv_width=floorwidth+ANTIALIASING;mediump float pixels_to_tile_units=1.0/u_tile_units_to_pixels;mediump float pixel_ratio_inverse=1.0/pixel_ratio;mediump float aspect=v_width/((pattern.w-pattern.y)*pixel_ratio_inverse);highp float subt_multiple=(pattern.z-pattern.x)*pixel_ratio_inverse*pixels_to_tile_units*aspect*32.0;highp float subt=floor(a_pattern_data.z/subt_multiple)*subt_multiple;float offset_sign=(fract(a_pattern_data.x)-0.5)*4.0;float line_progress_offset=offset_sign*v_width*0.5*pixels_to_tile_units;v_linesofar=(a_pattern_data.z-subt)+a_linesofar+line_progress_offset;v_pattern_data=vec2(a_pattern_data.x+line_progress_offset,a_pattern_data.y);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),raster:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\n#include "_prelude_raster_array.glsl"\nuniform float u_fade_t;uniform float u_opacity;uniform highp float u_raster_elevation;uniform highp float u_zoom_transition;in vec2 v_pos0;in vec2 v_pos1;in float v_depth;\n#ifdef PROJECTION_GLOBE_VIEW\nin float v_split_fade;\n#endif\nuniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;uniform float u_emissive_strength;\n#ifndef RASTER_ARRAY\nuniform sampler2D u_image0;uniform sampler2D u_image1;\n#endif\n#ifdef RASTER_COLOR\nuniform sampler2D u_color_ramp;uniform highp vec4 u_colorization_mix;uniform highp float u_colorization_offset;uniform vec2 u_texture_res;\n#endif\nvoid main() {vec4 color0,color1,color;vec2 value;\n#ifdef RASTER_COLOR\n#ifdef RASTER_ARRAY\n#ifdef RASTER_ARRAY_LINEAR\nvalue=mix(\nraTexture2D_image0_linear(v_pos0,u_texture_res,u_colorization_mix,u_colorization_offset),raTexture2D_image1_linear(v_pos1,u_texture_res,u_colorization_mix,u_colorization_offset),u_fade_t\n);\n#else\nvalue=mix(\nraTexture2D_image0_nearest(v_pos0,u_texture_res,u_colorization_mix,u_colorization_offset),raTexture2D_image1_nearest(v_pos1,u_texture_res,u_colorization_mix,u_colorization_offset),u_fade_t\n);\n#endif\nif (value.y > 0.0) value.x/=value.y;\n#else\ncolor=mix(texture(u_image0,v_pos0),texture(u_image1,v_pos1),u_fade_t);value=vec2(u_colorization_offset+dot(color.rgb,u_colorization_mix.rgb),color.a);\n#endif\ncolor=texture(u_color_ramp,vec2(value.x,0.5));if (color.a > 0.0) color.rgb/=color.a;color.a*=value.y;\n#else\ncolor0=texture(u_image0,v_pos0);color1=texture(u_image1,v_pos1);if (color0.a > 0.0) color0.rgb/=color0.a;if (color1.a > 0.0) color1.rgb/=color1.a;color=mix(color0,color1,u_fade_t);\n#endif\ncolor.a*=u_opacity;\n#ifdef GLOBE_POLES\ncolor.a*=1.0-smoothstep(0.0,0.05,u_zoom_transition);\n#endif\nvec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(vec4(out_color,1.0),u_emissive_strength).rgb;\n#endif\n#ifdef FOG\nhighp float fog_limit_high_meters=1000000.0;highp float fog_limit_low_meters=600000.0;float fog_limit=1.0-smoothstep(fog_limit_low_meters,fog_limit_high_meters,u_raster_elevation);out_color=fog_dither(fog_apply(out_color,v_fog_pos,fog_limit));\n#endif\nglFragColor=vec4(out_color*color.a,color.a);\n#ifdef PROJECTION_GLOBE_VIEW\nglFragColor*=mix(1.0,1.0-smoothstep(0.0,0.05,u_zoom_transition),smoothstep(0.8,0.9,v_split_fade));\n#endif\n#ifdef RENDER_CUTOFF\nglFragColor=glFragColor*cutoff_opacity(u_cutoff_params,v_depth);\n#endif\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform mat3 u_grid_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;uniform vec2 u_texture_offset;uniform float u_raster_elevation;uniform float u_zoom_transition;uniform vec2 u_merc_center;\n#define GLOBE_UPSCALE GLOBE_RADIUS/6371008.8\n#ifdef GLOBE_POLES\nin vec3 a_globe_pos;in vec2 a_uv;\n#else\nin vec2 a_pos;in vec2 a_texture_pos;\n#endif\nout vec2 v_pos0;out vec2 v_pos1;out float v_depth;\n#ifdef PROJECTION_GLOBE_VIEW\nout float v_split_fade;\n#endif\nvoid main() {vec2 uv;\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;gl_Position=u_matrix*u_globe_matrix*vec4(globe_pos   ,1.0);uv=a_uv;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(a_globe_pos,1.0)).xyz);\n#endif\n#else\nfloat w=1.0+dot(a_texture_pos,u_perspective_transform);uv=a_texture_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);vec3 globe_pos=latLngToECEF(latLng.xy);globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;vec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);float mercatorY=mercatorYfromLat(latLng[0]);float mercatorX=mercatorXfromLng(latLng[1]);    \nv_split_fade=0.0;if (u_zoom_transition > 0.0) {vec2 merc_pos=vec2(mercatorX,mercatorY);merc_world_pos=vec4(merc_pos,u_raster_elevation,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;float opposite_merc_center=mod(u_merc_center.x+0.5,1.0);float dist_from_poles=(abs(mercatorY-0.5)*2.0);float range=0.1;v_split_fade=abs(opposite_merc_center-mercatorX);v_split_fade=clamp(1.0-v_split_fade,0.0,1.0);v_split_fade=max(smoothstep(1.0-range,1.0,dist_from_poles),max(smoothstep(1.0-range,1.0,v_split_fade),smoothstep(1.0-range,1.0,1.0-v_split_fade)));}float tiles=u_grid_matrix[0][2];if (tiles > 0.0) {float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];float uvY=mercatorY*tiles-idy;float uvX=mercatorX*tiles-idx;uv=vec2(uvX,uvY);}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition)*w,w);gl_Position=u_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n#else\ngl_Position=u_matrix*vec4(a_pos*w,u_raster_elevation*w,w);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n#endif\n#endif\nv_pos0=uv;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;v_pos0=u_texture_offset.x+u_texture_offset.y*v_pos0;v_pos1=u_texture_offset.x+u_texture_offset.y*v_pos1;\n#ifdef RENDER_CUTOFF\nv_depth=gl_Position.z;\n#endif\n}'),rasterParticle:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform float u_fade_t;uniform float u_opacity;uniform highp float u_raster_elevation;in vec2 v_pos0;in vec2 v_pos1;uniform sampler2D u_image0;uniform sampler2D u_image1;void main() {vec4 color0,color1,color;color0=texture(u_image0,v_pos0);color1=texture(u_image1,v_pos1);if (color0.a > 0.0) color0.rgb/=color0.a;if (color1.a > 0.0) color1.rgb/=color1.a;color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 out_color=color.rgb;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(vec4(out_color,1.0),0.0).rgb;\n#endif\n#ifdef FOG\nhighp float fog_limit_high_meters=1000000.0;highp float fog_limit_low_meters=600000.0;float fog_limit=1.0-smoothstep(fog_limit_low_meters,fog_limit_high_meters,u_raster_elevation);out_color=fog_dither(fog_apply(out_color,v_fog_pos,fog_limit));\n#endif\nglFragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform mat3 u_grid_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_raster_elevation;uniform float u_zoom_transition;uniform vec2 u_merc_center;\n#define GLOBE_UPSCALE GLOBE_RADIUS/6371008.8\nin vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {float w=1.0;vec2 uv;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float mercatorX=mercatorXfromLng(latLng[1]);float tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];float uvX=mercatorX*tiles-idx;float uvY=mercatorY*tiles-idy;uv=vec2(uvX,uvY);vec3 globe_pos=latLngToECEF(latLng.xy);globe_pos+=normalize(globe_pos)*u_raster_elevation*GLOBE_UPSCALE;vec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {vec2 merc_pos=vec2(mercatorX,mercatorY);merc_world_pos=vec4(merc_pos,u_raster_elevation,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition)*w,w);gl_Position=u_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n#else\nuv=a_texture_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*w,u_raster_elevation*w,w);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n#endif\nv_pos0=uv;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}'),rasterParticleDraw:At("uniform sampler2D u_color_ramp;in float v_particle_speed;void main() {glFragColor=texture(u_color_ramp,vec2(v_particle_speed,0.5));}",'#include "_prelude_raster_particle.glsl"\nin float a_index;uniform sampler2D u_particle_texture;uniform float u_particle_texture_side_len;uniform vec2 u_tile_offset;out float v_particle_speed;void main() {ivec2 pixel_coord=ivec2(\nmod(a_index,u_particle_texture_side_len),a_index/u_particle_texture_side_len);vec4 pixel=texelFetch(u_particle_texture,pixel_coord,0);vec2 pos=unpack_pos_from_rgba(pixel)+u_tile_offset;vec2 tex_coord=fract(pos);vec2 velocity=lookup_velocity(tex_coord);if (velocity==INVALID_VELOCITY) {gl_Position=AWAY;v_particle_speed=0.0;} else {gl_Position=vec4(2.0*pos-1.0,0,1);v_particle_speed=length(velocity);}gl_PointSize=1.0;}'),rasterParticleTexture:At("uniform sampler2D u_texture;uniform float u_opacity;in vec2 v_tex_pos;void main() {vec4 color=texture(u_texture,v_tex_pos);glFragColor=vec4(floor(255.0*color*u_opacity)/255.0);}","in vec2 a_pos;out vec2 v_tex_pos;void main() {vec2 uv=0.5*a_pos+vec2(0.5);v_tex_pos=uv;gl_Position=vec4(a_pos,0.0,1.0);}"),rasterParticleUpdate:At('#include "_prelude_raster_particle.glsl"\nuniform sampler2D u_particle_texture;uniform mediump float u_particle_texture_side_len;uniform mediump float u_speed_factor;uniform highp float u_reset_rate;uniform highp float u_rand_seed;in highp vec2 v_tex_coord;vec2 linearstep(vec2 edge0,vec2 edge1,vec2 x) {return  clamp((x-edge0)/(edge1-edge0),vec2(0),vec2(1));}const highp vec3 rand_constants=vec3(12.9898,78.233,4375.85453);highp float rand(const highp vec2 co) {highp float t=dot(rand_constants.xy,co);return fract(sin(t)*(rand_constants.z+t));}void main() {ivec2 pixel_coord=ivec2(v_tex_coord*u_particle_texture_side_len);highp vec4 pixel=texelFetch(u_particle_texture,pixel_coord,0);highp vec2 pos=unpack_pos_from_rgba(pixel);highp vec2 velocity=lookup_velocity(clamp(pos,0.0,1.0));highp vec2 dp=velocity==INVALID_VELOCITY ? vec2(0) : velocity*u_speed_factor;pos=pos+dp;highp vec2 seed=(pos+v_tex_coord)*u_rand_seed;highp vec2 random_pos=vec2(rand(seed+1.3),rand(seed+2.1));highp vec2 persist_rate=pow(\nlinearstep(vec2(-u_particle_pos_offset),vec2(0),pos)*linearstep(vec2(1.0+u_particle_pos_offset),vec2(1),pos),vec2(4)\n);highp vec2 per_frame_persist=pow(persist_rate,abs(dp)/u_particle_pos_offset);highp float drop_rate=1.0-per_frame_persist.x*per_frame_persist.y;drop_rate=any(greaterThanEqual(abs(pos-0.5),vec2(0.5+u_particle_pos_offset))) ? 1.0 : drop_rate;highp float drop=step(1.0-drop_rate-u_reset_rate,rand(seed));highp vec2 next_pos=mix(pos,random_pos,drop);glFragColor=pack_pos_to_rgba(next_pos);}',"in vec2 a_pos;out vec2 v_tex_coord;void main() {v_tex_coord=0.5*(a_pos+vec2(1.0));gl_Position=vec4(a_pos,0.0,1.0);}"),symbolIcon:At('#include "_prelude_lighting.glsl"\nuniform sampler2D u_texture;\n#ifdef ICON_TRANSITION\nuniform float u_icon_transition;\n#endif\nin float v_fade_opacity;in vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nin vec2 v_tex_b;\n#endif\n#ifdef COLOR_ADJUSTMENT\nuniform mat4 u_color_adj_mat;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\nlowp float alpha=opacity*v_fade_opacity;vec4 out_color;\n#ifdef ICON_TRANSITION\nvec4 a=texture(u_texture,v_tex_a)*(1.0-u_icon_transition);vec4 b=texture(u_texture,v_tex_b)*u_icon_transition;out_color=(a+b);\n#else\nout_color=texture(u_texture,v_tex_a);\n#endif\n#ifdef COLOR_ADJUSTMENT\nout_color=u_color_adj_mat*out_color;\n#endif\nout_color*=alpha;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nin vec4 a_pos_offset;in vec4 a_tex_size;in vec4 a_pixeloffset;in vec4 a_projected_pos;in float a_fade_opacity;\n#ifdef OCCLUSION_QUERIES\nin float a_occlusion_query_opacity;\n#endif\n#ifdef Z_OFFSET\nin float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_globe_anchor;in vec3 a_globe_normal;\n#endif\n#ifdef ICON_TRANSITION\nin vec2 a_texb;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nout vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nout vec2 v_tex_b;\n#endif\nout float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\n#pragma mapbox: define lowp float occlusion_opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\n#pragma mapbox: initialize lowp float occlusion_opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_min_font_scale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;vec3 world_pos_globe;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos_globe=a_globe_anchor+h;world_pos=mix_globe_mercator(world_pos_globe,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjected_point;vec2 a;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetProjected_point=u_matrix*vec4(a_globe_anchor+displacement,1);vec4 projected_point_globe=u_matrix*vec4(world_pos_globe,1);a=projected_point_globe.xy/projected_point_globe.w;\n#else\noffsetProjected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);a=projected_point.xy/projected_point.w;\n#endif\nvec2 b=offsetProjected_point.xy/offsetProjected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_min_font_scale,font_scale)+a_pxoffset/16.0);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=globe_occlusion_fade;\n#ifdef SYMBOL_OCCLUSION_BY_TERRAIN_DEPTH\nocclusion_fade*=occlusionFade(projected_point);\n#endif\nfloat projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float out_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;float alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nv_tex_a=a_tex/u_texsize;\n#ifdef ICON_TRANSITION\nv_tex_b=a_texb/u_texsize;\n#endif\nv_fade_opacity=out_fade_opacity;\n#ifdef OCCLUSION_QUERIES\nfloat occludedFadeMultiplier=mix(occlusion_opacity,1.0,a_occlusion_query_opacity);v_fade_opacity*=occludedFadeMultiplier;\n#endif\n}'),symbolSDF:At('#include "_prelude_lighting.glsl"\n#define SDF_PX 8.0\nuniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;uniform bool u_is_halo;in float v_draw_halo;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;bool draw_halo=v_draw_halo > 0.0;if (draw_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).r;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);vec4 out_color=color*(alpha*opacity*fade_opacity);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nin vec4 a_pos_offset;in vec4 a_tex_size;in vec4 a_pixeloffset;in vec4 a_projected_pos;in float a_fade_opacity;\n#ifdef Z_OFFSET\nin float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_globe_anchor;in vec3 a_globe_normal;\n#endif\n#ifdef OCCLUSION_QUERIES\nin float a_occlusion_query_opacity;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform bool u_is_halo;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nout float v_draw_halo;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\n#pragma mapbox: define lowp float occlusion_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\n#pragma mapbox: initialize lowp float occlusion_opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;vec3 world_pos_globe;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos_globe=a_globe_anchor+h;world_pos=mix_globe_mercator(world_pos_globe,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetprojected_point;vec2 a;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetprojected_point=u_matrix*vec4(a_globe_anchor+displacement,1);vec4 projected_point_globe=u_matrix*vec4(world_pos_globe,1);a=projected_point_globe.xy/projected_point_globe.w;\n#else\noffsetprojected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);a=projected_point.xy/projected_point.w;\n#endif\nvec2 b=offsetprojected_point.xy/offsetprojected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=globe_occlusion_fade;\n#ifdef SYMBOL_OCCLUSION_BY_TERRAIN_DEPTH\nocclusion_fade*=occlusionFade(projected_point);\n#endif\nfloat projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float out_fade_opacity=interpolated_fade_opacity*projection_transition_fade;\n#ifdef OCCLUSION_QUERIES\nfloat occludedFadeMultiplier=mix(occlusion_opacity,1.0,a_occlusion_query_opacity);out_fade_opacity*=occludedFadeMultiplier;\n#endif\nfloat alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nfloat gamma_scale=gl_Position.w;v_draw_halo=(u_is_halo && float(gl_InstanceID)==0.0) ? 1.0 : 0.0;v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,out_fade_opacity);}'),symbolTextAndIcon:At('#include "_prelude_lighting.glsl"\n#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_halo;in float v_draw_halo;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;glFragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;bool draw_halo=v_draw_halo > 0.0;if (draw_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).r;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);vec4 out_color=color*(alpha*opacity*fade_opacity);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\nglFragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nin vec4 a_pos_offset;in vec4 a_tex_size;in vec4 a_projected_pos;in float a_fade_opacity;\n#ifdef OCCLUSION_QUERIES\nin float a_occlusion_query_opacity;\n#endif\n#ifdef Z_OFFSET\nin float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nin vec3 a_globe_anchor;in vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform vec2 u_texsize_icon;uniform bool u_is_halo;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nout float v_draw_halo;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\n#pragma mapbox: define lowp float occlusion_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\n#pragma mapbox: initialize lowp float occlusion_opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offset_projected_point=u_matrix*vec4(a_pos+vec2(1,0),0,1);vec2 a=projected_point.xy/projected_point.w;vec2 b=offset_projected_point.xy/offset_projected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*font_scale);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=globe_occlusion_fade;\n#ifdef SYMBOL_OCCLUSION_BY_TERRAIN_DEPTH\nocclusion_fade*=occlusionFade(projected_point);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nfloat out_fade_opacity=interpolated_fade_opacity*projection_transition_fade;\n#ifdef OCCLUSION_QUERIES\nfloat occludedFadeMultiplier=mix(occlusion_opacity,1.0,a_occlusion_query_opacity);out_fade_opacity*=occludedFadeMultiplier;\n#endif\nfloat alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+ xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nfloat gamma_scale=gl_Position.w;v_draw_halo=(u_is_halo && float(gl_InstanceID)==0.0) ? 1.0 : 0.0;v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,out_fade_opacity,is_sdf);}'),terrainRaster:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image0;in vec2 v_pos0;\n#ifdef FOG\nin float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nin vec4 v_pos_light_view_0;in vec4 v_pos_light_view_1;\n#endif\nuniform vec3 u_ground_shadow_factor;void main() {vec4 image_color=texture(u_image0,v_pos0);vec4 color;\n#ifdef LIGHTING_3D_MODE\nconst vec3 normal=vec3(0.0,0.0,1.0);\n#ifdef RENDER_SHADOWS\nfloat cutoffOpacity=1.0;\n#ifdef RENDER_CUTOFF\ncutoffOpacity=cutoff_opacity(u_cutoff_params,1.0/gl_FragCoord.w);\n#endif\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\nvec3 unlit_base=image_color.rgb*(1.0-image_color.a);vec3 emissive_base=image_color.rgb*image_color.a;float ndotl=u_shadow_direction.z;float occlusion=ndotl < 0.0 ? 1.0 : shadow_occlusion(v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w,0.0);ndotl=max(0.0,ndotl);vec3 lit=apply_lighting(unlit_base,normal,mix(1.0,(1.0-(u_shadow_intensity*occlusion))*ndotl,cutoffOpacity));vec3 emissive=compute_emissive_draped(emissive_base,1.0-u_shadow_intensity,occlusion,u_ground_shadow_factor);color.rgb=lit+emissive;color.a=1.0;\n#else\nfloat lighting_factor=shadowed_light_factor_normal_unbiased(normal,v_pos_light_view_0,v_pos_light_view_1,1.0/gl_FragCoord.w);color=apply_lighting(image_color,normal,mix(1.0,lighting_factor,cutoffOpacity));\n#endif\n#else\nfloat lighting_factor=u_lighting_directional_dir.z;color=apply_lighting(image_color,normal,lighting_factor);\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\ncolor.rgb=mix(color.rgb,image_color.rgb,image_color.a);color.a=1.0;\n#endif\n#endif\n#else\ncolor=image_color;\n#endif\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#else\ncolor=fog_dither(fog_apply_from_vert(color,v_fog_opacity));\n#endif\n#endif\nglFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_skirt_height;in vec2 a_pos;out vec2 v_pos0;\n#ifdef FOG\nout float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;out vec4 v_pos_light_view_0;out vec4 v_pos_light_view_1;out float v_depth;\n#endif\nvoid main() {vec3 decomposedPosAndSkirt=decomposeToPosAndSkirt(a_pos);float skirt=decomposedPosAndSkirt.z;vec2 decodedPos=decomposedPosAndSkirt.xy;float elevation=elevation(decodedPos)-skirt*u_skirt_height;v_pos0=decodedPos/8192.0;gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\nv_fog_pos=fog_position(decodedPos);\n#else\nv_fog_opacity=fog(fog_position(vec3(decodedPos,elevation)));\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec3 pos=vec3(decodedPos,elevation);v_pos_light_view_0=u_light_matrix_0*vec4(pos,1.);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1.);\n#endif\n}'),terrainDepth:At("precision highp float;in float v_depth;void main() {glFragColor=pack_depth(v_depth);}",'#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;in vec2 a_pos;out float v_depth;void main() {float elevation=elevation(a_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}'),skybox:At('#include "_prelude_fog.fragment.glsl"\nin lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=texture(u_cubemap,uv).rgb;\n#ifdef FOG\nsky_color=fog_apply_sky_gradient(v_uv.xzy,sky_color);\n#endif\nsky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);glFragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\n}',ft),skyboxGradient:At('#include "_prelude_fog.fragment.glsl"\nin highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform highp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture(u_color_ramp,vec2(progress,0.5));\n#ifdef FOG\ncolor.rgb=fog_apply_sky_gradient(v_uv.xzy,color.rgb/color.a)*color.a;\n#endif\ncolor*=u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);glFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\n}',ft),skyboxCapture:At("\nin highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;precision highp float;\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;glFragColor=vec4(color,1.0);}","in highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;out highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}"),globeRaster:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image0;uniform float u_far_z_cutoff;in vec2 v_pos0;\n#ifndef FOG\nuniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform vec2 u_viewport;\n#endif\nvoid main() {vec4 color;\n#ifdef CUSTOM_ANTIALIASING\nvec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);vec3 dir=normalize(ray_dir);vec3 closest_point=dot(u_globe_pos,dir)*dir;float norm_dist_from_center=1.0-length(closest_point-u_globe_pos)/u_globe_radius;const float antialias_pixel=2.0;float antialias_factor=antialias_pixel*fwidth(norm_dist_from_center);float antialias=smoothstep(0.0,antialias_factor,norm_dist_from_center);vec4 raster=texture(u_image0,v_pos0);\n#ifdef LIGHTING_3D_MODE\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\nraster=apply_lighting_with_emission_ground(raster,raster.a);color=vec4(raster.rgb*antialias,antialias);\n#else\nraster=apply_lighting_ground(raster);color=vec4(raster.rgb*antialias,raster.a*antialias);\n#endif\n#else\ncolor=vec4(raster.rgb*antialias,raster.a*antialias);\n#endif\n#else\ncolor=texture(u_image0,v_pos0);\n#ifdef LIGHTING_3D_MODE\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\ncolor=apply_lighting_with_emission_ground(color,color.a);color.a=1.0;\n#else\ncolor=apply_lighting_ground(color);\n#endif\n#endif\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ncolor*=1.0-step(u_far_z_cutoff,1.0/gl_FragCoord.w);glFragColor=color;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_proj_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform float u_zoom_transition;uniform vec2 u_merc_center;uniform mat3 u_grid_matrix;uniform float u_skirt_height;\n#ifdef GLOBE_POLES\nin vec3 a_globe_pos;in vec2 a_uv;\n#else\nin vec2 a_pos;\n#endif\nout vec2 v_pos0;void main() {\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;vec2 uv=a_uv;\n#else\nfloat tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];vec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float uvY=mercatorY*tiles-idy;float mercatorX=mercatorXfromLng(latLng[1]);float uvX=mercatorX*tiles-idx;vec3 globe_pos=latLngToECEF(latLng.xy);vec2 merc_pos=vec2(mercatorX,mercatorY);vec2 uv=vec2(uvX,uvY);\n#endif\nv_pos0=uv;vec2 tile_pos=uv*EXTENT;vec3 globe_derived_up_vector=normalize(globe_pos)*u_tile_up_scale;\n#ifdef GLOBE_POLES\nvec3 up_vector=globe_derived_up_vector;\n#else\nvec3 up_vector=elevationVector(tile_pos);\n#endif\nfloat height=elevation(tile_pos);globe_pos+=up_vector*height;\n#ifndef GLOBE_POLES\nglobe_pos-=globe_derived_up_vector*u_skirt_height*decomposed_pos_and_skirt.z;\n#endif\n#ifdef GLOBE_POLES\nvec4 interpolated_pos=u_globe_matrix*vec4(globe_pos,1.0);\n#else\nvec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {merc_world_pos=vec4(merc_pos,height-u_skirt_height*decomposed_pos_and_skirt.z,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition),1.0);\n#endif\ngl_Position=u_proj_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n}'),globeAtmosphere:At('#include "_prelude_fog.fragment.glsl"\nuniform float u_transition;uniform highp float u_fadeout_range;uniform highp float u_temporal_offset;uniform vec4 u_color;uniform vec4 u_high_color;uniform vec4 u_space_color;uniform float u_horizon_angle;in highp vec3 v_ray_dir;in highp vec3 v_horizon_dir;void main() {highp vec3 dir=normalize(v_ray_dir);float globe_pos_dot_dir;\n#ifdef PROJECTION_GLOBE_VIEW\nglobe_pos_dot_dir=dot(u_globe_pos,dir);highp vec3 closest_point_forward=abs(globe_pos_dot_dir)*dir;float norm_dist_from_center=length(closest_point_forward-u_globe_pos)/u_globe_radius;if (norm_dist_from_center < 0.98) {\n#ifdef ALPHA_PASS\nglFragColor=vec4(0,0,0,0);return;\n#else\n#ifdef NATIVE\nglFragColor=vec4(1,1,1,1);\n#else\nglFragColor=vec4(0,0,0,1);\n#endif\nreturn;\n#endif\n}\n#endif\nhighp vec3 horizon_dir=normalize(v_horizon_dir);float horizon_angle_mercator=dir.y < horizon_dir.y ?\n0.0 : max(acos(clamp(dot(dir,horizon_dir),-1.0,1.0)),0.0);float horizon_angle;\n#ifdef PROJECTION_GLOBE_VIEW\nhighp vec3 closest_point=globe_pos_dot_dir*dir;highp float closest_point_to_center=length(closest_point-u_globe_pos);highp float theta=asin(clamp(closest_point_to_center/length(u_globe_pos),-1.0,1.0));horizon_angle=globe_pos_dot_dir < 0.0 ?\nPI-theta-u_horizon_angle : theta-u_horizon_angle;float angle_t=pow(u_transition,10.0);horizon_angle=mix(horizon_angle,horizon_angle_mercator,angle_t);\n#else\nhorizon_angle=horizon_angle_mercator;\n#endif\nhorizon_angle/=PI;float t=exp(-horizon_angle/u_fadeout_range);float alpha_0=u_color.a;float alpha_1=u_high_color.a;float alpha_2=u_space_color.a;vec3 color_stop_0=u_color.rgb;vec3 color_stop_1=u_high_color.rgb;vec3 color_stop_2=u_space_color.rgb;\n#ifdef ALPHA_PASS\nfloat a0=mix(alpha_2,1.0,alpha_1);float a1=mix(a0,1.0,alpha_0);float a2=mix(a0,a1,t);float a =mix(alpha_2,a2,t);glFragColor=vec4(1.0,1.0,1.0,a);\n#else\nvec3 c0=mix(color_stop_2,color_stop_1,alpha_1);vec3 c1=mix(c0,color_stop_0,alpha_0);vec3 c2=mix(c0,c1,t);vec3 c=c2;\n#ifndef NATIVE\nc=dither(c,gl_FragCoord.xy+u_temporal_offset);\n#endif\nglFragColor=vec4(c*t,t);\n#endif\n}',"in vec3 a_pos;in vec2 a_uv;uniform vec3 u_frustum_tl;uniform vec3 u_frustum_tr;uniform vec3 u_frustum_br;uniform vec3 u_frustum_bl;uniform float u_horizon;out highp vec3 v_ray_dir;out highp vec3 v_horizon_dir;void main() {v_ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,a_uv.x),mix(u_frustum_bl,u_frustum_br,a_uv.x),a_uv.y);v_horizon_dir=mix(\nmix(u_frustum_tl,u_frustum_bl,u_horizon),mix(u_frustum_tr,u_frustum_br,u_horizon),a_uv.x);gl_Position=vec4(a_pos,1.0);}"),model:At('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform float u_opacity;uniform vec3 u_lightcolor;uniform vec3 u_lightpos;uniform float u_lightintensity;uniform vec4 u_baseColorFactor;uniform vec4 u_emissiveFactor;uniform float u_metallicFactor;uniform float u_roughnessFactor;uniform float u_emissive_strength;in highp vec4 v_position_height;in lowp vec4 v_color_mix;\n#ifdef RENDER_SHADOWS\nin vec4 v_pos_light_view_0;in vec4 v_pos_light_view_1;in float v_depth_shadows;\n#endif\n#ifdef OCCLUSION_TEXTURE_TRANSFORM\nuniform vec4 u_occlusionTextureTransform;\n#endif\n#pragma mapbox: define-attribute highp vec3 normal_3f\n#pragma mapbox: define-attribute highp vec3 color_3f\n#pragma mapbox: define-attribute highp vec4 color_4f\n#pragma mapbox: define-attribute highp vec2 uv_2f\n#pragma mapbox: initialize-attribute highp vec3 normal_3f\n#pragma mapbox: initialize-attribute highp vec3 color_3f\n#pragma mapbox: initialize-attribute highp vec4 color_4f\n#pragma mapbox: initialize-attribute highp vec2 uv_2f\n#ifdef HAS_ATTRIBUTE_a_pbr\nin lowp vec4 v_roughness_metallic_emissive_alpha;in mediump vec4 v_height_based_emission_params;\n#endif\n#ifdef HAS_TEXTURE_u_baseColorTexture\nuniform sampler2D u_baseColorTexture;uniform bool u_baseTextureIsAlpha;uniform bool u_alphaMask;uniform float u_alphaCutoff;\n#endif\n#ifdef HAS_TEXTURE_u_metallicRoughnessTexture\nuniform sampler2D u_metallicRoughnessTexture;\n#endif\n#ifdef HAS_TEXTURE_u_occlusionTexture\nuniform sampler2D u_occlusionTexture;uniform float u_aoIntensity;\n#endif\n#ifdef HAS_TEXTURE_u_normalTexture\nuniform sampler2D u_normalTexture;\n#endif\n#ifdef HAS_TEXTURE_u_emissionTexture\nuniform sampler2D u_emissionTexture;\n#endif\n#ifdef APPLY_LUT_ON_GPU\nuniform highp sampler3D u_lutTexture;\n#endif\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nin highp float v_depth;uniform highp sampler2D u_depthTexture;uniform vec2 u_inv_depth_size;uniform vec2 u_depth_range_unpack;\n#ifdef TERRAIN_DEPTH_D24\nfloat unpack_depth(float depth) {return  depth*u_depth_range_unpack.x+u_depth_range_unpack.y;}\n#else\nhighp float unpack_depth_rgba(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}\n#endif\nbool isOccluded() {vec2 coord=gl_FragCoord.xy*u_inv_depth_size;\n#ifdef TERRAIN_DEPTH_D24\nhighp float depth=unpack_depth(texture(u_depthTexture,coord).r);\n#else\nhighp float depth=unpack_depth_rgba(texture(u_depthTexture,coord));\n#endif\nreturn v_depth > depth+0.0005;}\n#endif\n#define saturate(_x) clamp(_x,0.,1.)\nvec3 linearTosRGB(vec3 color) {return pow(color,vec3(1./2.2));}vec3 sRGBToLinear(vec3 srgbIn) {return pow(srgbIn,vec3(2.2));}float calculate_NdotL(vec3 normal,vec3 lightDir) {const float ext=0.70710678118;return (clamp(dot(normal,lightDir),-ext,1.0)+ext)/(1.0+ext);}vec3 getDiffuseShadedColor(vec3 albedo,vec3 normal,vec3 lightDir,vec3 lightColor)\n{\n#ifdef LIGHTING_3D_MODE\nvec3 transformed_normal=vec3(-normal.xy,normal.z);float lighting_factor;\n#ifdef RENDER_SHADOWS\nlighting_factor=shadowed_light_factor_normal(transformed_normal,v_pos_light_view_0,v_pos_light_view_1,v_depth_shadows);\n#else\nlighting_factor=saturate(dot(transformed_normal,u_lighting_directional_dir));\n#endif\nreturn apply_lighting(albedo,transformed_normal,lighting_factor);\n#else\nvec3 n=normal;float colorvalue=((albedo.x*0.2126)+(albedo.y*0.7152))+(albedo.z*0.0722);vec3 c=vec3(0.03,0.03,0.03);float directional=clamp(dot(n,vec3(lightDir)),0.0,1.0);directional=mix(1.0-u_lightintensity,max((1.0-colorvalue)+u_lightintensity,1.0),directional);vec3 c3=c+clamp((albedo*directional)*lightColor,mix(vec3(0.0),vec3(0.3),vec3(1.0)-lightColor),vec3(1.0));return c3;\n#endif\n}vec4 getBaseColor() {vec4 albedo=u_baseColorFactor;\n#ifdef HAS_ATTRIBUTE_a_color_3f\nalbedo*=vec4(color_3f,1.0);\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\n#else\n#ifdef HAS_ATTRIBUTE_a_color_4f\nalbedo*=color_4f;\n#endif\n#endif\n#if defined (HAS_TEXTURE_u_baseColorTexture) && defined (HAS_ATTRIBUTE_a_uv_2f)\nvec4 texColor=texture(u_baseColorTexture,uv_2f);if(u_alphaMask) {if (texColor.w < u_alphaCutoff) {discard;}}\n#ifdef UNPREMULT_TEXTURE_IN_SHADER\nif(texColor.w > 0.0) {texColor.rgb/=texColor.w;}texColor.w=1.0;\n#endif\nif(u_baseTextureIsAlpha) {if (texColor.r < 0.5) {discard;}} else {texColor.rgb=sRGBToLinear(texColor.rgb);albedo*=texColor;}\n#endif\nvec4 color=vec4(mix(albedo.rgb,v_color_mix.rgb,v_color_mix.a),albedo.a);\n#ifdef APPLY_LUT_ON_GPU\ncolor=applyLUT(u_lutTexture,color);\n#endif\nreturn color;}highp mat3 cotangentFrame(highp vec3 N,highp vec3 p,highp vec2 uv ) {\n#ifdef HAS_TEXTURE_u_normalTexture\nhighp vec3 dp1=vec3(dFdx(p.x),dFdx(p.y),dFdx(p.z));highp vec3 dp2=vec3(dFdy(p.x),dFdy(p.y),dFdy(p.z));highp vec2 duv1=vec2(dFdx(uv.x),dFdx(uv.y));highp vec2 duv2=vec2(dFdy(uv.x),dFdy(uv.y));highp vec3 dp2perp=cross( dp2,N );highp vec3 dp1perp=cross( N,dp1 );highp vec3 T=dp2perp*duv1.x+dp1perp*duv2.x;highp vec3 B=dp2perp*duv1.y+dp1perp*duv2.y;highp float lengthT=dot(T,T);highp float lengthB=dot(B,B);highp float maxLength=max(lengthT,lengthB);highp float invmax=inversesqrt( maxLength );highp mat3 res=mat3( T*invmax,B*invmax,N );return res;\n#else\nreturn mat3(1.0);\n#endif\n}highp vec3 getNormal(){highp vec3 n;\n#ifdef HAS_ATTRIBUTE_a_normal_3f\nn=normalize(normal_3f);\n#else\nhighp vec3 fdx=vec3(dFdx(v_position_height.x),dFdx(v_position_height.y),dFdx(v_position_height.z));highp vec3 fdy=vec3(dFdy(v_position_height.x),dFdy(v_position_height.y),dFdy(v_position_height.z));n=normalize(cross(fdx,fdy))*-1.0;\n#endif\n#if defined(HAS_TEXTURE_u_normalTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\nvec3 nMap=texture( u_normalTexture,uv_2f).xyz;nMap=normalize(2.0*nMap-vec3(1.0));highp vec3 v=normalize(-v_position_height.xyz);highp mat3 TBN=cotangentFrame(n,v,uv_2f);n=normalize(TBN*nMap);\n#endif\nreturn n;}struct Material {float perceptualRoughness;float alphaRoughness;float metallic;vec3 f90;vec4 baseColor;vec3 diffuseColor;vec3 specularColor;highp vec3 normal;};Material getPBRMaterial() {Material mat;mat.baseColor=getBaseColor();mat.perceptualRoughness=u_roughnessFactor;mat.metallic=u_metallicFactor;\n#ifdef HAS_ATTRIBUTE_a_pbr\nmat.perceptualRoughness=v_roughness_metallic_emissive_alpha.x;mat.metallic=v_roughness_metallic_emissive_alpha.y;mat.baseColor.w*=v_roughness_metallic_emissive_alpha.w;\n#endif\n#if defined(HAS_TEXTURE_u_metallicRoughnessTexture) && defined(HAS_ATTRIBUTE_a_uv_2f) \nvec4 mrSample=texture(u_metallicRoughnessTexture,uv_2f);mat.perceptualRoughness*=mrSample.g;mat.metallic*=mrSample.b;\n#endif\nconst float c_minRoughness=0.04;mat.perceptualRoughness=clamp(mat.perceptualRoughness,c_minRoughness,1.0);mat.metallic=saturate(mat.metallic);mat.alphaRoughness=mat.perceptualRoughness*mat.perceptualRoughness;const vec3 f0=vec3(0.04);mat.diffuseColor=mat.baseColor.rgb*(vec3(1.0)-f0);mat.diffuseColor*=1.0-mat.metallic;mat.specularColor=mix(f0,mat.baseColor.rgb,mat.metallic);highp float reflectance=max(max(mat.specularColor.r,mat.specularColor.g),mat.specularColor.b);highp float reflectance90=saturate(reflectance*25.0);mat.f90=vec3(reflectance90);mat.normal=getNormal();return mat;}float V_GGX(float NdotL,float NdotV,float roughness)\n{float a2=roughness*roughness;float GGXV=NdotL*sqrt(NdotV*NdotV*(1.0-a2)+a2);float GGXL=NdotV*sqrt(NdotL*NdotL*(1.0-a2)+a2);return 0.5/(GGXV+GGXL);}float V_GGXFast(float NdotL,float NdotV,float roughness) {float a=roughness;float GGXV=NdotL*(NdotV*(1.0-a)+a);float GGXL=NdotV*(NdotL*(1.0-a)+a);return 0.5/(GGXV+GGXL);}vec3 F_Schlick(vec3 specularColor,vec3 f90,float VdotH)\n{return specularColor+(f90-specularColor)*pow(clamp(1.0-VdotH,0.0,1.0),5.0);}vec3 F_SchlickFast(vec3 specularColor,float VdotH)\n{float x=1.0-VdotH;float x4=x*x*x*x;return specularColor+(1.0-specularColor)*x4*x;}float D_GGX(highp float NdotH,float alphaRoughness)\n{highp float a4=alphaRoughness*alphaRoughness;highp float f=(NdotH*a4-NdotH)*NdotH+1.0;return a4/(PI*f*f);}vec3 diffuseBurley(Material mat,float LdotH,float NdotL,float NdotV)\n{float f90=2.0*LdotH*LdotH*mat.alphaRoughness-0.5;return (mat.diffuseColor/PI)*(1.0+f90*pow((1.0-NdotL),5.0))*(1.0+f90*pow((1.0-NdotV),5.0));}vec3 diffuseLambertian(Material mat)\n{\n#ifdef LIGHTING_3D_MODE\nreturn mat.diffuseColor;\n#else\nreturn mat.diffuseColor/PI;\n#endif\n}vec3 EnvBRDFApprox(vec3 specularColor,float roughness,highp float NdotV)\n{vec4 c0=vec4(-1,-0.0275,-0.572,0.022);vec4 c1=vec4(1,0.0425,1.04,-0.04);highp vec4 r=roughness*c0+c1;highp float a004=min(r.x*r.x,exp2(-9.28*NdotV))*r.x+r.y;vec2 AB=vec2(-1.04,1.04)*a004+r.zw;return specularColor*AB.x+AB.y;}vec3 computeIndirectLightContribution(Material mat,float NdotV,vec3 normal)\n{vec3 env_light=vec3(0.65,0.65,0.65);\n#ifdef LIGHTING_3D_MODE\nfloat ambient_factor=calculate_ambient_directional_factor(normal);env_light=u_lighting_ambient_color*ambient_factor;\n#endif\nvec3 envBRDF=EnvBRDFApprox(mat.specularColor,mat.perceptualRoughness,NdotV);vec3 indirectSpecular= envBRDF*env_light;vec3 indirectDiffuse=mat.diffuseColor*env_light;return indirectSpecular+indirectDiffuse;}vec3 computeLightContribution(Material mat,vec3 lightPosition,vec3 lightColor)\n{highp vec3 n=mat.normal;highp vec3 v=normalize(-v_position_height.xyz);highp vec3 l=normalize(lightPosition);highp vec3 h=normalize(v+l);float NdotV=clamp(abs(dot(n,v)),0.001,1.0);float NdotL=saturate(dot(n,l));highp float NdotH=saturate(dot(n,h));float VdotH=saturate(dot(v,h));vec3 f=F_SchlickFast(mat.specularColor,VdotH);float g=V_GGXFast(NdotL,NdotV,mat.alphaRoughness);float d=D_GGX(NdotH,mat.alphaRoughness);vec3 diffuseTerm=(1.0-f)*diffuseLambertian(mat);vec3 specularTerm=f*g*d;vec3 transformed_normal=vec3(-n.xy,n.z);float lighting_factor;\n#ifdef RENDER_SHADOWS\nlighting_factor=shadowed_light_factor_normal(transformed_normal,v_pos_light_view_0,v_pos_light_view_1,v_depth_shadows);\n#else\nlighting_factor=NdotL;\n#endif\nvec3 directLightColor=(specularTerm+diffuseTerm)*lighting_factor*lightColor;vec3 indirectLightColor=computeIndirectLightContribution(mat,NdotV,transformed_normal);vec3 color=(saturate(directLightColor)+indirectLightColor);float intensityFactor=1.0;\n#if !defined(LIGHTING_3D_MODE)\nconst vec3 luminosityFactor=vec3(0.2126,0.7152,0.0722);float luminance=dot(diffuseTerm,luminosityFactor);intensityFactor=mix((1.0-u_lightintensity),max((1.0-luminance+u_lightintensity),1.0),NdotL);\n#endif\ncolor*=intensityFactor;return color;}void main() {\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nif (isOccluded()) {discard;}\n#endif\nvec3 lightDir=u_lightpos;vec3 lightColor=u_lightcolor;\n#ifdef LIGHTING_3D_MODE\nlightDir=u_lighting_directional_dir;lightDir.xy=-lightDir.xy;lightColor=u_lighting_directional_color;\n#endif\nvec4 finalColor;\n#ifdef DIFFUSE_SHADED\nvec3 N=getNormal();vec3 baseColor=getBaseColor().rgb;vec3 diffuse=getDiffuseShadedColor(baseColor,N,lightDir,lightColor);\n#ifdef HAS_TEXTURE_u_occlusionTexture\nfloat ao=(texture(u_occlusionTexture,uv_2f).r-1.0)*u_aoIntensity+1.0;diffuse*=ao;\n#endif\nfinalColor=vec4(mix(diffuse,baseColor,u_emissive_strength),1.0)*u_opacity;\n#else\nMaterial mat=getPBRMaterial();vec3 color=computeLightContribution(mat,lightDir,lightColor);float ao=1.0;\n#if defined (HAS_TEXTURE_u_occlusionTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\n#ifdef OCCLUSION_TEXTURE_TRANSFORM\nvec2 uv=uv_2f.xy*u_occlusionTextureTransform.zw+u_occlusionTextureTransform.xy;\n#else\nvec2 uv=uv_2f;\n#endif\nao=(texture(u_occlusionTexture,uv).x-1.0)*u_aoIntensity+1.0;color*=ao;\n#endif\nvec4 emissive=u_emissiveFactor;\n#if defined(HAS_TEXTURE_u_emissionTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\nemissive.rgb*=sRGBToLinear(texture(u_emissionTexture,uv_2f).rgb);\n#endif\n#ifdef APPLY_LUT_ON_GPU\nfloat emissiveFactorLength=max(length(u_emissiveFactor.rgb),0.001);emissive.rgb=sRGBToLinear(applyLUT(u_lutTexture,linearTosRGB(emissive.rgb/emissiveFactorLength).rbg))*emissiveFactorLength;\n#endif\ncolor+=emissive.rgb;float opacity=mat.baseColor.w*u_opacity;\n#ifdef HAS_ATTRIBUTE_a_pbr\nfloat resEmission=v_roughness_metallic_emissive_alpha.z;resEmission*=v_height_based_emission_params.z+v_height_based_emission_params.w*pow(clamp(v_height_based_emission_params.x,0.0,1.0),v_height_based_emission_params.y);vec3 color_mix=v_color_mix.rgb;\n#ifdef APPLY_LUT_ON_GPU\ncolor_mix=applyLUT(u_lutTexture,color_mix);\n#endif\ncolor=mix(color,color_mix,min(1.0,resEmission));\n#ifdef HAS_ATTRIBUTE_a_color_4f\nfloat distance=length(vec2(1.3*max(0.0,abs(color_4f.x)-color_4f.z),color_4f.y));distance+= mix(0.5,0.0,clamp(resEmission-1.0,0.0,1.0));opacity*=v_roughness_metallic_emissive_alpha.w*saturate(1.0-distance*distance);\n#endif\n#endif\nvec3 unlitColor=mat.baseColor.rgb*ao+emissive.rgb;color=mix(color,unlitColor,u_emissive_strength);color=linearTosRGB(color);color*=opacity;finalColor=vec4(color,opacity);\n#endif\n#ifdef FOG\nfinalColor=fog_dither(fog_apply_premultiplied(finalColor,v_fog_pos,v_position_height.w));\n#endif\n#ifdef RENDER_CUTOFF\nfinalColor*=v_cutoff_opacity;\n#endif\n#ifdef INDICATOR_CUTOUT\nfinalColor=applyCutout(finalColor);\n#endif\nglFragColor=finalColor;\n#ifdef OVERDRAW_INSPECTOR\nglFragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_shadow.vertex.glsl"\nin vec3 a_pos_3f;\n#pragma mapbox: define-attribute highp vec3 normal_3f\n#pragma mapbox: define-attribute highp vec2 uv_2f\n#pragma mapbox: define-attribute highp vec3 color_3f\n#pragma mapbox: define-attribute highp vec4 color_4f\n#pragma mapbox: define-attribute-vertex-shader-only highp vec4 pbr\n#pragma mapbox: define-attribute-vertex-shader-only highp vec3 heightBasedEmissiveStrength\nuniform mat4 u_matrix;uniform mat4 u_node_matrix;uniform mat4 u_lighting_matrix;uniform vec3 u_camera_pos;uniform vec4 u_color_mix;\n#ifdef INSTANCED_ARRAYS\nin vec4 a_normal_matrix0;in vec4 a_normal_matrix1;in vec4 a_normal_matrix2;in vec4 a_normal_matrix3;\n#else\nuniform highp mat4 u_normal_matrix;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;out vec4 v_pos_light_view_0;out vec4 v_pos_light_view_1;out float v_depth_shadows;\n#endif\nout vec4 v_position_height;out lowp vec4 v_color_mix;\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nout highp float v_depth;\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\nout lowp vec4 v_roughness_metallic_emissive_alpha;out mediump vec4 v_height_based_emission_params;\n#endif\nvec3 sRGBToLinear(vec3 srgbIn) {return pow(srgbIn,vec3(2.2));}void main() {\n#pragma mapbox: initialize-attribute highp vec3 normal_3f\n#pragma mapbox: initialize-attribute highp vec2 uv_2f\n#pragma mapbox: initialize-attribute highp vec3 color_3f\n#pragma mapbox: initialize-attribute highp vec4 color_4f\n#pragma mapbox: initialize-attribute-custom highp vec4 pbr\n#pragma mapbox: initialize-attribute-custom highp vec3 heightBasedEmissiveStrength\nhighp mat4 normal_matrix;\n#ifdef INSTANCED_ARRAYS\nnormal_matrix=mat4(a_normal_matrix0,a_normal_matrix1,a_normal_matrix2,a_normal_matrix3);\n#else\nnormal_matrix=u_normal_matrix;\n#endif\nvec3 local_pos;mat3 rs;\n#ifdef MODEL_POSITION_ON_GPU\nvec3 pos_color=normal_matrix[0].xyz;vec4 translate=normal_matrix[1];vec3 pos_a=floor(pos_color);vec3 rgb=1.05*(pos_color-pos_a);float hidden=float(pos_a.x > EXTENT);float color_mix=pos_a.z/100.0;v_color_mix=vec4(sRGBToLinear(rgb),color_mix);float meter_to_tile=normal_matrix[0].w;vec4 pos=vec4(pos_a.xy,translate.z,1.0);rs[0].x=normal_matrix[1].w;rs[0].yz=normal_matrix[2].xy;rs[1].xy=normal_matrix[2].zw;rs[1].z=normal_matrix[3].x;rs[2].xyz=normal_matrix[3].yzw;vec4 pos_node=u_lighting_matrix*vec4(a_pos_3f,1.0);vec3 rotated_pos_node=rs*pos_node.xyz;vec3 pos_model_tile=(rotated_pos_node+vec3(translate.xy,0.0))*vec3(meter_to_tile,meter_to_tile,1.0);pos.xyz+=pos_model_tile;local_pos=pos.xyz;gl_Position=mix(u_matrix*pos,AWAY,hidden);pos.z*=meter_to_tile;v_position_height.xyz=pos.xyz-u_camera_pos;\n#else\nlocal_pos=a_pos_3f;gl_Position=u_matrix*vec4(a_pos_3f,1);v_position_height.xyz=vec3(u_lighting_matrix*vec4(a_pos_3f,1));v_color_mix=vec4(sRGBToLinear(u_color_mix.rgb),u_color_mix.a);\n#endif\nv_position_height.w=a_pos_3f.z;\n#ifdef HAS_ATTRIBUTE_a_pbr\nvec4 albedo_c=decode_color(pbr.xy);vec2 e_r_m=unpack_float(pbr.z);vec2 r_m= unpack_float(e_r_m.y*16.0);r_m.r=r_m.r*16.0;v_color_mix=vec4(albedo_c.rgb,1.0);v_roughness_metallic_emissive_alpha=vec4(vec3(r_m,e_r_m.x)/255.0,albedo_c.a);v_roughness_metallic_emissive_alpha.z*=2.0;float heightBasedRelativeIntepolation=a_pos_3f.z*heightBasedEmissiveStrength.x+heightBasedEmissiveStrength.y;v_height_based_emission_params.x=heightBasedRelativeIntepolation;v_height_based_emission_params.y=heightBasedEmissiveStrength.z;vec2 emissionMultiplierValues=unpack_float(pbr.w)/256.0;v_height_based_emission_params.z=emissionMultiplierValues.x;v_height_based_emission_params.w=emissionMultiplierValues.y-emissionMultiplierValues.x;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(local_pos);\n#endif\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef HAS_ATTRIBUTE_a_normal_3f\n#ifdef MODEL_POSITION_ON_GPU\nfloat x_squared_scale=dot(rs[0],rs[0]);float y_squared_scale=dot(rs[1],rs[1]);float z_squared_scale=dot(rs[2],rs[2]);vec3 squared_scale=vec3(x_squared_scale,y_squared_scale,z_squared_scale);normal_3f=rs*((u_lighting_matrix*vec4(normal_3f,0.0)).xyz/squared_scale);normal_3f=normalize(normal_3f);\n#else\nnormal_3f=vec3(normal_matrix*vec4(normal_3f,0));\n#endif\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\n#ifdef HAS_ATTRIBUTE_a_color_4f\nv_roughness_metallic_emissive_alpha.w=clamp(color_4f.a*v_roughness_metallic_emissive_alpha.w*(v_roughness_metallic_emissive_alpha.z-1.0),0.0,1.0);\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec4 shadow_pos=u_node_matrix*vec4(local_pos,1.0);\n#ifdef NORMAL_OFFSET\n#ifdef HAS_ATTRIBUTE_a_normal_3f\n#ifdef MODEL_POSITION_ON_GPU\nvec3 offset=shadow_normal_offset(vec3(-normal_3f.xy,normal_3f.z));shadow_pos.xyz+=offset*shadow_normal_offset_multiplier0();\n#else\nvec3 offset=shadow_normal_offset_model(normalize(normal_3f));shadow_pos.xyz+=offset*shadow_normal_offset_multiplier0();\n#endif\n#endif\n#endif\nv_pos_light_view_0=u_light_matrix_0*shadow_pos;v_pos_light_view_1=u_light_matrix_1*shadow_pos;v_depth_shadows=gl_Position.w;\n#endif\n}'),modelDepth:At("in highp float v_depth;void main() {\n#ifndef DEPTH_TEXTURE\nglFragColor=pack_depth(v_depth);\n#endif\n}","in vec3 a_pos_3f;uniform mat4 u_matrix;out highp float v_depth;\n#ifdef MODEL_POSITION_ON_GPU\n#ifdef INSTANCED_ARRAYS\nin vec4 a_normal_matrix0;in vec4 a_normal_matrix1;in vec4 a_normal_matrix2;in vec4 a_normal_matrix3;\n#else\nuniform highp mat4 u_instance;\n#endif\nuniform highp mat4 u_node_matrix;\n#endif\nvoid main() {\n#ifdef MODEL_POSITION_ON_GPU\nhighp mat4 instance;\n#ifdef INSTANCED_ARRAYS\ninstance=mat4(a_normal_matrix0,a_normal_matrix1,a_normal_matrix2,a_normal_matrix3);\n#else\ninstance=u_instance;\n#endif\nvec3 pos_color=instance[0].xyz;vec4 translate=instance[1];vec3 pos_a=floor(pos_color);float hidden=float(pos_a.x > EXTENT);float meter_to_tile=instance[0].w;vec4 pos=vec4(pos_a.xy,translate.z,1.0);mat3 rs;rs[0].x=instance[1].w;rs[0].yz=instance[2].xy;rs[1].xy=instance[2].zw;rs[1].z=instance[3].x;rs[2].xyz=instance[3].yzw;vec4 pos_node=u_node_matrix*vec4(a_pos_3f,1.0);vec3 rotated_pos_node=rs*pos_node.xyz;vec3 pos_model_tile=(rotated_pos_node+vec3(translate.xy,0.0))*vec3(meter_to_tile,meter_to_tile,1.0);pos.xyz+=pos_model_tile;gl_Position=mix(u_matrix*pos,AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(a_pos_3f,1);\n#endif\nv_depth=gl_Position.z/gl_Position.w;}"),stars:At("in highp vec2 v_uv;in mediump float v_intensity;float shapeCircle(in vec2 uv)\n{float beginFade=0.6;float lengthFromCenter=length(v_uv);return 1.0-clamp((lengthFromCenter-beginFade)/(1.0-beginFade),0.0,1.0);}void main() {float alpha=shapeCircle(v_uv);vec3 color=vec3(1.0,1.0,1.0);alpha*=v_intensity;glFragColor=vec4(color*alpha,alpha);HANDLE_WIREFRAME_DEBUG;}","\nin vec3 a_pos_3f;in vec2 a_uv;in float a_size_scale;in float a_fade_opacity;uniform mat4 u_matrix;uniform vec3 u_up;uniform vec3 u_right;uniform float u_intensity_multiplier;out highp vec2 v_uv;out mediump float v_intensity;void main() {v_uv=a_uv;v_intensity=a_fade_opacity*u_intensity_multiplier;vec3 pos=a_pos_3f;pos+=a_uv.x*u_right*a_size_scale;pos+=a_uv.y*u_up*a_size_scale;gl_Position=u_matrix*vec4(pos,1.0);}"),occlusion:At("uniform vec4 u_color;void main() {glFragColor=u_color;}",'#include "_prelude_terrain.vertex.glsl"\nin highp vec2 a_offset_xy;uniform highp vec3 u_anchorPos;uniform mat4 u_matrix;uniform vec2 u_screenSizePx;uniform vec2 u_occluderSizePx;void main() {vec3 world_pos=u_anchorPos;\n#ifdef TERRAIN\nfloat e=elevation(world_pos.xy);world_pos.z+=e;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1.0);projected_point.xy+=projected_point.w*a_offset_xy*0.5*u_occluderSizePx/u_screenSizePx;gl_Position=projected_point;}')};function Pt(e,t){const i=e.replace(/\s*\/\/[^\n]*\n/g,"\n").split("\n");for(let e of i)if(e=e.trim(),"#"===e[0]&&e.includes("if")&&!e.includes("endif")){e=e.replace("#","").replace(/ifdef|ifndef|elif|if/g,"").replace(/!|defined|\(|\)|\|\||&&/g,"").replace(/\s+/g," ").trim();const i=e.split(" ");for(const e of i)t.includes(e)||t.push(e);}}function At(e,t){const i=/#include\s+"([^"]+)"/g,o=/#pragma mapbox: ([\w\-]+) ([\w]+) ([\w]+) ([\w]+)/g;let r=t.match(/(attribute(\S*)|(^\s*|;)in) (highp |mediump |lowp )?([\w]+) ([\w]+)/gm);r&&(r=r.map((e=>{const t=e.split(" ");return t[t.length-1]})),r=[...new Set(r)]);const a={},n=[],s=[];if(e=e.replace(i,((e,t)=>(s.push(t),""))),(t=t.replace(i,((e,t)=>(n.push(t),"")))).includes("flat out"))return void console.error('The usage of "flat" qualifier is disallowed, see: https://bugs.webkit.org/show_bug.cgi?id=268071');let l=[...Tt];Pt(e,l),Pt(t,l);for(const e of [...n,...s])Et[e]||console.error(`Undefined include: ${e}`),Ct[e]||(Ct[e]=[],Pt(Et[e],Ct[e])),l=[...l,...Ct[e]];return {fragmentSource:e=e.replace(o,((e,t,i,o,r)=>(a[r]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nin ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"initialize"===t?`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:"define-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${r}\n    in ${i} ${o} ${r};\n#endif\n`:"initialize-attribute"===t?"":void 0))),vertexSource:t=t.replace(o,((e,t,i,o,r)=>{const n="float"===o?"vec2":o,s=r.match(/color/)?"color":n;return "define-attribute-vertex-shader-only"===t?`\n#ifdef HAS_ATTRIBUTE_a_${r}\nin ${i} ${o} a_${r};\n#endif\n`:a[r]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${n} a_${r};\nout ${i} ${o} ${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"initialize"===t?"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:"define-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${r}\n    in ${i} ${o} a_${r};\n    out ${i} ${o} ${r};\n#endif\n`:"initialize-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${r}\n    ${r} = a_${r};\n#endif\n`:void 0:"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${n} a_${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"define-instanced"===t?"mat4"===s?`\n#ifdef INSTANCED_ARRAYS\nin vec4 a_${r}0;\nin vec4 a_${r}1;\nin vec4 a_${r}2;\nin vec4 a_${r}3;\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:`\n#ifdef INSTANCED_ARRAYS\nin ${i} ${n} a_${r};\n#else\nuniform ${i} ${o} u_${r};\n#endif\n`:"initialize-attribute-custom"===t?`\n#ifdef HAS_ATTRIBUTE_a_${r}\n    ${i} ${o} ${r} = a_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = a_${r};\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${o} ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${o} ${r} = u_${r};\n#endif\n`})),staticAttributes:r,usedDefines:l,vertexIncludes:n,fragmentIncludes:s}}class Rt{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffers=[],this.vao=null;}bind(e,t,i,o,r,a,n,s){this.context=e;let l=this.boundPaintVertexBuffers.length!==o.length;for(let e=0;!l&&e<o.length;e++)this.boundPaintVertexBuffers[e]!==o[e]&&(l=!0);let c=this.boundDynamicVertexBuffers.length!==n.length;for(let e=0;!c&&e<n.length;e++)this.boundDynamicVertexBuffers[e]!==n[e]&&(c=!0);if(!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||l||c||this.boundIndexBuffer!==r||this.boundVertexOffset!==a)this.freshBind(t,i,o,r,a,n,s);else {e.bindVertexArrayOES.set(this.vao);for(const i of n)i&&(i.bind(),s&&i.instanceCount&&i.setVertexAttribDivisor(e.gl,t,s));r&&r.dynamicDraw&&r.bind();}}freshBind(e,t,i,o,r,a,n){const s=e.numAttributes,l=this.context,c=l.gl;this.vao&&this.destroy(),this.vao=l.gl.createVertexArray(),l.bindVertexArrayOES.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=r,this.boundDynamicVertexBuffers=a,t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r);for(const t of i)t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r);for(const t of a)t&&(t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r),n&&t.instanceCount&&t.setVertexAttribDivisor(c,e,n));o&&o.bind(),l.currentNumAttributes=s;}destroy(){this.vao&&(this.context.gl.deleteVertexArray(this.vao),this.vao=null);}}function Dt(t,i){const o=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new e.Y(0,r/o).toLngLat().lat,new e.Y(0,(r+1)/o).toLngLat().lat]}function Mt(t,i,o,r,a,n,s){const l=t.context,c=l.gl,h=o.hillshadeFBO;if(!h)return;t.prepareDrawTile();const _=t.isTileAffectedByFog(i),u=t.getOrCreateProgram("hillshade",{overrideFog:_});l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const d=((t,i,o,r)=>{const a=o.paint.get("hillshade-shadow-color"),n=o.paint.get("hillshade-highlight-color"),s=o.paint.get("hillshade-accent-color"),l=o.paint.get("hillshade-emissive-strength");let c=e.ab(o.paint.get("hillshade-illumination-direction"));if("viewport"===o.paint.get("hillshade-illumination-anchor"))c-=t.transform.angle;else if(t.style&&t.style.enable3dLights()&&t.style.directionalLight){const i=t.style.directionalLight.properties.get("direction"),o=e.ac(i.x,i.y,i.z);c=e.ab(o[1]);}const h=!t.options.moving;return {u_matrix:r||t.transform.calculateProjMatrix(i.tileID.toUnwrapped(),h),u_image:0,u_latrange:Dt(0,i.tileID),u_light:[o.paint.get("hillshade-exaggeration"),c],u_shadow:a.toRenderColor(o.lut),u_highlight:n.toRenderColor(o.lut),u_emissive_strength:l,u_accent:s.toRenderColor(o.lut)}})(t,o,r,t.terrain?i.projMatrix:null);t.uploadCommonUniforms(l,u,i.toUnwrapped());const{tileBoundsBuffer:p,tileBoundsIndexBuffer:f,tileBoundsSegments:m}=t.getTileBoundsBuffers(o);u.draw(t,c.TRIANGLES,a,n,s,e.af.disabled,d,r.id,p,f,m);}function zt(t,i,o){if(!i.needsDEMTextureUpload)return;const r=t.context,a=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(o.stride);const n=o.getPixels();i.demTexture?i.demTexture.update(n,{premultiply:!1}):i.demTexture=new e.T(r,n,a.R32F,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function Ot(t,i,o){const r=t.context,a=r.gl;if(!i.dem)return;const n=i.dem;if(r.activeTexture.set(a.TEXTURE1),zt(t,i,n),!i.demTexture)return;i.demTexture.bind(a.NEAREST,a.CLAMP_TO_EDGE);const s=n.dim;r.activeTexture.set(a.TEXTURE0);let l=i.hillshadeFBO;if(!l){const t=new e.T(r,{width:s,height:s,data:null},a.RGBA);t.bind(a.LINEAR,a.CLAMP_TO_EDGE),l=i.hillshadeFBO=r.createFramebuffer(s,s,!0,"renderbuffer"),l.colorAttachment.set(t.texture);}r.bindFramebuffer.set(l.framebuffer),r.viewport.set([0,0,s,s]);const{tileBoundsBuffer:c,tileBoundsIndexBuffer:h,tileBoundsSegments:_}=t.getMercatorTileBoundsBuffers(),u=[];t.linearFloatFilteringSupported()&&u.push("TERRAIN_DEM_FLOAT_FORMAT"),t.getOrCreateProgram("hillshadePrepare",{defines:u}).draw(t,a.TRIANGLES,e.ae.disabled,e.ag.disabled,e.a.unblended,e.af.disabled,((t,i)=>{const o=i.stride,r=e.ad.create();return e.ad.ortho(r,0,e.a3,-e.a3,0,0,1),e.ad.translate(r,r,[0,-e.a3,0]),{u_matrix:r,u_image:1,u_dimension:[o,o],u_zoom:t.overscaledZ}})(i.tileID,n),o.id,c,h,_),i.needsHillshadePrepare=!1;}function Ft(t,i,o,r,a){const n=function(o,r){if(o)return a(o);if(r){if(t.url&&r.tiles&&t.tiles&&delete t.tiles,r.variants){if(!Array.isArray(r.variants))return a(new Error("variants must be an array"));for(const t of r.variants){if(null==t||"object"!=typeof t||t.constructor!==Object)return a(new Error("variant must be an object"));if(!Array.isArray(t.capabilities))return a(new Error("capabilities must be an array"));if(1===t.capabilities.length&&"meshopt"===t.capabilities[0]){r=e.W(r,t);break}}}const o=e.ah(e.W(r,t),["tilejson","tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(o.vectorLayers=r.vector_layers,o.vectorLayerIds=o.vectorLayers.map((e=>e.id))),r.raster_layers&&(o.rasterLayers=r.raster_layers,o.rasterLayerIds=o.rasterLayers.map((e=>e.id))),o.tiles=i.canonicalizeTileset(o,t.url),a(null,o);}};return t.url?e.g(i.transformRequest(i.normalizeSourceURL(t.url,null,o,r),e.R.Source),n):e.e.frame((()=>n(null,t)))}class Bt{constructor(t,i,o){this.bounds=e.ai.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.aj(this.bounds.getWest())*i),r=Math.floor(e.ak(this.bounds.getNorth())*i),a=Math.ceil(e.aj(this.bounds.getEast())*i),n=Math.ceil(e.ak(this.bounds.getSouth())*i);return t.x>=o&&t.x<a&&t.y>=r&&t.y<n}}class kt extends e.E{constructor(t,i,o,r){super(),this.id=t,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.W({type:"raster"},i),e.W(this,e.ah(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.f("dataloading",{dataType:"source"})),this._tileJSONRequest=Ft(this._options,this.map._requestManager,null,null,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.d(i)):o&&(e.W(this,o),o.bounds&&(this.tileBounds=new Bt(o.bounds,this.minzoom,this.maxzoom)),e.an(o.tiles),this.fire(new e.f("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.f("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.al(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.W({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.e.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.h(this.map._requestManager.transformRequest(r,e.R.Tile),((o,r,a,n)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):r?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:a,expires:n}),t.setTexture(r,this.map.painter),t.state="loaded",e.am(this.dispatcher),void i(null)):i(null))));}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t&&t();}unloadTile(t,i){t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),i&&i();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class Nt extends e.E{constructor(t,i,o,r){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.W(this,e.ah(i,["url","scheme","tileSize","promoteId"])),this._options=e.W({type:"vector"},i),this._collectResourceTiming=!!i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new e.ao;}load(t){this._loaded=!1,this.fire(new e.f("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map._worldview;this._tileJSONRequest=Ft(this._options,this.map._requestManager,i,o,((r,a)=>{this._tileJSONRequest=null,this._loaded=!0,r?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.d(r))):a&&(e.W(this,a),a.bounds&&(this.tileBounds=new Bt(a.bounds,this.minzoom,this.maxzoom)),e.an(a.tiles,this.map._requestManager._customAccessToken),this.fire(new e.f("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.f("data",{dataType:"source",sourceDataType:"content"}))),t&&t(r);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest();const t=e.al(this.id,this.scope);this.load((()=>this.map.style.clearSource(t)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(e){this.cancelTileJSONRequest();}serialize(){return e.W({},this._options)}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r=this.map._requestManager.transformRequest(o,e.R.Tile),a=this.map.style?this.map.style.getLut(this.scope):null,n={request:r,data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,lut:a?{image:a.image.clone()}:null,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:e.e.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:t.isExtraShadowCaster,tessellationStep:this.map._tessellationStep};if(n.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",n,s.bind(this));else if(t.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",n,s.bind(this),void 0,!0);else {const i=e.ap.call({deduped:this._deduped},n,((e,i)=>{e||!i?s.call(this,e):(n.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",n,s.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function s(o,r){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(r&&r.resourceTiming&&(t.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&t.setExpiryData(r),t.loadVectorData(r,this.map.painter),e.am(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope});}unloadTile(e,t){e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}const Ut=(e,t,i)=>({u_matrix:e,u_image0:0,u_skirt_height:t,u_ground_shadow_factor:i}),Gt=(e,t,i,o,r,a,n,s,l,c,h,_,u,d,p,f)=>({u_proj_matrix:Float32Array.from(e),u_globe_matrix:t,u_normalize_matrix:Float32Array.from(o),u_merc_matrix:i,u_zoom_transition:r,u_merc_center:a,u_image0:0,u_frustum_tl:n,u_frustum_tr:s,u_frustum_br:l,u_frustum_bl:c,u_globe_pos:h,u_globe_radius:_,u_viewport:u,u_grid_matrix:f?Float32Array.from(f):new Float32Array(9),u_skirt_height:d,u_far_z_cutoff:p});class jt{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.a2(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.a2(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.a2(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.a2(t.right,i.right,o)),this}getCenter(t,i){const o=e.at((this.left+t-this.right)/2,0,t),r=e.at((this.top+i-this.bottom)/2,0,i);return new e.P(o,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new jt(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Vt(t,i){const o=e.aw(t,3);e.ad.fromQuat(t,i),e.az(t,3,o);}function Wt(t,i){const o=e.av.identity([]);return e.av.rotateZ(o,o,-i),e.av.rotateX(o,o,-t),o}function Zt(t,i){const o=[t[0],t[1],0],r=[i[0],i[1],0];if(e._.length(o)>=1e-15){const t=e._.normalize([],o);e._.scale(r,t,e._.dot(r,t)),i[0]=r[0],i[1]=r[1];}const a=e._.cross([],i,t);if(e._.len(a)<1e-15)return null;const n=Math.atan2(-a[1],a[0]);return Wt(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}class qt{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.Y?t:new e.Y(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.au(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,r=this._elevation?this._elevation.getAtPointOrZero(e.Y.fromLngLat(t)):0,a=e.Y.fromLngLat(t,r),n=[a.x-o.x,a.y-o.y,a.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=Zt(n,i);}setPitchBearing(t,i){this.orientation=Wt(e.ab(t),e.ab(-i));}}class Ht{constructor(t,i){this._transform=e.ad.identity([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.Y(t[0],t[1],t[2])}get position(){const t=e.aw(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.az(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.av.identity([]),t&&Vt(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Wt(e,t),Vt(this._transform,this._orientation);}forward(){const t=e.aw(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.aw(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.aw(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.ad.invert(o,this.getWorldToCamera(t,i)),o}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(t,i,o){const r=this.position;e._.scale(r,r,-t);const a=new Float64Array(16);return e.ad.fromScaling(a,[o,o,o]),e.ad.translate(a,a,r),a[10]*=i,a}getWorldToCamera(t,i){const o=new Float64Array(16),r=new Float64Array(4),a=this.position;return e.av.conjugate(r,this._orientation),e._.scale(a,a,-t),e.ad.fromQuat(o,r),e.ad.translate(o,o,a),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,r){const a=new Float64Array(16);return e.ad.perspective(a,t,i,o,r),a}getCameraToClipOrthographic(t,i,o,r,a,n){const s=new Float64Array(16);return e.ad.ortho(s,t,i,o,r,a,n),s}getDistanceToElevation(t,i=!1){const o=0===t?0:e.ax(t,i?e.ay(this.position[1]):this.position[1]),r=this.forward();return (o-this.position[2])/r[2]}clone(){return new Ht([...this.position],[...this.orientation])}}const $t={unknown:0,flipRequired:1,flipNotRequired:2},Xt=Math.tan(85*Math.PI/180);function Yt(t,i,o,r,a,n,s){const l=e.ad.create();if(o)if("globe"===n.name){const t=e.aB(a,i);e.ad.multiply(l,l,t);}else {const t=e.aC.invert([],s);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],r||e.ad.rotateZ(l,l,a.angle);}else e.ad.multiply(l,a.labelPlaneMatrix,t);return l}function Kt(e,t,i,o,r,a,n){const s=Yt(e,t,i,o,r,a,n);return "globe"===a.name&&i||(s[2]=s[6]=s[10]=s[14]=0),s}function Qt(t,i,o,r,a,n,s){if(o){if("globe"===n.name){const l=Yt(t,i,o,r,a,n,s);return e.ad.invert(l,l),e.ad.multiply(l,t,l),l}{const i=e.ad.clone(t),o=e.ad.identity([]);return o[0]=s[0],o[1]=s[1],o[4]=s[2],o[5]=s[3],e.ad.multiply(i,i,o),r||e.ad.rotateZ(i,i,-a.angle),i}}return a.glCoordMatrix}function Jt(t,i,o,r){const a=[t,i,o,1];o?e.aA.transformMat4(a,a,r):hi(a,a,r);const n=a[3];return a[0]/=n,a[1]/=n,a[2]/=n,a}function ei(e,t){return Math.min(.5+e/t*.5,1.5)}function ti(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function ii(t,i,o,r,a,n,s,l,c,h){const _=o.transform,u=r?t.textSizeData:t.iconSizeData,d=e.aD(u,o.transform.zoom),p="globe"===_.projection.name,f=[256/o.width*2+1,256/o.height*2+1],m=r?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;m.clear();let g=null;p&&(g=r?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,x=r?t.text.placedSymbolArray:t.icon.placedSymbolArray,y=o.transform.width/o.transform.height;let b,w=!1;for(let r=0;r<x.length;r++){const p=x.get(r),{numGlyphs:T,writingMode:E}=p;if(E!==e.aE.vertical||w||b===e.aE.horizontal||(w=!0),b=E,(p.hidden||E===e.aE.vertical)&&!w){ci(T,m);continue}w=!1;const C=new e.P(p.tileAnchorX,p.tileAnchorY);let{x:S,y:I,z:L}=_.projection.projectTilePoint(C.x,C.y,h.canonical);if(c){const[e,t,i]=c(C);S+=e,I+=t,L+=i;}const P=[S,I,L,1];if(e.aA.transformMat4(P,P,i),!ti(P,f)){ci(T,m);continue}const A=P[3],R=ei(o.transform.getCameraToCenterDistance(_.projection),A),D=e.aF(u,d,p),M=s?D/R:D*R,z=Jt(S,I,L,a);if(z[3]<=0){ci(T,m);continue}let O={};const F=s?null:c,B=ai(p,M,!1,l,i,a,n,t.glyphOffsetArray,v,m,g,z,C,O,y,F,_.projection,h,s);w=B.useVertical,F&&B.needsFlipping&&(O={}),(B.notEnoughRoom||w||B.needsFlipping&&ai(p,M,!0,l,i,a,n,t.glyphOffsetArray,v,m,g,z,C,O,y,F,_.projection,h,s).notEnoughRoom)&&ci(T,m);}r?(t.text.dynamicLayoutVertexBuffer.updateData(m),g&&t.text.globeExtVertexBuffer&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(m),g&&t.icon.globeExtVertexBuffer&&t.icon.globeExtVertexBuffer.updateData(g));}function oi(e,t,i,o,r,a,n,s,l,c,h,_,u,d,p,f){const{lineStartIndex:m,glyphStartIndex:g,segment:v}=s,x=g+s.numGlyphs,y=m+s.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(x-1),T=li(e*b,i,o,r,a,n,v,m,y,l,c,h,_,u,!0,d,p,f);if(!T)return null;const E=li(e*w,i,o,r,a,n,v,m,y,l,c,h,_,u,!0,d,p,f);return E?{first:T,last:E}:null}function ri(t,i,o,r){return t===e.aE.horizontal&&Math.abs(r)>Math.abs(o)?{useVertical:!0}:t===e.aE.vertical?r>0?{needsFlipping:!0}:null:i!==$t.unknown&&function(e,t){return 0===e||Math.abs(t/e)>Xt}(o,r)?i===$t.flipRequired?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function ai(t,i,o,r,a,n,s,l,c,h,_,u,d,p,f,m,g,v,x){const y=i/24,b=t.lineOffsetX*y,w=t.lineOffsetY*y,{lineStartIndex:T,glyphStartIndex:E,numGlyphs:C,segment:S,writingMode:I,flipState:L}=t,P=T+t.lineLength,A=t=>{if(_){const[i,o,r]=t.up,a=h.length;e.aG(_,a+0,i,o,r),e.aG(_,a+1,i,o,r),e.aG(_,a+2,i,o,r),e.aG(_,a+3,i,o,r);}const[i,o,r]=t.point;e.aH(h,i,o,r,t.angle);};if(C>1){const e=oi(y,l,b,w,o,u,d,t,c,n,p,m,!1,g,v,x);if(!e)return {notEnoughRoom:!0};if(r&&!o){let[i,o,r]=e.first.point,[a,n,l]=e.last.point;[i,o]=Jt(i,o,r,s),[a,n]=Jt(a,n,l,s);const c=ri(I,L,(a-i)*f,n-o);if(t.flipState=c&&c.needsFlipping?$t.flipRequired:$t.flipNotRequired,c)return c}A(e.first);for(let e=E+1;e<E+C-1;e++){const t=li(y*l.getoffsetX(e),b,w,o,u,d,S,T,P,c,n,p,m,!1,!1,g,v,x);if(!t)return h.length-=4*(e-E),{notEnoughRoom:!0};A(t);}A(e.last);}else {if(r&&!o){const i=Jt(d.x,d.y,0,a),o=T+S+1,r=new e.P(c.getx(o),c.gety(o)),n=Jt(r.x,r.y,0,a),s=n[3]>0?n:si(d,r,i,1,a,void 0,g,v.canonical),l=ri(I,L,(s[0]-i[0])*f,s[1]-i[1]);if(t.flipState=l&&l.needsFlipping?$t.flipRequired:$t.flipNotRequired,l)return l}const i=li(y*l.getoffsetX(E),b,w,o,u,d,S,T,P,c,n,p,m,!1,!1,g,v,x);if(!i)return {notEnoughRoom:!0};A(i);}return {}}function ni(e,t,i,o,r){const{x:a,y:n,z:s}=o.projectTilePoint(e.x,e.y,t);if(!r)return Jt(a,n,s,i);const[l,c,h]=r(e);return Jt(a+l,n+c,s+h,i)}function si(t,i,o,r,a,n,s,l){const c=ni(t.sub(i)._unit()._add(t),l,a,s,n);return e._.sub(c,o,c),e._.normalize(c,c),e._.scaleAndAdd(c,o,c,r)}function li(t,i,o,r,a,n,s,l,c,h,_,u,d,p,f,m,g,v){const x=r?t-i:t+i;let y=x>0?1:-1,b=0;r&&(y*=-1,b=Math.PI),y<0&&(b+=Math.PI);let w=l+s+(y>0?0:1)|0,T=a,E=a,C=0,S=0;const I=Math.abs(x),L=[],P=[];let A=n,R=A;const D=()=>si(R,A,E,I-C+1,_,d,m,g.canonical);for(;C+S<=I;){if(w+=y,w<l||w>=c)return null;if(E=T,R=A,L.push(E),p&&P.push(R),A=new e.P(h.getx(w),h.gety(w)),T=u[w],!T){const e=ni(A,g.canonical,_,m,d);T=e[3]>0?u[w]=e:D();}C+=S,S=e._.distance(E,T);}f&&d&&(u[w]&&(T=D(),S=e._.distance(E,T)),u[w]=T);const M=(I-C)/S,z=A.sub(R)._mult(M)._add(R),O=e._.sub([],T,E),F=e._.scaleAndAdd([],E,O,M);let B=[0,0,1],k=O[0],N=O[1];if(v&&(B=m.upVector(g.canonical,z.x,z.y),0!==B[0]||0!==B[1]||1!==B[2])){const t=[B[2],0,-B[0]],i=e._.cross([],B,t);e._.normalize(t,t),e._.normalize(i,i),k=e._.dot(O,t),N=e._.dot(O,i);}if(o){const t=e._.cross([],B,O);e._.normalize(t,t),e._.scaleAndAdd(F,F,t,o*y);}const U=b+Math.atan2(N,k);return L.push(F),p&&P.push(z),{point:F,angle:U,path:L,tilePath:P,up:B}}function ci(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function hi(e,t,i){const o=t[0],r=t[1];return e[0]=i[0]*o+i[4]*r+i[12],e[1]=i[1]*o+i[5]*r+i[13],e[3]=i[3]*o+i[7]*r+i[15],e}const _i=(e,t,i)=>(1-i)*e+i*t,ui=e=>e*e*e*e*e;class di{constructor(t,i,o,r,a,n,s){this.tileSize=512,this._renderWorldCopies=void 0===a||a,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=o??0,this._maxPitch=r??60,this.setProjection(n),this.setMaxBounds(s),this.width=0,this.height=0,this._center=new e.aI(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new jt,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._expandedProjMatrixCache={},this._distanceTileDataCache={},this._camera=new Ht,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._tileCoverLift=0,this.freezeTileCoverage=!1,this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1;}clone(){const e=new di(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._orthographicProjectionAtLowPitch=this._orthographicProjectionAtLowPitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get isOrthographic(){return "globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<15}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}get depthOcclusionForSymbolsAndCircles(){return "globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.ah(this.projection,["name","center","parallels"])}setProjection(i){this.projectionOptions=i||{name:"mercator"};const o=this.projection?this.getProjection():void 0;this.projection=e.aJ(this.projectionOptions);const r=!t(o,this.getProjection());return r&&this._calcMatrices(),this.mercatorFromTransition=!1,r}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.aJ({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.ax(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return e.au(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.aC.create(),e.aC.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.at(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.ab(t),this._calcMatrices());}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}get tileCoverLift(){return this._tileCoverLift}set tileCoverLift(e){this._tileCoverLift!==e&&(this._tileCoverLift=e);}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize));}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let r=0,a=0;for(let n=0;n<i.length;n++){const s=new e.P(i[n][0]*this.width,o+i[n][1]*(this.height-o)),l=t.pointCoordinate(s);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);r+=l[3]*c,a+=c;}return 0===a?NaN:r/a}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),r=this._mercatorZfromZoom(this._maxZoom),a=Math.max(o-i,r);this._setZoom(this._zoomFromMercatorZ(a));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const r=e._.length(e._.sub([],this._camera.position,o));return e.at(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.av.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e._.exactEquals(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new qt;return i.position=new e.Y(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.av.length(t))return !1;e.av.normalize(t,t);const i=e._.transformQuat([],[0,0,-1],t),o=e._.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const r=Zt(i,o);return !!r&&(this._camera.orientation=r,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;t[2]=e.at(t[2],r/o,r/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.aK(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.P(0,0)),r=this.pointCoordinate(new e.P(this.width,0)),a=this.pointCoordinate(new e.P(this.width,this.height)),n=this.pointCoordinate(new e.P(0,this.height)),s=Math.floor(Math.min(o.x,r.x,a.x,n.x)),l=Math.floor(Math.max(o.x,r.x,a.x,n.x)),c=1;for(let o=s-c;o<=l+c;o++)0!==o&&i.push(new e.aK(o,t));}return i}isLODDisabled(e){return (!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCoverForShadows(t,i,o){let r=[];if(0===i[0]&&0===i[1])return r;for(const o of t){const t=o.canonical,a=o.overscaledZ,n=o.wrap,s=1<<t.z,l=t.x+1<s,c=t.x>0,h=t.y+1<s,_=t.y>0,u=o.wrap-(c?0:1),d=o.wrap+(l?0:1),p=c?t.x-1:s-1,f=l?t.x+1:0;i[0]<0?(r.push(new e.aL(a,d,t.z,f,t.y)),i[1]<0&&h&&(r.push(new e.aL(a,n,t.z,t.x,t.y+1)),r.push(new e.aL(a,d,t.z,f,t.y+1))),i[1]>0&&_&&(r.push(new e.aL(a,n,t.z,t.x,t.y-1)),r.push(new e.aL(a,d,t.z,f,t.y-1)))):i[0]>0?(r.push(new e.aL(a,u,t.z,p,t.y)),i[1]<0&&h&&(r.push(new e.aL(a,n,t.z,t.x,t.y+1)),r.push(new e.aL(a,u,t.z,p,t.y+1))),i[1]>0&&_&&(r.push(new e.aL(a,n,t.z,t.x,t.y-1)),r.push(new e.aL(a,u,t.z,p,t.y-1)))):i[1]<0&&h?r.push(new e.aL(a,n,t.z,t.x,t.y+1)):_&&r.push(new e.aL(a,n,t.z,t.x,t.y-1));}if(r.length>1){r.sort(((e,t)=>e.overscaledZ-t.overscaledZ||e.wrap-t.wrap||e.canonical.z-t.canonical.z||e.canonical.x-t.canonical.x||e.canonical.y-t.canonical.y));let e=0,t=0;for(;t<r.length;)r[t].equals(r[e])?++t:r[++e]=r[t++];r.length=e+1;}const a=[];for(const e of r)r.some((t=>e.isChildOf(t)))||a.push(e);return r=a.filter((e=>!t.some((t=>!!(e.overscaledZ<o&&t.isChildOf(e))||e.equals(t)||e.isChildOf(t))))),r}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,r=this.elevation&&this.elevation.exaggeration(),a=r&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const s=this.locationCoordinate(this.center),l=this.center.lat,c=1<<i,h=[c*s.x,c*s.y,0],_="globe"===this.projection.name,u=!_,d=e.aM.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,u),p=_?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=c*e.ax(1,this.center.lat),m=this._camera.position[2]/e.ax(1,this.center.lat),g=[c*p.x,c*p.y,m*(u?1:f)],v=_||r,x=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),y=this.isLODDisabled(!0)?i:0;let b;if(this._elevation&&t.isTerrainDEM)b=1e4*this._elevation.exaggeration();else if(this._elevation){const e=this._elevation.getMinMaxForVisibleTiles();b=e?e.max:this._centerAltitude;}else b=this._centerAltitude;const w=t.isTerrainDEM?-b:this._elevation?this._elevation.getMinElevationBelowMSL():0,T=this.projection.isReprojectedInTileSpace?e.aN(this):1,E=t=>{const i=1/4e4,o=new e.Y(t.x+i,t.y,t.z),r=new e.Y(t.x,t.y+i,t.z),a=t.toLngLat(),n=o.toLngLat(),s=r.toLngLat(),l=this.locationCoordinate(a),c=this.locationCoordinate(n),h=this.locationCoordinate(s),_=Math.hypot(c.x-l.x,c.y-l.y),u=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(_*u)*T/i},C=t=>{const i=b,o=w;return {aabb:e.aQ(this,c,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},S=[];let I=[];const L=i,P=t.reparseOverscaled?o:i,A=(m-this._centerAltitude)*f,R=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=M(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},D=(e,t)=>{if(.707*t<e)return 1;const i=t/e;return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)},M=t=>{if(t.zoom<y)return !0;if(t.zoom===L)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(g),r=t.aabb.distanceY(g);let s=A,c=1;if(_){s=t.aabb.distanceZ(g);const i=Math.pow(2,t.zoom),o=e.ay((t.y+1)/i),r=e.ay(t.y/i),a=Math.min(Math.max(l,o),r),n=e.b4(a)/e.b4(l);if(c=a===l?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,n/this._mercatorScaleRatio),this.zoom<=e.b1&&t.zoom===L-1&&n>=.9)return !0}else if(a&&(s=t.aabb.distanceZ(g)*f),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=E(new e.Y((t.x+.5)/i,(t.y+.5)/i));c=o>.85?1:o;}if(!n){const e=Math.sqrt(i*i+r*r+s*s);let o=(1<<L-t.zoom)*x*c;return o*=D(Math.max(s,A),e),e<o}let u=Number.MAX_VALUE,d=0;const p=t.aabb.getCorners(),m=[];for(const t of p){e._.sub(m,t,g),_||(a?m[2]*=f:m[2]=A);const i=e._.dot(m,this._camera.forward());i<u&&(u=i,d=Math.abs(m[2]));}let v=(1<<L-t.zoom)*x*c;if(v*=D(Math.max(d,A),u),u<v)return !0;const b=t.aabb.closestPoint(h);return b[0]===h[0]&&b[1]===h[1]};if(this.renderWorldCopies)for(let e=1;e<=3;e++)S.push(C(-e)),S.push(C(e));for(S.push(C(0));S.length>0;){const o=S.pop(),r=o.x,s=o.y;let l=o.fullyVisible;const u=()=>"globe"===this.projection.name&&(0===o.y||o.y===(1<<o.zoom)-1);if(!l){let t=v?o.aabb.intersects(d):o.aabb.intersectsFlat(d);if(0===t&&u()){const i=new e.aO(o.zoom,r,s);t=e.aP(this,c,i,!0).intersects(d);}if(0===t)continue;l=2===t;}if(o.zoom!==L&&M(o))for(let t=0;t<4;t++){const i=(r<<1)+t%2,h=(s<<1)+(t>>1),u={aabb:n?o.aabb.quadrant(t):e.aQ(this,c,o.zoom+1,i,h,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:h,wrap:o.wrap,fullyVisible:l,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};a&&!_&&(u.tileID=new e.aL(o.zoom+1===L?P:o.zoom+1,o.wrap,o.zoom+1,i,h),R(u)),S.push(u);}else {const a=o.zoom===L?P:o.zoom;if(t.minzoom&&t.minzoom>a)continue;if(!l){let t=v?o.aabb.intersectsPrecise(d):o.aabb.intersectsPreciseFlat(d);if(0===t&&u()){const i=new e.aO(o.zoom,r,s);t=e.aP(this,c,i,!0).intersectsPrecise(d);}if(0===t)continue}const n=h[0]-(.5+r+(o.wrap<<o.zoom))*(1<<i-o.zoom),_=h[1]-.5-s,p=o.tileID?o.tileID:new e.aL(a,o.wrap,o.zoom,r,s);I.push({tileID:p,distanceSq:n*n+_*_});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();I=I.filter((r=>{const a=[0,0,0,1],n=[e.a3,e.a3,0,1],s=this.calculateFogTileMatrix(r.tileID.toUnwrapped());e.aA.transformMat4(a,a,s),e.aA.transformMat4(n,n,s);const l=e.aA.min([],a,n),c=e.aA.max([],a,n),h=e.aR(l,c);if(0===h)return !0;let _=!1;const u=this._elevation;if(u&&h>i&&0!==o){const i=this.calculateProjMatrix(r.tileID.toUnwrapped());let a;t.isTerrainDEM||(a=u.getMinMaxForTile(r.tileID)),a||(a={min:w,max:b});const n=e.b2(this.rotation),s=[n[0]*e.a3,n[1]*e.a3,a.max];e._.transformMat4(s,s,i),_=(1-s[1])*this.height*.5<o;}return h<i||_}));}return I.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.at(t.lat,-e.aS,e.aS),o=this.projection.project(t.lng,i);return new e.P(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.ax(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,r;const a=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-a.x)/e,r=(i.y-a.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(a);o=e.x-t.x,r=e.y-t.y;}const n=this.locationCoordinate(t);this.setLocation(new e.Y(n.x-o,n.y-r));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t,i){const o=i?e.ax(i,t.lat):void 0,r=this.projection.project(t.lng,t.lat);return new e.Y(r.x,r.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,r=[t.x,t.y,0,1],a=[t.x,t.y,1,1];e.aA.transformMat4(r,r,this.pixelMatrixInverse),e.aA.transformMat4(a,a,this.pixelMatrixInverse);const n=a[3];e.aA.scale(r,r,1/r[3]),e.aA.scale(a,a,1/n);const s=r[2],l=a[2];return {p0:r,p1:a,t:s===l?0:(o-s)/(l-s)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.aA.transformMat4(i,i,this.pixelMatrixInverse),e.aA.transformMat4(o,o,this.pixelMatrixInverse),e.aA.scale(i,i,1/i[3]),e.aA.scale(o,o,1/o[3]),i[2]=e.ax(i[2],this._center.lat)*this.worldSize,o[2]=e.ax(o[2],this._center.lat)*this.worldSize,e.aA.scale(i,i,1/this.worldSize),e.aA.scale(o,o,1/this.worldSize),new e.aT([i[0],i[1],i[2]],e._.normalize([],e._.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:r}=t,a=e.ax(i[2],this._center.lat),n=e.ax(o[2],this._center.lat);return new e.Y(e.a2(i[0],o[0],r)/this.worldSize,e.a2(i[1],o[1],r)/this.worldSize,e.a2(a,n,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);let i=this.projection.pointCoordinate3D(this,t.x,t.y);if(i)return new e.Y(i[0],i[1],i[2]);let o=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t);const a=.02*r,n=t.clone();for(let t=0;t<10&&r-o>a;t++){n.y=e.a2(o,r,.66);const t=this.projection.pointCoordinate3D(this,n.x,n.y);t?(r=n.y,i=t):o=n.y;}return i?new e.Y(i[0],i[1],i[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(t){if(t.y<0||t.y>this.height||t.x<0||t.x>this.width)return !1;if(this.elevation||this.zoom>=e.aU)return !this.isPointAboveHorizon(t);const i=this.pointCoordinate(t);return i.y>=0&&i.y<=1}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,r=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.aA.transformMat4(r,r,this.pixelMatrix),r[3]>0?new e.P(r[0]/r[3],r[1]/r[3]):new e.P(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,r=this.width-this._edgeInsets.right,a=this.pointLocation3D(new e.P(i,t)),n=this.pointLocation3D(new e.P(r,t)),s=this.pointLocation3D(new e.P(r,o)),l=this.pointLocation3D(new e.P(i,o));let c=Math.min(a.lng,n.lng,s.lng,l.lng),h=Math.max(a.lng,n.lng,s.lng,l.lng),_=Math.min(a.lat,n.lat,s.lat,l.lat),u=Math.max(a.lat,n.lat,s.lat,l.lat);const d=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(t,i,o,r,a)=>{const n=(t+o)/2,s=(i+r)/2,l=new e.P(n,s),{lng:m,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-m,_-g,m-h,g-u);c=Math.min(c,m),h=Math.max(h,m),_=Math.min(_,g),u=Math.max(u,g),(a<p||v>d)&&(f(t,i,n,s,a+1),f(n,s,o,r,a+1));};if(f(i,t,r,t,1),f(r,t,r,o,1),f(r,o,i,o,1),f(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.aV(this);t?(u=90,h=180,c=-180):i&&(_=-90,h=180,c=-180);}return new e.ai(new e.aI(c,_),new e.aI(h,u))}_getBoundsRectangular(t,i){const{top:o,left:r}=this._edgeInsets,a=this.height-this._edgeInsets.bottom,n=this.width-this._edgeInsets.right,s=new e.P(r,o),l=new e.P(n,o),c=new e.P(n,a),h=new e.P(r,a);let _=this.pointCoordinate(s,t),u=this.pointCoordinate(l,t);const d=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return _.y>1&&u.y>=0?_=new e.Y((1-p.y)/f(p,_)+p.x,1):_.y<0&&u.y<=1&&(_=new e.Y(-p.y/f(p,_)+p.x,0)),u.y>1&&_.y>=0?u=new e.Y((1-d.y)/f(d,u)+d.x,1):u.y<0&&_.y<=1&&(u=new e.Y(-d.y/f(d,u)+d.x,0)),(new e.ai).extend(this.coordinateLocation(_)).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(d))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.aS,this.maxLat=e.aS,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.aj(this.minLng)*this.tileSize,this.worldMaxX=e.aj(this.maxLng)*this.tileSize,this.worldMinY=e.ak(this.maxLat)*this.tileSize,this.worldMaxY=e.ak(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const r=t.canonical,a=1/this.height,n=this.cameraWorldSize,s=n/this.zoomScale(r.z),l=(r.x+Math.pow(2,r.z)*t.wrap)*s,c=r.y*s,h=this.point;h.x*=n/this.worldSize,h.y*=n/this.worldSize;const _=this.angle,u=Math.sin(-_),d=-Math.cos(-_);return o[i]={bearing:[u,d],center:[(h.x-l)*a,(h.y-c)*a],scale:s/e.a3*a},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const r=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.ad.multiply(r,this.worldToFogMatrix,r),o[i]=new Float32Array(r),o[i]}calculateProjMatrix(t,i=!1,o=!1){const r=t.key;let a;if(a=o?this._expandedProjMatrixCache:i?this._alignedProjMatrixCache:this._projMatrixCache,a[r])return a[r];const n=this.calculatePosMatrix(t,this.worldSize);let s;return s=this.projection.isReprojectedInTileSpace?this.mercatorMatrix:o?this.expandedFarZProjMatrix:i?this.alignedProjMatrix:this.projMatrix,e.ad.multiply(n,s,n),a[r]=new Float32Array(n),a[r]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const r=e.aW(t,this);return o[i]=r,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.ad.fromScaling([],[t,t,t]);return e.ad.multiply(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.ax(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),r=this._camera.forward(),a=e.ax(1,this._center.lat);o[2]/=a,r[2]/=a,e._.normalize(r,r);const n=t.raycast(o,r,t.exaggeration());if(n){const t=e._.scaleAndAdd([],o,r,n),i=new e.Y(t[0],t[1],e.ax(t[2],e.ay(t[1]))),s=(i.z+e._.length([i.x-o[0],i.y-o[1],i.z-o[2]*a]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(s),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.ax(1,this._center.lat)*this.worldSize,r=this._computeCameraPosition(o),a=i.getAtPointOrZero(new e.Y(...r)),n=this.pixelsPerMeter/this.worldSize*a,s=this._minimumHeightOverTerrain(),l=r[2]-n;if(l<=s)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[r[0],r[1],t.z-r[2]],o=e._.length(i);i[2]-=(s-l)/this._pixelsPerMercatorPixel;const a=e._.length(i);if(0===a)return;e._.scale(i,i,o/a*this._pixelsPerMercatorPixel),this._camera.position=[r[0],r[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.at(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.at(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:r}=this.point;let a=0,n=o,s=r;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,_=this.worldMaxY*this.scale;if(r-c<h&&(s=h+c),r+c>_&&(s=_-c),_-h<this.height&&(a=Math.max(a,this.height/(_-h)),s=(_+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;n=(o+i+this.worldSize)%this.worldSize-i,n-l<e&&(n=e+l),n+l>t&&(n=t-l),t-e<this.width&&(a=Math.max(a,this.width/(t-e)),n=(t+e)/2);}n===o&&s===r||(this.center=this.unproject(new e.P(n,s))),a&&(this.zoom+=this.scaleZoom(a)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i="globe"===this.projection.name,o=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.ax(1,this.center.lat)/e.ax(1,e.b3));const r=e.aX(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,r),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const a="meters"===this.projection.zAxisUnit?o:1,n=this._camera.getWorldToCamera(this.worldSize,a);let s;const l=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(l[8]=2*-t.x/this.width,l[9]=2*t.y/this.height,this.isOrthographic){let e=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),i=e*this.aspect,o=-i,r=-e;i-=t.x,o-=t.x,e+=t.y,r+=t.y,s=this._camera.getCameraToClipOrthographic(o,i,r,e,this._nearZ,this._farZ),((e,t,i,o)=>{for(let r=0;r<16;r++)e[r]=_i(t[r],i[r],o);})(s,s,l,ui(this.pitch>=15?1:this.pitch/15));}else s=l;const c=e.ad.mul([],l,n);let h=e.ad.mul([],s,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.ad.identity([]);e.ad.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.ad.multiply(i,i,e.aY(this)),e.ad.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.ad.multiply(h,h,i),e.ad.multiply(c,c,i),this.inverseAdjustmentMatrix=e.aZ(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];if(this.mercatorMatrix=e.ad.scale([],h,[this.worldSize,this.worldSize,this.worldSize/a,1]),this.projMatrix=h,this.invProjMatrix=e.ad.invert(new Float64Array(16),this.projMatrix),i){const i=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,1/0);i[8]=2*-t.x/this.width,i[9]=2*t.y/this.height,this.expandedFarZProjMatrix=e.ad.mul([],i,n);}else this.expandedFarZProjMatrix=this.projMatrix;const _=e.ad.invert([],s);this.frustumCorners=e.a_.fromInvProjectionMatrix(_,this.horizonLineFromTop(),this.height),this.cameraFrustum=e.aM.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!i);const u=new Float32Array(16);e.ad.identity(u),e.ad.scale(u,u,[1,-1,1]),e.ad.rotateX(u,u,this._pitch),e.ad.rotateZ(u,u,this.angle);const d=e.ad.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=e.ad.clone(d);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;d[8]=2*-t.x/this.width,d[9]=2*(t.y+p)/this.height,this.skyboxMatrix=e.ad.multiply(u,d,u);const f=this.point,m=f.x,g=f.y,v=this.width%2/2,x=this.height%2/2,y=Math.cos(this.angle),b=Math.sin(this.angle),w=m-Math.round(m)+y*v+b*x,T=g-Math.round(g)+y*x+b*v,E=new Float64Array(h);if(e.ad.translate(E,E,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=E,h=e.ad.create(),e.ad.scale(h,h,[this.width/2,-this.height/2,1]),e.ad.translate(h,h,[1,-1,0]),this.labelPlaneMatrix=h,h=e.ad.create(),e.ad.scale(h,h,[1,-1,1]),e.ad.translate(h,h,[-1,-1,0]),e.ad.scale(h,h,[2/this.width,2/this.height,1]),this.glCoordMatrix=h,this.pixelMatrix=e.ad.multiply(new Float64Array(16),this.labelPlaneMatrix,c),this._calcFogMatrices(),this._distanceTileDataCache={},h=e.ad.invert(new Float64Array(16),this.pixelMatrix),!h)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=h,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.a$(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e._.transformMat4(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=h;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={},this._expandedProjMatrixCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,r=1/this.height/this._pixelsPerMercatorPixel,a=[t,t,i];e._.scale(a,a,r),e._.scale(o,o,-1),e._.multiply(o,o,a);const n=e.ad.create();e.ad.translate(n,n,o),e.ad.scale(n,n,a),this.mercatorFogMatrix=n,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,r);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,r=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*r,o.y/this.worldSize-i[1]*r,e/this.worldSize*this._centerAltitude-i[2]*r]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],r=t[2];let a=1;this.projection.wrap&&(this.center=this.center.wrap()),r>0&&(a=Math.min((i-o)/r,1)),this._camera.position=e._.scaleAndAdd([],this._camera.position,t,a),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:r}=this._camera.getPitchBearing(),a=e.ax(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.ab(this._maxPitch)),s=Math.max((t[2]-a)/Math.cos(o),n),l=this._zoomFromMercatorZ(s);e._.scaleAndAdd(t,t,i,s),this._pitch=e.at(o,e.ab(this.minPitch),e.ab(this.maxPitch)),this.angle=e.au(r,-Math.PI,Math.PI),this._setZoom(e.at(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.Y(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min(null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom,this._maxZoom)+4;return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.aU,r=0,a=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),n=this.tileSize*Math.pow(2,e),s=this.getCameraToCenterDistance(this.projection,e,n),l=this.scaleZoom(s/(t*this.tileSize)),c=Math.abs(e-l);c<a&&(a=c,r=e),e<l?i=e:o=e;}return r}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.w("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),r=Math.max(t.x,i.x),a=Math.min(t.y,i.y),n=Math.max(t.y,i.y);if(a<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const s=[new e.P(o,a),new e.P(r,n),new e.P(o,n),new e.P(r,a)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of s){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.b0(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.P(0,0),new e.P(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e._.length(e._.sub([],this._camera.position,t)),r=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(r)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],r){const a=[t,i,o,1];e.aA.transformMat4(a,a,r);const n=a[3]=Math.max(a[3],1e-6);return a[0]/=n,a[1]/=n,a[2]/=n,a}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.P(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}}getCameraToCenterDistance(t,i=this.zoom,o=this.worldSize){const r=e.aX(t,i,this.width,this.height,1024),a=t.pixelSpaceConversion(this.center.lat,o,r);let n=.5/Math.tan(.5*this._fov)*this.height*a;return this.isOrthographic&&(n=_i(1,n,ui(this.pitch>=15?1:this.pitch/15))),n}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.ad.multiply(t,t,this.globeMatrix),t}getFrustum(t){return e.aM.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,"meters"===this.projection.zAxisUnit)}}const pi={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,LUT:10,ShadowMap0:11},fi=(t,i)=>{if(i>0&&t.terrain&&e.w("Cutoff is currently disabled on terrain"),i<=0||t.terrain)return {shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,1]}};const o=t.transform,r=Math.max(Math.abs(o._zoom-(t.minCutoffZoom-1)),1),a=o.isLODDisabled(!1)?e.$(60,45,o.pitch):e.$(30,15,o.pitch),n=o._farZ-o._nearZ,s=i*o.height,l=((1-(c=a))*o.cameraToCenterDistance+c*(o._farZ+s))*r;var c;return {shouldRenderCutoff:a<1,uniformValues:{u_cutoff_params:[o._nearZ,o._farZ,(l-o._nearZ)/n,(l-s-o._nearZ)/n]}}},mi={cascadeCount:2,shadowMapResolution:2048};class gi{constructor(e,t){this.aabb=e,this.lastCascade=t;}}class vi{add(e,t){const i=this.receivers[e.key];void 0!==i?(i.aabb.min[0]=Math.min(i.aabb.min[0],t.min[0]),i.aabb.min[1]=Math.min(i.aabb.min[1],t.min[1]),i.aabb.min[2]=Math.min(i.aabb.min[2],t.min[2]),i.aabb.max[0]=Math.max(i.aabb.max[0],t.max[0]),i.aabb.max[1]=Math.max(i.aabb.max[1],t.max[1]),i.aabb.max[2]=Math.max(i.aabb.max[2],t.max[2])):this.receivers[e.key]=new gi(t,null);}clear(){this.receivers={};}get(e){return this.receivers[e.key]}computeRequiredCascades(t,i,o){const r=e.b6.fromPoints(t.points);let a=0;for(const t in this.receivers){const n=this.receivers[t];if(!n)continue;if(!r.intersectsAabb(n.aabb))continue;n.aabb.min=r.closestPoint(n.aabb.min),n.aabb.max=r.closestPoint(n.aabb.max);const s=n.aabb.getCorners();for(let t=0;t<o.length;t++){let r=!0;for(const a of s){const n=[a[0]*i,a[1]*i,a[2]];if(e._.transformMat4(n,n,o[t].matrix),n[0]<-1||n[0]>1||n[1]<-1||n[1]>1){r=!1;break}}if(n.lastCascade=t,a=Math.max(a,t),r)break}}return a+1}}class xi{constructor(t){this.painter=t,this._enabled=!1,this._shadowLayerCount=0,this._numCascadesToRender=0,this._cascades=[],this._groundShadowTiles=[],this._receivers=new vi,this._depthMode=new e.ae(t.context.gl.LEQUAL,e.ae.ReadWrite,[0,1]),this._uniformValues={u_light_matrix_0:new Float32Array(16),u_light_matrix_1:new Float32Array(16),u_shadow_intensity:0,u_fade_range:[0,0],u_shadow_normal_offset:[1,1,1],u_shadow_texel_size:1,u_shadow_map_resolution:1,u_shadow_direction:[0,0,1],u_shadow_bias:[36e-5,.0012,.012],u_shadowmap_0:0,u_shadowmap_1:0},this._forceDisable=!1,this.useNormalOffset=!1,t.tp.registerParameter(this,["Shadows"],"_forceDisable",{label:"forceDisable"},(()=>{this.painter.style.map.triggerRepaint();})),t.tp.registerParameter(mi,["Shadows"],"cascadeCount",{min:1,max:2,step:1}),t.tp.registerParameter(mi,["Shadows"],"shadowMapResolution",{min:32,max:2048,step:32}),t.tp.registerBinding(this,["Shadows"],"_numCascadesToRender",{readonly:!0,label:"numCascadesToRender"});}destroy(){for(const e of this._cascades)e.texture.destroy(),e.framebuffer.destroy();this._cascades=[];}updateShadowParameters(t,i){const o=this.painter;if(this._enabled=!1,this._shadowLayerCount=0,this._receivers.clear(),!i||!i.properties)return;const r=i.properties.get("shadow-intensity");if(!i.shadowsEnabled()||r<=0)return;if(this._shadowLayerCount=o.style.order.reduce(((e,i)=>{const r=o.style._mergedLayers[i];return e+(r.hasShadowPass()&&!r.isHidden(t.zoom)?1:0)}),0),this._enabled=this._shadowLayerCount>0,!this.enabled)return;const a=o.context,n=mi.shadowMapResolution,s=mi.shadowMapResolution;if(0===this._cascades.length||mi.shadowMapResolution!==this._cascades[0].texture.size[0]){this._cascades=[];for(let t=0;t<mi.cascadeCount;++t){const t=o._shadowMapDebug,i=a.gl,r=a.createFramebuffer(n,s,t,"texture"),l=new e.T(a,{width:n,height:s,data:null},i.DEPTH_COMPONENT);if(r.depthAttachment.set(l.texture),t){const t=new e.T(a,{width:n,height:s,data:null},i.RGBA);r.colorAttachment.set(t.texture);}this._cascades.push({framebuffer:r,texture:l,matrix:[],far:0,boundingSphereRadius:0,frustum:new e.aM,scale:0});}}this.shadowDirection=bi(i);let l=0;if(t.elevation){const e=t.elevation,i=[1e4,-1e4];e.visibleDemTiles.filter((e=>e.dem)).forEach((e=>{const t=e.dem.tree;i[0]=Math.min(i[0],t.minimums[0]),i[1]=Math.max(i[1],t.maximums[0]);})),1e4!==i[0]&&(l=(i[1]-i[0])*e.exaggeration());}const c=1.5*t.cameraToCenterDistance,h=3*c,_=new Float64Array(16);for(let i=0;i<this._cascades.length;++i){const o=this._cascades[i];let r=t.height/50,a=1;1===mi.cascadeCount?a=h:0===i?a=c:(r=c,a=h);const[n,s]=Ti(t,this.shadowDirection,r,a,mi.shadowMapResolution,l);o.scale=t.scale,o.matrix=n,o.boundingSphereRadius=s,e.ad.invert(_,o.matrix),o.frustum=e.aM.fromInvProjectionMatrix(_,1,0,!0),o.far=a;}const u=this._cascades.length-1;this._uniformValues.u_fade_range=[.75*this._cascades[u].far,this._cascades[u].far],this._uniformValues.u_shadow_intensity=r,this._uniformValues.u_shadow_direction=[this.shadowDirection[0],this.shadowDirection[1],this.shadowDirection[2]],this._uniformValues.u_shadow_texel_size=1/mi.shadowMapResolution,this._uniformValues.u_shadow_map_resolution=mi.shadowMapResolution,this._uniformValues.u_shadowmap_0=pi.ShadowMap0,this._uniformValues.u_shadowmap_1=pi.ShadowMap0+1,this._groundShadowTiles=o.transform.coveringTiles({tileSize:512,renderWorldCopies:!0});const d=o.transform.elevation;for(const e of this._groundShadowTiles){let t={min:0,max:0};if(d){const i=d.getMinMaxForTile(e);i&&(t=i);}this.addShadowReceiver(e.toUnwrapped(),t.min,t.max);}}get enabled(){return this._enabled&&!this._forceDisable}set enabled(e){this._enabled=e;}drawShadowPass(t,i){if(!this.enabled)return;const o=this.painter,r=o.context;this._numCascadesToRender=this._receivers.computeRequiredCascades(o.transform.getFrustum(0),o.transform.worldSize,this._cascades),r.viewport.set([0,0,mi.shadowMapResolution,mi.shadowMapResolution]);for(let a=0;a<this._numCascadesToRender;++a){o.currentShadowCascade=a,r.bindFramebuffer.set(this._cascades[a].framebuffer.framebuffer),r.clear({color:e.C.white,depth:1});for(const e of t.order){const r=t._mergedLayers[e];if(!r.hasShadowPass()||r.isHidden(o.transform.zoom))continue;const a=t.getLayerSourceCache(r),n=a?i[a.id]:void 0;("model"===r.type||n&&n.length)&&o.renderLayer(o,a,r,n);}}o.currentShadowCascade=0;}drawGroundShadows(){if(!this.enabled)return;const t=this.painter,i=t.style,o=t.context,r=i.directionalLight,a=i.ambientLight;if(!r||!a)return;const n=[],s=fi(t,t.longestCutoffRange);s.shouldRenderCutoff&&n.push("RENDER_CUTOFF");const l=wi(i,r,a),c=new e.ae(o.gl.LEQUAL,e.ae.ReadOnly,t.depthRangeFor3D);for(const i of this._groundShadowTiles){const r=i.toUnwrapped(),a=t.isTileAffectedByFog(i),h=t.getOrCreateProgram("groundShadow",{defines:n,overrideFog:a});this.setupShadows(r,h),t.uploadCommonUniforms(o,h,r,null,s);const _={u_matrix:t.transform.calculateProjMatrix(r),u_ground_shadow_factor:l};h.draw(t,o.gl.TRIANGLES,c,e.ag.disabled,e.a.multiply,e.af.disabled,_,"ground_shadow",t.tileExtentBuffer,t.quadTriangleIndexBuffer,t.tileExtentSegments,{},t.transform.zoom,null,null);}}getShadowPassColorMode(){return this.painter._shadowMapDebug?e.a.unblended:e.a.disabled}getShadowPassDepthMode(){return this._depthMode}getShadowCastingLayerCount(){return this._shadowLayerCount}calculateShadowPassMatrixFromTile(t){const i=this.painter.transform,o=i.calculatePosMatrix(t,i.worldSize);return e.ad.multiply(o,this._cascades[this.painter.currentShadowCascade].matrix,o),Float32Array.from(o)}calculateShadowPassMatrixFromMatrix(t){return e.ad.multiply(t,this._cascades[this.painter.currentShadowCascade].matrix,t),Float32Array.from(t)}setupShadows(t,i,o,r=0){if(!this.enabled)return;const a=this.painter.transform,n=this.painter.context,s=n.gl,l=this._uniformValues,c=new Float64Array(16),h=a.calculatePosMatrix(t,a.worldSize);for(let t=0;t<this._cascades.length;t++)e.ad.multiply(c,this._cascades[t].matrix,h),l[0===t?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(c),n.activeTexture.set(s.TEXTURE0+pi.ShadowMap0+t),this._cascades[t].texture.bind(s.NEAREST,s.CLAMP_TO_EDGE);if(this.useNormalOffset=!!o,this.useNormalOffset){const i=e.b5(t.canonical),n=2/a.tileSize*e.a3/mi.shadowMapResolution,s=n*this._cascades[0].boundingSphereRadius,c=n*this._cascades[this._cascades.length-1].boundingSphereRadius,h=("vector-tile"===o?1:3)/Math.pow(2,r-t.canonical.z-(1-a.zoom+Math.floor(a.zoom)));l.u_shadow_normal_offset=[i,s*h,c*h],l.u_shadow_bias=[6e-5,.0012,.012];}else l.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(n,l);}setupShadowsFromMatrix(t,i,o=!1){if(!this.enabled)return;const r=this.painter.context,a=r.gl,n=this._uniformValues,s=new Float64Array(16);for(let i=0;i<mi.cascadeCount;i++)e.ad.multiply(s,this._cascades[i].matrix,t),n[0===i?"u_light_matrix_0":"u_light_matrix_1"]=Float32Array.from(s),r.activeTexture.set(a.TEXTURE0+pi.ShadowMap0+i),this._cascades[i].texture.bind(a.NEAREST,a.CLAMP_TO_EDGE);if(this.useNormalOffset=o,o){const e=5;n.u_shadow_normal_offset=[1,e,e],n.u_shadow_bias=[6e-5,.0012,.012];}else n.u_shadow_bias=[36e-5,.0012,.012];i.setShadowUniformValues(r,n);}getShadowUniformValues(){return this._uniformValues}getCurrentCascadeFrustum(){return this._cascades[this.painter.currentShadowCascade].frustum}computeSimplifiedTileShadowVolume(t,i,o,r){if(r[2]>=0)return {};const a=function(t,i,o){const r=o/(1<<t.canonical.z);return new e.b6([t.canonical.x*r+t.wrap*o,t.canonical.y*r+t.wrap*o,0],[(t.canonical.x+1)*r+t.wrap*o,(t.canonical.y+1)*r+t.wrap*o,i])}(t,i,o).getCorners(),n=i/-r[2];r[0]<0?(e._.add(a[0],a[0],[r[0]*n,0,0]),e._.add(a[3],a[3],[r[0]*n,0,0])):r[0]>0&&(e._.add(a[1],a[1],[r[0]*n,0,0]),e._.add(a[2],a[2],[r[0]*n,0,0])),r[1]<0?(e._.add(a[0],a[0],[0,r[1]*n,0]),e._.add(a[1],a[1],[0,r[1]*n,0])):r[1]>0&&(e._.add(a[2],a[2],[0,r[1]*n,0]),e._.add(a[3],a[3],[0,r[1]*n,0]));const s={};return s.vertices=a,s.planes=[yi(a[1],a[0],a[4]),yi(a[2],a[1],a[5]),yi(a[3],a[2],a[6]),yi(a[0],a[3],a[7])],s}addShadowReceiver(t,i,o){this._receivers.add(t,e.b6.fromTileIdAndHeight(t,i,o));}getMaxCascadeForTile(e){const t=this._receivers.get(e);return t&&t.lastCascade?t.lastCascade:0}}function yi(t,i,o){const r=e._.sub([],o,i),a=e._.sub([],t,i),n=e._.cross([],r,a),s=e._.length(n);return 0===s?[0,0,1,0]:(e._.scale(n,n,1/s),[n[0],n[1],n[2],-e._.dot(n,i)])}function bi(t){const i=t.properties.get("direction"),o=e.ac(i.x,i.y,i.z);o[2]=e.at(o[2],0,75);const r=e.b7([o[0],o[1],o[2]]);return e._.fromValues(r.x,r.y,r.z)}function wi(t,i,o){const r=i.properties.get("color"),a=i.properties.get("intensity"),n=i.properties.get("direction"),s=[n.x,n.y,n.z],l=o.properties.get("color"),c=o.properties.get("intensity"),h=Math.max(e._.dot([0,0,1],s),0),_=[0,0,0];e._.scale(_,l.toRenderColor(t.getLut(i.scope)).toArray01Linear().slice(0,3),c);const u=[0,0,0];return e._.scale(u,r.toRenderColor(t.getLut(o.scope)).toArray01Linear().slice(0,3),h*a),e.b8([_[0]>0?_[0]/(_[0]+u[0]):0,_[1]>0?_[1]/(_[1]+u[1]):0,_[2]>0?_[2]/(_[2]+u[2]):0])}function Ti(t,i,o,r,a,n){const s=t.zoom,l=t.scale,c=t.worldSize,h=1/c,_=t.aspect,u=Math.sqrt(1+_*_)*Math.tan(.5*t.fovX),d=u*u,p=r-o,f=r+o;let m,g;d>p/f?(m=r,g=r*u):(m=.5*f*(1+d),g=.5*Math.sqrt(p*p+2*(r*r+o*o)*d+f*f*d*d));const v=t.projection.pixelsPerMeter(t.center.lat,c),x=t._camera.getCameraToWorldMercator(),y=[0,0,-m*h];e._.transformMat4(y,y,x);let b=g*h;const w=t._edgeInsets;if(!(0===w.left&&0===w.top&&0===w.right&&0===w.bottom||w.left===w.right&&w.top===w.bottom)){const i=t._camera.getWorldToCamera(t.worldSize,"meters"===t.projection.zAxisUnit?v:1),a=t._camera.getCameraToClipPerspective(t._fov,t.width/t.height,o,r);a[8]=2*-t.centerOffset.x/t.width,a[9]=2*t.centerOffset.y/t.height;const n=new Float64Array(16);e.ad.mul(n,a,i);const h=new Float64Array(16);e.ad.invert(h,n);const _=e.aM.fromInvProjectionMatrix(h,c,s,!0);for(const i of _.points){const o=((T=i)[0]/=l,T[1]/=l,T[2]=e.ax(T[2],t._center.lat),T);b=Math.max(b,e._.len(e._.subtract([],y,o)));}}var T;b*=a/(a-1);const E=Math.acos(i[2]),C=Math.atan2(-i[0],-i[1]),S=new Ht;S.position=y,S.setPitchBearing(E,C);const I=S.getWorldToCamera(c,v),L=b*c,P=Math.min(t._mercatorZfromZoom(17)*c*-2,-2*L),A=S.getCameraToClipOrthographic(-L,L,-L,L,P,(L+n*v)/i[2]),R=new Float64Array(16);e.ad.multiply(R,A,I);const D=e._.fromValues(Math.floor(1e6*y[0])/1e6*c,Math.floor(1e6*y[1])/1e6*c,0),M=.5*a,z=[0,0,0];e._.transformMat4(z,D,R),e._.scale(z,z,M);const O=[Math.floor(z[0]),Math.floor(z[1]),Math.floor(z[2])],F=[0,0,0];e._.sub(F,z,O),e._.scale(F,F,-1/M);const B=new Float64Array(16);return e.ad.identity(B),e.ad.translate(B,B,F),e.ad.multiply(R,B,R),[R,L]}function Ei(e,t){return null!=e&&null!=t&&!(!e.hasData()||!t.hasData())&&null!=e.demTexture&&null!=t.demTexture&&e.tileID.key!==t.tileID.key}const Ci=new class{constructor(){this.operations={};}newMorphing(e,t,i,o,r){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i);}else this.operations[e]={startTime:o,phase:0,duration:r,from:t,to:i,queued:null};}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return {from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return !!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},Si={0:null,1:"TERRAIN_VERTEX_MORPHING"};function Ii(e,t,i){if(0===t)return 0;const o=t<1&&514===i?.25/t:1;return 6*Math.pow(1.5,22-e)*Math.max(t,1)*o}function Li(e,t){const i=1<<e.z;return !t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const Pi=e=>({u_matrix:e});function Ai(t,i,o,r,a){if(a>0){const n=e.e.now(),s=(n-t.timeAdded)/a,l=i?(n-i.timeAdded)/a:-1,c=o.getSource(),h=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),_=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(t.tileID.overscaledZ-h),u=_&&t.refreshedUponExpiration?1:e.at(_?s:1-l,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-u}:{opacity:u,mix:0}}return {opacity:1,mix:0}}class Ri extends kt{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-array",this.maxzoom=22,this._options=e.W({type:"raster-array"},i);}triggerRepaint(e){const t=this.map.painter._terrain,i=this.map.style.getSourceCache(this.id);t&&t.enabled&&i&&t._clearRenderCacheForTile(i.id,e.tileID),this.map.triggerRepaint();}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize),r=this.map._requestManager.transformRequest(o,e.R.Tile);t.requestParams=r,t.actor||(t.actor=this.dispatcher.getActor()),t.request=t.fetchHeader(void 0,((e,o,r,a)=>{if(delete t.request,t.aborted)return t.state="unloaded",i(null);if(e){if(20===e.code)return;return t.state="errored",i(e)}this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:r,expires:a}),t.state="empty",i(null);}));}unloadTile(t,i){const o=t.texture;o&&o instanceof e.T?(t.destroy(!0),this.map.painter.saveTileTexture(o)):(t.destroy(),t.flushQueues(),t._isHeaderLoaded=!1,delete t._mrt,delete t.textureDescriptor),t.fbo&&(t.fbo.destroy(),delete t.fbo),delete t.request,delete t.requestParams,delete t.neighboringTiles,t.state="unloaded";}prepareTile(t,i,o){t._isHeaderLoaded&&("empty"!==t.state&&(t.state="reloading"),t.fetchBand(i,o,((i,o)=>{if(i)return t.state="errored",this.fire(new e.d(i)),void this.triggerRepaint(t);o&&(t.setTexture(o,this.map.painter),t.state="loaded",this.triggerRepaint(t));})));}getInitialBand(e){if(!this.rasterLayers)return 0;const t=this.rasterLayers.find((({id:t})=>t===e)),i=t&&t.fields,o=i&&i.bands&&i.bands;return o?o[0]:0}getTextureDescriptor(t,i,o){if(!t)return;const r=i.sourceLayer||this.rasterLayerIds&&this.rasterLayerIds[0];if(!r)return;let a=null;i instanceof e.bk?a=i.paint.get("raster-array-band"):i instanceof e.bl&&(a=i.paint.get("raster-particle-array-band"));const n=a||this.getInitialBand(r);if(null!=n)if(t.textureDescriptor){if(!t.updateNeeded(r,n)||o)return Object.assign({},t.textureDescriptor,{texture:t.texture})}else this.prepareTile(t,r,n);}}const Di={vector:Nt,raster:kt,"raster-dem":class extends kt{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=e.W({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function r(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.h(this.map._requestManager.transformRequest(o,e.R.Tile),function(o,a,n,s){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(a){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:s});const i=ImageBitmap&&a instanceof ImageBitmap&&e.bi(),o=1-(a.width-e.bj(a.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?a:e.e.getImageData(a,o),c={uid:t.uid,coord:t.tileID,source:this.id,scope:this.scope,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",c,r.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,a=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,s=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.aL(t.overscaledZ,a,i.z,r,i.y).key]={backfilled:!1},l[new e.aL(t.overscaledZ,s,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.aL(t.overscaledZ,a,i.z,r,i.y-1).key]={backfilled:!1},l[new e.aL(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.aL(t.overscaledZ,s,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.aL(t.overscaledZ,a,i.z,r,i.y+1).key]={backfilled:!1},l[new e.aL(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.aL(t.overscaledZ,s,i.z,n,i.y+1).key]={backfilled:!1}),l}},"raster-array":Ri,geojson:class extends e.E{constructor(t,i,o,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=e.W({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),void 0!==i.minzoom&&(this.minzoom=i.minzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const a=e.a3/this.tileSize;this.workerOptions=e.W({source:this.id,scope:this.scope,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*a,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*a,extent:e.a3,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.a3,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*a,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter,dynamic:i.dynamic},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(t){return this._options.dynamic?"string"!=typeof t&&("Feature"===t.type&&(t={type:"FeatureCollection",features:[t]}),"FeatureCollection"!==t.type)?this.fire(new e.d(new Error("Data to update should be a feature or a feature collection."))):(this._coalesce&&"string"!=typeof t&&"string"!=typeof this._data&&"FeatureCollection"===this._data.type?this._data.features.push(...t.features):this._data=t,this._updateWorkerData(!0),this):this.fire(new e.d(new Error("Can't call updateData on a GeoJSON source with dynamic set to false.")))}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t=!1){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.f("dataloading",{dataType:"source"})),this._loaded=!1;const i=e.W({append:t},this.workerOptions);i.scope=this.scope;const o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.e.resolveURL(o),e.R.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this._pendingLoad=this.actor.send(`${this.type}.loadData`,i,((i,o)=>{if(this._loaded=!0,this._pendingLoad=null,i)this.fire(new e.d(i));else {const i={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&o&&o.resourceTiming&&o.resourceTiming[this.id]&&(i.resourceTiming=o.resourceTiming[this.id]),t&&(this._partialReload=!0),this.fire(new e.f("data",i)),this._partialReload=!1,this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(t),this._coalesce=!1);}));}loaded(){return this._loaded}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const r=this.map.style?this.map.style.getLut(this.scope):null,a=this._partialReload,n={type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,lut:r?{image:r.image.clone()}:null,scope:this.scope,pixelRatio:e.e.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0,partial:a};t.request=this.actor.send(o,n,((e,r)=>a&&!r?(t.state="loaded",i(null)):(delete t.request,t.destroy(),t.aborted?i(null):e?i(e):(t.loadVectorData(r,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e,t){this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope}),e.destroy();}onRemove(e){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.W({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends e.bm{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.R.Source).url);e.bn(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.d(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.d(new e.V(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.T(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:e.bm,model:class extends e.E{constructor(e,t,i,o){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t;}load(){const t=[];for(const i in this._options.models){const o=this._options.models[i],r=e.l(this.map._requestManager.transformRequest(o.uri,e.R.Model).url).then((t=>{if(!t)return;const r=e.c(t),a=new e.M(i,o.position,o.orientation,r);a.computeBoundsAndApplyParent(),this.models.push(a);})).catch((t=>{this.fire(new e.d(new Error(`Could not load model ${i} from ${o.uri}: ${t.message}`)));}));t.push(r);}return Promise.allSettled(t).then((()=>{this._loaded=!0,this.fire(new e.f("data",{dataType:"source",sourceDataType:"metadata"}));})).catch((t=>{this.fire(new e.d(new Error(`Could not load models: ${t.message}`)));}))}onAdd(e){this.map=e,this.load();}hasTransition(){return !1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return {type:"model"}}},"batched-model":class extends e.E{constructor(e,t,i,o){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(o);}onAdd(e){this.map=e,this.load();}load(t){this._loaded=!1,this.fire(new e.f("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map._worldview;this._tileJSONRequest=Ft(this._options,this.map._requestManager,i,o,((r,a)=>{this._tileJSONRequest=null,this._loaded=!0,r?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.d(r))):a&&(e.W(this,a),a.bounds&&(this.tileBounds=new Bt(a.bounds,this.minzoom,this.maxzoom)),e.an(a.tiles,this.map._requestManager._customAccessToken),this.fire(new e.f("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.f("data",{dataType:"source",sourceDataType:"content"}))),t&&t(r);}));}hasTransition(){return !1}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,e.R.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:t.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0};if(t.actor&&"expired"!==t.state)if("loading"===t.state)t.reloadCallback=i;else {if(t.buckets){const e=Object.values(t.buckets);for(const t of e)t.dirty=!0;return void(t.state="loaded")}t.request=t.actor.send("reloadTile",r,a.bind(this));}else t.actor=this.dispatcher.getActor(),t.request=t.actor.send("loadTile",r,a.bind(this),void 0,!0);function a(e,o){return t.aborted?i(null):e&&404!==e.status?i(e):(o&&(o.resourceTiming&&(t.resourceTiming=o.resourceTiming),this.map._refreshExpiredTiles&&t.setExpiryData(o),t.buckets={...t.buckets,...o.buckets},o.featureIndex&&(t.latestFeatureIndex=o.featureIndex)),t.state="loaded",void i(null))}}serialize(){return e.W({},this._options)}},canvas:class extends e.bm{constructor(t,i,o,r){super(t,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.d(new e.V(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.d(new e.V(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.d(new e.V(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.d(new e.V(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.d(new e.V(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.d(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(e){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?!t&&!this._playing||this.texture instanceof e.bo||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.T(i,this.canvas,i.gl.RGBA,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.E{constructor(t,i,o,r){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(r),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.d(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.d(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new Bt(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.W(this,e.ah(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.ah(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.f("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.f("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this.map=t,this._loaded=!1,this.fire(new e.f("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const{x:i,y:o,z:r}=e.tileID.canonical,a=new AbortController;e.request=Promise.resolve(this._implementation.loadTile({x:i,y:o,z:r},{signal:a.signal})).then(function(i){return delete e.request,e.aborted?(e.state="unloaded",t(null)):void 0===i?(e.state="errored",t(null)):null===i?(this.loadTileData(e,{width:this.tileSize,height:this.tileSize,data:null}),e.state="loaded",t(null)):function(e){return e instanceof ImageData||e instanceof HTMLCanvasElement||e instanceof ImageBitmap||e instanceof HTMLImageElement}(i)?(this.loadTileData(e,i),e.state="loaded",void t(null)):(e.state="errored",t(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((i=>{20!==i.code&&(e.state="errored",t(i));})),e.request.cancel=()=>a.abort();}loadTileData(e,t){e.setTexture(t,this.map.painter);}unloadTile(t,i){if(t.texture&&t.texture instanceof e.T?(t.destroy(!0),t.texture&&t.texture instanceof e.T&&this.map.painter.saveTileTexture(t.texture)):t.destroy(),this._implementation.unloadTile){const{x:e,y:i,z:o}=t.tileID.canonical;this._implementation.unloadTile({x:e,y:i,z:o});}i&&i();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t&&t();}hasTransition(){return !1}_coveringTiles(){return this.map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const t=e.al(this.id,this.scope);this.map.style.clearSource(t);}_update(){this.fire(new e.f("data",{dataType:"source",sourceDataType:"content"}));}}},Mi=function(t,i,o,r){const a=new Di[i.type](t,i,o,r);if(a.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${a.id}`);return e.bp(["load","abort","unload","serialize","prepare"],a),a};class zi extends e.bv{constructor(t){const i={type:"raster-dem",maxzoom:t.transform.maxZoom},o=new e.bw(e.bx(),null),r=Mi("mock-dem",i,o,t.style);super("mock-dem",r,!1),r.setEventedParent(this),this._sourceLoaded=!0;}_loadTile(e,t){e.state="loaded",t(null);}}class Oi extends e.bv{constructor(t){const i=Mi("proxy",{type:"geojson",maxzoom:t.transform.maxZoom},new e.bw(e.bx(),null),t.style);super("proxy",i,!1),i.setEventedParent(this),this.map=this.getSource().map=t,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(t,i,o){if(t.freezeTileCoverage)return;this.transform=t;const r=t.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled}).reduce(((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new e.by(o,this._source.tileSize*o.overscaleFactor(),t.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i}),{});for(const e in this._tiles)e in r||(this.freeFBO(e),this._tiles[e].unloadVectorData(),delete this._tiles[e]);}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e];}}deallocRenderCache(){this.renderCache.forEach((e=>e.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class Fi extends e.aL{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.projMatrix=i;}}class Bi extends e.bq{constructor(t,i){super(),this._debugParams={sortTilesHiZFirst:!0,disableRenderCache:!1},t.tp.registerParameter(this._debugParams,["Terrain"],"sortTilesHiZFirst",{},(()=>{this._style.map.triggerRepaint();})),t.tp.registerParameter(this._debugParams,["Terrain"],"disableRenderCache",{},(()=>{this._style.map.triggerRepaint();})),t.tp.registerButton(["Terrain"],"Invalidate Render Cache",(()=>{this.invalidateRenderCache=!0,this._style.map.triggerRepaint();})),this.painter=t,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,r,a]=function(t){const i=new e.bt,o=new e.bu,r=131;i.reserve(17161),o.reserve(33800);const a=e.a3/128,n=e.a3+a/2,s=n+a;for(let t=-a;t<s;t+=a)for(let o=-a;o<s;o+=a){const r=o<0||o>n||t<0||t>n?24575:0,a=e.at(Math.round(o),0,e.a3),s=e.at(Math.round(t),0,e.a3);i.emplaceBack(a+r,s);}const l=(e,t)=>{const i=t*r+e;o.emplaceBack(i+1,i,i+r),o.emplaceBack(i+r,i+r+1,i+1);};for(let e=1;e<129;e++)for(let t=1;t<129;t++)l(t,e);