/**
 * Enumeration for image sizes
 * @enum {number}
 * @readonly
 * @description Image sizes in pixels for the long side of the image.
 */
export enum ImageSize {

    /**
     * 320 pixels image size
     */
    Size320 = 320,

    /**
     * 640 pixels image size
     */
    Size640 = 640,

    /**
     * 1024 pixels image size
     */
    Size1024 = 1024,

    /**
     * 2048 pixels image size
     */
    Size2048 = 2048,
}
