# mapillary-js [![Build Status](https://circleci.com/gh/mapillary/mapillary-js.svg?style=svg)](https://circleci.com/gh/mapillary/mapillary-js)

WebGL JavaScript library for displaying street level photos from [Mapillary](https://www.mapillary.com)

<a href="http://bl.ocks.org/knikel/151a77df042cd3890502" target="_blank"><img style="max-width: 45%; height: auto;" src="https://raw.githubusercontent.com/mapillary/mapillary-js/master/docs/assets/media/mapillary-js-preview-01-perspective.jpg" /></a>
<a href="http://bl.ocks.org/knikel/151a77df042cd3890502" target="_blank"><img style="max-width: 45%; height: auto;" src="https://raw.githubusercontent.com/mapillary/mapillary-js/master/docs/assets/media/mapillary-js-preview-02-pano.jpg" /></a>

> **ATTENTION! This is a beta release

## Using mapillary-js

Include via HTML tags:
```html
<link rel="stylesheet" href="https://npmcdn.com/mapillary-js@1.4.0/dist/mapillary-js.min.css">
<script src="https://npmcdn.com/mapillary-js@1.4.0/dist/mapillary-js.min.js"></script>
```

Make sure to check out [Examples](https://github.com/mapillary/mapillary-js#examples) section below or [API Documentation](https://mapillary.github.io/mapillary-js) for more information.

Alternatively, you can `npm install mapillary-js` to use it with module loader/bundler of your choice.

## Examples
- [Simple mapillary-js embedding](https://bl.ocks.org/knikel/4615432968a33f1fcd6b)
- [Storytelling with mapillary-js](http://bl.ocks.org/knikel/630c2d6fa37a8a0e082a)
- mapillary-js + Leaflet - [Panorama](http://bl.ocks.org/knikel/f04c4656d1adeaaf1555) - [Perspective photo](http://bl.ocks.org/knikel/151a77df042cd3890502)
- mapillary-js + Leaflet + Tangram - [Panorama](http://bl.ocks.org/knikel/0f297c5b1fcfd14e38ba) - [Perspective photo](http://bl.ocks.org/knikel/fbeda1c8f89c97612b10)
- mapillary-js + mapbox-gl-js - [Panorama](http://bl.ocks.org/knikel/4ec4de69a0fc29318675) - [Perspective photo](http://bl.ocks.org/knikel/010115b08ebe30baba86)
- mapillary-js + Esri Leaflet -  [Panorama](http://bl.ocks.org/knikel/dd38c3fb1bd8fb3a826c) - [Perspective photo](http://bl.ocks.org/knikel/e85b802e97fd3390668f)
- mapillary-js + Google Maps - [Panorama](http://bl.ocks.org/knikel/451e2ee5d76ae72e669f)
- [Slider displaying difference in two photos](http://bl.ocks.org/knikel/bc0f813f611a8787ff02)

## Documentation
- [Developing with mapillary-js](https://github.com/mapillary/mapillary-js/blob/master/docs/developing.md)
- [Extending mapillary-js with plugins](https://github.com/mapillary/mapillary-js/blob/master/docs/plugins.md)
- [Glossary](https://github.com/mapillary/mapillary-js/blob/master/docs/glossary.md)
- [API Reference](https://mapillary.github.io/mapillary-js)

## Changelog

Every release is described on the GitHub [Releases](https://github.com/mapillary/mapillary-js/releases) page.

## License

MIT License

## Contributing to mapillary-js

See [contributing.md](https://github.com/mapillary/mapillary-js/blob/master/docs/contributing.md).
