import ajaxWrapper from "../helpers/ajaxWrapper";

import config from "../config/config";

import AppDispatcher from "../AppDispatcher";
import AppsEvents from "../events/AppsEvents";

var AppsActions = {
  requestApps: function () {
    const embed = "embed=group.groups&embed=group.apps&" +
      "embed=group.apps.deployments&embed=group.apps.counts";
    this.request({
      url: `${config.apiURL}v2/groups?${embed}`
    })
      .success(function (groups) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.REQUEST_APPS,
          data: groups
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.REQUEST_APPS_ERROR,
          data: error
        });
      });
  },
  requestApp: function (appId) {
    this.request({
      url: `${config.apiURL}v2/apps/${appId}?embed=app.taskStats`
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.REQUEST_APP,
          data: app
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.REQUEST_APP_ERROR,
          data: error
        });
      });
  },
  createApp: function (newAppAttributes) {
    if (newAppAttributes.container != null &&
      newAppAttributes.container.volumes != null) {
      newAppAttributes.residency = {
        relaunchEscalationTimeoutSeconds: 10,
        taskLostBehavior: "WAIT_FOREVER"
      };
    }
    this.request({
      method: "POST",
      data: newAppAttributes,
      url: `${config.apiURL}v2/apps`
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.CREATE_APP,
          data: app
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.CREATE_APP_ERROR,
          data: error
        });
      });
  },
  deleteApp: function (appId) {
    this.request({
      method: "DELETE",
      headers: {
        "Content-Type": "application/json"
      },
      url: `${config.apiURL}v2/apps/${appId}`
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.DELETE_APP,
          data: app,
          appId: appId
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.DELETE_APP_ERROR,
          data: error
        });
      });
  },
  restartApp: function (appId, force = false) {
    var url = `${config.apiURL}v2/apps/${appId}/restart`;

    if (force) {
      url = url + "?force=true";
    }

    this.request({
      method: "POST",
      data: {
        force: force
      },
      url: url
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.RESTART_APP,
          data: app,
          appId: appId
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.RESTART_APP_ERROR,
          data: error
        });
      });
  },
  scaleApp: function (appId, instances, force = false) {
    var url = `${config.apiURL}v2/apps/${appId}`;

    if (force) {
      url = url + "?force=true";
    }

    this.request({
      method: "PUT",
      data: {
        instances: instances
      },
      headers: {
        "Content-Type": "application/json"
      },
      url: url
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.SCALE_APP,
          data: app,
          appId: appId
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.SCALE_APP_ERROR,
          data: error,
          instances: instances
        });
      });
  },
  applySettingsOnApp: function (appId, settings, isEditing = false,
      force = false) {

    // Used to mark current app config as stale
    AppDispatcher.dispatch({
      actionType: AppsEvents.APPLY_APP_REQUEST,
      appId: appId
    });

    var url = `${config.apiURL}v2/apps/${appId}`;
    if (force) {
      url = url + "?force=true";
    }

    this.request({
      method: "PUT",
      data: settings,
      url: url
    })
      .success(function (app) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.APPLY_APP,
          data: app,
          appId: appId,
          isEditing: isEditing
        });
      })
      .error(function (error) {
        AppDispatcher.dispatch({
          actionType: AppsEvents.APPLY_APP_ERROR,
          data: error,
          isEditing: isEditing
        });
      });
  },
  emitFilterCounts: function (filterCounts) {
    AppDispatcher.dispatchNext({
      actionType: AppsEvents.UPDATE_APPS_FILTER_COUNT,
      data: filterCounts
    });
  },
  request: ajaxWrapper
};

export default AppsActions;
