/**
 * martinez v0.4.3
 * Martinez polygon clipping algorithm, does boolean operation on polygons (multipolygons, polygons with holes etc): intersection, union, difference, xor
 *
 * @author Alex Milevski <info@w8r.name>
 * @license MIT
 * @preserve
 */
(function(t,e){typeof exports==="object"&&typeof module!=="undefined"?e(exports):typeof define==="function"&&define.amd?define(["exports"],e):e(t.martinez={})})(this,function(t){"use strict";function i(t,e){return t>e?1:t<e?-1:0}var y=function t(e,r){if(e===void 0)e=i;if(r===void 0)r=false;this._compare=e;this._root=null;this._size=0;this._noDuplicates=!!r};var e={size:{configurable:true}};y.prototype.rotateLeft=function t(e){var r=e.right;if(r){e.right=r.left;if(r.left){r.left.parent=e}r.parent=e.parent}if(!e.parent){this._root=r}else if(e===e.parent.left){e.parent.left=r}else{e.parent.right=r}if(r){r.left=e}e.parent=r};y.prototype.rotateRight=function t(e){var r=e.left;if(r){e.left=r.right;if(r.right){r.right.parent=e}r.parent=e.parent}if(!e.parent){this._root=r}else if(e===e.parent.left){e.parent.left=r}else{e.parent.right=r}if(r){r.right=e}e.parent=r};y.prototype._splay=function t(e){var r=this;while(e.parent){var i=e.parent;if(!i.parent){if(i.left===e){r.rotateRight(i)}else{r.rotateLeft(i)}}else if(i.left===e&&i.parent.left===i){r.rotateRight(i.parent);r.rotateRight(i)}else if(i.right===e&&i.parent.right===i){r.rotateLeft(i.parent);r.rotateLeft(i)}else if(i.left===e&&i.parent.right===i){r.rotateRight(i);r.rotateLeft(i)}else{r.rotateLeft(i);r.rotateRight(i)}}};y.prototype.splay=function t(e){var r=this;var i,n,o,f,l;while(e.parent){i=e.parent;n=i.parent;if(n&&n.parent){o=n.parent;if(o.left===n){o.left=e}else{o.right=e}e.parent=o}else{e.parent=null;r._root=e}f=e.left;l=e.right;if(e===i.left){if(n){if(n.left===i){if(i.right){n.left=i.right;n.left.parent=n}else{n.left=null}i.right=n;n.parent=i}else{if(f){n.right=f;f.parent=n}else{n.right=null}e.left=n;n.parent=e}}if(l){i.left=l;l.parent=i}else{i.left=null}e.right=i;i.parent=e}else{if(n){if(n.right===i){if(i.left){n.right=i.left;n.right.parent=n}else{n.right=null}i.left=n;n.parent=i}else{if(l){n.left=l;l.parent=n}else{n.left=null}e.right=n;n.parent=e}}if(f){i.right=f;f.parent=i}else{i.right=null}e.left=i;i.parent=e}}};y.prototype.replace=function t(e,r){if(!e.parent){this._root=r}else if(e===e.parent.left){e.parent.left=r}else{e.parent.right=r}if(r){r.parent=e.parent}};y.prototype.minNode=function t(e){if(e===void 0)e=this._root;if(e){while(e.left){e=e.left}}return e};y.prototype.maxNode=function t(e){if(e===void 0)e=this._root;if(e){while(e.right){e=e.right}}return e};y.prototype.insert=function t(e,r){var i=this._root;var n=null;var o=this._compare;var f;if(this._noDuplicates){while(i){n=i;f=o(i.key,e);if(f===0){return}else if(o(i.key,e)<0){i=i.right}else{i=i.left}}}else{while(i){n=i;if(o(i.key,e)<0){i=i.right}else{i=i.left}}}i={key:e,data:r,left:null,right:null,parent:n};if(!n){this._root=i}else if(o(n.key,i.key)<0){n.right=i}else{n.left=i}this.splay(i);this._size++;return i};y.prototype.find=function t(e){var r=this._root;var i=this._compare;while(r){var n=i(r.key,e);if(n<0){r=r.right}else if(n>0){r=r.left}else{return r}}return null};y.prototype.contains=function t(e){var r=this._root;var i=this._compare;while(r){var n=i(e,r.key);if(n===0){return true}else if(n<0){r=r.left}else{r=r.right}}return false};y.prototype.remove=function t(e){var r=this.find(e);if(!r){return false}this.splay(r);if(!r.left){this.replace(r,r.right)}else if(!r.right){this.replace(r,r.left)}else{var i=this.minNode(r.right);if(i.parent!==r){this.replace(i,i.right);i.right=r.right;i.right.parent=i}this.replace(r,i);i.left=r.left;i.left.parent=i}this._size--;return true};y.prototype.removeNode=function t(e){if(!e){return false}this.splay(e);if(!e.left){this.replace(e,e.right)}else if(!e.right){this.replace(e,e.left)}else{var r=this.minNode(e.right);if(r.parent!==e){this.replace(r,r.right);r.right=e.right;r.right.parent=r}this.replace(e,r);r.left=e.left;r.left.parent=r}this._size--;return true};y.prototype.erase=function t(e){var r=this.find(e);if(!r){return}this.splay(r);var i=r.left;var n=r.right;var o=null;if(i){i.parent=null;o=this.maxNode(i);this.splay(o);this._root=o}if(n){if(i){o.right=n}else{this._root=n}n.parent=o}this._size--};y.prototype.pop=function t(){var e=this._root,r=null;if(e){while(e.left){e=e.left}r={key:e.key,data:e.data};this.remove(e.key)}return r};y.prototype.next=function t(e){var r=e;if(r){if(r.right){r=r.right;while(r&&r.left){r=r.left}}else{r=e.parent;while(r&&r.right===e){e=r;r=r.parent}}}return r};y.prototype.prev=function t(e){var r=e;if(r){if(r.left){r=r.left;while(r&&r.right){r=r.right}}else{r=e.parent;while(r&&r.left===e){e=r;r=r.parent}}}return r};y.prototype.forEach=function t(e){var r=this._root;var i=[],n=false,o=0;while(!n){if(r){i.push(r);r=r.left}else{if(i.length>0){r=i.pop();e(r,o++);r=r.right}else{n=true}}}return this};y.prototype.range=function t(e,r,i,n){var o=this;var f=[];var l=this._compare;var u=this._root,a;while(f.length!==0||u){if(u){f.push(u);u=u.left}else{u=f.pop();a=l(u.key,r);if(a>0){break}else if(l(u.key,e)>=0){if(i.call(n,u)){return o}}u=u.right}}return this};y.prototype.keys=function t(){var e=this._root;var r=[],i=[],n=false;while(!n){if(e){r.push(e);e=e.left}else{if(r.length>0){e=r.pop();i.push(e.key);e=e.right}else{n=true}}}return i};y.prototype.values=function t(){var e=this._root;var r=[],i=[],n=false;while(!n){if(e){r.push(e);e=e.left}else{if(r.length>0){e=r.pop();i.push(e.data);e=e.right}else{n=true}}}return i};y.prototype.at=function t(e){var r=this._root;var i=[],n=false,o=0;while(!n){if(r){i.push(r);r=r.left}else{if(i.length>0){r=i.pop();if(o===e){return r}o++;r=r.right}else{n=true}}}return null};y.prototype.load=function t(e,r,i){if(e===void 0)e=[];if(r===void 0)r=[];if(i===void 0)i=false;if(this._size!==0){throw new Error("bulk-load: tree is not empty")}var n=e.length;if(i){a(e,r,0,n-1,this._compare)}this._root=s(null,e,r,0,n);this._size=n;return this};y.prototype.min=function t(){var e=this.minNode(this._root);if(e){return e.key}else{return null}};y.prototype.max=function t(){var e=this.maxNode(this._root);if(e){return e.key}else{return null}};y.prototype.isEmpty=function t(){return this._root===null};e.size.get=function(){return this._size};y.createTree=function t(e,r,i,n,o){return new y(i,o).load(e,r,n)};Object.defineProperties(y.prototype,e);function s(t,e,r,i,n){var o=n-i;if(o>0){var f=i+Math.floor(o/2);var l=e[f];var u=r[f];var a={key:l,data:u,parent:t};a.left=s(a,e,r,i,f);a.right=s(a,e,r,f+1,n);return a}return null}function a(t,e,r,i,n){if(r>=i){return}var o=t[r+i>>1];var f=r-1;var l=i+1;while(true){do{f++}while(n(t[f],o)<0);do{l--}while(n(t[l],o)>0);if(f>=l){break}var u=t[f];t[f]=t[l];t[l]=u;u=e[f];e[f]=e[l];e[l]=u}a(t,e,r,l,n);a(t,e,l+1,i,n)}var f=0;var u=1;var h=2;var p=3;var d=0;var l=1;var E=2;var v=3;function w(t,e,r){if(e===null){t.inOut=false;t.otherInOut=true}else{if(t.isSubject===e.isSubject){t.inOut=!e.inOut;t.otherInOut=e.otherInOut}else{t.inOut=!e.otherInOut;t.otherInOut=e.isVertical()?!e.inOut:e.inOut}if(e){t.prevInResult=!n(e,r)||e.isVertical()?e.prevInResult:e}}t.inResult=n(t,r)}function n(t,e){switch(t.type){case f:switch(e){case d:return!t.otherInOut;case l:return t.otherInOut;case E:return t.isSubject&&t.otherInOut||!t.isSubject&&!t.otherInOut;case v:return true}break;case h:return e===d||e===l;case p:return e===E;case u:return false}return false}var c=function t(e,r,i,n,o){this.left=r;this.point=e;this.otherEvent=i;this.isSubject=n;this.type=o||f;this.inOut=false;this.otherInOut=false;this.prevInResult=null;this.inResult=false;this.resultInOut=false;this.isExteriorRing=true};c.prototype.isBelow=function t(e){var r=this.point,i=this.otherEvent.point;return this.left?(r[0]-e[0])*(i[1]-e[1])-(i[0]-e[0])*(r[1]-e[1])>0:(i[0]-e[0])*(r[1]-e[1])-(r[0]-e[0])*(i[1]-e[1])>0};c.prototype.isAbove=function t(e){return!this.isBelow(e)};c.prototype.isVertical=function t(){return this.point[0]===this.otherEvent.point[0]};c.prototype.clone=function t(){var e=new c(this.point,this.left,this.otherEvent,this.isSubject,this.type);e.inResult=this.inResult;e.prevInResult=this.prevInResult;e.isExteriorRing=this.isExteriorRing;e.inOut=this.inOut;e.otherInOut=this.otherInOut;return e};function g(t,e){if(t[0]===e[0]){if(t[1]===e[1]){return true}else{return false}}return false}function o(t,e,r){return(t[0]-r[0])*(e[1]-r[1])-(e[0]-r[0])*(t[1]-r[1])}function _(t,e){var r=t.point;var i=e.point;if(r[0]>i[0]){return 1}if(r[0]<i[0]){return-1}if(r[1]!==i[1]){return r[1]>i[1]?1:-1}return I(t,e,r,i)}function I(t,e,r,i){if(t.left!==e.left){return t.left?1:-1}if(o(r,t.otherEvent.point,e.otherEvent.point)!==0){return!t.isBelow(e.otherEvent.point)?1:-1}return!t.isSubject&&e.isSubject?1:-1}function m(t,e,r){var i=new c(e,false,t,t.isSubject);var n=new c(e,true,t.otherEvent,t.isSubject);if(g(t.point,t.otherEvent.point)){console.warn("what is that, a collapsed segment?",t)}i.contourId=n.contourId=t.contourId;if(_(n,t.otherEvent)>0){t.otherEvent.left=true;n.left=false}t.otherEvent.otherEvent=n;t.otherEvent=i;r.push(n);r.push(i);return r}function k(t,e){return t[0]*e[1]-t[1]*e[0]}function b(t,e){return t[0]*e[0]+t[1]*e[1]}function O(t,e,r,i,n){var o=[e[0]-t[0],e[1]-t[1]];var f=[i[0]-r[0],i[1]-r[1]];function l(t,e,r){return[t[0]+e*r[0],t[1]+e*r[1]]}var u=[r[0]-t[0],r[1]-t[1]];var a=k(o,f);var s=a*a;var h=b(o,o);if(s>0){var p=k(u,f)/a;if(p<0||p>1){return null}var v=k(u,o)/a;if(v<0||v>1){return null}if(p===0||p===1){return n?null:[l(t,p,o)]}if(v===0||v===1){return n?null:[l(r,v,f)]}return[l(t,p,o)]}a=k(u,o);s=a*a;if(s>0){return null}var c=b(o,u)/h;var g=c+b(o,f)/h;var y=Math.min(c,g);var d=Math.max(c,g);if(y<=1&&d>=0){if(y===1){return n?null:[l(t,y>0?y:0,o)]}if(d===0){return n?null:[l(t,d<1?d:1,o)]}if(n&&y===0&&d===1){return null}return[l(t,y>0?y:0,o),l(t,d<1?d:1,o)]}return null}function R(t,e,r){var i=O(t.point,t.otherEvent.point,e.point,e.otherEvent.point);var n=i?i.length:0;if(n===0){return 0}if(n===1&&(g(t.point,e.point)||g(t.otherEvent.point,e.otherEvent.point))){return 0}if(n===2&&t.isSubject===e.isSubject){return 0}if(n===1){if(!g(t.point,i[0])&&!g(t.otherEvent.point,i[0])){m(t,i[0],r)}if(!g(e.point,i[0])&&!g(e.otherEvent.point,i[0])){m(e,i[0],r)}return 1}var o=[];var f=false;var l=false;if(g(t.point,e.point)){f=true}else if(_(t,e)===1){o.push(e,t)}else{o.push(t,e)}if(g(t.otherEvent.point,e.otherEvent.point)){l=true}else if(_(t.otherEvent,e.otherEvent)===1){o.push(e.otherEvent,t.otherEvent)}else{o.push(t.otherEvent,e.otherEvent)}if(f&&l||f){e.type=u;t.type=e.inOut===t.inOut?h:p;if(f&&!l){m(o[1].otherEvent,o[0].point,r)}return 2}if(l){m(o[0],o[1].point,r);return 3}if(o[0]!==o[3].otherEvent){m(o[0],o[1].point,r);m(o[1],o[2].point,r);return 3}m(o[0],o[1].point,r);m(o[3].otherEvent,o[2].point,r);return 3}function j(t,e){if(t===e){return 0}if(o(t.point,t.otherEvent.point,e.point)!==0||o(t.point,t.otherEvent.point,e.otherEvent.point)!==0){if(g(t.point,e.point)){return t.isBelow(e.otherEvent.point)?-1:1}if(t.point[0]===e.point[0]){return t.point[1]<e.point[1]?-1:1}if(_(t,e)===1){return e.isAbove(t.point)?-1:1}return t.isBelow(e.point)?-1:1}if(t.isSubject===e.isSubject){var r=t.point,i=e.point;if(r[0]===i[0]&&r[1]===i[1]){r=t.otherEvent.point;i=e.otherEvent.point;if(r[0]===i[0]&&r[1]===i[1]){return 0}else{return t.contourId>e.contourId?1:-1}}}else{return t.isSubject?-1:1}return _(t,e)===1?1:-1}function x(t,e,r,i,n,o){var f=new y(j);var l=[];var u=Math.min(i[2],n[2]);var a,s,h;while(t.length!==0){var p=t.pop();l.push(p);if(o===d&&p.point[0]>u||o===E&&p.point[0]>i[2]){break}if(p.left){s=a=f.insert(p);h=f.minNode();if(a!==h){a=f.prev(a)}else{a=null}s=f.next(s);var v=a?a.key:null;var c=void 0;w(p,v,o);if(s){if(R(p,s.key,t)===2){w(p,v,o);w(p,s.key,o)}}if(a){if(R(a.key,p,t)===2){var g=a;if(g!==h){g=f.prev(g)}else{g=null}c=g?g.key:null;w(v,c,o);w(p,v,o)}}}else{p=p.otherEvent;s=a=f.find(p);if(a&&s){if(a!==h){a=f.prev(a)}else{a=null}s=f.next(s);f.remove(p);if(s&&a){R(a.key,s.key,t)}}}}return l}function S(t){var e,r,i,n;var o=[];for(r=0,i=t.length;r<i;r++){e=t[r];if(e.left&&e.inResult||!e.left&&e.otherEvent.inResult){o.push(e)}}var f=false;while(!f){f=true;for(r=0,i=o.length;r<i;r++){if(r+1<i&&_(o[r],o[r+1])===1){n=o[r];o[r]=o[r+1];o[r+1]=n;f=false}}}for(r=0,i=o.length;r<i;r++){e=o[r];e.pos=r}for(r=0,i=o.length;r<i;r++){e=o[r];if(!e.left){n=e.pos;e.pos=e.otherEvent.pos;e.otherEvent.pos=n}}return o}function N(t,e,r,i){var n=t+1;var o=e.length;if(n>o-1){return t-1}var f=e[t].point;var l=e[n].point;while(n<o&&l[0]===f[0]&&l[1]===f[1]){if(!r[n]){return n}else{n++}l=e[n].point}n=t-1;while(r[n]&&n>=i){n--}return n}function z(t,e){var r,i;var n=S(t);var o={};var f=[];var l;for(r=0,i=n.length;r<i;r++){if(o[r]){continue}var u=[[]];if(!n[r].isExteriorRing){if(e===E&&!n[r].isSubject&&f.length===0){f.push(u)}else if(f.length===0){f.push([[u]])}else{f[f.length-1].push(u[0])}}else if(e===E&&!n[r].isSubject&&f.length>1){f[f.length-1].push(u[0])}else{f.push(u)}var a=f.length-1;var s=r;var h=n[r].point;u[0].push(h);while(s>=r){l=n[s];o[s]=true;if(l.left){l.resultInOut=false;l.contourId=a}else{l.otherEvent.resultInOut=true;l.otherEvent.contourId=a}s=l.pos;o[s]=true;u[0].push(n[s].point);s=N(s,n,o,r)}s=s===-1?r:s;l=n[s];o[s]=o[l.pos]=true;l.otherEvent.resultInOut=true;l.otherEvent.contourId=a}return f}var M=L;var r=L;function L(t,e){var r=this;if(!(this instanceof L)){return new L(t,e)}this.data=t||[];this.length=this.data.length;this.compare=e||B;if(this.length>0){for(var i=(this.length>>1)-1;i>=0;i--){r._down(i)}}}function B(t,e){return t<e?-1:t>e?1:0}L.prototype={push:function(t){this.data.push(t);this.length++;this._up(this.length-1)},pop:function(){if(this.length===0){return undefined}var t=this.data[0];this.length--;if(this.length>0){this.data[0]=this.data[this.length];this._down(0)}this.data.pop();return t},peek:function(){return this.data[0]},_up:function(t){var e=this.data;var r=this.compare;var i=e[t];while(t>0){var n=t-1>>1;var o=e[n];if(r(i,o)>=0){break}e[t]=o;t=n}e[t]=i},_down:function(t){var e=this;var r=this.data;var i=this.compare;var n=this.length>>1;var o=r[t];while(t<n){var f=(t<<1)+1;var l=f+1;var u=r[f];if(l<e.length&&i(r[l],u)<0){f=l;u=r[l]}if(i(u,o)>=0){break}r[t]=u;t=f}r[t]=o}};M.default=r;var D=Math.max;var T=Math.min;var V=0;function A(t,e,r,i,n,o){var f,l,u,a,s,h;for(f=0,l=t.length-1;f<l;f++){u=t[f];a=t[f+1];s=new c(u,false,undefined,e);h=new c(a,false,s,e);s.otherEvent=h;if(u[0]===a[0]&&u[1]===a[1]){continue}s.contourId=h.contourId=r;if(!o){s.isExteriorRing=false;h.isExteriorRing=false}if(_(s,h)>0){h.left=true}else{s.left=true}var p=u[0],v=u[1];n[0]=T(n[0],p);n[1]=T(n[1],v);n[2]=D(n[2],p);n[3]=D(n[3],v);i.push(s);i.push(h)}}function C(t,e,r,i,n){var o=new M(null,_);var f,l,u,a,s,h;for(u=0,a=t.length;u<a;u++){f=t[u];for(s=0,h=f.length;s<h;s++){l=s===0;if(l){V++}A(f[s],true,V,o,r,l)}}for(u=0,a=e.length;u<a;u++){f=e[u];for(s=0,h=f.length;s<h;s++){l=s===0;if(n===E){l=false}if(l){V++}A(f[s],false,V,o,i,l)}}return o}var F=[];function P(t,e,r){var i=null;if(t.length*e.length===0){if(r===d){i=F}else if(r===E){i=t}else if(r===l||r===v){i=t.length===0?e:t}}return i}function U(t,e,r,i,n){var o=null;if(r[0]>i[2]||i[0]>r[2]||r[1]>i[3]||i[1]>r[3]){if(n===d){o=F}else if(n===E){o=t}else if(n===l||n===v){o=t.concat(e)}}return o}function X(t,e,r){if(typeof t[0][0][0]==="number"){t=[t]}if(typeof e[0][0][0]==="number"){e=[e]}var i=P(t,e,r);if(i){return i===F?null:i}var n=[Infinity,Infinity,-Infinity,-Infinity];var o=[Infinity,Infinity,-Infinity,-Infinity];var f=C(t,e,n,o,r);i=U(t,e,n,o,r);if(i){return i===F?null:i}var l=x(f,t,e,n,o,r);var u=z(l,r);return u}function q(t,e){return X(t,e,l)}function G(t,e){return X(t,e,E)}function H(t,e){return X(t,e,v)}function J(t,e){return X(t,e,d)}var K={UNION:l,DIFFERENCE:E,INTERSECTION:d,XOR:v};t.union=q;t.diff=G;t.xor=H;t.intersection=J;t.operations=K;Object.defineProperty(t,"__esModule",{value:true})});