<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# match-all

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Version](https://img.shields.io/npm/v/match-all.svg)](https://www.npmjs.com/package/match-all) [![Downloads](https://img.shields.io/npm/dt/match-all.svg)](https://www.npmjs.com/package/match-all) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> Get all the matches for a regular expression in a string.

















## :cloud: Installation

```sh
# Using npm
npm install --save match-all

# Using yarn
yarn add match-all
```













## :clipboard: Example



```js
const matchAll = require("match-all");

let s = "Hello _World_ and _Mars_";
console.log(matchAll(s, /_([a-z]+)_/gi).toArray());
// => [ "World", "Mars" ]

// Get matches one by one
let m = matchAll(s, /_([a-z]+)_/gi);
console.log(m.next());
// => "World"

console.log(m.next());
// => "Mars"

console.log(m.next());
// => null

let multipleGroup = "Hello _World001_ and _World002_";
console.log(matchAll(multipleGroup, /_([a-z]+([0-9]+))_/gi).toArray());
// => [ "World", "Mars" ]

// Get matches one by one
let multipleMatch = matchAll(multipleGroup, /_([a-z]+([0-9]+))_/gi);
console.log(multipleMatch.nextRaw());
// => [..., "World001", "001"]

console.log(multipleMatch.nextRaw());
// => [..., "World002", "002"]

let m2 = matchAll("Hello _World_, _Mars_, _Pluto_ and _Moon_!", /_([a-z]+)_/gi);
console.log(m2.next());
// => "World"

// Reset the match index
m2.reset();

console.log(m2.next());
// => "World"

console.log(m2.next());
// => "Mars"

// Set the match index to 20
m2.reset(20);

console.log(m2.next());
// => "Pluto"
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `matchAll(s, r)`
Get all the matches for a regular expression in a string.

#### Params

- **String** `s`: The input string.
- **RegExp** `r`: The regular expression.

#### Return
- **Object** An object containing the following fields:
 - `input` (String): The input string.
 - `regex` (RegExp): The regular expression.
 - `next` (Function): Get the next match.
 - `toArray` (Function): Get all the matches.
 - `reset` (Function): Reset the index.

### `next()`
Get the next match in single group match.

#### Return
- **String** The matched snippet.

### `nextRaw()`
Get the next match in raw regex output. Usefull to get another group match.

#### Return
- **Array** The matched snippet

### `toArray()`
Get all the matches.

#### Return
- **Array** The matched snippets.

### `reset(i)`
Reset the index.

#### Params

- **Number** `i`: The new index (default: `0`).

#### Return
- **Number** The new index.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `@nexrender/core`
 - `rucksack`
 - `emojer`
 - `bot-peripheral`
 - `@koumoul/vuetify-jsonschema-form`
 - `@dhis2/cli-utils-docsite`
 - `csv-to-lines`
 - `@koumoul/vjsf`
 - `autoload-modules-loader`
 - `trello-react-scripts`
 - `google-font-downloader`
 - `@x1b/vuetify-jsonschema-form`
 - `fixturize`
 - `text-testing-mocha`
 - `json-schema-for-vuetify`
 - `@edgar-orozco/vuetify-jsonschema-form`
 - `@dev7ch/vuetify-jsonschema-form`
 - `@sheetbase/app-scripts`
 - `@vitaliikorsakov/thelib`
 - `@nickjfree/vuetify-jsonschema-form`
 - `@cloedu/vuetify-jsonschema-form`
 - `navdata-parser`
 - `react-navigation-generated-cli`
 - `docker-compose-viz`
 - `waqueplus`
 - `@emartech/collect-font-families`
 - `@strong-config/node`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
