'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var TableRowColumn = require('./table-row-column');
var StylePropable = require('../mixins/style-propable');

var TableFooter = React.createClass({
  displayName: 'TableFooter',

  mixins: [StylePropable],

  contextTypes: {
    muiTheme: React.PropTypes.object
  },

  propTypes: {
    adjustForCheckbox: React.PropTypes.bool,
    style: React.PropTypes.object
  },

  getDefaultProps: function getDefaultProps() {
    return {
      adjustForCheckbox: true
    };
  },

  getTheme: function getTheme() {
    return this.context.muiTheme.component.tableFooter;
  },

  getStyles: function getStyles() {
    var styles = {
      cell: {
        borderTop: '1px solid ' + this.getTheme().borderColor,
        verticalAlign: 'bottom',
        padding: 20,
        textAlign: 'left',
        whiteSpace: 'nowrap'
      }
    };

    return styles;
  },

  render: function render() {
    var _props = this.props;
    var className = _props.className;

    var other = _objectWithoutProperties(_props, ['className']);

    var classes = 'mui-table-footer';
    if (className) classes += ' ' + className;

    var footerRows = this._createRows();

    return React.createElement(
      'tfoot',
      _extends({ className: classes }, other),
      footerRows
    );
  },

  _createRows: function _createRows() {
    var _this = this;

    var rowNumber = 0;
    return React.Children.map(this.props.children, function (child) {
      return _this._createRow(child, rowNumber++);
    });
  },

  _createRow: function _createRow(child, rowNumber) {
    var styles = this.getStyles();
    var props = {
      className: 'mui-table-footer-row',
      displayBorder: false,
      key: 'f-' + rowNumber,
      rowNumber: rowNumber,
      style: this.mergeAndPrefix(styles.cell, child.props.style)
    };

    var children = [this._getCheckboxPlaceholder(props)];
    React.Children.forEach(child.props.children, function (child) {
      children.push(child);
    });

    return React.cloneElement(child, props, children);
  },

  _getCheckboxPlaceholder: function _getCheckboxPlaceholder(props) {
    if (!this.props.adjustForCheckbox) return null;

    var key = 'fpcb' + props.rowNumber;
    return React.createElement(TableRowColumn, { key: key, style: { width: 24 } });
  }

});

module.exports = TableFooter;