'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _simpleAssign = require('simple-assign');

var _simpleAssign2 = _interopRequireDefault(_simpleAssign);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function getStyles(props, context) {
  var firstChild = props.firstChild;
  var lastChild = props.lastChild;
  var _context$muiTheme = context.muiTheme;
  var baseTheme = _context$muiTheme.baseTheme;
  var button = _context$muiTheme.button;
  var toolbar = _context$muiTheme.toolbar;


  var marginHorizontal = baseTheme.spacing.desktopGutter;
  var marginVertical = (toolbar.height - button.height) / 2;

  var styles = {
    root: {
      position: 'relative',
      marginLeft: firstChild ? -marginHorizontal : undefined,
      marginRight: lastChild ? -marginHorizontal : undefined,
      display: 'flex',
      justifyContent: 'space-between'
    },
    dropDownMenu: {
      root: {
        color: toolbar.color, // removes hover color change, we want to keep it
        marginRight: baseTheme.spacing.desktopGutter,
        flex: 1,
        whiteSpace: 'nowrap'
      },
      controlBg: {
        backgroundColor: toolbar.menuHoverColor,
        borderRadius: 0
      },
      underline: {
        display: 'none'
      }
    },
    button: {
      margin: marginVertical + 'px ' + marginHorizontal + 'px',
      position: 'relative'
    },
    icon: {
      root: {
        cursor: 'pointer',
        lineHeight: toolbar.height + 'px',
        paddingLeft: baseTheme.spacing.desktopGutter
      }
    },
    span: {
      color: toolbar.iconColor,
      lineHeight: toolbar.height + 'px'
    }
  };

  return styles;
}

var ToolbarGroup = function (_Component) {
  _inherits(ToolbarGroup, _Component);

  function ToolbarGroup() {
    _classCallCheck(this, ToolbarGroup);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(ToolbarGroup).apply(this, arguments));
  }

  _createClass(ToolbarGroup, [{
    key: 'handleMouseLeaveFontIcon',
    value: function handleMouseLeaveFontIcon(style) {
      return function (event) {
        event.target.style.zIndex = 'auto';
        event.target.style.color = style.root.color;
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props;
      var children = _props.children;
      var className = _props.className;
      var style = _props.style;

      var other = _objectWithoutProperties(_props, ['children', 'className', 'style']);

      var prepareStyles = this.context.muiTheme.prepareStyles;

      var styles = getStyles(this.props, this.context);

      var newChildren = _react2.default.Children.map(children, function (currentChild) {
        if (!currentChild) {
          return null;
        }
        if (!currentChild.type) {
          return currentChild;
        }
        switch (currentChild.type.muiName) {
          case 'DropDownMenu':
            return _react2.default.cloneElement(currentChild, {
              style: (0, _simpleAssign2.default)({}, styles.dropDownMenu.root, currentChild.props.style),
              styleControlBg: styles.dropDownMenu.controlBg,
              styleUnderline: styles.dropDownMenu.underline
            });
          case 'RaisedButton':
          case 'FlatButton':
            return _react2.default.cloneElement(currentChild, {
              style: (0, _simpleAssign2.default)({}, styles.button, currentChild.props.style)
            });
          case 'FontIcon':
            return _react2.default.cloneElement(currentChild, {
              style: (0, _simpleAssign2.default)({}, styles.icon.root, currentChild.props.style),
              color: currentChild.props.color || _this2.context.muiTheme.toolbar.iconColor,
              hoverColor: currentChild.props.hoverColor || _this2.context.muiTheme.toolbar.hoverColor
            });
          case 'ToolbarSeparator':
          case 'ToolbarTitle':
            return _react2.default.cloneElement(currentChild, {
              style: (0, _simpleAssign2.default)({}, styles.span, currentChild.props.style)
            });
          default:
            return currentChild;
        }
      }, this);

      return _react2.default.createElement(
        'div',
        _extends({}, other, { className: className, style: prepareStyles((0, _simpleAssign2.default)({}, styles.root, style)) }),
        newChildren
      );
    }
  }]);

  return ToolbarGroup;
}(_react.Component);

ToolbarGroup.propTypes = {
  /**
   * Can be any node or number of nodes.
   */
  children: _react.PropTypes.node,
  /**
   * The css class name of the root element.
   */
  className: _react.PropTypes.string,
  /**
   * Set this to true for if the `ToolbarGroup` is the first child of `Toolbar`
   * to prevent setting the left gap.
   */
  firstChild: _react.PropTypes.bool,
  /**
   * Determines the side the `ToolbarGroup` will snap to. Either 'left' or 'right'.
   */
  float: _react.PropTypes.oneOf(['left', 'right']),
  /**
   * Set this to true for if the `ToolbarGroup` is the last child of `Toolbar`
   * to prevent setting the right gap.
   */
  lastChild: _react.PropTypes.bool,
  /**
   * Override the inline-styles of the root element.
   */
  style: _react.PropTypes.object
};
ToolbarGroup.defaultProps = {
  firstChild: false,
  lastChild: false
};
ToolbarGroup.contextTypes = {
  muiTheme: _react.PropTypes.object.isRequired
};
exports.default = ToolbarGroup;