'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var horizontal = _react.PropTypes.oneOf(['left', 'middle', 'right']);
var vertical = _react.PropTypes.oneOf(['top', 'center', 'bottom']);

exports.default = {

  corners: _react.PropTypes.oneOf(['bottom-left', 'bottom-right', 'top-left', 'top-right']),

  horizontal: horizontal,

  vertical: vertical,

  origin: _react.PropTypes.shape({
    horizontal: horizontal,
    vertical: vertical
  }),

  cornersAndCenter: _react.PropTypes.oneOf(['bottom-center', 'bottom-left', 'bottom-right', 'top-center', 'top-left', 'top-right']),

  stringOrNumber: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number]),

  zDepth: _react.PropTypes.oneOf([0, 1, 2, 3, 4, 5])

};