var React = require('react');
var StylePropable = require('../mixins/style-propable');

var SlideInTransitionGroup = require('../transition-groups/slide-in');

var TimeDisplay = React.createClass({

  mixins: [StylePropable],
 
  contextTypes: {
    muiTheme: React.PropTypes.object
  },

  propTypes: {
    selectedTime: React.PropTypes.object.isRequired,
    format: React.PropTypes.oneOf(['ampm', '24hr']),
    mode: React.PropTypes.oneOf(['hour', 'minute']),
    affix: React.PropTypes.oneOf(['', 'pm', 'am'])
  },

  getInitialState: function() {
    return {
      transitionDirection: 'up'
    };
  },
  getDefaultProps: function () {
      return {
          mode: 'hour' ,
          affix: '' 
      };
  },
  componentWillReceiveProps: function(nextProps) {
    var direction;

    if (nextProps.selectedTime !== this.props.selectedTime) {
      direction = nextProps.selectedTime > this.props.selectedTime ? 'up' : 'down';
      this.setState({
        transitionDirection: direction
      });
    }
  },
  sanitizeTime: function(time){
    var hour = this.props.selectedTime.getHours();
    var min = this.props.selectedTime.getMinutes().toString();

    if(this.props.format == "ampm"){

      hour %= 12;
      hour = hour || 12;
    }

    hour = hour.toString();
    if(hour.length < 2 ) hour = "0" + hour;
    if(min.length < 2 ) min = "0" + min;

    return [hour, min];
  },
  getTheme: function() {
    return this.context.muiTheme.component.timePicker;
  },
  render: function() {
    
		var {
			selectedTime,
			mode,
			...other
		} = this.props;
     
		var styles = {
			root: {
				textAlign: "center",
				position: "relative",
				width: "280px",
				height: "100%",
			},

			time: {
				margin: "6px 0",
				lineHeight: "58px",
				height: "58px",
				fontSize: "58px",
			},

			box: {
				padding: "16px 0",
		    backgroundColor: this.getTheme().color,
		    color: this.getTheme().textColor,
			},


			hour: {}, 
			
			minute: {}
		}


    var [hour, min] =  this.sanitizeTime();
    
     
    var hourClassName = "";
    var minClassName = "";

    styles[mode].color = this.getTheme().accentColor;

    return (
      <div {...other} style={this.mergeAndPrefix(styles.root)} >

        <div style={this.mergeAndPrefix(styles.box)} >
 
         
          <div style={this.mergeAndPrefix(styles.time)} > 
            <span style={this.mergeAndPrefix(styles.hour)} onTouchTap={this.props.onSelectHour}>{hour}</span>
            <span>:</span>
            <span style={this.mergeAndPrefix(styles.minute)} onTouchTap={this.props.onSelectMin}>{min}</span>
          </div>
         <span key={"affix"}>{this.props.affix.toUpperCase()}</span>
          

        </div>

      </div>
    );
  }

});

module.exports = TimeDisplay;


 