'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styleSheet = undefined;

var _assign = require('object-assign');

var _extends = _assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _jssThemeReactor = require('jss-theme-reactor');

var _customPropTypes = require('../utils/customPropTypes');

var _customPropTypes2 = _interopRequireDefault(_customPropTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } //  weak


var styleSheet = exports.styleSheet = (0, _jssThemeReactor.createStyleSheet)('Icon', function (theme) {
  var palette = theme.palette;

  return {
    root: {
      userSelect: 'none'
    },
    accent: {
      color: palette.accent.A200
    },
    action: {
      color: palette.action.active
    },
    contrast: {
      color: palette.getContrastText(palette.primary[500])
    },
    disabled: {
      color: palette.action.disabled
    },
    error: {
      color: palette.error[500]
    },
    primary: {
      color: palette.primary[500]
    }
  };
});

/**
 *
 * ```jsx
 * <Icon>account_circle</Icon>
 * ```
 */
function Icon(props, context) {
  var _classNames;

  var accent = props.accent,
      action = props.action,
      children = props.children,
      classNameProp = props.className,
      contrast = props.contrast,
      disabled = props.disabled,
      error = props.error,
      primary = props.primary,
      other = _objectWithoutProperties(props, ['accent', 'action', 'children', 'className', 'contrast', 'disabled', 'error', 'primary']);

  var classes = context.styleManager.render(styleSheet);
  var className = (0, _classnames2.default)('material-icons', classes.root, (_classNames = {}, _defineProperty(_classNames, classes.accent, accent), _defineProperty(_classNames, classes.action, action), _defineProperty(_classNames, classes.contrast, contrast), _defineProperty(_classNames, classes.disabled, disabled), _defineProperty(_classNames, classes.error, error), _defineProperty(_classNames, classes.primary, primary), _classNames), classNameProp);

  return _react2.default.createElement(
    'span',
    _extends({ className: className }, other),
    children
  );
}

Icon.propTypes = {
  /**
   * If true, the button will use the theme's accent color.
   */
  accent: _react.PropTypes.bool,
  /**
   * If true, the button will use the theme's action.active color.
   */
  action: _react.PropTypes.bool,
  /**
   * The name of the icon
   */
  children: _react.PropTypes.node,
  /**
   * The CSS class name of the root element.
   */
  className: _react.PropTypes.string,
  /**
   * If true, the button will contrast the theme's primary color.
   */
  contrast: _react.PropTypes.bool,
  /**
   * If true, the button will use the theme's action.disabled color.
   */
  disabled: _react.PropTypes.bool,
  /**
   * If true, the text will use the theme's error color
   */
  error: _react.PropTypes.bool,
  /**
   * If true, the button will use the theme's primary color.
   */
  primary: _react.PropTypes.bool
};

Icon.contextTypes = {
  styleManager: _customPropTypes2.default.muiRequired
};

Icon.defaultProps = {
  accent: false,
  action: false,
  contrast: false,
  disabled: false,
  error: false,
  primary: false
};

Icon.muiName = 'Icon';

exports.default = Icon;