'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Transition = require('react-transition-group/Transition');

var _Transition2 = _interopRequireDefault(_Transition);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var babelPluginFlowReactPropTypes_proptype_Props = {
  classes: require('prop-types').object.isRequired,
  className: require('prop-types').string,
  pulsate: require('prop-types').bool,
  rippleSize: require('prop-types').number.isRequired,
  rippleX: require('prop-types').number.isRequired,
  rippleY: require('prop-types').number.isRequired
}; //  weak

/**
 * @ignore - internal component.
 */
var Ripple = function (_React$Component) {
  (0, _inherits3.default)(Ripple, _React$Component);

  function Ripple() {
    var _ref;

    var _temp, _this, _ret;

    (0, _classCallCheck3.default)(this, Ripple);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = Ripple.__proto__ || (0, _getPrototypeOf2.default)(Ripple)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      rippleVisible: false,
      rippleLeaving: false
    }, _this.handleEnter = function () {
      _this.setState({
        rippleVisible: true
      });
    }, _this.handleExit = function () {
      _this.setState({
        rippleLeaving: true
      });
    }, _this.getRippleStyles = function (props) {
      var rippleSize = props.rippleSize,
          rippleX = props.rippleX,
          rippleY = props.rippleY;


      return {
        width: rippleSize,
        height: rippleSize,
        top: -(rippleSize / 2) + rippleY,
        left: -(rippleSize / 2) + rippleX
      };
    }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
  }

  (0, _createClass3.default)(Ripple, [{
    key: 'render',
    value: function render() {
      var _classNames, _classNames2;

      var _props = this.props,
          classes = _props.classes,
          classNameProp = _props.className,
          pulsate = _props.pulsate,
          rippleX = _props.rippleX,
          rippleY = _props.rippleY,
          rippleSize = _props.rippleSize,
          other = (0, _objectWithoutProperties3.default)(_props, ['classes', 'className', 'pulsate', 'rippleX', 'rippleY', 'rippleSize']);
      var _state = this.state,
          rippleVisible = _state.rippleVisible,
          rippleLeaving = _state.rippleLeaving;


      var className = (0, _classnames2.default)(classes.wrapper, (_classNames = {}, (0, _defineProperty3.default)(_classNames, classes.wrapperLeaving, rippleLeaving), (0, _defineProperty3.default)(_classNames, classes.wrapperPulsating, pulsate), _classNames), classNameProp);

      var rippleClassName = (0, _classnames2.default)(classes.ripple, (_classNames2 = {}, (0, _defineProperty3.default)(_classNames2, classes.rippleVisible, rippleVisible), (0, _defineProperty3.default)(_classNames2, classes.rippleFast, pulsate), _classNames2));

      return _react2.default.createElement(
        _Transition2.default,
        (0, _extends3.default)({ onEnter: this.handleEnter, onExit: this.handleExit }, other),
        _react2.default.createElement(
          'span',
          { className: className },
          _react2.default.createElement('span', { className: rippleClassName, style: this.getRippleStyles(this.props) })
        )
      );
    }
  }]);
  return Ripple;
}(_react2.default.Component);

Ripple.defaultProps = {
  pulsate: false
};
Ripple.propTypes = process.env.NODE_ENV !== "production" ? {
  classes: require('prop-types').object.isRequired,
  className: require('prop-types').string,
  pulsate: require('prop-types').bool,
  rippleSize: require('prop-types').number.isRequired,
  rippleX: require('prop-types').number.isRequired,
  rippleY: require('prop-types').number.isRequired
} : {};
Ripple.propTypes = process.env.NODE_ENV !== "production" ? {
  classes: require('prop-types').object.isRequired,
  className: require('prop-types').string,
  pulsate: require('prop-types').bool,
  rippleSize: require('prop-types').number.isRequired,
  rippleX: require('prop-types').number.isRequired,
  rippleY: require('prop-types').number.isRequired
} : {};
exports.default = Ripple;