'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styles = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _ref2, _ref3;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactPopper = require('react-popper');

var _helpers = require('../utils/helpers');

var _common = require('../colors/common');

var _common2 = _interopRequireDefault(_common);

var _grey = require('../colors/grey');

var _grey2 = _interopRequireDefault(_grey);

var _withStyles = require('../styles/withStyles');

var _withStyles2 = _interopRequireDefault(_withStyles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var babelPluginFlowReactPropTypes_proptype_Node = require('react').babelPluginFlowReactPropTypes_proptype_Node || require('prop-types').any;

var babelPluginFlowReactPropTypes_proptype_Element = require('react').babelPluginFlowReactPropTypes_proptype_Element || require('prop-types').any;

var styles = exports.styles = function styles(theme) {
  return {
    root: {
      display: 'inline-flex'
    },
    popper: {
      zIndex: theme.zIndex.tooltip
    },
    tooltip: (0, _defineProperty3.default)({
      background: _grey2.default[700],
      borderRadius: 2,
      color: _common2.default.fullWhite,
      fontSize: 14,
      height: theme.spacing.unit * 4,
      lineHeight: '32px',
      opacity: 0,
      padding: '0 ' + theme.spacing.unit + 'px',
      transform: 'scale(0)',
      transition: theme.transitions.create(['opacity', 'transform'], {
        duration: theme.transitions.duration.shortest
      })
    }, theme.breakpoints.up('sm'), {
      height: 22,
      lineHeight: '22px',
      padding: '0 ' + theme.spacing.unit + 'px',
      fontSize: 10
    }),
    tooltipLeft: (0, _defineProperty3.default)({
      transformOrigin: 'right center',
      marginRight: theme.spacing.unit * 3
    }, theme.breakpoints.up('sm'), {
      marginRight: 14
    }),
    tooltipRight: (0, _defineProperty3.default)({
      transformOrigin: 'left center',
      marginLeft: theme.spacing.unit * 3
    }, theme.breakpoints.up('sm'), {
      marginLeft: 14
    }),
    tooltipTop: (0, _defineProperty3.default)({
      transformOrigin: 'center bottom',
      marginBottom: theme.spacing.unit * 3
    }, theme.breakpoints.up('sm'), {
      marginBottom: 14
    }),
    tooltipBottom: (0, _defineProperty3.default)({
      transformOrigin: 'center top',
      marginTop: theme.spacing.unit * 3
    }, theme.breakpoints.up('sm'), {
      marginTop: 14
    }),
    tooltipOpen: {
      opacity: 0.9,
      transform: 'scale(1)'
    }
  };
};

var babelPluginFlowReactPropTypes_proptype_Props = {
  children: typeof babelPluginFlowReactPropTypes_proptype_Element === 'function' ? babelPluginFlowReactPropTypes_proptype_Element.isRequired ? babelPluginFlowReactPropTypes_proptype_Element.isRequired : babelPluginFlowReactPropTypes_proptype_Element : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Element).isRequired,
  classes: require('prop-types').object,
  className: require('prop-types').string,
  disableTriggerFocus: require('prop-types').bool,
  disableTriggerHover: require('prop-types').bool,
  disableTriggerTouch: require('prop-types').bool,
  label: typeof babelPluginFlowReactPropTypes_proptype_Node === 'function' ? babelPluginFlowReactPropTypes_proptype_Node.isRequired ? babelPluginFlowReactPropTypes_proptype_Node.isRequired : babelPluginFlowReactPropTypes_proptype_Node : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Node).isRequired,
  onRequestClose: require('prop-types').func,
  onRequestOpen: require('prop-types').func,
  open: require('prop-types').bool,
  enterDelay: require('prop-types').number,
  leaveDelay: require('prop-types').number,
  placement: require('prop-types').oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),
  PopperProps: require('prop-types').object
};

var Tooltip = function (_React$Component) {
  (0, _inherits3.default)(Tooltip, _React$Component);

  function Tooltip() {
    var _ref;

    var _temp, _this, _ret;

    (0, _classCallCheck3.default)(this, Tooltip);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = Tooltip.__proto__ || (0, _getPrototypeOf2.default)(Tooltip)).call.apply(_ref, [this].concat(args))), _this), _this.state = {}, _this.enterTimer = null, _this.leaveTimer = null, _this.touchTimer = null, _this.isControlled = null, _this.ignoreNonTouchEvents = false, _this.handleRequestOpen = function (event) {
      var childrenProps = _this.props.children.props;

      if (event.type === 'focus' && childrenProps.onFocus) {
        childrenProps.onFocus(event);
      }

      if (event.type === 'mouseover' && childrenProps.onMouseOver) {
        childrenProps.onMouseOver(event);
      }

      if (_this.ignoreNonTouchEvents && event.type !== 'touchstart') {
        return;
      }

      clearTimeout(_this.leaveTimer);
      if (_this.props.enterDelay > 0) {
        _this.leaveTimer = setTimeout(function () {
          _this.requestOpen(event);
        }, _this.props.enterDelay);
      } else {
        _this.requestOpen(event);
      }
    }, _this.requestOpen = function (event) {
      if (!_this.isControlled) {
        _this.setState({ open: true });
      }

      if (_this.props.onRequestOpen) {
        _this.props.onRequestOpen(event, true);
      }
    }, _this.handleRequestClose = function (event) {
      var childrenProps = _this.props.children.props;

      if (event.type === 'blur' && childrenProps.onBlur) {
        childrenProps.onBlur(event);
      }

      if (event.type === 'mouseleave' && childrenProps.onMouseLeave) {
        childrenProps.onMouseLeave(event);
      }

      clearTimeout(_this.leaveTimer);
      if (_this.props.leaveDelay) {
        _this.leaveTimer = setTimeout(function () {
          _this.requestClose(event);
        }, _this.props.leaveDelay);
      } else {
        _this.requestClose(event);
      }
    }, _this.requestClose = function (event) {
      _this.ignoreNonTouchEvents = false;

      if (!_this.isControlled) {
        _this.setState({ open: false });
      }

      if (_this.props.onRequestClose) {
        _this.props.onRequestClose(event, false);
      }
    }, _this.handleTouchStart = function (event) {
      _this.ignoreNonTouchEvents = true;
      var childrenProps = _this.props.children.props;

      if (childrenProps.onTouchStart) {
        childrenProps.onTouchStart(event);
      }

      clearTimeout(_this.touchTimer);
      event.persist();
      _this.touchTimer = setTimeout(function () {
        _this.handleRequestOpen(event);
      }, 1e3);
    }, _this.handleTouchEnd = function (event) {
      var childrenProps = _this.props.children.props;

      if (childrenProps.onTouchEnd) {
        childrenProps.onTouchEnd(event);
      }

      clearTimeout(_this.touchTimer);
      clearTimeout(_this.leaveTimer);
      event.persist();
      _this.leaveTimer = setTimeout(function () {
        _this.requestClose(event);
      }, 1500 + _this.props.leaveDelay);
    }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
  }

  (0, _createClass3.default)(Tooltip, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      var props = this.props;


      this.isControlled = props.open !== undefined;

      if (!this.isControlled) {
        // not controlled, use internal state
        this.setState({
          open: false
        });
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      clearTimeout(this.enterTimer);
      clearTimeout(this.leaveTimer);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          childrenProp = _props.children,
          classes = _props.classes,
          className = _props.className,
          disableTriggerFocus = _props.disableTriggerFocus,
          disableTriggerHover = _props.disableTriggerHover,
          disableTriggerTouch = _props.disableTriggerTouch,
          enterDelay = _props.enterDelay,
          leaveDelay = _props.leaveDelay,
          label = _props.label,
          openProp = _props.open,
          onRequestClose = _props.onRequestClose,
          onRequestOpen = _props.onRequestOpen,
          placement = _props.placement,
          PopperProps = _props.PopperProps,
          other = (0, _objectWithoutProperties3.default)(_props, ['children', 'classes', 'className', 'disableTriggerFocus', 'disableTriggerHover', 'disableTriggerTouch', 'enterDelay', 'leaveDelay', 'label', 'open', 'onRequestClose', 'onRequestOpen', 'placement', 'PopperProps']);


      var open = this.isControlled ? openProp : this.state.open;
      var childrenProps = {};

      if (!disableTriggerTouch) {
        childrenProps.onTouchStart = this.handleTouchStart;
        childrenProps.onTouchEnd = this.handleTouchEnd;
      }

      if (!disableTriggerHover) {
        childrenProps.onMouseOver = this.handleRequestOpen;
        childrenProps.onMouseLeave = this.handleRequestClose;
      }

      if (!disableTriggerFocus) {
        childrenProps.onFocus = this.handleRequestOpen;
        childrenProps.onBlur = this.handleRequestClose;
      }

      return _react2.default.createElement(
        _reactPopper.Manager,
        (0, _extends3.default)({ className: (0, _classnames2.default)(classes.root, className) }, other),
        _react2.default.createElement(
          _reactPopper.Target,
          null,
          _react2.default.cloneElement(childrenProp, childrenProps)
        ),
        _react2.default.createElement(
          _reactPopper.Popper,
          (0, _extends3.default)({ placement: placement, className: classes.popper }, PopperProps),
          _react2.default.createElement(
            'div',
            {
              className: (0, _classnames2.default)(classes.tooltip, (0, _defineProperty3.default)({}, classes.tooltipOpen, open), classes['tooltip' + (0, _helpers.capitalizeFirstLetter)(placement.split('-')[0])])
            },
            label
          )
        )
      );
    }
  }]);
  return Tooltip;
}(_react2.default.Component);

Tooltip.defaultProps = {
  disableTriggerFocus: false,
  disableTriggerHover: false,
  disableTriggerTouch: false,
  enterDelay: 0,
  leaveDelay: 0,
  placement: 'bottom'
};
Tooltip.propTypes = process.env.NODE_ENV !== "production" ? (_ref2 = {
  classes: require('prop-types').object.isRequired,
  disableTriggerFocus: require('prop-types').bool.isRequired,
  disableTriggerHover: require('prop-types').bool.isRequired,
  disableTriggerTouch: require('prop-types').bool.isRequired,
  enterDelay: require('prop-types').number.isRequired,
  leaveDelay: require('prop-types').number.isRequired,
  placement: require('prop-types').string.isRequired,
  children: typeof babelPluginFlowReactPropTypes_proptype_Element === 'function' ? babelPluginFlowReactPropTypes_proptype_Element.isRequired ? babelPluginFlowReactPropTypes_proptype_Element.isRequired : babelPluginFlowReactPropTypes_proptype_Element : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Element).isRequired
}, (0, _defineProperty3.default)(_ref2, 'classes', require('prop-types').object), (0, _defineProperty3.default)(_ref2, 'className', require('prop-types').string), (0, _defineProperty3.default)(_ref2, 'disableTriggerFocus', require('prop-types').bool), (0, _defineProperty3.default)(_ref2, 'disableTriggerHover', require('prop-types').bool), (0, _defineProperty3.default)(_ref2, 'disableTriggerTouch', require('prop-types').bool), (0, _defineProperty3.default)(_ref2, 'label', typeof babelPluginFlowReactPropTypes_proptype_Node === 'function' ? babelPluginFlowReactPropTypes_proptype_Node.isRequired ? babelPluginFlowReactPropTypes_proptype_Node.isRequired : babelPluginFlowReactPropTypes_proptype_Node : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Node).isRequired), (0, _defineProperty3.default)(_ref2, 'onRequestClose', require('prop-types').func), (0, _defineProperty3.default)(_ref2, 'onRequestOpen', require('prop-types').func), (0, _defineProperty3.default)(_ref2, 'open', require('prop-types').bool), (0, _defineProperty3.default)(_ref2, 'enterDelay', require('prop-types').number), (0, _defineProperty3.default)(_ref2, 'leaveDelay', require('prop-types').number), (0, _defineProperty3.default)(_ref2, 'placement', require('prop-types').oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top'])), (0, _defineProperty3.default)(_ref2, 'PopperProps', require('prop-types').object), _ref2) : {};
Tooltip.propTypes = process.env.NODE_ENV !== "production" ? (_ref3 = {
  classes: require('prop-types').object.isRequired,
  disableTriggerFocus: require('prop-types').bool.isRequired,
  disableTriggerHover: require('prop-types').bool.isRequired,
  disableTriggerTouch: require('prop-types').bool.isRequired,
  enterDelay: require('prop-types').number.isRequired,
  leaveDelay: require('prop-types').number.isRequired,
  placement: require('prop-types').string.isRequired,
  children: typeof babelPluginFlowReactPropTypes_proptype_Element === 'function' ? babelPluginFlowReactPropTypes_proptype_Element.isRequired ? babelPluginFlowReactPropTypes_proptype_Element.isRequired : babelPluginFlowReactPropTypes_proptype_Element : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Element).isRequired
}, (0, _defineProperty3.default)(_ref3, 'classes', require('prop-types').object), (0, _defineProperty3.default)(_ref3, 'className', require('prop-types').string), (0, _defineProperty3.default)(_ref3, 'disableTriggerFocus', require('prop-types').bool), (0, _defineProperty3.default)(_ref3, 'disableTriggerHover', require('prop-types').bool), (0, _defineProperty3.default)(_ref3, 'disableTriggerTouch', require('prop-types').bool), (0, _defineProperty3.default)(_ref3, 'label', typeof babelPluginFlowReactPropTypes_proptype_Node === 'function' ? babelPluginFlowReactPropTypes_proptype_Node.isRequired ? babelPluginFlowReactPropTypes_proptype_Node.isRequired : babelPluginFlowReactPropTypes_proptype_Node : require('prop-types').shape(babelPluginFlowReactPropTypes_proptype_Node).isRequired), (0, _defineProperty3.default)(_ref3, 'onRequestClose', require('prop-types').func), (0, _defineProperty3.default)(_ref3, 'onRequestOpen', require('prop-types').func), (0, _defineProperty3.default)(_ref3, 'open', require('prop-types').bool), (0, _defineProperty3.default)(_ref3, 'enterDelay', require('prop-types').number), (0, _defineProperty3.default)(_ref3, 'leaveDelay', require('prop-types').number), (0, _defineProperty3.default)(_ref3, 'placement', require('prop-types').oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top'])), (0, _defineProperty3.default)(_ref3, 'PopperProps', require('prop-types').object), _ref3) : {};
exports.default = (0, _withStyles2.default)(styles, { name: 'MuiTooltip' })(Tooltip);