'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dark = exports.light = undefined;

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

exports.default = createPalette;

var _warning = require('warning');

var _warning2 = _interopRequireDefault(_warning);

var _deepmerge = require('deepmerge');

var _deepmerge2 = _interopRequireDefault(_deepmerge);

var _indigo = require('../colors/indigo');

var _indigo2 = _interopRequireDefault(_indigo);

var _pink = require('../colors/pink');

var _pink2 = _interopRequireDefault(_pink);

var _grey = require('../colors/grey');

var _grey2 = _interopRequireDefault(_grey);

var _red = require('../colors/red');

var _red2 = _interopRequireDefault(_red);

var _common = require('../colors/common');

var _common2 = _interopRequireDefault(_common);

var _colorManipulator = require('./colorManipulator');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// < 1kb payload overhead when lodash/merge is > 3kb.
var light = exports.light = {
  text: {
    primary: 'rgba(0, 0, 0, 0.87)',
    secondary: 'rgba(0, 0, 0, 0.54)',
    disabled: 'rgba(0, 0, 0, 0.38)',
    hint: 'rgba(0, 0, 0, 0.38)',
    icon: 'rgba(0, 0, 0, 0.38)',
    divider: 'rgba(0, 0, 0, 0.12)',
    lightDivider: 'rgba(0, 0, 0, 0.075)'
  },
  input: {
    bottomLine: 'rgba(0, 0, 0, 0.42)',
    helperText: 'rgba(0, 0, 0, 0.54)',
    labelText: 'rgba(0, 0, 0, 0.54)',
    inputText: 'rgba(0, 0, 0, 0.87)',
    disabled: 'rgba(0, 0, 0, 0.42)'
  },
  action: {
    active: 'rgba(0, 0, 0, 0.54)',
    disabled: 'rgba(0, 0, 0, 0.26)'
  },
  background: {
    default: _grey2.default[50],
    paper: _common2.default.white,
    appBar: _grey2.default[100],
    contentFrame: _grey2.default[200]
  }
};

var dark = exports.dark = {
  text: {
    primary: 'rgba(255, 255, 255, 1)',
    secondary: 'rgba(255, 255, 255, 0.7)',
    disabled: 'rgba(255, 255, 255, 0.5)',
    hint: 'rgba(255, 255, 255, 0.5)',
    icon: 'rgba(255, 255, 255, 0.5)',
    divider: 'rgba(255, 255, 255, 0.12)',
    lightDivider: 'rgba(255, 255, 255, 0.075)'
  },
  input: {
    bottomLine: 'rgba(255, 255, 255, 0.7)',
    helperText: 'rgba(255, 255, 255, 0.7)',
    labelText: 'rgba(255, 255, 255, 0.7)',
    inputText: 'rgba(255, 255, 255, 1)',
    disabled: 'rgba(255, 255, 255, 0.5)'
  },
  action: {
    active: 'rgba(255, 255, 255, 1)',
    disabled: 'rgba(255, 255, 255, 0.3)'
  },
  background: {
    default: '#303030',
    paper: _grey2.default[800],
    appBar: _grey2.default[900],
    contentFrame: _grey2.default[900],
    status: _common2.default.black
  }
};

function getContrastText(color) {
  if ((0, _colorManipulator.getContrastRatio)(color, _common2.default.black) < 7) {
    return dark.text.primary;
  }
  return light.text.primary;
}

function createPalette(palette) {
  var _palette$primary = palette.primary,
      primary = _palette$primary === undefined ? _indigo2.default : _palette$primary,
      _palette$secondary = palette.secondary,
      secondary = _palette$secondary === undefined ? _pink2.default : _palette$secondary,
      _palette$error = palette.error,
      error = _palette$error === undefined ? _red2.default : _palette$error,
      _palette$type = palette.type,
      type = _palette$type === undefined ? 'light' : _palette$type,
      other = (0, _objectWithoutProperties3.default)(palette, ['primary', 'secondary', 'error', 'type']);

  var shades = { dark: dark, light: light };

  process.env.NODE_ENV !== "production" ? (0, _warning2.default)(shades[type], 'Material-UI: the palette type `' + type + '` is not supported.') : void 0;

  var paletteOutput = (0, _deepmerge2.default)({
    common: _common2.default,
    type: type,
    primary: primary,
    secondary: secondary,
    error: error,
    grey: _grey2.default,
    shades: shades,
    text: shades[type].text,
    input: shades[type].input,
    action: shades[type].action,
    background: shades[type].background,
    getContrastText: getContrastText
  }, other);

  // Dev warnings
  if (process.env.NODE_ENV !== 'production') {
    var difference = function difference(base, compare) {
      if (!compare) {
        compare = {};
      }

      return (0, _keys2.default)(base).filter(function (hue) {
        return !compare[hue];
      });
    };

    var paletteColorError = function paletteColorError(name, base, compare) {
      var missing = difference(base, compare);
      process.env.NODE_ENV !== "production" ? (0, _warning2.default)(missing.length === 0, ['Material-UI: ' + name + ' color is missing the following hues: ' + missing.join(','), 'See the default colors, indigo, or pink, as exported from material-ui/colors.'].join('\n')) : void 0;
    };

    paletteColorError('primary', _indigo2.default, paletteOutput.primary);
    paletteColorError('secondary', _pink2.default, paletteOutput.secondary);
    paletteColorError('error', _red2.default, paletteOutput.error);
    paletteColorError('grey', _red2.default, paletteOutput.grey);
  }

  return paletteOutput;
}