var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';

import PropTypes from 'prop-types';
import classNames from 'classnames';
import withStyles from '../styles/withStyles';

export const styles = theme => ({
  root: {
    color: theme.palette.input.helperText,
    fontFamily: theme.typography.fontFamily,
    fontSize: 12,
    textAlign: 'left',
    marginTop: theme.spacing.unit,
    lineHeight: '1em',
    minHeight: '1em',
    margin: 0
  },
  dense: {
    marginTop: theme.spacing.unit / 2
  },
  error: {
    color: theme.palette.error.A400
  },
  disabled: {
    color: theme.palette.input.disabled
  }
});

function FormHelperText(props, context) {
  const {
    children,
    classes,
    className: classNameProp,
    disabled: disabledProp,
    error: errorProp,
    margin: marginProp
  } = props,
        other = _objectWithoutProperties(props, ['children', 'classes', 'className', 'disabled', 'error', 'margin']);
  const { muiFormControl } = context;

  let disabled = disabledProp;
  let error = errorProp;
  let margin = marginProp;

  if (muiFormControl) {
    if (typeof disabled === 'undefined') {
      disabled = muiFormControl.disabled;
    }

    if (typeof error === 'undefined') {
      error = muiFormControl.error;
    }

    if (typeof margin === 'undefined') {
      margin = muiFormControl.margin;
    }
  }

  const className = classNames(classes.root, {
    [classes.disabled]: disabled,
    [classes.error]: error,
    [classes.dense]: margin === 'dense'
  }, classNameProp);

  return React.createElement(
    'p',
    _extends({ className: className }, other),
    children
  );
}

FormHelperText.contextTypes = {
  muiFormControl: PropTypes.object
};

export default withStyles(styles, { name: 'MuiFormHelperText' })(FormHelperText);