var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import withStyles from '../styles/withStyles';
import { capitalizeFirstLetter } from '../utils/helpers';
import { darken, fade, lighten } from '../styles/colorManipulator';

export const styles = theme => ({
  root: {
    // Workaround for a rendering bug with spanned columns in Chrome 62.0.
    // Removes the alpha (sets it to 1), and lightens or darkens the theme color.
    borderBottom: `1px solid
    ${theme.palette.type === 'light' ? lighten(fade(theme.palette.text.lightDivider, 1), 0.925) : darken(fade(theme.palette.text.lightDivider, 1), 0.685)}`,
    textAlign: 'left'
  },
  numeric: {
    textAlign: 'right',
    flexDirection: 'row-reverse' // can be dynamically inherited at runtime by contents
  },
  typeHead: {
    color: theme.palette.text.secondary,
    fontSize: theme.typography.pxToRem(12),
    fontWeight: theme.typography.fontWeightMedium,
    position: 'relative' // Workaround for Tooltip positioning issue.
  },
  typeBody: {
    fontSize: theme.typography.pxToRem(13),
    color: theme.palette.text.primary
  },
  typeFooter: {
    borderBottom: 0,
    color: theme.palette.text.secondary,
    fontSize: theme.typography.pxToRem(12)
  },
  paddingDefault: {
    padding: `${theme.spacing.unit / 2}px ${theme.spacing.unit * 7}px ${theme.spacing.unit / 2}px ${theme.spacing.unit * 3}px`,
    '&:last-child': {
      paddingRight: theme.spacing.unit * 3
    }
  },
  paddingDense: {
    paddingRight: theme.spacing.unit * 3
  },
  paddingCheckbox: {
    padding: '0 12px'
  }
});

function TableCell(props, context) {
  const {
    children,
    classes,
    className: classNameProp,
    component,
    sortDirection,
    numeric,
    padding,
    type
  } = props,
        other = _objectWithoutProperties(props, ['children', 'classes', 'className', 'component', 'sortDirection', 'numeric', 'padding', 'type']);
  const { table } = context;
  let Component;
  if (component) {
    Component = component;
  } else {
    Component = table && table.head ? 'th' : 'td';
  }

  const className = classNames(classes.root, {
    [classes.numeric]: numeric,
    [classes[`padding${capitalizeFirstLetter(padding)}`]]: padding !== 'none' && padding !== 'default',
    [classes.paddingDefault]: padding !== 'none',
    [classes.typeHead]: type ? type === 'head' : table && table.head,
    [classes.typeBody]: type ? type === 'body' : table && table.body,
    [classes.typeFooter]: type ? type === 'footer' : table && table.footer
  }, classNameProp);

  let ariaSort = null;
  if (sortDirection) {
    ariaSort = sortDirection === 'asc' ? 'ascending' : 'descending';
  }

  return React.createElement(
    Component,
    _extends({ className: className, 'aria-sort': ariaSort }, other),
    children
  );
}

TableCell.propTypes = {
  /**
   * The table cell contents.
   */
  children: PropTypes.node,
  /**
   * Useful to extend the style applied to components.
   */
  classes: PropTypes.object.isRequired,
  /**
   * @ignore
   */
  className: PropTypes.string,
  /**
   * The component used for the root node.
   * Either a string to use a DOM element or a component.
   */
  component: PropTypes.oneOfType([PropTypes.string, PropTypes.func]),
  /**
   * If `true`, content will align to the right.
   */
  numeric: PropTypes.bool,
  /**
   * Sets the padding applied to the cell.
   */
  padding: PropTypes.oneOf(['default', 'checkbox', 'dense', 'none']),
  /**
   * Set aria-sort direction.
   */
  sortDirection: PropTypes.oneOf(['asc', 'desc', false]),
  /**
   * Specify the cell type.
   * By default, the TableHead, TableBody or TableFooter parent component set the value.
   */
  type: PropTypes.oneOf(['head', 'body', 'footer'])
};

TableCell.defaultProps = {
  numeric: false,
  padding: 'default'
};

TableCell.contextTypes = {
  table: PropTypes.object.isRequired
};

export default withStyles(styles, { name: 'MuiTableCell' })(TableCell);