var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import KeyboardArrowLeft from '../internal/svg-icons/KeyboardArrowLeft';
import KeyboardArrowRight from '../internal/svg-icons/KeyboardArrowRight';
import withStyles from '../styles/withStyles';
import IconButton from '../IconButton';

export const styles = theme => ({
  root: {
    flexShrink: 0,
    color: theme.palette.text.secondary,
    marginLeft: theme.spacing.unit * 2.5
  }
});

/**
 * @ignore - internal component.
 */
class TablePaginationActions extends React.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.handleBackButtonClick = event => {
      this.props.onChangePage(event, this.props.page - 1);
    }, this.handleNextButtonClick = event => {
      this.props.onChangePage(event, this.props.page + 1);
    }, _temp;
  }

  render() {
    const _props = this.props,
          {
      backIconButtonProps,
      classes,
      count,
      nextIconButtonProps,
      onChangePage,
      page,
      rowsPerPage,
      theme
    } = _props,
          other = _objectWithoutProperties(_props, ['backIconButtonProps', 'classes', 'count', 'nextIconButtonProps', 'onChangePage', 'page', 'rowsPerPage', 'theme']);

    return React.createElement(
      'div',
      _extends({ className: classes.root }, other),
      React.createElement(
        IconButton,
        _extends({
          onClick: this.handleBackButtonClick,
          disabled: page === 0
        }, backIconButtonProps),
        theme.direction === 'rtl' ? React.createElement(KeyboardArrowRight, null) : React.createElement(KeyboardArrowLeft, null)
      ),
      React.createElement(
        IconButton,
        _extends({
          onClick: this.handleNextButtonClick,
          disabled: page >= Math.ceil(count / rowsPerPage) - 1
        }, nextIconButtonProps),
        theme.direction === 'rtl' ? React.createElement(KeyboardArrowLeft, null) : React.createElement(KeyboardArrowRight, null)
      )
    );
  }
}

TablePaginationActions.propTypes = {
  /**
   * Properties applied to the back arrow `IconButton` component.
   */
  backIconButtonProps: PropTypes.object,
  /**
   * Useful to extend the style applied to components.
   */
  classes: PropTypes.object.isRequired,
  /**
   * The total number of rows.
   */
  count: PropTypes.number.isRequired,
  /**
   * Properties applied to the next arrow `IconButton` component.
   */
  nextIconButtonProps: PropTypes.object,
  /**
   * Callback fired when the page is changed.
   *
   * @param {object} event The event source of the callback
   * @param {number} page The page selected
   */
  onChangePage: PropTypes.func.isRequired,
  /**
   * The zero-based index of the current page.
   */
  page: PropTypes.number.isRequired,
  /**
   * The number of rows per page.
   */
  rowsPerPage: PropTypes.number.isRequired,
  /**
   * @ignore
   */
  theme: PropTypes.object.isRequired
};

export default withStyles(styles, { name: 'MuiTablePaginationActions', withTheme: true })(TablePaginationActions);