"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = StyledEngineProvider;
exports.cache = void 0;

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react2 = require("@emotion/react");

var _cache = _interopRequireDefault(require("@emotion/cache"));

// Cache with option to prepend emotion's style tag
const cache = (0, _cache.default)({
  key: 'css',
  prepend: true
});
exports.cache = cache;

function StyledEngineProvider(props) {
  const {
    injectFirst,
    children
  } = props;
  return injectFirst ? /*#__PURE__*/React.createElement(_react2.CacheProvider, {
    value: cache
  }, children) : children;
}

process.env.NODE_ENV !== "production" ? StyledEngineProvider.propTypes = {
  /**
   * Your component tree.
   */
  children: _propTypes.default.node,

  /**
   * By default, the styles are injected last in the <head> element of the page.
   * As a result, they gain more specificity than any other style sheet.
   * If you want to override Material-UI's styles, set this prop.
   */
  injectFirst: _propTypes.default.bool
} : void 0;