"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withThemeCreator = withThemeCreator;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _utils = require("@material-ui/utils");

var _useTheme = _interopRequireDefault(require("../useTheme"));

function withThemeCreator() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var defaultTheme = options.defaultTheme;

  var withTheme = function withTheme(Component) {
    if (process.env.NODE_ENV !== 'production' && Component === undefined) {
      throw new Error(['You are calling withTheme(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
    }

    var WithTheme = _react.default.forwardRef(function WithTheme(props, ref) {
      var innerRef = props.innerRef,
          other = (0, _objectWithoutProperties2.default)(props, ["innerRef"]);
      var theme = (0, _useTheme.default)() || defaultTheme;
      return _react.default.createElement(Component, (0, _extends2.default)({
        theme: theme,
        ref: innerRef || ref
      }, other));
    });

    process.env.NODE_ENV !== "production" ? WithTheme.propTypes = {
      /**
       * Use that property to pass a ref callback to the decorated component.
       * @deprecated
       */
      innerRef: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]), function (props) {
        if (props.innerRef == null) {
          return null;
        }

        return new Error('Material-UI: the `innerRef` prop is deprecated and will be removed in v5. ' + 'Refs are now automatically forwarded to the inner component.');
      })
    } : void 0;

    if (process.env.NODE_ENV !== 'production') {
      WithTheme.displayName = "WithTheme(".concat((0, _utils.getDisplayName)(Component), ")");
    }

    (0, _hoistNonReactStatics.default)(WithTheme, Component);

    if (process.env.NODE_ENV !== 'production') {
      // Exposed for test purposes.
      WithTheme.Naked = Component;
    }

    return WithTheme;
  };

  return withTheme;
} // Provide the theme object as a property to the input component.
// It's an alternative API to useTheme().
// We encourage the usage of useTheme() where possible.


var withTheme = withThemeCreator();
var _default = withTheme;
exports.default = _default;