"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _jss = require("jss");

var _StylesProvider = _interopRequireDefault(require("../StylesProvider"));

var _createGenerateClassName = _interopRequireDefault(require("../createGenerateClassName"));

class ServerStyleSheets {
  constructor(options = {}) {
    this.options = options;
  }

  collect(children) {
    // This is needed in order to deduplicate the injection of CSS in the page.
    const sheetsManager = new Map(); // This is needed in order to inject the critical CSS.

    this.sheetsRegistry = new _jss.SheetsRegistry(); // A new class name generator

    const generateClassName = (0, _createGenerateClassName.default)();
    return /*#__PURE__*/React.createElement(_StylesProvider.default, (0, _extends2.default)({
      sheetsManager: sheetsManager,
      serverGenerateClassName: generateClassName,
      sheetsRegistry: this.sheetsRegistry
    }, this.options), children);
  }

  toString() {
    return this.sheetsRegistry ? this.sheetsRegistry.toString() : '';
  }

  getStyleElement(props) {
    return /*#__PURE__*/React.createElement('style', (0, _extends2.default)({
      id: 'jss-server-side',
      key: 'jss-server-side',
      dangerouslySetInnerHTML: {
        __html: this.toString()
      }
    }, props));
  }

}

exports.default = ServerStyleSheets;