"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withThemeCreator = withThemeCreator;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _utils = require("@material-ui/utils");

var _useTheme = _interopRequireDefault(require("../useTheme"));

function withThemeCreator(options = {}) {
  const {
    defaultTheme
  } = options;

  const withTheme = Component => {
    if (process.env.NODE_ENV !== 'production') {
      if (Component === undefined) {
        throw new Error(['You are calling withTheme(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
      }
    }

    const WithTheme = /*#__PURE__*/React.forwardRef(function WithTheme(props, ref) {
      const {
        innerRef
      } = props,
            other = (0, _objectWithoutPropertiesLoose2.default)(props, ["innerRef"]);
      const theme = (0, _useTheme.default)() || defaultTheme;
      return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
        theme: theme,
        ref: innerRef || ref
      }, other));
    });
    process.env.NODE_ENV !== "production" ? WithTheme.propTypes = {
      /**
       * Use that prop to pass a ref to the decorated component.
       * @deprecated
       */
      innerRef: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]), props => {
        if (props.innerRef == null) {
          return null;
        }

        return new Error('Material-UI: The `innerRef` prop is deprecated and will be removed in v5. ' + 'Refs are now automatically forwarded to the inner component.');
      })
    } : void 0;

    if (process.env.NODE_ENV !== 'production') {
      WithTheme.displayName = `WithTheme(${(0, _utils.getDisplayName)(Component)})`;
    }

    (0, _hoistNonReactStatics.default)(WithTheme, Component);

    if (process.env.NODE_ENV !== 'production') {
      // Exposed for test purposes.
      WithTheme.Naked = Component;
    }

    return WithTheme;
  };

  return withTheme;
} // Provide the theme object as a prop to the input component.
// It's an alternative API to useTheme().
// We encourage the usage of useTheme() where possible.


const withTheme = withThemeCreator();
var _default = withTheme;
exports.default = _default;