import responsivePropType from './responsivePropType';
import style from './style';
import compose from './compose';
import { createUnaryUnit, getStyleFromPropValue } from './spacing';
import { handleBreakpoints } from './breakpoints';

function getBorder(value) {
  if (typeof value !== 'number') {
    return value;
  }

  return "".concat(value, "px solid");
}

export var border = style({
  prop: 'border',
  themeKey: 'borders',
  transform: getBorder
});
export var borderTop = style({
  prop: 'borderTop',
  themeKey: 'borders',
  transform: getBorder
});
export var borderRight = style({
  prop: 'borderRight',
  themeKey: 'borders',
  transform: getBorder
});
export var borderBottom = style({
  prop: 'borderBottom',
  themeKey: 'borders',
  transform: getBorder
});
export var borderLeft = style({
  prop: 'borderLeft',
  themeKey: 'borders',
  transform: getBorder
});
export var borderColor = style({
  prop: 'borderColor',
  themeKey: 'palette'
});

function resolveCssProperty(props, prop, transformer) {
  // Using a hash computation over an array iteration could be faster, but with only 28 items,
  // it isn't worth the bundle size.
  if (prop !== 'borderRadius') {
    return null;
  }

  var cssProperties = ['borderRadius'];
  var styleFromPropValue = getStyleFromPropValue(cssProperties, transformer);
  var propValue = props[prop];
  return handleBreakpoints(props, propValue, styleFromPropValue);
}

export var borderRadius = function borderRadius(props) {
  var transformer = createUnaryUnit(props.theme, 'shape.borderRadius', 4, 'borderRadius');
  return props.borderRadius ? resolveCssProperty(props, 'borderRadius', transformer) : {};
};
borderRadius.propTypes = process.env.NODE_ENV !== 'production' ? {
  borderRadius: responsivePropType
} : {};
borderRadius.filterProps = ['borderRadius'];
var borders = compose(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderRadius);
export default borders;