"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _merge = _interopRequireDefault(require("../merge"));

var _getThemeValue = _interopRequireWildcard(require("../getThemeValue"));

var _breakpoints = require("../breakpoints");

function objectsHaveSameKeys(...objects) {
  const allKeys = objects.reduce((keys, object) => keys.concat(Object.keys(object)), []);
  const union = new Set(allKeys);
  return objects.every(object => union.size === Object.keys(object).length);
}

function callIfFn(maybeFn, arg) {
  return typeof maybeFn === 'function' ? maybeFn(arg) : maybeFn;
}

function styleFunctionSx(props) {
  const {
    sx: styles,
    theme = {}
  } = props || {};
  if (!styles) return null;

  if (typeof styles === 'function') {
    return styles(theme);
  }

  if (typeof styles !== 'object') {
    // value
    return styles;
  }

  const emptyBreakpoints = (0, _breakpoints.createEmptyBreakpointObject)(theme.breakpoints);
  const breakpointsKeys = Object.keys(emptyBreakpoints);
  let css = emptyBreakpoints;
  Object.keys(styles).forEach(styleKey => {
    const value = callIfFn(styles[styleKey], theme);

    if (typeof value === 'object') {
      if (_getThemeValue.propToStyleFunction[styleKey]) {
        css = (0, _merge.default)(css, (0, _getThemeValue.default)(styleKey, value, theme));
      } else {
        const breakpointsValues = (0, _breakpoints.handleBreakpoints)({
          theme
        }, value, x => ({
          [styleKey]: x
        }));

        if (objectsHaveSameKeys(breakpointsValues, value)) {
          css[styleKey] = styleFunctionSx({
            sx: value,
            theme
          });
        } else {
          css = (0, _merge.default)(css, breakpointsValues);
        }
      }
    } else {
      css = (0, _merge.default)(css, (0, _getThemeValue.default)(styleKey, value, theme));
    }
  });
  return (0, _breakpoints.removeUnusedBreakpoints)(breakpointsKeys, css);
}

styleFunctionSx.filterProps = ['sx'];
var _default = styleFunctionSx;
exports.default = _default;