import * as React from 'react';
import PropTypes from 'prop-types';
import clsx from 'clsx';
import sliderUnstyledClasses from './sliderUnstyledClasses';

var useValueLabelClasses = function useValueLabelClasses(props) {
  var open = props.open;
  var utilityClasses = {
    offset: clsx(sliderUnstyledClasses.valueLabel, sliderUnstyledClasses.valueLabelOffset, open && sliderUnstyledClasses.valueLabelOpen),
    circle: sliderUnstyledClasses.valueLabelCircle,
    label: sliderUnstyledClasses.valueLabelLabel
  };
  return utilityClasses;
};
/**
 * @ignore - internal component.
 */


function SliderValueLabelUnstyled(props) {
  var children = props.children,
      className = props.className,
      value = props.value,
      _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      theme = props.theme;
  var classes = useValueLabelClasses(props);
  var Root = components.Root || 'span';
  return /*#__PURE__*/React.cloneElement(children, {
    className: clsx(children.props.className)
  }, /*#__PURE__*/React.createElement(React.Fragment, null, children.props.children, /*#__PURE__*/React.createElement(Root, {
    className: clsx(classes.offset, className),
    theme: theme,
    "aria-hidden": true
  }, /*#__PURE__*/React.createElement("span", {
    className: classes.circle
  }, /*#__PURE__*/React.createElement("span", {
    className: classes.label
  }, value)))));
}

process.env.NODE_ENV !== "production" ? SliderValueLabelUnstyled.propTypes = {
  children: PropTypes.element.isRequired,
  className: PropTypes.string,
  components: PropTypes.shape({
    Root: PropTypes.elementType
  }),
  theme: PropTypes.any,
  value: PropTypes.node
} : void 0;
export default SliderValueLabelUnstyled;