"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _sliderUnstyledClasses = _interopRequireDefault(require("./sliderUnstyledClasses"));

const useValueLabelClasses = props => {
  const {
    open
  } = props;
  const utilityClasses = {
    offset: (0, _clsx.default)(_sliderUnstyledClasses.default.valueLabel, _sliderUnstyledClasses.default.valueLabelOffset, open && _sliderUnstyledClasses.default.valueLabelOpen),
    circle: _sliderUnstyledClasses.default.valueLabelCircle,
    label: _sliderUnstyledClasses.default.valueLabelLabel
  };
  return utilityClasses;
};
/**
 * @ignore - internal component.
 */


function SliderValueLabelUnstyled(props) {
  const {
    children,
    className,
    value,
    components = {},
    theme
  } = props;
  const classes = useValueLabelClasses(props);
  const Root = components.Root || 'span';
  return /*#__PURE__*/React.cloneElement(children, {
    className: (0, _clsx.default)(children.props.className)
  }, /*#__PURE__*/React.createElement(React.Fragment, null, children.props.children, /*#__PURE__*/React.createElement(Root, {
    className: (0, _clsx.default)(classes.offset, className),
    theme: theme,
    "aria-hidden": true
  }, /*#__PURE__*/React.createElement("span", {
    className: classes.circle
  }, /*#__PURE__*/React.createElement("span", {
    className: classes.label
  }, value)))));
}

process.env.NODE_ENV !== "production" ? SliderValueLabelUnstyled.propTypes = {
  children: _propTypes.default.element.isRequired,
  className: _propTypes.default.string,
  components: _propTypes.default.shape({
    Root: _propTypes.default.elementType
  }),
  theme: _propTypes.default.any,
  value: _propTypes.default.node
} : void 0;
var _default = SliderValueLabelUnstyled;
exports.default = _default;