### [Versions](https://material-ui.com/versions/)

## 5.0.0-beta.5

<!-- generated comparing v5.0.0-beta.4..next -->

_Aug 24, 2021_

A big thanks to the 26 contributors who made this release possible. Here are some highlights ✨:

- 🐛 Fixed a lot of bugs and regressions to get us closer to the [v5 stable release milestone](https://github.com/mui-org/material-ui/milestone/44)
- 📚 Improved the docs and the migration guide for upgrading to v5

### `@material-ui/core@5.0.0-beta.5`

#### Breaking changes

- <!-- 36 --> [core] Update `.browserslistrc` file (#27788) @DanailH

  The targets of the default bundle have changed:

  - Chrome 90 (up from 84)
  - Edge 91 (up from 85)
  - Safari 14 (macOS) (up from 13.1) and 12.4 (iOS) (up from 12.2)
  - Opera 76 (up from 70)

- <!-- 43 --> [Autocomplete] Rename Value type to AutocompleteValue (#27804) @michaldudak

  The `useAutocomplete` hook used a type called `Value`. It was a very generic name for a type specific to the `Autocomplete` control, so it was removed to `AutocompleteValue`.

  ```diff
  -import { Value } from '@material-ui/core/useAutocomplete';
  +import { AutocompleteValue } from '@material-ui/core/useAutocomplete';
  ```

#### Changes

- <!-- 42 --> [AppBar] Fix transparency issue on dark mode (#27281) @will-amaral
- <!-- 29 --> Revert "[BottomNavigation] onClick does not fire if tapped while scrolling (#22524)" (#27690) @eps1lon
- <!-- 68 --> [Autocomplete] Add verbose warning for defaultValue (#27925) @vedadeepta
- <!-- 78 --> [Badge] Add missing classes to exported class object (#27943) @pvdstel
- <!-- 41 --> [ButtonGroup] Allow `size` customization via module augmentation (#27834) @aaronlademann-wf
- <!-- 67 --> [InputBase] Preserve host state  when changing `rows` from undefined to defined (#27683) @eps1lon
- <!-- 18 --> [InputLabel] Apply `asterisk` class when `required` (#27738) @alexile
- <!-- 26 --> [Select] Fix NativeSelect propagating classes to the DOM element (#27797) @mnajdova
- <!-- 28 --> [Stack] Match the customization standard (#27777) @oliviertassinari
- <!-- 70 --> [SvgIcon] Apply custom color if defined in the theme (#27923) @eps1lon
- <!-- 65 --> [Switch] Add optional `track` slot to SwitchUnstyled (#27916) @michaldudak
- <!-- 52 --> [Tooltip] Fix broken arrow position in rtl (#27868) @mnajdova
- <!-- 02 --> [transitions] Allow to run Slide into a custom container (#26623) @benny0642

### `@material-ui/system@5.0.0-beta.5`

#### Breaking changes

- <!-- 40 --> [system] Rename `styleProps` to `ownerState` (#27830) @mnajdova

  The change was done in order to better reflect what they are, not what we think they will be used for.

  ```diff
   <SomeSlotComponent
  -  styleProps={propsAndState}
  +  ownerState={propsAndState}
   />
  ```

#### Changes

- <!-- 63 --> [system] Remove dependency on `overridesResolver` for the `variants` (#27859) @mnajdova
- <!-- 32 --> [system] Forward `classes` prop if no slot specified in the options (#27795) @mnajdova
- <!-- 46 --> [system] Fix pseudo class overridden in variants (#27847) @hbjORbj

### `@material-ui/icons@5.0.0-beta.5`

- <!-- 13 --> [icons] Improve GitHub size (#27740) @oliviertassinari

### `@material-ui/styled-engine@5.0.0-beta.5`

- <!-- 27 --> [styled-engine] Remove unecessary aliases (#27779) @oliviertassinari
- <!-- 14 --> [styled-engine] Drop withComponent support (#27780) @oliviertassinari

### `@material-ui/unstyled@5.0.0-alpha.44`

- <!-- 07 --> [core] Utilize `CSS.supports` in `SliderUnstyled` component (#27724) @DanailH

### `@material-ui/lab@5.0.0-alpha.44`

- <!-- 54 --> [DatePicker] Fix click-away logic requiring second click in some cases (#24877) @eps1lon
- <!-- 05 --> [lab] Use the public API for module augmentation (#27735) @oliviertassinari
- <!-- 25 --> [Timeline] Fix color="inherit" on TimelineDot (#27794) @mnajdova

### Docs

- <!-- 77 --> [docs] Redesign on markdown page (#27860) @mnajdova
- <!-- 76 --> [docs] Split changelog into current and old (#27942) @eps1lon
- <!-- 74 --> [docs] Migration, emphasize theme structure change (#27935) @oliviertassinari
- <!-- 72 --> [docs] Fix missing `href` for AppDrawerNavItems (#27936) @eps1lon
- <!-- 71 --> [docs] Pass window of iframe to framed demos (#27924) @eps1lon
- <!-- 69 --> [docs] Simplify Select Chip demo styling (#27864) @LorenzHenk
- <!-- 60 --> [docs] Move from Redux to React Context (#27828) @eps1lon
- <!-- 58 --> [docs] Correct the useAutocomplete import path (#27805) @michaldudak
- <!-- 56 --> [docs] Fix Tooltip flicker when hovering between code icon and demo (#27841) @eps1lon
- <!-- 55 --> [docs] Don't log if a request was aborted in ServerRequestDatePicker demo (#27843) @eps1lon
- <!-- 53 --> [docs] Fix false-positive useToolbar warning when using the demo toolbar menu (#27842) @eps1lon
- <!-- 51 --> [docs] Add missing import (#27850) @nguyenyou
- <!-- 50 --> [docs] Fix circular integration demo (#27856) @LorenzHenk
- <!-- 48 --> [docs] A few examples is enough (#27874) @mekouar-mehdi
- <!-- 47 --> [docs] Improve README.md (#27852) @surajkumar016
- <!-- 45 --> [docs] Fix rtl issue on the demos (#27865) @mnajdova
- <!-- 44 --> [docs] Apply the new branding theme and do the AppBar redesign (#27789) @mnajdova
- <!-- 39 --> [docs] Improve grammar in 'Align list items' section (#27730) @atorenherrinton
- <!-- 38 --> [docs] Make API documentation tables horizontally scrollable (#27787) @jakeanq
- <!-- 37 --> [docs] Fix typo on "Customized dialogs" section (#27827) @nomanoff
- <!-- 33 --> [docs] Fix Autocomplete country layout shift (#27814) @oliviertassinari
- <!-- 23 --> [docs] Improve accessible labels for Card demos (#27675) @eps1lon
- <!-- 22 --> [docs] Run in StrictMode by default (#27693) @eps1lon
- <!-- 21 --> [docs] Display TypeScript code of demo if requested (#27691) @eps1lon
- <!-- 20 --> [docs] Use country image instead of emoji (#27723) @qiweiii
- <!-- 17 --> [docs] Zero runtime themeAugmentation documentation (#27706) @eps1lon
- <!-- 15 --> [docs] Fix MobileTextStepper example to match description (#27682) @nolastemgarden
- <!-- 12 --> [docs] Document the transfer-list limitations (#27783) @oliviertassinari
- <!-- 11 --> [docs] Move TypeScript docs in context (#27782) @oliviertassinari
- <!-- 10 --> [docs] Prefer linking API source TypeScript (#27781) @oliviertassinari
- <!-- 09 --> [docs] Improve the Modal onClose migration (#27775) @oliviertassinari
- <!-- 08 --> [docs] Fix outdated styled-engine docs (#27778) @oliviertassinari
- <!-- 06 --> [docs] Improve right to left guide (#27713) @mnajdova
- <!-- 04 --> [docs] Consistent line break (#27728) @oliviertassinari
- <!-- 03 --> [docs] Don't dispatch ignored "reset code variant" actions (#27712) @eps1lon
- <!-- 01 --> [docs] Fix sentence to be more grammatically correct (#27733) @atorenherrinton
- <!-- 16 --> [examples] Add code sandbox config with node version (#27798) @qiweiii
- <!-- 59 --> Revert "[examples] Fix nextjs with styled-components example (#27583)" (#27921) @mnajdova
- <!-- 57 --> Revert "[examples] Update create-react-app examples with styled-components to use package aliases (#27591)" (#27917) @mnajdova
- <!-- 66 --> [I10n] Add Khmer (kh-KH) locale support (#27915) @teachhay
- <!-- 62 --> [website] Add templates & design-kits page (#27811) @siriwatknp
- <!-- 61 --> [website] Improve rebranding homepage performance (#27838) @siriwatknp
- <!-- 49 --> [website] Honest a11y value proposition (#27826) @eps1lon
- <!-- 35 --> [website] Improve homepage rebranding (#27663) @siriwatknp
- <!-- 24 --> [website] A few polish (#27741) @oliviertassinari
- <!-- 73 --> [website] Polish homepage (#27930) @oliviertassinari

### Core

- <!-- 64 --> [core] Fix various flip: false regressions (#27920) @mnajdova
- <!-- 31 --> [core] Fix typo in code comment (#27818) @hamidreza-nateghi
- <!-- 19 --> [core] Fix typos in repository (#27785) @JEONGJIHUN
- <!-- 75 --> [test] Current behavior when disabling components variants (#27376) @noviicee
- <!-- 30 --> [tests Improve test for checking if classes is forwarded to any DOM element (#27815) @mnajdova
- <!-- 34 --> [tests] Replace legacy `describeConformance` with `describeConformanceV5` (#27817) @mnajdova

All contributors of this release in alphabetical order: @aaronlademann-wf, @alexile, @atorenherrinton, @benny0642, @DanailH, @eps1lon, @hamidreza-nateghi, @hbjORbj, @jakeanq, @JEONGJIHUN, @LorenzHenk, @mekouar-mehdi, @michaldudak, @mnajdova, @nguyenyou, @nolastemgarden, @nomanoff, @noviicee, @oliviertassinari, @pvdstel, @qiweiii, @siriwatknp, @surajkumar016, @teachhay, @vedadeepta, @will-amaral

## 5.0.0-beta.4

<!-- generated comparing v5.0.0-beta.3..next -->

_Aug 13, 2021_

Big thanks to the 19 contributors who made this release possible. Here are some highlights ✨:

- 🐛 Grid's "auto" behavior has been fixed by @aaronlademann-wf (#27514)
- ♿ An important bug with the keyboard navigation in MenuList was fixed (#27526) @ryancogswell

### `@material-ui/core@5.0.0-beta.4`

#### Breaking changes

- <!-- 07 --> [Grid] Fix "auto" behavior to match natural width of its content (#27514) @aaronlademann-wf

#### Changes

- <!-- 30 --> [ButtonBase] Fix tabIndex type (#27684) @kylegach
- <!-- 13 --> [MenuList] Fix text navigation (#27526) @ryancogswell
- <!-- 01 --> [l10n] Add Arabic Sudan (ar-SD) locale (#27588) @YassinHussein
- <!-- 23 --> [Radio] Fix size prop forwarding with custom icons (#27656) @DouglasPds
- <!-- 10 --> [TextField] Password visibility icons ( "visibility" ⇔ "visibility-off" ) should be reversed (#27507) @tonextone
- <!-- 18 --> [ToggleButton] Fix handling of color prop (#27635) @oliviertassinari

### `@material-ui/codemods@5.0.0-beta.4`

- <!-- 20 --> [codemod] Fix filename case sensitive duplicate @oliviertassinari

### `@material-ui/system@5.0.0-beta.4`

- <!-- 28 --> [StyledEngineProvider] Remove unnecessary emotion cache export (#27680) @garronej
- <!-- 11 --> [system] Fix missing filterProps in compose type (#27618) @R-Bower

### `@material-ui/labs@5.0.0-alpha.42`

- <!-- 27 --> [CalendarPicker] Improve contrast between enabled and disabled days (#27603) @nikitabobers
- <!-- 32 --> [PickersDay] Render `children` if specified (#27462) @abriginets
- <!-- 05 --> [TreeView] Fix TreeItem label overflow (#27585) @LorenzHenk

### Docs

- <!-- 36 --> [docs] Update guides for @material-ui/styled-engine-sc installation (#27602) @mnajdova
- <!-- 35 --> [docs] Document that @material-ui/styles is not strict mode compatible (#27639) @oliviertassinari
- <!-- 34 --> [docs] Link to "Customization of Theme" from relevant theme interfaces (#27689) @eps1lon
- <!-- 33 --> [docs] Update CSP page (#27627) @mnajdova
- <!-- 29 --> [docs] Reorder and rename "enforce value" ToggleButton demo (#27678) @LorenzHenk
- <!-- 12 --> [docs] Fix missing dependency in the DataGrid demo (#27597) @m4theushw
- <!-- 04 --> [docs] img should have a src attribute (#27632) @oliviertassinari
- <!-- 03 --> [docs] Add badges to Transfer List (#27634) @oliviertassinari
- <!-- 02 --> [docs] Recommend the `direct-import` babel plugin over `transform-import` (#27335) @umidbekk
- <!-- 37 --> [docs] Remove unused code (#27711) @eps1lon
- <!-- 39 --> [docs] Improve virtualization demo (#27340) @vedadeepta
- <!-- 31 --> [examples] Include a follow-up on the example (#27620) @matiasherranz
- <!-- 26 --> [website] Add about page (#27599) @siriwatknp
- <!-- 25 --> [website] Add pricing page (#27598) @siriwatknp

### Core

- <!-- 16 --> [core] Batch small changes (#27636) @oliviertassinari
- <!-- 06 --> [core] Change range strategy to bump (#27652) @oliviertassinari
- <!-- 24 --> [core] Fix visual regression example images (#27660) @eps1lon
- <!-- 38 --> [core] Remove diff when running yarn docs:dev (#27720) @eps1lon
- <!-- 22 --> [core] Remove mocks of require.context in markdown loader (#27406) @eps1lon
- <!-- 09 --> [core] Reduce use CSS when Checkbox disableRipple is set (#27568) @oliviertassinari
- <!-- 08 --> [test] Add coverage for jss-to-styled prefix from filename (#27522) @eps1lon
- <!-- 15 --> [test] Add current behavior for a11y name vs visible name for PickersDay (#27661) @eps1lon
- <!-- 17 --> [test] Dodge double logging in dev mode (#27653) @oliviertassinari
- <!-- 14 --> [test] Enable skipped test fixed by upstream React fix (#27615) @eps1lon
- <!-- 19 --> [theme] Add missed variants in Components interface (#27453) @nikitabobers

All contributors of this release in alphabetical order: @aaronlademann-wf, @abriginets, @DouglasPds, @eps1lon, @garronej, @kylegach, @LorenzHenk, @m4theushw, @matiasherranz, @mnajdova, @nikitabobers, @oliviertassinari, @R-Bower, @ryancogswell, @siriwatknp, @tonextone, @umidbekk, @vedadeepta, @YassinHussein

## 5.0.0-beta.3

<!-- generated comparing v5.0.0-beta.2..next -->

_Aug 6, 2021_

Big thanks to the 15 contributors who made this release possible. Here are some highlights ✨:

- <!-- 28 --> ✨ `jss-to-styled` codemod has been improved to support `createStyles` and `<React.Fragment>` usage (#27578) @mnajdova

### `@material-ui/core@5.0.0-beta.3`

- <!-- 33 --> [Modal] Restore `overflowX` and `overflowY` styles (#27487) @PCOffline
- <!-- 07 --> [Modal] Remove unnecessary check for children.props.tabIndex (#27374) @noviicee
- <!-- 14 --> [Select] Fix regression for icon not rotating (#27511) @mnajdova

### `@material-ui/system@5.0.0-beta.3`

- <!-- 38 --> [system] Added top, left, right and bottom border color CSS properties to system (#27580) @R-Bower

### `@material-ui/codemod@5.0.0-beta.3`

- <!-- 28 --> [codemod] Add support for `createStyles` usage in `jss-to-styled` (#27578) @mnajdova
- <!-- 11 --> [codemod] Fix `jss-to-styled` PREFIX generation on Windows (#27491) @mnajdova
- <!-- 39 --> [codemod] Fix `jss-to-styled` codemod to handle React.Fragment as root (#27495) @mnajdova

### `@material-ui/unstyled@5.0.0-alpha.42`

- <!-- 13 --> [FormControl] Create FormControlUnstyled (#27240) @michaldudak
- <!-- 23 --> [Autocomplete] Move useAutocomplete to the Unstyled package (#27485) @michaldudak

### Docs

- <!-- 40 --> [docs] Fix layout shift when opening hash anchor (#27619) @oliviertassinari
- <!-- 35 --> [docs] Add TypeScript guide for the `sx` prop (#27417) @mnajdova
- <!-- 32 --> [docs] Hardcode listed colors in /customization/color/#playground (#27446) @eps1lon
- <!-- 31 --> [docs] Bring back Select#onChange signature API (#27443) @eps1lon
- <!-- 27 --> [docs] Remove backticks in the title (#27567) @oliviertassinari
- <!-- 26 --> [docs] Fix 404 links (#27566) @oliviertassinari
- <!-- 25 --> [docs] Use the same h2 for the customization demos (#27569) @oliviertassinari
- <!-- 22 --> [docs] Fix syntax error in v5 migration `styled` api example (#27518) @kimbaudi
- <!-- 21 --> [docs] Improve SSR configuration with emotion (#27496) @frandiox
- <!-- 19 --> [docs] Change "pseudo-classes" to "state classes" (#27570) @michaldudak
- <!-- 18 --> [docs] Add StackBlitz edit demo integration (#27391) @sulco
- <!-- 12 --> [docs] Remove unnecessary generic argument (#27516) @bezpalko
- <!-- 08 --> [docs] Add customization demos (#27411) @siriwatknp
- <!-- 04 --> [docs] Restore initial descriptionRegExp logic (#27436) @oliviertassinari
- <!-- 03 --> [docs] Polish jss-to-styled docs (#27457) @oliviertassinari
- <!-- 34 --> [examples] Fix nextjs with styled-components example (#27583) @mnajdova
- <!-- 29 --> [examples] Update create-react-app examples with styled-components to use package aliases (#27591) @mnajdova
- <!-- 09 --> [examples] Improve integration examples with Next.js (#27331) @Harshita-Kanal
- <!-- 37 --> [website] Add spicefactory as gold sponsor @oliviertassinari
- <!-- 30 --> [website] Homepage rebranding (#27488) @siriwatknp
- <!-- 24 --> [website] Add Flavien to team and about pages (#27575) @flaviendelangle
- <!-- 17 --> [website] Add Ryan to Community contributors for Stack Overflow contributions (#27529) @ryancogswell
- <!-- 02 --> [website] Add references section to home (#27444) @siriwatknp

### Core

- <!-- 20 --> [core] rebaseWhen=auto does not seem to work (#27565) @oliviertassinari
- <!-- 10 --> [core] Improve instructions for the @material-ui/styles migration (#27466) @mnajdova
- <!-- 06 --> [core] Batch small changes (#27435) @oliviertassinari
- <!-- 01 --> [core] Receive patch and minor dependency updates (#27455) @eps1lon
- <!-- 16 --> [test] Update coverage to include all @material-ui packages (#27521) @eps1lon
- <!-- 15 --> [test] Lint codemod tests (#27519) @eps1lon
- <!-- 05 --> [test] Allow tests to run for 6s before timeout (#27456) @oliviertassinari

All contributors of this release in alphabetical order: @bezpalko, @eps1lon, @flaviendelangle, @frandiox, @Harshita-Kanal, @kimbaudi, @michaldudak, @mnajdova, @noviicee, @oliviertassinari, @PCOffline, @R-Bower, @ryancogswell, @siriwatknp, @sulco

## 5.0.0-beta.2

<!-- generated comparing v5.0.0-beta.1..next -->

_Jul 26, 2021_

Big thanks to the 20 contributors who made this release possible. Here are some highlights ✨:

- ✨ We introduced new codemod for converting JSS styles to emotion (#27292) @siriwatknp
  It should help adoption of v5, by making possible the removal of JSS sooner.

- 🐛 The majority of other changes in this release were bug fixes, test utilities and docs.

### `@material-ui/core@5.0.0-beta.2`

- <!-- 54 --> [Autocomplete] Explain how the loading prop works (#27416) @michaldudak
- <!-- 49 --> [Autocomplete] Update input value when the input changes (#27313) @turtleseason
- <!-- 09 --> [Autocomplete] Popper is not closing when the Autocomplete is disabled (#27312) @Goodiec
- <!-- 42 --> [Checkbox] Skip default hover styles with `disableRipple` (#27314) @faan234
- <!-- 50 --> [Dialog] Fix override paper styles (#27423) @newsiberian
- <!-- 17 --> [Grid] Remove width prop for rowSpacing (#27326) @sashkopavlenko
- <!-- 33 --> [Input] Merge `componentsProps` correctly (#27371) @mnajdova
- <!-- 55 --> [Pagination] Fixed usePagination requires @emotion in development mode (#27348) @ruppysuppy
- <!-- 07 --> [Pagination] Fix :hover effect on previous/next button (#27304) @Aubrey-Li
- <!-- 03 --> [Popper] Consistent timing of popper instance creation (#27233) @eps1lon
- <!-- 45 --> [Select] Add `SelectChangeEvent` for accurate types for event in onChange prop (#27370) @eps1lon
- <!-- 18 --> [Tabs] Use theme transition duration for the Tab animation (#27303) @florianbepunkt
- <!-- 35 --> [TextField] Allow custom colors in FormLabel (#27337) @oliviertassinari
- <!-- 14 --> [TextField] Fix name of componentsProps (#27338) @oliviertassinari
- <!-- 04 --> [transitions] Make sure inline styles used for transition values if declared (#27140) @eps1lon

### `@material-ui/codemod@5.0.0-beta.2`

- <!-- 57 --> [codemod] Add `optimal-imports` for v5 (#27404) @mnajdova
- <!-- 48 --> [codemod] Add jss to emotion codemod (#27292) @siriwatknp
- <!-- 34 --> [codemod] Fix running codemod CLI on Windows (#27395) @michaldudak
- <!-- 32 --> [codemod] Fix published version (#27384) @eps1lon
- <!-- 10 --> [codemod] Improve README.md (#27257) @mnajdova

### `@material-ui/unstyled@5.0.0-alpha.41`

- <!-- 36 --> [NoSsr] Move NoSsr to the Unstyled package (#27356) @michaldudak

### `@material-ui/utils@5.0.0-beta.1`

- <!-- 43 --> [utils] Convert createChainedFunction to TypeScript (#27386) @eps1lon

### `@material-ui/system@5.0.0-beta.2`

- <!-- 39 --> [system] Compute display name of `styled` component if `name` isn't set (#27401) @eps1lon
- <!-- 08 --> [system] Adds missing type for `shouldForwardProp` (#27310) @KLubin1

### `@material-ui/lab@5.0.0-alpha.41`

- <!-- 58 --> [pickers] Only accept dates from adapters in min/max props (#27392) @eps1lon
- <!-- 15 --> [pickers] Fallback to today if all possible dates are disabled (#27294) @eps1lon
- <!-- 06 --> [pickers] Minify error when LocalizationProvider is missing (#27295) @eps1lon
- <!-- 01 --> [pickers] Fix Fade animation behavior change (#27283) @oliviertassinari

### Docs

- <!-- 56 --> [docs] Display Popper arrow correctly  (#27339) @Patil2099
- <!-- 53 --> [docs] Focus pickers introduction on Material-UI (#27394) @eps1lon
- <!-- 51 --> [docs] Fix wrong import path in @material-ui/styles section (#27427) @WeldonTan
- <!-- 47 --> [docs] Update color imports  (#27321) @siriwatknp
- <!-- 38 --> [docs] Sync params of callbacks between types and JSDoc description (#27366) @eps1lon
- <!-- 37 --> [docs] Add migration note for synthetic native events in onChange (#27368) @eps1lon
- <!-- 31 --> [docs] Improve unstyled docs (#27382) @oliviertassinari
- <!-- 30 --> [docs] Update `Transitions` page (#27319) @siriwatknp
- <!-- 29 --> [docs] Add Unstyled components docs page (#27158) @michaldudak
- <!-- 28 --> [docs] Fix app bar regression (#27373) @mnajdova
- <!-- 27 --> [docs] Update migration guide to have a section on nested classes (#27354) @mnajdova
- <!-- 25 --> [docs] Convert App* components to emotion (#27150) @eps1lon
- <!-- 23 --> [docs] Fix duplicate "Theme" header (#27353) @eps1lon
- <!-- 22 --> [docs] Remove horizontal scrollbar in MiniDrawer (#27055) @AlvesJorge
- <!-- 21 --> [docs] Add `makeStyles` explanation in troubleshooting (#27322) @siriwatknp
- <!-- 20 --> [docs] Fix ExpansionPanel migration notes (#27352) @eps1lon
- <!-- 19 --> [docs] Transpile markdown files (#27349) @eps1lon
- <!-- 12 --> [docs] Fix typo in the word typography (#27329) @tudi2d
- <!-- 11 --> [docs] Use actual symbol of kilogram (#27332) @getsnoopy
- <!-- 02 --> [docs] Make migration doc easier to follow (#26948) @siriwatknp
- <!-- 46 --> [examples] Cleanup `gatsby` examples (#27375) @mnajdova
- <!-- 41 --> [examples] Create nextjs example using styled-components (#27088) @hboylan
- <!-- 26 --> [examples] Update gatsby example to use custom plugin (#27357) @mnajdova

### Core

- <!-- 24 --> [core] Remove obsolete styles documentation (#27350) @eps1lon
- <!-- 13 --> [core] Fix GitHub language detection (#27298) @oliviertassinari
- <!-- 44 --> [test] Include coverage report of browser tests (#27389) @eps1lon
- <!-- 40 --> [test] Add current behavior for getDisplayName with context components (#27402) @eps1lon
- <!-- 05 --> [test] Enable skipped picker tests (#27268) @eps1lon
- <!-- 52 --> [website] Add hero section to homepage (#27364) @siriwatknp

All contributors of this release in alphabetical order: @AlvesJorge, @Aubrey-Li, @eps1lon, @faan234, @florianbepunkt, @g
etsnoopy, @Goodiec, @hboylan, @KLubin1, @michaldudak, @mnajdova, @newsiberian, @oliviertassinari, @Patil2099, @ruppysupp
y, @sashkopavlenko, @siriwatknp, @tudi2d, @turtleseason, @WeldonTan

## 5.0.0-beta.1

<!-- generated comparing v5.0.0-beta.0..next -->

_Jul 14, 2021_

Big thanks to the 17 contributors who made this release possible. Here are some highlights ✨:

- ✨ We have introduced a new unstyled component: the Switch (#26688) @michaldudak
  You can find two new versions of the Switch. A component without any styles: [`SwitchUnstyled`](https://next.material-ui.com/components/switches/#unstyled-switches), and a hook: [`useSwitch`](https://next.material-ui.com/components/switches/#useswitch-hook).

  <a href="https://next.material-ui.com/components/switches/#unstyled-switches"><img width="832" alt="switch" src="https://user-images.githubusercontent.com/3165635/125192249-236f8a80-e247-11eb-9df9-17d476379a32.png"></a>

  You can follow our progress at https://github.com/mui-org/material-ui/issues/27170.

- 💄 We have updated the default `info` `success` `warning` color to be more accessible (#26817) @siriwatknp.
  You can find the new [default values](https://next.material-ui.com/customization/palette/#default-values) in the documentation.

  <a href="https://next.material-ui.com/customization/palette/#default-values"><img width="780" alt="colors" src="https://user-images.githubusercontent.com/3165635/125192657-4864fd00-e249-11eb-9dc1-44857b25b3b8.png"></a>

### `@material-ui/core@5.0.0-beta.1`

#### Breaking changes

- [Fab] Remove no longer necessary span wrapper (#27112) @siriwatknp
- [ToggleButton] Remove no longer necessary span wrapper (#27111) @siriwatknp

#### Changes

- [Autocomplete] Add componentsProps (#27183) @michal-perlakowski
- [Avatar] Fix support for crossOrigin (#27013) @ShirasawaSama
- [ButtonBase] Correct `disableRipple` API description (#27187) @michaldudak
- [ButtonGroup] Add color palette types (#27215) @ShirasawaSama
- [SwitchBase] Bring back `checked` and mark as deprecated (#27047) @siriwatknp
- [TextField] Remove redundant useFormControl implementation (#27197) @michaldudak
- [theme] Add missing MuiRating types to components.d.ts (#27086) @rajzik
- [theme] Remove `createV4Spacing` from `adaptV4Theme` (#27072) @siriwatknp
- [theme] Update default `info` `success` `warning` color (#26817) @siriwatknp
- [ToggleButton] Add color palette types (#27046) @ShirasawaSama
- [ToggleButton] Fix the api page (#27164) @oliviertassinari

### `@material-ui/unstyled@5.0.0-alpha.40`

- [Switch] Create SwitchUnstyled and useSwitch (#26688) @michaldudak

### `@material-ui/codemod@5.0.0-beta.1`

- [codemod] Add v5 important migration (#27032) @siriwatknp
- [codemod] Fix v5 codemods on Windows (#27254) @michaldudak

### `@material-ui/system@5.0.0-beta.1`

- [Box] Add breakpoint value support to maxWidth prop (#26984) @ansh-saini

### `@material-ui/lab@5.0.0-alpha.40`

- [CalendarPicker] Fix slide transition regression (#27273) @eps1lon
- [CalendarPicker] Use transition components from core instead of a custom implementation (#27043) @eps1lon
- [pickers] Fix default value of text keys (#26990) @oliviertassinari
- [TimePicker] Change default minutes and seconds to zero (#27037) @michal-perlakowski

### Docs

- [blog] Q2 2021 Update (#27089) @oliviertassinari
- [docs] Add information that the label prop in FormControlLabel is now @michal-perlakowski
- [docs] Don't crash page if an Ad crashes (#27178) @eps1lon
- [docs] Fix alt description of movavi backer @oliviertassinari
- [docs] Fix import source of hidden component (#27116) @vimutti77
- [docs] Fix layout regression (#27272) @oliviertassinari
- [docs] Fix syntax error in /styles/api markdown (#27176) @sahil-blulabs
- [docs] Fix the link for the sx props page (#27202) @mnajdova
- [docs] Fix theme context example code (#27053) @moshfeu
- [docs] Fix typo in CONTRIBUTING.md (#27218) Ayush Dubey
- [docs] Fix typos (#27074) @michaldudak
- [docs] Improve nav semantics (#27138) @eps1lon
- [docs] Migrate Ad\* components to emotion (#27159) @mnajdova
- [docs] Migrate rest of the docs to emotion (#27184) @mnajdova
- [docs] Move versions from \_app PageContext to page-specific context (#27078) @eps1lon
- [docs] Only bundle one version of the demos in production (#27020) @eps1lon
- [docs] Reduce layout shift on landing page (#27251) @eps1lon
- [docs] Remove Ethical Ads (#27173) @mbrookes
- [docs] Remove unused fs polyfill (#27069) @eps1lon
- [docs] Remove usage of `url` package (#27151) @eps1lon
- [docs] Replace react-text-mask with react-imask in integration example (#27071) @michal-perlakowski
- [docs] Sort the size in a more logical order (#27186) @oliviertassinari
- [docs] Use actual link to paperbase (#27063) @eps1lon
- [docs] Use custom markdown loader for landing page (#27065) @eps1lon
- [docs] Use webpack 5 (#27077) @eps1lon
- [examples] Fix CDN warning (#27229) @oliviertassinari
- [examples] Remove `StyledEngineProvider` as JSS is not used (#27133) @mnajdova
- [examples] Remove forgotten StyledEngineProvider (#27163) @oliviertassinari

### Core

- [core] Batch small changes (#26970) @oliviertassinari
- [core] Configure Renovate (#27003) @renovate[bot]
- [core] Migrate remaining mentions of Dependabot to Renovate (#27118) @eps1lon
- [core] Run yarn deduplicate on Renovate updates (#27115) @eps1lon
- [test] Document broken React 18 behavior of Autocomplete (#27242) @eps1lon
- [test] Increase BS timeout to 6min (#27179) @oliviertassinari
- [test] Migrate regressions to emotion (#27010) @vicasas
- [test] Narrow down React 18 compat issues (#27134) @eps1lon
- [test] Remove StyledEngineProvider usage from regressions and e2e test @mnajdova
- [test] Run React 18 integration tests with new createRoot API (#26672) @eps1lon
- [test] Update tests with latest state of StrictMode compatibility (#27042) @eps1lon
- [test] Use DOM events instead of mocked, partial events (#27198) @eps1lon
- [website] Open 4 new roles (#27123) @oliviertassinari
- [blog] Danilo Leal joins Material-UI (#27231) @oliviertassinari

All contributors of this release in alphabetical order: @eps1lon, @mbrookes, @michal-perlakowski, @michaldudak, @mnajdova, @moshfeu, @oliviertassinari, @rajzik, @renovate[bot], @sahil-blulabs, @ShirasawaSama, @siriwatknp, @vimutti77

## 5.0.0-beta.0

<!-- generated comparing v5.0.0-alpha.38..next -->

_Jul 01, 2021_

Big thanks to the 13 contributors who made this release possible. Here are some highlights ✨:

- 🎉 This is the first beta release of v5! A huge thanks to everyone who helped to make this happen! We're targeting the 1st of September for a stable release, and will use the next two months to polish v5, and ease the migration from v4. You can follow [the v5 stable milestone](https://github.com/mui-org/material-ui/milestone/44) for more details. We now encourage any new projects to start on v5.
- 🚀 We have completed all the planned breaking changes.
- ⚒️ We added the codemod CLI to simplify migration to v5 (#26941) @eps1lon. You can find it at [`@material-ui/codemod`](https://github.com/mui-org/material-ui/tree/HEAD/packages/material-ui-codemod).
- 🐛 The majority of other changes in this release were bug fixes, test utilities and docs.

### `@material-ui/core@5.0.0-beta.0`

#### Breaking changes

- [Tabs] Remove unnecessary wrapper from Tab (#26926) @siriwatknp

  `span` element that wraps children has been removed. `wrapper` classKey is also removed. More details about [this change](https://github.com/mui-org/material-ui/pull/26666).

  ```diff
  <button class="MuiTab-root">
  - <span class="MuiTab-wrapper">
      {icon}
      {label}
  - </span>
  </button>
  ```

- [BottomNavigation] Remove wrapper from BottomNavigationAction (#26923) @siriwatknp

  `span` element that wraps children has been removed. `wrapper` classKey is also removed. More details about [this change](https://github.com/mui-org/material-ui/pull/26666).

  ```diff
  <button class="MuiBottomNavigationAction-root">
  - <span class="MuiBottomNavigationAction-wrapper">
      {icon}
      <span class="MuiBottomNavigationAction-label">
        {label}
      </span>
  - </span>
  </button>
  ```

#### Changes

- <!-- 19 --> [Box] Fix TypeScript error on maxWidth prop (#26859) @ansh-saini
- <!-- 04 --> [Dialog] Automatically label by its DialogTitle (#26814) @eps1lon
- <!-- 32 --> [Hidden] Bring back and mark as deprecated (#26908) @siriwatknp
- <!-- 53 --> [List] Add button runtime deprecation warning (#26743) @siriwatknp
- <!-- 03 --> [Modal] Type BackdropProps according to styled version (#26836) @eps1lon
- <!-- 21 --> [Radio] Fix `defaultValue` to match the other value types  (#26945) @oliviertassinari
- <!-- 48 --> [Stepper] Add completed to global pseudo-classes (#26953) @michal-perlakowski
- <!-- 25 --> [Stepper] Fix support for no connectors (#26874) @varandasi
- <!-- 20 --> [TextField] Prevent `hiddenLabel` from spreading to DOM (#26864) @siriwatknp
- <!-- 18 --> [TextField] Fix label disappearing when focusing a button (#26933) @michal-perlakowski

### `@material-ui/codemod@5.0.0-beta.0`

- <!-- 37 --> [codemod] Add CLI (#26941) @eps1lon

### @material-ui/icons@5.0.0-beta.0

- <!-- 29 --> [icons] Regenerate transpiled files (#26985) @eps1lon

### @material-ui/lab@5.0.0-alpha.39

#### Breaking changes

- [DatePicker] Remove helper text default value (#26866) @DouglasPds

  Make the default rendered text field closer to the most common use cases (denser).

  ```diff
  <DatePicker
    label="Helper text example"
    value={value}
    onChange={onChange}
    renderInput={(params) => (
  -    <TextField {...params} />
  +    <TextField {...params} helperText={params?.inputProps?.placeholder} />
    )}
  >
  ```

#### Changes

- <!-- 12 --> [lab] Fix missing dependency on unstyled (#26937) @fishyFrogFace
- <!-- 50 --> [pickers] Consider TDate in ToolbarComponent types (#27035) @michal-perlakowski

### `@material-ui/system@5.0.0-beta.0`

- <!-- 14 --> [system] Support array overridesResolver (#26824) @siriwatknp

### Docs

- <!-- 49 --> [docs] Add notes to Table demo about stableSort (#27025) @CarlosGomez-dev
- <!-- 47 --> [docs] Add gold sponsor (#26968) @oliviertassinari
- <!-- 42 --> [docs] Update unstyled demos to not depend on `@material-ui/core` (#26869) @mnajdova
- <!-- 41 --> [docs] Fix demo paths in windows (#27004) @eps1lon
- <!-- 40 --> [docs] Export all locales (#27002) @eps1lon
- <!-- 38 --> [docs] Misc CONTRIBUTING.md changes (#26925) @eps1lon
- <!-- 35 --> [docs] Fix /components/hidden merge conflict (#26997) @eps1lon
- <!-- 26 --> [docs] Fix 404 links (#26963) @oliviertassinari
- <!-- 24 --> [docs] Remove link that points to v4 blog post (#26960) @steveafrost
- <!-- 16 --> [docs] Use custom webpack loader for markdown (#26774) @eps1lon
- <!-- 11 --> [docs] Fix 301 links (#26942) @oliviertassinari
- <!-- 01 --> [docs] Add page for the `sx` prop (#26769) @mnajdova
- <!-- 52 --> [docs] pre-fill issue when a demo crashes (#27034) @eps1lon
- <!-- 54 --> [docs] Move styled page under system (#26818)

### Core

- <!-- 46 --> [core] Inline rollup-plugin-size-snapshot (#26986) @eps1lon
- <!-- 43 --> [core] Remove unused props clone (#26992) @oliviertassinari
- <!-- 36 --> [core] Fix tests on Windows (#26931) @michaldudak
- <!-- 31 --> [core] Fix merge conflict between #26954 and #26874 @oliviertassinari
- <!-- 22 --> [core] Upgrade issues-helper to v2 (#26955) @michal-perlakowski
- <!-- 05 --> [core] Fix merge conflict (#26928) @eps1lon
- <!-- 45 --> [test] Convert HiddenCSS tests to testing-library (#27019) @eps1lon
- <!-- 44 --> [test] Convert NativeSelectInput tests to testing-library (#26952) @eps1lon
- <!-- 39 --> [test] Add a default mount implementation to conformance tests (#26949) @eps1lon
- <!-- 28 --> [test] Update tests to pass react@next (#26967) @eps1lon
- <!-- 27 --> [test] Add types to describeConformanceV5 (#26954) @eps1lon
- <!-- 17 --> [test] Use createPickerMount where appropriate (#26951) @eps1lon
- <!-- 15 --> [test] Convert SwipeableDrawer tests to testing-library (#26916) @eps1lon
- <!-- 13 --> [test] Convert Menu tests to testing-library (#26915) @eps1lon
- <!-- 10 --> [test] Convert Popover tests to testing-library (#26913) @eps1lon
- <!-- 08 --> [test] Convert Modal tests to testing-library (#26912) @eps1lon
- <!-- 07 --> [test] Make remaining testing-library tests StrictMode compatible (#26924) @eps1lon
- <!-- 51 --> [test] Only allow wrapping enzyme mount not creating (#27018) @eps1lon
- <!-- 06 --> [typescript] Disallow spreading TransitionHandlerProps (#26927) @eps1lon

All contributors of this release in alphabetical order: @ansh-saini, @BC-M, @CarlosGomez-dev, @DouglasPds, @eps1lon, @fishyFrogFace, @michal-perlakowski, @michaldudak, @mnajdova, @oliviertassinari, @siriwatknp, @steveafrost, @varandasi

## 5.0.0-alpha.38

<!-- generated comparing v5.0.0-alpha.37..next -->

_Jun 23, 2021_

Big thanks to the 18 contributors who made this release possible. Here are some highlights ✨:

- 🚀 We have only 2 left in the [breaking changes](https://github.com/mui-org/material-ui/issues/20012). The plan to release 5.0.0-beta.0 is on July 1st and will start to promote its usage over v4.
- 🎨 We have updated `Slider` to match current [Material Design guidelines](https://material.io/components/sliders).

  <a href="https://next.material-ui.com/components/slider/#continuous-sliders"><img width="247" alt="" src="https://user-images.githubusercontent.com/3165635/121884800-a8808600-cd13-11eb-8cdf-e25de8f1ba73.png" style="margin: auto"></a>

- 💡 `IconButton` now supports 3 sizes (`small, medium, large`). [See demo](https://next.material-ui.com/components/buttons/#sizes-2).
- ♿️ We have improved the default style of the `Link` to be more accessible (#26145) @ahmed-28

  <a href="https://next.material-ui.com/components/links/"><img width="543" alt="" src="https://user-images.githubusercontent.com/3165635/123097983-ef1b6200-d430-11eb-97da-b491fba5df49.png"></a>

### `@material-ui/core@5.0.0-alpha.38`

#### Breaking changes

- <!-- 05 --> [Menu] Use ButtonBase in MenuItem (#26591) @siriwatknp

  - Change the default value of `anchorOrigin.vertical` to follow the Material Design guidelines. The menu now displays below the anchor instead of on top of it. You can restore the previous behavior with:

    ```diff
     <Menu
    +  anchorOrigin={{
    +    vertical: 'top',
    +    horizontal: 'left',
    +  }}
    ```

  - The `MenuItem` component inherits the `ButtonBase` component instead of `ListItem`. The class names related to "MuiListItem-\*" are removed and theming `ListItem` is no longer affecting `MenuItem`.

    ```diff
    -<li className="MuiButtonBase-root MuiMenuItem-root MuiListItem-root">
    +<li className="MuiButtonBase-root MuiMenuItem-root">
    ```

  - The prop `listItemClasses` was removed, you can use `classes` instead.

    ```diff
    -<MenuItem listItemClasses={{...}}>
    +<MenuItem classes={{...}}>
    ```

- <!-- 09 --> [theme] Improve default breakpoints (#26746) @siriwatknp

  The default breakpoints were changed to better match the common use cases. They also better match the Material Design guidelines. [Read more about the change](https://github.com/mui-org/material-ui/issues/21902).

  ```diff
  {
    xs: 0,
    sm: 600,
  - md: 960,
  + md: 900,
  - lg: 1280,
  + lg: 1200,
  - xl: 1920,
  + xl: 1536,
  }
  ```

  If you prefer the old breakpoint values, use the snippet below.

  ```js
  import { createTheme } from '@material-ui/core/styles';

  const theme = createTheme({
    breakpoints: {
      values: {
        xs: 0,
        sm: 600,
        md: 960,
        lg: 1280,
        xl: 1920,
      },
    },
  });
  ```

- <!-- 10 --> [IconButton] Add size `large` and update styles (#26748) @siriwatknp

  The default size's padding is reduced to `8px` which makes the default IconButton size of `40px`. To get the old default size (`48px`), use `size="large"`. The change was done to better match Google's products when Material Design stopped documenting the icon button pattern.

  ```diff
  - <IconButton>
  + <IconButton size="large">
  ```

- <!-- 08 --> [Slider] Adjust css to match the specification (#26632) @siriwatknp

  Rework the CSS to match the latest [Material Design guidelines](https://material.io/components/sliders) and make custom styles more intuitive. [See documentation](https://next.material-ui.com/components/slider/).

  <a href="https://next.material-ui.com/components/slider/#continuous-sliders"><img width="247" alt="" src="https://user-images.githubusercontent.com/3165635/121884800-a8808600-cd13-11eb-8cdf-e25de8f1ba73.png" style="margin: auto"></a>

  You can reduce the density of the slider, closer to v4 with the [`size="small"` prop](https://next.material-ui.com/components/slider/#sizes).

  <a href="https://next.material-ui.com/components/slider/#sizes"><img width="330" alt="" src="https://user-images.githubusercontent.com/3165635/123076549-8aa0d880-d419-11eb-8835-06cd2b21b2d3.png" style="margin: auto"></a>

- <!-- 14 --> [IconButton] Remove label span (#26801) @siriwatknp

  `span` element that wraps children has been removed. `label` classKey is also removed. More details about [this change](https://github.com/mui-org/material-ui/pull/26666).

  ```diff
  <button class="MuiIconButton-root">
  - <span class="MuiIconButton-label">
      <svg />
  - </span>
  </button>
  ```

- <!-- 19 --> [core] Remove `unstable_` prefix on the `useThemeProps` hook (#26777) @mnajdova

  The following utilities were renamed to not contain the `unstable_` prefix:

  - `@material-ui/sytstem`

  ```diff
   import {
  -  unstable_useThemeProps,
  +  useThemeProps,
   } from '@material-ui/system';
  ```

  - `@material-ui/core`

  ```diff
   import {
  -  unstable_useThemeProps,
  +  useThemeProps,
   } from '@material-ui/core/styles';
  ```

#### Changes

- <!-- 33 --> [Alert] Add support for custom colors (#26831) @varandasi
- <!-- 32 --> [Button] Fix loading text invisible when disabled (#26857) @DanielBretzigheimer
- <!-- 43 --> [ButtonBase] Consider as a link with a custom component and `to` prop (#26576) @shadab14meb346
- <!-- 17 --> [ButtonBase] Derive state on render instead of in layout effects (#26762) @eps1lon
- <!-- 37 -->  [Drawer] Fix incorrect z-index (#26791) @michal-perlakowski
- <!-- 28 --> [Drawer] Remove incorrect transition handler props (#26835) @eps1lon
- <!-- 01 --> [Link] Improve accessibility support (#26145) @ahmed-28
- <!-- 41 --> [Modal] Fix calculating scrollbar size when using custom scrollbar (#26816) @michal-perlakowski
- <!-- 29 --> [Rating] Make input ids less predictable (#26493) @eps1lon
- <!-- 27 --> [Stepper] Add componentsProps.label to StepLabel (#26807) @michal-perlakowski
- <!-- 36 --> [Tabs] Show error when Tab has display: none (#26783) @michal-perlakowski
- <!-- 46 --> [theme] Add base color palette type to components (#26697) @siriwatknp

### `@material-ui/system@5.0.0-alpha.38`

#### Breaking Changes

- <!-- 35 --> [system] Normalize api for `createBox` (#26820) @mnajdova

  ```diff
   import { createBox } from '@material-ui/system';

  -const styled = createBox(defaultTheme);
  +const styled = createBox({ defaultTheme });
  ```

#### Changes

- <!-- 12 --> [system] Add ThemeProvider component (#26787) @mnajdova

### Docs

- <!-- 45 --> [docs] Fix misspelling of the word Typography (#26898) @dmrqx
- <!-- 42 --> [docs] Instruct users to install @material-ui/icons with the next tag (#26873) @michal-perlakowski
- <!-- 26 --> [docs] Sync translations (#26828) @l10nbot
- <!-- 25 --> [docs] Improve grammar of autocomplete/autofill section (#26798) @dijonkitchen
- <!-- 18 --> [docs] Explain "inherited props" better in the props table (#26778) @eps1lon
- <!-- 16 --> [docs] Fix documentation for upgrading to v5 (#26812) @tungdt-90
- <!-- 13 --> [docs] Improve notification color (#26796) @mnajdova
- <!-- 11 --> [docs] Fix various a11y issues with /customization/color (#26757) @eps1lon
- <!-- 04 --> [docs] Move custom theme to frame (#26744) @siriwatknp
- <!-- 02 --> [docs] Fix small PT typo fix: inciar -> iniciar (#26775) @brunocavalcante
- <!-- 03 --> [I10n] Add Chinese (Hong Kong) (zh-HK) locale (#26637) @kshuiroy
- <!-- 44 --> [l10n] Add sinhalese (siLK) locale (#26875) @pavinduLakshan
- <!-- 39 --> [examples] Rename nextjs typescript theme from tsx to ts (#26862) @Izhaki

### Core

- <!-- 38 --> [test] Fix Drawer test API @oliviertassinari
- <!-- 34 --> [test] Adjust expected useAutocomplete error messages for React 18 (#26858) @eps1lon
- <!-- 30 --> [test] Convert Drawer tests to testing-library (#26837) @eps1lon
- <!-- 23 --> [test] Convert remaining enzyme tests to testing-library (#26832) @eps1lon
- <!-- 22 --> [test] Ignore ReactDOM.hydrate deprecation warnings (#26815) @eps1lon
- <!-- 06 --> [test] Reduce flakiness (#26761) @eps1lon
- <!-- 07 --> [useId] Reduce likelyhood of collisions (#26758) @eps1lon
- <!-- 31 --> yarn deduplicate @oliviertassinari
- <!-- 21 --> Fix running framer's prettier under pwsh (#26819) @michaldudak
- <!-- 40 --> [core] Update babel-plugin-optimize-clsx (#26861) @oliviertassinari
- <!-- 24 --> [core] Assume no document.all at runtime (#26821) @eps1lon
- <!-- 20 --> [core] Remove dependency on `@material-ui/private-theming` (#26793) @mnajdova
- <!-- 15 --> [core] Remove dependency on `@material-ui/styled-engine` (#26792) @mnajdova

All contributors of this release in alphabetical order: @ahmed-28, @brunocavalcante, @DanielBretzigheimer, @dijonkitchen, @dmrqx, @eps1lon, @Izhaki, @kshuiroy, @l10nbot, @michal-perlakowski, @michaldudak, @mnajdova, @oliviertassinari, @pavinduLakshan, @shadab14meb346, @siriwatknp, @tungdt-90, @varandasi

## 5.0.0-alpha.37

<!-- generated comparing v5.0.0-alpha.36..next -->

_Jun 15, 2021_

Big thanks to the 11 contributors who made this release possible. Here are some highlights ✨:

- 💄 Add support for responsive props on the Grid component (#26590) @likitarai1.
  This fixes a longstanding issue. You can now specify different values for each breakpoint.

  ```jsx
  <Grid container spacing={{ xs: 2, md: 3 }} columns={{ xs: 1, sm: 2, md: 3 }}>
    <Grid item xs={2} sm={4} md={4} />
    <Grid item xs={2} sm={4} md={4} />
    <Grid item xs={2} sm={4} md={4} />
  </Grid>
  ```

  Head to the [documentation](https://next.material-ui.com/components/grid/#responsive-values) for more details.

- ⚒️ We've introduced a new `useTheme` and `useThemeProps` hooks in the `@material-ui/system` package.
  We believe that this package can be used as a standalone styling solution for building custom design systems (#26649) @mnajdova.
- 💥 Made progress with the breaking changes. We have done 105 of the 109 changes [planned](https://github.com/mui-org/material-ui/issues/20012). We are getting closer to our goal of releasing 5.0.0-beta.0 on July 1st and start to promote its usage over v4. You can also follow [our milestone](https://github.com/mui-org/material-ui/milestone/35) for more details.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.37`

#### Breaking changes

- <!-- 10 --> [Button] Remove label span (#26666) @siriwatknp

  The `span` element that wraps children has been removed. `label` classKey is also removed. The nested span was required for fixing a flexbox issue with iOS < 11.0.

  ```diff
  <button class="MuiButton-root">
  - <span class="MuiButton-label">
      children
  - </span>
  </button>
  ```

#### Changes

- <!-- 08 --> [Button] Add missing color type (#26593) @sakura90
- <!-- 07 --> [Grid] Add responsive direction and spacing props (#26590) @likitarai1
- <!-- 05 --> [List] Add ListItemButton export to index (#26667) @chadmuro
- <!-- 09 --> [theme] Fix missing exported Breakpoints types (#26684) @robphoenix

### `@material-ui/system@5.0.0-alpha.37`

#### Breaking changes

- <!-- 26 --> [system] Remove `theme` & `isRtl` from `useThemeProps` (#26701) @mnajdova

  The `isRtl` and `theme` props are no longer added by the `useThemeProps` hook. You can use the `useTheme` hook for this.

  ```diff
  -import { unstable_useThemeProps as useThemeProps } from '@material-ui/core/styles';
  +import { unstable_useThemeProps as useThemeProps, useTheme } from '@material-ui/core/styles';

   const Component = (inProps) => {
  -  const { isRtl, theme, ...props } = useThemeProps({ props: inProps, name: 'MuiComponent' });
  +  const props = useThemeProps({ props: inProps, name: 'MuiComponent' });

  +  const theme = useTheme();
  +  const isRtl = theme.direction === 'rtl';
     //.. rest of the code
  }
  ```

#### Changes

- <!-- 16 --> [system] Add useThemeProps & useTheme hooks (#26649) @mnajdova
- <!-- 15 --> [system] Add color manipulators (#26668) @mnajdova
- <!-- 06 --> [system] Fix support of custom shape in createTheme (#26673) @varandasi

### `@material-ui/unstyled@5.0.0-alpha.37`

- <!-- 04 --> [Slider] Improve TS definition (#26642) @mnajdova
- <!-- 21 --> [TrapFocus] Capture nodeToRestore via relatedTarget (#26696) @eps1lon

### `@material-ui/icons@5.0.0-alpha.37`

- <!-- 03 --> Revert "[icons] Only ship ES modules (#26310)" (#26656) @eps1lon

  The changes that we have tried in #26310 were breaking the integration with Next.js.

### `@material-ui/lab@5.0.0-alpha.37`

- <!-- 29 --> [core] Remove unused useKeyDown (#26765) @eps1lon
- <!-- 28 --> [DateTimePicker] Fix not visible selected tab icon (#26624) @nikitabobers

### Docs

- <!-- 20 --> [blog] Michał Dudak joins Material-UI (#26700) @oliviertassinari
- <!-- 27 --> [docs] Migrate onepirate premium template to emotion part2 (#26707) @vicasas
- <!-- 24 --> [docs] Fix TextField demo layout (#26710) @vicasas
- <!-- 19 --> [docs] Improve Paperbase demo (#26711) @oliviertassinari
- <!-- 17 --> [docs] Migrate onepirate premium template to emotion part1 (#26671) @vicasas
- <!-- 14 --> [docs] Migrate paperbase premium template to emotion (#26658) @vicasas
- <!-- 25 --> [List] Fix demo to have correct semantic (#26742) @siriwatknp

### Core

- <!-- 23 --> [core] Monitore size of key system modules (#26712) @oliviertassinari
- <!-- 22 --> [core] Batch small changes (#26738) @oliviertassinari
- <!-- 18 --> [core] Batch small changes (#26628) @oliviertassinari
- <!-- 13 --> [test] Ignore ReactDOM.render deprecation warning (#26683) @eps1lon
- <!-- 12 --> [test] Run e2e test with React 18 on a schedule (#26690) @eps1lon
- <!-- 11 --> [test] Count profiler renders not passive effects (#26678) @eps1lon
- <!-- 02 --> [test] Bundling fixtures should not override source build with published build (#26657) @eps1lon
- <!-- 01 --> [test] Make tests oblivious to StrictMode (#26654) @eps1lon

All contributors of this release in alphabetical order: @chadmuro, @eps1lon, @likitarai1, @mnajdova, @nikitabobers, @oliviertassinari, @robphoenix, @sakura90, @siriwatknp, @varandasi, @vicasas

## 5.0.0-alpha.36

<!-- generated comparing v5.0.0-alpha.35..next -->

_Jun 8, 2021_

Big thanks to the 14 contributors who made this release possible. Here are some highlights ✨:

- ⚒️ We've introduced a new `ListItemButton` component that should prevent common mistakes when using `<ListItem button />` and help with customization and TypeScript support (#26446) @siriwatknp.
- 👩‍🎤 `experimentalStyled` is now available without the `experimental` prefix.
  We're confident that its API shouldn't receive any major changes until the stable release of v5 (#26558) @mnajdova.
- 📦 `@material-ui/icons` only ships ES modules and no longer CommonJS modules.
  This reduces the download size of the package from 1.7 MB to 1.2 MB and install size from 15.6 MB to 6.7 MB (#26310) @eps1lon.
- 💄 Add support for [row and column spacing](https://next.material-ui.com/components/grid/#row-amp-column-spacing) in the Grid component (#26559) @likitarai1.
  <img width="549" alt="grid spacing demo" src="https://user-images.githubusercontent.com/3165635/121089288-383fa500-c7e7-11eb-8c43-53457b7430f1.png">

  Note that this feature was already available for [CSS grid users](https://next.material-ui.com/components/grid/#css-grid-layout) with the `rowGap` and `columnGap` props.

### `@material-ui/core@5.0.0-alpha.36`

#### Breaking changes

- <!-- 10 --> [AppBar] Fix background color on dark mode (#26545) @siriwatknp

  The `color` prop has no longer any effect in dark mode. The app bar uses the background color required by the elevation to follow the [Material Design guidelines](https://material.io/design/color/dark-theme.html). Use `enableColorOnDark` to restore the behavior of v4.

  ```jsx
  <AppBar enableColorOnDark />
  ```

- <!-- 13 --> [core] Rename `experimentalStyled` to `styled` (#26558) @mnajdova

  Remove the experimental prefix, this module is going stable:

  ```diff
  -import { experimentalStyled as styled } from '@material-ui/core/styles';
  +import { styled } from '@material-ui/core/styles';
  ```

- <!-- 03 --> [SwitchBase] Replace IconButton with ButtonBase (#26460) @siriwatknp
- <!-- 25 --> [theme] Improve default `primary`, `secondary` and `error` theme palette (#26555) @siriwatknp

#### Changes

- <!-- 17 --> [Box] Fix module 'clsx' not found in system (#26553) @coder-freestyle
- <!-- 07 --> [Box] Fix runtime error when using styled-components without ThemeProvider (#26548) @mnajdova
- <!-- 27 --> [Radio][Checkbox] Don't forward `color` to DOM elements (#26625) @siriwatknp
- <!-- 01 --> [Dialog] Flatten DialogTitle DOM structure, remove `disableTypography` (#26323) @eps1lon
- <!-- 31 --> [Grid] Add rowSpacing and columnSpacing props (#26559) @likitarai1
- <!-- 34 --> [List] extract button from ListItem to ListItemButton (#26446) @siriwatknp
- <!-- 23 --> [Popover] Fix PaperProps.ref breaking positioning (#26560) @vedadeepta
- <!-- 19 --> [Rating] onChangeActive shouldn't be fired on blur/focus (#26584) @coder-freestyle
- <!-- 11 --> [Select] Fix custom font size centering arrow (#26570) @sarahannnicholson
- <!-- 06 --> [styled] Convert implicit styleProps to explicit (#26461) @mnajdova@siriwatknp
- <!-- 08 --> [Tabs] Fix RTL indicator (#26470) @siriwatknp
- <!-- 02 --> [Tabs] Fix arrow rotation in vertical & RTL (#26527) @siriwatknp
- <!-- 20 --> [TextField] Fix support for custom `size` prop value (#26585) @coder-freestyle
- <!-- 04 --> [Tooltip] Finish exiting once started (#26535) @eps1lon

### `@material-ui/icons@5.0.0-alpha.36`

#### Breaking changes

- <!-- 15 --> [icons] Only ship ES modules (#26310) @eps1lon

  The `require()` of `@material-ui/icons` is no longer supported.
  This should not affect you if you're using a bundler like `webpack` or `snowpack` or meta frameworks like `next` or `gatsby`.

### `@material-ui/lab@5.0.0-alpha.36`

#### Breaking changes

- <!-- 29 --> [pickers] Remove `openPickerIcon` prop in favor of `components.OpenPickerIcon` (#26223) @vedadeepta

  ```diff
  <DateTimePicker
    components={{
      LeftArrowIcon: AlarmIcon,
      RightArrowIcon: SnoozeIcon,
  +   OpenPickerIcon: ClockIcon,
    }}
  - openPickerIcon={<ClockIcon />}
  ```

### `@material-ui/system@5.0.0-alpha.36`

- <!-- 18 --> [system] Add createTheme util (#26490) @mnajdova

### Docs

- <!-- 28 --> [docs] Migrate templates to emotion (#26604) @vicasas
- <!-- 26 --> [docs] Remove custom primary & secondary color (#26541) @siriwatknp
- <!-- 24 --> [docs] Don't escape prop descriptions for markdown table context (#26579) @eps1lon
- <!-- 22 --> [docs] Prepare for data grid auto-generated docs (#26477) @m4theushw
- <!-- 21 --> [docs] Fix typo sx !== xs (#26596) @onpaws
- <!-- 16 --> [docs] Multiple select demos moving when selecting values (#26539) @itsnorbertkalacska
- <!-- 14 --> [docs] Improve migration guide for `@material-ui/styles` (#26552) @mnajdova
- <!-- 12 --> [docs] `Rating` `value` is nullable in `onChange` (#26542) @sakura90
- <!-- 30 --> [example] Remove the dependency on @material-ui/styles (#26567) @garfunkelvila

### Core

- <!-- 33 --> [core] Ignore latest prettier run in git-blame @eps1lon
- <!-- 32 --> [core] Format @eps1lon
- <!-- 05 --> [test] Add bundle fixtures (#23166) @eps1lon
- <!-- 09 --> [website] Add Michał to the About Us page (#26557) @michaldudak

All contributors of this release in alphabetical order: @coder-freestyle, @eps1lon, @garfunkelvila, @itsnorbertkalacska, @likitarai1, @m4theushw, @michaldudak, @mnajdova, @onpaws, @sakura90, @sarahannnicholson, @siriwatknp, @vedadeepta, @vicasas

## 5.0.0-alpha.35

<!-- generated comparing v5.0.0-alpha.34..next -->

_May 31, 2021_

Big thanks to the 14 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 We have completed the migration to emotion of all the components (`@material-ui/core` and `@material-ui/lab`) @siriwatknp, @mnajdova.
- 📦 Save [10 kB gzipped](https://bundlephobia.com/result?p=@material-ui/core@5.0.0-alpha.34) by removing the dependency on `@material-ui/styles` (JSS) from the core and the lab (#26377, #26382, #26376) @mnajdova.
- ⚒️ Add many new [codemods](https://github.com/mui-org/material-ui/blob/HEAD/packages/material-ui-codemod/README.md) to automate the migration from v4 to v5 (#24867) @mbrookes.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.35`

#### Breaking changes

- [styles] Remove `makeStyles` from `@material-ui/core` (#26382) @mnajdova

  The `makeStyles` JSS utility is no longer exported from `@material-ui/core`. You can use `@material-ui/styles` instead. Make sure to add a `ThemeProvider` at the root of your application, as the `defaultTheme` is no longer available. If you are using this utility together with `@material-ui/core`, it's recommended you use the `ThemeProvider` component from `@material-ui/core` instead.

  ```diff
  -import { makeStyles } from '@material-ui/core/styles';
  +import { makeStyles } from '@material-ui/styles';
  +import { createTheme, ThemeProvider } from '@material-ui/core/styles';

  +const theme = createTheme();
   const useStyles = makeStyles((theme) => ({
     background: theme.palette.primary.main,
   }));
   function Component() {
     const classes = useStyles();
     return <div className={classes.root} />
   }

   // In the root of your app
   function App(props) {
  -  return <Component />;
  +  return <ThemeProvider theme={theme}><Component {...props} /></ThemeProvider>;
   }
  ```

- [styles] Remove `withStyles` from `@material-ui/core` (#26377) @mnajdova

  The `withStyles` JSS utility is no longer exported from `@material-ui/core`. You can use `@material-ui/styles` instead. Make sure to add a `ThemeProvider` at the root of your application, as the `defaultTheme` is no longer available. If you are using this utility together with `@material-ui/core`, you should use the `ThemeProvider` component from `@material-ui/core` instead.

  ```diff
  -import { withStyles } from '@material-ui/core/styles';
  +import { withStyles } from '@material-ui/styles';
  +import { createTheme, ThemeProvider } from '@material-ui/core/styles';

  +const defaultTheme = createTheme();
   const MyComponent = withStyles((props) => {
     const { classes, className, ...other } = props;
     return <div className={clsx(className, classes.root)} {...other} />
   })(({ theme }) => ({ root: { background: theme.palette.primary.main }}));

   function App() {
  -  return <MyComponent />;
  +  return <ThemeProvider theme={defaultTheme}><MyComponent /></ThemeProvider>;
   }
  ```

- [styles] Merge options in `experimentalStyled` (#26396) @mnajdova

  The options inside the `experimentalStyled` module are now merged under one object. In the coming weeks, we will rename ths module: `styled()` to signal that it's no longer experimental.

  ```diff
  -experimentalStyled(Button, { shouldForwardProp: (prop) => prop !== 'something' }, { skipSx: true })(...);
  +experimentalStyled(Button, { shouldForwardProp: (prop) => prop !== 'something', skipSx: true })(...);
  ```

- [Tabs] Update `min` & `max` width and remove `minWidth` media query (#26458) @siriwatknp

  Update the implementation to better match Material Design:

  - Tab `minWidth` changed from `72px` => `90px` (without media-query) according to [material-design spec](https://material.io/components/tabs#specs)
  - Tab `maxWidth` changed from `264px` => `360px` according to [material-design spec](https://material.io/components/tabs#specs)

#### Changes

- [ButtonBase] Fix role="button" attribute (#26271) @Gautam-Arora24
- [Dialog] Fix support for custom breakpoints (#26331) @jeferson-sb
- [Select] Open popup below button (#26200) @oliviertassinari
- [TextField] Add variants support, e.g. custom sizes (#26468) @siriwatknp
- [Tooltip] Improve handling of small vs. touch screens (#26097) @oliviertassinari

### `@material-ui/codemod@5.0.0-alpha.35`

- [codemod] Add multiple codemods to migrate components from v4 to v5 (#24867) @mbrookes
- [codemod] Correct path and add target placeholder (#26414) @mbrookes

### `@material-ui/icons@5.0.0-alpha.35`

- [icons] Use array children instead of React fragments (#26309) @eps1lon

  Reduce a bit the size of the package.

### `@material-ui/system@5.0.0-alpha.35`

We are progressively moving all modules that are relevant to styling custom design systems in this package. It's meant to be complementary with `@material-ui/unstyled`.

- [system] Add Box to system (#26379) @mnajdova
- [system] Add createStyled utility (#26485) @mnajdova

### `@material-ui/styled-engine-sc@5.0.0-alpha.35`

- [styled-engine] Fix styled() util to respect `options` (#26339) @pasDamola

### `@material-ui/lab@5.0.0-alpha.35`

#### Breaking changes

- [pickers] Remove allowKeyboardControl (#26451) @eps1lon
- [ClockPicker] Rework keyboard implementation (#26400) @eps1lon

  Remove the `allowKeyboardControl` prop from ClockPicker (and TimePicker and variants). Keyboard navigation now works by default.

#### Changes

- [Button] Migrate LoadingButton to emotion (#26370) @siriwatknp
- [ClockPicker] Selected option is the active descendant (#26411) @eps1lon
- [DatePicker] Migrate CalendarPicker to emotion (#26390) @siriwatknp
- [DatePicker] Migrate CalendarPickerSkeleton to emotion (#26335) @siriwatknp
- [DateRangePicker] Migrate DateRangePickerDay to emotion (#26368) @siriwatknp
- [DateRangePicker] Migrate internal components to emotion (#26326) @siriwatknp
- [pickers] Migrate PickersCalendarHeader to emotion (#26354) @siriwatknp
- [pickers] Migrate PickersModalDialog to emotion (#26355) @siriwatknp
- [pickers] Migrate PickersPopper to emotion (#26391) @siriwatknp
- [pickers] Migrate PickersTransition to emotion (#26353) @siriwatknp
- [TimePicker] Migrate ClockPicker to emotion (#26389) @siriwatknp
- [TreeView] Correctly select items in deeply nested trees (#26413) @Dru89

### Docs

- [docs] Add page for `experimentalStyled()` (#26361) @mnajdova
- [docs] Add TypeScript convention (#26259) @siriwatknp
- [docs] Add warning about git-blame-ignore-revs (#26487) @eps1lon
- [docs] Clarify migration from Hidden (#26348) @m4theushw
- [docs] Fix grammar for style library page (#26325) @mbrookes
- [docs] Persist copied state indefinitely or until the user moves their cursor (#26336) @eps1lon
- [docs] Typo in MultipleSelect (#26466) @wolfykey
- [docs] Update system installation for v5 (#26481) @mnajdova
- [template] Demo how to retreive form value (#26393) @akshitsuri

### Core

- [core] Batch small changes (#26434) @oliviertassinari
- [core] Fix peer dependencies declaration with yarn v2 (#26433) @oliviertassinari
- [core] Remove `@material-ui/styles` dependencies from declaration files too (#26376) @mnajdova
- [core] Revert Leverage CircleCI workspaces for jobs after checkout (#26444) @eps1lon
- [test] Don't hoist constant elements (#26448) @eps1lon
- [test] Fix prop-type warning (#26432) @oliviertassinari
- [test] Flush scheduled effects before user event returns (#26447) @eps1lon
- [test] Move ClockPicker tests to ClockPicker.test (#26407) @eps1lon
- [test] setProps from createPickerRender should set props on the rendered element (#26405) @eps1lon
- [utils] Convert useId to TypeScript (#26491) @eps1lon
- [website] Add Material-UI X page (#25794) @DanailH
- [website] Add open application section (#26501) @oliviertassinari
- [website] Add Siriwat to team page (#26406) @siriwatknp

All contributors of this release in alphabetical order: @akshitsuri, @DanailH, @Dru89, @eps1lon, @Gautam-Arora24, @jeferson-sb, @m4theushw, @mbrookes, @mnajdova, @oliviertassinari, @pasDamola, @siriwatknp, @wolfykey

## 5.0.0-alpha.34

_May 18, 2021_

<!-- generated comparing v5.0.0-alpha.33..next -->

Big thanks to the 16 contributors who made this release possible. Here are some highlights ✨:

- 💥 Make progress with the breaking changes. We have done 89 of the 109 changes [planned](https://github.com/mui-org/material-ui/issues/20012). We will release 5.0.0-beta.0 on July 1st and start to promote its usage over v4. You can also follow [our milestone](https://github.com/mui-org/material-ui/milestone/35) for more details.
- 🚀 Make progress with components migration to emotion. We have done 153 of the 168 components (almost there!)
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.34`

#### Breaking change

- <!-- 47 --> [Select][NativeSelect] Polish CSS classes (#26186) @m4theushw

  **Select, NativeSelect**

  Merge the `selectMenu` slot into `select`. Slot `selectMenu` was redundant. The `root` slot is no longer applied to the select, but to the root.

  ```diff
  -<NativeSelect classes={{ root: 'class1', select: 'class2', selectMenu: 'class3' }} />
  +<NativeSelect classes={{ select: 'class1 class2 class3' }} />
  ```

  **TablePagination**

  Move the custom class on `input` to `select`. The `input` key is being applied on another element.

  ```diff
  <TablePagination
  - classes={{ input: 'foo' }}
  + classes={{ select: 'foo' }}
  />
  ```

- <!-- 45 --> [core] Move `StyledEngineProvider` to `@material-ui/core/styles` (#26265) @mnajdova

  Change location of `StyledEngineProvider` import.

  ```diff
  -import StyledEngineProvider from '@material-ui/core/StyledEngineProvider';
  +import { StyledEngineProvider } from '@material-ui/core/styles';
  ```

- <!-- 39 --> [Autocomplete] Apply .Mui-focused instead of data-focus on the focused option (#26181) @m4theushw

  The `data-focus` attribute is not set on the focused option anymore, instead, global class names are used.

  ```diff
  -'.MuiAutocomplete-option[data-focus="true"]': {
  +'.MuiAutocomplete-option.Mui-focused': {
  ```

- <!-- 31 --> [Radio] Make color primary default (#26180) @vicasas
- <!-- 03 --> [Switch] Make color primary default (#26182) @vicasas
- <!-- 10 --> [pickers] Drop ResponsiveWrapper usage (#26123) @eps1lon

  When a responsive picker changes from mobile to desktop, it will now clear its entire state. To keep the original behavior you can implement a controlled picker:

  ```js
  function ResponsiveDateTimePicker(props) {
    const [open, setOpen] = React.useState(false);

    return (
      <DateTimePicker
        open={open}
        onClose={() => setOpen(false)}
        onOpen={() => setOpen(true)}
        {...props}
      />
    );
  }
  ```

- <!-- 63 --> [Autocomplete] Rename getOptionSelected to isOptionEqualToValue (#26173) @m4theushw
  ```diff
  <Autocomplete
  -  getOptionSelected={(option, value) => option.title === value.title}
  +  isOptionEqualToValue={(option, value) => option.title === value.title}
  />
  ```

> Follow [this link](https://next.material-ui.com/guides/migration-v4/#main-content) for full migration from v4 => v5

#### Changes

- <!-- 61 --> [TextField] Fix hiddenLabel type of FilledInput (#26290) @siriwatknp
- <!-- 54 --> [TextField] Fix classes forward to InputBase (#26231) @arpitBhalla
- <!-- 17 --> [Autocomplete] Fix missing 'createOption' in AutocompleteCloseReason type (#26197) @Gautam-Arora24
- <!-- 30 --> [Autocomplete] Reduce CSS specificity by 1 (#26238) @Gautam-Arora24
- <!-- 07 --> [ButtonBase] Omit aria-disabled if not disabled (#26189) @Gautam-Arora24
- <!-- 18 --> [colors] Fix A inconsistencies (#26196) @oliviertassinari
- <!-- 08 --> [examples] Fix dynamic global styles & global styles leak in the ssr examples (#26177) @mnajdova
- <!-- 57 --> [Slider] Fix support for non primary colors (#26285) @davidfdriscoll
- <!-- 56 --> [Slider] Center value label for disabled slider (#26257) @davidfdriscoll
- <!-- 19 --> [styled-engine] Fix styled-components not supporting empty style (#26098) @ruppysuppy
- <!-- 21 --> [styles] Fix overrides type issues (#26228) @mnajdova
- <!-- 64 --> [Container] Fix support for custom breakpoints (#26328) @alanszp

### `@material-ui/lab@5.0.0-alpha.34`

- <!-- 68 --> [pickers] Migrate TimePickerToolbar to emotion (#26274) @siriwatknp
- <!-- 67 --> [pickers] Migrate DatePickerToolbar to emotion (#26292) @siriwatknp
- <!-- 66 --> [DateTimePicker] Migrate DateTimePickerTabs and Toolbar to emotion (#26327) @siriwatknp
- <!-- 33 --> [DatePicker] Migrate PickersYear to emotion (#25949) @siriwatknp
- <!-- 35 --> [DateRangePicker] Migrate PickersToolbarText to emotion (#25983) @siriwatknp
- <!-- 46 --> [pickers] Migrate StaticWrapper to emotion (#26275) @siriwatknp
- <!-- 58 --> [pickers] Migrate Clock to emotion (#26278) @siriwatknp
- <!-- 43 --> [pickers] Migrate PickersToolbar to emotion (#26273) @siriwatknp
- <!-- 42 --> [pickers] Migrate ClockNumber to emotion (#26058) @siriwatknp
- <!-- 41 --> [pickers] Migrate ClockPointer to emotion (#26057) @siriwatknp
- <!-- 32 --> [pickers] Migrate PickersMonth to emotion (#26021) @siriwatknp
- <!-- 26 --> [pickers] Migrate MonthPicker to emotion (#26025) @siriwatknp
- <!-- 25 --> [pickers] Migrate PickersDay to emotion (#25995) @siriwatknp
- <!-- 06 --> [pickers] Migrate PickersToolbarButton to emotion (#25989) @siriwatknp

### `@material-ui/icons@5.0.0-alpha.34`

- <!-- 52 --> [icons] Remove extraneous React.Fragment (#26308) @eps1lon
- <!-- 50 --> [icons] Synchronize icons (#26302) @eps1lon

  New DriveFileMove icon and its variants

### Docs

- <!-- 16 --> [NProgressBar] Fix invalid ARIA and HTML (#26234) @eps1lon
- <!-- 65 --> [docs] Simplify demos slider (#26324) @oliviertassinari
- <!-- 48 --> [docs] Use transpiled icons directly (#26268) @eps1lon
- <!-- 44 --> [docs] Remove dependency on withStyles from @material-ui/core/styles (#26269) @mnajdova
- <!-- 40 --> [docs] Add Jalali date picker demo (#26243) @smmoosavi
- <!-- 37 --> [docs] Remove last dependencies on `makeStyles` from `@material-ui/core/styles` (#26246) @mnajdova
- <!-- 29 --> [docs] Polish the pickers demo (#26094) @oliviertassinari
- <!-- 28 --> [docs] Fix broken overrides link on API pages (#26244) @mnajdova
- <!-- 27 --> [docs] Improve documentation for Buttons (#26184) @arpitBhalla
- <!-- 24 --> [docs] Emphasize on props for screen readers (#26222) @atisheyJain03
- <!-- 23 --> [docs] Link third-party routing in Bottom Navigation (#26190) @arpitBhalla
- <!-- 22 --> [docs] Migrate Select, Progress demos to emotion (#26178) @mnajdova
- <!-- 20 --> [docs] Add accessibility section to Badges (#26009) @likitarai1
- <!-- 15 --> [docs] Migrate Popper, Drawer demos to emotion (#26183) @mnajdova
- <!-- 12 --> [docs] Use public next/router events API (#26233) @eps1lon
- <!-- 11 --> [docs] Remove remnants Hidden component (#26191) @vicasas
- <!-- 09 --> [docs] Ensure TreeView demos don't overflow demo container (#26161) @eps1lon
- <!-- 05 --> [docs] Fix a typo in the import statement of LocalizationProvider (#26226) @huyenltnguyen
- <!-- 04 --> [docs] Improve react-admin coverage in the showcase (#26169) @fzaninotto
- <!-- 02 --> [docs] Fix Workbox that are causing infinite loading of site (#26193) @arpitBhalla

### Core

- <!-- 60 --> [core] Skip sx prop in internal components (#26235) @mnajdova
- <!-- 59 --> [core] Remove `withStyles` dependencies from `@material-ui/core/styles` (#26277) @mnajdova
- <!-- 55 --> [core] Include human readable target in the browserstack build (#26322) @eps1lon
- <!-- 53 --> [core] Fix NotchedOutlineProps type (#26305) @gnowland
- <!-- 51 --> [core] Add file for git-blame --ignore-revs-file (#26295) @eps1lon
- <!-- 49 --> [core] Ensure component class keys aren't missing (#25754) @eps1lon
- <!-- 38 --> [core] Drop support for blocking mode (#26262) @eps1lon
- <!-- 36 --> [core] Don't download monorepo packages (#26261) @eps1lon
- <!-- 14 --> [core] Batch small changes (#26199) @oliviertassinari
- <!-- 13 --> [core] Extract classes descriptions from TypeScript (#25933) @eps1lon
- <!-- 34 --> [styled-engine] Fix test script (#26258) @ruppysuppy

All contributors of this release in alphabetical order: @arpitBhalla, @atisheyJain03, @davidfdriscoll, @eps1lon, @fzaninotto, @Gautam-Arora24, @gnowland, @huyenltnguyen, @likitarai1, @m4theushw, @mnajdova, @oliviertassinari, @ruppysuppy, @siriwatknp, @smmoosavi, @vicas

## 5.0.0-alpha.33

_May 9, 2021_

Big thanks to the 17 contributors who made this release possible. Here are some highlights ✨:

- 💥 Make progress with the breaking changes. We have done 81 of the 109 changes [planned](https://github.com/mui-org/material-ui/issues/20012). We will release 5.0.0-beta.0 on July 1st and start to promote its usage over v4. You can also follow [our milestone](https://github.com/mui-org/material-ui/milestone/35) for more details.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.33`

#### Breaking changes

- <!-- 09 --> [core] Remove deprecated innerRef prop (#26028) @m4theushw

  **withStyles**

  Replace the `innerRef` prop with the `ref` prop. Refs are now automatically forwarded to the inner component.

  ```diff
  import * as React from 'react';
  import { withStyles } from '@material-ui/core/styles';
  const MyComponent = withStyles({
    root: {
      backgroundColor: 'red',
    },
  })(({ classes }) => <div className={classes.root} />);
  function MyOtherComponent(props) {
    const ref = React.useRef();
  - return <MyComponent innerRef={ref} />;
  + return <MyComponent ref={ref} />;
  }
  ```

  **withTheme**

  Replace the `innerRef` prop with the `ref` prop. Refs are now automatically forwarded to the inner component.

  ```diff
  import * as React from 'react';
  import { withTheme  } from '@material-ui/core/styles';
  const MyComponent = withTheme(({ theme }) => <div>{props.theme.direction}</div>);
  function MyOtherComponent(props) {
    const ref = React.useRef();
  - return <MyComponent innerRef={ref} />;
  + return <MyComponent ref={ref} />;
  }
  ```

- <!-- 10 --> [theme] Rename `createMuiTheme` to `createTheme` (#25992) @m4theushw

  Developers only need one theme in their application. A prefix would suggest a second theme is needed. It's not the case. `createMuiTheme` will be removed in v6.

  ```diff
  -import { createMuiTheme } from '@material-ui/core/styles';
  +import { createTheme } from '@material-ui/core/styles';

  -const theme = createMuiTheme({
  +const theme = createTheme({
  ```

- <!-- 74 --> [theme] Remove MuiThemeProvider alias (#26171) @m4theushw

  The `MuiThemeProvider` is no longer exported. Use `ThemeProvider` instead. It was removed from the documentation during v4-beta, 2 years ago.

  ```diff
  -import { MuiThemeProvider } from '@material-ui/core/styles';
  +import { ThemeProvider } from '@material-ui/core/styles';
  ```

- <!-- 20 --> [Box] Remove the `clone` prop (#26031) @m4theushw

  Its behavior can be obtained using the `sx` prop.

  ```diff
  -<Box sx={{ border: '1px dashed grey' }} clone>
  -  <Button>Save</Button>
  -</Box>
  +<Button sx={{ border: '1px dashed grey' }}>Save</Button>
  ```

- <!-- 51 --> [Box] Remove render prop (#26113) @m4theushw

  Its behavior can be obtained using the `sx` prop directly on the child if it's a Material-UI component. For non-Material-UI components use the `sx` prop in conjunction with the `component` prop:

  ```diff
  -<Box sx={{ border: '1px dashed grey' }}>
  -  {(props) => <Button {...props}>Save</Button>}
  -</Box>
  +<Button sx={{ border: '1px dashed grey' }}>Save</Button>
  ```

  ```diff
  -<Box sx={{ border: '1px dashed grey' }}>
  -  {(props) => <button {...props}>Save</button>}
  -</Box>
  +<Box component="button" sx={{ border: '1px dashed grey' }}>Save</Box>
  ```

- <!-- 25 --> [Checkbox] Make color="primary" default (#26002) @vicasas

  This better matches the Material Design guidelines.

  ```diff
  -<Checkbox />
  +<Checkbox color="secondary />
  ```

- <!-- 30 --> [Select] Remove `labelWidth` prop (#26026) @m4theushw

  The `label` prop now fulfills the same purpose, using CSS layout instead of JavaScript measurement to render the gap in the outlined. The TextField already handles it by default.

  ```diff
  -<Select variant="outlined" labelWidth={20} />
  +<Select label="Gender" />
  ```

- <!-- 50 --> [core] Remove `styled` JSS utility from `@material-ui/core/styles` (#26101) @mnajdova

  The `styled` **JSS** utility is no longer exported from `@material-ui/core/styles`. You can use `@material-ui/styles/styled` instead. Make sure to add a `ThemeProvider` at the root of your application, as the `defaultTheme` is no longer available. If you are using this utility together with `@material-ui/core`, it's recommended you use the `ThemeProvider` component from `@material-ui/core/styles` instead.

  ```diff
  -import { styled } from '@material-ui/core/styles';
  +import { styled } from '@material-ui/styles';
  +import { createTheme, ThemeProvider } from '@material-ui/core/styles';

  +const theme = createTheme();
   const MyComponent = styled('div')(({ theme }) => ({ background: theme.palette.primary.main }));

   function App(props) {
  -  return <MyComponent />;
  +  return <ThemeProvider theme={theme}><MyComponent {...props} /></ThemeProvider>;
   }
  ```

  For new components, you can instead use the `experimentalStyled()` helper powered by emotion/sc.

  ```jsx
  import { experimentalStyled as styled } from '@material-ui/core/styles';
  ```

- <!-- 63 --> [Hidden] Remove component (#26135) @m4theushw

  Removed in favor of using the `sx` prop or the `useMediaQuery` hook.

  Use the `sx` prop to replace `implementation="css"`:

  ```diff
  -<Hidden implementation="css" xlUp><Paper /></Hidden>
  -<Hidden implementation="css" xlUp><button /></Hidden>
  +<Paper sx={{ display: { xl: 'none', xs: 'block' } }} />
  +<Box component="button" sx={{ display: { xl: 'none', xs: 'block' } }} />
  ```

  ```diff
  -<Hidden implementation="css" mdDown><Paper /></Hidden>
  -<Hidden implementation="css" mdDown><button /></Hidden>
  +<Paper sx={{ display: { xs: 'none', md: 'block' } }} />
  +<Box component="button" sx={{ display: { xs: 'none', md: 'block' } }} />
  ```

  Use the `useMediaQuery` hook to replace `implementation="js"`:

  ```diff
  -<Hidden implementation="js" xlUp><Paper /></Hidden>
  +const hidden = useMediaQuery(theme => theme.breakpoints.up('xl'));
  +return hidden ? null : <Paper />;
  ```

- <!-- 64 --> [withWidth] Remove API (#26136) @m4theushw

  Removed in favor of the `useMediaQuery` hook. You can reproduce the same functionality creating a custom hook as described [here](https://next.material-ui.com/components/use-media-query/#migrating-from-withwidth).

- <!-- 75 --> [Autocomplete] Rename values of the reason argument (#26172) @m4theushw

  Rename the values of the reason argument in `onChange` and `onClose` for consistency:

  1. `create-option` to `createOption`
  2. `select-option` to `selectOption`
  3. `remove-option` to `removeOption`

- <!-- 28 --> [core] Remove `withTheme` from `@material-ui/core` (#26051) @mnajdova

  The `withTheme` utility has been removed from the `@material-ui/core/styles` package. You can use the `@material-ui/styles/withTheme` instead. Make sure to add a `ThemeProvider` at the root of your application, as the `defaultTheme` is no longer available. If you are using this utility together with `@material-ui/core`, it's recommended you use the `ThemeProvider` from `@material-ui/core/styles` instead.

  ```diff
   import * as React from 'react';
  -import { withTheme } from '@material-ui/core/styles';
  +import { withTheme } from '@material-ui/styles';
  +import { createTheme, ThemeProvider } from '@material-ui/core/styles';

  +const theme = createTheme();
   const MyComponent = withTheme(({ theme }) => <div>{props.theme.direction}</div>);

   function App(props) {
  -  return <MyComponent />;
  +  return <ThemeProvider theme={theme}><MyComponent {...props} /></ThemeProvider>;
   }
  ```

- <!-- 15 --> [core] Remove `createStyles` from `@material-ui/core` (#26018) @mnajdova

  - The `createGenerateClassName` module is no longer exported from `@material-ui/core/styles`. You should import it directly from `@material-ui/styles`.

  ```diff
  -import { createGenerateClassName } from '@material-ui/core/styles';
  +import { createGenerateClassName } from '@material-ui/styles';
  ```

  - The `jssPreset` object is no longer exported from `@material-ui/core/styles`. You should import it directly from `@material-ui/styles`.

  ```diff
  -import { jssPreset } from '@material-ui/core/styles';
  +import { jssPreset } from '@material-ui/styles';
  ```

  - The `ServerStyleSheets` component is no longer exported from `@material-ui/core/styles`. You should import it directly from `@material-ui/styles`.

  ```diff
  -import { ServerStyleSheets } from '@material-ui/core/styles';
  +import { ServerStyleSheets } from '@material-ui/styles';
  ```

- The `StylesProvider` component is no longer exported from `@material-ui/core/styles`. You should import it directly from `@material-ui/styles`.

  ```diff
  -import { StylesProvider } from '@material-ui/core/styles';
  +import { StylesProvider } from '@material-ui/styles';
  ```

- The `useThemeVariants` hook is no longer exported from `@material-ui/core/styles`. You should import it directly from `@material-ui/styles`.

  ```diff
  -import { useThemeVariants } from '@material-ui/core/styles';
  +import { useThemeVariants } from '@material-ui/styles';
  ```

- [FormControlLabel] The `label` prop is now required.

#### Changes

- <!-- 47 --> [Dialog] Improve support for custom breakpoints (#26092) @oliviertassinari
- <!-- 32 --> [IconButton] Fix default color prop (#26064) @Jack-Works
- <!-- 27 --> [Radio] Migrate RadioButtonIcon to emotion (#26068) @mnajdova
- <!-- 33 --> [SwipeableDrawer] Migrate SwipeArea to emotion (#26059) @mnajdova
- <!-- 72 --> [Table] Synchronize horizontal sticky header position with body (#26159) @LiKang6688
- <!-- 69 --> [Tabs] Fix support for null children in TabList (#26170) @hubertokf
- <!-- 31 --> [Tabs] Fix keyboard traversal over disabled tabs (#26061) @anish-khanna
- <!-- 55 --> [TextField] Fix missing `standard` variant classes in types (#26115) @siriwatknp
- <!-- 54 --> [TextField] Allow to customize Typography in FormControlLabel (#25883) @mousemke
- <!-- 17 --> [theme] Fix transition duration default value customization (#26054) @anshuman9999

### `@material-ui/lab@5.0.0-alpha.33`

#### Breaking changes

- <!-- 08 --> [Timeline] Add support for position override on items (#25974) @simonecervini

  Rename the `align` prop to `position` to reduce confusion.

  ```diff
  -<Timeline align="alternate">
  +<Timeline position="alternate">
  ```

  ```diff
  -<Timeline align="left">
  +<Timeline position="right">
  ```

  ```diff
  -<Timeline align="right">
  +<Timeline position="left">
  ```

- <!-- 56 --> [pickers] Remove customization of deep components (#26118) @eps1lon

#### Changes

- <!-- 02 --> [DatePicker] Migrate YearPicker to emotion (#25928) @siriwatknp
- <!-- 14 --> [DateRangePicker] Fix not being opened on click (#26016) @eps1lon
- <!-- 48 --> [pickers] Fix ref types (#26121) @eps1lon
- <!-- 43 --> [pickers] Rely on native behavior for disabled/readOnly behavior (#26055) @eps1lon
- <!-- 29 --> [pickers] Remove unused components from mobile and desktop variants (#26066) @eps1lon
- <!-- 23 --> [pickers] Document readonly/disabled pickers (#26056) @eps1lon
- <!-- 19 --> [pickers] Remove unused components from static variants (#26052) @eps1lon
- <!-- 13 --> [pickers] Toggle mobile keyboard view in the same commit as the view changes (#26017) @eps1lon
- <!-- 11 --> [pickers] Remove redundant aria-hidden (#26014) @eps1lon
- <!-- 04 --> [pickers] Ensure input value is reset in the same commit as the value (#25972) @eps1lon
- <!-- 49 --> [internal][pickers] Pass desktop wrapper props explicitly (#26120) @eps1lon
- <!-- 44 --> [internal][pickers] Move useInterceptProps into module (#26090) @eps1lon
- <!-- 37 --> [internal][pickers] Explicit default toolbar components (#26075) @eps1lon
- <!-- 35 --> [internal][pickers] Move validation from config to module (#26074) @eps1lon
- <!-- 21 --> [internal][pickers] Minimal types for defaultizing in useInterceptProps (#26063) @eps1lon
- <!-- 18 --> [internal][pickers] Don't validate inputFormat in production (#26053) @eps1lon
- <!-- 12 --> [internal][pickers] Remove unused styles (#26023) @eps1lon
- <!-- 03 --> [internal][pickers] Remove `AllSharedPickerProps` and `AllSharedDateRangePickerProps` (#26005) @eps1lon

### Docs

- <!-- 77 --> [docs] Migrate Tabs, Table, Snackbar demos to emotion (#26175) @mnajdova
- <!-- 73 --> [docs] Fix dynamic global styles (#25690) @mnajdova
- <!-- 71 --> [docs] Fixed React.forwardRef missing display name ESLint error (#26160) @arpitBhalla
- <!-- 70 --> [docs] Migrate Tooltip, Steppers demos to emotion (#26165) @mnajdova
- <!-- 68 --> [docs] Migrate Dialog demos to emotion (#26162) @vicasas
- <!-- 67 --> [docs] Remove `makeStyles` from landing pages (#26130) @mnajdova
- <!-- 65 --> [docs] Add new customized switch examples (#26096) @DanielBretzigheimer
- <!-- 62 --> [docs] Migrate Autocomplete demos  (#26127) @mnajdova
- <!-- 61 --> [docs] Remove `@material-ui/core/styles` from the styles pages (#26126) @mnajdova
- <!-- 60 --> [docs] Update templates, premium-themes to use `makeStyles` from `@material-ui/styles` (#26131) @mnajdova
- <!-- 59 --> [docs] Migrate TreeView demos (#26146) @mnajdova
- <!-- 57 --> [docs] More explicit breakpoint documentation in `sx` (#26140) @eps1lon
- <!-- 53 --> [docs] Explicitly describe how the media query affects the rendered version (#26129) @eps1lon
- <!-- 45 --> [docs] Fix 301 link to store (#26095) @oliviertassinari
- <!-- 42 --> [docs] Normalize name use for state in pickers demo (#26093) @oliviertassinari
- <!-- 41 --> [docs] Consistent type name in docs (#26077) @jamesaucode
- <!-- 38 --> [docs] Remove `makeStyles` dependency from core in modules (#26071) @mnajdova
- <!-- 34 --> [docs] Add links for demo in different deploys (#26065) @eps1lon
- <!-- 26 --> [docs] Add section for useFormControl (#25927) @t49tran
- <!-- 24 --> [docs] Add Styled Engine page (#25911) @mnajdova
- <!-- 16 --> [docs] Migrate Timeline demos to emotion (#26036) @vicasas
- <!-- 07 --> [docs] Document all the colors available (#26015) @anshuman9999
- <!-- 01 --> [docs] Avoid extracting classes twice (#25973) @oliviertassinari

### Core

- <!-- 52 --> [test] Add test for behavior when picker variant changes (#26128) @eps1lon
- <!-- 36 --> [test] testing-library patterns for playwright tests (#25860) @eps1lon
- <!-- 22 --> [test] Remove scheduler/tracing (#26062) @eps1lon
- <!-- 05 --> [test] Remove duplicate property (#26011) @eps1lon
- <!-- 76 --> [core] Link to experimental size-comparison page (#26179) @eps1lon
- <!-- 66 --> [core] Update typings for theme's components (#26125) @mnajdova
- <!-- 58 --> [core] Improve `react@experimental` compat (#26116) @eps1lon
- <!-- 46 --> [core] Remove more dependencies on `@material-ui/styles` (#26100) @mnajdova
- <!-- 40 --> [core] Batch small changes (#26083) @oliviertassinari
- <!-- 39 --> [core] ComponentType -> JSXElementConstructor (#26081) @eps1lon
- <!-- 06 --> [core] Create new @material-ui/private-theming package (#25986) @mnajdova

All contributors of this release in alphabetical order: @anish-khanna, @anshuman9999, @arpitBhalla, @DanielBretzigheimer, @eps1lon, @hubertokf, @Jack-Works, @jamesaucode, @LiKang6688, @m4theushw, @mnajdova, @mousemke, @oliviertassinari, @simonecervini, @siriwatknp, @t49tran, @vicasas

## 5.0.0-alpha.32

<!-- generated comparing v5.0.0-alpha.31..next -->

_Apr 27, 2021_

Big thanks to the 15 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 We have completed the migration to emotion of all components in `@material-ui/core`. We will focus on the components in `@material-ui/lab` next.
- 💥 Make progress with the breaking changes plan. We have done 38 out of 41 breaking changes that can be deprecated. We have done 21 out of the 39 that can't have deprecations. Once done, we will focus on updating the component for better following material design, and to improve the aesthetic.
- 💄 Support extending the theme for custom color and size values in all components.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.32`

#### Breaking changes

- <!-- 46 -->  [Table] Rename padding="default" to padding="normal" (#25924) @m4theushw

  ```diff
  -<Table padding="default" />
  -<TableCell padding="default" />
  +<Table padding="normal" />
  +<TableCell padding="normal" />
  ```

- <!-- 29 --> [Button] Rename `pending` prop to `loading` in LoadingButton (#25874) @m4theushw

  ```diff
  -<LoadingButton pending pendingIndicator="Pending..." pendingPosition="end" />
  +<LoadingButton loading loadingIndicator="Pending..." loadingPosition="end" />
  ```

- <!-- 25 --> [ButtonBase] Remove buttonRef prop (#25896) @m4theushw

  ```diff
  -<ButtonBase buttonRef={ref} />
  +<ButtonBase ref={ref} />
  ```

  ```diff
  -<Button buttonRef={ref} />
  +<Button ref={ref} />
  ```

- <!-- 41 --> [Checkbox][Switch] Remove checked argument from onChange (#25871) @m4theushw

  ```diff
  function MyCheckbox() {
  - const handleChange = (event: React.ChangeEvent<HTMLInputElement>, checked: boolean) => {
  + const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
  +   const checked = event.target.checked;
    };
    return <Checkbox onChange={handleChange} />;
  }
  ```

  ```diff
  function MySwitch() {
  - const handleChange = (event: React.ChangeEvent<HTMLInputElement>, checked: boolean) => {
  + const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
  +   const checked = event.target.checked;
    };
    return <Switch onChange={handleChange} />;
  }
  ```

- <!-- 42 --> [theme] Remove theme.breakpoints.width helper (#25918) @m4theushw

  ```diff
  -theme.breakpoints.width('md')
  +theme.breakpoints.values.md
  ```

- <!-- 32 --> [theme] Remove theme.typography.round helper (#25914) @m4theushw

  The `theme.typography.round` helper was removed because it was no longer used. If you need it, use the function below:

  ```js
  function round(value) {
    return Math.round(value * 1e5) / 1e5;
  }
  ```

#### Changes

- <!-- 03 --> [Container] Fix maxWidth="false" resulting in incorrect css (#25869) @mnajdova
- <!-- 49 --> [core] Improve support for extended props in theme (#25934) @vicasas
- <!-- 45 --> [core] Fix various too wide `classes` types (AppBar, Card, Link, LoadingButton, MenuItem) (#25917) @eps1lon
- <!-- 05 --> [Drawer] Fix classes forwarded to DOM node for docked drawer (#25870) @mnajdova
- <!-- 21 --> [IconButton] Support custom colors and sizes (#25890) @Vikram710
- <!-- 16 --> [l10n] Add Bengali (bnBD) locale (#25841) @Knoxo
- <!-- 34 --> [Rating] Support custom sizes (#25922) @vicasas
- <!-- 30 --> [Select] Fix classes leaking on the DOM (#25894) @siriwatknp
- <!-- 43 --> [Stack] Fix support of spacing falsy values (#25937) @simonecervini
- <!-- 22 --> [Table] Migrate TablePagination to emotion (#25809) @siriwatknp
- <!-- 26 --> [Tabs] Migrate Tabs to emotion (#25824) @siriwatknp
- <!-- 50 --> [TextField] Remove utlity class name for margin="none" (#25969) @oliviertassinari
- <!-- 24 --> [TextField] Make the `position` prop required in InputAdornment (#25891) @m4theushw
- <!-- 23 --> [theme] Remove fade color helper (#25895) @m4theushw

### `@material-ui/lab@5.0.0-alpha.32`

- <!-- 53 --> [DateTimePicker] `date` is nullable in `onChange` (#25981) @eps1lon
- <!-- 39 --> [internal][Pickers] Remove unused TView type argument (#25936) @eps1lon
- <!-- 48 --> [internal][Pickers] Inline some BasePickerProps usages (#25971) @eps1lon
- <!-- 44 --> [internal][Pickers] Entangle what *Props vs All*Props means (#25938) @eps1lon
- <!-- 19 --> [lab] Update slot components to use overridesResolver (#25906) @mnajdova
- <!-- 40 --> [Timeline] Remove use of nth-child in favor of nth-of-type (#25915) @wellwellmissesanderson
- <!-- 06 --> [Timeline] Migrate Timeline to emotion (#25838) @siriwatknp
- <!-- 55 --> [TreeView] Migrate TreeItem to emotion (#25835) @siriwatknp

### `@material-ui/styled-engine@5.0.0-alpha.32`

- <!-- 02 --> [styled-engine] Skip variants resolver for non root slots by default (#25865) @mnajdova

### `@material-ui/system@5.0.0-alpha.32`

- <!-- 12 --> [system] Add missing `main` entry for styleFunctionSx (#25885) @eps1lon

### `@material-ui/types@6.0.0`

This package is just re-released since version 5.1.7 had a breaking change.

### Docs

- <!-- 28 --> [Autocomplete] Fix tagSize class typo (#25908) @JanMisker
- <!-- 51 --> [DataGrid] Update docs sections (#25980) @dtassone
- <!-- 38 --> [docs] Batch small fixes (#25807) @m4theushw
- <!-- 13 --> [docs] Explicitly list demos of unstyled components (#25900) @eps1lon
- <!-- 04 --> [docs] Expose heading links in a11y tree (#25861) @eps1lon
- <!-- 58 --> [docs] Fix minor typo (#26001) @onpaws
- <!-- 09 --> [docs] Fix global styles leaking on different pages (#25855) @mnajdova
- <!-- 31 --> [docs] Fix Typography api docs for `paragraph` prop (#25929) @DanailH
- <!-- 17 --> [docs] Fix Slider's classes wrong description (#25907) @mnajdova
- <!-- 37 --> [docs] Grammar correction in autocomplete API (#25910) @gruber76
- <!-- 15 --> [docs] Require documentation of demos (#25811) @eps1lon
- <!-- 36 --> [docs] Update minimum required TypeScript version (#25930) @eps1lon
- <!-- 56 --> [Table] Improve description of TablePagination.rowsPerPageOptions (#25982) @kevinlul

### Core

- <!-- 54 --> [core] Fix wrong imports to '@material-ui/styles' (#25984) @mnajdova
- <!-- 52 --> [core] Ensure props spreading works as expected (#25939) @oliviertassinari
- <!-- 47 --> [core] Batch small changes (#25968) @oliviertassinari
- <!-- 35 --> [core] Enable trailing comma in TypeScript files (#25931) @eps1lon
- <!-- 33 --> [core] Remove @typescript-to-proptypes-generate handlers (#25909) @eps1lon
- <!-- 18 --> [core] Update slots components to enable flatten specificity for overrides (#25853, #25864, #25881, #25884, #25887, #25904, #25892) @mnajdova
- <!-- 27 --> [test] Add current behavior of inverleaving elements on mousedown (#25903) @eps1lon
- <!-- 20 --> [test] Add test validator to improve DX (#25854) @siriwatknp
- <!-- 57 --> [test] Fix duplicate key in TreeItem test (#26000) @mnajdova

All contributors of this release in alphabetical order: @DanailH, @dtassone, @eps1lon, @gruber76, @JanMisker, @kevinlul, @Knoxo, @m4theushw, @mnajdova, @oliviertassinari, @simonecervini, @siriwatknp, @vicasas, @Vikram710, @wellwellmissesanderson

## 5.0.0-alpha.31

<!-- generated comparing v5.0.0-alpha.30..next -->

_Apr 20, 2021_

Big thanks to the 19 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Migrate 4 components to emotion.
- 💥 Resume work on the breaking changes, aim for v5.0.0-beta.0 in the next coming months.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.31`

#### Breaking changes

- [FormControl] Change default variant from standard to outlined (#24895) @petyosi
  Standard has been removed from the Material Design guidelines. [This codemod](https://github.com/mui-org/material-ui/tree/next/packages/material-ui-codemod#variant-prop) will automatically update your code.

  ```diff
  -<FormControl value="Standard" />
  -<FormControl value="Outlined" variant="outlined" />
  +<FormControl value="Standard" variant="standard" />
  +<FormControl value="Outlined" />
  ```

- [Menu] The `selectedMenu` variant will not vertically align the selected item with the anchor anymore. (#25691) @m4theushw
- [Popover] Remove the `getContentAnchorEl` prop to simplify the positioning logic. (#25691) @m4theushw
- [Select] Change default variant from standard to outlined (#24895) @petyosi
  Standard has been removed from the Material Design guidelines. [This codemod](https://github.com/mui-org/material-ui/tree/next/packages/material-ui-codemod#variant-prop) will automatically update your code.

  ```diff
  -<Select value="Standard" />
  -<Select value="Outlined" variant="outlined" />
  +<Select value="Standard" variant="standard" />
  +<Select value="Outlined" />
  ```

#### Changes

- <!-- 17 --> [Alert] Fix action to be aligned with the text (#25768) @mnajdova
- <!-- 30 --> [Avatar] Fix onload event not firing when img cached (#25793) @npandrei
- <!-- 35 --> [Box] Add utility mui class (#25802) @mnajdova
- <!-- 24 --> [core] Don't call noop event.persist() (#25782) @eps1lon
- <!-- 52 --> [Dialog] Fix support of custom breakpoint units (#25788) @Vikram710
- <!-- 26 --> [List] Fix support for list item container style overrides (#25777) @mnajdova
- <!-- 21 --> [Rating] Allow clearing ratings with arrow keys (#25645) @Vikram710
- <!-- 05 --> [Rating] Fix focus visible regression (#25698) @oliviertassinari
- <!-- 46 --> [Select] Fix specificity of style overrides (#25766) @robphoenix
- <!-- 39 --> [Select] Fix className overwritten (#25815) @siriwatknp
- <!-- 33 --> [Select] Fix overrides for slots (#25796) @mnajdova
- <!-- 19 --> [Snackbar] Fix hidden overlay blocking interactions regression (#25739) @MieleVL
- <!-- 13 --> [TextField] Fix InputAdornment classes (#25749) @mnajdova
- <!-- 07 --> [theme] Avoid mutating args in createSpacing (#25745) @eps1lon

### `@material-ui/lab@5.0.0-alpha.31`

#### Breaking changes

- <!-- 37 --> [Pickers] Rename DayPicker to CalendarPicker (#25810) @eps1lon

  ```diff
  -import DayPicker from '@material-ui/lab/DayPicker';
  +import CalendarPicker from '@material-ui/lab/CalendarPicker';

  createMuiTheme({
    components: {
  -   MuiDayPicker: {},
  +   MuiCalendarPicker: {},
    }
  })
  ```

- <!-- 04 --> [Pickers] Rename PickersCalendarSkeleton to CalendarPickerSkeleton (#25679) @eps1lon

  ```diff
  -import PickersCalendarSkeleton from '@material-ui/lab/PickersCalendarSkeleton';
  +import CalendarPickerSkeleton from '@material-ui/lab/CalendarPickerSkeleton';
  ```

- <!-- 06 --> [Pickers] Rename `date` `view` to `day` (#25685) @eps1lon

  ```diff
  -<DatePicker openTo="date" views={['date', 'month']} />
  +<DatePicker openTo="day" views={['day', 'month']} />
  ```

#### Changes

- <!-- 16 --> [DateRangePicker] Add DateRangePickerDay to theme augmentation list (#25758) @ifndefdeadmau5
- <!-- 38 --> [Pickers] Rename internal DayPickerView to CalendarPickerView (#25817) @eps1lon
- <!-- 41 --> [Pickers] Remove `TView` generic in CalendarPicker (#25818) @eps1lon
- <!-- 40 --> [Pickers] Use passive effect to attach close-on-escape listener (#25819) @eps1lon
- <!-- 50 --> [Timeline] Migrate TimelineDot to emotion (#25830) @vicasas
- <!-- 28 --> [Timeline] Migrate TimelineContent to emotion (#25781) @siriwatknp
- <!-- 53 --> [Timeline] Migrate TimelineItem to emotion (#25822) @vicasas
- <!-- 47 --> [Timeline] Migrate TimelineOppositeContent to emotion (#25816) @vicasas
- <!-- 54 --> [TrapFocus] Make isEnabled and getDoc optional (#25784) @m4theushw

### `@material-ui/styled-engine@5.0.0-alpha.31`

- <!-- 27 --> [styled-engine] Fix shouldForwardProp on slots (#25780) @mnajdova
- <!-- 11 --> [styled-engine] Improve GlobalStyles props (#25751) @mnajdova

### `@material-ui/unstyled@5.0.0-alpha.31`

- <!-- 14 --> [unstyled] Convert generateUtilityClass(es) to TypeScript (#25753) @eps1lon

### Docs

- <!-- 31 --> [Avatar] Set backgroundColor from string (#25789) @Vikram710
- <!-- 59 --> [docs] Add demos for public picker components (#25812) @eps1lon
- <!-- 49 --> [docs] Add example with switch dark/light mode (#25823) @Vikram710
- <!-- 01 --> [docs] Add package headings to 5.0.0-alpha.30 changelog (#25733) @eps1lon
- <!-- 61 --> [docs] Add unstyled section to all components coming with the package (#25843) @mnajdova
- <!-- 10 --> [docs] Breakdown Chip demos into smaller ones (#25750) @vicasas
- <!-- 12 --> [docs] Document circular progress inherit (#25736) @oliviertassinari
- <!-- 58 --> [docs] Fix /production-error crash (#25839) @eps1lon
- <!-- 48 --> [docs] Fix ad duplication (#25831) @oliviertassinari
- <!-- 09 --> [docs] Fix autocommplete disable event value (#25752) @oliviertassinari
- <!-- 56 --> [docs] Fix inline-preview selection controls (#25834) @oliviertassinari
- <!-- 29 --> [docs] Fix Horizontally centered demo (#25787) @viditrv123
- <!-- 45 --> [docs] Improve pickers migration docs from v3 (#25813) @ahmed-28
- <!-- 15 --> [docs] Move DataGrid editing nav link (#25769) @dtassone
- <!-- 36 --> [docs] Replace Typography color values with system values (#25805) @oliviertassinari
- <!-- 60 --> [docs] Remove one inline-style (#25671) @oliviertassinari
- <!-- 18 --> [docs] Use gender neutral pronoun for Swipeable Drawer (#25775) @catchanuj
- <!-- 20 --> [examples] Add TypeScript for styled-components engine (#25675) @jqrun
- <!-- 23 --> [l10n] zhTW refinement (#25786) @shakatoday
- <!-- 44 --> [Tabs] Add demo for routing with Tabs (#25827) @ahmed-28
- <!-- 57 --> [website] Add Matheus Wichman (#25801) @m4theushw

### Core

- <!-- 42 --> [core] Batch small changes (#25804) @oliviertassinari
- <!-- 02 --> [core] Document token permissions of release:changelog (#25732) @eps1lon
- <!-- 34 --> [core] Error when installing in unsupported node environments (#25795) @eps1lon
- <!-- 43 --> [core] Fix rgba to hex conversion (#25825) @saeedeyvazy
- <!-- 08 --> [core] Normalize usage of pseudo classes selectors (#25748) @mnajdova
- <!-- 51 --> [core] Remove unused public types (#25833) @oliviertassinari
- <!-- 25 --> [core] Remove incorrect overridesResolver usages (#25778) @mnajdova
- <!-- 03 --> [test] Use public imports (#25686) @vicasas
- <!-- 22 --> [core] Use readonly arrays where possible (#25746) @eps1lon

All contributors of this release in alphabetical order: @ahmed-28, @catchanuj, @dtassone, @eps1lon, @ifndefdeadmau5, @jqrun, @m4theushw, @MieleVL, @mnajdova, @npandrei, @oliviertassinari, @petyosi, @robphoenix, @saeedeyvazy, @shakatoday, @siriwatknp, @vicasas, @viditrv123, @Vikram710

## 5.0.0-alpha.30

<!-- generated comparing v5.0.0-alpha.29..next -->

_Apr 12, 2021_

Big thanks to the 21 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Migrate 9 components to emotion.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.30`

- <!-- 19 --> [Alert] Vertically align action on top (#25654) @xdshivani
- <!-- 37 --> [Autocomplete] Fix text field standard visual regression (#25676) @oliviertassinari
- <!-- 08 --> [CssBaseline] Fix @font-face rule broken in styleOverrides (#25583) @mnajdova
- <!-- 45 --> [Grid] Support custom number of columns (#25636) @Avi98
- <!-- 15 --> [InputBase] Fix autofill typo (#25651) @michal-perlakowski
- <!-- 43 --> [LinearProgress] Add color="inherit" support (#25641) @itscharlieliu
- <!-- 06 --> [Pagination] Allow to differentiate more item types (#25622) @ruppysuppy
- <!-- 35 --> [Popover] Add popoverClasses export to type declarations (#25695) @tomasznguyen
- <!-- 33 --> [Rating] Add highlight selected rating only (#25649) @Vikram710
- <!-- 14 --> [Rating] Migrate to emotion (#25588) @natac13
- <!-- 38 --> [Select] Migrate to emotion (#25653) @mnajdova
- <!-- 17 --> [Select] Migrate NativeSelect to emotion (#24698) @duganbrett
- <!-- 28 --> [SpeedDial] Fix broken aria reference issue (#25665) @RiyaNegi
- <!-- 05 --> [Stepper] Migrate MobileStepper to emotion (#25589) @natac13
- <!-- 13 --> [styles] Outdated warning message (#25637) @bhairavee23
- <!-- 32 --> [Table] Remove legacy fix for JSS (#25692) @oliviertassinari
- <!-- 10 --> [Table] Migrate TableSortLabel to emotion (#25638) @natac13
- <!-- 16 --> [TabPanel] Migrate to emotion (#25646) @tomasznguyen
- <!-- 11 --> [TextareaAutosize] Fix resizing bug on Firefox (#25634) @bhairavee23
- <!-- 44 --> [TextField] Add textFieldClasses export to type declarations (#25696) @tomasznguyen
- <!-- 39 --> [theme] Change default bgColor to white in light mode (#25730) @saleebm
- <!-- 02 --> [ToggleButton] Add fullWidth prop (#25585) @hcz
- <!-- 40 --> [typescript] Add muiName to declarations (#25689) @michal-perlakowski

### `@material-ui/lab@5.0.0-alpha.30`

- <!-- 20 --> [Timeline] Migrate TimelineSeparator to emotion (#25666) @vicasas
- <!-- 18 --> [Timeline] Migrate TimelineConnector to emotion (#25663) @vicasas
- <!-- 42 --> [TimePicker] Use clock icon when editing in mobile mode (#25569) @alcwhite
- <!-- 29 --> [TreeView] Migrate to emotion (#25673) @tomasznguyen

### Docs

- <!-- 31 --> [blog] Fix typos @oliviertassinari
- <!-- 41 --> [docs] Migrate TextField demos to emotion (#25626) @vicasas
- <!-- 36 --> [docs] Bump stylis-plugin-rtl requirement (#25661) @mnajdova
- <!-- 34 --> [docs] Ensure old api-docs translations are cleaned (#25680) @eps1lon
- <!-- 25 --> [docs] Fix typo in v4 migration doc (#25678) @thameera
- <!-- 23 --> [docs] Fix useLayoutEffect warning (#25670) @oliviertassinari
- <!-- 22 --> [docs] Fix a11y issue in the SpeedDial docs (#25669) @RiyaNegi
- <!-- 12 --> [docs] Cover TypeScript commands in codemod readme (#25640) @StuffByLiang
- <!-- 09 --> [docs] Migrate Popover demos to emotion (#25620) @vicasas
- <!-- 07 --> [docs] Fix typo in switches and checkboxes doc (#25639) @dimitropoulos
- <!-- 03 --> [docs] Add interoperability section for Portal (#25575) @mnajdova
- <!-- 01 --> [docs] Fix side nav scroll position (#25619) @misaka3
- <!-- 30 --> [website] Q1 2021 Update (#25591) @oliviertassinari
- <!-- 04 --> [website] Matheus Wichman joins Material-UI (#25590) @oliviertassinari

### Core

- <!-- 27 --> [test] Use public api in lab (#25682) @vicasas
- <!-- 26 --> [test] Test types of .spec lab files (#25684) @eps1lon
- <!-- 24 --> [core] Fix build step for unstyled package (#25672) @oliviertassinari
- <!-- 21 --> [core] Ensure react-is uses v17 (#25668) @eps1lon

All contributors of this release in alphabetical order: @alcwhite, @bhairavee23, @dimitropoulos, @duganbrett, @eps1lon, @hcz, @itscharlieliu, @michal-perlakowski, @misaka3, @mnajdova, @natac13, @oliviertassinari, @RiyaNegi, @ruppysuppy, @saleebm, @StuffByLiang, @thameera, @tomasznguyen, @vicasas, @Vikram710, @xdshivani

## 5.0.0-alpha.29

<!-- generated comparing v5.0.0-alpha.28..next -->

_Apr 4, 2021_

Big thanks to the 26 contributors who made this release possible. Here are some highlights ✨:

- 🙌 Add support in the Grid for any spacing value (#25503) @ZakMiller.
  For instance:

  ```jsx
  <Grid container spacing={1.5}>
  <Grid container spacing="30px">
  ```

  This feature was made possible by the recent migration to emotion.
  You can [find the other issues](https://github.com/mui-org/material-ui/issues?q=is%3Aopen+is%3Aissue+label%3A%22component%3A+Grid%22) unlocked by the migration to emotion on the Grid component that are left to be solved.

- 👩‍🎤 Convert 3 components to emotion (#25541, #25516, #25521) @rajzik, @praveenkumar-kalidass, @siriwatknp.
- 📚 Migrate 8 component demo pages to the `sx`, `Stack`, and `styled` API @vicasas.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.29`

- <!-- 39 --> [AppBar] Fix type support of overridable component (#25456) @heleg
- <!-- 26 --> [Autocomplete] Fix Async demo in docs (#25536) @kanish671
- <!-- 23 --> [Autocomplete] Fix TypeScript wrapper example (#25530) @JanKaczmarkiewicz
- <!-- 21 --> [Backdrop] Remove z-index: -1 (#25524) @silver-snoopy
- <!-- 41 --> [Card] Add component prop support (#25537) @silver-snoopy
- <!-- 31 --> [CssBaseline] Migrate ScopedCssBaseline to emotion (#25541) @rajzik
- <!-- 03 --> [Divider] Support middle variant with vertical orientation (#25428) @vedadeepta
- <!-- 16 --> [Grid] Support decimal spacing (#25503) @ZakMiller
- <!-- 28 --> [List] Remove background inheritance of ListSubheader (#25532) @tanmoyopenroot
- <!-- 40 --> [Paper] Support dark mode brightening based on elevation (#25522) @m4theushw
- <!-- 43 --> [Select] Fix selection of non-options (#25567) @oliviertassinari
- <!-- 34 --> [Select] Set aria-expanded to false when listbox is collapsed (#25545) @Harish-Karthick
- <!-- 18 --> [SpeedDial] Call focus on escape (#25509) @tanmoyopenroot
- <!-- 20 --> [Stack] Add component prop (#25526) @silver-snoopy
- <!-- 07 --> [Stack] Fix the :not selector (#25484) @Andarist
- <!-- 24 --> [Stepper] Migrate StepButton to emotion (#25516) @praveenkumar-kalidass
- <!-- 22 --> [Stepper] Migrate Stepper to emotion (#25521) @siriwatknp
- <!-- 01 --> [Tabs] Don't animate scroll on first render (#25469) @manziEric
- <!-- 25 --> [Tooltip] Fix forwarded classes (#25535) @silver-snoopy

### `@material-ui/unstyled@5.0.0-alpha.29`

- <!-- 38 --> [Slider] Allow disabling the left and right thumbs swap (#25547) @michal-perlakowski

### `@material-ui/lab@5.0.0-alpha.29`

- <!-- 12 --> [DateRangePicker] Fix props naming in DatePicker components (#25504) @callmeberzerker
- <!-- 04 --> [DateRangePickerInput][internal] Inline makeDateRangePicker calls (#25470) @eps1lon
- <!-- 06 --> [StaticDateRangePicker] Fix inconsistent name for theme props (#25483) @eps1lon
- <!-- 17 --> [Pickers] Move own internals from lab internals to dedicated file (#25498) @eps1lon

### Docs

- <!-- 46 --> [docs] Provide an alternative to right-to-left (#25584) @dariusk
- <!-- 45 --> [docs] Add note for typescript on the styled() customization guide (#25576) @mnajdova
- <!-- 44 --> [docs] Replace incorrect instances of defined with define (#25572) @surajpoddar16
- <!-- 42 --> [docs] Fix spelling error in roadmap.md file (#25570) @Brlaney
- <!-- 37 --> [docs] Migrate Card demos to emotion (#25557) @vicasas
- <!-- 36 --> [docs] Fix typo in data grid (#25561) @michael-001
- <!-- 33 --> [docs] Migrate Menu demos to emotion (#25554) @vicasas
- <!-- 32 --> [docs] Fix <kbd> style in dark mode (#25551) @m4theushw
- <!-- 30 --> [docs] Document changing skeleton color (#25542) @ZakMiller
- <!-- 29 --> [docs] Improve coverage of TypeScript theme augmentation (#25489) @ashishshuklabs
- <!-- 27 --> [docs] Update minimizing-bundle-size.md (#25534) @nguyenyou
- <!-- 15 --> [docs] Migrate Portal demos to emotion (#25505) @vicasas
- <!-- 14 --> [docs] Migrate NoSSR demos to emotion (#25506) @vicasas
- <!-- 13 --> [docs] Migrate ClickAwayListener demos to emotion (#25507) @vicasas
- <!-- 10 --> [docs] Cover change of React support (#25487) @oliviertassinari
- <!-- 09 --> [docs] Migrate Transitions demos to emotion (#25488) @vicasas
- <!-- 08 --> [docs] Fix Stack divider demo (#25491) @oliviertassinari
- <!-- 02 --> [docs] Migrate Icons demos to emotion (#25412) @vicasas

### Core

- <!-- 19 --> [core] Use latest TypeScript in typescript-to-proptypes (#25512) @eps1lon
- <!-- 11 --> [core] Update the codesandbox issue templates (#25501) @oliviertassinari
- <!-- 05 --> [test] Wait on e2e server to start before starting runner (#25476) @eps1lon

All contributors of this release in alphabetical order: @Andarist, @ashishshuklabs, @Brlaney, @callmeberzerker, @dariusk, @eps1lon, @Harish-Karthick, @heleg, @JanKaczmarkiewicz, @kanish671, @m4theushw, @manziEric, @michael-001, @michal-perlakowski, @mnajdova, @nguyenyou, @oliviertassinari, @praveenkumar-kalidass, @rajzik, @silver-snoopy, @siriwatknp, @surajpoddar16, @tanmoyopenroot, @vedadeepta, @vicasas, @ZakMiller

## 5.0.0-alpha.28

_Mar 22, 2021_

Big thanks to the 34 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Convert 9 components to emotion (#25267, #25216, #25264, #25197, #25372, #25281, #25210, #25279, #2528) @natac13 @tomasznguyen @kayuapi.
  85% of the components have been migrated so far, thanks to the help of the community.
- 📚 Migrate 18 component demo pages to the `sx`, `Stack`, and `styled` API @vicasas.
  This was also an importunity to breakdown the existing large demos into smaller and more focuses ones.
- Add a new Stack component (#25149) @souporserious
  The component allows to workaround the lack of support for the CSS flexbox `gap` property across browsers.

  <img width="830" alt="stack" src="https://user-images.githubusercontent.com/3165635/112068427-29434200-8b6a-11eb-94e8-057535423b0f.png">

  See the documentation for [more details](https://next.material-ui.com/components/stack/).

- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.28`

#### Breaking changes

- [core] Drop support for React 16 (#25464) @eps1lon
- <!-- 36 --> [core] Drop support for node 10 (#25306) @eps1lon

#### Changes

- <!-- 70 --> [Autocomplete] Warn when the input didn't resolve in time (#25311) @LaneRamp
- <!-- 26 --> [Autocomplete] Fix styleOverrides support (#25276) @manziEric
- <!-- 68 --> [ButtonBase] Allow to customize the link component via theme (#25331) @vedadeepta
- <!-- 43 --> [ButtonBase] Fix default type attribute (submit -> button) (#25323) @RTEYL
- <!-- 73 --> [ButtonGroup] Support custom colors (#25413) @oliviertassinari
- <!-- 13 --> [CircularProgress] Fix animation when disableShrink={true} (#25247) @duongdev
- <!-- 29 --> [Dialog] Fix typo (#25287) @aheimlich
- <!-- 22 --> [Dialog] Migrate DialogContentText to emotion (#25267) @tomasznguyen
- <!-- 04 --> [Dialog] Migrate Dialog to emotion (#25216) @natac13
- <!-- 79 --> [Drawer] Fix RTL support (#25453) @silver-snoopy
- <!-- 50 --> [Menu] Migrate to emotion (#25264) @tomasz-crozzroads
- <!-- 77 --> [Paper] Fix component prop type error (#25426) @heleg
- <!-- 17 --> [Popover] Migrate to emotion (#25197) @tomasznguyen
- <!-- 59 --> [Radio] Fix html structure (#25398) @oliviertassinari
- <!-- 58 --> [Select] Fix focus background when variant="outlined" (#25393) @christiaan
- <!-- 62 --> [Slider] Add `tabIndex` prop (#25388) @johnloven
- <!-- 88 --> [Snackbar] Fix prop type error for 'key' prop (#25431) @jansedlon
- <!-- 38 --> [SpeedDial] Reset tooltip state when the speed dial is closed (#25259) @m4theushw
- <!-- 71 --> [Stack] Add new component (#25149) @souporserious
- <!-- 81 --> [Stepper] Migrate StepLabel to emotion (#25372) @praveenkumar-kalidass
- <!-- 27 --> [Stepper] Migrate StepIcon to emotion (#25281) @praveenkumar-kalidass
- <!-- 08 --> [Stepper] Migrate StepContent to emotion (#25210) @praveenkumar-kalidass
- <!-- 30 --> [SwipeableDrawer] Fix hideBackDrop support (#25275) @manziEric
- <!-- 75 --> [Table] Fix duplicated keys in TablePagination rows per page (#25309) @martinfrancois
- <!-- 72 --> [Table] Consistency with DataTable (#25414) @oliviertassinari
- <!-- 76 --> [TextField] Size small for multiline (#25423) @julihereu
- <!-- 48 --> [TextField] Migrate InputAdornment to emotion (#25279) @kayuapi
- <!-- 47 --> [TextField] Migrate to emotion (#25286) @tomasznguyen
- <!-- 74 --> [ToggleButton] Add color prop (#25390) @AlfredoGJ
- <!-- 82 --> [Tooltip] Make `disableFocusListener` prop comment clearer (#25455) @jansedlon
- <!-- 24 --> [Tooltip] Fix placement regression (#25255) @oliviertassinari
- <!-- 25 --> [Transition] Add easing prop to override default timing function (#25245) @jeferson-sb

### `@material-ui/lab@5.0.0-alpha.28`

- <!-- 85 --> [Pickers] Follow "private by default" in makeDateRangePicker (#25424) @eps1lon
- <!-- 53 --> [Pickers] Simplify internals of *Wrapper components (#25369) @eps1lon
- <!-- 35 --> [Pickers] Remove `make*` HOCs (#25172) @eps1lon
- <!-- 19 --> [Pickers] Remove propTypes in production for exotic components (#25261) @eps1lon
- [Pickers] Unify ref behavior (#25425) @eps1lon
- [Pickers] Sort properties (#25473) @eps1lon

### `@material-ui/utils@5.0.0-alpha.28`

- <!-- 90 --> [utils] Fix useForkRef typings rejecting nullish (#25468) @eps1lon
- <!-- 54 --> [utils] Allow functional updates in TypeScript declaration of useControlled (#25378) @MikhailTSE
- <!-- 28 --> [utils] Add a new integer propType (#25224) @fayzzzm

### Docs

- <!-- 56 --> [docs] Fix typo in migration-v4.md (#25384) @Tollwood
- <!-- 86 --> [docs] Use defaultCodeOpen where appropriate (#25418) @eps1lon
- <!-- 84 --> [docs] Support RTL with styled components (#25457) @silver-snoopy
- <!-- 83 --> [docs] Improve the docs of the Grid component (#25429) @oliviertassinari
- <!-- 80 --> [docs] Migrate Switch demos to emotion (#25366) @vicasas
- <!-- 78 --> [docs] Use Stack in demos (#25419) @vicasas
- <!-- 69 --> [docs] Migrate Checkbox demos to emotion (#25394) @vicasas
- <!-- 67 --> [docs] Migrate Radio demos to emotion (#25396) @vicasas
- <!-- 66 --> [docs] Update icon link to fonts.google.com (#25410) @BGehrels
- <!-- 60 --> [docs] Migrate Avatar demos to emotion (#25375) @vicasas
- <!-- 57 --> [docs] Fix multiline textfields docs to use minRows/maxRows (#25383) @saleebm
- <!-- 55 --> [docs] Consolidate environment variables into next.config (#25386) @eps1lon
- <!-- 52 --> [docs] Use `env` next config over DefinePlugin (#25373) @eps1lon
- <!-- 49 --> [docs] Migrate SpeedDial to emotion (#25367) @vicasas
- <!-- 46 --> [docs] Refine the used prop-type to discriminate number from integer (#25334) @fayzzzm
- <!-- 45 --> [docs] Migrate AppBar demos to emotion (#25335) @m4theushw
- <!-- 44 --> [docs] Migrate Grid demos to emotion (#25332) @vicasas
- <!-- 42 --> [docs] Migrate Toggle Button demos to emotion (#25333) @vicasas
- <!-- 41 --> [docs] Migrate Links demos to emotion (#25303) @vicasas
- <!-- 40 --> [docs] Migrate Breadcrumbs demos to emotion (#25302) @vicasas
- <!-- 34 --> [docs] Migrate Image List demos to emotion (#25301) @vicasas
- <!-- 33 --> [docs] Bring clarity about the IE 11 support policy: it's partial (#25262) @oliviertassinari
- <!-- 31 --> [docs] Add the new demo page for the data grid (#25284) @DanailH
- <!-- 23 --> [docs] Migrate List demos to emotion (#25266) @vicasas
- <!-- 21 --> [docs] Migrate Chip demos to emotion (#25268) @vicasas
- <!-- 20 --> [docs] Add missing props to *DatePicker API (#25254) @eps1lon
- <!-- 18 --> [docs] Improve accessibility of the basic menu demo (#25207) @ee0pdt
- <!-- 16 --> [docs] Migrate Fab demos to emotion (#25251) @vicasas
- <!-- 15 --> [docs] Migrate Rating demos to emotion (#25252) @vicasas
- <!-- 14 --> [docs] Migrate Transfer List demos to emotion (#25253) @vicasas
- <!-- 07 --> [docs] Remove dead generatePropTypeDescription method (#25188) @fayzzzm
- <!-- 06 --> [docs] Migrate Skeleton demos to emotion (#25212) @vicasas
- <!-- 05 --> [docs] Migrate Paper demos to emotion (#25213) @vicasas
- <!-- 03 --> [docs] Migrate Container demos to emotion (#25220) @vicasas
- <!-- 01 --> [docs] Add GlobalStyles API (#25191) @eps1lon

### Core

- <!-- 63 --> [benchmark] Set intended environment (#25402) @eps1lon
- <!-- 11 --> [core] Remove .propTypes when the props are empty (#25193) @eps1lon
- <!-- 91 --> [core] Fix allSettled usage (#25461) @eps1lon
- <!-- 87 --> [core] Switch to React 17 (#25416) @eps1lon
- <!-- 65 --> [core] Bump missed node versions (#25385) @eps1lon
- <!-- 39 --> [core] Batch small changes (#25330) @oliviertassinari
- <!-- 37 --> [core] Use Promise.allSettled over .all where appropriate (#25315) @eps1lon
- <!-- 92 --> [test] Use fixture terminology in e2e and visual regression tests (#25466) @eps1lon
- <!-- 89 --> [test] Create end-to-end testing CI job (#25405) @eps1lon
- <!-- 64 --> [test] Transpile more similar to prod bundle (#25406) @eps1lon
- <!-- 32 --> [test] Minor improvements to `describeConformance` (#25297) @eps1lon
- <!-- 12 --> [test] Fix warnings in the demos (#25140) @oliviertassinari
- <!-- 10 --> [test] Convert createClientRender to TypeScript (#25249) @eps1lon
- <!-- 09 --> [test] Increase ttp setup timeout (#25248) @eps1lon
- <!-- 02 --> [test] Improve typescript-to-proptypes test suite (#25209) @eps1lon

All contributors of this release in alphabetical order: @aheimlich, @AlfredoGJ, @BGehrels, @christiaan, @DanailH, @duongdev, @ee0pdt, @eps1lon, @fayzzzm, @heleg, @jansedlon, @jeferson-sb, @johnloven, @julihereu, @kayuapi, @LaneRamp, @m4theushw, @manziEric, @martinfrancois, @MikhailTSE, @natac13, @oliviertassinari, @praveenkumar-kalidass, @RTEYL, @saleebm, @silver-snoopy, @souporserious, @Tollwood, @tomasz-crozzroads, @tomasznguyen, @vedadeepta, @vicasas

## 5.0.0-alpha.27

<!-- generated comparing v5.0.0-alpha.26..next -->

_Mar 5, 2021_

Big thanks to the 12 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Convert 8 components to emotion (#25091, #25158, #25146, #25142, #25166) @natac13, @mngu, @m4theushw, @praveenkumar-kalidass.
- 📚 Convert 5 components demos to emotion (#25164, #25183, #25180, #25145, #25138) @vicasas
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.27`

- <!-- 16 --> [Autocomplete] Support readonly type for the options (#25155) @silver-snoopy
- <!-- 13 --> [Drawer] Migrate to emotion (#25091) @natac13
- <!-- 20 --> [LinearProgress] Migrate to emotion (#25158) @mngu
- <!-- 06 --> [Pagination] Migrate Pagination and PaginationItem to emotion (#25146) @mngu
- <!-- 21 --> [Radio] Migrate to emotion (#25152) @mngu
- <!-- 10 --> [Snackbar] Migrate to emotion (#25142) @m4theushw
- <!-- 25 --> [SpeedDial] Migrate to emotion (#25166) @m4theushw
- <!-- 12 --> [Stepper] Migrate StepConnector to emotion (#25092) @praveenkumar-kalidass
- <!-- 07 --> [styled] Fix override logic to support component without root (#25143) @niting143
- <!-- 08 --> [Table] Remove default role logic in TableCell (#25105) @silver-snoopy
- <!-- 27 --> [Table] Use primary cover over secondary for selected state (#25182) @beaudry
- <!-- 23 --> [theme] Fix styleOverrides with nested selectors (#25156) @ruppysuppy

### `@material-ui/system@5.0.0-alpha.27`

- <!-- 02 --> [system] Fix behavior of visuallyHidden when used with `sx` prop (#25110) @niting143

### `@material-ui/lab@5.0.0-alpha.27`

#### Breaking changes

- <!-- 18 --> [Pickers] Remove `dateAdapter` prop (#25162) @eps1lon

The prop didn't solve any important problem better than any of its alternatives do.

```diff
-<DatePicker dateAdapter={x} />
+<LocalizationProvider dateAdapter={x}>
+  <DatePicker />
+</LocalizationProvider>
```

#### Changes

- <!-- 19 --> [Pickers][internal] Use React.forwardRef instead of forwardedRef prop (#25173) @eps1lon

### `@material-ui/styles@5.0.0-alpha.27`

- <!-- 03 --> [styles] Use capitalize from utils (#25136) @eps1lon

### Docs

- <!-- 22 --> [docs] Migrate Bottom Navigation demos to emotion (#25180) @vicasas
- <!-- 09 --> [docs] Migrate Button demos to emotion (#25138) @vicasas
- <!-- 17 --> [docs] Migrate Divider demos to emotion (#25145) @vicasas
- <!-- 24 --> [docs] Migrate Pagination demos to emotion (#25183) @vicasas
- <!-- 26 --> [docs] Migrate Typography demos to emotion (#25164) @vicasas
- <!-- 11 --> [docs] Remove CircleCI from backers (#24801) @mbrookes
- <!-- 14 --> [docs] Update the used testing libraries (#25144) @oliviertassinari

### Core

- <!-- 01 --> [CHANGELOG] Better document breaking changes @oliviertassinari
- <!-- 05 --> [core] Modernize icons `builder:src` (#25137) @eps1lon
- <!-- 04 --> [core] Properly use BABEL_ENV test and development (#25139) @eps1lon
- <!-- 15 --> [test] Add (manual) visual regression test for icons (#25160) @eps1lon

All contributors of this release in alphabetical order: @beaudry, @eps1lon, @m4theushw, @mbrookes, @mngu, @natac13, @niting143, @oliviertassinari, @praveenkumar-kalidass, @ruppysuppy, @silver-snoopy, @vicasas

## 5.0.0-alpha.26

<!-- generated comparing v5.0.0-alpha.25..next -->

_Feb 27, 2021_

Big thanks to the 26 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Convert 11 components to emotion (#24696, #24631, #24857, #25048, #24693, #24663, #25007, #24688, #24665, #24878, #24571) @praveenkuma @natac13 @xs9627 @povilass @m4theushw @natac13 @natac13 @DanailH @duganbrett @duganbrett @praveenkumar-kalidass @vinyldarkscratch.
  75% of the components have been migrated so far, thanks to the help of the community.
- 🦴 Convert 4 components to the unstyled pattern (#24985, #24857, #24890, #24957) @povilass.
  This change doesn't introduce any breaking changes. Hence, most of the conversion effort will be done post v5-stable.
- 📚 Fix the generation of the API pages for the date pickers (#25101, #25100, #25086, #25089, #25085, #25084) @eps1lon.
  This is a follow-up effort after we have merged `material-ui-pickers`. The components are written in TypeScript which required us to upgrade our infra.
- 👌 Improve the Slider thumb and track animation (#24968) @remyoudemans.
  The thumb is now moving with a light transition between different values unless it's dragged.
  <img src="https://user-images.githubusercontent.com/3165635/109394906-b7405a00-7929-11eb-829a-3b5246c30c08.gif" width="412" height="110" />
- 💅 Convert 5 components with custom colors support (#25099, #25088) @mngu.
  This change makes it easier to leverage custom palettes
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@5.0.0-alpha.26`

#### Breaking changes

- <!-- 089 --> [Tabs] Change the default indicatorColor and textColor prop values to "primary" (#25063) @Dripcoding

  This is done to match the most common use cases with Material Design. You can restore the previous behavior with:

  ```diff
  -<Tabs />
  +<Tabs indicatorColor="primary" textColor="inherit" />
  ```

#### Changes

- <!-- 099 --> [AppBar][CircularProgress][LinearProgress] Support custom colors (#25099) @mngu
- <!-- 102 --> [Autocomplete] Prevent closing on no-option text click (#25103) @silver-snoopy
- <!-- 101 --> [Autocomplete] Fix ListboxComponent slot regression (#25102) @oliviertassinari
- <!-- 035 --> [Autocomplete] Fix the return type of AutocompleteGetTagProps (#24950) @joemaffei
- <!-- 029 --> [Autocomplete] Migrate to emotion (#24696) @natac13
- <!-- 091 --> [Button] Fix ripple stuck after displaying the context menu (#25004) @DanailH
- <!-- 082 --> [Button] Fix forward classes to ButtonBase (#25072) @praveenkumar-kalidass
- <!-- 034 --> [Chip] Normalize Material Design States (#24915) @oliviertassinari
- <!-- 031 --> [Chip] Fix focus-visible regression (#24906) @oliviertassinari
- <!-- 018 --> [CircularProgress] Make source easier to read (#24893) @oliviertassinari
- <!-- 053 --> [Menu] Migrate MenuItem to emotion (#24631) @xs9627
- <!-- 079 --> [Paper] Fix type support of overridable component (#25059) @mngu
- <!-- 051 --> [Skeleton] Fix global theme customization  (#24983) @glocore
- <!-- 067 --> [Slider] Improve thumb and track animation (#24968) @remyoudemans
- <!-- 009 --> [Slider] Fix override of event.target when preparing change events (#24782) @praveenkumar-kalidass
- <!-- 097 --> [Snackbar] Migrate SnackbarContent to emotion (#25048) @m4theushw
- <!-- 028 --> [SwipeableDrawer] Fix detection of native scroll container (#24903) @oliviertassinari
- <!-- 059 --> [Switch] Migrate to emotion (#24693) @natac13
- <!-- 050 --> [Switch] Update to follow current MD guidelines (#24954) @hxqlin
- <!-- 016 --> [Table] Migrate TableCell to emotion (#24663) @natac13
- <!-- 094 --> [TextField] Support custom color and size (#25088) @mngu
- <!-- 093 --> [TextField] Fix input adornment color (#25090) @manziEric
- <!-- 081 --> [TextField] Fix FilledInput AA contrast issue (#25046) @Dripcoding
- <!-- 072 --> [TextField] Migrate FormControlLabel to emotion (#25007) @DanailH
- <!-- 069 --> [TextField] Fix label wrap, display an ellipsis instead (#25012) @NekoApocalypse
- <!-- 052 --> [TextField] Migrate OutlinedInput to emotion (#24688) @duganbrett
- <!-- 048 --> [TextField] Fix focused={true} disabled={true} infinite render (#24961) @oliviertassinari
- <!-- 019 --> [TextField] Migrate FormLabel and InputLabel to emotion (#24665) @duganbrett
- <!-- 077 --> [theme] Update theme.palette.text.secondary to match the spec (#25060) @Dripcoding
- <!-- 058 --> [ToggleButton] Migrate ToggleButtonGroup to emotion (#24878) @praveenkumar-kalidass
- <!-- 098 --> [Tooltip] Migrate to emotion (#24571) @vinyldarkscratch

### `@material-ui/unstyled@5.0.0-alpha.26`

- <!-- 033 --> [Portal] Migrate to unstyled (#24890) @povilass
- <!-- 047 --> [TrapFocus] Migrate to unstyled (#24957) @povilass
- <!-- 060 --> [Backdrop] Migrate to unstyled (#24985) @povilass
- <!-- 078 --> [Modal] Migrate to emotion + unstyled (#24857) @povilass

### `@material-ui/lab@5.0.0-alpha.26`

- <!-- 071 --> [Pickers] Fix scroll-jump when opening with a selected value (#25010) @eps1lon
- <!-- 066 --> [Pickers] Rework keyboard navigation implementation (#24315) @eps1lon
- <!-- 065 --> [Pickers] Fix picker components not opening on click in React 17 (#24981) @eps1lon
- <!-- 013 --> [Pickers] Fix outdated link to PickersDay (#24883) @oliviertassinari

### `@material-ui/icons@5.0.0-alpha.26`

- <!-- 087 --> [icons] Synchronize icons (#25055) @eps1lon

  The icons were synchronized with https://material.io/resources/icons/. This change increases the number of supported icons from 1,349 to 1,781 per theme (we support 5 themes). The breaking changes:

  ```diff
  // AmpStories -> Download
  -AmpStories
  +Download
  -AmpStoriesOutlined
  +DownloadOutlined
  -AmpStoriesRounded
  +DownloadRounded
  -AmpStoriesSharp
  +DownloadSharp
  -AmpStoriesTwoTone
  +DownloadTwoTone
  // Outbond -> Outbound
  -Outbond
  +Outbound
  -OutbondOutlined
  +OutboundOutlined
  -OutbondRounded
  +OutboundRounded
  -OutbondSharp
  +OutboundSharp
  -OutbondTwoTone
  +OutboundTwoTone
  ```

  We are getting closer to the maximum number of icons our infrastructure can support. In the future, we might remove the least popular icons in favor of the most frequently used ones.

### `@material-ui/system@5.0.0-alpha.26`

- <!-- 057 --> [system] Fix gap, rowGap, columnGap, borderRadius reponsive support (#24994) @oliviertassinari

### `@material-ui/utils@5.0.0-alpha.26`

- <!-- 025 --> [utils] Fix isMuiElement types (#24936) @oliviertassinari

### Docs

- <!-- 100 --> [docs] Add DateRangePickerDay, PickersDay, PickersCalendarSkeleton, MontherPicker API (#25101) @eps1lon
- <!-- 096 --> [docs] Add DayPicker API (#25100) @eps1lon
- <!-- 095 --> [docs] Improve description of builderbook (#25086) @klyburke
- <!-- 092 --> [docs] Add API of ClockPicker (#25089) @eps1lon
- <!-- 090 --> [docs] Add API of *DateRangePicker components (#25085) @eps1lon
- <!-- 088 --> [docs] Add API of *DateTimePicker components (#25084) @eps1lon
- <!-- 084 --> [docs] Add graphql-starter to Example Projects (#25068) @koistya
- <!-- 083 --> [docs] Migrate Alert demos to emotion (#25074) @m4theushw
- <!-- 075 --> [docs] Add codesandbox example for styled-components (#25050) @jony89
- <!-- 056 --> [docs] Wrong link @oliviertassinari
- <!-- 049 --> [docs] Improve error message when GitHub API fail (#24976) @oliviertassinari
- <!-- 037 --> [docs] Separate simple and nested modal demos (#24938) @ydubinskyi
- <!-- 030 --> [docs] Remove under construction icons from DataGrid feature pages (#24946) @DanailH
- <!-- 020 --> [docs] Fix prefers-color-scheme switch (#24902) @oliviertassinari
- <!-- 001 --> [docs] Add yarn install step, safer @oliviertassinari
- <!-- 055 --> [examples] Fix code sandbox link GitHub branch (#24996) @kevbarns

### Core

- <!-- 086 --> [core] Prevent out-of-memory in test_types_next (#25079) @eps1lon
- <!-- 085 --> [core] Pin playwright image to known working version (#25080) @eps1lon
- <!-- 080 --> [core] Remove need to reinject backdrop (#25071) @oliviertassinari
- <!-- 074 --> [core] Batch small changes (#25015) @oliviertassinari
- <!-- 068 --> [core] More cleanup on Pickers code (#25020) @dborstelmann
- <!-- 063 --> [core] Allow running full pipeline with various React versions (#25005) @eps1lon
- <!-- 061 --> [core] Fix missing codecov report (#25006) @eps1lon
- <!-- 040 --> [core] Fix release:tag pushing to first push remote (#24960) @eps1lon
- <!-- 039 --> [core] Fix cache miss when using playwright docker images (#24942) @eps1lon
- <!-- 023 --> [core] Prevent out-of-memory when type-checking in CI (#24933) @eps1lon
- <!-- 022 --> [core] Disable page size tracking (#24932) @eps1lon
- <!-- 021 --> [core] Extract linting into separate CI job (#24930) @eps1lon
- <!-- 017 --> [core] Only clone props if needed (#24892) @oliviertassinari
- <!-- 015 --> [core] listChangedFiles returns an empty list with no changed files (#24879) @eps1lon
- <!-- 014 --> [core] Remove dead code in docs:dev (#24880) @oliviertassinari
- <!-- 012 --> [core] Fix a few stylelint error (#24885) @oliviertassinari
- <!-- 011 --> [core] Fix name of Safari target (#24881) @oliviertassinari
- <!-- 010 --> [core] Prefer return over throw in chainPropTypes (#24882) @oliviertassinari
- <!-- 006 --> [core] Support /r/issue-template back (#24870) @oliviertassinari
- <!-- 003 --> [core] Simplify xxxClasses types (#24736) @oliviertassinari
- <!-- 076 --> [test] Improve BrowserStack configuration (#25049) @oliviertassinari
- <!-- 073 --> [test] Track bundle size of unstyled components (#25047) @oliviertassinari
- <!-- 070 --> [test] Make `render` required with describeConformanceV5 (#25003) @oliviertassinari
- <!-- 064 --> [test] Move a11y tree exclusion to appropriate document (#24998) @eps1lon
- <!-- 062 --> [test] Test with ClickAwayListener mount on onClickCapture (#25001) @eps1lon
- <!-- 045 --> [test] Improve various timer related issues (#24963) @eps1lon
- <!-- 043 --> [test] Avoid Rate Limit Exceeded (#24931) @oliviertassinari
- <!-- 042 --> [test] Remove internal icons smoke test (#24969) @eps1lon
- <!-- 041 --> [test] Reduce compile time of test:karma in watchmode drastically (#24967) @eps1lon
- <!-- 038 --> [test] Dedupe missing act warnings for HoC (#24949) @eps1lon
- <!-- 036 --> [test] Consolidate on a single API (#24884) @oliviertassinari
- <!-- 027 --> [test] Update react next patch (#24934) @eps1lon
- <!-- 026 --> [test] Link CircleCI URL in BS (#24935) @oliviertassinari
- <!-- 024 --> [test] Run more tests at the same time (#24886) @oliviertassinari
- <!-- 008 --> [test] Dedupe missing act warnings by component name (#24871) @eps1lon
- <!-- 007 --> [test] Enable type-unaware versions of disabled typed-aware lint rules (#24873) @eps1lon
- <!-- 005 --> [test] Initial workspace definition (#24869) @eps1lon
- <!-- 004 --> [test] Add current behavior of focus during mount in Popper (#24863) @eps1lon
- <!-- 002 --> [test] Increase BrowserStack timeout to 6min (#24861) @oliviertassinari

All contributors of this release in alphabetical order: @DanailH, @dborstelmann, @Dripcoding, @duganbrett, @eps1lon, @glocore, @hxqlin, @joemaffei, @jony89, @kevbarns, @klyburke, @koistya, @m4theushw, @manziEric, @mngu, @natac13, @NekoApocalypse, @oliviertassinari, @povilass, @praveenkumar-kalidass, @remyoudemans, @silver-snoopy, @vinyldarkscratch, @xs9627, @ydubinskyi

## 5.0.0-alpha.25

<!-- generated comparing v5.0.0-alpha.24..next -->

_Feb 11, 2021_

Big thanks to the 30 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Convert 32 components to emotion. Around 64% of the components have been migrated so far, thanks to the help of the community. We aim to migrate them all before the end of Q1 2021.
  The podium of the most active community members in the migration 🏆:

  1. @natac13 x17
  2. @vicasas x5
  3. @kodai3 x4

- 📐 Add a subset of the system as flattened props on `Typography` (#24496) @mnajdova.
  Now, you can do:

  ```jsx
  <Typography padding={2} color="text.secondary" />
  ```

- 📅 Focus on the date pickers, 5 fixes and 3 docs improvements.
- 💅 Provide a new [`darkScrollbar()`](https://next.material-ui.com/components/css-baseline/#scrollbars) CSS utility to improve the native scrollbar in dark mode. The documentation uses it.

### `@material-ui/core@5.0.0-alpha.25`

#### Breaking changes

- Increase the minimum version of TypeScript supported from v3.2 to v3.5. (#24795) @petyosi

  We try to align with types released from [DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped) (i.e. packages published on npm under the `@types` namespace).
  We will not change the minimum supported version in a major version of Material-UI.
  However, we generally recommend to not use a TypeScript version older than the [lowest supported version of DefinitelyTyped](https://github.com/DefinitelyTyped/DefinitelyTyped#older-versions-of-typescript-33-and-earlier).

#### Changes

- <!-- 03 --> [ImageList] Migrate to emotion (#24615) @kodai3
- <!-- 04 --> [Dialog] Migrate DialogTitle to emotion (#24623) @vicasas
- <!-- 05 --> [TextField] Prepare removal of labelWidth prop (#24595) @oliviertassinari
- <!-- 08 --> [ImageList] Migrate ImageListItem to emotion (#24619) @kodai3
- <!-- 09 --> [Card] Migrate CardMedia to emotion (#24625) @natac13
- <!-- 10 --> [Card] Migrate CardHeader to emotion (#24626) @natac13
- <!-- 11 --> [TextField] Migrate FilledInput to emotion (#24634) @mnajdova
- <!-- 12 --> [Fab] Migrate to emotion (#24618) @natac13
- <!-- 14 --> [ClickAwayListener] Fix `children` and `onClickAway` types (#24565) @eps1lon
- <!-- 15 --> [List] Migrate ListItemIcon to emotion (#24630) @vicasas
- <!-- 17 --> [Card] Migrate CardActionArea to emotion (#24636) @natac13
- <!-- 18 --> [DataTable] Add example in docs for data table (#24428) @DanailH
- <!-- 19 --> [CircularProgress] Migrate to emotion (#24622) @natac13
- <!-- 20 --> [ImageList] Migrate ImageListItemBar to emotion (#24632) @kodai3
- <!-- 21 --> [TextField] Migrate Input component to emotion (#24638) @duganbrett
- <!-- 22 --> [Tab] Migrate to emotion (#24651) @natac13
- <!-- 24 --> [Table] Migrate to emotion (#24657) @natac13
- <!-- 25 --> [List] Migrate ListItemAvatar to emotion (#24656) @vicasas
- <!-- 26 --> [TextField] Migrate FormControl to emotion (#24659) @duganbrett
- <!-- 27 --> [Table] Migrate TableContainer to emotion (#24666) @natac13
- <!-- 28 --> [Tab] Migrate TabScrollButton to emotion (#24654) @natac13
- <!-- 29 --> [Card] Warn on raised + outlined (#24648) @sumarlidason
- <!-- 32 --> [TextField] Migrate FormHelperText to emotion (#24661) @duganbrett
- <!-- 33 --> [Dialog] Migrate DialogContent to emotion (#24670) @vicasas
- <!-- 36 --> [Typography] Add system props (#24496) @mnajdova
- <!-- 38 --> [Paper] Improve warning on invalid combinations of variant and elevation (#24667) @eps1lon
- <!-- 39 --> [Chip] Migrate to emotion (#24649) @natac13
- <!-- 41 --> [ToggleButton] Migrate to emotion (#24674) @natac13
- <!-- 42 --> [Step] Migrate to emotion (#24678) @natac13
- <!-- 45 --> [Link] Fix CSS prefix property casing with emotion (#24701) @idanrozin
- <!-- 50 --> [Card] Use the default elevation (#24733) @oliviertassinari
- <!-- 53 --> [Typography] Remove align inherit noise (#24717) @oliviertassinari
- <!-- 56 --> [Dialog] Convert role `none presentation` to `presentation` (#24500) @hallzac2
- <!-- 64 --> [TextField] Improve baseline alignment with start adornment (#24742) @praveenkumar-kalidass
- <!-- 65 --> [Popper] Fix usage of ownerDocument with anchorEl (#24753) @ruppysuppy
- <!-- 75 --> [Table] Migrate TableBody to emotion (#24703) @natac13
- <!-- 76 --> [Table] Migrate TableRow to emotion (#24687) @natac13
- <!-- 77 --> [TextField] Migrate FormGroup to emotion (#24685) @vicasas
- <!-- 82 --> [CssBaseline] Make dark mode scrollbar overrides an optional function (#24780) @dborstelmann
- <!-- 83 --> [ButtonGroup] Migrate ButtonGroup to emotion (#24775) @mirefly
- <!-- 87 --> [Checkbox] Migrate to emotion (#24702) @natac13
- <!-- 89 --> [Table] Migrate TableHead to emotion (#24686) @natac13
- <!-- 90 --> [Table] Migrate TableFooter to emotion (#24684) @natac13
- <!-- 92 --> [Skeleton] Migrate to emotion (#24652) @kodai3

### `@material-ui/system@5.0.0-alpha.25`

#### Breaking changes

- <!-- 78 --> [system] Use spacing unit in `gap`, `rowGap`, and `columnGap` (#24794) @ruppysuppy

  If you were using a number previously, you need to provide the value in `px` to bypass the new transformation with `theme.spacing`. The change was done for consistency with the Grid spacing prop and the other system spacing properties, e.g. `<Box padding={2}>`.

  ```diff
  <Box
  - gap={2}
  + gap="2px"
  >
  ```

### `@material-ui/styled-engine@5.0.0-alpha.25`

- <!-- 34 --> [styled-engine] Fix GlobalStyles not to throw when no theme is available (#24671) @mnajdova

### `@material-ui/types@5.0.0-alpha.25`

#### Breaking changes

- <!-- 91 --> [types] Rename the exported `Omit` type in `@material-ui/types`. (#24795) @petyosi
  The module is now called `DistributiveOmit`. The change removes the confusion with the built-in `Omit` helper introduced in TypeScript v3.5. The built-in `Omit`, while similar, is non-distributive. This leads to differences when applied to union types. [See this StackOverflow answer for further details](https://stackoverflow.com/a/57103940/1009797).

```diff
-import { Omit } from '@material-ui/types';
+import { DistributiveOmit } from '@material-ui/types';
```

#### Changes

- <!-- 61 --> [types] Remove implicit children from PropInjector (#24746) @eps1lon

### `@material-ui/lab@5.0.0-alpha.25`

- <!-- 02 --> [Pickers] Fix role attribute (#24621) @EkaterinaMozheiko
- <!-- 35 --> [Pickers] Fix `showTodayButton` not returning the current time (#24650) @anthonyraymond
- <!-- 44 --> [Pickers] Ensure components have a display name in DEV (#24676) @eps1lon
- <!-- 49 --> [Pickers] Fix more name inconsistencies (#24734) @oliviertassinari
- <!-- 54 --> [Pickers] Dismiss on clickaway when using the desktop variant (#24653) @eps1lon
- <!-- 69 --> [Pickers] Add missing periods at end of some descriptions (#24791) @fulin426
- <!-- 81 --> [Pickers] Enable YearPicker documentation (#24830) @oliviertassinari
- <!-- 88 --> [Pickers] Fix useState related console warnings in examples (#24848) @ydubinskyi

### Docs

- <!-- 06 --> [docs] Add sorting section (#24637) @dtassone
- <!-- 13 --> [docs] Include in docs directive to silence `eslint` erroneous warning (#24644) @silviot
- <!-- 23 --> [docs] Clarifying the documentation about Chip behavior (#24645) @KarimOurrai
- <!-- 30 --> [docs] Update Typography in migration guide (#24662) @mbrookes
- <!-- 37 --> [examples] Update examples to use StyledEngineProvider (#24489) @mnajdova
- <!-- 40 --> [docs] Add API documentation for *DatePicker components (#24655) @eps1lon
- <!-- 47 --> [docs] Add HoodieBees to sponsors (#24735) @mbrookes
- <!-- 48 --> [docs] Fix indent @oliviertassinari
- <!-- 55 --> [docs] Make <main> responsive to font size (#24531) @eps1lon
- <!-- 59 --> [docs] Follow similar demo pattern for date and time pickers (#24739) @eps1lon
- <!-- 66 --> [docs] Add information about local dev environment (#24771) @plug-n-play
- <!-- 67 --> [docs] Add tcespal to Showcase (#24793) @ArnaultNouvel
- <!-- 68 --> [docs] Fix CssBaseline typography description (#24802) @xiaoyu-tamu
- <!-- 70 --> [docs] Add 'playlist' synonym to 'menu' (#24754) @Lagicrus
- <!-- 71 --> [docs] Add more similar icons (#24799) @oliviertassinari
- <!-- 72 --> [docs] Fix typo in the error message generated by createMuiTheme (#24827) @mbrookes
- <!-- 73 --> [examples] Align more with the v5 recommended approach (#24798) @Tejaswiangotu123
- <!-- 74 --> [docs] Update ButtonGroup demos to match v5 (#24797) @SCollinA
- <!-- 84 --> [docs] Fix formatting of `mask` prop description (#24842) @eps1lon
- <!-- 92 --> [docs] Add read synonym to drafts (#24854) @Lagicrus

### Core

- <!-- 01 --> [core] Fix release:tag pushing to material-ui-docs (#24633) @eps1lon
- <!-- 16 --> [core] Fix `next` using stale pages (#24635) @eps1lon
- <!-- 31 --> [test] Skip JSDOM in style related conformance tests (#24668) @mnajdova
- <!-- 43 --> [test] Conformance to handle wrapped elements (#24679) @natac13
- <!-- 51 --> [core] Batch small changes (#24705) @oliviertassinari
- <!-- 52 --> [test] Run more tests in Strict Mode (#24646) @oliviertassinari
- <!-- 57 --> [test] Avoid visual flakiness (#24737) @oliviertassinari
- <!-- 60 --> [core] Remove deprecated SimplifiedPropsOf/Simplify types (#24750) @petyosi
- <!-- 62 --> [core] Disable type-checking of .propTypes (#24747) @eps1lon
- <!-- 63 --> [test] Allow setting react-dist-tag via pipeline parameter (#24755) @eps1lon
- <!-- 79 --> [test] Don't run dev CI for dependabot pushes (#24833) @eps1lon
- <!-- 80 --> [test] Isolate Tooltip tests more (#24834) @eps1lon
- <!-- 85 --> [test] Clear emotion cache between tests (#24837) @eps1lon
- <!-- 86 --> [core] Save/restore actual yarn cache folder (#24844) @eps1lon
- <!-- 91 --> [test] Increase timeout to 4000ms for screenshots (#24850) @oliviertassinari

All contributors of this release in alphabetical order: @anthonyraymond, @ArnaultNouvel, @DanailH, @dborstelmann, @dtassone, @duganbrett, @EkaterinaMozheiko, @eps1lon, @fulin426, @hallzac2, @idanrozin, @KarimOurrai, @kodai3, @Lagicrus, @mbrookes, @mirefly, @mnajdova, @natac13, @oliviertassinari, @petyosi, @plug-n-play, @praveenkumar-kalidass, @ruppysuppy, @SCollinA, @silviot, @sumarlidason, @Tejaswiangotu123, @vicasas, @xiaoyu-tamu, @ydubinskyi

## 5.0.0-alpha.24

<!-- generated comparing v5.0.0-alpha.23..next -->

_Jan 26, 2021_

Big thanks to the 23 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Convert 31 components to emotion. Around 40% of the components have been migrated so far thanks to the help of the community.
- 🐛 Fix two long-standing issues with the Grid. Solve the horizontal scrollbar as well as dimensions when nesting (#24332) @greguintow.
- 📚 Fix various display issues on API documentation pages (#24526, #24503, #24504. #24517, #24417).
- 📐 Add a subset of the system as flatten props on the CSS utility components (`Grid` and `Box` so far, `Typography` and `Stack` coming later) (#24485, #24499) @mnajdova.

  ```jsx
  <Box m={2}>
  ```

### `@material-ui/core@5.0.0-alpha.24`

- <!-- 85 --> [Dialog] Migrate DialogActions to emotion (#24613) @vicasas
- <!-- 84 --> [Toolbar] Migrate to emotion (#24567) @natac13
- <!-- 83 --> [Hidden] Fix unsupported props warning when sx prop is used (#24624) @mnajdova
- <!-- 82 --> [List] Migrate ListItemText to emotion (#24602) @natac13
- <!-- 80 --> [List] Migrate ListItemSecondaryAction to emotion (#24593) @xs9627
- <!-- 79 --> [BottomNavigation] Migrate to emotion (#24556) @vinyldarkscratch
- <!-- 77 --> [CardActions] Fix wrong classes export name (#24609) @mnajdova
- <!-- 76 --> [Card] Migrate CardContent to emotion (#24600) @vicasas
- <!-- 75 --> [Card] Migrate to emotion (#24597) @povilass
- <!-- 74 --> [TextField] Migrate InputBase to emotion (#24555) @duganbrett
- <!-- 73 --> [Accordion] Allow to disable gutter/spacing (#24532) @TimonPllkrn
- <!-- 72 --> [List] Migrate to emotion (#24560) @vinyldarkscratch
- <!-- 71 --> [Card] Migrate CardActions to emotion (#24604) @vicasas
- <!-- 69 --> [List] Migrate ListSubheader to emotion (#24561) @vinyldarkscratch
- <!-- 68 --> [Breadcrumbs] Migrate to emotion (#24522) @vinyldarkscratch
- <!-- 67 --> [Divider] Migrate to emotion (#24558) @vinyldarkscratch
- <!-- 66 --> [Switch] Migrate SwitchBase to emotion (#24552) @vinyldarkscratch
- <!-- 65 --> [Hidden] Migrate to emotion (#24544) @vinyldarkscratch
- <!-- 64 --> [List] Migrate ListItem to emotion (#24543) @xs9627
- <!-- 62 --> [TextField] Fix Google Translate zero-width space issue (#24563) @d3mp
- <!-- 61 --> [Table] Separate classes for different labels (#24568) @tonysepia
- <!-- 58 --> [Accordion] Migrate AccordionSummary to emotion (#24540) @vinyldarkscratch
- <!-- 57 --> [IconButton] Migrate to emotion (#24542) @vinyldarkscratch
- <!-- 54 --> [Accordion] Migrate AccordionActions to emotion (#24538) @vinyldarkscratch
- <!-- 53 --> [Accordion] Migrate AccordionDetails to emotion (#24539) @vinyldarkscratch
- <!-- 50 --> [Link] Migrate to emotion (#24529) @praveenkumar-kalidass
- <!-- 49 --> [Accordion] Migrate to emotion (#24518) @vinyldarkscratch
- <!-- 46 --> [Backdrop] Migrate to emotion (#24523) @vinyldarkscratch
- <!-- 39 --> [Grid] Add system props (#24499) @mnajdova
- <!-- 38 --> [Icon] Migrate to emotion (#24516) @vinyldarkscratch
- <!-- 36 --> [Collapse] Migrate to emotion (#24501) @vinyldarkscratch
- <!-- 33 --> [SvgIcon] Migrate to emotion (#24506) @oliviertassinari
- <!-- 32 --> [Avatar] Migrate AvatarGroup to emotion (#24452) @praveenkumar-kalidass
- <!-- 31 --> [Box] Add back system props (#24485) @mnajdova
- <!-- 30 --> [Alert] Migrate AlertTitle to emotion (#24448) @povilass
- <!-- 26 --> [Alert] Migrate to emotion (#24442) @kutnickclose
- <!-- 21 --> [l10n] Improve Hebrew translation (#24449) @eladmotola
- <!-- 19 --> [Checkbox][Switch] Document defaultChecked (#24446) @praveenkumar-kalidass
- <!-- 18 --> [AppBar] Migrate to emotion (#24439) @povilass
- <!-- 16 --> [l10n] Improve German translation (#24436) @lukaselmer
- <!-- 15 --> [Button][Badge] Support custom colors and sizes (#24408) @mnajdova
- <!-- 10 --> [Grid] Fix horizontal scrollbar and nested dimensions (#24332) @greguintow
- <!-- 07 --> [Grid] Migrate to emotion (#24395) @mnajdova
- <!-- 06 --> [Badge] Fix TS custom variants (#24407) @mnajdova

### `@material-ui/lab@5.0.0-alpha.24`

- <!-- 48 --> [DatePicker] Remove unnecessary wrapping dom node (#24533) @mxsph
- <!-- 12 --> [DateRangePicker] Remove variant prop override for Textfield (#24433) @praveenkumar-kalidass
- <!-- 03 --> [lab] Reflect draft pattern of picker value in implementation (#24367) @eps1lon

### `@material-ui/styled-engine@5.0.0-alpha.24`

- <!-- 13 --> [styled-engine] Rename StylesProvider to StyledEngineProvider (#24429) @mnajdova

### `@material-ui/system@5.0.0-alpha.24`

- <!-- 44 --> [system] Fix handling of null-ish values (#24530) @oliviertassinari

### `@material-ui/unstyled@5.0.0-alpha.24`

- <!-- 08 --> [unstyled] Convert composeClasses to TypeScript (#24396) @eps1lon

### `@material-ui/utils@5.0.0-alpha.24`

- <!-- 60 --> [utils] `useEventCallback` `args` defaults to `unknown[]` (#24564) @eps1lon
- <!-- 11 --> [utils] Fix requirePropFactory to merge validators (#24423) @mnajdova

### Docs

- <!-- 86 --> [examples] Patch preact example not working (#24616)
- <!-- 78 --> [docs] Add missing newline in component JSDoc (#24610) @eps1lon
- <!-- 70 --> [docs] Add API of picker components (#24497) @eps1lon
- <!-- 63 --> [examples] Add `locale` prop to the Nextjs Link component (#24596) @CyanoFresh
- <!-- 52 --> [docs] List required props first in /api/* (#24526) @eps1lon
- <!-- 45 --> [docs] Mention the system props when available in the API pages (#24503) @mnajdova
- <!-- 43 --> [docs] Improve system properties page (#24524) @mnajdova
- <!-- 42 --> [docs] Fix malformed component API description (#24504) @eps1lon
- <!-- 41 --> [docs] Fix ToC "Component name" fragment link on /api/* (#24517) @eps1lon
- <!-- 40 --> [docs] Fix ToC on /api pages linking to api-docs (#24515) @eps1lon
- <!-- 37 --> [docs] Add comment explaining specificity bump on Select (#24509) @KarimMokhtar
- <!-- 28 --> [docs] Compute spreadable from tests (#24490) @eps1lon
- <!-- 27 --> [docs] Fix label bug in stepper vertical demo (#24491) @artola
- <!-- 20 --> [docs] Update Divjoy URL (#24447) @mbrookes
- <!-- 17 --> [docs] Improve packages description (#24330) @oliviertassinari
- <!-- 14 --> [docs] Fix content-layout-shift (#24418) @oliviertassinari
- <!-- 09 --> [docs] Document default values of external props (#24417) @eps1lon
- <!-- 02 --> [docs] Update in-house ads (#24410) @mbrookes @ewldev

### Core

- <!-- 87 --> [core] Skip downloading browser binaries in codesandbox/ci (#24628) @eps1lon
- <!-- 81 --> [core] Batch small changes (#24599) @oliviertassinari
- <!-- 59 --> [test] Simplify DatePicker tests (#24545) @eps1lon
- <!-- 51 --> [core] Improve pseudo classes overrides error (#24535) @mnajdova
- <!-- 35 --> [core] Fix styleProps to always contain all props (#24505) @mnajdova
- <!-- 34 --> [test] Fix AvatarGroup failing test (#24512) @mnajdova
- <!-- 29 --> [pickers] Sort tests (#24481) @eps1lon
- <!-- 25 --> [test] Split tests in describeConformanceV5 to isolate them (#24479) @mnajdova
- <!-- 24 --> [core] Do not forward classes prop by default in experimentalStyled (#24451) @mnajdova
- <!-- 23 --> [core] Pass styleProps on all slots in the styled() components (#24454) @mnajdova
- <!-- 22 --> [core] Batch small changes (#24445) @oliviertassinari
- <!-- 01 --> [core] Normalize generating declaration files (#24411) @eps1lon

All contributors of this release in alphabetical order: @artola, @CyanoFresh, @d3mp, @duganbrett, @eladmotola, @eps1lon, @ewldev, @greguintow, @KarimMokhtar, @kutnickclose, @lukaselmer, @mbrookes, @mnajdova, @mxsph, @natac13, @oliviertassinari, @povilass, @praveenkumar-kalidass, @TimonPllkrn, @tonysepia, @vicasas, @vinyldarkscratch, @xs9627

## 5.0.0-alpha.23

###### _Jan 14, 2021_

Big thanks to the 15 contributors who made this release possible. Here are some highlights ✨:

- 📚 Only document public paths in module augmentation (#24267) @eps1lon
- 👩‍🎤 Migrate the Paper and CssBaseline to emotion (#24397, #24176) @povilass @mnajdova

  We have reached a point where we feel confident that the new approach should make it to v5 stable. An issue has been created to track the progress with the migration to emotion: #24405. Your contribution to this effort and the ones from the community are welcome 🙌.

- 📅 Various improvements on the date picker components (#24301, #24309, #24275, #24298, #24319) @m4theushw @eps1lon @huzaima @praveenkumar-kalidass
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.23`/`@material-ui/unstyled@v5.0.0-alpha.23`

- [Container] Fix disableGutters style not applied (#24284) @povilass
- [Paper] Migrate to emotion (#24397) @povilass
- [Slider] Allow mobile VO users to interact with Sliders (#23902) @CodySchaaf
- [SwipeableDrawer] Add bleeding demo (#24268) @vicasas
- [SwipeableDrawer] Fix overflow scroll computation logic (#24225) @yann120
- [Table] Fix "more than" translation in es-ES (#24356) @vicasas
- [TextField] Fix error color for form input with secondary color (#24290) @praveenkumar-kalidass
- [Button] Fix resolution of default props (#24253) @oliviertassinari

### `@material-ui/lab@v5.0.0-alpha.23`

#### Breaking changes

- [DateRangePicker] Remove DateRangDelimiter (#24298) @huzaima

  You can migrate away from it with:

  ```diff
  diff --git a/docs/src/pages/components/date-range-picker/BasicDateRangePicker.tsx b/docs/src/pages/components/date-range-picker/BasicDateRangePicker.tsx
  index 72a89f9a11..2742fa6811 100644
  --- a/docs/src/pages/components/date-range-picker/BasicDateRangePicker.tsx
  +++ b/docs/src/pages/components/date-range-picker/BasicDateRangePicker.tsx
  @@ -3,7 +3,7 @@ import TextField from '@material-ui/core/TextField';
  import DateRangePicker, { DateRange } from '@material-ui/lab/DateRangePicker';
  import AdapterDateFns from '@material-ui/lab/AdapterDateFns';
  import LocalizationProvider from '@material-ui/lab/LocalizationProvider';
  -import DateRangeDelimiter from '@material-ui/lab/DateRangeDelimiter';
  +import Box from '@material-ui/core/Box';

  export default function BasicDateRangePicker() {
    const [value, setValue] = React.useState<DateRange<Date>>([null, null]);
  @@ -20,7 +20,7 @@ export default function BasicDateRangePicker() {
          renderInput={(startProps, endProps) => (
            <React.Fragment>
              <TextField {...startProps} variant="standard" />
  -            <DateRangeDelimiter> to </DateRangeDelimiter>
  +            <Box sx={{ mx: 2 }}>to</Box>
              <TextField {...endProps} variant="standard" />
            </React.Fragment>
          )}
  ```

#### Changes

- [DatePicker] Fix out of range month selection (#24301) @m4theushw
- [DatePicker] Replace withDefaultProps with useThemeProps (#24309) @m4theushw
- [DatePicker] Simplify ExtendWrapper type (#24275) @eps1lon
- [DatePicker] Reduce coupling of parsing picker input value and props (#24319) @eps1lon
- [TimePicker] Add pointer cursor for clock in desktop (#24276) @praveenkumar-kalidass
- [lab] Drop usage of createStyles (#24158) @eps1lon
- [lab] Fix import paths in generated declaration files (#24380) @eps1lon
- [lab] Prevent possible null pointer in useValidation (#24318) @eps1lon

### `@material-ui/styled-engine@v5.0.0-alpha.23`/`@material-ui/styled-engine-sc@v5.0.0-alpha.23`

- [styled-engine] Add `GlobalStyles` component (#24176) @mnajdova

### Docs

- [docs] Add example perfomance Stepper vertical (#24292) @vicasas
- [docs] Change Link example from JS to TS (#24291) @vicasas
- [docs] Do not show 'Add' if user input matches existing option (#24333) @ramdog
- [docs] Focus docs search input when the shortcut is clicked (#24296) @eps1lon
- [docs] Further template the CSS API descriptions (#24360) @mbrookes
- [docs] Improve Next.js Link integration (#24258) @oliviertassinari
- [docs] Misc API fixes (#24357) @mbrookes
- [docs] Prevent kbd to wrap (#24269) @oliviertassinari
- [docs] Simplify icon button docs (#24317) @baharalidurrani
- [docs] Standardize some API descriptions (#24274) @mbrookes
- [docs] Sync AppSearch.tsx with AppSearch.js (#24363) @Lagicrus
- [docs] Update CONTRIBUTING being accepted (#24306) @vicasas
- [docs] Update right to left compatibility plugin version (#24370) @mnajdova
- [docs] Widen example datetime-local picker so it's not clipped (#24324) @ramdog
- [website] Add BrandingFooter (#24095) @mnajdova
- [website] Add Discover more (#24327) @oliviertassinari
- [website] Add newsletter (#24322) @oliviertassinari
- [website] Fix regressions @oliviertassinari
- [website] Improve typography theme (#24386) @oliviertassinari

### Core

- [core] Create issue labeled (#24283) @xrkffgg
- [core] Fix eslint @oliviertassinari
- [core] Skip downloading browser binaries when building docs (#24393) @eps1lon
- [core] Small changes (#24329) @oliviertassinari
- [core] Support public paths in module augmentation (#24267) @eps1lon
- [core] Update classes generation logic (#24371) @mnajdova
- [core] Update issue mark duplicate (#24311) @xrkffgg
- [core] Update issues helper version (#24379) @xrkffgg
- [test] Add pipeline task for performance monitoring (#24289) @eps1lon
- [test] Compensate for Circle CI's low performance (#24358) @oliviertassinari
- [test] Debug expensive GH actions still runing for l10nbot (#24392) @eps1lon
- [test] Move callback args to right side of assertion (#24366) @eps1lon
- [test] Persist new declaration files in CI cache (#24313) @eps1lon
- [test] Reduce download times of playwright binaries (#24364) @eps1lon
- [test] Skip expensive GitHub actions on l10nbot commits (#24303) @eps1lon
- [test] Test declaration files in TS nightly (#24391) @eps1lon
- [styles] Define useThemeProps as unstable and fix TS issues (#24383) @mnajdova

## 5.0.0-alpha.22

###### _Jan 4, 2021_

Big thanks to the 14 contributors who made this release possible. Here are some highlights ✨:

- ♿️ Fix major accessibility issue with the Autocomplete (#24213) @inform880
- 👩‍🎤 Migrate the Container to emotion (#24227) @oliviertassinari
- 🐛 Fix Next.js regression and other cross-platform issues with the build (#24200, #24223)
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.22`/`@material-ui/unstyled@v5.0.0-alpha.22`

- [Autocomplete] Fix VoiceOver not reading the correct activedescendant (#24213) @inform880
- [Autocomplete] Warn when value is invalid (#24202) @Sandeep0695
- [Button] Fix disableElevation regression (#24251) @oliviertassinari
- [Container] Migrate to emotion (#24227) @oliviertassinari
- [Pagination] Fix className forwarding when type is ellipsis (#24256) @andrelmlins
- [Select] Improve description on how it extends the Input components (#24180) @azza85
- [styled] Fix missing types for `sx` (#24211) @mnajdova
- [styled] Remove unused type parameters from StyledOptions (#24255) @eps1lon
- [styled] Support components without theme (#24214) @mnajdova
- [styles] Fix classes logic (#24250) @oliviertassinari
- [styles] Improve the classes structure (#24249) @oliviertassinari

### `@material-ui/lab@v5.0.0-alpha.22`

- [DatePicker] Fix year only view, hide the current month (#24205) @hyeonhong
- [DatePicker] Nested imports for better DX (#24147) @oliviertassinari
- [DatePicker] Remove unused type parameters (#24257) @eps1lon
- [TimePicker] Prevent conflicting type parameter in `ClockProps#getClockLabelText` (#24193) @eps1lon

### Docs

- [docs] Accept pages written in TypeScript (#24230) @oliviertassinari
- [docs] Document emotion migration breaking changes (#24229) @luminaxster
- [docs] Fix broken benchmark link (#24210) @jalaj-k
- [docs] Fix codesandbox datagrid demo (#24218) @brno32
- [docs] Fix iframe demos with emotion (#24232) @oliviertassinari
- [docs] Sync translations (#24161) @l10nbot

### Core

- [test] More granular progress tracking of relative type imports (#24233) @eps1lon
- [core] Add missing sx typings on the components migrated to emotion (#24208) @mnajdova
- [core] Batch small changes (#24224) @oliviertassinari
- [core] Create issue mark duplicate (#24184) @xrkffgg
- [core] Fix generation of package.json (#24223) @oliviertassinari
- [core] Fix relative import of types (#24248) @oliviertassinari
- [core] Platform agnostic build script for envinfo (#24200) @eps1lon
- [core] Remove unused generics from experimentalStyled (#24192) @eps1lon

## 5.0.0-alpha.21

###### _Dec 30, 2020_

Big thanks to the 14 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Migrate the Avatar to emotion (#24114) @oliviertassinari
- 👩‍🎤 Migrate the Button to emotion (#24107, #24100) @mnajdova
- ♿️ Improve TrapFocus behavior, ignore the container as a tabbable element (#23364) @gregnb
  In rare cases, an element might not longer be tabbable when looping, e.g. overflow container in Firefox.
  You can work around the problem by adding a `tabIndex={0}` or customizing the `getTabbable` prop.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.21`/`@material-ui/unstyled@v5.0.0-alpha.21`

- [Avatar] Migrate to emotion (#24114) @oliviertassinari
- [ButtonBase] Migrate styles to emotion (#24100) @mnajdova
- [Button] Migrate styles to emotion (#24107) @mnajdova
- [unstyled] Add utils for generating utility classes (#24126) @mnajdova
- [TrapFocus] Fix trap to only focus on tabbable elements (#23364) @gregnb
- [Link] Improve integration with Next.js (#24121) @kelvinsanchez15
- [Select] Fix overflow showing scrollbar (#24085) @Segebre
- [Slider] Fix circular type reference in SliderValueLabel (#24190) @eps1lon
- [Skeleton] Fix default TypeScript component type (#24191) @eps1lon

### `@material-ui/system@v5.0.0-alpha.21`

- [system] Fix sx prop typings to support grid gap props (#24093) @mnajdova
- [system] Improve the SxProp typings structure, by splitting them in a separate module. (#24090) @mnajdova
- [system] Replace grid gap properties (#24094) @mnajdova

### `@material-ui/lab@v5.0.0-alpha.21`

- [DatePicker] Allow to customize icons (#24017) @jackcwu
- [DatePicker] Fix missing component for theme augmentation (#24092) @rajzik
- [DatePicker] Hide outline on container (#24108) @oliviertassinari
- [DatePicker] Fix accessibility issue with heading (#24183) @gracektay
- [TimePicker] Improve the design to fit on smaller screens (#23855) @marianayap
- [TreeView] Add preventScroll for tree focus (#24105) @praveenkumar-kalidass

### `@material-ui/styles@v5.0.0-alpha.21`

- [styles] Fix for supporting non string props in propsToClassKey (#24101) @mnajdova

### `@material-ui/styled-engine@v5.0.0-alpha.21`/`@material-ui/styled-engine-sc@v5.0.0-alpha.21`

- [styled-engine] Fix StylesProvider injectFirst with sc (#24104) @mnajdova

### Docs

- [docs] Add examples for adding and removing Typography variants (#24088) @mnajdova
- [docs] Fix typo (#24123) @ajonp
- [docs] Fix warning about wrong prop type (#24117) @mnajdova
- [docs] Rename "Customization > Theme > Global" to "Customization > Theme > Components" (#24115) @mnajdova
- [docs] Rename customization/components to customization/how-to-customize (#24089) @mnajdova
- [docs] Replace process.browser with typeof navigator (#24122) @softshipper
- [docs] Sync translations (#24152) @l10nbot
- [docs] Update Fontsource install instructions (#24120) @DecliningLotus
- [docs] Add system grid page (#24119) @mnajdova
- [blog] 2020 in review and beyond (#24130) @oliviertassinari
- [docs] Improve naming and structure of the Customization and Guide pages (#24175) @mnajdova

### Core

- [core] Batch small changes (#24131) @oliviertassinari
- [core] Fix overridesResolver on the core components and added tests (#24125) @mnajdova
- [core] Reduce number of files included in language server (#24165) @eps1lon
- [core] Reduce response time of initial PR bot comment (#24168) @eps1lon
- [core] Refactor styled() components to ease out the migration process (#24124) @mnajdova
- [test] Add more packages to browser test suite (#24155) @eps1lon
- [core] Monitor progress of fixing type imports (#24188) @eps1lon
- [core] Fix build on Windows (#24187) @oliviertassinari

## 5.0.0-alpha.20

###### _Dec 21, 2020_

Big thanks to the 13 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Migrate the Typography to emotion (#23841) @DanailH

  This change allows to add typography variants in the theme and to use them directly:

  ```jsx
  const theme = createMuiTheme({
    typography: {
      poster: {
        color: 'red',
      },
    },
  });
  <Typography variant="poster">poster</Typography>;
  ```

  [A full demo](https://codesandbox.io/s/fontsizetheme-material-demo-forked-l9u05?file=/demo.tsx:725-773)

- 📚 Add a shortcut to open the Algolia search (#23959) @hmaddisb.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.20`/`@material-ui/unstyled@v5.0.0-alpha.20`

#### Breaking changes

- [CssBaseline] Change body font size to body1 (1rem) (#24018) @mbrookes

  The new default matches the variant used by the Typography component. To return to the previous size, you can override it in the theme:

  ```js
  const theme = createMuiTheme({
    typography: {
      body1: {
        fontSize: '0.875rem',
      },
    },
  });
  ```

#### Changes

- [Badge] Fix the classes description to reflect the correct component (#24035) @mnajdova
- [Select] Fix aria-describedby attribute (#24027) @HVish
- [Skeleton] Fix Circle border radius on Safari (#24054) @anatolzak
- [Slider][badge] Fix classes prop not working (#24034) @mnajdova
- [Typography] Migrate styles to emotion (#23841) @DanailH

### `@material-ui/styled-engine@v5.0.0-alpha.20`/`@material-ui/styled-engine-sc@v5.0.0-alpha.20`

- [styled-engine] Add name and slot options (#23964) @mnajdova
- [styled-engine] Add StylesProvider with injectFirst option (#23934) @mnajdova

### `@material-ui/system@v5.0.0-alpha.20`

- [system] Fix transform not firing when theme provided (#24010) @ZovcIfzm

### Docs

- [docs] Add a shortcut to access the search bar (#23959) @hmaddisb
- [docs] Animate component's mounting and unmounting (#24049) @cjoecker
- [docs] Fix collapse API docs description of 'hidden' style condition (#24053) @jaiwanth-v
- [docs] Improve color demo snippet spacing (#24009) @yukinoda
- [docs] Improve displayed versions (#24051) @oliviertassinari
- [docs] Show a better file on codesandbox (#24052) @oliviertassinari
- [docs] Update customization/components and customization/global pages (#24016) @mnajdova
- [docs] Update the CSS injection guide (#24020) @mnajdova

### Core

- [core] Batch small changes (#24038) @oliviertassinari
- [core] Track size of /unstyled (#24021) @eps1lon
- [core] Use consistent naming scheme for ttp annotations (#24022) @eps1lon

## 5.0.0-alpha.19

###### _Dec 13, 2020_

Big thanks to the 24 contributors who made this release possible. Here are some highlights ✨:

- 👩‍🎤 Migrate the Badge to emotion (#23745) @mnajdova.
- 🌏 Add infrastructure to translate the API pages (#23852) @mbrookes.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.19`

#### Breaking changes

- [Icon][svgicon] Change default fontSize from default to medium (#23950) @mbrookes

  The default value of `fontSize` was changed from `default` to `medium` for consistency.
  In the unlikey event that you were using the value `default`, the prop can be removed:

  ```diff
  -<SvgIcon fontSize="default">{iconPath}</SvgIcon>
  +<SvgIcon>{iconPath}</SvgIcon>
  ```

- [TextField] Add size prop for outlined and filled input (#23832) @mayralgr

  Rename `marginDense` and `inputMarginDense` classes to `sizeSmall` and `inputSizeSmall` to match the prop.

#### Changes

- [Autocomplete] Document onChange last `details` param (#23942) @natac13
- [Autocomplete] Fix useAutocomplete groupedOptions type (#23854) @ZachCMP
- [Autocomplete] Improve DX/UX when getOptionLabel is not configured correctly (#23884) @marianayap
- [Autocomplete] Improve getOptionSelected description (#23817) @smartshivkat
- [Badge] Create unstyled component & move to emotion (#23745) @mnajdova
- [Grid] Improve support for nested grid (#23913) @gbrochar
- [Grid] Fix side effects when direction="column" and xs={} is used (#23900) @Kai-W
- [Select] Fix description, value is not required (#23940) @natac13
- [Slider] Remove color prop in unstyled (#23840) @mnajdova
- [Slider] Replaced inlined isHostComponent with the utils (#23880) @mnajdova
- [SwipeableDrawer] Refactor internals (#23944) @eps1lon
- [TextField] Add documentation for hidden label (#23915) @Fredestrik
- [TextField] Fix the color leak of the textbox (#23912) @szabgab
- [useMediaQuery] Fix a false return at the first call (#23806) @marthaerm
- [utils] Fix minified errors throwing with \_formatMuiErrorMessage (#23828) @eps1lon

### `@material-ui/unstyled@v5.0.0-alpha.19`

- [core] Use Lerna to publish (#23793) @oliviertassinari

### `@material-ui/system@v5.0.0-alpha.19`

#### Breaking changes

- [system] Move visually hidden helper to utils (#23974) @eps1lon

  Only applies if you've installed v5.0.0-alpha.1

  ```diff
  -import { visuallyHidden } from '@material-ui/system';
  +import { visuallyHidden } from '@material-ui/utils';
  ```

#### Changes

- [core] Use Lerna to publish (#23793) @oliviertassinari

### `@material-ui/lab@v5.0.0-alpha.19`

- [core] Use Lerna to publish (#23793) @oliviertassinari

### `@material-ui/utils@v5.0.0-alpha.19`

- [core] Use Lerna to publish (#23793) @oliviertassinari

### `@material-ui/styles@v5.0.0-alpha.19`

- [core] Use Lerna to publish (#23793) @oliviertassinari

### Docs

- [example] Change Box to new sx prop (#23937) @natac13
- [example] Explain package choice (#23938, #23958) @mnajdova
- [example] Update nextjs examples to fix hydration (#23936) @mnajdova
- [docs] Add API tradeoff section for the sx prop (#23962) @mnajdova
- [docs] Add ELEVATOR to backers (#23977) @mbrookes
- [docs] Add eslint rule to docs (#23843) @jens-ox
- [docs] Add infrastructure to translate API pages (#23852) @mbrookes
- [docs] Add link to the sx docs page in the API description (#23967) @mnajdova
- [docs] Add prepend option on emotion caches to allow JSS style overrides (#23892) @mnajdova
- [docs] Add Vercel deploy config (#23910) @eps1lon
- [docs] Allow codesandbox deploy for demos in X (#23644) @oliviertassinari
- [docs] Copy icons to clipboard (#23850) @CodeWithGuruji
- [docs] Fix breakpoints typos (#23893) @mnajdova
- [docs] Fix color contrast of code within links (#23819) @eps1lon
- [docs] Fix duplicated styles generated from emotion (#23809) @mnajdova
- [docs] Fix icon alignment in /components/breadcrumbs (#23818) @eps1lon
- [docs] Fix production deploy (#23963) @eps1lon
- [docs] Fix source on Github links (#23821) @praveenkumar-kalidass
- [docs] Fix StickyHeaderTable round borders (#23882) @antoniopacheco
- [docs] Fix typo in date picker dayjs adapter name (#23935) @andresmrm
- [docs] Improve system properties page (#23961) @mnajdova
- [docs] Link module augmentation in TypeScript @oliviertassinari
- [docs] Make stable width of localization example (#23820) @sujinleeme
- [docs] Mention Adobe XD (#23978) @oliviertassinari
- [docs] Prefer system shorthands (#23970) @oliviertassinari
- [docs] Remove 'TODO' comment from buildApi script (#23973) @mbrookes
- [docs] Sync translations (#23742, #23842) @l10nbot
- [docs] Update Badge examples to use Box instead of makeStyles (#23927) @mnajdova

### Core

- [test] Add conformance tests for testing the `theme.components` options for the v5 components (#23896) @mnajdova
- [test] Include type path mappings in language server (#23905) @eps1lon
- [test] Make Popper tests StrictMode agnostic (#23838) @eps1lon
- [test] Run benchmarks in Azure Pipelines when approved (#23895) @eps1lon
- [test] Skip tests with cascading network requests (#23823) @eps1lon
- [core] All packages are published from /build (#23886) @oliviertassinari
- [core] Batch small changes (#23853) @oliviertassinari
- [core] Fix failing CI on HEAD (#23947) @oliviertassinari
- [core] Force LF for text files (#23932) @eps1lon
- [core] Improve envinfo instructions (#23918) @eps1lon
- [core] Replace fs-extra deprecated function (exists) (#23848) @leonardopliski
- [core] Use Lerna to publish (#23793) @oliviertassinari
- [core] Use playwright instead of puppeteer (#23906) @eps1lon
- [core] Add envinfo --json flag (#23883) @eps1lon
- [core] Ask for output from envinfo in issues (#23881) @eps1lon

## 5.0.0-alpha.18

###### _Dec 3, 2020_

Big thanks to the 17 contributors who made this release possible. Here are some highlights ✨:

- Fix most of the issues with the system (#23716, #23635, #23737, #23733, #23700, #23688) @mnajdova.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.18`

#### Breaking changes

- [Box] Remove deprecated props (#23716) @mnajdova
  All props are now available under the `sx` prop. A deprecation will be landing in v4.
  Thanks to @mbrookes developers can automate the migration with a [codemod](https://github.com/mui-org/material-ui/blob/next/packages/material-ui-codemod/README.md#box-sx-prop).

  ```diff
  -<Box p={2} bgColor="primary.main">
  +<Box sx={{ p: 2, bgColor: 'primary.main' }}>
  ```

#### Changes

- [Autocomplete] Add ability to override key down events handlers (#23487) @hessaam
- [Autocomplete] Better isolate test case (#23704) @oliviertassinari
- [Autocomplete] Fix highlight change event (#23718) @TakumaKira
- [Box] Fix TypeScript issue when component prop is used (#23686) @mnajdova
- [experimentalStyled] Make sx style fn optional (#23714) @mnajdova
- [l10n] Improve Brazilian (pt-BR) locale (#23707) @m4rcelofs
- [l10n] Improve Korean (ko-KR) locale (#23794) @sujinleeme
- [Select] Add disabled attribute in input element when disabled (#23778) @praveenkumar-kalidass
- [Switch] Add preventDefault check for state change (#23786) @praveenkumar-kalidass
- [Tabs] Remove duplicate styles (#23561) @cmfcmf

### `@material-ui/system@v5.0.0-alpha.18`

- [system] Allow values to use shorter string when the prop name is contained in the value (#23635) @mnajdova
- [system] Another round of perf improvements (#23737) @mnajdova
- [system] Fix transform return value to support CSSObject (#23733) @mnajdova
- [system] Make borderRadius multiply a theme's design token (#23700) @mnajdova
- [system] Various perf gain experiments (#23688) @mnajdova

### `@material-ui/styles@v5.0.0-alpha.18`

- [styles] Small performance gain (#23749) @oliviertassinari
- [styles] Update mergeClasses types to more closely match its implementation (#23705) @etrepum

### `@material-ui/utils@v5.0.0-alpha.18`

- [system] Another round of perf improvements (#23737) @mnajdova

### `@material-ui/lab@v5.0.0-alpha.18`

- [DatePicker] Found one prop that was renamed (#23676) @oliviertassinari
- [DateRangePicker] Allow same date selection (#23701) @hmaddisb

### `@material-ui/styled-engine@v5.0.0-alpha.18`/`@material-ui/styled-engine-sc@v5.0.0-alpha.18`

- [styled-engine] Fix tagged template syntax with multiple expressions (#23269) @eps1lon

### Docs

- [docs] Add settings panel to allow system mode (#23722) @mbrookes
- [docs] Add v5 peer dependencies in README (#23751) @johnrichardrinehart
- [docs] Document using codesandbox-ci (#23800) @brorlarsnicklas
- [docs] Fix link name for canadacasino (#23799) @eps1lon
- [docs] Fix various a11y issues reported by lighthouse (#23791) @eps1lon
- [docs] Improve prop descriptions (#23723) @oliviertassinari
- [docs] Improve SEO structure (#23748) @oliviertassinari
- [docs] Improve settings toggle button styling (#23754) @mbrookes
- [docs] Misc fixes (#23756) @mbrookes
- [docs] Move instructions for starting the docs earlier in the file (#23801) @brorlarsnicklas
- [docs] Prepare v5.0.0-alpha.17 (#23680) @oliviertassinari
- [docs] Remove unused abstraction (#23724) @oliviertassinari
- [docs] Sync translations (#23682) @l10nbot

### Core

- [benchmark] Improve printed results (#23729) @oliviertassinari
- [benchmark] Test styleFunctionSx vs. @styled-system/css (#23702) @mnajdova
- [benchmark] Update with latest (#23694) @oliviertassinari
- [core] Batch small changes (#23678) @oliviertassinari
- [core] Fix ci @oliviertassinari
- [core] Fix error handling on upload (#23734) @eps1lon
- [core] Fully clear composite TypeScript project state (#23805) @eps1lon
- [core] Remove unused classes (#23473) @jens-ox
- [test] Add conformance test suite for v5 (#23798) @mnajdova
- [test] Cleanup skipped tests (#23732) @eps1lon
- [test] Misc improvements to experimental and browser test runner (#23699) @eps1lon
- [test] Stay busy until document.fonts is ready (#23736) @eps1lon

## 5.0.0-alpha.17

###### _Nov 23, 2020_

Big thanks to the 18 contributors who made this release possible. Here are some highlights ✨:

- 📚 Improve the IntelliSense support for the `sx` prop (#23599) @mnajdova.
  You should now get a description for each property of the system. For instance with `mx`:

  ![system TypeScript](https://user-images.githubusercontent.com/3165635/99920493-20f60a00-2d24-11eb-8748-c5dd7fe85cbd.png)

- 💅 Migrate the first core component to the v5 styling architecture (#23308) @mnajdova.
  We have spent the last few months iterating on the new styling approach in the lab, and are confident enough in the new approach to move it to the core, so we have migrated the Slider. We will wait a week or two to collect feedback on it, before scaling it to the rest of the codebase.
- 📅 Fix the first few issues on the date picker components since the migration in the lab.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.17`

#### Breaking changes

- [Slider] Migrate to emotion (#23308) @mnajdova

  By default, emotion injects its style after JSS, this breaks the computed styles. In order to get the correct CSS injection order until all the components are migrated, you need to wrap the root of your application with:

  ```jsx
  import * as React from 'react';
  import ReactDOM from 'react-dom';
  import { StylesProvider } from '@material-ui/core';
  import App from './App';

  ReactDOM.render(
    <StylesProvider injectFirst>
      <App />
    </StylesProvider>,
    document.querySelector('#root'),
  );
  ```

  This enforces emotion being injected first. [More details](https://next.material-ui.com/guides/interoperability/#css-injection-order) in the documentation.

- [Autocomplete] Rename `closeIcon` prop with `clearIcon` to avoid confusion (#23617) @akhilmhdh.

  ```diff
  -<Autocomplete closeIcon={icon} />
  +<Autocomplete clearIcon={icon} />
  ```

- [Dialog] Remove the `disableBackdropClick` prop. It's redundant with the `reason` argument (#23607) @eps1lon.

  ```diff
  <Dialog
  - disableBackdropClick
  - onClose={handleClose}
  + onClose={(event, reason) => {
  +   if (reason !== 'backdropClick') {
  +     onClose(event, reason);
  +   }
  + }}
  />
  ```

- [Modal] Remove the `disableBackdropClick` prop. It's redundant with the `reason` argument (#23607) @eps1lon.

  ```diff
  <Modal
  - disableBackdropClick
  - onClose={handleClose}
  + onClose={(event, reason) => {
  +   if (reason !== 'backdropClick') {
  +     onClose(event, reason);
  +   }
  + }}
  />
  ```

- [Modal] Remove the `onEscapeKeyDown` prop. It's redundant with the `reason` argument. (#23571) @eps1lon

  ```diff
  <Modal
  -  onEscapeKeyDown={handleEscapeKeyDown}
  +  onClose={(event, reason) => {
  +    if (reason === "escapeKeyDown") {
  +      handleEscapeKeyDown(event);
  +    }
  +  }}
  />;
  ```

#### Changes

- [CircularProgress][linearprogress] Change components from div to span (#23587) @bruno-azzi
- [Grid] Improve warning when a prop is missing (#23630) @udayRedI
- [Icon] Allow customizing the 'material-icons' base class name (#23613) @rart
- [Select] Fix focus() call on ref (#23302) @reedanders
- [Slider] Add test case for triggering a specific value (#23642) @Thehambalamba
- [Slider] General cleanup and add classes prop for unstyled (#23569) @mnajdova
- [styles] Add support for TypeScript 4.1 (#23633) @eps1lon

### `@material-ui/codemod@v5.0.0-alpha.17`

- [codemod] Add moved-lab-modules (#23588) @eps1lon
  This codemod is part of our effort to make the migration from v4 to v5 as painless as possible.

### `@material-ui/utils@v5.0.0-alpha.17`

- [Grid] Improve warning when a prop is missing (#23630) @udayRedI

### `@material-ui/system@v5.0.0-alpha.17`

- [system] Improve the `sx` prop IntelliSense (#23599) @mnajdova

### `@material-ui/unstyled@v5.0.0-alpha.17`

- [Slider] Replace core Slider with SliderStyled (#23308) @mnajdova

### `@material-ui/lab@v5.0.0-alpha.17`

#### Breaking changes

- [DatePicker] Change the import path of the date adapters (#23568) @eps1lon.
  It better fits with the current import convention.

  ```diff
  -import AdapterDateFns from '@material-ui/lab/dateAdapter/date-fns';
  +import AdapterDateFns from '@material-ui/lab/AdapterDateFns';
  ```

#### Changes

- [DatePicker] Add missing exports (#23621) @havgry
- [DatePicker] Add missing TypeScript definitions (#23560) @mbrookes
- [DatePicker] Fix false-positive when validating mask in Safari (#23602) @eps1lon
- [DatePicker] Fix missing manifest for typescript packages (#23564) @eps1lon
- [TimePicker] Prevent scroll when interacting with the clock (#23563) @knightss27

### Docs

- [docs] Add advanced page for the system (#23596) @mnajdova
- [docs] Add docs for typography in system (#23510) @oliviertassinari
- [docs] API pages i18n (#23214) @mbrookes
- [docs] Create pickers migration guide (#23605) @dmtrKovalenko
- [docs] Enable TS language service for docs/src (#23576) @eps1lon
- [docs] Explain the information listed on the system properties page (#23566) @mnajdova
- [docs] Fix /api client-side routing (#23586) @eps1lon
- [docs] Fix the Box section title on migration-v4 guide (#23679) @claudioldf
- [docs] Generate default values for docs from the unstyled components (#23614) @mnajdova
- [docs] Increase printWidth from 80 to 85(#23512) @eps1lon
- [docs] Prevent layout jumps from img loading in system demo (#23504) @eps1lon
- [docs] Remove controlled Tooltip example in Slider (#23625) @micsidoruk
- [docs] Remove dead demos in the system basics page (#23565) @mnajdova
- [docs] Replace emotion-server packages with @emotion/server (#23557) @numToStr
- [docs] Sync translations (#23648) @l10nbot

### Core

- [core] Add support for TypeScript 4.1 (#23633) @eps1lon
- [core] Batch small changes (#23554) @oliviertassinari
- [core] Cleanup emotion dependencies (#23556) @eps1lon
- [core] Fix formatting (#23567) @eps1lon
- [core] Fix tracked component size regression (#23516) @eps1lon
- [core] Fix transpilation target of UMD bundle (#23618) @eps1lon
- [test] Create chunks for Argos (#23518) @oliviertassinari
- [test] Debug argos-cli upload failures (#23623) @eps1lon
- [test] Enable experimental-timezone tests (#23595) @eps1lon
- [test] Misc visual regression flakiness improvements (#23619) @eps1lon
- [test] Use playwright instead of vrtest (#23500) @eps1lon

## 5.0.0-alpha.16

###### _Nov 14, 2020_

Big thanks to the 34 contributors who made this release possible. Here are some highlights ✨:

- 📅 Migrate the date picker to the lab (#22692) @dmtrKovalenko.
  We have integrated the components with the code infrastructure. Next we will migrate all the GitHub issues from [material-ui-pickers](https://github.com/mui-org/material-ui-pickers) and archive the repository. This migration will help provide first-class support for the date picker components. The component will stay in the lab as long as necessary to reach the high quality bar we have for core components. You can find the [new documentation here](https://next.material-ui.com/components/pickers/).

  While the source code is currently hosted in the [main repository](https://github.com/mui-org/material-ui), we might move it to the [x repository](https://github.com/mui-org/material-ui-x) in the future, depending on what is easier for the commercial date range picker. The date picker will stay open source no matter what.

- 📚 Revamp the documentation for [the system](https://next.material-ui.com/system/basics/). The System contains CSS utilities. The documentation now promotes the use of the `sx` prop. It's ideal for adding one-off styles, e.g. padding, but when pushed to its limits, it can be used to implement quickly a complete page.
- 👩‍🎨 Upgrade emotion to v11 (#23007) @mnajdova.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.16`

#### Breaking changes

- [TextField] Change default variant from standard to outlined (#23503) @mbrookes
  Standard has been removed from the Material Design guidelines. [This codemod](https://github.com/mui-org/material-ui/tree/next/packages/material-ui-codemod#variant-prop) will automatically update your code.

  ```diff
  -<TextField value="Standard" />
  -<TextField value="Outlined" variant="outlined" />
  +<TextField value="Standard" variant="standard" />
  +<TextField value="Outlined" />
  ```

- [Autocomplete] Remove `debug` in favor of `open` and dev tools (#23377) @eps1lon
  There are a couple of simpler alternatives: `open={true}`, Chrome devtools ["Emulate focused"](https://twitter.com/sulco/status/1305841873945272321), or React devtools props.

#### Changes

- [Autocomplete] Use Popper when `disablePortal` (#23263) @eps1lon
- [Box] Better DX for deprecated props (#23285) @eps1lon
- [codemod] Add a codemod for the Box sx prop (#23465) @mbrookes
- [CssBaseline] Add dark mode scrollbar support (#23407) @mmmols
- [Slider] Extract slots as standalone components (#22893) @mnajdova
- [Stepper] Fix the icon prop support in StepLabel (#23408) @randyshoopman
- [theme] Add htmlFontSize to Typography interface (#23412) @fergusmcdonald
- [Tooltip] Fix PopperProps popper modifiers not being merged properly (#23421) @dominique-mueller
- [Tooltip] Long press select text on iOS (#23466) @hmaddisb
- [Tooltip] Unexpected behaviour onOpen/onClose (#23482) @brorlarsnicklas

### `@material-ui/lab@v5.0.0-alpha.16`

- [DatePicker] Migrate to the lab #22692 @dmtrKovalenko

### `@material-ui/system@v5.0.0-alpha.16`

- [system] Add typography prop that will pull from theme.typography (#23451) @mnajdova
- [system] Create separate margin and padding functions (#23452) @mnajdova
- [system] Export styleFunctionSx and improve signature (#23397) @mnajdova
- [system] Merge breakpoints in correct order (#23380) @mnajdova
- [system] Remove css utility in favor of sx (#23454) @mnajdova
- [system] Warn for spacing when non integer value is used with theme.spacing array (#23460) @mnajdova

### `@material-ui/styled-engine@v5.0.0-alpha.16`

- [styled-engine] Upgrade emotion to 11 RC (#23007) @mnajdova

### `@material-ui/unstyled@v5.0.0-alpha.16`

- [Slider] Extract slots as standalone components (#22893) @mnajdova

### `@material-ui/codemod@v5.0.0-alpha.16`

- [TextField] Change default variant from standard to outlined (#23503) @mbrookes

### Docs

- [docs] Allow to host code in a different repo (#23390) @oliviertassinari
- [docs] CHANGELOG for v5.0.0-alpha.15 (#23383) @oliviertassinari
- [docs] Fix examples download URLs to match the correct branch name (#23467) @matchatype
- [docs] Fix links being opened when dismissing context menus (#23491) @eps1lon
- [docs] Fix the Netlify proxy for localization of X (#23387) @oliviertassinari
- [docs] Fix usage of palette.type instead of palette.mode in docs (#23414) @hubgit
- [docs] Improve documentation of the system (#23294) @mnajdova
- [docs] Improve feedback a11y (#23459) @eps1lon
- [docs] Improve formatting of the system (#23509) @oliviertassinari
- [docs] Improve migration guide for theme.palette (#23416) @hubgit
- [docs] Mention delay instead of transition twice (#23393) @benmneb
- [docs] Prepare Material-UI X (#1893) @oliviertassinari
- [docs] Redirect legacy GridList pages to ImageList (#23456) @eps1lon
- [docs] Remove redundant aria-label when wrapped in Tooltip (#23455) @eps1lon
- [docs] Sync translations (#23316) @l10nbot
- [docs] Update buildAPI script to handle the "styled" components (#23370) @mnajdova
- [docs] Update new components in the roadmap (#23507) @mbrookes
- [docs] Update translations (#23501) @l10nbot

### Core

- [core] Batch small changes (#23422) @oliviertassinari
- [core] Fix skipped ignore patterns (#23474) @eps1lon
- [core] Switch to globby and fast-glob (#23382) @eps1lon
- [test] Increase timeout threshold for slow Firefox tests (#23463) @eps1lon
- [test] Make sure system properties are in the same order when generating CSS (#23388) @mnajdova
- [test] Prefer longhand properties (#23445) @eps1lon
- [test] Remove data-mui-test from tests (#23498) @eps1lon
- [test] Remove keyDown#force (#23488) @eps1lon
- [test] Use adapter instead of native Date (#23475) @eps1lon
- [test] Use fake timers in visual regression tests (#23464) @eps1lon

## 5.0.0-alpha.15

###### _Nov 4, 2020_

Big thanks to the 20 contributors who made this release possible. Here are some highlights ✨:

- ⚛️ Add support for React 17 (#23311) @eps1lon.
  React 17 release is unusual because it doesn't add any new developer-facing features. It was released a couple of days ago. You can learn more about it in the [introduction post](https://reactjs.org/blog/2020/10/20/react-v17.html). Material-UI now supports `^16.8.0 || ^17.0.0`.
- 🛠 Introduce a new `@material-ui/unstyled` package (#23270) @mnajdova.
  This package will host the unstyled version of the components. In this first iteration, only the Slider is available. You can find it documented under the [same page](https://next.material-ui.com/components/slider-styled/#unstyled-slider) as the styled version.

  **Why an unstyled package?**

  While engineering teams are successfully building custom design systems by wrapping Material-UI, we [occasionally hear](https://github.com/mui-org/material-ui/issues/6218) that Material Design or our styling solution are something they don't need. Some teams prefer SASS, others prefer to customize the components starting from a pristine state. What all these teams have in common is that they value the features coming from the components, such as accessibility.

  The unstyled package goes one step down in the abstraction layer, providing more flexibility. Angular Material introduced this approach two years ago. Today their unstyled components account for [25% of the usage](https://npm-stat.com/charts.html?package=%40angular%2Fmaterial&package=%40angular%2Fcdk&from=2017-11-03&to=2020-11-03).

  Another reason for introducing this package is to prepare the groundwork for a [second theme](https://github.com/mui-org/material-ui/issues/22485) (not Material Design based).

  A note on the terminology: "unstyled" means that the components have the same API as the "styled" components but come without CSS. Material-UI also contains "headless" components that exposes a hook API, e.g. [useAutocomplete](https://next.material-ui.com/components/autocomplete/#useautocomplete) or [usePagination](https://next.material-ui.com/components/pagination/#usepagination).

  This change is part of our strategy to iterate on the v5 architecture with the `Slider` first. In the next alpha release, we plan to replace the v4 slider with the v5 slider. Once the new approach is stress-tested and validated, we will roll it out to all the components.

- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.15`

#### Breaking changes

- [AppBar] Fix z-index when position="static" (#23325) @sujinleeme
  Remove z-index when position static and relative
- [theme] Fix error message for augmentColor failure (#23371) @reedanders
  The signature of `theme.palette.augmentColor` helper has changed:

  ```diff
  -theme.palette.augmentColor(red);
  +theme.palette.augmentColor({ color: red, name: 'brand' });
  ```

#### Changes

- [Autocomplete] Fix unclickable area between text input and endAdornment (#23229) @sujinleeme
- [Autocomplete] Follow Material Design State spec (#23323) @sujinleeme
- [Avatar] Fix usage of srcset property (#23286) @matheuspiment
- [ClickAwayListener] Fix mounting behavior in Portals in React 17 (#23315) @eps1lon
- [core] Allow React 17 (#23311) @eps1lon
- [Icon] Fix translation, e.g Google Translate (#23237) @cbeltrangomez84
- [LinearProgress] Fix Safari's bug during composition of different paint (#23293) @montogeek
- [Radio] Fix dot misalignment in Safari (#23239) @anasufana
- [styled-engine] Fix tagged template syntax with multiple expressions (#23269) @eps1lon
- [Table] Fix empty row logic when displaying all (#23280) @JoaoJesus94
- [Table] Fix handling of rowsPerPage={-1} (#23299) @JoaoJesus94
- [TextareaAutosize] Fix container with no intrinsic height (#23273) @sujinleeme
- [TextField] Fix disabled color in Safari (#23375) @Morteza-Jenabzadeh
- [theme] Fix spacing string arguments (#23224) @GuilleDF
- [Tooltip] Fix excess spacing (#23233) @benneq

### `@material-ui/unstyled@v5.0.0-alpha.15`

- [unstyled] Create package and move SliderUnstyled there (#23270) @mnajdova
- [core] Allow React 17 (#23311) @eps1lon

### `@material-ui/lab@v5.0.0-alpha.15`

- [lab] Migrate Timeline to TypeScript (#23242) @oliviertassinari
- [core] Allow React 17 (#23311) @eps1lon

### `@material-ui/icons@v5.0.0-alpha.15`

- [core] Allow React 17 (#23311) @eps1lon

### `@material-ui/styles@v5.0.0-alpha.15`

- [core] Allow React 17 (#23311) @eps1lon

### `@material-ui/system@v5.0.0-alpha.15`

- [core] Allow React 17 (#23311) @eps1lon
- [theme] Fix spacing string arguments (#23224) @GuilleDF

### Docs

- [Transition] Document default appear value (#23221) @GuilleDF
- [blog] Danail Hadjiatanasov joins Material-UI (#23223) @oliviertassinari
- [docs] Add Material-UI Builder to in-house ads (#23342) @mbrookes
- [docs] Fix a few typos and add comma (#23284) @reedanders
- [docs] Fix few propTypes in Inputs (#23331) @youknowhat
- [docs] Fix language cookie (#23324) @mbrookes
- [docs] Fix typo in `README.md` (#23329) @mtsknn
- [docs] Guard against unknown value in userLanguage cookie (#23336) @mbrookes
- [docs] Make it clearer that custom router is supported (#23304) @Maxgit3
- [docs] Sync translations (#23080) @l10nbot
- [docs] Update homepage quotes (#23326) @mbrookes
- [docs] Update nav translations (#23234) @mbrookes
- [docs] Update system pages to use sx prop instead of deprecated Box props (#23368) @mnajdova
- [docs] Use present tense for bool prop descriptions (#23274) @mbrookes

### Core

- [utils] Add all @material-ui/core/utils to @material-ui/utils (#23264) @mnajdova
- [core] Batch small changes (#23327) @oliviertassinari
- [core] Fix implicit transitive 'csstype' dependency (#23301) @quinnturner
- [core] Move material-ui-benchmark into benchmark/server (#23271) @eps1lon
- [core] Replace temp package with node built-ins (#23262) @eps1lon
- [core] Restrict top level imports that target CJS modules (#23159) @eps1lon
- [test] Fix unexpected console warn/error spy swallowing unrelated messages (#23312) @eps1lon
- [test] Fix various issues with the new cli on windows (#23381) @eps1lon
- [test] Improve test debugging (#23372) @eps1lon
- [test] Introduce experimental CLI (#23369) @eps1lon
- [test] Prevent growing call stack in custom keyDown/keyUp (#23321) @eps1lon
- [test] Run with Safari 13 (#23292) @eps1lon

## 5.0.0-alpha.14

###### _Oct 23, 2020_

Big thanks to the 23 contributors who made this release possible.
Here are some highlights ✨:

- 💄 Introduce a new `sx` prop (#23053, #23205) @mnajdova
  We have resumed the work on Material-UI System. This is made possible by the latest progress on the new styling solution of v5.
  You can read the [introduction blog post](https://medium.com/material-ui/introducing-material-ui-design-system-93e921beb8df) that we did for the system two years ago.

  The system is meant to solve the following problems:

  1. Naming things is hard. How should a class name, JSS style rule, or styled component be named?
  2. Jumping between JS and CSS in the editor wastes time. This is particularly true as the complexity (LOCs/# of elements) of a component increases. It's still true when using the `styled()` API.
  3. Introducing a `makeStyles` for the first time in a component is daunting. For example, it's why https://github.com/vscodeshift/material-ui-codemorphs#add-usestyles-hook exists. What if we had less code to type, gaining velocity when writing styles?
  4. Pulling values out from the theme can be cumbersome. How can we make it less painful to increase the usage of design tokens?

  This new iteration of the system brings two major improvements:

  - It moves from the support of a subset of CSS to the support of a superset of CSS.
    Learning the shorthand is optional. It's no longer necessary to moving back to styled() when the system doesn't support a specific CSS property.
  - It moves from support on Box only to any core component (starting with the slider).

    ```jsx
    import Slider from '@material-ui/lab/SliderStyled';

    // Set the primary color and a vertical margin of 16px on desktop.
    <Slider sx={{ color: 'primary.main', my: { xs: 0, md: 2 } }} />;
    ```

- ✨ Upgrade Popper.js from v1 to v2 (#21761) @joshwooding
  The change reduces the bundle size (-1 kB gzipped) while fixing bugs at the same time.

- 🐛 Fix broken nested imports with the icons package (#23157) @eps1lon
  The revamp of the bundling strategy in #22814 has broken the nested imports.
  Imports such as the one below should work again with this release:

  ```jsx
  import CloseIcon from '@material-ui/icons/Close';
  ```

- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.14`

#### Breaking changes

- [Popper] Upgrade to popper.js to v2 (#21761) @joshwooding
  This third-party library has introduced a lot of changes.<br />
  You can read [their migration guide](https://popper.js.org/docs/v2/migration-guide/) or the following summary:

  - The CSS prefixes have changed:
    ```diff
    popper: {
      zIndex: 1,
    - '&[x-placement*="bottom"] $arrow': {
    + '&[data-popper-placement*="bottom"] $arrow': {
    ```
  - Method names have changed.

    ```diff
    -popperRef.current.scheduleUpdate()
    +popperRef.current.update()
    ```

    ```diff
    -popperRef.current.update()
    +popperRef.current.forceUpdate()
    ```

  - Modifiers' API has changed a lot. There are too many changes to be covered here.

- [withMobileDialog] Remove this higher-order component (#23202) @RDIL
  The hook API allows a simpler and more flexible solution than the HOC:

  ```diff
  -import withMobileDialog from '@material-ui/core/withMobileDialog';
  +import { useTheme, useMediaQuery } from '@material-ui/core';

  function ResponsiveDialog(props) {
  - const { fullScreen } = props;
  + const theme = useTheme();
  + const fullScreen = useMediaQuery(theme.breakpoints.down('sm'));
    const [open, setOpen] = React.useState(false);

  // ...

  -export default withMobileDialog()(ResponsiveDialog);
  +export default ResponsiveDialog;
  ```

#### Changes

- [Box] Add sx prop (#23053) @mnajdova
- [Box] Deprecate system props (#23206) @mnajdova
- [Card] Use flex display for CardHeader.avatar (#23169) @mordechaim
- [Container] Fix support of custom breakpoint units (#23191) @espipj
- [Container] Revert max-width change for xs @oliviertassinari
- [InputBase] Use ref prop instead of inputRef prop on input component (#23174) @GuilleDF
- [l10n] Add Kazakh (kz-KZ) locale (#23195) @abdulgafur24
- [Rating] Ensure hover and click are in sync (#23117) @redbmk
- [Select] Fix SelectDisplayProps className concat (#23211) @reedanders

### `@material-ui/styled-engine@v5.0.0-alpha.14`

- [styled] Add @babel/runtime dependency (#23175) @koistya

### `@material-ui/system@v5.0.0-alpha.14`

- [Box] Add sx prop (#23053) @mnajdova
- [core] Fix bundles for packages without subpackages (#23157) @eps1lon

### `@material-ui/icons@v5.0.0-alpha.14`

- [core] Fix bundles for packages without subpackages (#23157) @eps1lon

### `@material-ui/lab@v5.0.0-alpha.14`

#### Breaking changes

- [AvatarGroup] Move from lab to core (#23121) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import AvatarGroup from '@material-ui/lab/AvatarGroup';
  +import AvatarGroup from '@material-ui/core/AvatarGroup';
  ```

#### Changes

- [Slider] Add sx prop in SliderStyled (#23205) @mnajdova

### `@material-ui/utils@v5.0.0-alpha.14`

- [utils] Fix types of chainPropTypes (#23123) @oliviertassinari
- [core] Fix bundles for packages without subpackages (#23157) @eps1lon

### `@material-ui/types@v5.2.0-alpha.14`

- [types] Add LICENSE files (#23162) @lielfr

### Docs

- [examples] Remove reason example project (#23158) @mnajdova
- [examples] Update cdn example to use @material-ui/core@next (#23153) @mnajdova
- [examples] Update preact to use the @material-ui/core@next (#23154) @mnajdova
- [examples] Update ssr example to use @material-ui/core@next (#23155) @mnajdova
- [examples] Updated nextjs-typescript example to use @material-ui/core@next (#23119) @numToStr
- [docs] Add Menu component example with explicit positioning prop values (#23167) @jaebradley
- [docs] Add page feedback (#22885) @mbrookes
- [docs] Add Performance section for Modal (#23168) @jaebradley
- [docs] Better document CardActionArea (#23196) @el1f
- [docs] Cleaner image of font-size equation (#23189) @CamDavidsonPilon
- [docs] Fix casing typo (#23148) @piperchester
- [docs] Fix typo in steppers (#23163) @AGDholo
- [docs] Fix typo on interoperability page (#23177) @SassNinja
- [docs] Improve migration v5 guide @oliviertassinari
- [docs] Lazy load demo toolbar (#23108) @eps1lon
- [docs] Remove unused style selectors `extendedIcon` (#23160) @MatejKastak
- [docs] Use Box sx prop on all Slider examples #23217 @mnajdova

### Core

- [benchmark] Add theme-ui and chakra-ui Box scenarios (#23180) @mnajdova
- [benchmark] Create separate workspace (#23209) @eps1lon
- [benchmark] Extracted Profiler & added output in readme (#23178) @mnajdova
- [core] Batch small changes (#23116) @oliviertassinari
- [core] Improve bundle size comment (#23110) @eps1lon
- [core] Prevent unstable chunks in size snapshot (#23181) @eps1lon

## 5.0.0-alpha.13

###### _Oct 17, 2020_

Big thanks to the 25 contributors who made this release possible.
Here are some highlights ✨:

- 📦 Ship modern bundle (#22814) @eps1lon.
  This is a significant update to the [browsers supported](https://next.material-ui.com/getting-started/supported-platforms/) by Material-UI.
  The previous policy was defined 2 years ago, and the landscape has evolved since then. The package now includes 4 bundles:

  1. `stable` (default, formerly `esm`) which targets a snapshot (on release) of `> 0.5%, last 2 versions, Firefox ESR, not dead, not IE 11"`
  2. `node` (formerly default) which targets a snapshot (on release) of `maintained node versions`
  3. `legacy` (new) which is `stable` + IE11
  4. `modern` (formerly `es`) which targets the last 1 version of evergreen browsers and active node (currently that is 14

  The change yields a 6% reduction in bundle size 📦 (Babel only).
  In the coming weeks, we will refactor the internals to take advantage of the new browser capabilities that dropping these older platforms allows. For instance, we might be able to remove the span we render inside the `<Button>` to work around [Flexbug #9](https://github.com/philipwalton/flexbugs/blob/master/README.md#flexbug-9).

  Check the updated [Supported platforms documentation](https://next.material-ui.com/getting-started/supported-platforms/) and [new "minimizing bundle size" guide](https://next.material-ui.com/guides/minimizing-bundle-size/).

  If you target IE11, you need to use the new bundle (`legacy`). We are treating IE11 as a second class-citizen, which is a continuation of the direction taken in #22873.

- 🚀 Improve the internal benchmark suite (#22923, #23058) @mnajdova.
  This was a prerequisite step to improve the [system](https://next.material-ui.com/system/basics/). We needed to be able to measure performance. After #22945, we have measured that the `Box` component is x3 faster in v5-alpha compared to v4.
- ✏️ A new blog post: [Q3 2020 Update](https://material-ui.com/blog/2020-q3-update/) (#23055) @oliviertassinari.
- 🐙 Migrate more tests to react-testing-library @deiga, @Morteza-Jenabzadeh, @nicholas-l.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.13`

#### Breaking changes

- [core] Ship modern bundle (#22814) @eps1lon

#### Change

- [Autocomplete] Fix autoHighlight synchronization (#23025) @Tubaleviao
- [Autocomplete] Ignore keydown event until IME is confirmed (#23050) @jiggum
- [Card] Fix action area hover style on touch devices (#23079) @giulianovarriale
- [Slider] Align value label text center (#23075) @LorenzHenk
- [SwipeableDrawer] Decorrelate swipeAreaWidth and initial jumping amount (#23042) @omidtajik
- [Tooltip] Fix followCursor preventing onMouseMove on children (#23104) @eps1lon
- [Tooltip] Refactor event handling (#23092) @eps1lon
- [theme] Add missing types for theme overrides (#23028) @povilass
- [l10n] Add Arabic (ar_EG) locale (#23006) @GoldenWings

### `@material-ui/lab@v5.0.0-alpha.13`

- [TreeView] Fix bundle size link and refactor array spreads (#22992) @joshwooding
- [TreeView] Fix `alpha` color utility instead of deprecated `fade` (#22978) @joshwooding
- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/utils@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/system@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/styles@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/styled-engine@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/styled-engine-sc@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### `@material-ui/icons@v5.0.0-alpha.13`

- [core] Ship modern bundle (#22814) @eps1lon

### Docs

- [blog] Allow to support card preview (#23087) @oliviertassinari
- [blog] Q3 2020 Update (#23055) @oliviertassinari
- [docs] Add a new demo to the showcase (#22949) @adonig
- [docs] Add demo for Link underline (#23074) @LorenzHenk
- [docs] Add logarithmic slider demo (#23076) @LorenzHenk
- [docs] Add react-admin in related projects page (#23097) @fzaninotto
- [docs] Change color to palette (#23046) @mockingjet
- [docs] Don't suggest putting a Switch inside a ListItemSecondaryAction (#23018) @sirlantis
- [docs] Fix docs:dev (#23023) @eps1lon
- [docs] Fix vertical alignment of Slider demo (#23059) @r0zar
- [docs] Fix wrong variable characters (#23066) @AGDholo
- [docs] Improve docs for Table sticky column grouping (#23100) @andre-silva-14
- [docs] Improve icon preview color contrast (#22974) @oliviertassinari
- [docs] Interoperability guide updates (#23030) @mnajdova
- [docs] Move outdated versions into a collapsible section (#23029) @NoNamePro0
- [docs] Point to material-ui-x/next instead of master @oliviertassinari
- [docs] Restore ButtonBases images (#23083) @eps1lon
- [docs] Slider demos clean up (#22964) @mnajdova
- [docs] Sync translations (#22888) @l10nbot
- [examples] Update gatsby example to use @material-ui/\* next (#23089) @mnajdova
- [examples] Update gatsby-theme example to use @material-ui/\* next #23093 @mnajdova
- [examples] Update nextjs example project to use @material-ui/\* next (#23094) @mnajdova

### Core

- [benchmark] Add browser benchmark (#22923) @mnajdova
- [benchmark] Fix benchmark scripts & moved scenarios to correct benchmark project (#23058) @mnajdova
- [test] Enable failing unexpected console warn|error in browser tests (#23063) @eps1lon
- [test] Fail each test on unexpected console logs in test:unit (#23064) @eps1lon
- [test] Introduce toHaveInlineStyle and toHaveComputedStyle matcher (#23054) @eps1lon
- [test] Migrate ButtonBase to react-testing-library (#23011) @deiga
- [test] Migrate IconButton to react-testing-library (#22972) @Morteza-Jenabzadeh
- [test] Migrate InputBase to react-testing-library (#23014) @deiga
- [test] Migrate SpeedDial to react-testing-library (#23021) @nicholas-l
- [test] Migrate TableCell to react-testing-library (#23095) @nicholas-l
- [test] Migrate TableRow to react-testing-library (#23105) @deiga
- [test] Move some work out of evaluation phase (#23112) @eps1lon
- [test] Supress 404 img warnings in browser tests (#23106) @eps1lon
- [test] Throw on console.(error|warn) outside of test (#22907) @eps1lon
- [test] Use dot reporter in CI (#23026) @eps1lon
- [core] Add support for iOS Safari 12 (#23068) @eps1lon
- [core] Also format dot files & folders (#22975) @oliviertassinari
- [core] Extend yarn size:why (#22979) @eps1lon
- [core] Fix react-next test (#23027) @oliviertassinari
- [core] Lint CSS (#22976) @oliviertassinari
- [core] Misc modules/\* cleanup (#22983) @eps1lon

## 5.0.0-alpha.12

###### _Oct 11, 2020_

Big thanks to the 45 contributors who made this release possible.
Here are some highlights ✨:

- 🧪 The promotion of 4 components from the lab to core: Autocomplete, Pagination, SpeedDial, and ToggleButton. These components have been in the lab for more than 10 months @mbrookes.
- 📦 Switch the style engine of the `Box` component from JSS to _@material-ui/styled-engine_ (use emotion by default) (#22945) @mnajdova.
  The early benchmark we have run shows that performance has improved. We will share more detailed results in #21657.
- 🐙 Migrate a large portion of the tests from enzyme to react-testing-library @eladmotola, @baterson, @bewong89, @devrasec, @guillermaster, @itamar244, @jeferson-sb, @The24thDS.
  Last month, react-testing-library had [more downloads](https://npm-stat.com/charts.html?package=enzyme&package=%40testing-library%2Freact&from=2019-10-10&to=2020-10-10) than enzyme in the ecosystem!
- 🏷 Add support for tooltips [following the cursor](https://next.material-ui.com/components/tooltips/#follow-cursor) (#22876) @xtrixia.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.12`

#### Breaking changes

- [Accordion] Remove `display:flex` from AccordionDetails (#22809) @croraf
  The style was too opinionated. Most developers expect `display: block`.
- [Accordion] Replace IconButton wrapper with div (#22817) @croraf
  Remove IconButtonProps prop from AccordionSummary.
  The component renders a `<div>` element instead of an IconButton.
  The prop is no longer relevant.
- [Box] Add mui styled usage (#22945) @mnajdova
  Change the style-engine powering the Box component from JSS to the style engine adatper (emotion by default).
- [CircularProgress] Drop IE11 wobbly workaround (#22873) @suliskh
  The IE11 workaround is harming performance on the latest browsers.
  This change is part of a best-effort strategy to keep IE11 support.
  We are degrading the UX and DX with IE11 where we can improve the components on modern browsers.
- [Table] Rename onChangeRowsPerPage and onChangePage (#22900) @eladmotola
  The change was done to match the API convention.

  ```diff
  <TablePagination
  - onChangeRowsPerPage={()=>{}}
  - onChangePage={()=>{}}
  + onRowsPerPageChange={()=>{}}
  + onPageChange={()=>{}}
  ```

- [theme] Rename fade to alpha (#22834) @mnajdova
  Better describe its functionality. The previous name was leading to confusion when the input color already had an alpha value. The helper **overrides** the alpha value of the color.

  ```diff
  - import { fade } from '@material-ui/core/styles';
  + import { alpha } from '@material-ui/core/styles';

  const classes = makeStyles(theme => ({
  -  backgroundColor: fade(theme.palette.primary.main, theme.palette.action.selectedOpacity),
  +  backgroundColor: alpha(theme.palette.primary.main, theme.palette.action.selectedOpacity),
  }));
  ```

- [Tooltip] Make `interactive` default (#22382) @eps1lon
  The previous default behavior failed [success criterion 1.4.3 ("hoverable") in WCAG 2.1](https://www.w3.org/TR/WCAG21/#content-on-hover-or-focus).
  To reflect the new default value, the prop was renamed to `disableInteractive`.
  If you want to restore the old behavior (thus not reaching level AA), you can apply the following diff:

  ```diff
  -<Tooltip>
  +<Tooltip disableInteractive>
  # Interactive tooltips no longer need the `interactive` prop.
  -<Tooltip interactive>
  +<Tooltip>
  ```

#### Changes

- [Accordion] Remove incorrect demo which nests input in button (#22898) @croraf
- [Autocomplete] Fix filtering when value is already selected (#22935) @montelius
- [Autocomplete] Fix virtualization example in IE11 (#22940) @bearfromtheabyss
- [Autocomplete] Restrict component props in `renderInput` (#22789) @eps1lon
- [Box] Add types for `ref` (#22927) @lcswillems
- [Button] Fix invalid type value (#22883) @oliviertassinari
- [Button] Improve loading transition (#22884) @oliviertassinari
- [Grid] Clarify document about direction column limitation (#22871) @ThewBear
- [IconButton] Improve warning against non root onClick listeners (#22821) @pranjanpr
- [Popper] Use placement viewport instead of window (#22748) @maksimgm
- [Select] Add generic support for value (#22839) @AntoineGrandchamp
- [Skeleton] Fix importing with named export (#22879) @0prodigy
- [SpeedDial] Fix keyboard navigation when uncontrolled (#22826) @akharkhonov
- [styled] Specify emotion & styled-components as optional peer dependencies (#22808) @mnajdova
- [styled] Support default theme when none is available (#22791) @mnajdova
- [Tabs] Fix RTL scrollbar with Chrome 85 (#22830) @ankit
- [TextField] Pass minRows to InputComponent (#22831) @suliskh
- [ToggleButton] Fix vertical double border (#22825) @Avi98
- [ToggleButton] Match ToggleButtonGroup name and render function name (#22790) @jjoselv
- [Tooltip] Add placement `followCursor` (#22876) @xtrixia
- [Tooltip] Improve docs and warning for custom children (#22775) @brorlarsnicklas
- [Tooltip] Use label semantics (#22729) @eps1lon
- [useAutocomplete] Fix getXProps functions type (#22749) @kentaro84207

### `@material-ui/styled-engine@v5.0.0-alpha.12`

- [styled] Support default theme when none is available (#22791) @mnajdova

### `@material-ui/lab@v5.0.0-alpha.12`

#### Breaking changes

- [Autocomplete] Move from lab to core (#22715) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import Autocomplete from '@material-ui/lab/Autocomplete';
  -import useAutocomplete from '@material-ui/lab/useAutocomplete';
  +import Autocomplete from '@material-ui/core/Autocomplete';
  +import useAutocomplete from '@material-ui/core/useAutocomplete';
  ```

- [Pagination] Move from lab to core (#22848) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import Pagination from '@material-ui/lab/Pagination';
  -import PaginationItem from '@material-ui/lab/PaginationItem';
  -import { usePagination } from '@material-ui/lab/Pagination';
  +import Pagination from '@material-ui/core/Pagination';
  +import PaginationItem from '@material-ui/core/PaginationItem';
  +import usePagination from '@material-ui/core/usePagination';
  ```

- [SpeedDial] Move from lab to core (#22743) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import SpeedDial from '@material-ui/lab/SpeedDial';
  -import SpeedDialAction from '@material-ui/lab/SpeedDialAction';
  -import SpeedDialIcon from '@material-ui/lab/SpeedDialIcon';
  +import SpeedDial from '@material-ui/core/SpeedDial';
  +import SpeedDialAction from '@material-ui/core/SpeedDialAction';
  +import SpeedDialIcon from '@material-ui/core/SpeedDialIcon';
  ```

- [ToggleButton] Move from lab to core (#22784) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import ToggleButton from '@material-ui/lab/ToggleButton';
  -import ToggleButtonGroup from '@material-ui/lab/ToggleButtonGroup';
  +import ToggleButton from '@material-ui/core/ToggleButton';
  +import ToggleButtonGroup from '@material-ui/core/ToggleButtonGroup';
  ```

- [TreeView] Improve customization of tree item (#22846) @joshwooding
  Remove `onLabelClick` and `onIconClick`.

#### Changes

- [AvatarGroup] Add variant prop (#22832) @hjades
- [SliderStyled] Fix mark label alignment on coarse pointer devices (#22849) @joshwooding

### Docs

- [docs] Add example for using styled-components as styled-engine (#22788) @mnajdova
- [docs] Add longhand system API props to docs (#22796) @possibilities
- [docs] Box & system cleanup (#22962) @mnajdova
- [docs] CONTRIBUTING.md only yarn is supported (#22754) @Yashvirani
- [docs] Document createSvgIcon() (#22843) @mbrookes
- [docs] Document inherited props (#22318) @oliviertassinari
- [docs] Document LoadingButton behavior (#22878) @eps1lon
- [docs] Fix dark theme for input field on autocomplete (#22711) @GauravKesarwani
- [docs] Fix material icon search details view (#22793) @skr571999
- [docs] Fix type vs. mode and capitalization of createMuiTheme (#22844) @joshwooding
- [docs] Fix typo in guides/typescript (#22806) @croraf
- [docs] Fix various typos (#22842) @kkirsche
- [docs] For non-SSR language, internal search fall back to English (#22902) @bicstone
- [docs] Improve CRA example (#22967) @spursbyte
- [docs] Improve FormControl duplication warning (#22823) @talgautb
- [docs] Improve perf when opening the drawer (#22781) @eps1lon
- [docs] Improve SEO on titles (#22742) @oliviertassinari
- [docs] Improve the left side-nav (#22780) @oliviertassinari
- [docs] Include peer deps in installation steps (#22889) @numToStr
- [docs] Link all the examples in docs (#22891) @Avi98
- [docs] More robust description matcher (#22836) @eps1lon
- [docs] Reduce risk of 404 when changing the default branch (#22801) @eps1lon
- [docs] Resolve .tsx first (#22315) @oliviertassinari
- [docs] Simplify locales example (#22747) @mbrookes
- [docs] Sync translations (#22752, #22851) @l10nbot
- [docs] Update installation guide to contain peer dependencies (#22787) @mnajdova
- [docs] Update ToggleButton import (#22971) @mbrookes
- [docs] Use demo name as codesandbox name (#22926) @eps1lon

### Core

- [benchmark] Add cross-env to fix window run issue (#22895) @mnajdova
- [core] Batch small changes (#22746) @oliviertassinari
- [core] Batch small changes (#22847) @oliviertassinari
- [core] Drop babel-plugin-transform-dev-warning (#22802) @eps1lon
- [core] Misc dependency fixes (#22909) @eps1lon
- [test] Apply lazy forwardRef fix (#22904) @eps1lon
- [test] Autocomplete drop "defaultProps" pattern (#22896) @eps1lon
- [test] Fix react-next patch (#22800) @eps1lon
- [test] Migrate Accordion to react-testing-library (#22952) @bewong89
- [test] Migrate Backdrop to react-testing-library (#22931) @itamar244
- [test] Migrate Container to react-testing-library (#22919) @eladmotola
- [test] Migrate CssBaseline to react-testing-library (#22920) @eladmotola
- [test] Migrate Fab to react-testing-library (#22959) @The24thDS
- [test] Migrate Fade to react-testing-library (#22918) @eladmotola
- [test] Migrate Grow to react-testing-library (#22917) @eladmotola
- [test] Migrate List to react-testing-library (#22929) @eladmotola
- [test] Migrate MenuList and ImageListItem to react-testing-library (#22958) @eladmotola
- [test] Migrate MobileStepper to react-testing-library (#22963) @devrasec
- [test] Migrate more components to react-testing-library (#22872) @baterson
- [test] Migrate more components to react-testing-library (#22874) @baterson
- [test] Migrate more components to react-testing-library (#22892) @baterson
- [test] Migrate NativeSelect to react-testing-library (#22970) @guillermaster
- [test] Migrate NativeSelectInput to react-testing-library (#22910) @baterson
- [test] Migrate RadioGroup to react-testing-library (#22953) @eladmotola
- [test] Migrate Slide to react-testing-library (#22913) @eladmotola
- [test] Migrate SpeedDialIcon to react-testing-library (#22965) @jeferson-sb
- [test] Migrate TabIndicator to react-testing-library (#22906) @eladmotola
- [test] Migrate TextField to react-testing-library (#22944) @The24thDS
- [test] Migrate useTheme,withTheme to react-testing-library (#22928) @eladmotola
- [test] Migrate Zoom to react-testing-library (#22914) @eladmotola
- [test] Prevent nextjs build cache to grow indefinitely (#22948) @eps1lon
- [test] Simplify usage of `yarn mocha` (#22899) @eps1lon
- [test] Solve 2000ms timeout (#22778) @oliviertassinari
- [test] Update react next patch (#22890) @eps1lon
- [test] Use appropriate templates for csb CI (#22943) @eps1lon
- [test] Verbose reporter in CI (#22924) @eps1lon

## 5.0.0-alpha.11

###### _Sep 26, 2020_

Big thanks to the 29 contributors who made this release possible.
Here are some highlights ✨:

- 👩‍🎨 A first iteration on the new styling solution.

  You can find a [new version](https://next.material-ui.com/components/slider-styled/) of the slider in the lab powered by [emotion](https://emotion.sh/).

  In the event that you are already using styled-components in your application, you can swap emotion for styled-components 💅. Check [this CodeSandbox](https://codesandbox.io/s/sliderstyled-with-styled-components-forked-olc27?file=/package.json) for a demo. It relies on aliases to prevent any bundle size overhead.

  The new styling solution saves 2kB gzipped in the bundle compared to JSS, and about 14 kB gzipped if you were already using emotion or styled-components.

  Last but not least, the change allows us to take advantage dynamic style props. We will use them for dynamic color props, variant props, and new style props (an improved [system](https://material-ui.com/system/basics/)).

  This change has been in our roadmap for more than a year.
  We announced it in the [v4 release blog post](https://medium.com/material-ui/material-ui-v4-is-out-4b7587d1e701) as a direction v5 would take.

- 🛠 A first iteration on the unstyled components.

  You can find a [new version](https://next.material-ui.com/components/slider-styled/#UnstyledSlider.tsx) of the slider in the lab without any styles.
  The unstyled component weighs 6.5 kB gzipped, compared with 26 kB for the styled version when used standalone. The component is best suited for use when you want to fully customize the look of the component without reimplementing the JavaScript and accessibility logic.

- ⚡️ A first alpha of the [DataGrid](https://material-ui.com/components/data-grid/) component.

  It has taken 6 months of development since the initial commit (March 15th, 2020) to make the first alpha release of the grid. The component comes in two versions:
  @material-ui/data-grid is licensed under MIT, while @material-ui/x-grid is licensed under a commercial license.

- 🪓 Keep working on the breaking changes.

  We aim to complete most of the breaking changes during the alpha stage of v5.
  We will move to beta once all the breaking changes we have anticipated are handled.
  As always, you should find a clear and simple upgrade path for each of them.
  You can learn more about the breaking changes left to be done in #22700.

- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.11`

#### Breaking changes

- [Chip] Rename `default` variant to `filled` (#22683) @mnajdova
  Rename `default` variant to `filled` for consistency.

  ```diff
  -<Chip variant="default">
  +<Chip variant="filled">
  ```

- [Tabs] Add allowScrollButtonsMobile prop for mobile view (#22700) @GauravKesarwani
  The API that controls the scroll buttons has been split it into two props:

  - The `scrollButtons` prop controls when the scroll buttons are displayed depending on the space available.
  - The `allowScrollButtonsMobile` prop removes the CSS media query that systematically hides the scroll buttons on mobile.

  ```diff
  -<Tabs scrollButtons="on" />
  -<Tabs scrollButtons="desktop" />
  -<Tabs scrollButtons="off" />
  +<Tabs scrollButtons allowScrollButtonsMobile />
  +<Tabs scrollButtons />
  +<Tabs scrollButtons={false} />
  ```

- [theme] Improve breakpoints definitions (#22695) @mnajdova
  Breakpoints are now treated as values instead of ranges.
  The behavior of `down(key)` was changed to define media query less than the value defined with the corresponding breakpoint (exclusive).
  The behavior of `between(start, end)` was also updated to define media query for the values between the actual values of start (inclusive) and end (exclusive).

  Find examples of the changes required defined below:

```diff
-theme.breakpoints.down('sm') // '@media (max-width:959.95px)' - [0, sm + 1) => [0, md)
+theme.breakpoints.down('md') // '@media (max-width:959.95px)' - [0, md)
```

```diff
-theme.breakpoints.between('sm', 'md') // '@media (min-width:600px) and (max-width:1279.95px)' - [sm, md + 1) => [sm, lg)
+theme.breakpoints.between('sm', 'lg') // '@media (min-width:600px) and (max-width:1279.95px)' - [sm, lg)
```

- [theme] Rename `type` to `mode` (#22687) @mnajdova
  Renames `theme.palette.type` to `theme.palette.mode`, to better follow the "dark mode" term that is usually used for describing this feature.

  ```diff
  import { createMuiTheme } from '@material-ui/core/styles';

  -const theme = createMuiTheme({palette: { type: 'dark' }}),
  +const theme = createMuiTheme({palette: { mode: 'dark' }}),
  ```

  The changes are supported by the `adaptV4Theme()` for easing the migration

#### Changes

- [Checkbox] Improve indeterminate UI (#22635) @oliviertassinari
- [Chip] Fix prop-type support for custom variants (#22603) @cansin
- [icons] Expose a data-test-id attribute on all svg icons (#22634) @jaebradley
- [Rating] Add form integration test suite (#22573) @eps1lon
- [Rating] Simpler customization of active "no value" styles (#22613) @eps1lon
- [Rating] Treat as input when readOnly (#22606) @eps1lon
- [Rating] Treat read-only as image (#22639) @eps1lon
- [Select] Improve docs for displayEmpty prop (#22601) @mihaipanait
- [Slider] Better tracking of mouse events (#22557, #22638) @chrisinajar, @oliviertassinari
- [Slider] Create unstyled version and migrate to emotion & styled-components (#22435) @mnajdova
- [Slider] Export components from lab and renamed to fit file names (#22723) @mnajdova
- [Slider] Fix value label display for custom value component (#22614) @NoNonsense126
- [Stepper] Add slight transition (#22654) @xtrixia
- [Tabs] Fix TabScrollButton using absolute path (#22690) @4vanger
- [Tabs] Only scroll the visible tabs (#22600) @quochuy
- [theme] convertLength does not work for fromUnit !== 'px' (#22739) @brorlarsnicklas
- [theme] Fix createSpacing.d.ts definition (#22645) @dabretin
- [theme] Fix Hidden breakpoints issues and updates the migration guide (#22702) @mnajdova

### `@material-ui/lab@v5.0.0-alpha.11`

#### Breaking changes

- [Alert] Move from lab to core (#22651) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import Alert from '@material-ui/lab/Alert';
  -import AlertTitle from '@material-ui/lab/AlertTitle';
  +import Alert from '@material-ui/core/Alert';
  +import AlertTitle from '@material-ui/core/AlertTitle';
  ```

- [Rating] Move from lab to core (#22725) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import Rating from '@material-ui/lab/Rating';
  +import Rating from '@material-ui/core/Rating';
  ```

- [Skeleton] Move from lab to core (#22740) @mbrookes
  Move the component from the lab to the core. This component will become stable.

  ```diff
  -import Skeleton from '@material-ui/lab/Skeleton';
  +import Skeleton from '@material-ui/core/Skeleton';
  ```

- [Autocomplete] Get root elements of options via renderOption (#22591) @ImanMahmoudinasab
  After this change, the full DOM structure of the option is exposed.
  It makes customizations easier.
  You can recover from the change with:

  ```diff
  <Autocomplete
  - renderOption={(option, { selected }) => (
  -   <React.Fragment>
  + renderOption={(props, option, { selected }) => (
  +   <li {...props}>
        <Checkbox
          icon={icon}
          checkedIcon={checkedIcon}
          style={{ marginRight: 8 }}
          checked={selected}
        />
        {option.title}
  -   </React.Fragment>
  +   </li>
    )}
  />
  ```

#### Changes

- [lab] Fix transitive dependencies in @material-ui/lab (#22671) @koistya
- [Autocomplete] Add "remove-option" to AutocompleteCloseReason type (#22672) @iansjk
- [Autocomplete] Don't close popup when Ctrl/Meta is pressed (#22696) @montelius
- [Autocomplete] Fix accessibility issue with empty option set (#22712) @tylerjlawson
- [Autocomplete] Update GitHub customization example (#22735) @hmaddisb

### `@material-ui/styled-engine@v5.0.0-alpha.11`

The new default style engine leveraging emotion.

### `@material-ui/styled-engine-sc@v5.0.0-alpha.11`

Allows developer to swap emotion with styled-components.
More documentation are coming.

### `@material-ui/icons@v5.0.0-alpha.11`

- [icons] Synchronize with Google (#22680) @delewis13

### `@material-ui/styles@v5.0.0-alpha.11`

- [Slider] Create unstyled version and migrate to emotion & styled-components (#22435) @mnajdova

### `@material-ui/system@v5.0.0-alpha.11`

- [core] Port createSpacing to TypeScript (#22720) @eps1lon

### Docs

- [blog] New posts (#22607) @oliviertassinari
- [docs] Add additional context to Autocomplete asynchronous documentation (#22621) @jaebradley
- [docs] Add emotion dependencies in codesandbox examples (#22736) @mnajdova
- [docs] Add props from Unstyled component to Styled API page (#22733) @mnajdova
- [docs] Add ui-schema in related projects (#22644) @elbakerino
- [docs] Avoid confusion between layout grid and data grid (#22681) @oliviertassinari
- [docs] Batch small changes (#22646) @oliviertassinari
- [docs] Configuring redirects for MUI X (#22632) @dtassone
- [docs] Customized hook at Autocomplete issue in dark mode (#22605) @hmaddisb
- [docs] Encourage DataGrid in /components/tables/ over alternatives (#22637) @oliviertassinari
- [docs] Fix emotion broken in SSR (#22731) @mnajdova
- [docs] Fix markdown metadata yaml (#22629) @oliviertassinari
- [docs] Fix static asset loading with X @oliviertassinari
- [docs] Improve Dashboard template (#22647) @pak1989
- [docs] Improve DX for docs generation (#22619) @eps1lon
- [docs] Migrate templates to TypeScript (#22650) @oliviertassinari
- [docs] New Crowdin updates (#22620) @mbrookes
- [docs] Prevent toolbar tooltips overlapping demos (#22732) @eps1lon
- [docs] Reduce indirections (#22642) @Arsikod
- [docs] Reference experimental slider demos correctly (#22738) @eps1lon
- [docs] Remove minimum-scale from meta viewport in docs (#22724) @barik
- [docs] Remove wrong migration instruction (#22710) @oliviertassinari
- [docs] Use codesandbox deploy for demos created from deploy previews (#22616) @eps1lon

### Core

- [core] Port createSpacing to TypeScript (#22720) @eps1lon
- [core] Replace ChangeEvent<{}> with SyntheticEvent (#22716) @eps1lon
- [core] Use ttp sources directly (#22706) @eps1lon
- [test] Add skip ci to Crowdin commit message (#22685) @mbrookes
- [test] Only run on push for master/next (#22624) @eps1lon
- [test] Run CircleCI anytime (#22676) @eps1lon

## 5.0.0-alpha.10

###### _Sep 15, 2020_

Big thanks to the 16 contributors who made this release possible.
Here are some highlights ✨:

- Keep working on the breaking changes before v5-beta.
  As always, you should find a clear and simple upgrade path for each of them.
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.10`

#### Breaking changes

- [Accordion] Normalize focusVisible logic (#22567) @oliviertassinari
  Rename `focused` to `focusVisible` for consistency with the other components:

  ```diff
  <Accordion
    classes={{
  -   focused: 'custom-focus-visible-classname',
  +   focusVisible: 'custom-focus-visible-classname',
    }}
  />
  ```

- [Stepper] Remove Paper and built-in padding (#22564) @mbrookes
  The root component (Paper) was replaced with a `<div>`. Stepper no longer has elevation, nor inherits Paper's props. This change is meant to encourage composition.

  ```diff
  -<Stepper elevation={2}>
  -  <Step>
  -    <StepLabel>Hello world</StepLabel>
  -  </Step>
  -</Stepper>
  +<Paper square elevation={2}>
  +  <Stepper>
  +    <Step>
  +      <StepLabel>Hello world</StepLabel>
  +    </Step>
  +  </Stepper>
  +<Paper>
  ```

  Remove the built-in 24px padding for consistency with the other components that avoid reserving space anytime it's possible.

  ```diff
  -<Stepper>
  -  <Step>
  -    <StepLabel>Hello world</StepLabel>
  -  </Step>
  -</Stepper>
  +<Stepper style={{ padding: 24 }}>
  +  <Step>
  +    <StepLabel>Hello world</StepLabel>
  +  </Step>
  +</Stepper>
  ```

- [theme] Always return default spacing value with px units (#22552) @mbrookes

  `theme.spacing` now returns single values with px units by default.
  This change improves the integration with styled-components & emotion (with the CSS template strings syntax).

  Before:

  ```
  theme.spacing(2) => 16
  ```

  After:

  ```
  theme.spacing(2) => '16px'
  ```

- [theme] Remove palette.text.hint key (#22537) @mbrookes

  The `theme.palette.text.hint` key was available but unused in Material-UI v4 components.
  You can use `adaptV4Theme()` to restore the previous behavior.

#### Changes

- [BottomNavigation] onClick does not fire if tapped while scrolling (#22524) @EliasJorgensen
- [Button] Remove dead code (#22566) @oliviertassinari
- [Chip] Fix focus visible style (#22430) @alexmotoc
- [ImageList] Refactor using CSS grid & React context (#22395) @mbrookes
- [Slider] Improve integration with form libraries (#22548) @NoNonsense126
- [StepIcon] Add className in render SvgIcon (#22559) @ZouYouShun
- [SwipeableDrawer] Avoid blocking events (#22525) @JadRizk
- [theme] Support spacing and border radius with CSS unit (#22530) @madmanwithabike
- [theme] Fix theme object global leak (#22517) @eps1lon
- [theme] Increase usage of the disabled design tokens (#22570) @LorenzHenk

### `@material-ui/lab@v5.0.0-alpha.10`

#### Breaking changes

- [Rating] Use different shape for empty and filled icons (#22554) @oliviertassinari
  Change the default empty icon to improve accessibility (1.4.1 WCAG 2.1).
  If you have a custom `icon` prop but no `emptyIcon` prop, you can restore the previous behavior with:

  ```diff
  <Rating
    icon={customIcon}
  + emptyIcon={null}
  />
  ```

#### Changes

- [Autocomplete] Improve TypeScript in the Google Maps demo (#22555) @L-U-C-K-Y
- [Rating] Explain some styles in code comments (#22571) @eps1lon

### Docs

- [docs] Improve Font Awesome integration (#22496) @chrislambe
- [docs] Clarify SSG acronym in Next.js example (#22558) @leerob
- [docs] Add redirection for links published on npm (#22575) @oliviertassinari
- [docs] Add LightyearVPN to showcase (#22568) @lightyearvpn
- [docs] Fix typo, extra 'you' (#22560) @jedsmit
- [docs] Option to disable ads (#22574) @oliviertassinari

### Core

- [core] Remove usage of deprecated event.keyCode (#22569) @oliviertassinari
- [core] Remove references to other objects from created theme (#22523) @eps1lon
- [core] Batch small changes (#22565) @oliviertassinari

## 5.0.0-alpha.9

###### _Sep 6, 2020_

Big thanks to the 14 contributors who made this release possible.
Here are some highlights ✨:

- 💎 A new diamond sponsor: [DoiT](https://www.doit-intl.com/), thank you!
- 📚 Include the default value of the props in IntelliSense (#22447) @eps1lon
- ⚛️ More source migrated to TypeScript and testing-library (#22441) @baterson
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.9`

#### Breaking changes

- [Modal] Remove `onRendered` prop from Modal and Portal (#22464) @eps1lon
  Depending on your use case either use a [callback ref](https://reactjs.org/docs/refs-and-the-dom.html#callback-refs) on the child element or an effect hook in the child component.

#### Changes

- [Modal] Convert ModalManager to TypeScript (#22465) @eps1lon
- [Paper] Fix elevation warning when rendering (#22494) @nesso-pfl
- [Slider] Edge against swallowing of mouse up event (#22401) @motiejunas
- [Tabs] Add option to show scrollbar (#22438) @LogyLeo
- [Tabs] Document visibleScrollBar default value (#22475) @eps1lon
- [TextField] Remove excessive catching of hiddenLabel prop (#22444) @croraf

### `@material-ui/lab@v5.0.0-alpha.9`

- [docs] Include default values in IntelliSense (#22447) @eps1lon

### Docs

- [docs] Add DoiT diamond sponsor (#22436) @oliviertassinari
- [docs] Bump markdown-to-jsx (#22474) @eps1lon
- [docs] Change showcase approval process (#22398) @africanzoe
- [docs] Fix close context menu if repeated (#22463) @eps1lon
- [docs] Fix Next.js example (#22457) @bhati
- [docs] Fix TypeScript deps in CodeSandbox (#22346) @oliviertassinari
- [docs] Fix unresolved returntypes for props (#22459) @eps1lon
- [docs] Fix usage of overrides instead of styleOverrides (#22478) @discodanne
- [docs] Improve Backstage showcase (#22458) @stefanalund
- [docs] Improve styles basics.md section (#22440) @bxie
- [docs] Include default values in IntelliSense (#22447) @eps1lon

### Core

- [core] Batch small changes (#22461) @oliviertassinari
- [core] Fix useEventCallback type (#22448) @kodai3
- [core] Try out new JSX transform where available (#22455) @eps1lon
- [test] Migrate more components to react-testing-library (#22441) @baterson

## 5.0.0-alpha.8

###### _Aug 31, 2020_

Big thanks to the 19 contributors who made this release possible.
Here are some highlights ✨:

- 🎨 Inverse the customization API of the theme to be component-centric (#22347, #22293) @mnajdova.

```jsx
const theme = createMuiTheme({
  components: {
    MuiIconButton: {
      defaultProps: {
        size: 'small',
      },
      styleOverrides: {
        sizeSmall: {
          marginLeft: 4,
          marginRight: 4,
          padding: 12,
        },
      },
    },
  },
});
```

- ✨ Add [text in divider](https://next.material-ui.com/components/dividers/#dividers-with-text) support (#22285) @ShehryarShoukat96

  ```jsx
  <Divider>{'CENTER'}</Divider>
  ```

  <img width="530" alt="divider" src="https://user-images.githubusercontent.com/3165635/91740018-01cb5e80-ebb3-11ea-9a7f-6ddb48b3f496.png">

- ♿️ A bunch of accessibility fixes (#22366, #22374, #22377, #22340, #22376) @fakeharahman @alexmotoc @eps1lon @oliviertassinari
- ⚛️ Increase adoption of TypeScript in the codebase (#22389, #22367, #22282) @Luchanso, @oliviertassinari

### `@material-ui/core@v5.0.0-alpha.8`

#### Breaking changes

- [theme] Rename theme keys to defaultProps and styleOverrides (#22347) @mnajdova
- [theme] Restructure component definitions (#22293) @mnajdova
  The components' definition inside the theme were restructure under the `components` key, to allow people easier discoverability about the definitions regarding one component.

  1. `props`

  ```diff
  import { createMuiTheme } from '@material-ui/core/styles';

  const theme = createMuiTheme({
  -  props: {
  -    MuiButton: {
  -      disableRipple: true,
  -    },
  -  },
  +  components: {
  +    MuiButton: {
  +      defaultProps: {
  +        disableRipple: true,
  +      },
  +    },
  +  },
  });
  ```

  2. `overrides`

  ```diff
  import { createMuiTheme } from '@material-ui/core/styles';

  const theme = createMuiTheme({
  -  overrides: {
  -    MuiButton: {
  -      root: { padding: 0 },
  -    },
  -  },
  +  components: {
  +    MuiButton: {
  +      styleOverrides: {
  +        root: { padding: 0 },
  +      },
  +    },
  +  },
  });
  ```

  Note that if you don't have the time to upgrade the structure of the theme, you
  can use the `adaptV4Theme()` adapter.

- [GridList] Rename to ImageList (#22311) @mbrookes
- [GridList] Rename Tile to Item (#22385) @mbrookes
  Rename the `GridList` components to `ImageList` to align with the current Material Design naming.

  ```diff
  -import GridList from '@material-ui/core/GridList';
  -import GridListTile from '@material-ui/core/GridListTile';
  -import GridListTileBar from '@material-ui/core/GridListTileBar';
  +import ImageList from '@material-ui/core/ImageList';
  +import ImageListItem from '@material-ui/core/ImageListItem';
  +import ImageListItemBar from '@material-ui/core/ImageListItemBar';

  -<GridList>
  -  <GridListTile>
  +<ImageList>
  +  <ImageListItem>
      <img src="file.jpg" alt="Image title" />
  -    <GridListTileBar
  +    <ImageListItemBar
        title="Title"
        subtitle="Subtitle"
      />
  -  </GridListTile>
  -</GridList>
  +  </ImageListItem>
  +</ImageList>
  ```

#### Changes

- [Breadcrumbs] Fix wrong role usage (#22366) @fakeharahman
- [Breadcrumbs] More robust focus capture (#22374) @eps1lon
- [ButtonBase] Reset box-sizing to border-box (#22316) @su8ru
- [Dialog] Fix unexpected close when releasing click on backdrop (#22310) @danbrud
- [Divider] Add text in divider (#22285) @ShehryarShoukat96
- [Slider] Respect disabled property when already focused (#22247) @pireads
- [Tabs] Don't fire onChange if current value (#22381) @jjoselv
- [Tabs] Improve focus management on list with no active tabs (#22377) @alexmotoc
- [theme] Add theme.mixins.gutters() in adaptV4Theme (#22396) @mnajdova
- [Tooltip] Improve readability (#22340) @oliviertassinari
- [Tooltip] Meet dismissable WCAG criterion (#22376) @eps1lon
- [l10n] Improve th-TH locale (#22350) @vimutti77

### `@material-ui/lab@v5.0.0-alpha.8`

- [docs] Add IntelliSense for each class in the `classes` prop (#22312) @eps1lon

### `@material-ui/styles@v5.0.0-alpha.8`

- [theme] Restructure component definitions (#22293) @mnajdova

### `@material-ui/utils@v5.0.0-alpha.8`

- [core] Move utils package to TypeScript (#22367) @oliviertassinari

### Docs

- [docs] Add Content Security Policy guide (#22383) @tjg37
- [docs] Add IntelliSense for each class in the `classes` prop (#22312) @eps1lon
- [docs] Add links in the header (#22210) @oliviertassinari
- [docs] Fix Argos-ci 404 link (#22362) @brunocechet
- [docs] Fix test README typo @mbrookes
- [docs] Forward x data-grid (#22400) @oliviertassinari
- [docs] Transpile demo .ts files (#22388) @eps1lon
- [docs] Add Backstage to showcase (#22428) @stefanalund
- [docs] Update Fontsource installation instructions (#22431) @DecliningLotus

### Core

- [icons] Label them as vendored for GitHub (#22397) @oliviertassinari
- [test] DialogContent with testing-library (#22356) @baterson
- [test] DialogContentText with testing-library (#22357) @baterson
- [test] DialogTitle with testing-library (#22358) @baterson
- [test] Enable tests that weren't working in JSDOM (#22360) @eps1lon
- [test] Fix failing tests on Windows (#22369) @eps1lon
- [test] Update react 17 patch (#22391) @eps1lon
- [core] Add explicit dependency on `@types/yargs` (#22339) @eps1lon
- [core] Add useEnhancedEffect module (#22317) @oliviertassinari
- [core] Batch small changes (#22314) @oliviertassinari
- [core] Fix setRef types (#22389) @Luchanso
- [core] Include TypeScript definitions in GitHub source (#22282) @oliviertassinari
- [core] Refactor how we ignore default values in docs (#22355) @eps1lon
- [core] Update SECURITY.md to account for v5 @oliviertassinari

## 5.0.0-alpha.7

###### _Aug 22, 2020_

Big thanks to the 22 contributors who made this release possible.
Here are some highlights ✨:

- 💎 A new diamond sponsor: [Octopus](https://octopus.com/), thank you!
- ⚛️ Migrate parts of the codebase to TypeScript (#22295, #22280, #22179, #22195) @rothbart, @eps1lon, @oliviertassinari.
- 💅 Add support for custom variant to most of the components (9 new components in this release) @mnajdova
- ⚛️ Keep working on React 17 support (#22270, #22262) @eps1lon
- And many more 🐛 bug fixes and 📚 improvements.

### `@material-ui/core@v5.0.0-alpha.7`

### Breaking changes

- [Menu] Remove transition onX props (#22212) @mbrookes
  The onE\* transition props were removed. Use TransitionProps instead.

  ```diff
  <Menu
  -  onEnter={onEnter}
  -  onEntered={onEntered},
  -  onEntering={onEntered},
  -  onExit={onEntered},
  -  onExited={onEntered},
  -  onExiting={onEntered}
  +  TransitionProps={{
  +    onEnter,
  +    onEntered,
  +    onEntering,
  +    onExit,
  +    onExited,
  +    onExiting,
  +  }}
  >
  ```

- [Popover] Remove transition onX props (#22184) @mbrookes
  The onE\* transition props were removed. Use TransitionProps instead.

  ```diff
  <Popover
  -  onEnter={onEnter}
  -  onEntered={onEntered},
  -  onEntering={onEntered},
  -  onExit={onEntered},
  -  onExited={onEntered},
  -  onExiting={onEntered}
  +  TransitionProps={{
  +    onEnter,
  +    onEntered,
  +    onEntering,
  +    onExit,
  +    onExited,
  +    onExiting,
  +  }}
  />
  ```

- [TextField] Improve line-height reset (#22149) @imnasnainaec
  Increase the line-height by 4px to support long descender on special alphabets.
  If you were overriding the input vertical padding, reduce it by 4px.

### Changes

- [Accordion] Fix scroll anchoring (#22292) @brickmaker17
- [colorManipulator] Add support for CSS Color Module Level 4 (#20790) @marcosvega91
- [Divider] Custom variant (#22182) @mnajdova
- [Fab] Custom variant (#22189) @mnajdova
- [l10n] Add Thai (th-TH) locale (#22242) @smoogi
- [l10n] Improve ja-JP locale (#22287) @chelproc
- [Link] Custom variant (#22204) @mnajdova
- [Paper] Custom variant (#22216) @mnajdova
- [Slider] Improve touch passive event handling (#22269) @mikhalev-im
- [Stepper] Fix spacing without StepContent (#22199) @Floriferous
- [SwipeableDrawer] Fix prevented inner scroll (#22254) @BramKaashoek
- [Tabs] Add aria-orientation of vertical (#22291) @eps1lon
- [Tabs] Document how to make scroll icons visible (#22255) @Sorgrum
- [TextField] Add hidden label to multi-line filled textfield (#22284) @fakeharahman
- [Toolbar] Custom variant (#22217) @mnajdova
- [TrapFocus] Entangle effects (#22155) @eps1lon
- [TrapFocus] Fix compatibility issues with React 17 (#22270) @eps1lon
- [TrapFocus] Prevent possible crash in React 17 (#22262) @eps1lon

### `@material-ui/icons@v5.0.0-alpha.7`

- [icons] Synchronize icons (#22186) @oliviertassinari

### `@material-ui/styles@v5.0.0-alpha.7`

- [core] Change children to be optional (#22134) @suliskh

### `@material-ui/lab@v5.0.0-alpha.7`

- [Alert] Custom variant (#22218) @mnajdova
- [Pagination] Custom variant (#22220, #22219) @mnajdova
- [Skeleton] Custom variant (#22243) @mnajdova
- [SpeedDial] Add support for uncontrolled open state (#22248) @akharkhonov
- [Timeline] Custom variant (#22244) @mnajdova

### Docs

- [docs] Add Design resources in installation (#22209) @oliviertassinari
- [docs] Add Octopus diamond sponsor (#22177) @oliviertassinari
- [docs] Better track usage of icons (#22187) @oliviertassinari
- [docs] Change property/properties to prop/props (#22271) @mbrookes
- [docs] Document TextField helperText height (#22146) @morgan-sam
- [docs] Fix `@global` being considered a class (#22297) @eps1lon
- [docs] Fix a typo on TextField components (#22300) @Renfrew
- [docs] Fix use of removed transition onE\* props (#22286) @mbrookes
- [docs] Improve codesandbox generation logic (#22221) @oliviertassinari
- [docs] Migrate Onepirate to TypeScript (#22295) @rothbart
- [docs] Migrate Dashboard template to TypeScript (#22280) @oliviertassinari
- [docs] Fix minimizing-bundle-size.md (#22298) @Primajin

### Core

- [core] Batch small changes (#22183) @oliviertassinari
- [core] Change children to be optional (#22134) @suliskh
- [test] Clear fake timers only in afterEach hook (#22307) @dmtrKovalenko
- [test] Convert initMatchers to TypeScript (#22179) @eps1lon
- [test] Improve toHaveVirtualFocus error message (#22185) @eps1lon
- [test] Lint fix the custom rules plugin for useThemeVariants (#22192) @mnajdova
- [test] Make all tests runnable with React 17 (#22290) @eps1lon
- [test] Prevent swallowing errors during setup (#22196) @eps1lon
- [test] Setup infra for tests in TypeScript (#22195) @eps1lon
- [test] Update react next patch (#22260) @eps1lon

## 5.0.0-alpha.6

###### _Aug 13, 2020_

Big thanks to the 26 contributors who made this release possible.
Here are some highlights ✨:

- 💅 Introduce a new dynamic variant API (#21648) @mnajdova.
  This API allows developers to add new variants on the Material-UI's components right from the theme, without having to wrap the components.
  For instance with the Button:

  ```tsx
  // Define the style that should be applied, for specific props.
  const theme = createMuiTheme({
    variants: {
      MuiButton: [
        {
          props: { variant: 'dashed', color: 'secondary' },
          styles: {
            border: `4px dashed ${red[500]}`,
          },
        },
      ],
    },
  });

  // Retain type safety.
  declare module '@material-ui/core/Button/Button' {
    interface ButtonPropsVariantOverrides {
      dashed: true;
    }
  }

  // Enjoy!
  <Button variant="dashed" />;
  ```

  More details in [the documentation](https://material-ui.com/customization/components/#adding-new-component-variants) and [RFC](#21749).

- 👮 Add documentation for the [TrapFocus](https://next.material-ui.com/components/trap-focus/) component (#22062) @oliviertassinari.
- ⚛️ Prepare support for React v17 (#22093, #22105, #22143, #22111) @eps1lon.
- 🚧 We have undertaken breaking changes.

### `@material-ui/core@v5.0.0-alpha.6`

### Breaking changes

- [Avatar] Rename variant circle -> circular for consistency (#22015) @kodai3
  Rename `circle` to `circular` for consistency. The possible values should be adjectives, not nouns:

  ```diff
  -<Avatar variant="circle">
  +<Avatar variant="circular">
  ```

- [Badge] Rename overlap circle -> circular and rectangle -> rectangular for consistency (#22050) @kodai3
  Rename `circle` to `circular` and `rectangle` to `rectangular` for consistency. The possible values should be adjectives, not nouns:

  ```diff
  -<Badge overlap="circle">
  -<Badge overlap="rectangle">
  +<Badge overlap="circular">
  +<Badge overlap="rectangular">
  ```

- [CircularProgress] Remove static variant, simplify determinate (#22060) @mbrookes
  The `static` variant has been merged into the `determinate` variant, with the latter assuming the appearance of the former.
  The removed variant was rarely useful. It was an exception to Material Design, and was removed from the specification.

  ```diff
  -<CircularProgress variant="determinate" />
  ```

  ```diff
  -<CircularProgress variant="static" classes={{ static: 'className' }} />
  +<CircularProgress variant="determinate" classes={{ determinate: 'className' }} />
  ```

- [Dialog] Remove transition onX props (#22113) @mbrookes
  The onE\* transition props were removed. Use TransitionProps instead.

  ```diff
  <Dialog
  -  onEnter={onEnter}
  -  onEntered={onEntered},
  -  onEntering={onEntered},
  -  onExit={onEntered},
  -  onExited={onEntered},
  -  onExiting={onEntered}
  +  TransitionProps={{
  +    onEnter,
  +    onEntered,
  +    onEntering,
  +    onExit,
  +    onExited,
  +    onExiting,
  +  }}
  />
  ```

- [Fab] Rename round -> circular for consistency (#21903) @kodai3
  Rename `round` to `circular` for consistency. The possible values should be adjectives, not nouns:

  ```diff
  -<Fab variant="round">
  +<Fab variant="circular">
  ```

- [List] Improve hover/select/focus UI display (#21930) @joshwooding
- [Pagination] Rename round -> circular for consistency (#22009) @kodai3
  Rename `round` to `circular` for consistency. The possible values should be adjectives, not nouns:

  ```diff
  -<Pagination shape="round">
  -<PaginationItem shape="round">
  +<Pagination shape="circular">
  +<PaginationItem shape="circular">
  ```

- [RootRef] Remove component (#21974) @eps1lon
  This component was removed. You can get a reference to the underlying DOM node of our components via `ref` prop.
  The component relied on [`ReactDOM.findDOMNode`](https://reactjs.org/docs/react-dom.html#finddomnode) which is [deprecated in `React.StrictMode`](https://reactjs.org/docs/strict-mode.html#warning-about-deprecated-finddomnode-usage).

  ```diff
  -<RootRef rootRef={ref}>
  -  <Button />
  -</RootRef>
  +<Button ref={ref} />
  ```

- [Snackbar] Change the default position on desktop (#21980) @kodai3
  The notification now displays at the bottom left on large screens.
  It better matches the behavior of Gmail, Google Keep, material.io, etc.
  You can restore the previous behavior with:

  ```diff
  -<Snackbar />
  +<Snackbar anchorOrigin={{ vertical: 'bottom', horizontal: 'center' }} />
  ```

- [Snackbar] Remove transition onX props (#22107) @mbrookes
  The onE\* transition props were removed. Use TransitionProps instead.

  ```diff
  <Snackbar
  -  onEnter={onEnter}
  -  onEntered={onEntered},
  -  onEntering={onEntered},
  -  onExit={onEntered},
  -  onExited={onEntered},
  -  onExiting={onEntered}
  +  TransitionProps={{
  +    onEnter,
  +    onEntered,
  +    onEntering,
  +    onExit,
  +    onExited,
  +    onExiting,
  +  }}
  />
  ```

- [TextareaAutosize] Rename rowsMax->maxRows & rowsMin->minRows (#21873) @mhayk
  Rename `rowsMin`/`rowsMax` prop with `mi Rows`/`maxRows` for consistency with HTML attributes.

  ```diff
  -<TextField rowsMax={6}>
  -<TextareAutosize rowsMin={1}>
  -<TextareAutosize rowsMax={6}>
  +<TextField maxRows={6}>
  +<TextareAutosize minRows={1}>
  +<TextareAutosize maxRows={6}>
  ```

- [TextField] Better isolate static textarea behavior to dynamic one (#21995) @AxartInc
  Better isolate the fixed textarea height behavior to the dynamic one.
  You need to use the `rowsMin` prop in the following case:

  ```diff
  -<TextField rows={2} rowsMax={5} />
  +<TextField rowsMin={2} rowsMax={5} />
  ```

  Remove the `rows` prop, use the `rowsMin` prop instead.
  This change aims to clarify the behavior of the prop.

  ```diff
  -<TextareaAutosize rows={2} />
  +<TextareaAutosize rowsMin={2} />
  ```

- [theme] Remove theme.mixins.gutters (#22109) @joshwooding
  The abstraction hasn't proven to be used frequently enough to be valuable.

  ```diff
  -theme.mixins.gutters(),
  +paddingLeft: theme.spacing(2),
  +paddingRight: theme.spacing(2),
  +[theme.breakpoints.up('sm')]: {
  +  paddingLeft: theme.spacing(3),
  +  paddingRight: theme.spacing(3),
  +},
  ```

### Changes

- [Avatar] Custom variant (#22139) @mnajdova
- [Badge] Add missing class key (#22095) @kodai3
- [Badge] Custom variant (#22140) @mnajdova
- [Button] Improved variant type names & cleanup tests (#22010) @mnajdova
- [ButtonBase] Forward type to other components than 'button' (#22172) @eps1lon
- [ButtonGroup] Custom variant (#22160) @mnajdova
- [Chip] Custom variant (#22161) @mnajdova
- [CssBaseline] Add text size adjust property (#22089) @Tolsee
- [l10n] Add Greek (el-GR) locale (#21988) @tmanolat
- [Table] Cell small's right padding is bigger than medium (#22017) @adamlaurencik
- [TrapFocus] Add documentation (#22062) @oliviertassinari
- [Typography] Add custom variants support (#22006) @mnajdova
- [useIsFocusVisible] Remove focus-visible if focus is re-targetted (#22102) @eps1lon
- [core] Fix various potential issues with multiple windows (#22159) @scottander
- [core] Improve hook dependencies in useControlled.js (#21977) @roth1002

### `@material-ui/lab@v5.0.0-alpha.6`

### Breaking changes

- [Skeleton] Rename variant circle -> circular and rect -> rectangular for consistency (#22053) @kodai3
  Rename `circle` to `circular` and `rect` to `rectangular` for consistency. The possible values should be adjectives, not nouns:

  ```diff
  -<Skeleton variant="circle">
  -<Skeleton variant="rect">
  +<Skeleton variant="circular">
  +<Skeleton variant="rectangular">
  ```

### Changes

- [Autocomplete] Add support for "{label: string}" data type as a default for "options" (#21992) @DanailH
- [TreeView] Add disabled prop (#20133) @netochaves
- [TreeView] Simplify focus logic (#22098) @eps1lon
- [TreeView] Test current behavior of active item removal (#21720) @eps1lon
- [TreeView] Test selection behavior (#21901) @joshwooding

### `@material-ui/system@v5.0.0-alpha.6`

- [core] Bump csstype to 3.0.0 (#22048) @eps1lon

### Docs

- [docs] Add 'size' prop to ToggleButton API docs (#22052) @zenje
- [docs] Add ClassKeys migration description for Renaming API (#22061) @kodai3
- [docs] Add a label to the TreeView demos (#21900) @joshwooding
- [docs] Add missing JSDoc for various props (#22005) @eps1lon
- [docs] Add the services that support MUI in readme (#22137) @naineet
- [docs] Add trailingSlash: true (#22008) @oliviertassinari
- [docs] Add visibility to TypeScript examples (#22013) @esemeniuc
- [docs] Avoid using any type in Tabs examples (#22091) @tacigar
- [docs] Bump next to 9.5.0 (#21975) @eps1lon
- [docs] Disallow undefined array members at runtime where they're unexpected (#21990) @eps1lon
- [docs] Improve Autocomplete GitHub demo (#22153) @aquibbaig
- [docs] Improve draggable dialog demo wording (#22021) @Sanskar95
- [docs] Improve transition props API descriptions (#21952) @maksimgm
- [docs] Port buildApi to TypeScript (#22055) @eps1lon
- [docs] Update build instructions for component API (#21970) @eps1lon
- [docs] Update grouped instruction of autocomplete (#22056) @yfng96
- [docs] Use `import * as React from 'react';` (#22058) @mbrookes
- [docs] Use pickers v4 (#22023) @eps1lon

### Core

- [core] Allow running prettier from material-ui-x (#22071) @oliviertassinari
- [core] Bump csstype to 3.0.0 (#22048) @eps1lon
- [core] Fix next and prevent future regressions (#22135) @eps1lon
- [core] Improve merge-conflict label automation (#22065) @eps1lon
- [core] Lint cleanup (#21972) @eps1lon
- [core] Resolve all dot-prop versions to 5.x (#22007) @eps1lon
- [core] Small changes (#22020) @oliviertassinari
- [Security] Bump elliptic from 6.5.0 to 6.5.3 (#21997) @dependabot-preview
- [test] Drop css-loader (#21999) @eps1lon
- [test] Lint framer workspace (#22002) @eps1lon
- [test] Lint useThemeVariants with custom rules plugin (#21963) @eps1lon
- [test] Run same tests in coverage and unit (#22092) @eps1lon
- [test] Type-check framerx package (#21868) @eps1lon
- [test] Work on React v17 (#22093, #22105, #22143, #22111) @eps1lon

## 5.0.0-alpha.5

###### _July 28, 2020_

Big thanks to the 18 contributors who made this release possible.

### `@material-ui/core@v5.0.0-alpha.5`

#### Breaking changes

- [Grid] Rename justify prop to justifyContent (#21845) @mnajdova

  Rename `justify` prop with `justifyContent` to be aligned with the CSS property name.

  ```diff
  -<Grid justify="center">
  +<Grid justifyContent="center">
  ```

#### Changes

- [Accordion] Add new classes key (#21920) @natac13
- [Accordion] Fix IconButtonProps spreading logic (#21850) @kgregory
- [Avatar] Fix group size (#21896) @natac13
- [Button] Custom variant (#21648) @mnajdova
- [CssBaseline] Export ScopedCssBaseline from barrel index (#21869) @mherczeg
- [Dialog] Fix body scrollbar close behavior (#21951) @maksimgm
- [Icon] Hide name placeholder while "Material Icons" font is loading (#21950) @maksimgm
- [Select] Ensure that onChange is called before onClose (#21878) @DanailH
- [Slider] Make `index` public in the ValueLabel props (#21932) @govardhan-srinivas

### `@material-ui/lab@v5.0.0-alpha.5`

- [TreeView] Change focus management to aria-activedescendant (#21695) @joshwooding
- [TreeView] Fix crash when shift clicking a clean tree (#21899) @joshwooding

### Framer

- [framer] Refactor as switch (#21885) @mhkasif
- [framer] Update with latest sources (#21888) @eps1lon

### Docs

- [blog] Q2 2020 Update (#21822) @oliviertassinari
- [docs] Add expand all and select all to controlled tree demo (#21929) @joshwooding
- [docs] Add useRadioGroup section (#21910) @kodai3
- [docs] Autocomplete is not showing options even though they exist (#21949) @maksimgm
- [docs] Change the destination branch for PRs (#21870) @DanailH
- [docs] Fix Skeleton inline example (#21918) @ppecheux
- [docs] Fix custom Snackbar width on mobile (#21948) @ruhci28
- [docs] Fix the type of the second argument of 'createMuiTheme' function (#21859) @DanailH
- [docs] Improve ad display @oliviertassinari
- [docs] Improve documentation of theme.breakpoints (#21922) @ruhci28
- [docs] Link react-hook-form (#21886) @jeffshek
- [docs] Mention @MuiContrib in CONTRIBUTING (#21891) @eps1lon
- [docs] Replace latests tags with next in the codesandbox (#21851) @mnajdova
- [docs] Update gold sponsor to Text-Em-All (formerly Call-Em-All) (#21897) @jonmiller0
- [docs] Update testing guide (#21863) @eps1lon

### Core

- [test] Enable more StrictMode tests (#21817) @eps1lon
- [test] Lint internal typescript-to-proptypes fork (#21876) @eps1lon
- [test] Pass didWarnControlledToUncontrolled between tests (#21875) @eps1lon
- [test] Unify import to `test/utils (#21856) @eps1lon
- [core] Add warnings where ref-forwarding components/elements are required (#21883) @eps1lon
- [core] Automatically tweet about good first issues (#21879) @eps1lon
- [core] Batch small changes (#21928) @oliviertassinari
- [core] Remove /test-utils (#21855) @eps1lon
- [core] Throw on unused `typescript-to-proptypes-ignore` directives (#21867) @eps1lon

## 5.0.0-alpha.4

###### _July 19, 2020_

Big thanks to the 11 contributors who made this release possible.

### `@material-ui/core@v5.0.0-alpha.4`

#### Breaking changes

- [core] Drop support for non-ref-forwarding class components (#21811) @eps1lon
  Support for non-ref-forwarding class components in the `component` prop or as an immediate `children` has been dropped. If you were using `unstable_createStrictModeTheme` or didn't see any warnings related to `findDOMNode` in `React.StrictMode` then you don't need to do anything.
  Otherwise check out the ["Caveat with refs" section in our composition guide](/guides/composition/#caveat-with-refs) to find out how to migrate.
  This change affects almost all components where you're using the `component` prop or passing `children` to components that require `children` to be elements (e.g. `<MenuList><CustomMenuItem /></MenuList>`)
- [Stepper] Use context API (#21613) @baterson
  Rely on the context over the `React.cloneElement()` API.
  This change makes composition easier.

### `@material-ui/icons@v5.0.0-alpha.4`

- [icons] Add Google brand icon (#21807) @bmg02

### Docs

- [docs] Break up Select demos (#21792) @cjoecker
- [docs] Change RMUIF info to new version (#21812) @phoqe
- [docs] Fix Spanish translation (#21800) @adamsr123
- [docs] Fix nav color (#21780) @mbrookes
- [docs] Update advanced-de.md (#21786) @jasonericdavis

### Core

- [core] Allow dist tag as argv in use-react-dist-tag (#21810) @eps1lon
- [core] Drop support for non-ref-forwarding class components (#21811) @eps1lon
- [core] Lint with typescript-eslint parser (#21758) @oliviertassinari
- [core] One label is enough @oliviertassinari
- [core] Remove lint:fix command @oliviertassinari
- [test] Enable "missing act()"-warnings (#21802) @eps1lon
- [test] Improve stack trace for unexpected errors (#21818) @eps1lon
- [test] Update react next patch (#21746) @eps1lon
- [test] Use testing-library in withStyles (#21804) @eps1lon

## 5.0.0-alpha.3

###### _July 12, 2020_

Big thanks to the 14 contributors who made this release possible.

### `@material-ui/core@v5.0.0-alpha.3`

- [Avatar] Avoid usage of z-index (#21685) @nvdai2401
- [GridList] Fix crash when loading images (#21741) @paradoxxxzero
- [List] Fix secondary action position when disableGutters={true} (#21732) @kgregory
- [TablePagination] Fix broken labelling if SelectProps provided ids (#21703) @eps1lon
- [theme] Fix custom breakpoint in CSS Media Queries (#21759) @nkrivous
- [TrapFocus] Fix disableAutoFocus prop (#21612) @oliviertassinari

### `@material-ui/lab@v5.0.0-alpha.3`

- [lab] Fix TypeScript theme overrides support (#21724) @cjoecker
- [Autocomplete] Fail form validation if required is filled when `multiple` (#21692, #21670) @weslenng, @eps1lon

### Docs

- [examples] Include troubleshooting for next.js (#21683) @ocavue
- [docs] Add ethicalads.io (#21752) @oliviertassinari
- [docs] Apply small fixes (#21754) @jaironalves
- [docs] Batch small changes (#21669) @oliviertassinari
- [docs] Bump next to 9.4.4 (#21690) @eps1lon
- [docs] Fix custom switch ripple color (#21729) @xanderoku
- [docs] Fix text from showcase (#21755) @cjoecker
- [docs] Improve customized timeline demo (#21739) @mageprincess
- [docs] Move more prop docs into IntelliSense (#21659) @eps1lon
- [docs] Move more prop docs into IntelliSense (#21687) @eps1lon
- [docs] Recommend default branch (#21719) @eps1lon
- [docs] Remove `@document` directive from IntelliSense (#21688) @eps1lon
- [docs] Track web-vitals (#21702) @eps1lon

### Core

- [test] Allow container + hydrate in render (#21747) @eps1lon
- [test] Bump url-loader (#21689) @eps1lon
- [test] Restore clock between each test (#21760) @eps1lon
- [test] Run lab unit tests in browser (#21691) @eps1lon
- [core] Allow generating markdown api docs for subset of components (#21731) @eps1lon
- [core] Batch small changes (#21756) @oliviertassinari
- [core] Don't bail out early if docs:api fails (#21726) @eps1lon
- [core] Remove dead code from docs:api (#21730) @eps1lon
- [core] Simplify debounce (#21666) @NMinhNguyen
- [core] Use common yarn version (#21779) @eps1lon

## 5.0.0-alpha.2

###### _July 4, 2020_

Big thanks to the 16 contributors who made this release possible.

### `@material-ui/core@v5.0.0-alpha.2`

#### Breaking changes

- [Button] Make primary the default color (#21594) @mbrookes
  The button `color` prop is now "primary" by default, and "default" has been removed. This makes the button closer to the Material Design specification and simplifies the API.

  ```diff
  -<Button color="default" />
  -<Button color="primary" />
  +<Button />
  +<Button />
  ```

- [ExpansionPanel] Remove component (#21630) @mnajdova
  This completes our effort on renaming the ExpansionPanel component Accordion
- [Collapse] Add orientation and horizontal support (#20619) @darkowic
  The `collapsedHeight` prop was renamed `collapsedSize` to support the horizontal direction.

  ```diff
  -<Collapse collapsedHeight={40}>
  +<Collapse collapsedSize={40}>
  ```

#### Changes

- [Card] Fix vertically center header action (#21646) @kgregory
- [l10n] Update cs-CZ and sk-SK locales (#21656) @char0n
- [l10n] Update sv-SE locale (#21631) @tbz
- [Menu] Remove overflow style in MenuItem (#21644) @tj3407
- [MenuItem] Add types for ListItemClasses (#21654) @eps1lon
- [Slider] Fix cannot read property 'focus' of null (#21653) @mageprincess
- [TextField] Fix CSS isolation issue (#21665) @Codetalker777
- [TrapFocus] Fix portal support (#21610) @mnajdova
- [TypeScript] Fix version support (#21640) @jakubfiglak

### `@material-ui/lab@v5.0.0-alpha.2`

- [TreeView] Improve node registration and fix other issues (#21574) @joshwooding

### Docs

- [blog] Post survey results 2020 (#21555) @mnajdova
- [docs] Add new showcase (#21637) @cjoecker
- [docs] CodeFund is shutting down (#21632) @oliviertassinari
- [docs] Document next version (#21591) @oliviertassinari
- [docs] Enable docs search on v5.0.0 & fix duplicate on master @oliviertassinari
- [docs] Fix ad issues @oliviertassinari
- [docs] Move more prop docs into IntelliSense (#21655) @eps1lon
- [docs] Remove in-context translation code & files (#21633) @mbrookes
- [example] Remove dead dependency from next-typescript (#21628) @StefanWerW

### Core

- [test] Add toWarnDev() and toErrorDev() matcher (#21581) @eps1lon

## 5.0.0-alpha.1

###### _June 27, 2020_

Big thanks to the 33 contributors who made this release possible. Here are some highlights ✨:

- 🔄 Introduce a new `LoadingButton` component in the lab (#21389) @mnajdova.
- 📍 Synchronize icons with Google, add 200 new icons (#21498) @alecananian
- 💥 Start working on breaking changes.

### `@material-ui/core@v5.0.0-alpha.1`

#### Breaking changes

- [Divider] Use border instead of background color (#18965) @mikejav.
  It prevents inconsistent height on scaled screens. For people customizing the color of the border, the change requires changing the override CSS property:

  ```diff
  .MuiDivider-root {
  - background-color: #f00;
  + border-color: #f00;
  }
  ```

- [Rating] Rename `visuallyhidden` to `visuallyHidden` for consistency (#21413) @mnajdova.

  ```diff
  <Rating
    classes={{
  -    visuallyhidden: 'custom-visually-hidden-classname',
  +    visuallyHidden: 'custom-visually-hidden-classname',
    }}
  />
  ```

- [Typography] Replace the `srOnly` prop so as to not duplicate the capabilities of [System](https://material-ui.com/system/basics/) (#21413) @mnajdova.

  ```diff
  -import Typography from '@material-ui/core/Typography';
  +import { visuallyHidden } from '@material-ui/utils';
  +import styled from 'styled-component';

  +const Span = styled('span')(visuallyHidden);

  -<Typography variant="srOnly">Create a user</Typography>
  +<Span>Create a user</Span>
  ```

- [TablePagination] Add showFirstButton and showLastButton support (#20750) @ShahAnuj2610.
  The customization of the table pagination's actions labels must be done with the `getItemAriaLabel` prop. This increases consistency with the `Pagination` component.

  ```diff
  <TablePagination
  - backIconButtonText="Avant"
  - nextIconButtonText="Après
  + getItemAriaLabel={…}
  ```

- [ExpansionPanel] Rename to Accordion (#21494) @mnajdova.
  Use a more common the naming convention:

  ```diff
  -import ExpansionPanel from '@material-ui/core/ExpansionPanel';
  -import ExpansionPanelSummary from '@material-ui/core/ExpansionPanelSummary';
  -import ExpansionPanelDetails from '@material-ui/core/ExpansionPanelDetails';
  -import ExpansionPanelActions from '@material-ui/core/ExpansionPanelActions';
  +import Accordion from '@material-ui/core/Accordion';
  +import AccordionSummary from '@material-ui/core/AccordionSummary';
  +import AccordionDetails from '@material-ui/core/AccordionDetails';
  +import AccordionActions from '@material-ui/core/AccordionActions';

  -<ExpansionPanel>
  +<Accordion>
  -  <ExpansionPanelSummary>
  +  <AccordionSummary>
       <Typography>Location</Typography>
       <Typography>Select trip destination</Typography>
  -  </ExpansionPanelSummary>
  +  </AccordionSummary>
  -  <ExpansionPanelDetails>
  +  <AccordionDetails>
       <Chip label="Barbados" onDelete={() => {}} />
       <Typography variant="caption">Select your destination of choice</Typography>
  -  </ExpansionPanelDetails>
  +  </AccordionDetails>
     <Divider />
  -  <ExpansionPanelActions>
  +  <AccordionActions>
       <Button size="small">Cancel</Button>
       <Button size="small" color="primary">Save</Button>
  -  </ExpansionPanelActions>
  +  </AccordionActions>
  -</ExpansionPanel>
  +</Accordion>
  ```

- [BottomNavigation] typescript: The `event` in `onChange` is no longer typed as a `React.ChangeEvent` but `React.SyntheticEvent`.

  ```diff
  -<BottomNavigation onChange={(event: React.ChangeEvent<{}>) => {}} />
  +<BottomNavigation onChange={(event: React.SyntheticEvent) => {}} />
  ```

- [Slider] typescript: The `event` in `onChange` is no longer typed as a `React.ChangeEvent` but `React.SyntheticEvent`.

  ```diff
  -<Slider onChange={(event: React.ChangeEvent<{}>, value: unknown) => {}} />
  +<Slider onChange={(event: React.SyntheticEvent, value: unknown) => {}} />
  ```

- [Tabs] typescript: The `event` in `onChange` is no longer typed as a `React.ChangeEvent` but `React.SyntheticEvent`.

  ```diff
  -<Tabs onChange={(event: React.ChangeEvent<{}>, value: unknown) => {}} />
  +<Tabs onChange={(event: React.SyntheticEvent, value: unknown) => {}} />
  ```

- [Accordion] typescript: The `event` in `onChange` is no longer typed as a `React.ChangeEvent` but `React.SyntheticEvent`.
  ```diff
  -<Accordion onChange={(event: React.ChangeEvent<{}>, expanded: boolean) => {}} />
  +<Accordion onChange={(event: React.SyntheticEvent, expanded: boolean) => {}} />
  ```

#### Changes

- [Badge] Fix transition flicker (#21557) @mnajdova
- [ButtonGroup] Improve contained hover style (#21532) @alecananian
- [l10n] Improve Russian translation (#21480) @AntonLukichev
- [l10n] Improve zh-CN, add zh-TW (#21493) @Jack-Works
- [LinearProgress] High frequency updates (#21416) @dnicerio
- [Stepper] Fix optional label alignment (#21420) @curtislin7
- [Table] Move prop docs into IntelliSense (#21530) @oliviertassinari
- [TablePagination] Add showFirstButton and showLastButton support (#20750) @ShahAnuj2610
- [Tabs] Fix useCallback missing arguments (#21471) @KitsonBroadhurst
- [TextField] Fix FilledInput disable hover style when disabled (#21457) @tchmnn

### `@material-ui/lab@v5.0.0-alpha.1`

- [Autocomplete] Fix support for renderTags={() => null} (#21460) @matthenschke
- [LoadingButton] Introduce new component (#21389) @mnajdova
- [Pagination] Fix display when boundaryCount={0} (#21446) @guimacrf
- [Skeleton] Fix text border (#21543) @el1f
- [Timeline] Align dots with content (#21402) @mnajdova
- [TreeView] Minor styling changes (#21573) @joshwooding
- [TreeView] Simplify customization (#21514) @joshwooding

### `@material-ui/icons@v5.0.0-alpha.1`

- [icons] Synchronize icons with Google (#21498) @alecananian

### `@material-ui/system@v5.0.0-alpha.1`

- [system] Introduce visuallyHidden style utility (#21413) @mnajdova

### Docs

- [docs] Add CSP support section to docs (#21479) @razor-x
- [docs] Add explicit example for extending existing palette colors (#21458) @BennyHinrichs
- [docs] Add more details about breakpoint widths (#21545) @Muzietto
- [docs] Add new gold sponsor @oliviertassinari
- [docs] Add transitions customization page (#21456) @mnajdova
- [docs] Correct syntax errors to improve document readability (#21515) @AGDholo
- [docs] Document type="number" limitation (#21500) @IwalkAlone
- [docs] Entry for translations and fix grammar error (#21478) @jaironalves
- [docs] Fix broken "customization" anchor link (#21506) @connorads
- [docs] Fix typo in MultipleSelects.js (#21510) @ShiyuCheng2018
- [docs] Fix typo in SpeedDialIcon classes comment (#21398) @zachbradshaw
- [docs] Fix typo in TextField required prop (#21538) @HumbertoL
- [docs] Fix version in localized urls (#21442) @tchmnn
- [docs] Format english markdown files (#21463) @eps1lon
- [docs] Format some previously unformatted, untranslated files (#21558) @eps1lon
- [docs] Hide duplicate table borders (#20809) @marcosvega91
- [docs] Improve docs for useMediaQuery and breakpoint (#21512) @DDDDDanica
- [docs] Improve npm homepage links (#21452) @eps1lon
- [docs] Move more prop docs into IntelliSense (#21383) @eps1lon
- [docs] Restrict docs markdown and demos to 80ch (#21481) @eps1lon
- [docs] Reword palette intention and fix format (#21477) @DDDDDanica
- [docs] Update v4 migration guide (#21462) @eps1lon

### Core

- [typescript-to-proptypes] Integrate into monorepo @eps1lon
- [test] Add type test CardHeader title component (#21590) @eps1lon
- [test] Fix type tests not being type checked (#21539) @eps1lon
- [test] Ignore empty vrtests (#21450) @eps1lon
- [test] Improve makeStyles error coverage (#21568) @eps1lon
- [test] Migrate Typography to testing-library (#21534) @marcosvega91
- [test] Move size comparison details to separate page (#21504) @eps1lon
- [test] Use testing-library in MenuItem (#21391) @eps1lon
- [test] Use testing-library in StepButton (#21406) @baterson
- [test] Use testing-library in Stepper (#21400) @baterson
- [core] Batch small changes (#21419) @oliviertassinari
- [core] Batch small changes (#21553) @oliviertassinari
- [core] Disable caching for yarn proptypes permanently (#21414) @eps1lon
- [core] Extend env for build script (#21403) @eps1lon
- [core] Fix react next patch and prevent regression (#21495) @eps1lon
- [core] Fork typescript-to-proptypes (#21497) @eps1lon
- [core] Misc branch cleaning (#21459) @eps1lon
- [core] Misc prettier changes (#21484) @eps1lon
- [core] Run prettier on the JSON sources (#21556) @oliviertassinari
- [core] Type custom `onChange` implementations with a generic react event (#21552) @eps1lon

## Older versions

Changes before 5.x are listed in our [changelog for older versions](https://github.com/mui-org/material-ui/blob/HEAD/CHANGELOG.old.md).
