import { OverrideProps } from '@material-ui/types';
import * as React from 'react';
export declare type NativeFormControlElement = HTMLInputElement | HTMLTextAreaElement | HTMLSelectElement;
export interface FormControlUnstyledOwnProps {
    /**
     * The content of the component.
     */
    children?: React.ReactNode;
    /**
     * Class name applied to the root element.
     */
    className?: string;
    /**
     * The components used for each slot inside the FormControl.
     * Either a string to use a HTML element or a component.
     * @default {}
     */
    components?: {
        Root?: React.ElementType;
    };
    componentsProps?: {
        root?: object;
    };
    defaultValue?: unknown;
    /**
     * If `true`, the label, input and helper text should be displayed in a disabled state.
     * @default false
     */
    disabled?: boolean;
    /**
     * If `true`, the label is displayed in an error state.
     * @default false
     */
    error?: boolean;
    /**
     * Extra properties to be placed on the FormControlContext.
     * @default {}
     */
    extraContextProperties?: object;
    /**
     * If `true`, the component is displayed in focused state.
     * @default false
     */
    focused?: boolean;
    onChange?: React.ChangeEventHandler<NativeFormControlElement>;
    /**
     * If `true`, the label will indicate that the `input` is required.
     * @default false
     */
    required?: boolean;
    value?: unknown;
}
export interface FormControlUnstyledTypeMap<P = {}, D extends React.ElementType = 'div'> {
    props: P & FormControlUnstyledOwnProps;
    defaultComponent: D;
}
declare type FormControlUnstyledProps<D extends React.ElementType = FormControlUnstyledTypeMap['defaultComponent'], P = {}> = OverrideProps<FormControlUnstyledTypeMap<P, D>, D> & {
    /**
     * The component used for the Root slot.
     * Either a string to use a HTML element or a component.
     * This is equivalent to `components.Root`. If both are provided, the `component` is used.
     */
    component?: D;
};
export default FormControlUnstyledProps;
