import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import * as React from 'react';
import PropTypes from 'prop-types';
import clsx from 'clsx';
import { unstable_capitalize as capitalize, usePreviousProps } from '@material-ui/utils';
import isHostComponent from '../utils/isHostComponent';
import composeClasses from '../composeClasses';
import { getBadgeUtilityClass } from './badgeUnstyledClasses';
import { jsx as _jsx } from "react/jsx-runtime";
import { jsxs as _jsxs } from "react/jsx-runtime";

var useUtilityClasses = function useUtilityClasses(ownerState) {
  var variant = ownerState.variant,
      anchorOrigin = ownerState.anchorOrigin,
      overlap = ownerState.overlap,
      invisible = ownerState.invisible,
      classes = ownerState.classes;
  var slots = {
    root: ['root'],
    badge: ['badge', variant, "anchorOrigin".concat(capitalize(anchorOrigin.vertical)).concat(capitalize(anchorOrigin.horizontal)).concat(capitalize(overlap)), invisible && 'invisible']
  };
  return composeClasses(slots, getBadgeUtilityClass, classes);
};

var BadgeUnstyled = /*#__PURE__*/React.forwardRef(function BadgeUnstyled(props, ref) {
  var _props$anchorOrigin = props.anchorOrigin,
      anchorOriginProp = _props$anchorOrigin === void 0 ? {
    vertical: 'top',
    horizontal: 'right'
  } : _props$anchorOrigin,
      classesProp = props.classes,
      badgeContentProp = props.badgeContent,
      _props$component = props.component,
      component = _props$component === void 0 ? 'span' : _props$component,
      children = props.children,
      className = props.className,
      _props$components = props.components,
      components = _props$components === void 0 ? {} : _props$components,
      _props$componentsProp = props.componentsProps,
      componentsProps = _props$componentsProp === void 0 ? {} : _props$componentsProp,
      invisibleProp = props.invisible,
      _props$max = props.max,
      maxProp = _props$max === void 0 ? 99 : _props$max,
      _props$overlap = props.overlap,
      overlapProp = _props$overlap === void 0 ? 'rectangular' : _props$overlap,
      _props$showZero = props.showZero,
      showZero = _props$showZero === void 0 ? false : _props$showZero,
      _props$variant = props.variant,
      variantProp = _props$variant === void 0 ? 'standard' : _props$variant,
      theme = props.theme,
      other = _objectWithoutProperties(props, ["anchorOrigin", "classes", "badgeContent", "component", "children", "className", "components", "componentsProps", "invisible", "max", "overlap", "showZero", "variant", "theme"]);

  var prevProps = usePreviousProps({
    anchorOrigin: anchorOriginProp,
    badgeContent: badgeContentProp,
    max: maxProp,
    overlap: overlapProp,
    variant: variantProp
  });
  var invisible = invisibleProp;

  if (invisibleProp == null && (badgeContentProp === 0 && !showZero || badgeContentProp == null && variantProp !== 'dot')) {
    invisible = true;
  }

  var _ref = invisible ? prevProps : props,
      _ref$anchorOrigin = _ref.anchorOrigin,
      anchorOrigin = _ref$anchorOrigin === void 0 ? anchorOriginProp : _ref$anchorOrigin,
      badgeContent = _ref.badgeContent,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? maxProp : _ref$max,
      _ref$overlap = _ref.overlap,
      overlap = _ref$overlap === void 0 ? overlapProp : _ref$overlap,
      _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? variantProp : _ref$variant;

  var ownerState = _extends({}, props, {
    anchorOrigin: anchorOrigin,
    badgeContent: badgeContent,
    classes: classesProp,
    invisible: invisible,
    max: max,
    overlap: overlap,
    variant: variant
  });

  var displayValue = '';

  if (variant !== 'dot') {
    displayValue = badgeContent > max ? "".concat(max, "+") : badgeContent;
  }

  var classes = useUtilityClasses(ownerState);
  var Root = components.Root || component;
  var rootProps = componentsProps.root || {};
  var Badge = components.Badge || 'span';
  var badgeProps = componentsProps.badge || {};
  return /*#__PURE__*/_jsxs(Root, _extends({}, rootProps, !isHostComponent(Root) && {
    as: component,
    ownerState: _extends({}, ownerState, rootProps.ownerState),
    theme: theme
  }, {
    ref: ref
  }, other, {
    className: clsx(classes.root, rootProps.className, className),
    children: [children, /*#__PURE__*/_jsx(Badge, _extends({}, badgeProps, !isHostComponent(Badge) && {
      ownerState: _extends({}, ownerState, badgeProps.ownerState),
      theme: theme
    }, {
      className: clsx(classes.badge, badgeProps.className),
      children: displayValue
    }))]
  }));
});
process.env.NODE_ENV !== "production" ? BadgeUnstyled.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The anchor of the badge.
   * @default {
   *   vertical: 'top',
   *   horizontal: 'right',
   * }
   */
  anchorOrigin: PropTypes.shape({
    horizontal: PropTypes.oneOf(['left', 'right']).isRequired,
    vertical: PropTypes.oneOf(['bottom', 'top']).isRequired
  }),

  /**
   * The content rendered within the badge.
   */
  badgeContent: PropTypes.node,

  /**
   * The badge will be added relative to this node.
   */
  children: PropTypes.node,

  /**
   * Override or extend the styles applied to the component.
   */
  classes: PropTypes.object,

  /**
   * @ignore
   */
  className: PropTypes.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: PropTypes.elementType,

  /**
   * The components used for each slot inside the Badge.
   * Either a string to use a HTML element or a component.
   * @default {}
   */
  components: PropTypes.shape({
    Badge: PropTypes.elementType,
    Root: PropTypes.elementType
  }),

  /**
   * The props used for each slot inside the Badge.
   * @default {}
   */
  componentsProps: PropTypes.object,

  /**
   * If `true`, the badge is invisible.
   */
  invisible: PropTypes.bool,

  /**
   * Max count to show.
   * @default 99
   */
  max: PropTypes.number,

  /**
   * Wrapped shape the badge should overlap.
   * @default 'rectangular'
   */
  overlap: PropTypes.oneOf(['circular', 'rectangular']),

  /**
   * Controls whether the badge is hidden when `badgeContent` is zero.
   * @default false
   */
  showZero: PropTypes.bool,

  /**
   * The variant to use.
   * @default 'standard'
   */
  variant: PropTypes.string
} : void 0;
export default BadgeUnstyled;