// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/base/foundation
//   ../../@material/ripple/component
//   ../../@material/ripple/types

declare module '@material/chips' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    export * from '@material/chips/chip-set/index';
    /**
        * Backwards compatibility for existing clients.
        */
    import * as deprecated from '@material/chips/deprecated/index';
    export { deprecated, };
}

declare module '@material/chips/chip-set/index' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/chips/chip-set/adapter';
    export * from '@material/chips/chip-set/component';
    export * from '@material/chips/chip-set/constants';
    export * from '@material/chips/chip-set/foundation';
}

declare module '@material/chips/deprecated/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/chips/deprecated/trailingaction/index';
    export * from '@material/chips/deprecated/chip/index';
    export * from '@material/chips/deprecated/chip-set/index';
}

declare module '@material/chips/chip-set/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    import { Animation } from '@material/chips/chip/constants';
    import { Attributes, Events } from '@material/chips/chip-set/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipSetAdapter {
            /** Announces the message via an aria-live region */
            announceMessage(message: string): void;
            /** Emits the given event with the given detail. */
            emitEvent<D extends object>(eventName: Events, eventDetail: D): void;
            /** Returns the value for the given attribute, if it exists. */
            getAttribute(attrName: Attributes): string | null;
            /** Returns the actions provided by the child chip at the given index. */
            getChipActionsAtIndex(index: number): ActionType[];
            /** Returns the number of child chips. */
            getChipCount(): number;
            /** Returns the ID of the chip at the given index. */
            getChipIdAtIndex(index: number): string;
            /** Returns the index of the child chip with the matching ID. */
            getChipIndexById(chipID: string): number;
            /** Proxies to the MDCChip#isActionFocusable method. */
            isChipFocusableAtIndex(index: number, actionType: ActionType): boolean;
            /** Proxies to the MDCChip#isActionSelectable method. */
            isChipSelectableAtIndex(index: number, actionType: ActionType): boolean;
            /** Proxies to the MDCChip#isActionSelected method. */
            isChipSelectedAtIndex(index: number, actionType: ActionType): boolean;
            /** Removes the chip at the given index. */
            removeChipAtIndex(index: number): void;
            /** Proxies to the MDCChip#setActionFocus method. */
            setChipFocusAtIndex(index: number, action: ActionType, focus: FocusBehavior): void;
            /** Proxies to the MDCChip#setActionSelected method. */
            setChipSelectedAtIndex(index: number, actionType: ActionType, isSelected: boolean): void;
            /** Starts the chip animation at the given index. */
            startChipAnimationAtIndex(index: number, animation: Animation): void;
    }
}

declare module '@material/chips/chip-set/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { ActionType } from '@material/chips/action/constants';
    import { MDCChipFactory } from '@material/chips/chip/component';
    import { MDCChipSetFoundation } from '@material/chips/chip-set/foundation';
    /**
        * MDCChip provides component encapsulation of the foundation implementation.
        */
    export class MDCChipSet extends MDCComponent<MDCChipSetFoundation> {
            static attachTo(root: Element): MDCChipSet;
            initialize(chipFactory?: MDCChipFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCChipSetFoundation;
            /** Returns the index of the chip with the given ID or -1 if none exists. */
            getChipIndexByID(chipID: string): number;
            /**
                * Returns the ID of the chip at the given index or an empty string if the
                * index is out of bounds.
                */
            getChipIdAtIndex(index: number): string;
            /** Returns the unique indexes of the selected chips. */
            getSelectedChipIndexes(): ReadonlySet<number>;
            /** Sets the selection state of the chip. */
            setChipSelected(index: number, action: ActionType, isSelected: boolean): void;
            /** Returns the selection state of the chip. */
            isChipSelected(index: number, action: ActionType): boolean;
            /** Animates the chip addition at the given index. */
            addChip(index: number): void;
            /** Removes the chip at the given index. */
            removeChip(index: number): void;
    }
}

declare module '@material/chips/chip-set/constants' {
    /**
        * Events provides the named constants for strings used by the foundation.
        */
    export enum Attributes {
            ARIA_MULTISELECTABLE = "aria-multiselectable"
    }
    /**
        * CssClasses provides the named constants for class names.
        */
    export enum CssClasses {
            CHIP = "mdc-evolution-chip"
    }
    /**
        * Events provides the constants for emitted events.
        */
    export enum Events {
            INTERACTION = "MDCChipSet:interaction",
            REMOVAL = "MDCChipSet:removal",
            SELECTION = "MDCChipSet:selection"
    }
}

declare module '@material/chips/chip-set/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { ActionType } from '@material/chips/action/constants';
    import { MDCChipSetAdapter } from '@material/chips/chip-set/adapter';
    import { ChipAnimationEvent, ChipInteractionEvent, ChipNavigationEvent } from '@material/chips/chip-set/types';
    /**
        * MDCChipSetFoundation provides a foundation for all chips.
        */
    export class MDCChipSetFoundation extends MDCFoundation<MDCChipSetAdapter> {
            static get defaultAdapter(): MDCChipSetAdapter;
            constructor(adapter?: Partial<MDCChipSetAdapter>);
            handleChipAnimation({ detail }: ChipAnimationEvent): void;
            handleChipInteraction({ detail }: ChipInteractionEvent): void;
            handleChipNavigation({ detail }: ChipNavigationEvent): void;
            /** Returns the unique selected indexes of the chips. */
            getSelectedChipIndexes(): ReadonlySet<number>;
            /** Sets the selected state of the chip at the given index and action. */
            setChipSelected(index: number, action: ActionType, isSelected: boolean): void;
            /** Returns the selected state of the chip at the given index and action. */
            isChipSelected(index: number, action: ActionType): boolean;
            /** Removes the chip at the given index. */
            removeChip(index: number): void;
            addChip(index: number): void;
    }
    export default MDCChipSetFoundation;
}

declare module '@material/chips/deprecated/trailingaction/index' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/chips/deprecated/trailingaction/adapter';
    export * from '@material/chips/deprecated/trailingaction/component';
    export * from '@material/chips/deprecated/trailingaction/foundation';
    export * from '@material/chips/deprecated/trailingaction/types';
    export { strings as trailingActionStrings } from '@material/chips/deprecated/trailingaction/constants';
}

declare module '@material/chips/deprecated/chip/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/chips/deprecated/chip/adapter';
    export * from '@material/chips/deprecated/chip/component';
    export * from '@material/chips/deprecated/chip/foundation';
    export * from '@material/chips/deprecated/chip/types';
    export { cssClasses as chipCssClasses, strings as chipStrings } from '@material/chips/deprecated/chip/constants';
}

declare module '@material/chips/deprecated/chip-set/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/chips/deprecated/chip-set/adapter';
    export * from '@material/chips/deprecated/chip-set/component';
    export * from '@material/chips/deprecated/chip-set/foundation';
    export { cssClasses as chipSetCssClasses, strings as chipSetStrings } from '@material/chips/deprecated/chip-set/constants';
}

declare module '@material/chips/action/constants' {
    /**
        * CssClasses provides the classes to be queried and manipulated on the root.
        */
    export enum CssClasses {
            PRIMARY_ACTION = "mdc-evolution-chip__action--primary",
            TRAILING_ACTION = "mdc-evolution-chip__action--trailing",
            CHIP_ROOT = "mdc-evolution-chip"
    }
    /**
        * InteractionTrigger provides detail of the different triggers for action
        * interactions.
        */
    export enum InteractionTrigger {
            UNSPECIFIED = 0,
            CLICK = 1,
            BACKSPACE_KEY = 2,
            DELETE_KEY = 3,
            SPACEBAR_KEY = 4,
            ENTER_KEY = 5
    }
    /**
        * ActionType provides the different types of available actions.
        */
    export enum ActionType {
            UNSPECIFIED = 0,
            PRIMARY = 1,
            TRAILING = 2
    }
    /**
        * Events provides the different events emitted by the action.
        */
    export enum Events {
            INTERACTION = "MDCChipAction:interaction",
            NAVIGATION = "MDCChipAction:navigation"
    }
    /**
        * FocusBehavior provides configurations for focusing or unfocusing an action.
        */
    export enum FocusBehavior {
            FOCUSABLE = 0,
            FOCUSABLE_AND_FOCUSED = 1,
            NOT_FOCUSABLE = 2
    }
    /**
        * Attributes provides the HTML attributes used by the foundation.
        */
    export enum Attributes {
            ARIA_DISABLED = "aria-disabled",
            ARIA_HIDDEN = "aria-hidden",
            ARIA_SELECTED = "aria-selected",
            DATA_DELETABLE = "data-mdc-deletable",
            DISABLED = "disabled",
            ROLE = "role",
            TAB_INDEX = "tabindex"
    }
}

declare module '@material/chips/chip/constants' {
    /**
        * CssClasses provides the named constants for class names.
        */
    export enum CssClasses {
            SELECTING = "mdc-evolution-chip--selecting",
            DESELECTING = "mdc-evolution-chip--deselecting",
            SELECTING_WITH_PRIMARY_ICON = "mdc-evolution-chip--selecting-with-primary-icon",
            DESELECTING_WITH_PRIMARY_ICON = "mdc-evolution-chip--deselecting-with-primary-icon",
            DISABLED = "mdc-evolution-chip--disabled",
            ENTER = "mdc-evolution-chip--enter",
            EXIT = "mdc-evolution-chip--exit",
            SELECTED = "mdc-evolution-chip--selected",
            HIDDEN = "mdc-evolution-chip--hidden",
            WITH_PRIMARY_ICON = "mdc-evolution-chip--with-primary-icon"
    }
    /**
        * Events provides the named constants for emitted events.
        */
    export enum Events {
            INTERACTION = "MDCChip:interaction",
            NAVIGATION = "MDCChip:navigation",
            ANIMATION = "MDCChip:animation"
    }
    /**
        * Events provides the named constants for strings used by the foundation.
        */
    export enum Attributes {
            DATA_REMOVED_ANNOUNCEMENT = "data-mdc-removed-announcement",
            DATA_ADDED_ANNOUNCEMENT = "data-mdc-added-announcement"
    }
    /**
        * Animation provides the names of runnable animations.
        */
    export enum Animation {
            ENTER = "mdc-evolution-chip-enter",
            EXIT = "mdc-evolution-chip-exit"
    }
}

declare module '@material/chips/chip/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCChipActionFactory } from '@material/chips/action/component';
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    import { Animation } from '@material/chips/chip/constants';
    import { MDCChipFoundation } from '@material/chips/chip/foundation';
    /**
        * MDCChipFactory is used by the parent MDCChipSet component to initialize
        * chips.
        */
    export type MDCChipFactory = (el: Element, foundation?: MDCChipFoundation) => MDCChip;
    /**
        * MDCChip provides component encapsulation of the foundation implementation.
        */
    export class MDCChip extends MDCComponent<MDCChipFoundation> {
            static attachTo(root: Element): MDCChip;
            initialize(actionFactory?: MDCChipActionFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCChipFoundation;
            /** Exposed to be called by the parent chip set. */
            remove(): void;
            /** Returns the ActionTypes for the encapsulated actions. */
            getActions(): ActionType[];
            /** Returns the ID of the root element. */
            getElementID(): string;
            isDisabled(): boolean;
            setDisabled(isDisabled: boolean): void;
            /** Returns the focusability of the action. */
            isActionFocusable(action: ActionType): boolean;
            /** Returns the selectability of the action. */
            isActionSelectable(action: ActionType): boolean;
            /** Returns the selected state of the action. */
            isActionSelected(action: ActionType): boolean;
            /** Sets the focus behavior of the action. */
            setActionFocus(action: ActionType, focus: FocusBehavior): void;
            /** Sets the selected state of the action. */
            setActionSelected(action: ActionType, isSelected: boolean): void;
            /** Starts the animation on the chip. */
            startAnimation(animation: Animation): void;
    }
}

declare module '@material/chips/chip-set/types' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCChipAnimationEventDetail, MDCChipInteractionEventDetail, MDCChipNavigationEventDetail } from '@material/chips/chip/types';
    /**
        * MDCChipSetInteractionEventDetail provides detail about the interaction event.
        */
    export interface MDCChipSetInteractionEventDetail {
            chipID: string;
            chipIndex: number;
    }
    /**
        * MDCChipSetRemovalEventDetail provides detail about the removal event.
        */
    export interface MDCChipSetRemovalEventDetail {
            chipID: string;
            chipIndex: number;
            isComplete: boolean;
    }
    /**
        * MDCChipSetSelectionEventDetail provides detail about the selection event.
        */
    export interface MDCChipSetSelectionEventDetail {
            chipID: string;
            chipIndex: number;
            isSelected: boolean;
    }
    /**
        * ChipInteractionEvent is the custom event for the interaction event.
        */
    export type ChipInteractionEvent = CustomEvent<MDCChipInteractionEventDetail>;
    /**
        * ChipNavigationEvent is the custom event for the navigation event.
        */
    export type ChipNavigationEvent = CustomEvent<MDCChipNavigationEventDetail>;
    /**
        * ChipAnimationEvent is the custom event for the animation event.
        */
    export type ChipAnimationEvent = CustomEvent<MDCChipAnimationEventDetail>;
}

declare module '@material/chips/deprecated/trailingaction/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { InteractionTrigger } from '@material/chips/deprecated/trailingaction/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipTrailingActionAdapter {
            focus(): void;
            getAttribute(attr: string): string | null;
            notifyInteraction(trigger: InteractionTrigger): void;
            notifyNavigation(key: string): void;
            setAttribute(attr: string, value: string): void;
    }
}

declare module '@material/chips/deprecated/trailingaction/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCRipple, MDCRippleFactory } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCChipTrailingActionFoundation } from '@material/chips/deprecated/trailingaction/foundation';
    /**
        * Creates a trailing action component on the given element.
        */
    export type MDCChipTrailingActionFactory = (el: Element, foundation?: MDCChipTrailingActionFoundation) => MDCChipTrailingAction;
    export class MDCChipTrailingAction extends MDCComponent<MDCChipTrailingActionFoundation> implements MDCRippleCapableSurface {
            get ripple(): MDCRipple;
            static attachTo(root: Element): MDCChipTrailingAction;
            initialize(rippleFactory?: MDCRippleFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCChipTrailingActionFoundation;
            isNavigable(): boolean;
            focus(): void;
            removeFocus(): void;
    }
}

declare module '@material/chips/deprecated/trailingaction/foundation' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCChipTrailingActionAdapter } from '@material/chips/deprecated/trailingaction/adapter';
    export class MDCChipTrailingActionFoundation extends MDCFoundation<MDCChipTrailingActionAdapter> {
        static get strings(): {
            ARIA_HIDDEN: string;
            INTERACTION_EVENT: string;
            NAVIGATION_EVENT: string;
            TAB_INDEX: string;
        };
        static get defaultAdapter(): MDCChipTrailingActionAdapter;
        constructor(adapter?: Partial<MDCChipTrailingActionAdapter>);
        handleClick(evt: MouseEvent): void;
        handleKeydown(evt: KeyboardEvent): void;
        removeFocus(): void;
        focus(): void;
        isNavigable(): boolean;
    }
    export default MDCChipTrailingActionFoundation;
}

declare module '@material/chips/deprecated/trailingaction/types' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { InteractionTrigger } from '@material/chips/deprecated/trailingaction/constants';
    export interface MDCChipTrailingActionInteractionEventDetail {
        trigger: InteractionTrigger;
    }
    export interface MDCChipTrailingActionNavigationEventDetail {
        key: string;
    }
    export interface MDCChipTrailingActionInteractionEvent extends Event {
        readonly detail: MDCChipTrailingActionInteractionEventDetail;
    }
    export interface MDCChipTrailingActionNavigationEvent extends Event {
        readonly detail: MDCChipTrailingActionNavigationEventDetail;
    }
}

declare module '@material/chips/deprecated/trailingaction/constants' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export enum InteractionTrigger {
        UNSPECIFIED = 0,
        CLICK = 1,
        BACKSPACE_KEY = 2,
        DELETE_KEY = 3,
        SPACEBAR_KEY = 4,
        ENTER_KEY = 5
    }
    export const strings: {
        ARIA_HIDDEN: string;
        INTERACTION_EVENT: string;
        NAVIGATION_EVENT: string;
        TAB_INDEX: string;
    };
}

declare module '@material/chips/deprecated/chip/adapter' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventSource } from '@material/chips/deprecated/chip/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipAdapter {
            /**
                * Adds a class to the root element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root element.
                */
            removeClass(className: string): void;
            /**
                * @return true if the root element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Adds a class to the leading icon element.
                */
            addClassToLeadingIcon(className: string): void;
            /**
                * Removes a class from the leading icon element.
                */
            removeClassFromLeadingIcon(className: string): void;
            /**
                * @return true if target has className, false otherwise.
                */
            eventTargetHasClass(target: EventTarget | null, className: string): boolean;
            /**
                * @return the attribute string value if present, otherwise null
                */
            getAttribute(attr: string): string | null;
            /**
                * Emits a custom "MDCChip:interaction" event denoting the chip has been
                * interacted with (typically on click or keydown).
                */
            notifyInteraction(): void;
            /**
                * Emits a custom "MDCChip:selection" event denoting the chip has been selected or deselected.
                */
            notifySelection(selected: boolean, chipSetShouldIgnore: boolean): void;
            /**
                * Emits a custom "MDCChip:trailingIconInteraction" event denoting the trailing icon has been
                * interacted with (typically on click or keydown).
                */
            notifyTrailingIconInteraction(): void;
            /**
                * Emits a custom event "MDCChip:removal" denoting the chip will be removed.
                */
            notifyRemoval(removedAnnouncement: string | null): void;
            /**
                * Emits a custom event "MDCChip:navigation" denoting a focus navigation event.
                */
            notifyNavigation(key: string, source: EventSource): void;
            /**
                * Emits when editing starts.
                */
            notifyEditStart(): void;
            /**
                * Emits when editing finishes.
                */
            notifyEditFinish(): void;
            /**
                * @return The computed property value of the given style property on the root element.
                */
            getComputedStyleValue(propertyName: string): string;
            /**
                * Sets the property value of the given style property on the root element.
                */
            setStyleProperty(propertyName: string, value: string): void;
            /**
                * @return Whether the chip has a leading icon.
                */
            hasLeadingIcon(): boolean;
            /**
                * @return The bounding client rect of the root element.
                */
            getRootBoundingClientRect(): ClientRect;
            /**
                * @return The bounding client rect of the checkmark element or null if it doesn't exist.
                */
            getCheckmarkBoundingClientRect(): ClientRect | null;
            /**
                * Sets the value of the attribute on the primary action content.
                */
            setPrimaryActionAttr(attr: string, value: string): void;
            /**
                * Gives focus to the primary action.
                */
            focusPrimaryAction(): void;
            /**
                * Sets focus to the trailing action.
                */
            focusTrailingAction(): void;
            /**
                * Removes focus from the trailing action.
                */
            removeTrailingActionFocus(): void;
            /**
                * Returns true if the trailing action is navigable.
                * Should return the value of MDCChipTrailingAction#isNavigable() or false.
                */
            isTrailingActionNavigable(): boolean;
            /**
                * @return true if the text direction is right-to-left.
                */
            isRTL(): boolean;
    }
}

declare module '@material/chips/deprecated/chip/component' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCRipple, MDCRippleFactory } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCChipTrailingActionFactory } from '@material/chips/deprecated/trailingaction/component';
    import { MDCChipFoundation } from '@material/chips/deprecated/chip/foundation';
    export type MDCChipFactory = (el: Element, foundation?: MDCChipFoundation) => MDCChip;
    export class MDCChip extends MDCComponent<MDCChipFoundation> implements MDCRippleCapableSurface {
            /**
                * @return Whether the chip is selected.
                */
            get selected(): boolean;
            /**
                * Sets selected state on the chip.
                */
            set selected(selected: boolean);
            /**
                * @return Whether a trailing icon click should trigger exit/removal of the chip.
                */
            get shouldRemoveOnTrailingIconClick(): boolean;
            /**
                * Sets whether a trailing icon click should trigger exit/removal of the chip.
                */
            set shouldRemoveOnTrailingIconClick(shouldRemove: boolean);
            /**
                * Sets whether a clicking on the chip should focus the primary action.
                */
            set setShouldFocusPrimaryActionOnClick(shouldFocus: boolean);
            get ripple(): MDCRipple;
            get id(): string;
            static attachTo(root: Element): MDCChip;
            initialize(rippleFactory?: MDCRippleFactory, trailingActionFactory?: MDCChipTrailingActionFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            /**
                * Begins the exit animation which leads to removal of the chip.
                */
            beginExit(): void;
            getDefaultFoundation(): MDCChipFoundation;
            setSelectedFromChipSet(selected: boolean, shouldNotifyClients: boolean): void;
            focusPrimaryAction(): void;
            focusTrailingAction(): void;
            removeFocus(): void;
            remove(): void;
    }
}

declare module '@material/chips/deprecated/chip/foundation' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCChipTrailingActionNavigationEvent } from '@material/chips/deprecated/trailingaction/types';
    import { MDCChipAdapter } from '@material/chips/deprecated/chip/adapter';
    export class MDCChipFoundation extends MDCFoundation<MDCChipAdapter> {
            static get strings(): {
                    ADDED_ANNOUNCEMENT_ATTRIBUTE: string;
                    ARIA_CHECKED: string;
                    ARROW_DOWN_KEY: string;
                    ARROW_LEFT_KEY: string;
                    ARROW_RIGHT_KEY: string;
                    ARROW_UP_KEY: string;
                    BACKSPACE_KEY: string;
                    CHECKMARK_SELECTOR: string;
                    DELETE_KEY: string;
                    END_KEY: string;
                    ENTER_KEY: string;
                    ENTRY_ANIMATION_NAME: string;
                    HOME_KEY: string;
                    IE_ARROW_DOWN_KEY: string;
                    IE_ARROW_LEFT_KEY: string;
                    IE_ARROW_RIGHT_KEY: string;
                    IE_ARROW_UP_KEY: string;
                    IE_DELETE_KEY: string;
                    INTERACTION_EVENT: string;
                    LEADING_ICON_SELECTOR: string;
                    NAVIGATION_EVENT: string;
                    PRIMARY_ACTION_SELECTOR: string;
                    REMOVED_ANNOUNCEMENT_ATTRIBUTE: string;
                    REMOVAL_EVENT: string;
                    SELECTION_EVENT: string;
                    SPACEBAR_KEY: string;
                    TAB_INDEX: string;
                    TRAILING_ACTION_SELECTOR: string;
                    TRAILING_ICON_INTERACTION_EVENT: string;
                    TRAILING_ICON_SELECTOR: string;
            };
            static get cssClasses(): {
                    CHECKMARK: string;
                    CHIP_EXIT: string;
                    DELETABLE: string;
                    EDITABLE: string;
                    EDITING: string;
                    HIDDEN_LEADING_ICON: string;
                    LEADING_ICON: string;
                    PRIMARY_ACTION: string;
                    PRIMARY_ACTION_FOCUSED: string;
                    SELECTED: string;
                    TEXT: string;
                    TRAILING_ACTION: string;
                    TRAILING_ICON: string;
            };
            static get defaultAdapter(): MDCChipAdapter;
            constructor(adapter?: Partial<MDCChipAdapter>);
            isSelected(): boolean;
            isEditable(): boolean;
            isEditing(): boolean;
            setSelected(selected: boolean): void;
            setSelectedFromChipSet(selected: boolean, shouldNotifyClients: boolean): void;
            getShouldRemoveOnTrailingIconClick(): boolean;
            setShouldRemoveOnTrailingIconClick(shouldRemove: boolean): void;
            setShouldFocusPrimaryActionOnClick(shouldFocus: boolean): void;
            getDimensions(): ClientRect;
            /**
                * Begins the exit animation which leads to removal of the chip.
                */
            beginExit(): void;
            handleClick(): void;
            handleDoubleClick(): void;
            /**
                * Handles a transition end event on the root element.
                */
            handleTransitionEnd(evt: TransitionEvent): void;
            handleFocusIn(evt: FocusEvent): void;
            handleFocusOut(evt: FocusEvent): void;
            /**
                * Handles an interaction event on the trailing icon element. This is used to
                * prevent the ripple from activating on interaction with the trailing icon.
                */
            handleTrailingActionInteraction(): void;
            /**
                * Handles a keydown event from the root element.
                */
            handleKeydown(evt: KeyboardEvent): void;
            handleTrailingActionNavigation(evt: MDCChipTrailingActionNavigationEvent): void;
            /**
                * Called by the chip set to remove focus from the chip actions.
                */
            removeFocus(): void;
            /**
                * Called by the chip set to focus the primary action.
                *
                */
            focusPrimaryAction(): void;
            /**
                * Called by the chip set to focus the trailing action (if present), otherwise
                * gives focus to the trailing action.
                */
            focusTrailingAction(): void;
    }
    export default MDCChipFoundation;
}

declare module '@material/chips/deprecated/chip/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { EventSource } from '@material/chips/deprecated/chip/constants';
    export interface MDCChipInteractionEventDetail {
        chipId: string;
    }
    export interface MDCChipSelectionEventDetail extends MDCChipInteractionEventDetail {
        selected: boolean;
        shouldIgnore: boolean;
    }
    export interface MDCChipRemovalEventDetail extends MDCChipInteractionEventDetail {
        removedAnnouncement: string | null;
    }
    export interface MDCChipNavigationEventDetail extends MDCChipInteractionEventDetail {
        key: string;
        source: EventSource;
    }
    export interface MDCChipInteractionEvent extends Event {
        readonly detail: MDCChipInteractionEventDetail;
    }
    export interface MDCChipSelectionEvent extends Event {
        readonly detail: MDCChipSelectionEventDetail;
    }
    export interface MDCChipRemovalEvent extends Event {
        readonly detail: MDCChipRemovalEventDetail;
    }
    export interface MDCChipNavigationEvent extends Event {
        readonly detail: MDCChipNavigationEventDetail;
    }
}

declare module '@material/chips/deprecated/chip/constants' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export enum Direction {
        LEFT = "left",
        RIGHT = "right"
    }
    export enum EventSource {
        PRIMARY = "primary",
        TRAILING = "trailing",
        NONE = "none"
    }
    export const strings: {
        ADDED_ANNOUNCEMENT_ATTRIBUTE: string;
        ARIA_CHECKED: string;
        ARROW_DOWN_KEY: string;
        ARROW_LEFT_KEY: string;
        ARROW_RIGHT_KEY: string;
        ARROW_UP_KEY: string;
        BACKSPACE_KEY: string;
        CHECKMARK_SELECTOR: string;
        DELETE_KEY: string;
        END_KEY: string;
        ENTER_KEY: string;
        ENTRY_ANIMATION_NAME: string;
        HOME_KEY: string;
        IE_ARROW_DOWN_KEY: string;
        IE_ARROW_LEFT_KEY: string;
        IE_ARROW_RIGHT_KEY: string;
        IE_ARROW_UP_KEY: string;
        IE_DELETE_KEY: string;
        INTERACTION_EVENT: string;
        LEADING_ICON_SELECTOR: string;
        NAVIGATION_EVENT: string;
        PRIMARY_ACTION_SELECTOR: string;
        REMOVED_ANNOUNCEMENT_ATTRIBUTE: string;
        REMOVAL_EVENT: string;
        SELECTION_EVENT: string;
        SPACEBAR_KEY: string;
        TAB_INDEX: string;
        TRAILING_ACTION_SELECTOR: string;
        TRAILING_ICON_INTERACTION_EVENT: string;
        TRAILING_ICON_SELECTOR: string;
    };
    export const cssClasses: {
        CHECKMARK: string;
        CHIP_EXIT: string;
        DELETABLE: string;
        EDITABLE: string;
        EDITING: string;
        HIDDEN_LEADING_ICON: string;
        LEADING_ICON: string;
        PRIMARY_ACTION: string;
        PRIMARY_ACTION_FOCUSED: string;
        SELECTED: string;
        TEXT: string;
        TRAILING_ACTION: string;
        TRAILING_ICON: string;
    };
    export const navigationKeys: Set<string>;
    export const jumpChipKeys: Set<string>;
}

declare module '@material/chips/deprecated/chip-set/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipSetAdapter {
            /**
                * @return true if the root element contains the given class name.
                */
            hasClass(className: string): boolean;
            /**
                * Removes the chip with the given index from the chip set.
                * Make sure to remove it from the chip list, too.
                */
            removeChipAtIndex(index: number): void;
            /**
                * Sets the selected state of the chip at the given index.
                */
            selectChipAtIndex(index: number, isSelected: boolean, shouldNotifyClients: boolean): void;
            /**
                * Returns the index of the chip at the given ID.
                * @param chipId the unique ID of the chip
                * @return the numerical index of the chip with the matching id or -1.
                */
            getIndexOfChipById(chipId: string): number;
            /**
                * Calls Chip#focusPrimaryAction() on the chip at the given index.
                * @param index the index of the chip
                */
            focusChipPrimaryActionAtIndex(index: number): void;
            /**
                * Calls Chip#focusTrailingAction() on the chip at the given index.
                * @param index the index of the chip
                */
            focusChipTrailingActionAtIndex(index: number): void;
            /**
                * Removes focus from the chip at the given index.
                * @param index the index of the chip
                */
            removeFocusFromChipAtIndex(index: number): void;
            /**
                * @return true if the text direction is RTL.
                */
            isRTL(): boolean;
            /**
                * @return the number of chips in the chip set.
                */
            getChipListCount(): number;
            /**
                * Announces the message via an aria-live region.
                */
            announceMessage(message: string): void;
    }
}

declare module '@material/chips/deprecated/chip-set/component' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCChip, MDCChipFactory } from '@material/chips/deprecated/chip/component';
    import { MDCChipSetFoundation } from '@material/chips/deprecated/chip-set/foundation';
    export class MDCChipSet extends MDCComponent<MDCChipSetFoundation> {
            static attachTo(root: Element): MDCChipSet;
            get chips(): ReadonlyArray<MDCChip>;
            /**
                * @return An array of the IDs of all selected chips.
                */
            get selectedChipIds(): ReadonlyArray<string>;
            /**
                * @param chipFactory A function which creates a new MDCChip.
                */
            initialize(chipFactory?: MDCChipFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            /**
                * Adds a new chip object to the chip set from the given chip element.
                */
            addChip(chipEl: Element): void;
            getDefaultFoundation(): MDCChipSetFoundation;
    }
}

declare module '@material/chips/deprecated/chip-set/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCChipInteractionEventDetail, MDCChipNavigationEventDetail, MDCChipRemovalEventDetail, MDCChipSelectionEventDetail } from '@material/chips/deprecated/chip/types';
    import { MDCChipSetAdapter } from '@material/chips/deprecated/chip-set/adapter';
    export class MDCChipSetFoundation extends MDCFoundation<MDCChipSetAdapter> {
            static get strings(): {
                    CHIP_SELECTOR: string;
            };
            static get cssClasses(): {
                    CHOICE: string;
                    FILTER: string;
            };
            static get defaultAdapter(): MDCChipSetAdapter;
            constructor(adapter?: Partial<MDCChipSetAdapter>);
            /**
                * Returns an array of the IDs of all selected chips.
                */
            getSelectedChipIds(): ReadonlyArray<string>;
            /**
                * Selects the chip with the given id. Deselects all other chips if the chip set is of the choice variant.
                * Does not notify clients of the updated selection state.
                */
            select(chipId: string): void;
            /**
                * Handles a chip interaction event
                */
            handleChipInteraction({ chipId }: MDCChipInteractionEventDetail): void;
            /**
                * Handles a chip selection event, used to handle discrepancy when selection state is set directly on the Chip.
                */
            handleChipSelection({ chipId, selected, shouldIgnore }: MDCChipSelectionEventDetail): void;
            /**
                * Handles the event when a chip is removed.
                */
            handleChipRemoval({ chipId, removedAnnouncement }: MDCChipRemovalEventDetail): void;
            /**
                * Handles a chip navigation event.
                */
            handleChipNavigation({ chipId, key, source }: MDCChipNavigationEventDetail): void;
    }
    export default MDCChipSetFoundation;
}

declare module '@material/chips/deprecated/chip-set/constants' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export const strings: {
        CHIP_SELECTOR: string;
    };
    export const cssClasses: {
        CHOICE: string;
        FILTER: string;
    };
}

declare module '@material/chips/action/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCRipple, MDCRippleFactory } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    import { MDCChipActionFoundation } from '@material/chips/action/foundation';
    import { MDCChipPrimaryActionFoundation } from '@material/chips/action/primary-foundation';
    import { MDCChipTrailingActionFoundation } from '@material/chips/action/trailing-foundation';
    /**
        * MDCChipActionFactory is used by the parent MDCChip component to initialize
        * chip actions.
        */
    export type MDCChipActionFactory = (el: Element, foundation?: MDCChipActionFoundation) => MDCChipAction;
    /**
        * MDCChipAction provides component encapsulation of the different foundation
        * implementations.
        */
    export class MDCChipAction extends MDCComponent<MDCChipActionFoundation> implements MDCRippleCapableSurface {
            static attachTo(root: Element): MDCChipAction;
            get ripple(): MDCRipple;
            initialize(rippleFactory?: MDCRippleFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCChipPrimaryActionFoundation | MDCChipTrailingActionFoundation;
            setDisabled(isDisabled: boolean): void;
            isDisabled(): boolean;
            setFocus(behavior: FocusBehavior): void;
            isFocusable(): boolean;
            setSelected(isSelected: boolean): void;
            isSelected(): boolean;
            isSelectable(): boolean;
            actionType(): ActionType;
    }
}

declare module '@material/chips/chip/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    import { MDCChipAdapter } from '@material/chips/chip/adapter';
    import { Animation } from '@material/chips/chip/constants';
    import { ActionInteractionEvent, ActionNavigationEvent } from '@material/chips/chip/types';
    /**
        * MDCChipFoundation provides a foundation for all chips.
        */
    export class MDCChipFoundation extends MDCFoundation<MDCChipAdapter> {
            static get defaultAdapter(): MDCChipAdapter;
            constructor(adapter?: Partial<MDCChipAdapter>);
            destroy(): void;
            getElementID(): string;
            setDisabled(isDisabled: boolean): void;
            isDisabled(): boolean;
            getActions(): ActionType[];
            isActionFocusable(action: ActionType): boolean;
            isActionSelectable(action: ActionType): boolean;
            isActionSelected(action: ActionType): boolean;
            setActionFocus(action: ActionType, focus: FocusBehavior): void;
            setActionSelected(action: ActionType, isSelected: boolean): void;
            startAnimation(animation: Animation): void;
            handleAnimationEnd(event: AnimationEvent): void;
            handleTransitionEnd(): void;
            handleActionInteraction({ detail }: ActionInteractionEvent): void;
            handleActionNavigation({ detail }: ActionNavigationEvent): void;
    }
    export default MDCChipFoundation;
}

declare module '@material/chips/chip/types' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType } from '@material/chips/action/constants';
    import { MDCChipActionInteractionEventDetail, MDCChipActionNavigationEventDetail } from '@material/chips/action/types';
    import { Animation } from '@material/chips/chip/constants';
    /** MDCChipInteractionEventDetail provides details for the interaction event. */
    export interface MDCChipInteractionEventDetail {
            actionID: string;
            chipID: string;
            source: ActionType;
            shouldRemove: boolean;
            isSelectable: boolean;
            isSelected: boolean;
    }
    /** MDCChipNavigationEventDetail provides details for the navigation event. */
    export interface MDCChipNavigationEventDetail {
            chipID: string;
            source: ActionType;
            key: string;
            isRTL: boolean;
    }
    /** MDCChipAnimationEventDetail provides details for the animation event. */
    export interface MDCChipAnimationEventDetail {
            chipID: string;
            animation: Animation;
            isComplete: boolean;
            addedAnnouncement?: string;
            removedAnnouncement?: string;
    }
    /**
        * MDCChipActionInteractionEvent is the custom event for the interaction event.
        */
    export type ActionInteractionEvent = CustomEvent<MDCChipActionInteractionEventDetail>;
    /**
        * MDCChipActionInteractionEvent is the custom event for the interaction event.
        */
    export type ActionNavigationEvent = CustomEvent<MDCChipActionNavigationEventDetail>;
}

declare module '@material/chips/action/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCChipActionAdapter } from '@material/chips/action/adapter';
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    /**
        * MDCChipActionFoundation provides a base abstract foundation for all chip
        * actions.
        */
    export abstract class MDCChipActionFoundation extends MDCFoundation<MDCChipActionAdapter> {
            static get defaultAdapter(): MDCChipActionAdapter;
            constructor(adapter?: Partial<MDCChipActionAdapter>);
            handleClick(): void;
            handleKeydown(event: KeyboardEvent): void;
            setDisabled(isDisabled: boolean): void;
            isDisabled(): boolean;
            setFocus(behavior: FocusBehavior): void;
            isFocusable(): boolean;
            setSelected(isSelected: boolean): void;
            isSelected(): boolean;
            abstract actionType(): ActionType;
            abstract isSelectable(): boolean;
            protected abstract shouldEmitInteractionOnRemoveKey(): boolean;
    }
    export default MDCChipActionFoundation;
}

declare module '@material/chips/action/primary-foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType } from '@material/chips/action/constants';
    import { MDCChipActionFoundation } from '@material/chips/action/foundation';
    /**
        * MDCChipPrimaryActionFoundation provides the business logic for the primary
        * chip action.
        */
    export class MDCChipPrimaryActionFoundation extends MDCChipActionFoundation {
            isSelectable(): boolean;
            actionType(): ActionType;
            protected shouldEmitInteractionOnRemoveKey(): boolean;
    }
    export default MDCChipPrimaryActionFoundation;
}

declare module '@material/chips/action/trailing-foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType } from '@material/chips/action/constants';
    import { MDCChipActionFoundation } from '@material/chips/action/foundation';
    /**
        * MDCChipTrailingActionFoundation provides the business logic for the trailing
        * chip action.
        */
    export class MDCChipTrailingActionFoundation extends MDCChipActionFoundation {
            isSelectable(): boolean;
            actionType(): ActionType;
            protected shouldEmitInteractionOnRemoveKey(): boolean;
    }
    export default MDCChipTrailingActionFoundation;
}

declare module '@material/chips/chip/adapter' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType, FocusBehavior } from '@material/chips/action/constants';
    import { Attributes, CssClasses, Events } from '@material/chips/chip/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipAdapter {
            /** Adds the given class to the root element. */
            addClass(className: CssClasses): void;
            /** Emits the given event with the given detail. */
            emitEvent<D extends object>(eventName: Events, eventDetail: D): void;
            /** Returns the child actions provided by the chip. */
            getActions(): ActionType[];
            /** Returns the value for the given attribute, if it exists. */
            getAttribute(attrName: Attributes): string | null;
            /** Returns the ID of the root element. */
            getElementID(): string;
            /** Returns the offset width of the root element. */
            getOffsetWidth(): number;
            /** Returns true if the root element has the given class. */
            hasClass(className: CssClasses): boolean;
            /** Proxies to the MDCChipAction#isSelectable method. */
            isActionSelectable(action: ActionType): boolean;
            /** Proxies to the MDCChipAction#isSelected method. */
            isActionSelected(action: ActionType): boolean;
            /** Proxies to the MDCChipAction#isFocusable method. */
            isActionFocusable(action: ActionType): boolean;
            /** Proxies to the MDCChipAction#isDisabled method. */
            isActionDisabled(action: ActionType): boolean;
            /** Returns true if the text direction is right-to-left. */
            isRTL(): boolean;
            /** Removes the given class from the root element. */
            removeClass(className: CssClasses): void;
            /** Proxies to the MDCChipAction#setDisabled method. */
            setActionDisabled(action: ActionType, isDisabled: boolean): void;
            /** Proxies to the MDCChipAction#setFocus method. */
            setActionFocus(action: ActionType, behavior: FocusBehavior): void;
            /** Proxies to the MDCChipAction#setSelected method. */
            setActionSelected(action: ActionType, isSelected: boolean): void;
            /** Sets the style property to the given value. */
            setStyleProperty(property: string, value: string): void;
    }
}

declare module '@material/chips/action/types' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { ActionType, InteractionTrigger } from '@material/chips/action/constants';
    /**
        * MDCChipActionInteractionEventDetail provides the details for the interaction
        * event.
        */
    export interface MDCChipActionInteractionEventDetail {
            actionID: string;
            source: ActionType;
            trigger: InteractionTrigger;
    }
    /**
        * MDCChipActionNavigationEventDetail provides the details for the navigation
        * event.
        */
    export interface MDCChipActionNavigationEventDetail {
            source: ActionType;
            key: string;
    }
}

declare module '@material/chips/action/adapter' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { Attributes, Events } from '@material/chips/action/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCChipActionAdapter {
            emitEvent<D extends object>(eventName: Events, eventDetail: D): void;
            focus(): void;
            getAttribute(attr: Attributes): string | null;
            getElementID(): string;
            removeAttribute(attr: Attributes): void;
            setAttribute(attr: Attributes, value: string): void;
    }
}

