// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/progress-indicator/component
//   ../../@material/base/foundation
//   ../../@material/progress-indicator/foundation

declare module '@material/circular-progress' {
    /**
      * @license
      * Copyright 2020 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/circular-progress/adapter';
    export * from '@material/circular-progress/component';
    export * from '@material/circular-progress/constants';
    export * from '@material/circular-progress/foundation';
}

declare module '@material/circular-progress/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCCircularProgressAdapter {
            addClass(className: string): void;
            getDeterminateCircleAttribute(attributeName: string): string | null;
            hasClass(className: string): boolean;
            removeClass(className: string): void;
            removeAttribute(attributeName: string): void;
            setAttribute(attributeName: string, value: string): void;
            setDeterminateCircleAttribute(attributeName: string, value: string): void;
    }
}

declare module '@material/circular-progress/component' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCProgressIndicator } from '@material/progress-indicator/component';
    import { MDCCircularProgressFoundation } from '@material/circular-progress/foundation';
    export class MDCCircularProgress extends MDCComponent<MDCCircularProgressFoundation> implements MDCProgressIndicator {
            initialize(): void;
            static attachTo(root: Element): MDCCircularProgress;
            /**
                * Sets whether the progress indicator is in determinate mode.
                * @param isDeterminate Whether the indicator should be determinate.
                */
            set determinate(value: boolean);
            /**
                * Sets the current progress value. In indeterminate mode, this has no
                * visual effect but will be reflected if the indicator is switched to
                * determinate mode.
                * @param value The current progress value, which must be between 0 and 1.
                */
            set progress(value: number);
            /**
                * Whether the progress indicator is hidden.
                */
            get isClosed(): boolean;
            /**
                * Shows the progress indicator.
                */
            open(): void;
            /**
                * Hides the progress indicator.
                */
            close(): void;
            getDefaultFoundation(): MDCCircularProgressFoundation;
    }
}

declare module '@material/circular-progress/constants' {
    /**
        * CSS class names used in component.
        */
    export const cssClasses: {
            INDETERMINATE_CLASS: string;
            CLOSED_CLASS: string;
    };
    /**
        * Attributes and selectors used in component.
        */
    export const strings: {
            ARIA_HIDDEN: string;
            ARIA_VALUENOW: string;
            DETERMINATE_CIRCLE_SELECTOR: string;
            RADIUS: string;
            STROKE_DASHOFFSET: string;
    };
}

declare module '@material/circular-progress/foundation' {
    /**
        * @license
        * Copyright 2020 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCProgressIndicatorFoundation } from '@material/progress-indicator/foundation';
    import { MDCCircularProgressAdapter } from '@material/circular-progress/adapter';
    export class MDCCircularProgressFoundation extends MDCFoundation<MDCCircularProgressAdapter> implements MDCProgressIndicatorFoundation {
            static get cssClasses(): {
                    INDETERMINATE_CLASS: string;
                    CLOSED_CLASS: string;
            };
            static get strings(): {
                    ARIA_HIDDEN: string;
                    ARIA_VALUENOW: string;
                    DETERMINATE_CIRCLE_SELECTOR: string;
                    RADIUS: string;
                    STROKE_DASHOFFSET: string;
            };
            static get defaultAdapter(): MDCCircularProgressAdapter;
            constructor(adapter?: Partial<MDCCircularProgressAdapter>);
            init(): void;
            /**
                * Sets whether the progress indicator is in determinate mode.
                * @param determinate Whether the indicator should be determinate.
                */
            setDeterminate(determinate: boolean): void;
            isDeterminate(): boolean;
            /**
                * Sets the current progress value. In indeterminate mode, this has no
                * visual effect but will be reflected if the indicator is switched to
                * determinate mode.
                * @param value The current progress value, which must be between 0 and 1.
                */
            setProgress(value: number): void;
            getProgress(): number;
            /**
                * Shows the progress indicator.
                */
            open(): void;
            /**
                * Hides the progress indicator
                */
            close(): void;
            /**
                * @return Returns whether the progress indicator is hidden.
                */
            isClosed(): boolean;
    }
    export default MDCCircularProgressFoundation;
}

