// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/checkbox/component
//   ../../@material/base/foundation

declare module '@material/data-table' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/data-table/adapter';
    export * from '@material/data-table/component';
    export * from '@material/data-table/foundation';
    export * from '@material/data-table/constants';
    export * from '@material/data-table/types';
}

declare module '@material/data-table/adapter' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { SortValue } from '@material/data-table/constants';
    import { MDCDataTableRowSelectionChangedEventDetail, ProgressIndicatorStyles, SortActionEventDetail } from '@material/data-table/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCDataTableAdapter {
            /**
                * Adds CSS class name to root element.
                *
                * @param className CSS class name to add to root element.
                */
            addClass(className: string): void;
            /**
                * Removes CSS class name from root element.
                *
                * @param className CSS class name to add to root element.
                */
            removeClass(className: string): void;
            /**
                * Adds a class name to row element at given row index excluding header row.
                *
                * @param rowIndex Index of row element excluding header row.
                * @param cssClasses CSS Class string to add.
                */
            addClassAtRowIndex(rowIndex: number, cssClasses: string): void;
            /**
                * @return Row count excluding header row.
                */
            getRowCount(): number;
            /**
                * @return Array of row elements excluding header row.
                */
            getRowElements(): Element[];
            /**
                * Returns row id of row element at given row index based on `data-row-id` attribute on row element `tr`.
                *
                * @param rowIndex Index of row element.
                * @return Row id of row element, returns `null` in absence of `data-row-id` attribute on row element.
                */
            getRowIdAtIndex(rowIndex: number): string | null;
            /**
                * Returns index of row element that contains give child element. Returns -1 if element is not child of any row
                * element.
                *
                * @param el Child element of row element.
                * @return Index of row element.
                */
            getRowIndexByChildElement(el: Element): number;
            /**
                * @return Selected row count.
                */
            getSelectedRowCount(): number;
            /**
                * @param rowIndex Index of row element.
                * @return True if row checkbox at given row index is checked.
                */
            isCheckboxAtRowIndexChecked(rowIndex: number): boolean;
            /**
                * @return True if header row checkbox is checked.
                */
            isHeaderRowCheckboxChecked(): boolean;
            /**
                * @return True if table rows are selectable.
                */
            isRowsSelectable(): boolean;
            /**
                * Notifies when row selection is changed.
                *
                * @param data Event detail data for row selection changed event.
                */
            notifyRowSelectionChanged(data: MDCDataTableRowSelectionChangedEventDetail): void;
            /**
                * Notifies when header row is checked.
                */
            notifySelectedAll(): void;
            /**
                * Notifies when header row is unchecked.
                */
            notifyUnselectedAll(): void;
            /**
                * Initializes header row checkbox. Destroys previous header row checkbox instance if any.
                * @return Can return Promise only if registering checkbox is asynchronous.
                */
            registerHeaderRowCheckbox(): Promise<void> | void;
            /**
                * Initializes all row checkboxes. Destroys previous row checkbox instances if any. This is usually called when row
                * checkboxes are added or removed from table.
                * @return Can return Promise only if registering checkbox is asynchronous.
                */
            registerRowCheckboxes(): Promise<void> | void;
            /**
                * Removes class name from row element at give row index.
                *
                * @param rowIndex Index of row element excluding header row element.
                * @param cssClasses Class name string.
                */
            removeClassAtRowIndex(rowIndex: number, cssClasses: string): void;
            /**
                * Sets attribute to row element at given row index.
                *
                * @param rowIndex Index of row element excluding header row element.
                * @param attr Name of attribute.
                * @param value Value of attribute.
                */
            setAttributeAtRowIndex(rowIndex: number, attr: string, value: string): void;
            /**
                * Sets header row checkbox checked or unchecked.
                *
                * @param checked True to set header row checkbox checked.
                */
            setHeaderRowCheckboxChecked(checked: boolean): void;
            /**
                * Sets header row checkbox to indeterminate.
                *
                * @param indeterminate True to set header row checkbox indeterminate.
                */
            setHeaderRowCheckboxIndeterminate(indeterminate: boolean): void;
            /**
                * Sets row checkbox to checked or unchecked at given row index.
                *
                * @param rowIndex Index of row element excluding header row element.
                * @param checked True to set checked.
                */
            setRowCheckboxCheckedAtIndex(rowIndex: number, checked: boolean): void;
            /**
                * @return Total count of header cells.
                */
            getHeaderCellCount(): number;
            /**
                * @return Array of header cell elements.
                */
            getHeaderCellElements(): Element[];
            /**
                * @return Attribute value for given header cell index.
                */
            getAttributeByHeaderCellIndex(columnIndex: number, attribute: string): string | null;
            /**
                * Sets attribute of a header cell by index.
                */
            setAttributeByHeaderCellIndex(columnIndex: number, attribute: string, value: string): void;
            /**
                * Sets class name of a header cell by index.
                */
            setClassNameByHeaderCellIndex(columnIndex: number, className: string): void;
            /**
                * Removes a class name of a header cell by index.
                */
            removeClassNameByHeaderCellIndex(columnIndex: number, className: string): void;
            /**
                * Notifies when column is sorted.
                */
            notifySortAction(data: SortActionEventDetail): void;
            /**
                * @return Returns computed styles height of table's body element.
                */
            getTableBodyHeight(): string;
            /**
                * @return Returns computed styles height of table's header element.
                */
            getTableHeaderHeight(): string;
            /**
                * Sets progress indicator CSS styles to position it on top of table body.
                */
            setProgressIndicatorStyles(styles: ProgressIndicatorStyles): void;
            /**
                * Sets appropriate sort status label by header cell index. Skips setting sort
                * status label if header cell is not sortable.
                *
                * Example status label to set for sortValue:
                *
                *   - `SortValue.ASCENDING`: 'Sorted in ascending order'
                *   - `SortValue.DESCENDING`: 'Sorted in descending order'
                *   - `SortValue.NONE`: '' (Empty string)
                */
            setSortStatusLabelByHeaderCellIndex(columnIndex: number, sortValue: SortValue): void;
    }
}

declare module '@material/data-table/component' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCCheckboxFactory } from '@material/checkbox/component';
    import { MDCDataTableFoundation } from '@material/data-table/foundation';
    /**
        * Implementation of `MDCDataTableFoundation`
        */
    export class MDCDataTable extends MDCComponent<MDCDataTableFoundation> {
            static attachTo(root: Element): MDCDataTable;
            initialize(checkboxFactory?: MDCCheckboxFactory): void;
            initialSyncWithDOM(): void;
            /**
                * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
                */
            layout(): void;
            /**
                * @return Returns array of header row cell elements.
                */
            getHeaderCells(): Element[];
            /**
                * @return Returns array of row elements.
                */
            getRows(): Element[];
            /**
                * @return Returns array of selected row ids.
                */
            getSelectedRowIds(): Array<string | null>;
            /**
                * Sets selected row ids. Overwrites previously selected rows.
                * @param rowIds Array of row ids that needs to be selected.
                */
            setSelectedRowIds(rowIds: string[]): void;
            destroy(): void;
            getDefaultFoundation(): MDCDataTableFoundation;
    }
}

declare module '@material/data-table/foundation' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCDataTableAdapter } from '@material/data-table/adapter';
    import { SortActionEventData } from '@material/data-table/types';
    /**
        * The Foundation of data table component containing pure business logic, any
        * logic requiring DOM manipulation are delegated to adapter methods.
        */
    export class MDCDataTableFoundation extends MDCFoundation<MDCDataTableAdapter> {
            static get defaultAdapter(): MDCDataTableAdapter;
            constructor(adapter?: Partial<MDCDataTableAdapter>);
            /**
                * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
                * Use this if registering checkbox is synchronous.
                */
            layout(): void;
            /**
                * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
                * Use this if registering checkbox is asynchronous.
                */
            layoutAsync(): Promise<void>;
            /**
                * @return Returns array of row elements.
                */
            getRows(): Element[];
            /**
                * @return Array of header cell elements.
                */
            getHeaderCells(): Element[];
            /**
                * Sets selected row ids. Overwrites previously selected rows.
                * @param rowIds Array of row ids that needs to be selected.
                */
            setSelectedRowIds(rowIds: string[]): void;
            /**
                * @return Returns array of all row ids.
                */
            getRowIds(): Array<string | null>;
            /**
                * @return Returns array of selected row ids.
                */
            getSelectedRowIds(): Array<string | null>;
            /**
                * Handles header row checkbox change event.
                */
            handleHeaderRowCheckboxChange(): void;
            /**
                * Handles change event originated from row checkboxes.
                */
            handleRowCheckboxChange(event: Event): void;
            /**
                * Handles sort action on sortable header cell.
                */
            handleSortAction(eventData: SortActionEventData): void;
            /**
                * Shows progress indicator blocking only the table body content when in
                * loading state.
                */
            showProgress(): void;
            /**
                * Hides progress indicator when data table is finished loading.
                */
            hideProgress(): void;
    }
}

declare module '@material/data-table/constants' {
    /**
        * CSS class names used in component.
        */
    export const cssClasses: {
            CELL: string;
            CELL_NUMERIC: string;
            CONTENT: string;
            HEADER_CELL: string;
            HEADER_CELL_LABEL: string;
            HEADER_CELL_SORTED: string;
            HEADER_CELL_SORTED_DESCENDING: string;
            HEADER_CELL_WITH_SORT: string;
            HEADER_CELL_WRAPPER: string;
            HEADER_ROW: string;
            HEADER_ROW_CHECKBOX: string;
            IN_PROGRESS: string;
            PROGRESS_INDICATOR: string;
            ROOT: string;
            ROW: string;
            ROW_CHECKBOX: string;
            ROW_SELECTED: string;
            SORT_ICON_BUTTON: string;
            SORT_STATUS_LABEL: string;
            PAGINATION_ROWS_PER_PAGE_SELECT: string;
            PAGINATION_ROWS_PER_PAGE_LABEL: string;
    };
    /**
        * DOM attributes used in component.
        */
    export const attributes: {
            ARIA_SELECTED: string;
            ARIA_SORT: string;
    };
    /**
        * List of data attributes used in component.
        */
    export const dataAttributes: {
            COLUMN_ID: string;
            ROW_ID: string;
    };
    /**
        * CSS selectors used in component.
        */
    export const selectors: {
            CONTENT: string;
            HEADER_CELL: string;
            HEADER_CELL_WITH_SORT: string;
            HEADER_ROW: string;
            HEADER_ROW_CHECKBOX: string;
            PROGRESS_INDICATOR: string;
            ROW: string;
            ROW_CHECKBOX: string;
            ROW_SELECTED: string;
            SORT_ICON_BUTTON: string;
            SORT_STATUS_LABEL: string;
    };
    /**
        * Messages used in component.
        */
    export const messages: {
            SORTED_IN_DESCENDING: string;
            SORTED_IN_ASCENDING: string;
    };
    /**
        * Attributes and selectors used in component.
        * @deprecated Use `attributes`, `dataAttributes` and `selectors` instead.
        */
    export const strings: {
            ARIA_SELECTED: string;
            ARIA_SORT: string;
            DATA_ROW_ID_ATTR: string;
            HEADER_ROW_CHECKBOX_SELECTOR: string;
            ROW_CHECKBOX_SELECTOR: string;
            ROW_SELECTED_SELECTOR: string;
            ROW_SELECTOR: string;
    };
    /**
        * Sort values defined by ARIA.
        * See https://www.w3.org/WAI/PF/aria/states_and_properties#aria-sort
        */
    export enum SortValue {
            ASCENDING = "ascending",
            DESCENDING = "descending",
            NONE = "none",
            OTHER = "other"
    }
    /**
        * Event names used in component.
        */
    export const events: {
            ROW_SELECTION_CHANGED: string;
            SELECTED_ALL: string;
            UNSELECTED_ALL: string;
            SORTED: string;
    };
}

declare module '@material/data-table/types' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { SortValue } from '@material/data-table/constants';
    export interface MDCDataTableRowSelectionChangedEventDetail {
            rowIndex: number;
            rowId: string | null;
            selected: boolean;
    }
    /**
        * Event data required for sort action callback - `handleSortAction()`.
        * Component must send this data to foundation when sort action triggered on
        * sortable header cell.
        */
    export interface SortActionEventData {
            columnId: string | null;
            columnIndex: number;
            headerCell: HTMLElement;
    }
    /**
        * Event detail triggered by foundation on sort action. This event detail is
        * used to trigger DOM event by component.
        */
    export interface SortActionEventDetail {
            columnId: string | null;
            columnIndex: number;
            headerCell: HTMLElement;
            sortValue: SortValue;
    }
    /**
        * Styles used to dynamically set dimensions of progress indicator based on
        * table header & body.
        */
    export interface ProgressIndicatorStyles {
            height: string;
            top: string;
    }
}

