// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../focus-trap
//   ../../../@material/base/component
//   ../../../@material/base/foundation

declare module 'mdc-dialog' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import * as util from 'mdc-dialog/util';
    export { util };
    export * from 'mdc-dialog/adapter';
    export * from 'mdc-dialog/component';
    export * from 'mdc-dialog/foundation';
    export * from 'mdc-dialog/types';
}

declare module 'mdc-dialog/util' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import * as createFocusTrap from 'focus-trap';
    export type MDCDialogFocusTrapFactory = (element: HTMLElement | string, userOptions?: createFocusTrap.Options) => createFocusTrap.FocusTrap;
    export function createFocusTrapInstance(surfaceEl: HTMLElement, focusTrapFactory?: MDCDialogFocusTrapFactory, initialFocusEl?: createFocusTrap.FocusTarget): createFocusTrap.FocusTrap;
    export function isScrollable(el: HTMLElement | null): boolean;
    export function areTopsMisaligned(els: HTMLElement[]): boolean;
}

declare module 'mdc-dialog/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCDialogAdapter {
            addClass(className: string): void;
            removeClass(className: string): void;
            hasClass(className: string): boolean;
            addBodyClass(className: string): void;
            removeBodyClass(className: string): void;
            eventTargetMatches(target: EventTarget | null, selector: string): boolean;
            isContentScrollable(): boolean;
            areButtonsStacked(): boolean;
            getActionFromEvent(evt: Event): string | null;
            trapFocus(): void;
            releaseFocus(): void;
            clickDefaultButton(): void;
            reverseButtons(): void;
            notifyOpening(): void;
            notifyOpened(): void;
            notifyClosing(action: string): void;
            notifyClosed(action: string): void;
    }
}

declare module 'mdc-dialog/component' {
    /**
      * @license
      * Copyright 2017 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCDialogFoundation } from 'mdc-dialog/foundation';
    import { MDCDialogFocusTrapFactory } from 'mdc-dialog/util';
    export class MDCDialog extends MDCComponent<MDCDialogFoundation> {
        readonly isOpen: boolean;
        escapeKeyAction: string;
        scrimClickAction: string;
        autoStackButtons: boolean;
        static attachTo(root: Element): MDCDialog;
        initialize(focusTrapFactory?: MDCDialogFocusTrapFactory, initialFocusEl?: HTMLElement): void;
        initialSyncWithDOM(): void;
        destroy(): void;
        layout(): void;
        open(): void;
        close(action?: string): void;
        getDefaultFoundation(): MDCDialogFoundation;
    }
}

declare module 'mdc-dialog/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCDialogAdapter } from 'mdc-dialog/adapter';
    export class MDCDialogFoundation extends MDCFoundation<MDCDialogAdapter> {
            static readonly cssClasses: {
                    CLOSING: string;
                    OPEN: string;
                    OPENING: string;
                    SCROLLABLE: string;
                    SCROLL_LOCK: string;
                    STACKED: string;
            };
            static readonly strings: {
                    ACTION_ATTRIBUTE: string;
                    BUTTON_SELECTOR: string;
                    CLOSED_EVENT: string;
                    CLOSE_ACTION: string;
                    CLOSING_EVENT: string;
                    CONTAINER_SELECTOR: string;
                    CONTENT_SELECTOR: string;
                    DEFAULT_BUTTON_SELECTOR: string;
                    DESTROY_ACTION: string;
                    OPENED_EVENT: string;
                    OPENING_EVENT: string;
                    SCRIM_SELECTOR: string;
                    SUPPRESS_DEFAULT_PRESS_SELECTOR: string;
                    SURFACE_SELECTOR: string;
            };
            static readonly numbers: {
                    DIALOG_ANIMATION_CLOSE_TIME_MS: number;
                    DIALOG_ANIMATION_OPEN_TIME_MS: number;
            };
            static readonly defaultAdapter: MDCDialogAdapter;
            constructor(adapter?: Partial<MDCDialogAdapter>);
            init(): void;
            destroy(): void;
            open(): void;
            close(action?: string): void;
            isOpen(): boolean;
            getEscapeKeyAction(): string;
            setEscapeKeyAction(action: string): void;
            getScrimClickAction(): string;
            setScrimClickAction(action: string): void;
            getAutoStackButtons(): boolean;
            setAutoStackButtons(autoStack: boolean): void;
            layout(): void;
            layoutInternal_(): void;
            handleInteraction(evt: MouseEvent | KeyboardEvent): void;
            handleDocumentKeydown(evt: KeyboardEvent): void;
    }
    export default MDCDialogFoundation;
}

declare module 'mdc-dialog/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export interface MDCDialogCloseEventDetail {
        action?: string;
    }
    export interface MDCDialogCloseEvent extends Event {
        readonly detail: MDCDialogCloseEventDetail;
    }
}

