// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/dom/focus-trap
//   ../../@material/base/component
//   ../../@material/base/foundation

declare module '@material/dialog' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import * as util from '@material/dialog/util';
    export { util };
    export * from '@material/dialog/adapter';
    export * from '@material/dialog/component';
    export * from '@material/dialog/constants';
    export * from '@material/dialog/foundation';
    export * from '@material/dialog/types';
}

declare module '@material/dialog/util' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { FocusOptions, FocusTrap } from '@material/dom/focus-trap';
    export type MDCDialogFocusTrapFactory = (element: HTMLElement, options: FocusOptions) => FocusTrap;
    export function createFocusTrapInstance(surfaceEl: HTMLElement, focusTrapFactory: MDCDialogFocusTrapFactory, initialFocusEl?: HTMLElement): FocusTrap;
    export function isScrollable(el: HTMLElement | null): boolean;
    export function areTopsMisaligned(els: HTMLElement[]): boolean;
}

declare module '@material/dialog/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCDialogAdapter {
            addClass(className: string): void;
            removeClass(className: string): void;
            hasClass(className: string): boolean;
            addBodyClass(className: string): void;
            removeBodyClass(className: string): void;
            eventTargetMatches(target: EventTarget | null, selector: string): boolean;
            isContentScrollable(): boolean;
            areButtonsStacked(): boolean;
            getActionFromEvent(evt: Event): string | null;
            trapFocus(focusElement: HTMLElement | null): void;
            releaseFocus(): void;
            getInitialFocusEl(): HTMLElement | null;
            clickDefaultButton(): void;
            reverseButtons(): void;
            notifyOpening(): void;
            notifyOpened(): void;
            notifyClosing(action: string): void;
            notifyClosed(action: string): void;
    }
}

declare module '@material/dialog/component' {
    /**
      * @license
      * Copyright 2017 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCDialogFoundation } from '@material/dialog/foundation';
    import { MDCDialogFocusTrapFactory } from '@material/dialog/util';
    export class MDCDialog extends MDCComponent<MDCDialogFoundation> {
        get isOpen(): boolean;
        get escapeKeyAction(): string;
        set escapeKeyAction(action: string);
        get scrimClickAction(): string;
        set scrimClickAction(action: string);
        get autoStackButtons(): boolean;
        set autoStackButtons(autoStack: boolean);
        static attachTo(root: Element): MDCDialog;
        initialize(focusTrapFactory?: MDCDialogFocusTrapFactory): void;
        initialSyncWithDOM(): void;
        destroy(): void;
        layout(): void;
        open(): void;
        close(action?: string): void;
        getDefaultFoundation(): MDCDialogFoundation;
    }
}

declare module '@material/dialog/constants' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export const cssClasses: {
        CLOSING: string;
        OPEN: string;
        OPENING: string;
        SCROLLABLE: string;
        SCROLL_LOCK: string;
        STACKED: string;
    };
    export const strings: {
        ACTION_ATTRIBUTE: string;
        BUTTON_DEFAULT_ATTRIBUTE: string;
        BUTTON_SELECTOR: string;
        CLOSED_EVENT: string;
        CLOSE_ACTION: string;
        CLOSING_EVENT: string;
        CONTAINER_SELECTOR: string;
        CONTENT_SELECTOR: string;
        DESTROY_ACTION: string;
        INITIAL_FOCUS_ATTRIBUTE: string;
        OPENED_EVENT: string;
        OPENING_EVENT: string;
        SCRIM_SELECTOR: string;
        SUPPRESS_DEFAULT_PRESS_SELECTOR: string;
        SURFACE_SELECTOR: string;
    };
    export const numbers: {
        DIALOG_ANIMATION_CLOSE_TIME_MS: number;
        DIALOG_ANIMATION_OPEN_TIME_MS: number;
    };
}

declare module '@material/dialog/foundation' {
    /**
        * @license
        * Copyright 2017 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCDialogAdapter } from '@material/dialog/adapter';
    export class MDCDialogFoundation extends MDCFoundation<MDCDialogAdapter> {
            static get cssClasses(): {
                    CLOSING: string;
                    OPEN: string;
                    OPENING: string;
                    SCROLLABLE: string;
                    SCROLL_LOCK: string;
                    STACKED: string;
            };
            static get strings(): {
                    ACTION_ATTRIBUTE: string;
                    BUTTON_DEFAULT_ATTRIBUTE: string;
                    BUTTON_SELECTOR: string;
                    CLOSED_EVENT: string;
                    CLOSE_ACTION: string;
                    CLOSING_EVENT: string;
                    CONTAINER_SELECTOR: string;
                    CONTENT_SELECTOR: string;
                    DESTROY_ACTION: string;
                    INITIAL_FOCUS_ATTRIBUTE: string;
                    OPENED_EVENT: string;
                    OPENING_EVENT: string;
                    SCRIM_SELECTOR: string;
                    SUPPRESS_DEFAULT_PRESS_SELECTOR: string;
                    SURFACE_SELECTOR: string;
            };
            static get numbers(): {
                    DIALOG_ANIMATION_CLOSE_TIME_MS: number;
                    DIALOG_ANIMATION_OPEN_TIME_MS: number;
            };
            static get defaultAdapter(): MDCDialogAdapter;
            constructor(adapter?: Partial<MDCDialogAdapter>);
            init(): void;
            destroy(): void;
            open(): void;
            close(action?: string): void;
            isOpen(): boolean;
            getEscapeKeyAction(): string;
            setEscapeKeyAction(action: string): void;
            getScrimClickAction(): string;
            setScrimClickAction(action: string): void;
            getAutoStackButtons(): boolean;
            setAutoStackButtons(autoStack: boolean): void;
            layout(): void;
            /** Handles click on the dialog root element. */
            handleClick(evt: MouseEvent): void;
            /** Handles keydown on the dialog root element. */
            handleKeydown(evt: KeyboardEvent): void;
            /** Handles keydown on the document. */
            handleDocumentKeydown(evt: KeyboardEvent): void;
    }
    export default MDCDialogFoundation;
}

declare module '@material/dialog/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export interface MDCDialogCloseEventDetail {
        action?: string;
    }
    export interface MDCDialogCloseEvent extends Event {
        readonly detail: MDCDialogCloseEventDetail;
    }
}

