/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

import MDCComponent from '@material/base/component';
import MDCFormFieldFoundation from './foundation';
/* eslint-disable no-unused-vars */
import {MDCSelectionControl} from '@material/selection-control/index';
/* eslint-enable no-unused-vars */

/**
 * @extends MDCComponent<!MDCFormFieldFoundation>
 */
class MDCFormField extends MDCComponent {
  static attachTo(root) {
    return new MDCFormField(root);
  }

  /** @param {?MDCSelectionControl} input */
  set input(input) {
    this.input_ = input;
  }

  /** @return {?MDCSelectionControl} */
  get input() {
    return this.input_;
  }

  constructor(...args) {
    super(...args);

    /** @private {?MDCSelectionControl} */
    this.input_;
  }

  /**
   * @return {!Element}
   * @private
   */
  get label_() {
    const {LABEL_SELECTOR} = MDCFormFieldFoundation.strings;
    return /** @type {!Element} */ (this.root_.querySelector(LABEL_SELECTOR));
  }

  /** @return {!MDCFormFieldFoundation} */
  getDefaultFoundation() {
    return new MDCFormFieldFoundation({
      registerInteractionHandler: (type, handler) => this.label_.addEventListener(type, handler),
      deregisterInteractionHandler: (type, handler) => this.label_.removeEventListener(type, handler),
      activateInputRipple: () => {
        if (this.input_ && this.input_.ripple) {
          this.input_.ripple.activate();
        }
      },
      deactivateInputRipple: () => {
        if (this.input_ && this.input_.ripple) {
          this.input_.ripple.deactivate();
        }
      },
    });
  }
}

export {MDCFormField, MDCFormFieldFoundation};
