// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/base/foundation

declare module '@material/list' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/list/adapter';
    export * from '@material/list/component';
    export * from '@material/list/constants';
    export * from '@material/list/foundation';
    export * from '@material/list/types';
}

declare module '@material/list/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCListAdapter {
            /**
                * Returns the attribute value of list item at given `index`.
                */
            getAttributeForElementIndex(index: number, attr: string): string | null;
            getListItemCount(): number;
            getFocusedElementIndex(): number;
            setAttributeForElementIndex(index: number, attribute: string, value: string): void;
            addClassForElementIndex(index: number, className: string): void;
            removeClassForElementIndex(index: number, className: string): void;
            /**
                * Focuses list item at the index specified.
                */
            focusItemAtIndex(index: number): void;
            /**
                * Sets the tabindex to the value specified for all button/a element children of
                * the list item at the index specified.
                */
            setTabIndexForListItemChildren(listItemIndex: number, tabIndexValue: string): void;
            /**
                * @return true if radio button is present at given list item index.
                */
            hasRadioAtIndex(index: number): boolean;
            /**
                * @return true if checkbox is present at given list item index.
                */
            hasCheckboxAtIndex(index: number): boolean;
            /**
                * @return true if checkbox inside a list item is checked.
                */
            isCheckboxCheckedAtIndex(index: number): boolean;
            /**
                * @return true if root element is focused.
                */
            isRootFocused(): boolean;
            /**
                * @param index list item index.
                * @param className the name of the class whose presence is to be checked.
                * @return true if list item at `index` has class `className`.
                */
            listItemAtIndexHasClass(index: number, className: string): boolean;
            /**
                * Sets the checked status of checkbox or radio at given list item index.
                */
            setCheckedCheckboxOrRadioAtIndex(index: number, isChecked: boolean): void;
            /**
                * Notifies user action on list item.
                */
            notifyAction(index: number): void;
            /**
                * @return true when the current focused element is inside list root.
                */
            isFocusInsideList(): boolean;
            /**
                * @return the primary text content of the list item at index.
                */
            getPrimaryTextAtIndex(index: number): string;
    }
}

declare module '@material/list/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCListFoundation } from '@material/list/foundation';
    import { MDCListIndex } from '@material/list/types';
    export type MDCListFactory = (el: Element, foundation?: MDCListFoundation) => MDCList;
    export class MDCList extends MDCComponent<MDCListFoundation> {
            set vertical(value: boolean);
            get listElements(): Element[];
            set wrapFocus(value: boolean);
            /**
                * @return Whether typeahead is currently matching a user-specified prefix.
                */
            get typeaheadInProgress(): boolean;
            /**
                * Sets whether typeahead functionality is enabled on the list.
                * @param hasTypeahead Whether typeahead is enabled.
                */
            set hasTypeahead(hasTypeahead: boolean);
            set singleSelection(isSingleSelectionList: boolean);
            get selectedIndex(): MDCListIndex;
            set selectedIndex(index: MDCListIndex);
            static attachTo(root: Element): MDCList;
            initialSyncWithDOM(): void;
            destroy(): void;
            layout(): void;
            /**
                * Extracts the primary text from a list item.
                * @param item The list item element.
                * @return The primary text in the element.
                */
            getPrimaryText(item: Element): string;
            /**
                * Initialize selectedIndex value based on pre-selected list items.
                */
            initializeListType(): void;
            /**
                * Updates the list item at itemIndex to the desired isEnabled state.
                * @param itemIndex Index of the list item
                * @param isEnabled Sets the list item to enabled or disabled.
                */
            setEnabled(itemIndex: number, isEnabled: boolean): void;
            /**
                * Given the next desired character from the user, adds it to the typeahead
                * buffer. Then, attempts to find the next option matching the buffer. Wraps
                * around if at the end of options.
                *
                * @param nextChar The next character to add to the prefix buffer.
                * @param startingIndex The index from which to start matching. Defaults to
                *     the currently focused index.
                * @return The index of the matched item.
                */
            typeaheadMatchItem(nextChar: string, startingIndex?: number): number;
            getDefaultFoundation(): MDCListFoundation;
    }
}

declare module '@material/list/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        LIST_ITEM_ACTIVATED_CLASS: string;
        LIST_ITEM_CLASS: string;
        LIST_ITEM_DISABLED_CLASS: string;
        LIST_ITEM_SELECTED_CLASS: string;
        LIST_ITEM_TEXT_CLASS: string;
        LIST_ITEM_PRIMARY_TEXT_CLASS: string;
        ROOT: string;
    };
    const evolutionClassNameMap: {
        [x: string]: string;
    };
    const deprecatedClassNameMap: {
        [x: string]: string;
    };
    const strings: {
        ACTION_EVENT: string;
        ARIA_CHECKED: string;
        ARIA_CHECKED_CHECKBOX_SELECTOR: string;
        ARIA_CHECKED_RADIO_SELECTOR: string;
        ARIA_CURRENT: string;
        ARIA_DISABLED: string;
        ARIA_ORIENTATION: string;
        ARIA_ORIENTATION_HORIZONTAL: string;
        ARIA_ROLE_CHECKBOX_SELECTOR: string;
        ARIA_SELECTED: string;
        ARIA_INTERACTIVE_ROLES_SELECTOR: string;
        ARIA_MULTI_SELECTABLE_SELECTOR: string;
        CHECKBOX_RADIO_SELECTOR: string;
        CHECKBOX_SELECTOR: string;
        CHILD_ELEMENTS_TO_TOGGLE_TABINDEX: string;
        DEPRECATED_SELECTOR: string;
        FOCUSABLE_CHILD_ELEMENTS: string;
        RADIO_SELECTOR: string;
        SELECTED_ITEM_SELECTOR: string;
    };
    const numbers: {
        UNSET_INDEX: number;
        TYPEAHEAD_BUFFER_CLEAR_TIMEOUT_MS: number;
    };
    const evolutionAttribute = "evolution";
    export { strings, cssClasses, numbers, deprecatedClassNameMap, evolutionAttribute, evolutionClassNameMap };
}

declare module '@material/list/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCListAdapter } from '@material/list/adapter';
    import { MDCListIndex } from '@material/list/types';
    export class MDCListFoundation extends MDCFoundation<MDCListAdapter> {
            static get strings(): {
                    ACTION_EVENT: string;
                    ARIA_CHECKED: string;
                    ARIA_CHECKED_CHECKBOX_SELECTOR: string;
                    ARIA_CHECKED_RADIO_SELECTOR: string;
                    ARIA_CURRENT: string;
                    ARIA_DISABLED: string;
                    ARIA_ORIENTATION: string;
                    ARIA_ORIENTATION_HORIZONTAL: string;
                    ARIA_ROLE_CHECKBOX_SELECTOR: string;
                    ARIA_SELECTED: string;
                    ARIA_INTERACTIVE_ROLES_SELECTOR: string;
                    ARIA_MULTI_SELECTABLE_SELECTOR: string;
                    CHECKBOX_RADIO_SELECTOR: string;
                    CHECKBOX_SELECTOR: string;
                    CHILD_ELEMENTS_TO_TOGGLE_TABINDEX: string;
                    DEPRECATED_SELECTOR: string;
                    FOCUSABLE_CHILD_ELEMENTS: string;
                    RADIO_SELECTOR: string;
                    SELECTED_ITEM_SELECTOR: string;
            };
            static get cssClasses(): {
                    LIST_ITEM_ACTIVATED_CLASS: string;
                    LIST_ITEM_CLASS: string;
                    LIST_ITEM_DISABLED_CLASS: string;
                    LIST_ITEM_SELECTED_CLASS: string;
                    LIST_ITEM_TEXT_CLASS: string;
                    LIST_ITEM_PRIMARY_TEXT_CLASS: string;
                    ROOT: string;
            };
            static get numbers(): {
                    UNSET_INDEX: number;
                    TYPEAHEAD_BUFFER_CLEAR_TIMEOUT_MS: number;
            };
            static get defaultAdapter(): MDCListAdapter;
            constructor(adapter?: Partial<MDCListAdapter>);
            layout(): void;
            /** Returns the index of the item that was last focused. */
            getFocusedItemIndex(): number;
            /** Toggles focus wrapping with keyboard navigation. */
            setWrapFocus(value: boolean): void;
            /**
                * Toggles orientation direction for keyboard navigation (true for vertical,
                * false for horizontal).
                */
            setVerticalOrientation(value: boolean): void;
            /** Toggles single-selection behavior. */
            setSingleSelection(value: boolean): void;
            /**
                * Sets whether typeahead is enabled on the list.
                * @param hasTypeahead Whether typeahead is enabled.
                */
            setHasTypeahead(hasTypeahead: boolean): void;
            /**
                * @return Whether typeahead is currently matching a user-specified prefix.
                */
            isTypeaheadInProgress(): boolean;
            /** Toggle use of the "activated" CSS class. */
            setUseActivatedClass(useActivated: boolean): void;
            /**
                * Toggles use of the selected attribute (true for aria-selected, false for
                * aria-checked).
                */
            setUseSelectedAttribute(useSelected: boolean): void;
            getSelectedIndex(): MDCListIndex;
            setSelectedIndex(index: MDCListIndex, { forceUpdate }?: {
                    forceUpdate?: boolean;
            }): void;
            /**
                * Focus in handler for the list items.
                */
            handleFocusIn(listItemIndex: number): void;
            /**
                * Focus out handler for the list items.
                */
            handleFocusOut(listItemIndex: number): void;
            /**
                * Key handler for the list.
                */
            handleKeydown(event: KeyboardEvent, isRootListItem: boolean, listItemIndex: number): void;
            /**
                * Click handler for the list.
                */
            handleClick(index: number, toggleCheckbox: boolean): void;
            /**
                * Focuses the next element on the list.
                */
            focusNextElement(index: number): number;
            /**
                * Focuses the previous element on the list.
                */
            focusPrevElement(index: number): number;
            focusFirstElement(): number;
            focusLastElement(): number;
            focusInitialElement(): number;
            /**
                * @param itemIndex Index of the list item
                * @param isEnabled Sets the list item to enabled or disabled.
                */
            setEnabled(itemIndex: number, isEnabled: boolean): void;
            /**
                * Given the next desired character from the user, adds it to the typeahead
                * buffer. Then, attempts to find the next option matching the buffer. Wraps
                * around if at the end of options.
                *
                * @param nextChar The next character to add to the prefix buffer.
                * @param startingIndex The index from which to start matching. Only relevant
                *     when starting a new match sequence. To start a new match sequence,
                *     clear the buffer using `clearTypeaheadBuffer`, or wait for the buffer
                *     to clear after a set interval defined in list foundation. Defaults to
                *     the currently focused index.
                * @return The index of the matched item, or -1 if no match.
                */
            typeaheadMatchItem(nextChar: string, startingIndex?: number, skipFocus?: boolean): number;
            /**
                * Clears the typeahead buffer.
                */
            clearTypeaheadBuffer(): void;
    }
    export default MDCListFoundation;
}

declare module '@material/list/types' {
    /**
        * @license
        * Copyright 2019 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    export interface MDCListActionEventDetail {
            /**
                * Index of the list item that was activated.
                */
            index: number;
    }
    export interface MDCListActionEvent extends Event {
            detail: MDCListActionEventDetail;
    }
    export type MDCListIndex = number | number[];
    /**
        * Type used by the typeahead mechanism to keep track of the index associated
        * with list item text.
        */
    export interface MDCListTextAndIndex {
            text: string;
            index: number;
    }
}

