// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../@material/menu-surface/constants
//   ../../../@material/base/component
//   ../../../@material/list/index
//   ../../../@material/menu-surface/index
//   ../../../@material/menu-surface/types
//   ../../../@material/base/foundation

declare module 'mdc-menu' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export { Corner } from '@material/menu-surface/constants';
    export * from 'mdc-menu/adapter';
    export * from 'mdc-menu/component';
    export * from 'mdc-menu/foundation';
    export * from 'mdc-menu/types';
}

declare module 'mdc-menu/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCMenuItemEventDetail } from 'mdc-menu/types';
    /**
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCMenuAdapter {
            /**
                * Adds a class to the element at the index provided.
                */
            addClassToElementAtIndex(index: number, className: string): void;
            /**
                * Removes a class from the element at the index provided
                */
            removeClassFromElementAtIndex(index: number, className: string): void;
            /**
                * Adds an attribute, with value, to the element at the index provided.
                */
            addAttributeToElementAtIndex(index: number, attr: string, value: string): void;
            /**
                * Removes an attribute from an element at the index provided.
                */
            removeAttributeFromElementAtIndex(index: number, attr: string): void;
            /**
                * @return true if the element contains the className.
                */
            elementContainsClass(element: Element, className: string): boolean;
            /**
                * Closes the menu-surface.
                */
            closeSurface(): void;
            /**
                * @return Index of the element in the list or -1 if it is not in the list.
                */
            getElementIndex(element: Element): number;
            /**
                * @return The parentElement of the provided element.
                */
            getParentElement(element: Element): Element | null;
            /**
                * @return The element within the selectionGroup containing the selected element class.
                */
            getSelectedElementIndex(selectionGroup: Element): number;
            /**
                * Emit an event when a menu item is selected.
                */
            notifySelected(evtData: MDCMenuItemEventDetail): void;
    }
}

declare module 'mdc-menu/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCListFactory } from '@material/list/index';
    import { Corner, MDCMenuSurfaceFactory } from '@material/menu-surface/index';
    import { MDCMenuDistance } from '@material/menu-surface/types';
    import { MDCMenuFoundation } from 'mdc-menu/foundation';
    export type MDCMenuFactory = (el: Element, foundation?: MDCMenuFoundation) => MDCMenu;
    export class MDCMenu extends MDCComponent<MDCMenuFoundation> {
            static attachTo(root: Element): MDCMenu;
            initialize(menuSurfaceFactory?: MDCMenuSurfaceFactory, listFactory?: MDCListFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            open: boolean;
            wrapFocus: boolean;
            /**
                * Return the items within the menu. Note that this only contains the set of elements within
                * the items container that are proper list items, and not supplemental / presentational DOM
                * elements.
                */
            readonly items: Element[];
            quickOpen: boolean;
            /**
                * @param corner Default anchor corner alignment of top-left menu corner.
                */
            setAnchorCorner(corner: Corner): void;
            setAnchorMargin(margin: Partial<MDCMenuDistance>): void;
            /**
                * @return The item within the menu at the index specified.
                */
            getOptionByIndex(index: number): Element | null;
            setFixedPosition(isFixed: boolean): void;
            hoistMenuToBody(): void;
            setIsHoisted(isHoisted: boolean): void;
            setAbsolutePosition(x: number, y: number): void;
            /**
                * Sets the element that the menu-surface is anchored to.
                */
            setAnchorElement(element: Element): void;
            handleAfterOpened_(): void;
            getDefaultFoundation(): MDCMenuFoundation;
    }
}

declare module 'mdc-menu/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCMenuAdapter } from 'mdc-menu/adapter';
    export class MDCMenuFoundation extends MDCFoundation<MDCMenuAdapter> {
            static readonly cssClasses: {
                    MENU_SELECTED_LIST_ITEM: string;
                    MENU_SELECTION_GROUP: string;
                    ROOT: string;
            };
            static readonly strings: {
                    ARIA_SELECTED_ATTR: string;
                    CHECKBOX_SELECTOR: string;
                    LIST_SELECTOR: string;
                    SELECTED_EVENT: string;
            };
            /**
                * @see {@link MDCMenuAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCMenuAdapter;
            constructor(adapter?: Partial<MDCMenuAdapter>);
            destroy(): void;
            handleKeydown(evt: KeyboardEvent): void;
            handleItemAction(listItem: Element): void;
    }
    export default MDCMenuFoundation;
}

declare module 'mdc-menu/types' {
    /**
        * Event properties used by the adapter and foundation.
        */
    export interface MDCMenuItemEventDetail {
            index: number;
    }
    /**
        * Event properties specific to the default component implementation.
        */
    export interface MDCMenuItemComponentEventDetail extends MDCMenuItemEventDetail {
            item: Element;
    }
    export interface MDCMenuItemEvent extends Event {
            readonly detail: MDCMenuItemEventDetail;
    }
    export interface MDCMenuItemComponentEvent extends Event {
            readonly detail: MDCMenuItemComponentEventDetail;
    }
}

