// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/menu-surface/constants
//   ../../@material/base/component
//   ../../@material/list/component
//   ../../@material/list/types
//   ../../@material/menu-surface/component
//   ../../@material/menu-surface/types
//   ../../@material/base/foundation

declare module '@material/menu' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export { Corner } from '@material/menu-surface/constants';
    export * from '@material/menu/adapter';
    export * from '@material/menu/component';
    export * from '@material/menu/constants';
    export * from '@material/menu/foundation';
    export * from '@material/menu/types';
}

declare module '@material/menu/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCMenuItemEventDetail } from '@material/menu/types';
    /**
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCMenuAdapter {
            /**
                * Adds a class to the element at the index provided.
                */
            addClassToElementAtIndex(index: number, className: string): void;
            /**
                * Removes a class from the element at the index provided
                */
            removeClassFromElementAtIndex(index: number, className: string): void;
            /**
                * Adds an attribute, with value, to the element at the index provided.
                */
            addAttributeToElementAtIndex(index: number, attr: string, value: string): void;
            /**
                * Removes an attribute from an element at the index provided.
                */
            removeAttributeFromElementAtIndex(index: number, attr: string): void;
            /**
                * @return true if the element contains the className.
                */
            elementContainsClass(element: Element, className: string): boolean;
            /**
                * Closes the menu-surface.
                * @param skipRestoreFocus Whether to skip restoring focus to the previously
                *    focused element after the surface has been closed.
                */
            closeSurface(skipRestoreFocus?: boolean): void;
            /**
                * @return Index of the element in the list or -1 if it is not in the list.
                */
            getElementIndex(element: Element): number;
            /**
                * Emit an event when a menu item is selected.
                */
            notifySelected(evtData: MDCMenuItemEventDetail): void;
            /** @return Returns the menu item count. */
            getMenuItemCount(): number;
            /**
                * Focuses the menu item at given index.
                * @param index Index of the menu item that will be focused every time the menu opens.
                */
            focusItemAtIndex(index: number): void;
            /** Focuses the list root element. */
            focusListRoot(): void;
            /**
                * @return Returns selected list item index within the same selection group which is
                * a sibling of item at given `index`.
                * @param index Index of the menu item with possible selected sibling.
                */
            getSelectedSiblingOfItemAtIndex(index: number): number;
            /**
                * @return Returns true if item at specified index is contained within an `.mdc-menu__selection-group` element.
                * @param index Index of the selectable menu item.
                */
            isSelectableItemAtIndex(index: number): boolean;
    }
}

declare module '@material/menu/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCListFactory } from '@material/list/component';
    import { MDCListIndex } from '@material/list/types';
    import { MDCMenuSurfaceFactory } from '@material/menu-surface/component';
    import { Corner } from '@material/menu-surface/constants';
    import { MDCMenuDistance } from '@material/menu-surface/types';
    import { DefaultFocusState } from '@material/menu/constants';
    import { MDCMenuFoundation } from '@material/menu/foundation';
    export type MDCMenuFactory = (el: Element, foundation?: MDCMenuFoundation) => MDCMenu;
    export class MDCMenu extends MDCComponent<MDCMenuFoundation> {
            static attachTo(root: Element): MDCMenu;
            initialize(menuSurfaceFactory?: MDCMenuSurfaceFactory, listFactory?: MDCListFactory): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            get open(): boolean;
            set open(value: boolean);
            get wrapFocus(): boolean;
            set wrapFocus(value: boolean);
            /**
                * Sets whether the menu has typeahead functionality.
                * @param value Whether typeahead is enabled.
                */
            set hasTypeahead(value: boolean);
            /**
                * @return Whether typeahead logic is currently matching some user prefix.
                */
            get typeaheadInProgress(): boolean;
            /**
                * Given the next desired character from the user, adds it to the typeahead
                * buffer. Then, attempts to find the next option matching the buffer. Wraps
                * around if at the end of options.
                *
                * @param nextChar The next character to add to the prefix buffer.
                * @param startingIndex The index from which to start matching. Only relevant
                *     when starting a new match sequence. To start a new match sequence,
                *     clear the buffer using `clearTypeaheadBuffer`, or wait for the buffer
                *     to clear after a set interval defined in list foundation. Defaults to
                *     the currently focused index.
                * @return The index of the matched item, or -1 if no match.
                */
            typeaheadMatchItem(nextChar: string, startingIndex?: number): number;
            /**
                * Layout the underlying list element in the case of any dynamic updates
                * to its structure.
                */
            layout(): void;
            /**
                * Return the items within the menu. Note that this only contains the set of elements within
                * the items container that are proper list items, and not supplemental / presentational DOM
                * elements.
                */
            get items(): Element[];
            /**
                * Turns on/off the underlying list's single selection mode. Used mainly
                * by select menu.
                *
                * @param singleSelection Whether to enable single selection mode.
                */
            set singleSelection(singleSelection: boolean);
            /**
                * Retrieves the selected index. Only applicable to select menus.
                * @return The selected index, which is a number for single selection and
                *     radio lists, and an array of numbers for checkbox lists.
                */
            get selectedIndex(): MDCListIndex;
            /**
                * Sets the selected index of the list. Only applicable to select menus.
                * @param index The selected index, which is a number for single selection and
                *     radio lists, and an array of numbers for checkbox lists.
                */
            set selectedIndex(index: MDCListIndex);
            set quickOpen(quickOpen: boolean);
            /**
                * Sets default focus state where the menu should focus every time when menu
                * is opened. Focuses the list root (`DefaultFocusState.LIST_ROOT`) element by
                * default.
                * @param focusState Default focus state.
                */
            setDefaultFocusState(focusState: DefaultFocusState): void;
            /**
                * @param corner Default anchor corner alignment of top-left menu corner.
                */
            setAnchorCorner(corner: Corner): void;
            setAnchorMargin(margin: Partial<MDCMenuDistance>): void;
            /**
                * Sets the list item as the selected row at the specified index.
                * @param index Index of list item within menu.
                */
            setSelectedIndex(index: number): void;
            /**
                * Sets the enabled state to isEnabled for the menu item at the given index.
                * @param index Index of the menu item
                * @param isEnabled The desired enabled state of the menu item.
                */
            setEnabled(index: number, isEnabled: boolean): void;
            /**
                * @return The item within the menu at the index specified.
                */
            getOptionByIndex(index: number): Element | null;
            /**
                * @param index A menu item's index.
                * @return The primary text within the menu at the index specified.
                */
            getPrimaryTextAtIndex(index: number): string;
            setFixedPosition(isFixed: boolean): void;
            setIsHoisted(isHoisted: boolean): void;
            setAbsolutePosition(x: number, y: number): void;
            /**
                * Sets the element that the menu-surface is anchored to.
                */
            setAnchorElement(element: Element): void;
            getDefaultFoundation(): MDCMenuFoundation;
    }
}

declare module '@material/menu/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        MENU_SELECTED_LIST_ITEM: string;
        MENU_SELECTION_GROUP: string;
        ROOT: string;
    };
    const strings: {
        ARIA_CHECKED_ATTR: string;
        ARIA_DISABLED_ATTR: string;
        CHECKBOX_SELECTOR: string;
        LIST_SELECTOR: string;
        SELECTED_EVENT: string;
    };
    const numbers: {
        FOCUS_ROOT_INDEX: number;
    };
    enum DefaultFocusState {
        NONE = 0,
        LIST_ROOT = 1,
        FIRST_ITEM = 2,
        LAST_ITEM = 3
    }
    export { cssClasses, strings, numbers, DefaultFocusState };
}

declare module '@material/menu/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCMenuAdapter } from '@material/menu/adapter';
    import { DefaultFocusState } from '@material/menu/constants';
    export class MDCMenuFoundation extends MDCFoundation<MDCMenuAdapter> {
            static get cssClasses(): {
                    MENU_SELECTED_LIST_ITEM: string;
                    MENU_SELECTION_GROUP: string;
                    ROOT: string;
            };
            static get strings(): {
                    ARIA_CHECKED_ATTR: string;
                    ARIA_DISABLED_ATTR: string;
                    CHECKBOX_SELECTOR: string;
                    LIST_SELECTOR: string;
                    SELECTED_EVENT: string;
            };
            static get numbers(): {
                    FOCUS_ROOT_INDEX: number;
            };
            /**
                * @see {@link MDCMenuAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCMenuAdapter;
            constructor(adapter?: Partial<MDCMenuAdapter>);
            destroy(): void;
            handleKeydown(evt: KeyboardEvent): void;
            handleItemAction(listItem: Element): void;
            handleMenuSurfaceOpened(): void;
            /**
                * Sets default focus state where the menu should focus every time when menu
                * is opened. Focuses the list root (`DefaultFocusState.LIST_ROOT`) element by
                * default.
                */
            setDefaultFocusState(focusState: DefaultFocusState): void;
            /** @return Index of the currently selected list item within the menu. */
            getSelectedIndex(): number;
            /**
                * Selects the list item at `index` within the menu.
                * @param index Index of list item within the menu.
                */
            setSelectedIndex(index: number): void;
            /**
                * Sets the enabled state to isEnabled for the menu item at the given index.
                * @param index Index of the menu item
                * @param isEnabled The desired enabled state of the menu item.
                */
            setEnabled(index: number, isEnabled: boolean): void;
    }
    export default MDCMenuFoundation;
}

declare module '@material/menu/types' {
    /**
        * Event properties used by the adapter and foundation.
        */
    export interface MDCMenuItemEventDetail {
            index: number;
    }
    /**
        * Event properties specific to the default component implementation.
        */
    export interface MDCMenuItemComponentEventDetail extends MDCMenuItemEventDetail {
            item: Element;
    }
    export interface MDCMenuItemEvent extends Event {
            readonly detail: MDCMenuItemEventDetail;
    }
    export interface MDCMenuItemComponentEvent extends Event {
            readonly detail: MDCMenuItemComponentEventDetail;
    }
}

