/**
 * @license
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import MDCFoundation from '@material/base/foundation';
import MDCSelectLabelAdapter from './adapter';
import {cssClasses} from './constants';

/**
 * @extends {MDCFoundation<!MDCSelectLabelAdapter>}
 * @final
 */
class MDCSelectLabelFoundation extends MDCFoundation {
  /** @return enum {string} */
  static get cssClasses() {
    return cssClasses;
  }

  /**
   * {@see MDCSelectLabelAdapter} for typing information on parameters and return
   * types.
   * @return {!MDCSelectLabelAdapter}
   */
  static get defaultAdapter() {
    return /** @type {!MDCSelectLabelAdapter} */ ({
      addClass: () => {},
      removeClass: () => {},
      getWidth: () => {},
    });
  }

  /**
   * @param {!MDCSelectLabelAdapter} adapter
   */
  constructor(adapter) {
    super(Object.assign(MDCSelectLabelFoundation.defaultAdapter, adapter));
  }

  /**
   * Styles the label to float or defloat as necessary.
   * @param {string} value The value of the input.
   */
  styleFloat(value) {
    const {LABEL_FLOAT_ABOVE} = MDCSelectLabelFoundation.cssClasses;
    if (!!value) {
      this.adapter_.addClass(LABEL_FLOAT_ABOVE);
    } else {
      this.adapter_.removeClass(LABEL_FLOAT_ABOVE);
    }
  }
}

export default MDCSelectLabelFoundation;
