// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/menu-surface/constants
//   ../../@material/base/component
//   ../../@material/floating-label/component
//   ../../@material/line-ripple/component
//   ../../@material/menu/component
//   ../../@material/notched-outline/component
//   ../../@material/base/foundation
//   ../../@material/base/types

declare module '@material/select' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/adapter';
    export * from '@material/select/component';
    export * from '@material/select/constants';
    export * from '@material/select/foundation';
    export * from '@material/select/types';
    export * from '@material/select/helper-text/index';
    export * from '@material/select/icon/index';
}

declare module '@material/select/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { Corner } from '@material/menu-surface/constants';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectAdapter {
            /**
                * Adds class to select anchor element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the select anchor element.
                */
            removeClass(className: string): void;
            /**
                * Returns true if the select anchor element contains the given class name.
                */
            hasClass(className: string): boolean;
            /**
                * Activates the bottom line, showing a focused state.
                */
            activateBottomLine(): void;
            /**
                * Deactivates the bottom line.
                */
            deactivateBottomLine(): void;
            /**
                * Returns true if label exists, false if it doesn't.
                */
            hasLabel(): boolean;
            /**
                * Floats label determined based off of the shouldFloat argument.
                */
            floatLabel(shouldFloat: boolean): void;
            /**
                * Returns width of label in pixels, if the label exists.
                */
            getLabelWidth(): number;
            /**
                * Styles the label as required, if the label exists.
                */
            setLabelRequired(isRequired: boolean): void;
            /**
                * Returns true if outline element exists, false if it doesn't.
                */
            hasOutline(): boolean;
            /**
                * Only implement if outline element exists.
                */
            notchOutline(labelWidth: number): void;
            /**
                * Closes notch in outline element, if the outline exists.
                */
            closeOutline(): void;
            /**
                * Sets the line ripple transform origin center.
                */
            setRippleCenter(normalizedX: number): void;
            /**
                * Emits a change event when an element is selected.
                */
            notifyChange(value: string): void;
            /**
                * Sets the text content of the selectedText element to the given string.
                */
            setSelectedText(text: string): void;
            /**
                * Returns whether the select anchor is focused.
                */
            isSelectAnchorFocused(): boolean;
            /**
                * Gets the given attribute on the select anchor element.
                */
            getSelectAnchorAttr(attr: string): string | null;
            /**
                * Sets the given attribute on the select anchor element.
                */
            setSelectAnchorAttr(attr: string, value: string): void;
            /**
                * Removes the given attribute on the select anchor element.
                */
            removeSelectAnchorAttr(attr: string): void;
            /**
                * Adds class to the menu element.
                */
            addMenuClass(className: string): void;
            /**
                * Removes a class from the menu element.
                */
            removeMenuClass(className: string): void;
            /**
                * Opens the menu.
                */
            openMenu(): void;
            /**
                * Closes the menu.
                */
            closeMenu(): void;
            /**
                * Returns the select anchor element.
                */
            getAnchorElement(): Element | null;
            /**
                * Sets the menu anchor element.
                */
            setMenuAnchorElement(anchorEl: Element): void;
            /**
                * Sets the menu anchor corner.
                */
            setMenuAnchorCorner(anchorCorner: Corner): void;
            /**
                * Sets whether the menu should wrap focus.
                */
            setMenuWrapFocus(wrapFocus: boolean): void;
            /**
                * Focuses the menu item element at the given index.
                */
            focusMenuItemAtIndex(index: number): void;
            /**
                * Returns the number of menu items.
                */
            getMenuItemCount(): number;
            /**
                * Returns an array representing the VALUE_ATTR attributes of each menu item.
                */
            getMenuItemValues(): string[];
            /**
                * Gets the text content of the menu item element at the given index.
                */
            getMenuItemTextAtIndex(index: number): string;
            /**
                * Returns the selected index.
                */
            getSelectedIndex(): number;
            /**
                * Sets the selected index in the menu.
                */
            setSelectedIndex(index: number): void;
            /**
                * Returns whether typeahead is in progress in the menu.
                */
            isTypeaheadInProgress(): boolean;
            /**
                * Adds a character to the list typeahead buffer and returns index of the
                * next item in the list matching the buffer.
                */
            typeaheadMatchItem(nextChar: string, startingIndex: number): number;
    }
}

declare module '@material/select/component' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCFloatingLabelFactory } from '@material/floating-label/component';
    import { MDCLineRippleFactory } from '@material/line-ripple/component';
    import { MDCMenuFactory } from '@material/menu/component';
    import { MDCNotchedOutlineFactory } from '@material/notched-outline/component';
    import { MDCSelectFoundation } from '@material/select/foundation';
    import { MDCSelectHelperTextFactory } from '@material/select/helper-text/component';
    import { MDCSelectIconFactory } from '@material/select/icon/component';
    export class MDCSelect extends MDCComponent<MDCSelectFoundation> {
            static attachTo(root: Element): MDCSelect;
            initialize(labelFactory?: MDCFloatingLabelFactory, lineRippleFactory?: MDCLineRippleFactory, outlineFactory?: MDCNotchedOutlineFactory, menuFactory?: MDCMenuFactory, iconFactory?: MDCSelectIconFactory, helperTextFactory?: MDCSelectHelperTextFactory): void;
            /**
                * Initializes the select's event listeners and internal state based
                * on the environment's state.
                */
            initialSyncWithDOM(): void;
            destroy(): void;
            get value(): string;
            set value(value: string);
            get selectedIndex(): number;
            set selectedIndex(selectedIndex: number);
            get disabled(): boolean;
            set disabled(disabled: boolean);
            set leadingIconAriaLabel(label: string);
            /**
                * Sets the text content of the leading icon.
                */
            set leadingIconContent(content: string);
            /**
                * Sets the text content of the helper text.
                */
            set helperTextContent(content: string);
            /**
                * Enables or disables the default validation scheme where a required select
                * must be non-empty. Set to false for custom validation.
                * @param useDefaultValidation Set this to false to ignore default
                *     validation scheme.
                */
            set useDefaultValidation(useDefaultValidation: boolean);
            /**
                * Sets the current invalid state of the select.
                */
            set valid(isValid: boolean);
            /**
                * Checks if the select is in a valid state.
                */
            get valid(): boolean;
            /**
                * Sets the control to the required state.
                */
            set required(isRequired: boolean);
            /**
                * Returns whether the select is required.
                */
            get required(): boolean;
            /**
                * Re-calculates if the notched outline should be notched and if the label
                * should float.
                */
            layout(): void;
            /**
                * Synchronizes the list of options with the state of the foundation. Call
                * this whenever menu options are dynamically updated.
                */
            layoutOptions(): void;
            getDefaultFoundation(): MDCSelectFoundation;
    }
}

declare module '@material/select/constants' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        ACTIVATED: string;
        DISABLED: string;
        FOCUSED: string;
        INVALID: string;
        MENU_INVALID: string;
        OUTLINED: string;
        REQUIRED: string;
        ROOT: string;
        WITH_LEADING_ICON: string;
    };
    const strings: {
        ARIA_CONTROLS: string;
        ARIA_DESCRIBEDBY: string;
        ARIA_SELECTED_ATTR: string;
        CHANGE_EVENT: string;
        HIDDEN_INPUT_SELECTOR: string;
        LABEL_SELECTOR: string;
        LEADING_ICON_SELECTOR: string;
        LINE_RIPPLE_SELECTOR: string;
        MENU_SELECTOR: string;
        OUTLINE_SELECTOR: string;
        SELECTED_TEXT_SELECTOR: string;
        SELECT_ANCHOR_SELECTOR: string;
        VALUE_ATTR: string;
    };
    const numbers: {
        LABEL_SCALE: number;
        UNSET_INDEX: number;
        CLICK_DEBOUNCE_TIMEOUT_MS: number;
    };
    export { cssClasses, strings, numbers };
}

declare module '@material/select/foundation' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectAdapter } from '@material/select/adapter';
    import { MDCSelectFoundationMap } from '@material/select/types';
    export class MDCSelectFoundation extends MDCFoundation<MDCSelectAdapter> {
            static get cssClasses(): {
                    ACTIVATED: string;
                    DISABLED: string;
                    FOCUSED: string;
                    INVALID: string;
                    MENU_INVALID: string;
                    OUTLINED: string;
                    REQUIRED: string;
                    ROOT: string;
                    WITH_LEADING_ICON: string;
            };
            static get numbers(): {
                    LABEL_SCALE: number;
                    UNSET_INDEX: number;
                    CLICK_DEBOUNCE_TIMEOUT_MS: number;
            };
            static get strings(): {
                    ARIA_CONTROLS: string;
                    ARIA_DESCRIBEDBY: string;
                    ARIA_SELECTED_ATTR: string;
                    CHANGE_EVENT: string;
                    HIDDEN_INPUT_SELECTOR: string;
                    LABEL_SELECTOR: string;
                    LEADING_ICON_SELECTOR: string;
                    LINE_RIPPLE_SELECTOR: string;
                    MENU_SELECTOR: string;
                    OUTLINE_SELECTOR: string;
                    SELECTED_TEXT_SELECTOR: string;
                    SELECT_ANCHOR_SELECTOR: string;
                    VALUE_ATTR: string;
            };
            /**
                * See {@link MDCSelectAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCSelectAdapter;
            /**
                * @param adapter
                * @param foundationMap Map from subcomponent names to their subfoundations.
                */
            constructor(adapter?: Partial<MDCSelectAdapter>, foundationMap?: Partial<MDCSelectFoundationMap>);
            /** Returns the index of the currently selected menu item, or -1 if none. */
            getSelectedIndex(): number;
            setSelectedIndex(index: number, closeMenu?: boolean, skipNotify?: boolean): void;
            setValue(value: string, skipNotify?: boolean): void;
            getValue(): string;
            getDisabled(): boolean;
            setDisabled(isDisabled: boolean): void;
            /** Opens the menu. */
            openMenu(): void;
            /**
                * @param content Sets the content of the helper text.
                */
            setHelperTextContent(content: string): void;
            /**
                * Re-calculates if the notched outline should be notched and if the label
                * should float.
                */
            layout(): void;
            /**
                * Synchronizes the list of options with the state of the foundation. Call
                * this whenever menu options are dynamically updated.
                */
            layoutOptions(): void;
            handleMenuOpened(): void;
            handleMenuClosing(): void;
            handleMenuClosed(): void;
            /**
                * Handles value changes, via change event or programmatic updates.
                */
            handleChange(): void;
            handleMenuItemAction(index: number): void;
            /**
                * Handles focus events from select element.
                */
            handleFocus(): void;
            /**
                * Handles blur events from select element.
                */
            handleBlur(): void;
            handleClick(normalizedX: number): void;
            /**
                * Handles keydown events on select element. Depending on the type of
                * character typed, does typeahead matching or opens menu.
                */
            handleKeydown(event: KeyboardEvent): void;
            /**
                * Opens/closes the notched outline.
                */
            notchOutline(openNotch: boolean): void;
            /**
                * Sets the aria label of the leading icon.
                */
            setLeadingIconAriaLabel(label: string): void;
            /**
                * Sets the text content of the leading icon.
                */
            setLeadingIconContent(content: string): void;
            setUseDefaultValidation(useDefaultValidation: boolean): void;
            setValid(isValid: boolean): void;
            isValid(): boolean;
            setRequired(isRequired: boolean): void;
            getRequired(): boolean;
            init(): void;
    }
    export default MDCSelectFoundation;
}

declare module '@material/select/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCSelectHelperTextFoundation } from '@material/select/helper-text/foundation';
    import { MDCSelectIconFoundation } from '@material/select/icon/foundation';
    export interface MDCSelectFoundationMap {
        leadingIcon: MDCSelectIconFoundation;
        helperText: MDCSelectHelperTextFoundation;
    }
    export interface MDCSelectEventDetail {
        value: string;
        index: number;
    }
    export interface MDCSelectEvent extends Event {
        readonly detail: MDCSelectEventDetail;
    }
}

declare module '@material/select/helper-text/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/helper-text/adapter';
    export * from '@material/select/helper-text/component';
    export * from '@material/select/helper-text/foundation';
    export { cssClasses as helperTextCssClasses, strings as helperTextStrings } from '@material/select/helper-text/constants';
}

declare module '@material/select/icon/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/icon/adapter';
    export * from '@material/select/icon/component';
    export * from '@material/select/icon/foundation';
    export { strings as iconStrings } from '@material/select/icon/constants';
}

declare module '@material/select/helper-text/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCSelectHelperTextFoundation } from '@material/select/helper-text/foundation';
    export type MDCSelectHelperTextFactory = (el: Element, foundation?: MDCSelectHelperTextFoundation) => MDCSelectHelperText;
    export class MDCSelectHelperText extends MDCComponent<MDCSelectHelperTextFoundation> {
        static attachTo(root: Element): MDCSelectHelperText;
        get foundationForSelect(): MDCSelectHelperTextFoundation;
        getDefaultFoundation(): MDCSelectHelperTextFoundation;
    }
}

declare module '@material/select/icon/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCSelectIconFoundation } from '@material/select/icon/foundation';
    export type MDCSelectIconFactory = (el: Element, foundation?: MDCSelectIconFoundation) => MDCSelectIcon;
    export class MDCSelectIcon extends MDCComponent<MDCSelectIconFoundation> {
        static attachTo(root: Element): MDCSelectIcon;
        get foundationForSelect(): MDCSelectIconFoundation;
        getDefaultFoundation(): MDCSelectIconFoundation;
    }
}

declare module '@material/select/helper-text/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectHelperTextAdapter } from '@material/select/helper-text/adapter';
    export class MDCSelectHelperTextFoundation extends MDCFoundation<MDCSelectHelperTextAdapter> {
            static get cssClasses(): {
                    HELPER_TEXT_VALIDATION_MSG: string;
                    HELPER_TEXT_VALIDATION_MSG_PERSISTENT: string;
            };
            static get strings(): {
                    ARIA_HIDDEN: string;
                    ROLE: string;
            };
            /**
                * See {@link MDCSelectHelperTextAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCSelectHelperTextAdapter;
            constructor(adapter?: Partial<MDCSelectHelperTextAdapter>);
            /**
                * @return The ID of the helper text, or null if none is set.
                */
            getId(): string | null;
            /**
                * @return Whether the helper text is currently visible.
                */
            isVisible(): boolean;
            /**
                * Sets the content of the helper text field.
                */
            setContent(content: string): void;
            /**
                * Sets the helper text to act as a validation message.
                * By default, validation messages are hidden when the select is valid and
                * visible when the select is invalid.
                *
                * @param isValidation True to make the helper text act as an error validation
                *     message.
                */
            setValidation(isValidation: boolean): void;
            /**
                * Sets the persistency of the validation helper text.
                * This keeps the validation message visible even if the select is valid,
                * though it will be displayed in the normal (grey) color.
                */
            setValidationMsgPersistent(isPersistent: boolean): void;
            /**
                * When acting as a validation message, shows/hides the helper text and
                * triggers alerts as necessary based on the select's validity.
                */
            setValidity(selectIsValid: boolean): void;
    }
    export default MDCSelectHelperTextFoundation;
}

declare module '@material/select/icon/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectIconAdapter } from '@material/select/icon/adapter';
    export class MDCSelectIconFoundation extends MDCFoundation<MDCSelectIconAdapter> {
            static get strings(): {
                    ICON_EVENT: string;
                    ICON_ROLE: string;
            };
            /**
                * See {@link MDCSelectIconAdapter} for typing information on parameters and return types.
                */
            static get defaultAdapter(): MDCSelectIconAdapter;
            constructor(adapter?: Partial<MDCSelectIconAdapter>);
            init(): void;
            destroy(): void;
            setDisabled(disabled: boolean): void;
            setAriaLabel(label: string): void;
            setContent(content: string): void;
            handleInteraction(evt: MouseEvent | KeyboardEvent): void;
    }
    export default MDCSelectIconFoundation;
}

declare module '@material/select/helper-text/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectHelperTextAdapter {
            /**
                * Adds a class to the helper text element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the helper text element.
                */
            removeClass(className: string): void;
            /**
                * Returns whether or not the helper text element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Sets an attribute with a given value on the helper text element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the helper text element.
                */
            removeAttr(attr: string): void;
            /**
                * Gets an attribute from the helper text element.
                */
            getAttr(attr: string): string | null;
            /**
                * Sets the text content for the helper text element.
                */
            setContent(content: string): void;
    }
}

declare module '@material/select/helper-text/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const strings: {
        ARIA_HIDDEN: string;
        ROLE: string;
    };
    const cssClasses: {
        HELPER_TEXT_VALIDATION_MSG: string;
        HELPER_TEXT_VALIDATION_MSG_PERSISTENT: string;
    };
    export { strings, cssClasses };
}

declare module '@material/select/icon/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventType, SpecificEventListener } from '@material/base/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectIconAdapter {
            /**
                * Gets the value of an attribute on the icon element.
                */
            getAttr(attr: string): string | null;
            /**
                * Sets an attribute on the icon element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the icon element.
                */
            removeAttr(attr: string): void;
            /**
                * Sets the text content of the icon element.
                */
            setContent(content: string): void;
            /**
                * Registers an event listener on the icon element for a given event.
                */
            registerInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event listener on the icon element for a given event.
                */
            deregisterInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Emits a custom event "MDCSelect:icon" denoting a user has clicked the icon.
                */
            notifyIconAction(): void;
    }
}

declare module '@material/select/icon/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const strings: {
        ICON_EVENT: string;
        ICON_ROLE: string;
    };
    export { strings };
}

