// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/floating-label/component
//   ../../@material/line-ripple/component
//   ../../@material/menu/component
//   ../../@material/notched-outline/component
//   ../../@material/ripple/component
//   ../../@material/ripple/types
//   ../../@material/base/foundation
//   ../../@material/base/types

declare module '@material/select' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/adapter';
    export * from '@material/select/component';
    export * from '@material/select/constants';
    export * from '@material/select/foundation';
    export * from '@material/select/types';
    export * from '@material/select/helper-text/index';
    export * from '@material/select/icon/index';
}

declare module '@material/select/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectAdapter {
            /**
                * Adds class to root element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the root element.
                */
            removeClass(className: string): void;
            /**
                * Returns true if the root element contains the given class name.
                */
            hasClass(className: string): boolean;
            /**
                * Activates the bottom line, showing a focused state.
                */
            activateBottomLine(): void;
            /**
                * Deactivates the bottom line.
                */
            deactivateBottomLine(): void;
            /**
                * Sets the value of the select.
                */
            setValue(value: string): void;
            /**
                * Returns the selected value of the select element.
                */
            getValue(): string;
            /**
                * Floats label determined based off of the shouldFloat argument.
                */
            floatLabel(shouldFloat: boolean): void;
            /**
                * Returns width of label in pixels, if the label exists.
                */
            getLabelWidth(): number;
            /**
                * Returns true if outline element exists, false if it doesn't.
                */
            hasOutline(): boolean;
            /**
                * Only implement if outline element exists.
                */
            notchOutline(labelWidth: number): void;
            /**
                * Closes notch in outline element, if the outline exists.
                */
            closeOutline(): void;
            /**
                * Opens the menu.
                */
            openMenu(): void;
            /**
                * Closes the menu.
                */
            closeMenu(): void;
            /**
                * Returns true if the menu is currently open.
                */
            isMenuOpen(): boolean;
            /**
                * Sets the selected index of the select to the index provided.
                */
            setSelectedIndex(index: number): void;
            /**
                * Sets the select to disabled.
                */
            setDisabled(isDisabled: boolean): void;
            /**
                * Sets the line ripple transform origin center.
                */
            setRippleCenter(normalizedX: number): void;
            /**
                * Emits a change event when an element is selected.
                */
            notifyChange(value: string): void;
            /**
                * Checks if the select is currently valid.
                */
            checkValidity(): boolean;
            /**
                * Adds/Removes the invalid class.
                */
            setValid(isValid: boolean): void;
    }
}

declare module '@material/select/component' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCFloatingLabelFactory } from '@material/floating-label/component';
    import { MDCLineRippleFactory } from '@material/line-ripple/component';
    import { MDCMenuFactory } from '@material/menu/component';
    import { MDCNotchedOutlineFactory } from '@material/notched-outline/component';
    import { MDCRipple } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCSelectFoundation } from '@material/select/foundation';
    import { MDCSelectHelperTextFactory } from '@material/select/helper-text/component';
    import { MDCSelectIconFactory } from '@material/select/icon/component';
    export class MDCSelect extends MDCComponent<MDCSelectFoundation> implements MDCRippleCapableSurface {
            static attachTo(root: Element): MDCSelect;
            root_: HTMLElement;
            ripple: MDCRipple | null;
            initialize(labelFactory?: MDCFloatingLabelFactory, lineRippleFactory?: MDCLineRippleFactory, outlineFactory?: MDCNotchedOutlineFactory, menuFactory?: MDCMenuFactory, iconFactory?: MDCSelectIconFactory, helperTextFactory?: MDCSelectHelperTextFactory): void;
            /**
                * Initializes the select's event listeners and internal state based
                * on the environment's state.
                */
            initialSyncWithDOM(): void;
            destroy(): void;
            value: string;
            selectedIndex: number;
            disabled: boolean;
            leadingIconAriaLabel: string;
            /**
                * Sets the text content of the leading icon.
                */
            leadingIconContent: string;
            /**
                * Sets the text content of the helper text.
                */
            helperTextContent: string;
            /**
             * Checks if the select is in a valid state.
             */
            valid: boolean;
            /**
             * Returns whether the select is required.
             */
            required: boolean;
            /**
                * Recomputes the outline SVG path for the outline element.
                */
            layout(): void;
            getDefaultFoundation(): MDCSelectFoundation;
    }
}

declare module '@material/select/constants' {
    /**
      * @license
      * Copyright 2016 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        ACTIVATED: string;
        DISABLED: string;
        FOCUSED: string;
        INVALID: string;
        OUTLINED: string;
        REQUIRED: string;
        ROOT: string;
        SELECTED_ITEM_CLASS: string;
        WITH_LEADING_ICON: string;
    };
    const strings: {
        ARIA_CONTROLS: string;
        ARIA_SELECTED_ATTR: string;
        CHANGE_EVENT: string;
        ENHANCED_VALUE_ATTR: string;
        HIDDEN_INPUT_SELECTOR: string;
        LABEL_SELECTOR: string;
        LEADING_ICON_SELECTOR: string;
        LINE_RIPPLE_SELECTOR: string;
        MENU_SELECTOR: string;
        NATIVE_CONTROL_SELECTOR: string;
        OUTLINE_SELECTOR: string;
        SELECTED_ITEM_SELECTOR: string;
        SELECTED_TEXT_SELECTOR: string;
    };
    const numbers: {
        LABEL_SCALE: number;
    };
    export { cssClasses, strings, numbers };
}

declare module '@material/select/foundation' {
    /**
        * @license
        * Copyright 2016 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectAdapter } from '@material/select/adapter';
    import { MDCSelectFoundationMap } from '@material/select/types';
    export class MDCSelectFoundation extends MDCFoundation<MDCSelectAdapter> {
            static readonly cssClasses: {
                    ACTIVATED: string;
                    DISABLED: string;
                    FOCUSED: string;
                    INVALID: string;
                    OUTLINED: string;
                    REQUIRED: string;
                    ROOT: string;
                    SELECTED_ITEM_CLASS: string;
                    WITH_LEADING_ICON: string;
            };
            static readonly numbers: {
                    LABEL_SCALE: number;
            };
            static readonly strings: {
                    ARIA_CONTROLS: string;
                    ARIA_SELECTED_ATTR: string;
                    CHANGE_EVENT: string;
                    ENHANCED_VALUE_ATTR: string;
                    HIDDEN_INPUT_SELECTOR: string;
                    LABEL_SELECTOR: string;
                    LEADING_ICON_SELECTOR: string;
                    LINE_RIPPLE_SELECTOR: string;
                    MENU_SELECTOR: string;
                    NATIVE_CONTROL_SELECTOR: string;
                    OUTLINE_SELECTOR: string;
                    SELECTED_ITEM_SELECTOR: string;
                    SELECTED_TEXT_SELECTOR: string;
            };
            /**
                * See {@link MDCSelectAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCSelectAdapter;
            /**
                * @param adapter
                * @param foundationMap Map from subcomponent names to their subfoundations.
                */
            constructor(adapter?: Partial<MDCSelectAdapter>, foundationMap?: Partial<MDCSelectFoundationMap>);
            setSelectedIndex(index: number): void;
            setValue(value: string): void;
            getValue(): string;
            setDisabled(isDisabled: boolean): void;
            /**
                * @param content Sets the content of the helper text.
                */
            setHelperTextContent(content: string): void;
            layout(): void;
            handleMenuOpened(): void;
            handleMenuClosed(): void;
            /**
                * Handles value changes, via change event or programmatic updates.
                */
            handleChange(didChange?: boolean): void;
            /**
                * Handles focus events from select element.
                */
            handleFocus(): void;
            /**
                * Handles blur events from select element.
                */
            handleBlur(): void;
            handleClick(normalizedX: number): void;
            handleKeydown(event: KeyboardEvent): void;
            /**
                * Opens/closes the notched outline.
                */
            notchOutline(openNotch: boolean): void;
            /**
                * Sets the aria label of the leading icon.
                */
            setLeadingIconAriaLabel(label: string): void;
            /**
                * Sets the text content of the leading icon.
                */
            setLeadingIconContent(content: string): void;
            setValid(isValid: boolean): void;
            isValid(): boolean;
    }
    export default MDCSelectFoundation;
}

declare module '@material/select/types' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCSelectHelperTextFoundation } from '@material/select/helper-text/foundation';
    import { MDCSelectIconFoundation } from '@material/select/icon/foundation';
    export interface MDCSelectFoundationMap {
        leadingIcon: MDCSelectIconFoundation;
        helperText: MDCSelectHelperTextFoundation;
    }
    export interface MDCSelectEventDetail {
        value: string;
        index: number;
    }
    export interface MDCSelectEvent extends Event {
        readonly detail: MDCSelectEventDetail;
    }
}

declare module '@material/select/helper-text/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/helper-text/adapter';
    export * from '@material/select/helper-text/component';
    export * from '@material/select/helper-text/foundation';
    export { cssClasses as helperTextCssClasses, strings as helperTextStrings } from '@material/select/helper-text/constants';
}

declare module '@material/select/icon/index' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/select/icon/adapter';
    export * from '@material/select/icon/component';
    export * from '@material/select/icon/foundation';
    export { strings as iconStrings } from '@material/select/icon/constants';
}

declare module '@material/select/helper-text/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCSelectHelperTextFoundation } from '@material/select/helper-text/foundation';
    export type MDCSelectHelperTextFactory = (el: Element, foundation?: MDCSelectHelperTextFoundation) => MDCSelectHelperText;
    export class MDCSelectHelperText extends MDCComponent<MDCSelectHelperTextFoundation> {
        static attachTo(root: Element): MDCSelectHelperText;
        readonly foundation: MDCSelectHelperTextFoundation;
        getDefaultFoundation(): MDCSelectHelperTextFoundation;
    }
}

declare module '@material/select/icon/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCSelectIconFoundation } from '@material/select/icon/foundation';
    export type MDCSelectIconFactory = (el: Element, foundation?: MDCSelectIconFoundation) => MDCSelectIcon;
    export class MDCSelectIcon extends MDCComponent<MDCSelectIconFoundation> {
        static attachTo(root: Element): MDCSelectIcon;
        readonly foundation: MDCSelectIconFoundation;
        getDefaultFoundation(): MDCSelectIconFoundation;
    }
}

declare module '@material/select/helper-text/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectHelperTextAdapter } from '@material/select/helper-text/adapter';
    export class MDCSelectHelperTextFoundation extends MDCFoundation<MDCSelectHelperTextAdapter> {
            static readonly cssClasses: {
                    HELPER_TEXT_PERSISTENT: string;
                    HELPER_TEXT_VALIDATION_MSG: string;
            };
            static readonly strings: {
                    ARIA_HIDDEN: string;
                    ROLE: string;
            };
            /**
                * See {@link MDCSelectHelperTextAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCSelectHelperTextAdapter;
            constructor(adapter?: Partial<MDCSelectHelperTextAdapter>);
            /**
                * Sets the content of the helper text field.
                */
            setContent(content: string): void;
            /**
                *  Sets the persistency of the helper text.
                */
            setPersistent(isPersistent: boolean): void;
            /**
                * @param isValidation True to make the helper text act as an error validation message.
                */
            setValidation(isValidation: boolean): void;
            /**
                * Makes the helper text visible to screen readers.
                */
            showToScreenReader(): void;
            /**
                * Sets the validity of the helper text based on the select validity.
                */
            setValidity(selectIsValid: boolean): void;
    }
    export default MDCSelectHelperTextFoundation;
}

declare module '@material/select/icon/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSelectIconAdapter } from '@material/select/icon/adapter';
    export class MDCSelectIconFoundation extends MDCFoundation<MDCSelectIconAdapter> {
            static readonly strings: {
                    ICON_EVENT: string;
                    ICON_ROLE: string;
            };
            /**
                * See {@link MDCSelectIconAdapter} for typing information on parameters and return types.
                */
            static readonly defaultAdapter: MDCSelectIconAdapter;
            constructor(adapter?: Partial<MDCSelectIconAdapter>);
            init(): void;
            destroy(): void;
            setDisabled(disabled: boolean): void;
            setAriaLabel(label: string): void;
            setContent(content: string): void;
            handleInteraction(evt: MouseEvent | KeyboardEvent): void;
    }
    export default MDCSelectIconFoundation;
}

declare module '@material/select/helper-text/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectHelperTextAdapter {
            /**
                * Adds a class to the helper text element.
                */
            addClass(className: string): void;
            /**
                * Removes a class from the helper text element.
                */
            removeClass(className: string): void;
            /**
                * Returns whether or not the helper text element contains the given class.
                */
            hasClass(className: string): boolean;
            /**
                * Sets an attribute with a given value on the helper text element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the helper text element.
                */
            removeAttr(attr: string): void;
            /**
                * Sets the text content for the helper text element.
                */
            setContent(content: string): void;
    }
}

declare module '@material/select/helper-text/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const strings: {
        ARIA_HIDDEN: string;
        ROLE: string;
    };
    const cssClasses: {
        HELPER_TEXT_PERSISTENT: string;
        HELPER_TEXT_VALIDATION_MSG: string;
    };
    export { strings, cssClasses };
}

declare module '@material/select/icon/adapter' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { EventType, SpecificEventListener } from '@material/base/types';
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSelectIconAdapter {
            /**
                * Gets the value of an attribute on the icon element.
                */
            getAttr(attr: string): string | null;
            /**
                * Sets an attribute on the icon element.
                */
            setAttr(attr: string, value: string): void;
            /**
                * Removes an attribute from the icon element.
                */
            removeAttr(attr: string): void;
            /**
                * Sets the text content of the icon element.
                */
            setContent(content: string): void;
            /**
                * Registers an event listener on the icon element for a given event.
                */
            registerInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Deregisters an event listener on the icon element for a given event.
                */
            deregisterInteractionHandler<K extends EventType>(evtType: K, handler: SpecificEventListener<K>): void;
            /**
                * Emits a custom event "MDCSelect:icon" denoting a user has clicked the icon.
                */
            notifyIconAction(): void;
    }
}

declare module '@material/select/icon/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const strings: {
        ICON_EVENT: string;
        ICON_ROLE: string;
    };
    export { strings };
}

