// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/ripple/adapter
//   ../../@material/ripple/component
//   ../../@material/ripple/foundation
//   ../../@material/ripple/types
//   ../../@material/base/observer-foundation
//   ../../@material/base/foundation

declare module '@material/switch' {
    /**
      * @license
      * Copyright 2021 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import * as deprecated from '@material/switch/deprecated';
    export { deprecated };
    export * from '@material/switch/adapter';
    export * from '@material/switch/component';
    export * from '@material/switch/constants';
    export * from '@material/switch/foundation';
}

declare module '@material/switch/deprecated' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    export * from '@material/switch/deprecated/adapter';
    export * from '@material/switch/deprecated/component';
    export * from '@material/switch/deprecated/constants';
    export * from '@material/switch/deprecated/foundation';
}

declare module '@material/switch/adapter' {
    /**
        * @license
        * Copyright 2021 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { CssClasses } from '@material/switch/constants';
    /**
        * The state of the switch.
        */
    export interface MDCSwitchState {
            /**
                * Indicates whether or not the switch is disabled.
                */
            disabled: boolean;
            /**
                * Indicates whether or not the switch is processing and showing a loading
                * indicator. A disabled switch cannot be processing.
                */
            processing: boolean;
            /**
                * If true, the switch is on. If false, the switch is off.
                */
            selected: boolean;
    }
    /**
        * Defines the shape of the adapter expected by the foundation.
        *
        * This adapter is used to delegate state-only updates from the foundation
        * to the component. It does not delegate DOM or rendering logic, such as adding
        * or removing classes.
        */
    export interface MDCSwitchAdapter {
            /**
                * The state of the component.
                */
            state: MDCSwitchState;
    }
    /**
        * Defines the shape of the adapter expected by the rendering foundation.
        *
        * This adapter is used to delegate state and rendering logic updates from the
        * rendering foundation to the component.
        */
    export interface MDCSwitchRenderAdapter extends MDCSwitchAdapter {
            /**
                * Adds a class to the root element.
                * @param className The class to add.
                */
            addClass(className: CssClasses): void;
            /**
                * Returns whether or not the root element has a class.
                * @param className The class to check.
                * @return true if the root element has the class, or false if not.
                */
            hasClass(className: CssClasses): boolean;
            /**
                * Checks if the root element is disabled.
                * @return true if the root element is disabled, or false if not.
                */
            isDisabled(): boolean;
            /**
                * Removes a class from the root element.
                * @param className The class to remove.
                */
            removeClass(className: CssClasses): void;
            /**
                * Sets the `aria-checked` attribute of the root element.
                * @param ariaChecked The value of the attribute to set.
                */
            setAriaChecked(ariaChecked: string): void;
            /**
                * Disables or enables the root element.
                * @param disabled True to disable the root element, or false to enable.
                */
            setDisabled(disabled: boolean): void;
    }
}

declare module '@material/switch/component' {
    /**
        * @license
        * Copyright 2021 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCRippleAdapter } from '@material/ripple/adapter';
    import { MDCRipple } from '@material/ripple/component';
    import { MDCRippleFoundation } from '@material/ripple/foundation';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCSwitchRenderAdapter, MDCSwitchState } from '@material/switch/adapter';
    import { MDCSwitchRenderFoundation } from '@material/switch/foundation';
    /**
        * `MDCSwitch` provides a component implementation of a Material Design switch.
        */
    export class MDCSwitch extends MDCComponent<MDCSwitchRenderFoundation> implements MDCSwitchState, MDCRippleCapableSurface {
            root: HTMLButtonElement;
            /**
                * Creates a new `MDCSwitch` and attaches it to the given root element.
                * @param root The root to attach to.
                * @return the new component instance.
                */
            static attachTo(root: HTMLButtonElement): MDCSwitch;
            disabled: boolean;
            processing: boolean;
            selected: boolean;
            ripple: MDCRipple;
            constructor(root: HTMLButtonElement, foundation?: MDCSwitchRenderFoundation);
            initialize(): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCSwitchRenderFoundation;
            protected createAdapter(): MDCSwitchRenderAdapter;
            protected createRippleFoundation(): MDCRippleFoundation;
            protected createRippleAdapter(): MDCRippleAdapter;
    }
}

declare module '@material/switch/constants' {
    /**
        * CSS classes used for switch.
        */
    export enum CssClasses {
            PROCESSING = "mdc-switch--processing",
            SELECTED = "mdc-switch--selected",
            UNSELECTED = "mdc-switch--unselected"
    }
    /**
        * Query selectors used for switch.
        */
    export enum Selectors {
            RIPPLE = ".mdc-switch__ripple"
    }
}

declare module '@material/switch/foundation' {
    /**
        * @license
        * Copyright 2021 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCObserverFoundation } from '@material/base/observer-foundation';
    import { MDCSwitchAdapter, MDCSwitchRenderAdapter } from '@material/switch/adapter';
    /**
        * `MDCSwitchFoundation` provides a state-only foundation for a switch
        * component.
        *
        * State observers and event handler entrypoints update a component's adapter's
        * state with the logic needed for switch to function.
        */
    export class MDCSwitchFoundation extends MDCObserverFoundation<MDCSwitchAdapter> {
            constructor(adapter: MDCSwitchAdapter);
            /**
                * Initializes the foundation and starts observing state changes.
                */
            init(): void;
            /**
                * Event handler for switch click events. Clicking on a switch will toggle its
                * selected state.
                */
            handleClick(): void;
            protected stopProcessingIfDisabled(): void;
    }
    /**
        * `MDCSwitchRenderFoundation` provides a state and rendering foundation for a
        * switch component.
        *
        * State observers and event handler entrypoints update a component's
        * adapter's state with the logic needed for switch to function.
        *
        * In response to state changes, the rendering foundation uses the component's
        * render adapter to keep the component's DOM updated with the state.
        */
    export class MDCSwitchRenderFoundation extends MDCSwitchFoundation {
            protected adapter: MDCSwitchRenderAdapter;
            /**
                * Initializes the foundation and starts observing state changes.
                */
            init(): void;
            /**
                * Initializes the foundation from a server side rendered (SSR) component.
                * This will sync the adapter's state with the current state of the DOM.
                *
                * This method should be called after `init()`.
                */
            initFromDOM(): void;
            protected onDisabledChange(): void;
            protected onProcessingChange(): void;
            protected onSelectedChange(): void;
    }
}

declare module '@material/switch/deprecated/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCSwitchAdapter {
            /**
                * Adds a CSS class to the root element.
                */
            addClass(className: string): void;
            /**
                * Removes a CSS class from the root element.
                */
            removeClass(className: string): void;
            /**
                * Sets checked state of the native HTML control underlying the switch.
                */
            setNativeControlChecked(checked: boolean): void;
            /**
                * Sets the disabled state of the native HTML control underlying the switch.
                */
            setNativeControlDisabled(disabled: boolean): void;
            /**
                * Sets an attribute value of the native HTML control underlying the switch.
                */
            setNativeControlAttr(attr: string, value: string): void;
    }
}

declare module '@material/switch/deprecated/component' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCComponent } from '@material/base/component';
    import { MDCRipple } from '@material/ripple/component';
    import { MDCRippleCapableSurface } from '@material/ripple/types';
    import { MDCSwitchFoundation } from '@material/switch/deprecated/foundation';
    export class MDCSwitch extends MDCComponent<MDCSwitchFoundation> implements MDCRippleCapableSurface {
        static attachTo(root: HTMLElement): MDCSwitch;
        destroy(): void;
        initialSyncWithDOM(): void;
        getDefaultFoundation(): MDCSwitchFoundation;
        get ripple(): MDCRipple;
        get checked(): boolean;
        set checked(checked: boolean);
        get disabled(): boolean;
        set disabled(disabled: boolean);
    }
}

declare module '@material/switch/deprecated/constants' {
    /** CSS classes used by the switch. */
    const cssClasses: {
        /** Class used for a switch that is in the "checked" (on) position. */
        CHECKED: string;
        /** Class used for a switch that is disabled. */
        DISABLED: string;
    };
    /** String constants used by the switch. */
    const strings: {
        /** Aria attribute for checked or unchecked state of switch */
        ARIA_CHECKED_ATTR: string;
        /** A CSS selector used to locate the native HTML control for the switch.  */
        NATIVE_CONTROL_SELECTOR: string;
        /** A CSS selector used to locate the ripple surface element for the switch. */
        RIPPLE_SURFACE_SELECTOR: string;
    };
    export { cssClasses, strings };
}

declare module '@material/switch/deprecated/foundation' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCSwitchAdapter } from '@material/switch/deprecated/adapter';
    export class MDCSwitchFoundation extends MDCFoundation<MDCSwitchAdapter> {
        /** The string constants used by the switch. */
        static get strings(): {
            ARIA_CHECKED_ATTR: string;
            NATIVE_CONTROL_SELECTOR: string;
            RIPPLE_SURFACE_SELECTOR: string;
        };
        /** The CSS classes used by the switch. */
        static get cssClasses(): {
            CHECKED: string;
            DISABLED: string;
        };
        /** The default Adapter for the switch. */
        static get defaultAdapter(): MDCSwitchAdapter;
        constructor(adapter?: Partial<MDCSwitchAdapter>);
        /** Sets the checked state of the switch. */
        setChecked(checked: boolean): void;
        /** Sets the disabled state of the switch. */
        setDisabled(disabled: boolean): void;
        /** Handles the change event for the switch native control. */
        handleChange(evt: Event): void;
    }
    export default MDCSwitchFoundation;
}

