// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../@material/base/component
//   ../../@material/base/foundation

declare module '@material/tab-scroller' {
    /**
      * @license
      * Copyright 2019 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    import * as util from '@material/tab-scroller/util';
    export { util };
    export * from '@material/tab-scroller/adapter';
    export * from '@material/tab-scroller/component';
    export * from '@material/tab-scroller/constants';
    export * from '@material/tab-scroller/foundation';
    export * from '@material/tab-scroller/types';
}

declare module '@material/tab-scroller/util' {
    /**
        * Computes the height of browser-rendered horizontal scrollbars using a self-created test element.
        * May return 0 (e.g. on OS X browsers under default configuration).
        */
    export function computeHorizontalScrollbarHeight(documentObj: Document, shouldCacheResult?: boolean): number;
}

declare module '@material/tab-scroller/adapter' {
    /**
        * Defines the shape of the adapter expected by the foundation.
        * Implement this adapter for your framework of choice to delegate updates to
        * the component in your framework of choice. See architecture documentation
        * for more details.
        * https://github.com/material-components/material-components-web/blob/master/docs/code/architecture.md
        */
    export interface MDCTabScrollerAdapter {
            /**
                * Adds the given className to the root element.
                * @param className The className to add
                */
            addClass(className: string): void;
            /**
                * Removes the given className from the root element.
                * @param className The className to remove
                */
            removeClass(className: string): void;
            /**
                * Adds the given className to the scroll area element.
                * @param className The className to add
                */
            addScrollAreaClass(className: string): void;
            /**
                * Returns whether the event target matches given className.
                * @param evtTarget The event target
                * @param selector The selector to check
                */
            eventTargetMatchesSelector(evtTarget: EventTarget, selector: string): boolean;
            /**
                * Sets a style property of the area element to the passed value.
                * @param propName The style property name to set
                * @param value The style property value
                */
            setScrollAreaStyleProperty(propName: string, value: string): void;
            /**
                * Sets a style property of the content element to the passed value.
                * @param propName The style property name to set
                * @param value The style property value
                */
            setScrollContentStyleProperty(propName: string, value: string): void;
            /**
                * Returns the scroll content element's computed style value of the given css property `propertyName`.
                * We achieve this via `getComputedStyle(...).getPropertyValue(propertyName)`.
                */
            getScrollContentStyleValue(propertyName: string): string;
            /**
                * Sets the scrollLeft value of the scroll area element to the passed value.
                * @param scrollLeft The new scrollLeft value
                */
            setScrollAreaScrollLeft(scrollLeft: number): void;
            /**
                * Returns the scrollLeft value of the scroll area element.
                */
            getScrollAreaScrollLeft(): number;
            /**
                * Returns the offsetWidth of the scroll content element.
                */
            getScrollContentOffsetWidth(): number;
            /**
                * Returns the offsetWitdth of the scroll area element.
                */
            getScrollAreaOffsetWidth(): number;
            /**
                * Returns the bounding client rect of the scroll area element.
                */
            computeScrollAreaClientRect(): ClientRect;
            /**
                * Returns the bounding client rect of the scroll content element.
                */
            computeScrollContentClientRect(): ClientRect;
            /**
                * Returns the height of the browser's horizontal scrollbars (in px).
                */
            computeHorizontalScrollbarHeight(): number;
    }
}

declare module '@material/tab-scroller/component' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCComponent } from '@material/base/component';
    import { MDCTabScrollerFoundation } from '@material/tab-scroller/foundation';
    export type MDCTabScrollerFactory = (el: Element, foundation?: MDCTabScrollerFoundation) => MDCTabScroller;
    export class MDCTabScroller extends MDCComponent<MDCTabScrollerFoundation> {
            static attachTo(root: Element): MDCTabScroller;
            initialize(): void;
            initialSyncWithDOM(): void;
            destroy(): void;
            getDefaultFoundation(): MDCTabScrollerFoundation;
            /**
                * Returns the current visual scroll position
                */
            getScrollPosition(): number;
            /**
                * Returns the width of the scroll content
                */
            getScrollContentWidth(): number;
            /**
                * Increments the scroll value by the given amount
                * @param scrollXIncrement The pixel value by which to increment the scroll value
                */
            incrementScroll(scrollXIncrement: number): void;
            /**
                * Scrolls to the given pixel position
                * @param scrollX The pixel value to scroll to
                */
            scrollTo(scrollX: number): void;
    }
}

declare module '@material/tab-scroller/constants' {
    /**
      * @license
      * Copyright 2018 Google Inc.
      *
      * Permission is hereby granted, free of charge, to any person obtaining a copy
      * of this software and associated documentation files (the "Software"), to deal
      * in the Software without restriction, including without limitation the rights
      * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
      * copies of the Software, and to permit persons to whom the Software is
      * furnished to do so, subject to the following conditions:
      *
      * The above copyright notice and this permission notice shall be included in
      * all copies or substantial portions of the Software.
      *
      * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
      * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
      * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
      * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
      * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
      * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
      * THE SOFTWARE.
      */
    const cssClasses: {
        ANIMATING: string;
        SCROLL_AREA_SCROLL: string;
        SCROLL_TEST: string;
    };
    const strings: {
        AREA_SELECTOR: string;
        CONTENT_SELECTOR: string;
    };
    export { cssClasses, strings, };
}

declare module '@material/tab-scroller/foundation' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCFoundation } from '@material/base/foundation';
    import { MDCTabScrollerAdapter } from '@material/tab-scroller/adapter';
    import { MDCTabScrollerRTL } from '@material/tab-scroller/rtl-scroller';
    export class MDCTabScrollerFoundation extends MDCFoundation<MDCTabScrollerAdapter> {
            static readonly cssClasses: {
                    ANIMATING: string;
                    SCROLL_AREA_SCROLL: string;
                    SCROLL_TEST: string;
            };
            static readonly strings: {
                    AREA_SELECTOR: string;
                    CONTENT_SELECTOR: string;
            };
            static readonly defaultAdapter: MDCTabScrollerAdapter;
            constructor(adapter?: Partial<MDCTabScrollerAdapter>);
            init(): void;
            /**
                * Computes the current visual scroll position
                */
            getScrollPosition(): number;
            /**
                * Handles interaction events that occur during transition
                */
            handleInteraction(): void;
            /**
                * Handles the transitionend event
                */
            handleTransitionEnd(evt: Event): void;
            /**
                * Increment the scroll value by the scrollXIncrement using animation.
                * @param scrollXIncrement The value by which to increment the scroll position
                */
            incrementScroll(scrollXIncrement: number): void;
            /**
                * Increment the scroll value by the scrollXIncrement without animation.
                * @param scrollXIncrement The value by which to increment the scroll position
                */
            incrementScrollImmediate(scrollXIncrement: number): void;
            /**
                * Scrolls to the given scrollX value
                */
            scrollTo(scrollX: number): void;
            /**
                * @return Browser-specific {@link MDCTabScrollerRTL} instance.
                */
            getRTLScroller(): MDCTabScrollerRTL;
    }
    export default MDCTabScrollerFoundation;
}

declare module '@material/tab-scroller/types' {
    /**
        * MDCTabScrollerAnimation contains the values required for animating from the
        * current scroll position to the new scroll position. The "finalScrollPosition"
        * value represents the new scroll position while the "scrollDelta" value is the
        * corresponding transformation that is applied to the scroll content. Together,
        * they create the animation by first updating the scroll value then applying
        * the transformation and animating the transition. Both pieces are necessary
        * for the scroll animation to work. The values are used as-is by the tab
        * scroller animation method, ensuring that all logic for determining scroll
        * position or transformation is abstracted away from the animation method.
        */
    export interface MDCTabScrollerAnimation {
            finalScrollPosition: number;
            scrollDelta: number;
    }
    /**
        * MDCTabScrollerHorizontalEdges represents the left and right edges of the
        * scroll content. These values vary depending on how scrolling in RTL is
        * implemented by the browser. One value is always 0 and one value is always
        * the max scrollable value as either a positive or negative integer.
        */
    export interface MDCTabScrollerHorizontalEdges {
            left: number;
            right: number;
    }
}

declare module '@material/tab-scroller/rtl-scroller' {
    /**
        * @license
        * Copyright 2018 Google Inc.
        *
        * Permission is hereby granted, free of charge, to any person obtaining a copy
        * of this software and associated documentation files (the "Software"), to deal
        * in the Software without restriction, including without limitation the rights
        * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
        * copies of the Software, and to permit persons to whom the Software is
        * furnished to do so, subject to the following conditions:
        *
        * The above copyright notice and this permission notice shall be included in
        * all copies or substantial portions of the Software.
        *
        * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
        * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
        * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
        * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
        * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
        * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
        * THE SOFTWARE.
        */
    import { MDCTabScrollerAdapter } from '@material/tab-scroller/adapter';
    import { MDCTabScrollerAnimation } from '@material/tab-scroller/types';
    export abstract class MDCTabScrollerRTL {
            protected readonly adapter_: MDCTabScrollerAdapter;
            constructor(adapter: MDCTabScrollerAdapter);
            abstract getScrollPositionRTL(translateX: number): number;
            abstract scrollToRTL(scrollX: number): MDCTabScrollerAnimation;
            abstract incrementScrollRTL(scrollX: number): MDCTabScrollerAnimation;
            /**
                * @param scrollX The current scrollX position
                * @param translateX The current translateX position
                */
            abstract getAnimatingScrollPosition(scrollX: number, translateX: number): number;
    }
    export default MDCTabScrollerRTL;
}

