/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import * as tslib_1 from "tslib";
import { getCorrectPropertyName } from '@material/animation/util';
import { MDCComponent } from '@material/base/component';
import { MDCTabBar } from '../tab-bar/component';
import { MDCTabBarScrollerFoundation } from './foundation';
var MDCTabBarScroller = /** @class */ (function (_super) {
    tslib_1.__extends(MDCTabBarScroller, _super);
    function MDCTabBarScroller() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCTabBarScroller.attachTo = function (root) {
        return new MDCTabBarScroller(root);
    };
    Object.defineProperty(MDCTabBarScroller.prototype, "tabBar", {
        get: function () {
            return this.tabBar_;
        },
        enumerable: true,
        configurable: true
    });
    MDCTabBarScroller.prototype.initialize = function (tabBarFactory) {
        if (tabBarFactory === void 0) { tabBarFactory = function (el) { return new MDCTabBar(el); }; }
        this.scrollFrame_ =
            this.root_.querySelector(MDCTabBarScrollerFoundation.strings.FRAME_SELECTOR);
        this.tabBarEl_ =
            this.root_.querySelector(MDCTabBarScrollerFoundation.strings.TABS_SELECTOR);
        this.forwardIndicator_ =
            this.root_.querySelector(MDCTabBarScrollerFoundation.strings.INDICATOR_FORWARD_SELECTOR);
        this.backIndicator_ =
            this.root_.querySelector(MDCTabBarScrollerFoundation.strings.INDICATOR_BACK_SELECTOR);
        this.tabBar_ = tabBarFactory(this.tabBarEl_);
    };
    MDCTabBarScroller.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) { return _this.root_.classList.add(className); },
            removeClass: function (className) { return _this.root_.classList.remove(className); },
            eventTargetHasClass: function (target, className) { return target.classList.contains(className); },
            addClassToForwardIndicator: function (className) { return _this.forwardIndicator_.classList.add(className); },
            removeClassFromForwardIndicator: function (className) { return _this.forwardIndicator_.classList.remove(className); },
            addClassToBackIndicator: function (className) { return _this.backIndicator_.classList.add(className); },
            removeClassFromBackIndicator: function (className) { return _this.backIndicator_.classList.remove(className); },
            isRTL: function () { return getComputedStyle(_this.root_).getPropertyValue('direction') === 'rtl'; },
            registerBackIndicatorClickHandler: function (handler) { return _this.backIndicator_.addEventListener('click', handler); },
            deregisterBackIndicatorClickHandler: function (handler) { return _this.backIndicator_.removeEventListener('click', handler); },
            registerForwardIndicatorClickHandler: function (handler) { return _this.forwardIndicator_.addEventListener('click', handler); },
            deregisterForwardIndicatorClickHandler: function (handler) { return _this.forwardIndicator_.removeEventListener('click', handler); },
            registerCapturedInteractionHandler: function (evt, handler) { return _this.root_.addEventListener(evt, handler, true); },
            deregisterCapturedInteractionHandler: function (evt, handler) { return _this.root_.removeEventListener(evt, handler, true); },
            registerWindowResizeHandler: function (handler) { return window.addEventListener('resize', handler); },
            deregisterWindowResizeHandler: function (handler) { return window.removeEventListener('resize', handler); },
            getNumberOfTabs: function () { return _this.tabBar.tabs.length; },
            getComputedWidthForTabAtIndex: function (index) { return _this.tabBar.tabs[index].computedWidth; },
            getComputedLeftForTabAtIndex: function (index) { return _this.tabBar.tabs[index].computedLeft; },
            getOffsetWidthForScrollFrame: function () { return _this.scrollFrame_.offsetWidth; },
            getScrollLeftForScrollFrame: function () { return _this.scrollFrame_.scrollLeft; },
            setScrollLeftForScrollFrame: function (scrollLeftAmount) { return _this.scrollFrame_.scrollLeft = scrollLeftAmount; },
            getOffsetWidthForTabBar: function () { return _this.tabBarEl_.offsetWidth; },
            setTransformStyleForTabBar: function (value) {
                _this.tabBarEl_.style.setProperty(getCorrectPropertyName(window, 'transform'), value);
            },
            getOffsetLeftForEventTarget: function (target) { return target.offsetLeft; },
            getOffsetWidthForEventTarget: function (target) { return target.offsetWidth; },
        };
        // tslint:enable:object-literal-sort-keys
        return new MDCTabBarScrollerFoundation(adapter);
    };
    MDCTabBarScroller.prototype.layout = function () {
        this.foundation_.layout();
    };
    return MDCTabBarScroller;
}(MDCComponent));
export { MDCTabBarScroller };
//# sourceMappingURL=component.js.map