/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import { MDCFoundation } from '@material/base/foundation';
import { MDCTabBarScrollerAdapter } from './adapter';
export declare class MDCTabBarScrollerFoundation extends MDCFoundation<MDCTabBarScrollerAdapter> {
    static readonly cssClasses: {
        INDICATOR_BACK: string;
        INDICATOR_ENABLED: string;
        INDICATOR_FORWARD: string;
        TAB: string;
    };
    static readonly strings: {
        FRAME_SELECTOR: string;
        INDICATOR_BACK_SELECTOR: string;
        INDICATOR_FORWARD_SELECTOR: string;
        TABS_SELECTOR: string;
        TAB_SELECTOR: string;
    };
    static readonly defaultAdapter: MDCTabBarScrollerAdapter;
    private pointerDownRecognized_;
    private currentTranslateOffset_;
    private focusedTarget_;
    private layoutFrame_;
    private scrollFrameScrollLeft_;
    private readonly forwardIndicatorClickHandler_;
    private readonly backIndicatorClickHandler_;
    private readonly resizeHandler_;
    private readonly interactionHandler_;
    constructor(adapter?: Partial<MDCTabBarScrollerAdapter>);
    init(): void;
    destroy(): void;
    scrollBack(evt?: MouseEvent): void;
    scrollForward(evt?: MouseEvent): void;
    layout(): void;
    scrollToTabAtIndex(index: number): void;
    private layout_;
    private shiftFrame_;
    private handlePossibleTabKeyboardFocus_;
    private updateIndicatorEnabledStates_;
    private normalizeForRTL_;
    private isRTL_;
}
export default MDCTabBarScrollerFoundation;
