/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import * as tslib_1 from "tslib";
import { MDCComponent } from '@material/base/component';
import { MDCTab } from '../tab/component';
import { MDCTabFoundation } from '../tab/foundation';
import { MDCTabBarFoundation } from './foundation';
var strings = MDCTabBarFoundation.strings;
var MDCTabBar = /** @class */ (function (_super) {
    tslib_1.__extends(MDCTabBar, _super);
    function MDCTabBar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCTabBar.attachTo = function (root) {
        return new MDCTabBar(root);
    };
    Object.defineProperty(MDCTabBar.prototype, "tabs", {
        get: function () {
            return this.tabs_;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabBar.prototype, "activeTab", {
        get: function () {
            var activeIndex = this.foundation_.getActiveTabIndex();
            return this.tabs[activeIndex];
        },
        set: function (tab) {
            this.setActiveTab_(tab, false);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabBar.prototype, "activeTabIndex", {
        get: function () {
            return this.foundation_.getActiveTabIndex();
        },
        set: function (index) {
            this.setActiveTabIndex_(index, false);
        },
        enumerable: true,
        configurable: true
    });
    MDCTabBar.prototype.initialize = function (tabFactory) {
        var _this = this;
        if (tabFactory === void 0) { tabFactory = function (el) { return new MDCTab(el); }; }
        this.indicator_ = this.root_.querySelector(strings.INDICATOR_SELECTOR);
        this.tabs_ = this.gatherTabs_(tabFactory);
        this.tabSelectedHandler_ = function (_a) {
            var detail = _a.detail;
            var tab = detail.tab;
            _this.setActiveTab_(tab, true);
        };
    };
    MDCTabBar.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) { return _this.root_.classList.add(className); },
            removeClass: function (className) { return _this.root_.classList.remove(className); },
            bindOnMDCTabSelectedEvent: function () {
                return _this.listen(MDCTabFoundation.strings.SELECTED_EVENT, _this.tabSelectedHandler_);
            },
            unbindOnMDCTabSelectedEvent: function () {
                return _this.unlisten(MDCTabFoundation.strings.SELECTED_EVENT, _this.tabSelectedHandler_);
            },
            registerResizeHandler: function (handler) { return window.addEventListener('resize', handler); },
            deregisterResizeHandler: function (handler) { return window.removeEventListener('resize', handler); },
            getOffsetWidth: function () { return _this.root_.offsetWidth; },
            setStyleForIndicator: function (propertyName, value) { return _this.indicator_.style.setProperty(propertyName, value); },
            getOffsetWidthForIndicator: function () { return _this.indicator_.offsetWidth; },
            notifyChange: function (evtData) { return _this.emit(strings.CHANGE_EVENT, evtData); },
            getNumberOfTabs: function () { return _this.tabs.length; },
            isTabActiveAtIndex: function (index) { return _this.tabs[index].isActive; },
            setTabActiveAtIndex: function (index, isActive) {
                _this.tabs[index].isActive = isActive;
            },
            isDefaultPreventedOnClickForTabAtIndex: function (index) { return _this.tabs[index].preventDefaultOnClick; },
            setPreventDefaultOnClickForTabAtIndex: function (index, preventDefaultOnClick) {
                _this.tabs[index].preventDefaultOnClick = preventDefaultOnClick;
            },
            measureTabAtIndex: function (index) { return _this.tabs[index].measureSelf(); },
            getComputedWidthForTabAtIndex: function (index) { return _this.tabs[index].computedWidth; },
            getComputedLeftForTabAtIndex: function (index) { return _this.tabs[index].computedLeft; },
        };
        // tslint:enable:object-literal-sort-keys
        return new MDCTabBarFoundation(adapter);
    };
    MDCTabBar.prototype.layout = function () {
        this.foundation_.layout();
    };
    MDCTabBar.prototype.gatherTabs_ = function (tabFactory) {
        var tabElements = [].slice.call(this.root_.querySelectorAll(strings.TAB_SELECTOR));
        return tabElements.map(function (el) { return tabFactory(el); });
    };
    MDCTabBar.prototype.setActiveTabIndex_ = function (activeTabIndex, notifyChange) {
        this.foundation_.switchToTabAtIndex(activeTabIndex, notifyChange);
    };
    MDCTabBar.prototype.setActiveTab_ = function (activeTab, notifyChange) {
        var indexOfTab = this.tabs.indexOf(activeTab);
        if (indexOfTab < 0) {
            throw new Error('Invalid tab component given as activeTab: Tab not found within this component\'s tab list');
        }
        this.setActiveTabIndex_(indexOfTab, notifyChange);
    };
    return MDCTabBar;
}(MDCComponent));
export { MDCTabBar };
//# sourceMappingURL=component.js.map