/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import * as tslib_1 from "tslib";
import { getCorrectPropertyName } from '@material/animation/util';
import { MDCFoundation } from '@material/base/foundation';
import { cssClasses, strings } from './constants';
var MDCTabBarFoundation = /** @class */ (function (_super) {
    tslib_1.__extends(MDCTabBarFoundation, _super);
    function MDCTabBarFoundation(adapter) {
        var _this = _super.call(this, tslib_1.__assign({}, MDCTabBarFoundation.defaultAdapter, adapter)) || this;
        _this.isIndicatorShown_ = false;
        _this.activeTabIndex_ = 0;
        _this.layoutFrame_ = 0;
        return _this;
    }
    Object.defineProperty(MDCTabBarFoundation, "cssClasses", {
        get: function () {
            return cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabBarFoundation, "strings", {
        get: function () {
            return strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabBarFoundation, "defaultAdapter", {
        get: function () {
            // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
            return {
                addClass: function () { return undefined; },
                removeClass: function () { return undefined; },
                bindOnMDCTabSelectedEvent: function () { return undefined; },
                unbindOnMDCTabSelectedEvent: function () { return undefined; },
                registerResizeHandler: function () { return undefined; },
                deregisterResizeHandler: function () { return undefined; },
                getOffsetWidth: function () { return 0; },
                setStyleForIndicator: function () { return undefined; },
                getOffsetWidthForIndicator: function () { return 0; },
                notifyChange: function () { return undefined; },
                getNumberOfTabs: function () { return 0; },
                isTabActiveAtIndex: function () { return false; },
                setTabActiveAtIndex: function () { return undefined; },
                isDefaultPreventedOnClickForTabAtIndex: function () { return false; },
                setPreventDefaultOnClickForTabAtIndex: function () { return undefined; },
                measureTabAtIndex: function () { return undefined; },
                getComputedWidthForTabAtIndex: function () { return 0; },
                getComputedLeftForTabAtIndex: function () { return 0; },
            };
            // tslint:enable:object-literal-sort-keys
        },
        enumerable: true,
        configurable: true
    });
    MDCTabBarFoundation.prototype.init = function () {
        var _this = this;
        this.resizeHandler_ = function () { return _this.layout(); };
        this.adapter_.addClass(cssClasses.UPGRADED);
        this.adapter_.bindOnMDCTabSelectedEvent();
        this.adapter_.registerResizeHandler(this.resizeHandler_);
        var activeTabIndex = this.findActiveTabIndex_();
        if (activeTabIndex >= 0) {
            this.activeTabIndex_ = activeTabIndex;
        }
        this.layout();
    };
    MDCTabBarFoundation.prototype.destroy = function () {
        this.adapter_.removeClass(cssClasses.UPGRADED);
        this.adapter_.unbindOnMDCTabSelectedEvent();
        this.adapter_.deregisterResizeHandler(this.resizeHandler_);
    };
    MDCTabBarFoundation.prototype.layout = function () {
        var _this = this;
        if (this.layoutFrame_) {
            cancelAnimationFrame(this.layoutFrame_);
        }
        this.layoutFrame_ = requestAnimationFrame(function () {
            _this.layoutInternal_();
            _this.layoutFrame_ = 0;
        });
    };
    MDCTabBarFoundation.prototype.switchToTabAtIndex = function (index, shouldNotify) {
        var _this = this;
        if (index === this.activeTabIndex_) {
            return;
        }
        if (index < 0 || index >= this.adapter_.getNumberOfTabs()) {
            throw new Error("Out of bounds index specified for tab: " + index);
        }
        var prevActiveTabIndex = this.activeTabIndex_;
        this.activeTabIndex_ = index;
        requestAnimationFrame(function () {
            if (prevActiveTabIndex >= 0) {
                _this.adapter_.setTabActiveAtIndex(prevActiveTabIndex, false);
            }
            _this.adapter_.setTabActiveAtIndex(_this.activeTabIndex_, true);
            _this.layoutIndicator_();
            if (shouldNotify) {
                _this.adapter_.notifyChange({ activeTabIndex: _this.activeTabIndex_ });
            }
        });
    };
    MDCTabBarFoundation.prototype.getActiveTabIndex = function () {
        return this.findActiveTabIndex_();
    };
    MDCTabBarFoundation.prototype.layoutInternal_ = function () {
        var _this = this;
        this.forEachTabIndex_(function (index) { return _this.adapter_.measureTabAtIndex(index); });
        this.layoutIndicator_();
    };
    MDCTabBarFoundation.prototype.layoutIndicator_ = function () {
        var isIndicatorFirstRender = !this.isIndicatorShown_;
        // Ensure that indicator appears in the right position immediately for correct first render.
        if (isIndicatorFirstRender) {
            this.adapter_.setStyleForIndicator('transition', 'none');
        }
        var translateAmtForActiveTabLeft = this.adapter_.getComputedLeftForTabAtIndex(this.activeTabIndex_);
        var scaleAmtForActiveTabWidth = this.adapter_.getComputedWidthForTabAtIndex(this.activeTabIndex_) / this.adapter_.getOffsetWidth();
        var transformValue = "translateX(" + translateAmtForActiveTabLeft + "px) scale(" + scaleAmtForActiveTabWidth + ", 1)";
        this.adapter_.setStyleForIndicator(getCorrectPropertyName(window, 'transform'), transformValue);
        if (isIndicatorFirstRender) {
            // Force layout so that transform styles to take effect.
            this.adapter_.getOffsetWidthForIndicator();
            this.adapter_.setStyleForIndicator('transition', '');
            this.adapter_.setStyleForIndicator('visibility', 'visible');
            this.isIndicatorShown_ = true;
        }
    };
    MDCTabBarFoundation.prototype.findActiveTabIndex_ = function () {
        var _this = this;
        var activeTabIndex = -1;
        this.forEachTabIndex_(function (index) {
            if (_this.adapter_.isTabActiveAtIndex(index)) {
                activeTabIndex = index;
                return true;
            }
        });
        return activeTabIndex;
    };
    MDCTabBarFoundation.prototype.forEachTabIndex_ = function (iterator) {
        var numTabs = this.adapter_.getNumberOfTabs();
        for (var index = 0; index < numTabs; index++) {
            var shouldBreak = iterator(index);
            if (shouldBreak) {
                break;
            }
        }
    };
    return MDCTabBarFoundation;
}(MDCFoundation));
export { MDCTabBarFoundation };
// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
export default MDCTabBarFoundation;
//# sourceMappingURL=foundation.js.map