/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import * as tslib_1 from "tslib";
import { MDCComponent } from '@material/base/component';
import { MDCRipple } from '@material/ripple/component';
import { cssClasses } from './constants';
import { MDCTabFoundation } from './foundation';
var MDCTab = /** @class */ (function (_super) {
    tslib_1.__extends(MDCTab, _super);
    function MDCTab() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.ripple_ = MDCRipple.attachTo(_this.root_);
        return _this;
    }
    MDCTab.attachTo = function (root) {
        return new MDCTab(root);
    };
    Object.defineProperty(MDCTab.prototype, "computedWidth", {
        get: function () {
            return this.foundation_.getComputedWidth();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTab.prototype, "computedLeft", {
        get: function () {
            return this.foundation_.getComputedLeft();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTab.prototype, "isActive", {
        get: function () {
            return this.foundation_.isActive();
        },
        set: function (isActive) {
            this.foundation_.setActive(isActive);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTab.prototype, "preventDefaultOnClick", {
        get: function () {
            return this.foundation_.preventsDefaultOnClick();
        },
        set: function (preventDefaultOnClick) {
            this.foundation_.setPreventDefaultOnClick(preventDefaultOnClick);
        },
        enumerable: true,
        configurable: true
    });
    MDCTab.prototype.destroy = function () {
        this.ripple_.destroy();
        _super.prototype.destroy.call(this);
    };
    MDCTab.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) { return _this.root_.classList.add(className); },
            removeClass: function (className) { return _this.root_.classList.remove(className); },
            registerInteractionHandler: function (type, handler) { return _this.listen(type, handler); },
            deregisterInteractionHandler: function (type, handler) { return _this.unlisten(type, handler); },
            getOffsetWidth: function () { return _this.root_.offsetWidth; },
            getOffsetLeft: function () { return _this.root_.offsetLeft; },
            notifySelected: function () {
                return _this.emit(MDCTabFoundation.strings.SELECTED_EVENT, { tab: _this }, true);
            },
        };
        // tslint:enable:object-literal-sort-keys
        return new MDCTabFoundation(adapter);
    };
    MDCTab.prototype.initialSyncWithDOM = function () {
        this.isActive = this.root_.classList.contains(cssClasses.ACTIVE);
    };
    MDCTab.prototype.measureSelf = function () {
        this.foundation_.measureSelf();
    };
    return MDCTab;
}(MDCComponent));
export { MDCTab };
//# sourceMappingURL=component.js.map