/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
import * as tslib_1 from "tslib";
import { MDCFoundation } from '@material/base/foundation';
import { cssClasses, strings } from './constants';
var MDCTabFoundation = /** @class */ (function (_super) {
    tslib_1.__extends(MDCTabFoundation, _super);
    function MDCTabFoundation(adapter) {
        var _this = _super.call(this, tslib_1.__assign({}, MDCTabFoundation.defaultAdapter, adapter)) || this;
        _this.computedWidth_ = 0;
        _this.computedLeft_ = 0;
        _this.isActive_ = false;
        _this.preventDefaultOnClick_ = false;
        _this.clickHandler_ = function (evt) {
            if (_this.preventDefaultOnClick_) {
                evt.preventDefault();
            }
            _this.adapter_.notifySelected();
        };
        _this.keydownHandler_ = function (evt) {
            if (evt.key === 'Enter' || evt.keyCode === 13) {
                _this.adapter_.notifySelected();
            }
        };
        return _this;
    }
    Object.defineProperty(MDCTabFoundation, "cssClasses", {
        get: function () {
            return cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabFoundation, "strings", {
        get: function () {
            return strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCTabFoundation, "defaultAdapter", {
        get: function () {
            // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
            return {
                addClass: function () { return undefined; },
                removeClass: function () { return undefined; },
                registerInteractionHandler: function () { return undefined; },
                deregisterInteractionHandler: function () { return undefined; },
                getOffsetWidth: function () { return 0; },
                getOffsetLeft: function () { return 0; },
                notifySelected: function () { return undefined; },
            };
            // tslint:enable:object-literal-sort-keys
        },
        enumerable: true,
        configurable: true
    });
    MDCTabFoundation.prototype.init = function () {
        this.adapter_.registerInteractionHandler('click', this.clickHandler_);
        this.adapter_.registerInteractionHandler('keydown', this.keydownHandler_);
    };
    MDCTabFoundation.prototype.destroy = function () {
        this.adapter_.deregisterInteractionHandler('click', this.clickHandler_);
        this.adapter_.deregisterInteractionHandler('keydown', this.keydownHandler_);
    };
    MDCTabFoundation.prototype.getComputedWidth = function () {
        return this.computedWidth_;
    };
    MDCTabFoundation.prototype.getComputedLeft = function () {
        return this.computedLeft_;
    };
    MDCTabFoundation.prototype.isActive = function () {
        return this.isActive_;
    };
    MDCTabFoundation.prototype.setActive = function (isActive) {
        this.isActive_ = isActive;
        if (this.isActive_) {
            this.adapter_.addClass(cssClasses.ACTIVE);
        }
        else {
            this.adapter_.removeClass(cssClasses.ACTIVE);
        }
    };
    MDCTabFoundation.prototype.preventsDefaultOnClick = function () {
        return this.preventDefaultOnClick_;
    };
    MDCTabFoundation.prototype.setPreventDefaultOnClick = function (preventDefaultOnClick) {
        this.preventDefaultOnClick_ = preventDefaultOnClick;
    };
    MDCTabFoundation.prototype.measureSelf = function () {
        this.computedWidth_ = this.adapter_.getOffsetWidth();
        this.computedLeft_ = this.adapter_.getOffsetLeft();
    };
    return MDCTabFoundation;
}(MDCFoundation));
export { MDCTabFoundation };
// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
export default MDCTabFoundation;
//# sourceMappingURL=foundation.js.map